/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.ResourceNode;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.io.RandomAccessFile;
import java.util.Date;

public class PlanImageHuge
extends PlanImage
implements Runnable {
    static final int LIMIT = 4096;
    protected int step;
    protected byte[] pixelsSub;
    protected int ox;
    protected int oy;
    protected int ow;
    protected int oh;
    private boolean restart;
    private boolean lock;
    private Thread thread;
    protected boolean isExtracting;
    private boolean toSubImage;
    private PixelsSub[] vPixelsSub = new PixelsSub[17];
    private int nbPixelsSub = 0;
    private int nextPixelsSub = 0;
    private int _x;
    private int _y;
    private int _w;
    private int _h;
    private byte[] pixelsWork;
    private byte[] buf;

    protected PlanImageHuge(Aladin aladin, String file, MyInputStream in, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, in, label, from, o, imgNode, skip, doClose, forPourcent);
        this.type = 15;
    }

    @Override
    protected boolean isSync() {
        return super.isSync() && !this.isExtracting;
    }

    protected int getStep() {
        return this.step;
    }

    protected boolean fromSubImage(double zoom, int wview, int hview) {
        return (double)(wview * this.step) / zoom < 4096.0 && (double)(hview * this.step) / zoom < 4096.0;
    }

    protected byte[] cropPixels(int x, int y, int w, int h) {
        int xa = (x - this.ox) * this.step;
        int ya = (y - this.oy) * this.step;
        int wa = w * this.step;
        int ha = h * this.step;
        byte[] pixels = new byte[wa * ha];
        this.getPixels(pixels, this.pixelsSub, this.ow * this.step, this.oh * this.step, xa, ya, wa, ha);
        return pixels;
    }

    protected boolean loadSubImage(int x, int y, int w, int h) {
        int gap = 128 / this.step;
        y -= gap;
        w += 2 * gap;
        h += 2 * gap;
        if ((x -= gap) < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if ((x + w) * this.step >= this.naxis1) {
            w = this.naxis1 / this.step - x - 1;
        }
        if ((y + h) * this.step >= this.naxis2) {
            h = this.naxis2 / this.step - y - 1;
        }
        return this.getSubImage(x, y, w, h);
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(10);
        }
    }

    private synchronized boolean getLock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    private synchronized void unlock() {
        this.lock = false;
    }

    protected boolean inSubImage(int x, int y, int w, int h) {
        return this.selectPixelsSub(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPixelsSub(byte[] pixelsSub, int x, int y, int w, int h) {
        PixelsSub[] pixelsSubArray = this.vPixelsSub;
        synchronized (this.vPixelsSub) {
            if (this.nbPixelsSub < this.vPixelsSub.length) {
                this.nextPixelsSub = this.nbPixelsSub++;
            } else {
                this.nextPixelsSub = 0;
                block3: for (int i = 0; i < this.vPixelsSub.length; ++i) {
                    PixelsSub px = this.vPixelsSub[i];
                    for (int j = 0; j < this.aladin.view.getNbView(); ++j) {
                        ViewSimple v = this.aladin.view.viewSimple[j];
                        if (v.isFree() || v.pref != this || !v.flagHuge || px.agree(v.xHuge, v.yHuge, v.wHuge, v.hHuge)) continue;
                        this.nextPixelsSub = j;
                        continue block3;
                    }
                }
            }
            this.vPixelsSub[this.nextPixelsSub] = new PixelsSub(pixelsSub, x, y, w, h);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return this.nextPixelsSub;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPixelSub() {
        PixelsSub[] pixelsSubArray = this.vPixelsSub;
        synchronized (this.vPixelsSub) {
            for (int i = 0; i < this.nbPixelsSub; ++i) {
                this.vPixelsSub[i] = null;
            }
            this.nbPixelsSub = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean selectPixelsSub(int x, int y, int w, int h) {
        PixelsSub[] pixelsSubArray = this.vPixelsSub;
        synchronized (this.vPixelsSub) {
            for (int i = 0; i < this.nbPixelsSub; ++i) {
                PixelsSub px = this.vPixelsSub[i];
                if (!px.agree(x, y, w, h)) continue;
                this.pixelsSub = px.pixels;
                this.ox = px.ox;
                this.oy = px.oy;
                this.ow = px.ow;
                this.oh = px.oh;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return false;
        }
    }

    private boolean getSubImage(int x, int y, int w, int h) {
        if (this.inSubImage(x, y, w, h)) {
            return true;
        }
        this.flagUpdating = true;
        this.aladin.calque.select.repaint();
        this.waitLock();
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        if (this.isExtracting) {
            this.restart = true;
        } else {
            this.toSubImage = true;
            this.thread = new Thread((Runnable)this, "HugeSubImage");
            this.thread.start();
        }
        return false;
    }

    @Override
    public void run() {
        if (!this.toSubImage) {
            super.run();
            return;
        }
        this.toSubImage = false;
        this.isExtracting = true;
        this.aladin.calque.select.repaint();
        this.getSubImageThread();
    }

    private void getSubImageThread() {
        int x = this._x;
        int y = this._y;
        int w = this._w;
        int h = this._h;
        this.ox = x;
        this.oy = y;
        this.ow = w;
        this.oh = h;
        this.restart = false;
        this.unlock();
        long t = System.currentTimeMillis();
        double r = 255.0 / (this.pixelMax - this.pixelMin);
        try {
            int size = w * h * this.step * this.step;
            this.pixelsWork = new byte[size];
            this.buf = new byte[w * this.step * this.nbytes];
            int len = w * this.step;
            int pos = 0;
            for (int i = this.naxis2 - (y + h) * this.step; i < this.naxis2 - y * this.step; ++i) {
                this.fCache.seek(this.cacheOffset + ((long)i * (long)this.naxis1 + (long)(x * this.step)) * (long)this.nbytes);
                this.fCache.readFully(this.buf);
                for (int j = 0; j < len; ++j) {
                    double c = this.getPixVal(this.buf, this.bitpix, j);
                    if (Double.isNaN(c) || this.isBlank && c == this.blank) {
                        this.pixelsWork[pos++] = 0;
                        continue;
                    }
                    this.pixelsWork[pos++] = (byte)(1 + (c <= this.pixelMin ? 0 : (c >= this.pixelMax ? 254 : (int)((c - this.pixelMin) * r))) & 0xFF);
                }
                if (!this.restart) continue;
                this.restart = false;
                this.getSubImageThread();
                return;
            }
            this.isExtracting = false;
            PlanImageHuge.invImageLine(w * this.step, h * this.step, this.pixelsWork);
            this.pixelsSub = this.pixelsWork;
            int n = this.addPixelsSub(this.pixelsSub, this.ox, this.oy, this.ow, this.oh);
            Aladin.trace(3, "getSubImage[" + n + "] from " + this.label + " (" + x * this.step + "," + y * this.step + " " + w * this.step + "x" + h * this.step + ") in " + (System.currentTimeMillis() - t) + "ms");
            this.nextImgID();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.flagUpdating = false;
        this.aladin.view.repaintAll();
    }

    @Override
    public int getPixel8(int x, int y) {
        if (this.inSubImage(x / this.step, y / this.step, 1, 1)) {
            return this.pixelsSub[(y - this.oy * this.step) * this.ow * this.step + (x - this.ox * this.step)] & 0xFF;
        }
        return this.getBufPixels8()[y / this.step * this.width + x / this.step];
    }

    @Override
    protected String getPixelInfo(int x, int y, int mode) {
        if (!this.flagOk || y < 0 || y >= this.naxis2 || x < 0 || x >= this.naxis1) {
            return "";
        }
        switch (mode) {
            case 0: {
                byte b = this.inSubImage(x / this.step, y / this.step, 1, 1) ? this.pixelsSub[(y - this.oy * this.step) * this.ow * this.step + (x - this.ox * this.step)] : this.getBufPixels8()[y / this.step * this.width + x / this.step];
                return Util.align3(b & 0xFF) + " / 255";
            }
            case 2: {
                if (this.onePixelOrigin == null) {
                    this.onePixelOrigin = new byte[this.nbytes];
                }
                if (!this.getOnePixelFromCache(this.onePixelOrigin, this.nbytes, x, y)) {
                    return UNK;
                }
                return this.Y(this.getPixVal(this.onePixelOrigin, this.bitpix, 0));
            }
            case 1: {
                if (this.onePixelOrigin == null) {
                    this.onePixelOrigin = new byte[this.nbytes];
                }
                if (!this.getOnePixelFromCache(this.onePixelOrigin, this.nbytes, x, y)) {
                    return UNK;
                }
                double val = this.getPixVal(this.onePixelOrigin, this.bitpix, 0) * this.bScale + this.bZero;
                if (Aladin.levelTrace < 4) {
                    return this.Y(val);
                }
                double infileVal = PlanImageHuge.getPixVal1(this.onePixelOrigin, this.bitpix, 0);
                return this.Y(val) + (Double.isNaN(infileVal) || val != infileVal ? "(" + infileVal + ")" : "") + (this.isBlank && infileVal == this.blank ? " BLANK" : "");
            }
        }
        return null;
    }

    @Override
    protected boolean recut(double min, double max, boolean autocut) {
        if (min == -1.0 && max == -1.0) {
            min = this.dataMinFits;
            max = this.dataMaxFits;
        }
        this.flagUpdating = true;
        this.flagOk = false;
        this.aladin.calque.select.repaint();
        int xc = 0;
        int yc = 0;
        int wc = 0;
        if (autocut && Projection.isOk(this.projd)) {
            Coord c = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
            this.projd.getXY(c);
            xc = (int)c.x;
            yc = (int)c.y;
            ViewSimple v = this.aladin.view.getCurrentView();
            if (v.pref == this) {
                try {
                    wc = (int)(v.getTaille() / this.projd.getPixResDelta()) / 2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            int w = Math.min(1024, this.width);
            int h = Math.min(1024, this.height);
            int x = this.width / 2 - w / 2;
            int y = this.height / 2 - h / 2;
            if (wc > 0) {
                w = h = Math.min(1024, wc);
                x = xc - w / 2;
                y = yc - w / 2;
            }
            byte[] buf = new byte[w * h * this.nbytes];
            this.getPixelsFromCache(buf, this.nbytes, x, y, w, h);
            this.findMinMax(buf, this.bitpix, w, h, min, max, autocut, 0, 0, 0, 0);
            min = this.pixelMin;
            max = this.pixelMax;
            this.loadHugeImage();
            this.resetPixelSub();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.setPourcent(-1.0);
        this.ow = -1;
        this.flagUpdating = false;
        this.flagOk = true;
        this.resetHist();
        return true;
    }

    private void loadHugeImage() throws Exception {
        byte[] buf = new byte[512];
        long ntaille = (long)this.width * (long)this.height * (long)this.nbytes;
        int pos = 0;
        this.offsetLoad = 0;
        try {
            for (int h = 0; h < this.height; ++h) {
                for (int w = 0; w < this.width; ++w) {
                    this.fCache.seek(this.cacheOffset + ((long)(h * this.step + this.step / 2) * (long)this.naxis1 + (long)(w * this.step + this.step / 2)) * (long)this.nbytes);
                    this.fCache.readFully(buf, pos, this.nbytes);
                    if ((pos += this.nbytes) != buf.length) continue;
                    this.to8bits(this.getBufPixels8(), this.offsetLoad / this.nbytes, buf, pos / this.nbytes, this.bitpix, this.pixelMin, this.pixelMax, true);
                    this.offsetLoad += pos;
                    pos = 0;
                    this.setPourcent((double)this.offsetLoad * 99.0 / (double)ntaille);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pos > 0) {
            this.to8bits(this.getBufPixels8(), this.offsetLoad / this.nbytes, buf, pos / this.nbytes, this.bitpix, this.pixelMin, this.pixelMax, true);
            this.offsetLoad += pos;
            this.setPourcent((double)this.offsetLoad * 99.0 / (double)ntaille);
        }
        PlanImageHuge.invImageLine(this.width, this.height, this.getBufPixels8());
    }

    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int n;
        int naxis = 2;
        Aladin.trace(2, "Loading Huge FITS image");
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        naxis = this.headerFits.getIntFromHeader("NAXIS");
        if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (naxis == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    dis.skip(this.naxis1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("NAXIS2");
        this.nbytes = n = Math.abs(this.bitpix) / 8;
        long taille = (long)this.width * (long)this.height * (long)n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        Date d = new Date();
        if (!this.setCacheFromFile(dis)) {
            Aladin.trace(2, "Dumping huge image in local cache...");
            int len = 512;
            byte[] buffer = new byte[len];
            long offsetLoad = 0L;
            RandomAccessFile f = null;
            try {
                while (offsetLoad < taille) {
                    if (taille - offsetLoad < (long)len) {
                        len = (int)(taille - offsetLoad);
                    }
                    dis.readFully(buffer, 0, len);
                    if (offsetLoad == 0L) {
                        f = this.beginInCache(buffer);
                    } else {
                        f.write(buffer, 0, len);
                    }
                    this.setPourcent((double)(offsetLoad += (long)len) * 85.0 / (double)taille);
                }
                this.fCache = f;
            }
            catch (Exception e) {
                this.error = Aladin.error = "Loading error: " + e.getMessage();
                e.printStackTrace();
                this.close();
                return false;
            }
        }
        this.tailleLoad = taille;
        boolean cut = this.aladin.configuration.getCMCut();
        int w = Math.min(1024, this.width);
        int h = Math.min(1024, this.height);
        int x = this.width / 2 - w / 2;
        int y = this.height / 2 - h / 2;
        byte[] buf = new byte[w * h * this.nbytes];
        this.getPixelsFromCache(buf, this.nbytes, x, y, w, h);
        this.findMinMax(buf, this.bitpix, w, h, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
        int len = 512;
        buf = new byte[len];
        int mx = Math.max(this.width, this.height);
        this.step = 1;
        while (mx / this.step > 2048) {
            this.step *= 2;
        }
        this.width = PlanImageHuge.top((double)this.width / (double)this.step);
        this.height = PlanImageHuge.top((double)this.height / (double)this.step);
        Aladin.trace(3, "Huge image (" + this.naxis1 + "x" + this.naxis2 + ") step=" + this.step + " => (" + this.width + "x" + this.height + ")");
        this.setBufPixels8(new byte[this.width * this.height]);
        this.loadHugeImage();
        if (naxis > 2) {
            try {
                dis.skip(taille);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Reading " + (cut ? "and autocutting " : "") + "in " + Util.round((double)temps / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)temps / 1048.576, 2) + " Mbyte/s");
        this.calculPixelsZoom();
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    class PixelsSub {
        int ox;
        int oy;
        int ow;
        int oh;
        byte[] pixels;

        PixelsSub(byte[] pixelsSub, int x, int y, int w, int h) {
            this.pixels = pixelsSub;
            this.ox = x;
            this.oy = y;
            this.ow = w;
            this.oh = h;
        }

        boolean agree(int x, int y, int w, int h) {
            return x >= this.ox && y >= this.oy && x + w <= this.ox + this.ow && y + h <= this.oy + this.oh;
        }
    }
}

