/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImageCube;
import cds.aladin.ResourceNode;
import cds.fits.Fits;

public class PlanImageCubeCmp
extends PlanImageCube {
    protected PlanImageCubeCmp(Aladin aladin, String file, MyInputStream in, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, in, label, from, o, imgNode, skip, doClose, forPourcent);
    }

    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int n;
        Aladin.trace(2, "Loading FITS cmp " + TYPE[this.type]);
        this.setPourcent(0.0);
        Fits fits = new Fits();
        fits.loadFITS(dis);
        if (this.flagSkip) {
            return true;
        }
        this.headerFits = new FrameHeaderFits(fits.headerFits);
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        this.setPixMode(2);
        this.nbytes = n = Math.abs(this.bitpix) / 8;
        long taille = (long)this.width * (long)this.height * (long)this.depth * (long)n;
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + this.depth + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        this.cacheFromOriginalFile = false;
        try {
            this.crpix3 = this.headerFits.getDoubleFromHeader("CRPIX3");
            this.crval3 = this.headerFits.getDoubleFromHeader("CRVAL3");
            this.cdelt3 = this.headerFits.getDoubleFromHeader("CDELT3");
            this.cunit3 = this.headerFits.getStringFromHeader("CUNIT3");
            this.fromCanal = true;
        }
        catch (Exception e) {
            this.fromCanal = false;
        }
        boolean cut = this.aladin.configuration.getCMCut();
        int offset = 0;
        int i = 0;
        while (i < this.depth) {
            String s = this.fromCanal ? this.getCanalValue(i) : this.label;
            this.pixelsOrigin = new byte[this.width * this.height * this.nbytes];
            this.pixels = new byte[this.width * this.height];
            System.arraycopy(fits.pixels, offset, this.pixelsOrigin, 0, this.pixelsOrigin.length);
            this.addFrame(s, this.pixels, this.pixelsOrigin, false, null, 0L);
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
            this.to8bits(this.pixels, 0, this.pixelsOrigin, this.pixelsOrigin.length / this.nbytes, this.bitpix, this.pixelMin, this.pixelMax, true);
            ++i;
            offset += this.pixelsOrigin.length;
        }
        this.creatDefaultCM();
        this.z = this.depth / 2;
        this.setPourcent(-1.0);
        return true;
    }
}

