/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImageBlink;
import cds.aladin.ResourceNode;
import cds.aladin.SED;
import cds.tools.Util;
import java.io.RandomAccessFile;
import java.util.Date;

public class PlanImageCube
extends PlanImageBlink {
    protected double crval3;
    protected double crpix3;
    protected double cdelt3;
    protected String cunit3;
    protected boolean ctype3Log;
    protected boolean fromCanal;

    protected PlanImageCube(Aladin aladin, String file, MyInputStream in, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, in, label, from, o, imgNode, skip, doClose, forPourcent);
        this.type = 4;
        this.initDelay = 400;
    }

    protected String getCanalValue(int n) {
        return PlanImageCube.getCanalValue(n, this.crpix3, this.cdelt3, this.crval3, this.cunit3, this.ctype3Log);
    }

    public static String getCanalValue(int n, double crpix3, double cdelt3, double crval3, String cunit3, boolean ctype3Log) {
        String s1;
        double S;
        if (ctype3Log) {
            double d = cdelt3 / (Math.log(10.0) * crval3);
            S = crval3 * Math.pow(10.0, d * ((double)(n + 1) - crpix3));
        } else {
            S = crval3 + ((double)(n + 1) - crpix3) * cdelt3;
        }
        String string = s1 = cunit3 == null ? null : SED.getUnitFreq(S, cunit3, 6);
        if (s1 == null && cunit3 != null) {
            s1 = SED.getUnitWave(S, cunit3, 4);
        }
        if (s1 == null) {
            s1 = Util.myRound(S);
            if (cunit3 != null) {
                s1 = s1 + " " + cunit3;
            }
        }
        return s1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int n;
        Aladin.trace(2, "Loading FITS " + TYPE[this.type]);
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        int naxis = this.headerFits.getIntFromHeader("NAXIS");
        if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (naxis == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    dis.skip(this.naxis1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        this.setPixMode(2);
        this.nbytes = n = Math.abs(this.bitpix) / 8;
        long taille = (long)this.width * (long)this.height * (long)this.depth * (long)n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + this.depth + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        try {
            this.crpix3 = this.headerFits.getDoubleFromHeader("CRPIX3");
            this.crval3 = this.headerFits.getDoubleFromHeader("CRVAL3");
            try {
                this.cdelt3 = this.headerFits.getDoubleFromHeader("CDELT3");
            }
            catch (Exception e) {
                if (this.headerFits.getDoubleFromHeader("CD1_3") != 0.0 || this.headerFits.getDoubleFromHeader("CD2_3") != 0.0 || this.headerFits.getDoubleFromHeader("CD3_1") != 0.0 || this.headerFits.getDoubleFromHeader("CD3_2") != 0.0) {
                    throw new Exception();
                }
                this.cdelt3 = this.headerFits.getDoubleFromHeader("CD3_3");
            }
            this.cunit3 = this.headerFits.getStringFromHeader("CUNIT3");
            String ctype3 = this.headerFits.getStringFromHeader("CTYPE3");
            this.ctype3Log = ctype3 != null && ctype3.indexOf("-LOG") > 0;
            this.fromCanal = true;
            Aladin.trace(3, " => CTYPE3=" + ctype3 + " CRPIX3=" + this.crpix3 + " CRVAL3=" + this.crval3 + " CDELT3=" + this.cdelt3);
        }
        catch (Exception e) {
            this.fromCanal = false;
        }
        if (this.flagSkip) {
            dis.skip(taille);
        } else {
            Date d = new Date();
            boolean dejaCharge = false;
            int frameToBeLoad = this.depth;
            long required = (long)this.width * (long)this.height * (long)this.depth * (long)(this.nbytes + 1);
            boolean loadInRam = this.aladin.getMem() - (double)(required / 0x100000L) > (double)Aladin.MARGERAM;
            boolean partialInRam = false;
            Aladin.trace(4, "PlanImageCube.loadImageFits() ask for " + Util.getUnitDisk(required) + " " + (loadInRam ? "try in Ram" : "=> not enough space in RAM"));
            if (!loadInRam) {
                this.aladin.freeSomeRam(required, this);
                long freeMem = (long)this.aladin.getMem() * 1024L * 1024L;
                System.out.println("freeMem => " + Util.getUnitDisk(freeMem));
                loadInRam = (freeMem - required) / 20L > (long)Aladin.MARGERAM * 1024L * 1024L;
                long t1 = (long)this.width * (long)this.height * (long)this.nbytes;
                long dispMem = freeMem - (long)Aladin.MARGERAM * 1024L * 1024L;
                long pixel8Mem = (long)this.width * (long)this.height * (long)this.depth;
                long free = dispMem - pixel8Mem;
                if (free < 0L) {
                    free = 0L;
                }
                frameToBeLoad = (int)(free / t1);
                Aladin.trace(4, "PlanImageCube.loadImageFits() [2nd test]  ask for " + Util.getUnitDisk(required) + (loadInRam ? "try in Ram " + frameToBeLoad + " frames" : " not in RAM") + " freeRAM=" + Util.getUnitDisk(free) + ", one frame=" + Util.getUnitDisk(t1));
            }
            this.cacheFromOriginalFile = this.setCacheFromFile(dis);
            RandomAccessFile f = null;
            int tailleImg = PlanImageCube.floor(taille / (long)this.depth);
            this.pixelsOrigin = new byte[tailleImg];
            int m = this.depth / 2 + 1;
            byte[] buffer = null;
            long pos2emeLecture = 0L;
            try {
                if (!Aladin.STANDALONE) {
                    dejaCharge = true;
                    int maxM = PlanImageCube.floor(taille / 4L / (long)tailleImg);
                    if (m > maxM) {
                        m = maxM;
                    }
                    buffer = new byte[PlanImageCube.round(tailleImg * m)];
                    dis.readFully(buffer);
                    System.arraycopy(buffer, (m - 1) * tailleImg, this.pixelsOrigin, 0, tailleImg);
                } else {
                    dejaCharge = false;
                    buffer = this.pixelsOrigin;
                    if (!this.cacheFromOriginalFile) {
                        for (int i = 0; i < m; ++i) {
                            dis.readFully(buffer);
                            if (i == 0) {
                                f = this.beginInCache(buffer);
                                continue;
                            }
                            f.write(buffer);
                        }
                    } else {
                        pos2emeLecture = dis.getPos();
                        dis.skip((long)(m - 1) * (long)tailleImg);
                        dis.readFully(buffer);
                    }
                }
                Aladin.trace(3, " => Cube autocut uses the frame " + m);
                boolean cut = this.aladin.configuration.getCMCut();
                this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
                double amem = 0.0;
                double adelta = 0.0;
                String s = null;
                for (int i = 0; i < this.depth; ++i) {
                    try {
                        s = this.fromCanal ? this.getCanalValue(i) : this.label;
                        double mem = this.aladin.getMem();
                        if (!loadInRam && mem < (double)(Aladin.MARGERAM - 10)) {
                            throw new OutOfMemoryError();
                        }
                        if (Aladin.levelTrace == 4) {
                            double delta = amem - mem;
                            if (Math.abs(adelta - delta) > 0.2 || mem < (double)(Aladin.MARGERAM - 1)) {
                                Aladin.trace(4, "PlanImageCube.cacheImageFits(): frame " + i + " freeRam=" + mem + "MB delta=" + delta + "MB");
                            }
                            amem = mem;
                            adelta = delta;
                        }
                        try {
                            this.setBufPixels8(new byte[this.width * this.height]);
                            if (mem < (double)Aladin.MARGERAM) {
                                throw new OutOfMemoryError();
                            }
                        }
                        catch (OutOfMemoryError e) {
                            Aladin.trace(4, "PlanImageCube.loadImageFits(): out of memory1 freeRam=" + this.aladin.getMem() + "MB => inRam=false...");
                            loadInRam = false;
                            if (!this.freeRam()) {
                                throw new OutOfMemoryError();
                            }
                            this.setBufPixels8(new byte[this.width * this.height]);
                        }
                        if (i < m) {
                            if (dejaCharge) {
                                System.arraycopy(buffer, i * tailleImg, this.pixelsOrigin, 0, tailleImg);
                            } else {
                                if (i == 0) {
                                    if (pos2emeLecture != 0L) {
                                        f = new RandomAccessFile(this.cacheID, "r");
                                    }
                                    f.seek(pos2emeLecture);
                                }
                                f.readFully(this.pixelsOrigin);
                            }
                        } else {
                            dis.readFully(this.pixelsOrigin);
                            if (f != null && !this.cacheFromOriginalFile) {
                                f.write(this.pixelsOrigin);
                            }
                        }
                        this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.pixelsOrigin.length / this.nbytes, this.bitpix, this.pixelMin, this.pixelMax, true);
                        PlanImageCube.invImageLine(this.width, this.height, this.getBufPixels8());
                        if (loadInRam && frameToBeLoad <= 0) {
                            Aladin.trace(4, "PlanImageCube.loadImageFits(): low memory2 (frame=" + i + ") => other frames not in RAM...");
                            partialInRam = true;
                            loadInRam = false;
                        }
                        this.addFrame(s, this.getBufPixels8(), loadInRam ? this.pixelsOrigin : null, this.cacheFromOriginalFile, this.cacheID, this.cacheOffset);
                        if (loadInRam) {
                            this.pixelsOrigin = new byte[tailleImg];
                            --frameToBeLoad;
                        }
                    }
                    catch (OutOfMemoryError e) {
                        Aladin.trace(4, "PlanImageCube.loadImageFits(): out of memory freeRam=" + this.aladin.getMem() + "MB => inRam=false...");
                        loadInRam = false;
                        this.freeRam();
                        this.error = "Out of memory";
                        this.addFrame(s, this.getBufPixels8(), null, this.cacheFromOriginalFile, this.cacheID, this.cacheOffset);
                        boolean bl = false;
                        if (f != null) {
                            f.close();
                        }
                        return bl;
                    }
                    this.cacheOffset += (long)this.pixelsOrigin.length;
                    this.setPourcent(99.0 * (double)i / (double)this.depth);
                    if (i != 0) continue;
                    this.calculPixelsZoom();
                }
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
            buffer = null;
            this.noOriginalPixels();
            Date d1 = new Date();
            int temps = (int)(d1.getTime() - d.getTime());
            d = d1;
            Aladin.trace(3, " => Reading " + (!dejaCharge ? "(2 pass) " : "") + "and analyzing " + this.getDepth() + " frames in " + Util.round((double)temps / 0.001, 3) + " s => " + (temps != 0 ? Util.round((double)(taille / (long)temps / 1024L) * 1.024, 2) + " Mbyte/s" : "--") + (loadInRam ? " (fully in RAM)" : (partialInRam ? " (partially in RAM)" : "")));
        }
        if (naxis > 3) {
            try {
                long offset = n * this.width * this.height;
                for (int i = 3; i < naxis; ++i) {
                    offset *= (long)this.headerFits.getIntFromHeader("NAXIS" + (i + 1));
                }
                dis.skip(offset -= (long)(n * this.width * this.height));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        this.creatDefaultCM();
        this.z = this.depth / 2;
        this.setPourcent(-1.0);
        return true;
    }
}

