/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Coord;
import cds.aladin.CubeControl;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlinkItem;
import cds.aladin.PlanImageCube;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.ResourceNode;
import cds.aladin.ViewSimple;
import cds.fits.HeaderFits;
import cds.tools.Util;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PlanImageBlink
extends PlanImage {
    protected PlanImage pRef;
    protected int initDelay;
    protected boolean flagPause;
    protected double z;
    protected Vector<PlanImageBlinkItem> vFrames;
    protected int depth;
    private PlanImage[] tmpP;
    protected boolean flagAppend;
    public static final int PERM0 = 0;
    public static final int PERM1 = 1;
    public static final int PERM2 = 2;
    public static final int W2D = 0;
    public static final int H2D = 1;
    public static final int CP = 2;
    public static final int CM = 3;
    private int modePerm = 0;
    private boolean flagRecut = false;
    private double _min;
    private double _max;
    private boolean _autocut;
    private boolean _restart;
    protected Thread threadRecut = null;
    private boolean lock;
    private RandomAccessFile fCacheBis = null;
    private String cacheIDBis = null;
    private byte[] bufCache = null;
    private boolean loadInRamInProgress = false;
    private boolean loadInRamAborting = false;
    private int ooLastFrame = -1;
    private int oLastFrame = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanImageBlink(Aladin aladin, PlanImage[] p, String label, int delay) {
        super(aladin);
        this.type = 3;
        this.initDelay = delay;
        this.flagPause = false;
        this.z = 0.0;
        this.isOldPlan = false;
        this.pRef = p[0];
        this.vFrames = new Vector();
        Aladin.trace(3, "Blink ref plane: " + this.pRef.label);
        this.init(label, this.pRef);
        this.tmpP = new PlanImage[p.length - 1];
        System.arraycopy(p, 1, this.tmpP, 0, p.length - 1);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < p.length; ++i) {
            s.append((i > 0 ? "/" : "") + p[i]);
        }
        this.sendLog("Blink", "[" + s + "]");
        this.flagAppend = false;
        PlanImageBlink planImageBlink = this;
        synchronized (planImageBlink) {
            this.runme = new Thread((Runnable)this, "AladinBuildBlink");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    @Override
    protected int getInitDelay() {
        return this.initDelay;
    }

    @Override
    protected void setPause(boolean flag, ViewSimple v) {
        this.flagPause = flag;
    }

    @Override
    protected boolean isPause() {
        return this.flagPause;
    }

    @Override
    protected void setZ(double z) {
        this.z = z;
    }

    @Override
    protected double getZ() {
        return this.z;
    }

    protected PlanImageBlink(Aladin aladin, String file, MyInputStream in, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, in, label, from, o, imgNode, skip, doClose, forPourcent);
    }

    @Override
    protected boolean freePlan() {
        if (!super.freePlan()) {
            return false;
        }
        this.freeRam();
        this.pRef = null;
        this.vFrames = null;
        if (this.fCacheBis != null) {
            try {
                this.fCacheBis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cacheIDBis = null;
        return true;
    }

    protected void init(String label, PlanImage p) {
        p.copy(this);
        this.type = 3;
        this.flagOk = false;
        this.askActive = true;
        this.headerFits = null;
        this.pixelsZoom = null;
        this.fmt = 0;
        this.res = 0;
        this.orig = 3;
        this.status = "Re-sampling...";
        this.progress = "computing...";
        if (label == null) {
            label = "Blk img";
        }
        this.setLabel(label);
        this.copyright = "Blink sequence by Aladin";
        this.param = "";
        this.transfertFct = 3;
        this.video = 0;
        this.typeCM = p.typeCM;
        this.cmControl[0] = 0;
        this.cmControl[1] = 128;
        this.cmControl[2] = 255;
        this.cm = CanvasColorMap.getCM(0, 128, 255, false, this.typeCM, this.getTransfertFct());
        this.vFrames.addElement(new PlanImageBlinkItem(p));
        this.pixelMin = 0.0;
        this.dataMin = 0.0;
        this.pixelMax = 255.0;
        this.dataMax = 255.0;
        this.bZero = 0.0;
        this.bScale = 1.0;
    }

    public int getPermutation() {
        return this.modePerm;
    }

    public void permutation(int m) {
        int action = -1;
        if (m == this.modePerm) {
            return;
        }
        if (this.modePerm == 0 && m == 1 || this.modePerm == 1 && m == 0) {
            action = 1;
        } else if (this.modePerm == 0 && m == 2 || this.modePerm == 2 && m == 0) {
            action = 0;
        } else if (this.modePerm == 1 && m == 2) {
            action = 2;
        } else if (this.modePerm == 2 && m == 1) {
            action = 3;
        }
        boolean full = this.modePerm == 0 ? this.loadInRam(0, this.depth) : this.isFullyInRam(0, this.depth);
        this.flagProcessing = true;
        this.pourcent = -1.0;
        this.aladin.calque.repaintAll();
        new ThreadPermute(m, action, full).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPermute(int a, boolean full) {
        int j;
        int w;
        int n = a == 0 || a == 2 ? this.depth : (w = a == 3 ? this.height : this.width);
        int h = a == 1 || a == 3 ? this.depth : (a == 2 ? this.width : this.height);
        int d = a == 2 || a == 1 ? this.height : this.width;
        ArrayList<PlanImageBlinkItem> v = null;
        int n2 = j = full ? 1 : 0;
        while (j < 2) {
            if (!full) {
                for (PlanImageBlinkItem p : this.vFrames) {
                    p.pixelsOrigin = null;
                }
                this.aladin.gc();
            }
            try {
                v = new ArrayList<PlanImageBlinkItem>(d);
                for (int i = 0; i < d; ++i) {
                    byte[] pixels = new byte[w * h];
                    byte[] pixelsOrign = full ? new byte[w * h * this.nbytes] : null;
                    v.add(new PlanImageBlinkItem(this.label, pixels, pixelsOrign, false, null, 0L));
                }
                break;
            }
            catch (OutOfMemoryError e) {
                this.aladin.console.printError("!!! Not enough memory => trying Cube permutation without true pixels...");
                full = false;
                v = null;
                System.gc();
                ++j;
            }
        }
        double deltaPourcent = 100.0 / (double)this.depth;
        for (int z = 0; z < this.depth; ++z) {
            this.pourcent += deltaPourcent;
            PlanImageBlinkItem pi = this.vFrames.get(z);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    PlanImageBlinkItem p = (PlanImageBlinkItem)v.get(a == 2 || a == 1 ? y : x);
                    int src = y * this.width + x;
                    int trg = (a == 1 || a == 3 ? z : (a == 2 ? x : y)) * w + (a == 0 || a == 2 ? z : (a == 3 ? y : x));
                    p.pixels[trg] = pi.pixels[src];
                    if (!full) continue;
                    System.arraycopy(pi.pixelsOrigin, src * this.nbytes, p.pixelsOrigin, trg * this.nbytes, this.nbytes);
                }
            }
        }
        Vector<PlanImageBlinkItem> v1 = new Vector<PlanImageBlinkItem>(d);
        for (PlanImageBlinkItem p : v) {
            v1.add(p);
        }
        PlanImageBlink planImageBlink = this;
        synchronized (planImageBlink) {
            this.vFrames = v1;
            this.naxis1 = this.width = w;
            this.naxis2 = this.height = h;
            this.depth = d;
            this.oLastFrame = -1;
            this.setCubeFrame(0.0);
        }
    }

    private void permuteCalib(int m) {
        try {
            if (this.headerFits == null) {
                return;
            }
            String originalHeaderFits = this.headerFits.getOriginalHeaderFits();
            if (m == 1) {
                originalHeaderFits = this.modifCalib(originalHeaderFits, new String[]{"2-3", "3-2"});
            } else if (m == 2) {
                originalHeaderFits = this.modifCalib(originalHeaderFits, new String[]{"1-3", "3-1"});
            }
            Projection proj = new Projection(2, new Calib(new HeaderFits(originalHeaderFits)), this);
            this.setNewProjD(proj);
            this.setHasSpecificCalib();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.projd = null;
            this.projD = null;
            return;
        }
    }

    private String modifCalib(String s, String[] rules) {
        StringTokenizer st = new StringTokenizer(s, "\n");
        StringBuffer res = new StringBuffer();
        while (st.hasMoreTokens()) {
            int pos;
            String line = st.nextToken();
            if (!line.startsWith("COMMENT") && !line.startsWith("HISTORY") && (pos = line.indexOf(61)) != -1) {
                char ch = ' ';
                --pos;
                while (pos > 0 && Character.isWhitespace(ch = line.charAt(pos))) {
                    --pos;
                }
                if (pos > 0 && Character.isDigit(ch)) {
                    for (int i = 0; i < rules.length; ++i) {
                        char avant = rules[i].charAt(0);
                        char apres = rules[i].charAt(rules[i].length() - 1);
                        if (ch != avant) continue;
                        line = line.substring(0, pos) + apres + line.substring(pos + 1);
                        break;
                    }
                }
            }
            res.append(line + "\n");
        }
        return res.toString();
    }

    @Override
    protected boolean setActivated(boolean flag) {
        if (flag = super.setActivated(flag)) {
            this.aladin.view.startTimer();
        }
        return flag;
    }

    @Override
    protected boolean waitForPlan() {
        this.addFrame(this.tmpP);
        return true;
    }

    @Override
    public void run() {
        if (this.flagRecut) {
            this.flagRecut = false;
            this.runRecut();
            return;
        }
        if (!this.flagAppend) {
            Aladin.trace(1, "Creating the " + TYPE[this.type] + " plane " + this.label);
            if (this instanceof PlanImageCube) {
                this.planReady(super.waitForPlan());
            } else {
                this.planReady(this.waitForPlan());
                this.pRef = null;
            }
            this.flagAppend = true;
        } else {
            Aladin.trace(1, "Adding planes to " + this.label);
            this.addFrame(this.tmpP);
            this.flagOk = true;
        }
        this.aladin.view.startTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void addPlan(PlanImage p) {
        this.flagOk = false;
        this.flagProcessing = true;
        this.tmpP = new PlanImage[1];
        this.tmpP[0] = p;
        this.aladin.calque.select.repaint();
        PlanImageBlink planImageBlink = this;
        synchronized (planImageBlink) {
            this.runme = new Thread((Runnable)this, "AladinBlinkAdd");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected synchronized void addFrame(String label, byte[] pixels, byte[] pixelsOrigin, boolean cacheFromOriginalFile, String cacheID, long cacheOffset) {
        if (this.vFrames == null) {
            this.vFrames = new Vector();
        }
        this.vFrames.addElement(new PlanImageBlinkItem(label, pixels, pixelsOrigin, cacheFromOriginalFile, cacheID, cacheOffset));
    }

    protected synchronized void addFrame(PlanImage[] p) {
        int n;
        Aladin.trace(3, "Adding " + p.length + " frame(s)...");
        Coord coo = new Coord();
        int x = 0;
        int y = 0;
        int w = this.width;
        int taille = this.width * this.height;
        byte[][] c = new byte[p.length][taille];
        boolean[] theSame = new boolean[p.length];
        boolean flagAllTheSame = true;
        for (n = 0; n < p.length; ++n) {
            theSame[n] = !Projection.isOk(this.projd) && !Projection.isOk(p[n].projd);
            if (theSame[n] || (theSame[n] = this.projd.c.TheSame(p[n].projd.c))) {
                p[n].getLinearPixels8(c[n]);
                Aladin.trace(4, "PlanImageBlink.addFrame() : " + p[n].label);
                continue;
            }
            Aladin.trace(4, "PlanImageBlink.addFrame() : " + p[n].label + " (resampled)");
            flagAllTheSame = false;
        }
        if (!flagAllTheSame) {
            for (int i = 0; i < taille; ++i) {
                coo.x = i % w;
                coo.y = i / w;
                this.projd.getCoord(coo);
                if (Double.isNaN(coo.al)) continue;
                for (n = 0; n < p.length; ++n) {
                    if (theSame[n]) continue;
                    PlanImage p2 = p[n];
                    p2.projd.getXY(coo);
                    if (!Double.isNaN(coo.x)) {
                        x = (int)Math.round(coo.x);
                        y = (int)Math.round(coo.y);
                        if (x >= 0 && x < p2.width && y >= 0 && y < p2.height) {
                            int pix = 0xFF & p2.getBufPixels8()[y * p2.width + x];
                            c[n][i] = (byte)p2.cm.getBlue(pix);
                        }
                    }
                    if (i * p.length % 10000 != 0) continue;
                    this.setPourcent(i * 100 / taille);
                }
            }
        }
        for (n = 0; n < p.length; ++n) {
            PlanImage pi = p[n];
            this.vFrames.addElement(new PlanImageBlinkItem(pi.label, c[n], null, pi.cacheFromOriginalFile, pi.cacheID, pi.cacheOffset));
        }
        this.setPourcent(-1.0);
        this.flagOk = true;
        this.flagProcessing = false;
        Aladin.trace(3, "Adding a frame achieved...");
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    @Override
    protected boolean hasOriginalPixels() {
        if (this.vFrames == null) {
            return false;
        }
        PlanImageBlinkItem p = this.vFrames.elementAt(0);
        return p.pixelsOrigin != null || p.cacheID != null;
    }

    @Override
    protected boolean recut(double min, double max, boolean autocut) {
        if (!this.hasOriginalPixels()) {
            return false;
        }
        this.getLock();
        this.flagUpdating = true;
        if (min == -1.0 && max == -1.0) {
            min = this.dataMinFits;
            max = this.dataMaxFits;
        }
        this._min = min;
        this._max = max;
        this._autocut = autocut;
        this.flagRecut = true;
        this._restart = false;
        ViewSimple vc = this.aladin.view.getCurrentView();
        int frame = vc.cubeControl.lastFrame;
        this.activePixelsOrigin(frame);
        PlanImageBlinkItem pbi = this.vFrames.elementAt(frame);
        this.pixelsOriginFromCache();
        this.getPix8Bits(pbi.pixels, this.pixelsOrigin, this.bitpix, this.width, this.height, min, max, autocut, 0, 0, 0);
        PlanImageBlink.invImageLine(this.width, this.height, pbi.pixels);
        this.changeImgID();
        this.calculPixelsZoom(pbi.pixels);
        this.aladin.calque.select.repaint();
        this.aladin.calque.zoom.zoomView.repaint();
        vc.repaint();
        this._autocut = false;
        this._min = this.pixelMin;
        this._max = this.pixelMax;
        if (!this.isThreadingRecut()) {
            this.setThreadRecut(new Thread((Runnable)this, "AladinBlinkRecut")).start();
        } else {
            this.recutCubeAgain();
        }
        return true;
    }

    synchronized Thread setThreadRecut(Thread t) {
        this.threadRecut = t;
        return t;
    }

    synchronized boolean isThreadingRecut() {
        return this.threadRecut != null;
    }

    private synchronized void setLock(boolean l) {
        this.lock = l;
    }

    private synchronized boolean isLocked() {
        return this.lock;
    }

    private void getLock() {
        while (this.isLocked()) {
            Util.pause(10);
        }
    }

    synchronized void setRestart(boolean f) {
        this._restart = f;
    }

    synchronized boolean isRestart() {
        return this._restart;
    }

    private void recutCubeAgain() {
        this.setRestart(true);
    }

    private void runRecut() {
        this.recutCube(this._min, this._max, this._autocut);
    }

    protected boolean recutCube(double min, double max, boolean autocut) {
        this.setRestart(false);
        this.setLock(false);
        Date d = new Date();
        String ocacheID = null;
        byte[] buffer = new byte[this.width * this.height * this.nbytes];
        byte[] buf = null;
        RandomAccessFile f = null;
        Aladin.trace(3, "Original cube pixels reloaded frame by frame");
        for (int frame = 0; frame < this.depth; ++frame) {
            if (frame % 5 == 0) {
                Util.pause(10);
            }
            try {
                if (this.isRestart()) {
                    if (f != null) {
                        f.close();
                    }
                    buffer = null;
                    return this.recutCube(this._min, this._max, this._autocut);
                }
                PlanImageBlinkItem pbi = this.vFrames.elementAt(frame);
                if (pbi.pixelsOrigin != null) {
                    buf = pbi.pixelsOrigin;
                } else {
                    if (ocacheID != pbi.cacheID) {
                        if (f != null) {
                            f.close();
                        }
                        f = new RandomAccessFile(new File(pbi.cacheID), "r");
                        ocacheID = pbi.cacheID;
                    }
                    f.seek(pbi.cacheOffset);
                    f.readFully(buffer);
                    buf = buffer;
                }
                this.getPix8Bits(pbi.pixels, buf, this.bitpix, this.width, this.height, min, max, autocut, 0, 0, 0);
                PlanImageBlink.invImageLine(this.width, this.height, pbi.pixels);
                this.setPourcent(99.0 * (double)frame / (double)this.depth);
                continue;
            }
            catch (Exception e) {
                System.err.println("Error on frame " + frame);
                e.printStackTrace();
            }
        }
        try {
            f.close();
        }
        catch (Exception frame) {
            // empty catch block
        }
        Date d1 = new Date();
        long temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Full cube contrast adjustement in " + temps + " ms");
        buffer = null;
        this.flagOk = true;
        this.flagUpdating = false;
        this.changeImgID();
        this.setPourcent(-1.0);
        this.aladin.view.repaintAll();
        Util.pause(1000);
        if (this._restart) {
            return this.recutCube(this._min, this._max, this._autocut);
        }
        this.getLock();
        this.setThreadRecut(null);
        this.setLock(false);
        return true;
    }

    @Override
    protected boolean getFromCache() {
        if (this.pixelsOrigin != null) {
            return true;
        }
        if (this.oLastFrame != -1) {
            PlanImageBlinkItem pbi = this.vFrames.elementAt(this.oLastFrame);
            if (pbi.pixelsOrigin != null) {
                this.pixelsOrigin = pbi.pixelsOrigin;
                return true;
            }
        }
        return super.getFromCache();
    }

    protected synchronized boolean freeRam() {
        if (this.loadInRamInProgress) {
            this.loadInRamAborting = true;
        }
        return this.freeRam(-1L) > 0L;
    }

    protected synchronized long freeRam(long askMem) {
        long mem = 0L;
        if (this.vFrames == null) {
            return 0L;
        }
        Enumeration<PlanImageBlinkItem> e = this.vFrames.elements();
        while (e.hasMoreElements()) {
            PlanImageBlinkItem pbi = e.nextElement();
            if (pbi.pixelsOrigin == null) continue;
            pbi.pixelsOrigin = null;
            if (askMem == -1L || (mem += (long)pbi.pixelsOrigin.length) <= askMem) continue;
            break;
        }
        if (mem > 0L) {
            Aladin.trace(4, "PlanImageBlink.freeRam(" + askMem + ") [" + this.label + "] (free " + (double)mem / 1048576.0 + "MB) ...");
            this.aladin.gc();
        }
        return mem;
    }

    @Override
    protected boolean isCubeClassique() {
        return true;
    }

    synchronized boolean isFullyInRam(int z1, int d) {
        for (int z = z1; z < this.depth && z < z1 + d; ++z) {
            if (this.vFrames.elementAt((int)z).pixelsOrigin != null) continue;
            return false;
        }
        return true;
    }

    private synchronized boolean loadInRam(int z1, int d) {
        if (this.isFullyInRam(z1, d)) {
            Aladin.trace(4, "PlanImageBlink.loadInRam(" + z1 + "," + d + "): reloading not required (fully in Ram)");
            return true;
        }
        try {
            boolean ok;
            long taille = (long)this.width * (long)this.height * (long)d * (long)this.nbytes;
            if (taille >= Integer.MAX_VALUE) {
                return false;
            }
            if (this.loadInRamInProgress) {
                Aladin.trace(4, "PlanImageBlink.loadInRam(" + z1 + "," + d + "): loading still in progress => no launch new one");
                return false;
            }
            this.loadInRamAborting = false;
            this.loadInRamInProgress = true;
            double requiredMo = (double)this.width * (double)this.height * (double)d * (double)(this.nbytes + 1) / 1048576.0;
            boolean bl = ok = this.aladin.getMem() - requiredMo > (double)Aladin.MARGERAM;
            if (!ok && this.aladin.freeSomeRam((long)(requiredMo * 1024.0 * 1024.0), this) > 0L) {
                ok = this.aladin.getMem() - requiredMo > (double)Aladin.MARGERAM;
            }
            Aladin.trace(4, "PlanImageBlink.loadInRam(" + z1 + "," + d + "): ask for " + requiredMo + "Mo : " + (ok ? "enough space => loading..." : "Not enough space => ignored"));
            if (!ok) {
                this.loadInRamInProgress = false;
                return false;
            }
            int length = this.width * this.height * this.nbytes;
            for (int z = z1; z < this.depth && z < z1 + d; ++z) {
                PlanImageBlinkItem pbi = this.vFrames.elementAt(z);
                if (pbi.pixelsOrigin != null) continue;
                pbi.pixelsOrigin = new byte[length];
                if (this.cacheIDBis != pbi.cacheID) {
                    if (this.fCacheBis != null) {
                        try {
                            this.fCacheBis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.cacheIDBis = pbi.cacheID;
                    this.fCacheBis = new RandomAccessFile(new File(this.cacheIDBis), "r");
                }
                if (this.loadInRamAborting) {
                    throw new Exception("LoadInRam abort by freeRam call");
                }
                this.seekAndRead(this.fCacheBis, pbi.cacheOffset, pbi.pixelsOrigin, 0, length);
            }
            this.loadInRamInProgress = false;
            return true;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.loadInRamInProgress = false;
            return false;
        }
    }

    protected double getPixel(int x, int y, int z) throws Exception {
        PlanImageBlinkItem pbi = this.vFrames.elementAt(z);
        byte[] pixelsOrigin = pbi.pixelsOrigin;
        if (pbi.pixelsOrigin != null) {
            return this.getPixVal(pixelsOrigin, this.bitpix, y * this.width + x) * this.bScale + this.bZero;
        }
        if (this.cacheIDBis != pbi.cacheID) {
            if (this.fCacheBis != null) {
                try {
                    this.fCacheBis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cacheIDBis = pbi.cacheID;
            this.fCacheBis = new RandomAccessFile(new File(this.cacheIDBis), "r");
        }
        if (this.bufCache == null) {
            this.bufCache = new byte[this.nbytes];
        }
        this.seekAndRead(this.fCacheBis, pbi.cacheOffset + (long)(this.nbytes * (y * this.width + x)), this.bufCache, 0, this.bufCache.length);
        return this.getPixVal(this.bufCache, this.bitpix, 0) * this.bScale + this.bZero;
    }

    private synchronized void seekAndRead(RandomAccessFile f, long pos, byte[] buf, int offset, int length) throws Exception {
        f.seek(pos);
        f.readFully(buf, offset, length);
    }

    protected double[][][] getCube(int x, int y, int z, int w, int h, int d) throws Exception {
        return this.getCube(null, x, y, z, w, h, d);
    }

    protected double[][][] getCube(double[][][] cube, int x, int y, int z, int w, int h, int d) throws Exception {
        if (cube == null) {
            cube = new double[w][h][d];
        }
        this.loadInRam(z, d);
        byte[] buffer = new byte[w * this.nbytes];
        for (int z1 = z; z1 < z + d; ++z1) {
            int x1;
            int y12;
            PlanImageBlinkItem pbi = this.vFrames.elementAt(z1);
            byte[] pixelsOrigin = pbi.pixelsOrigin;
            if (pbi.pixelsOrigin != null) {
                for (y12 = y; y12 < y + h; ++y12) {
                    for (x1 = x; x1 < x + w; ++x1) {
                        cube[x1 - x][y12 - y][z1 - z] = this.getPixVal(pixelsOrigin, this.bitpix, y12 * this.width + x1) * this.bScale + this.bZero;
                    }
                }
                continue;
            }
            if (this.cacheIDBis != pbi.cacheID) {
                if (this.fCacheBis != null) {
                    try {
                        this.fCacheBis.close();
                    }
                    catch (Exception y12) {
                        // empty catch block
                    }
                }
                this.cacheIDBis = pbi.cacheID;
                this.fCacheBis = new RandomAccessFile(new File(this.cacheIDBis), "r");
            }
            for (y12 = y; y12 < y + h; ++y12) {
                this.seekAndRead(this.fCacheBis, pbi.cacheOffset + (long)(this.nbytes * (y12 * this.width + x)), buffer, 0, buffer.length);
                for (x1 = 0; x1 < w; ++x1) {
                    cube[x1][y12 - y][z1 - z] = this.getPixVal(buffer, this.bitpix, x1) * this.bScale + this.bZero;
                }
            }
        }
        return cube;
    }

    @Override
    protected String getSizeInfo() {
        return this.width + "x" + this.height + " pixels (8bits kept)";
    }

    @Override
    public int getDepth() {
        return this.vFrames == null ? 0 : this.vFrames.size();
    }

    @Override
    protected String getFrameLabel(int i) {
        if (!this.active) {
            return this.label;
        }
        return this.vFrames.elementAt((int)i).label;
    }

    protected byte[] getFrame(int n) {
        return this.vFrames.elementAt((int)n).pixels;
    }

    @Override
    protected byte getPixel8bit(int z, double x, double y) {
        return this.vFrames.elementAt((int)z).pixels[(int)y * this.width + (int)x];
    }

    @Override
    protected void activeCubePixels(ViewSimple v) {
        if (this.flagUpdating) {
            return;
        }
        if (this.ooLastFrame == v.cubeControl.lastFrame) {
            return;
        }
        if (v.cubeControl.mode == CubeControl.PAUSE) {
            this.activePixelsOrigin(v);
        } else {
            ((PlanImage)v.pref).noOriginalPixels();
        }
        if (this.oLastFrame == v.cubeControl.lastFrame) {
            return;
        }
        this.oLastFrame = v.cubeControl.lastFrame;
        PlanImageBlinkItem pbi = this.vFrames.elementAt(this.oLastFrame);
        this.setBufPixels8(pbi.pixels);
        this.pixelsOrigin = pbi.pixelsOrigin;
        this.aladin.calque.zoom.zoomView.resetImgID();
        this.aladin.calque.zoom.zoomView.repaint();
    }

    @Override
    protected boolean setCubeFrame(double frameLevel) {
        int frame = (int)frameLevel;
        if (this.flagUpdating) {
            return false;
        }
        if (this.oLastFrame == frame) {
            return false;
        }
        this.oLastFrame = frame;
        this.z = this.oLastFrame;
        PlanImageBlinkItem pbi = this.vFrames.elementAt(this.oLastFrame);
        this.setBufPixels8(pbi.pixels);
        this.pixelsOrigin = pbi.pixelsOrigin;
        this.aladin.view.resumeStatOnCube();
        return true;
    }

    protected void activePixelsOrigin(ViewSimple v) {
        this.activePixelsOrigin(v, this);
    }

    protected void activePixelsOrigin(int frame) {
        this.activePixelsOrigin(this, frame);
    }

    protected void activePixelsOrigin(ViewSimple v, PlanImage p) {
        this.activePixelsOrigin(p, v.cubeControl.lastFrame);
    }

    private void activePixelsOrigin(PlanImage p, int frame) {
        this.ooLastFrame = frame;
        PlanImageBlinkItem pbi = this.vFrames.elementAt(frame);
        p.cacheID = pbi.cacheID;
        p.cacheOffset = pbi.cacheOffset;
        p.cacheFromOriginalFile = pbi.cacheFromOriginalFile;
        p.pixelsOrigin = pbi.pixelsOrigin;
    }

    protected void getPixels(byte[] newpixels, int x, int y, int w, int h, int frame, double transparency) {
        int k = 0;
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        if (transparency == -1.0 || transparency == 0.0 || this.getDepth() == 1) {
            byte[] pixels = this.getFrame(frame);
            int n = y + h;
            for (int i = y; i < n; ++i) {
                System.arraycopy(pixels, i * this.width + x, newpixels, k, w);
                k += w + aw;
            }
            return;
        }
        byte[] p1 = this.getFrame(frame);
        byte[] p2 = this.getFrame(frame == this.getDepth() - 1 ? 0 : frame + 1);
        double complement = 1.0 - transparency;
        int n = y + h;
        for (int i = y; i < n; ++i) {
            int m = x + w;
            for (int j = x; j < m; ++j) {
                int q = i * this.width + j;
                double pix = (double)(p1[q] & 0xFF) * complement + (double)(p2[q] & 0xFF) * transparency;
                newpixels[k++] = (byte)((int)pix & 0xFF);
            }
            if (aw == 0) continue;
            k += aw;
        }
    }

    class ThreadPermute
    extends Thread {
        int m;
        int action;
        boolean full;

        public ThreadPermute(int m, int action, boolean full) {
            this.m = m;
            this.action = action;
            this.full = full;
        }

        @Override
        public void run() {
            PlanImageBlink.this.doPermute(this.action, this.full);
            PlanImageBlink.this.permuteCalib(this.m);
            PlanImageBlink.this.modePerm = this.m;
            PlanImageBlink.this.flagProcessing = false;
            PlanImageBlink.this.pourcent = -1.0;
            PlanImageBlink.this.changeImgID();
            PlanImageBlink.this.aladin.calque.repaintAll();
            Properties.majProp();
        }
    }
}

