/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Coord;
import cds.aladin.Kernel;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.tools.Util;

public class PlanImageAlgo
extends PlanImage {
    protected static final int PPV = 0;
    protected static final int BILINEAIRE = 1;
    protected static final int ADD = 0;
    protected static final int SUB = 1;
    protected static final int MUL = 2;
    protected static final int DIV = 3;
    protected static final int NORM = 4;
    protected static final int NORMCUT = 5;
    protected static final int CONV = 6;
    protected static final int CONVG = 7;
    protected static final int BITPIX = 8;
    protected static final int BITPIXCUT = 9;
    protected static String[] NAME = new String[]{"Add", "Sub", "Mul", "Div", "Norm", "NormC", "Conv", "ConvG", "Bitpix", "BitpixC"};
    private PlanImage p1 = null;
    private PlanImage p2 = null;
    private int fct;
    private double coef;
    private String param;
    protected int methode;
    private boolean askNewView = false;
    private static final String FCT = "+-*/~#";

    protected PlanImageAlgo(Aladin aladin, String label, PlanImage p1, PlanImage p2, int fct, double coef, String conv, int methode) {
        super(aladin, p1);
        this.type = 7;
        this.askNewView = true;
        Calque cfr_ignored_0 = aladin.calque;
        this.isOldPlan = !Calque.isNewPlan(label);
        this.setLabel(label == null ? "conv[" + label + "]" : label);
        this.launchAlgo(p1, p2, fct, coef, conv, methode);
    }

    protected PlanImageAlgo(Aladin aladin, PlanImage p) {
        super(aladin, p);
        this.type = 7;
    }

    protected PlanImageAlgo() {
    }

    protected PlanImageAlgo(Aladin aladin) {
        super(aladin);
        this.type = 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchAlgo(PlanImage p1, PlanImage p2, int fct, double coef, String param, int methode) {
        this.methode = methode;
        this.p1 = p1 == null ? null : new PlanImage(this.aladin, p1);
        this.p2 = p2 == null ? null : new PlanImage(this.aladin, p2);
        this.p1 = p1;
        this.p2 = p2;
        this.fct = fct;
        this.coef = coef;
        this.param = param;
        this.copyright = "Computed by Aladin";
        param = "Computed: " + this.getFonction();
        this.setHasSpecificCalib();
        this.flagOk = false;
        this.flagProcessing = true;
        this.aladin.calque.select.repaint();
        this.sendLog("Compute", " [" + this + " = " + this.getFonction() + (methode == 1 ? "/bilinear" : "") + "]");
        PlanImageAlgo planImageAlgo = this;
        synchronized (planImageAlgo) {
            this.runme = new Thread((Runnable)this, "AladinBuildAlgo");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected String getFonction() {
        return (this.p1 != null ? this.p1.label : (this.p2 != null ? this.coef + "" : "")) + " " + (this.fct == 6 ? "conv " + this.param + "" : (this.fct == 8 ? "bitpix " + this.param + "" : (this.fct == 9 ? "bitpix -cut " + this.param + "" : PlanImageAlgo.getFct(this.fct) + (this.p2 != null ? this.p2.label : this.coef + "")))) + " ";
    }

    protected static String getFct(int fct) {
        return FCT.charAt(fct) + "";
    }

    @Override
    protected void planReady(boolean ready) {
        if (!ready || this.askNewView) {
            super.planReady(ready);
            return;
        }
        this.setActivated(true);
        this.pourcent = -1.0;
        this.flagOk = true;
        this.aladin.calque.repaintAll();
    }

    protected static PlanImage normalise(PlanImage p) {
        PlanImageAlgo p1 = new PlanImageAlgo(p.aladin, null, p, null, 4, 0.0, null, 0);
        while (p1 != null && !p1.isSync()) {
            Util.pause(500);
            Aladin.trace(4, "PlanImageAlgo.normalise:  waiting " + p + "...");
        }
        return p1;
    }

    protected boolean compute() {
        int x;
        int y;
        this.flagProcessing = true;
        this.aladin.calque.select.repaint();
        if (this.p1 != null) {
            this.p1.setLockCacheFree(true);
            this.p1.pixelsOriginFromCache();
        }
        if (this.p2 != null) {
            this.p2.setLockCacheFree(true);
            this.p2.pixelsOriginFromCache();
        }
        Aladin.trace(3, "Computing " + this.getFonction() + "...");
        Coord coo = new Coord();
        double op2 = 0.0;
        double min = 0.0;
        double max = 0.0;
        double moy = 0.0;
        boolean flagNorm = false;
        if (this.fct == 4 || this.fct == 5) {
            flagNorm = true;
            min = this.fct == 4 ? this.dataMin : this.pixelMin;
            max = this.fct == 4 ? this.dataMax : this.pixelMax;
            min = min * this.bScale + this.bZero;
            max = max * this.bScale + this.bZero;
            this.coef = max - min;
            if (this.fct == 5) {
                this.transfertFct = 3;
            }
            for (y = 0; y < this.height; ++y) {
                int n = 0;
                double pixLine = 0.0;
                for (x = 0; x < this.width; ++x) {
                    try {
                        double pix = this.p1.getPixel(x, y);
                        if (this.p1.isBlank(pix)) continue;
                        pixLine += pix;
                        ++n;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                moy += n == 0 ? 0.0 : pixLine / (double)n;
            }
            moy /= (double)this.height;
        }
        int bitpix1 = this.p1 == null ? 8 : this.p1.bitpix;
        int bitpix2 = this.p2 == null ? 8 : this.p2.bitpix;
        this.bitpix = Math.max(Math.abs(bitpix1), Math.abs(bitpix2));
        if (bitpix1 < 0 || bitpix2 < 0) {
            this.bitpix = -this.bitpix;
        }
        if (this.fct == 6 && this.bitpix != -64) {
            this.bitpix = -32;
        }
        if ((this.p1 != null && (this.p1.bScale != 1.0 || this.p1.bZero != 0.0) || this.p2 != null && (this.p2.bScale != 1.0 || this.p2.bZero != 0.0)) && this.bitpix != -64) {
            this.bitpix = -32;
        }
        if (this.fct == 8 || this.fct == 9) {
            this.bitpix = Integer.parseInt(this.param);
        }
        this.nbytes = Math.abs(this.bitpix) / 8;
        this.bZero = 0.0;
        this.bScale = 1.0;
        this.isBlank = false;
        this.dataMaxFits = 0.0;
        this.dataMinFits = 0.0;
        Aladin.trace(4, "PlanImageAlgo.compute(): Target image: " + this.width + "x" + this.height + " bitpix=" + this.bitpix);
        this.pixelsOrigin = new byte[this.width * this.height * this.nbytes];
        if (this.fct == 8 || this.fct == 9) {
            double maxCoding;
            double d = this.bitpix == -64 ? Double.MAX_VALUE : (this.bitpix == -32 ? 3.4028234663852886E38 : (this.bitpix == 64 ? 9.223372036854776E18 : (this.bitpix == 32 ? 2.147483647E9 : (maxCoding = this.bitpix == 16 ? 32767.0 : 255.0))));
            double minCoding = this.bitpix == -64 ? -1.7976931348623157E308 : (this.bitpix == -32 ? -3.4028234663852886E38 : (this.bitpix == 64 ? -9.223372036854776E18 : (this.bitpix == 32 ? -2.147483648E9 : (this.bitpix == 16 ? -32768.0 : 0.0))));
            double pMin = this.p1.getPixelMin();
            double pMax = this.p1.getPixelMax();
            double coef = (maxCoding - minCoding) / (pMax - pMin);
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    double pixval = this.p1.getPixel(x, y);
                    if (this.fct == 9) {
                        if (pixval < pMin) {
                            pixval = pMin;
                        } else if (pixval > pMax) {
                            pixval = pMax;
                        }
                        pixval = (pixval - pMin) * coef + minCoding;
                    } else if (pixval > maxCoding) {
                        pixval = maxCoding;
                    } else if (pixval < minCoding) {
                        pixval = minCoding;
                    }
                    this.setPixelOriginInDouble(x, y, pixval);
                }
                if (y % 100 != 0) continue;
                if (this.type == 0) break;
                this.pourcent = x * y * 100 / this.p1.getBufPixels8().length;
            }
            this.bZero = pMin - minCoding;
            this.bScale = 1.0 / coef;
            this.pixelMin = this.dataMin = minCoding;
            this.pixelMax = this.dataMax = maxCoding;
        } else if (this.fct == 6) {
            Kernel k;
            block88: {
                double pixRes = 2.777777777777778E-4;
                try {
                    pixRes = this.projd.getPixResDelta();
                }
                catch (Exception minCoding) {
                    // empty catch block
                }
                k = null;
                try {
                    k = this.aladin.kernelList.getKernel(this.param, pixRes);
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    this.error = e.getMessage();
                    if (this.error != null) break block88;
                    this.error = "conv error";
                }
            }
            if (k == null) {
                Aladin.error(this.error);
                this.flagOk = true;
                return false;
            }
            int cols = k.matrix.length;
            int cols2 = cols / 2;
            double[] inPixels = new double[this.width * this.height];
            int i = 0;
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    double pix = this.p1.getPixelOriginInDouble(x, y);
                    inPixels[i++] = pix;
                }
            }
            if (k.gaussian != null) {
                double[] outPixels = new double[this.width * this.height];
                this.convolveAndTranspose(k, inPixels, outPixels, this.width, this.height, 0);
                this.convolveAndTranspose(k, outPixels, inPixels, this.height, this.width, this.width * this.height / 2);
                i = 0;
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        this.setPixelOriginInDouble(x, y, inPixels[i++]);
                    }
                }
            } else {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        double pixval = 0.0;
                        for (int y1 = -cols2; y1 <= cols2; ++y1) {
                            for (int x1 = -cols2; x1 <= cols2; ++x1) {
                                int x2 = x + x1;
                                int y2 = y + y1;
                                if (x2 < 0) {
                                    x2 = 0;
                                } else if (x2 >= this.width) {
                                    x2 = this.width - 1;
                                }
                                if (y2 < 0) {
                                    y2 = 0;
                                } else if (y2 >= this.height) {
                                    y2 = this.height - 1;
                                }
                                pixval += inPixels[y2 * this.width + x2] * k.matrix[x1 + cols2][y1 + cols2];
                            }
                        }
                        this.setPixelOriginInDouble(x, y, pixval);
                    }
                    if (y % 100 != 0) continue;
                    if (this.type != 0) {
                        this.pourcent = x * y * 100 / this.p1.getBufPixels8().length;
                        continue;
                    }
                    break;
                }
            }
        } else {
            boolean sameCalib = false;
            if (this.p1 != null && !Projection.isOk(this.p1.projd) && this.p2 != null && !Projection.isOk(this.p2.projd)) {
                sameCalib = true;
            } else if (this.p1 != null && this.p2 != null) {
                sameCalib = this.p1.projd.c.TheSame(this.p2.projd.c);
            }
            boolean noCalib = false;
            if (this.p1 != null && !Projection.isOk(this.p1.projd) && this.p2 != null && !Projection.isOk(this.p2.projd)) {
                noCalib = true;
            }
            if (sameCalib) {
                this.methode = 0;
            }
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = -1.7976931348623157E308;
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    double pixval = Double.NaN;
                    try {
                        pixval = this.p1.getPixel(x, y);
                        if (flagNorm) {
                            if (pixval < min) {
                                pixval = min;
                            }
                            if (pixval > max) {
                                pixval = max;
                            }
                            pixval /= moy;
                        } else {
                            if (this.p2 == null || this.fct == 4) {
                                op2 = this.coef;
                            } else {
                                coo.x = x;
                                coo.y = y;
                                if (!sameCalib && !noCalib) {
                                    coo.y = (double)this.height - coo.y - 1.0;
                                    this.p1.projd.getCoord(coo);
                                    if (Double.isNaN(coo.al)) continue;
                                    this.p2.projd.getXY(coo);
                                    coo.y = (double)this.p2.height - coo.y - 1.0;
                                }
                                if (!Double.isNaN(coo.x)) {
                                    switch (this.methode) {
                                        case 0: {
                                            int x1 = (int)Math.round(coo.x);
                                            int y1 = (int)Math.round(coo.y);
                                            if (x1 < 0 || x1 >= this.p2.width || y1 < 0 || y1 >= this.p2.height) {
                                                op2 = Double.NaN;
                                                break;
                                            }
                                            op2 = this.p2.getPixel(x1, y1);
                                            break;
                                        }
                                        case 1: {
                                            double d3;
                                            double d2;
                                            double d1;
                                            double d0;
                                            int x1 = (int)Math.round(coo.x - 0.5);
                                            int y1 = (int)Math.round(coo.y - 0.5);
                                            int x2 = x1 + 1;
                                            int y2 = y1 + 1;
                                            if (x1 < 0 || x2 >= this.p2.width || y1 < 0 || y2 >= this.p2.height) {
                                                op2 = Double.NaN;
                                                break;
                                            }
                                            double a0 = this.p2.getPixel(x1, y1);
                                            double a1 = this.p2.getPixel(x2, y1);
                                            double a2 = this.p2.getPixel(x1, y2);
                                            double a3 = this.p2.getPixel(x2, y2);
                                            if (coo.x == (double)x1) {
                                                d0 = 1.0;
                                                d1 = 0.0;
                                            } else if (coo.x == (double)x2) {
                                                d0 = 0.0;
                                                d1 = 1.0;
                                            } else {
                                                d0 = 1.0 / (coo.x - (double)x1);
                                                d1 = 1.0 / ((double)x2 - coo.x);
                                            }
                                            if (coo.y == (double)y1) {
                                                d2 = 1.0;
                                                d3 = 0.0;
                                            } else if (coo.y == (double)y2) {
                                                d2 = 0.0;
                                                d3 = 1.0;
                                            } else {
                                                d2 = 1.0 / (coo.y - (double)y1);
                                                d3 = 1.0 / ((double)y2 - coo.y);
                                            }
                                            double pA = (a0 * d0 + a1 * d1) / (d0 + d1);
                                            double pB = (a2 * d0 + a3 * d1) / (d0 + d1);
                                            op2 = (pA * d2 + pB * d3) / (d2 + d3);
                                        }
                                    }
                                }
                            }
                            if (!Double.isNaN(op2)) {
                                double d = this.fct == 0 ? pixval + op2 : (this.fct == 1 ? pixval - op2 : (pixval = this.fct == 2 ? pixval * op2 : pixval / op2));
                                if (pixval < this.dataMin) {
                                    this.dataMin = pixval;
                                }
                                if (pixval > this.dataMax) {
                                    this.dataMax = pixval;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                    this.setPixelOriginInDouble(x, y, pixval);
                }
                if (y % 100 != 0) continue;
                if (this.type != 0) {
                    this.pourcent = x * y * 100 / this.p1.getBufPixels8().length;
                    continue;
                }
                break;
            }
        }
        this.flagProcessing = false;
        if (this.fmt == 1) {
            this.fmt = 0;
        }
        if (this.headerFits != null) {
            this.headerFits.setKeyValue("BSCALE", this.bScale + "");
            this.headerFits.setKeyValue("BZERO", this.bZero + "");
        }
        this.reUseOriginalPixels();
        this.active = true;
        this.selected = true;
        Aladin.trace(3, "Algo achieved...");
        this.pourcent = -1.0;
        this.changeImgID();
        if (this.p1 != null) {
            this.p1.setLockCacheFree(false);
        }
        if (this.p2 != null) {
            this.p2.setLockCacheFree(false);
        }
        this.p2 = null;
        this.p1 = null;
        return true;
    }

    protected void convolveAndTranspose(Kernel k, double[] inPixels, double[] outPixels, int width, int height, int gap) {
        int cols = k.matrix.length;
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int index = y;
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                double pixval = 0.0;
                for (int col = -cols2; col <= cols2; ++col) {
                    int ix = x + col;
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= width) {
                        ix = width - 1;
                    }
                    pixval += inPixels[ioffset + ix] * k.gaussian[col + cols2];
                }
                outPixels[index] = pixval;
                index += height;
            }
            if (y % 100 != 0) continue;
            if (this.type == 0) break;
            this.pourcent = (gap + y * width / 2) * 100 / inPixels.length;
        }
    }
}

