/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanHips;
import cds.aladin.Tile;
import cds.aladin.TileRgb;
import cds.aladin.ViewSimple;
import cds.hipsgen.TabRgb;
import cds.moc.SMoc;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class PlanHipsRgb
extends PlanHips {
    public PlanHips red;
    public PlanHips green;
    public PlanHips blue;
    protected TabRgb tabRgb;

    protected PlanHipsRgb(Aladin aladin, TabRgb tabRgb, String label, PlanHips red, PlanHips green, PlanHips blue, Coord co, double radius) {
        super(aladin);
        this.tabRgb = tabRgb;
        this.label = label;
        this.red = red;
        this.green = green;
        this.blue = blue;
        if (red != null) {
            red.addRecutListener(this);
            if (!red.isTruePixels()) {
                red.switchFormat();
            }
        }
        if (green != null) {
            green.addRecutListener(this);
            if (!green.isTruePixels()) {
                green.switchFormat();
            }
        }
        if (blue != null) {
            blue.addRecutListener(this);
            if (!blue.isTruePixels()) {
                blue.switchFormat();
            }
        }
        this.pixMode = 0;
        this.color = true;
        this.useCache = false;
        this.local = true;
        this.id = "ALADIN/P/RGB";
        this.co = co;
        this.coRadius = this.coRadius;
        this.suite();
    }

    @Override
    protected void suite() {
        PlanHips a = this.red != null ? this.red : (this.blue != null ? this.blue : this.green);
        this.orderMin = a.orderMin;
        this.orderMax = a.orderMax;
        this.flagNoTarget = a.flagNoTarget;
        this.objet = a.objet;
        this.body = a.objet;
        this.frameOrigin = a.frameOrigin;
        this.specificProj = a.specificProj;
        this.setNewProjD(a.projd.copy());
        this.orderTile = a.orderTile;
        this.setDefaultZoom(this.co, this.coRadius);
        this.suiteSpecific();
        this.launchLoading();
    }

    @Override
    protected void suiteSpecific() {
        this.selected = true;
        this.active = true;
        this.isOldPlan = false;
        this.tileList = new PlanHips.TileList();
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.aladin.endMsg();
        this.resetStats();
    }

    protected void initTileParam(int width, int height) {
        this.naxis1 = this.width = width;
        this.naxis2 = this.height = height;
    }

    @Override
    protected boolean freePlan() {
        if (this.red != null) {
            this.red.addRecutListener(null);
        }
        if (this.green != null) {
            this.green.addRecutListener(null);
        }
        if (this.blue != null) {
            this.blue.addRecutListener(null);
        }
        return super.freePlan();
    }

    @Override
    protected boolean isLoading() {
        return false;
    }

    @Override
    public Tile askForTile(Addr cell) {
        TileRgb pixAsk = new TileRgb(this, cell);
        this.tileList.put(cell, pixAsk);
        return pixAsk;
    }

    @Override
    public boolean recut() {
        this.tabRgb.updateTables();
        this.updatePreview();
        return true;
    }

    public void updatePreview() {
        this.freeTileList();
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    @Override
    protected void tryWakeUp() {
        if (this.red != null) {
            this.red.tryWakeUp();
        }
        if (this.green != null) {
            this.green.tryWakeUp();
        }
        if (this.blue != null) {
            this.blue.tryWakeUp();
        }
    }

    @Override
    protected int getOrderMin() {
        return this.orderMin == -1 ? 0 : this.orderMin;
    }

    @Override
    protected synchronized void drawTiles(Graphics g, ViewSimple v, boolean now, BufferedImage imgb) {
        this.drawTilesNow(g, v, imgb);
    }

    @Override
    protected void drawTilesNow(Graphics g, ViewSimple v, BufferedImage imgb) {
        int i;
        long[] pix;
        int order = Math.max(this.getOrderMin(), Math.min(this.getOrderMaxInView(v), this.orderMax));
        if (v.isAllSky()) {
            pix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (i = 0; i < pix.length; ++i) {
                pix[i] = i;
            }
        } else {
            pix = this.getNpixList(v, this.getCooCentreHiPS(v), order);
        }
        for (i = 0; i < pix.length; ++i) {
            Addr cell = this.createAddr(order, pix[i], -1);
            if (this.isOutMoc(order, pix[i]) || this.isOutView(v, cell)) continue;
            Tile k = this.getTile(cell, true);
            try {
                k.resetTimer();
                k.loadNow();
                k.draw(g, v, 0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void planReadyMoc() {
        try {
            SMoc m = new SMoc();
            if (this.red != null && this.red.moc != null) {
                m = m.union(this.red.moc);
            }
            if (this.green != null && this.green.moc != null) {
                m = m.union(this.green.moc);
            }
            if (this.blue != null && this.blue.moc != null) {
                m = m.union(this.blue.moc);
            }
            this.moc = new SMoc(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

