/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.PlanHipsCat;
import cds.aladin.Source;
import cds.aladin.Tile;
import cds.aladin.TileProgen;
import cds.aladin.TileProgenAllsky;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import java.awt.Graphics;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.TreeMap;

public class PlanHipsProgen
extends PlanHipsCat {
    private TileProgenAllsky allsky;
    private boolean showFootprint = false;

    protected PlanHipsProgen(Aladin aladin) {
        super(aladin);
    }

    protected PlanHipsProgen(Aladin aladin, TreeObjDir gluSky, String label, Coord c, double radius, String startingTaskId) {
        super(aladin, gluSky, label, c, radius, startingTaskId);
    }

    @Override
    protected void setSpecificParams(TreeObjDir gluSky) {
        this.type = 18;
        this.c = Couleur.getNextDefault(this.aladin.calque);
        this.setOpacityLevel(1.0f);
        this.scanProperties();
        if (this.prop != null) {
            String s = this.prop.getProperty("hips_order_min");
            if (s == null) {
                s = this.prop.getProperty("minOrder");
            }
            if (s != null) {
                try {
                    this.orderMin = Integer.parseInt(s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.frameOrigin = 0;
        this.url = gluSky.getUrl();
        this.local = gluSky.isLocal();
        if (this.survey.equals("HpxFinder")) {
            this.survey = this.getAssociatedSurvey() + Util.FS + this.survey;
        }
        this.loadGenericLegende();
    }

    private String getAssociatedSurvey() {
        String dir = this.getAssociatedSurveyByProperties();
        if (dir == null) {
            dir = this.getAssociatedSurveByUrl();
        }
        Aladin.trace(3, "Associated HiPS survey [" + dir + "]");
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAssociatedSurveyByProperties() {
        String s = this.url.replace('\\', '/');
        int fin = s.lastIndexOf("/HpxFinder");
        if (fin == -1) {
            return null;
        }
        String propPath = s.substring(0, fin) + "/" + "properties";
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)Util.openStream(propPath), "UTF-8");
            this.prop = new MyProperties();
            this.prop.load(in);
            String label = this.prop.getProperty("label");
            if (label != null) {
                String string = label;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private String getAssociatedSurveByUrl() {
        String s = this.url.replace('\\', '/');
        int fin = s.lastIndexOf("/HpxFinder");
        int deb = s.lastIndexOf(47, fin - 1);
        String associatedSurvey = s.substring(deb + 1, fin);
        return associatedSurvey;
    }

    @Override
    protected int getTileMode() {
        return 5;
    }

    @Override
    protected boolean hasAssociatedFootprints() {
        return true;
    }

    @Override
    public Tile askForTile(Addr aadr) {
        this.readyAfterDraw = false;
        TileProgen pixAsk = new TileProgen(this, aadr);
        this.tileList.put(aadr, pixAsk);
        return pixAsk;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        this.prepareDraw(v);
        if (this.pcat == null || !this.pcat.hasObj()) {
            return;
        }
        this.pcat.draw(g, null, v, true, false, 0, 0);
    }

    protected boolean drawAllSky(ViewSimple v, TreeMap<String, Source> map, int order) {
        boolean hasDrawnSomething = false;
        if (this.allsky == null) {
            Addr addr = new Addr(order, -1L, -1);
            this.allsky = new TileProgenAllsky(this, addr);
            this.tileList.put(addr, this.allsky);
            if (this.local) {
                this.allsky.loadFromNet();
            } else {
                if (!this.useCache || !this.allsky.isCached()) {
                    this.tryWakeUp();
                    return true;
                }
                this.allsky.loadFromCache();
                this.pourcent = -1.0;
            }
        }
        if (this.allsky.getStatus() == 6) {
            boolean bl = hasDrawnSomething = this.allsky.draw(map) > 0;
            if (hasDrawnSomething) {
                this.fusion(map);
            }
        }
        return this.allsky.getStatus() != 7;
    }

    private boolean prepareDraw(ViewSimple v) {
        long[] pix = null;
        int nb = 0;
        long nLoaded = 0L;
        long nTotal = 0L;
        TreeMap<String, Source> map = new TreeMap<String, Source>();
        this.setHasMoreDetails(true);
        int order = this.getOrderMaxInView(v) + 1;
        if (order < 3) {
            order = 3;
        }
        if ((order < 3 || order < this.orderMin) && this.orderMax >= 3) {
            return false;
        }
        if (order > this.orderMax) {
            order = this.orderMax;
        }
        this.hasDrawnSomething = false;
        if (this.drawAllSky(v, map, 3)) {
            return this.hasDrawnSomething;
        }
        this.setMem();
        this.resetPriority();
        pix = this.getPixListView(v, order);
        boolean moreDetails = false;
        for (int i = 0; i < pix.length; ++i) {
            int status;
            Addr cell = this.createAddr(order, pix[i], -1);
            if (this.isOutMoc(order, pix[i]) || this.isOutView(v, cell)) continue;
            ++nTotal;
            TileProgen tile = (TileProgen)this.getTile(cell, true);
            if (tile == null || (status = tile.getStatus()) == 7) continue;
            tile.priority = 250 - this.priority++;
            if (status == 8) {
                tile.setStatus(1, true);
            }
            if (status != 6) {
                moreDetails = true;
                continue;
            }
            if ((nb += tile.draw(map)) > 0) {
                tile.resetTimer();
            }
            ++nLoaded;
        }
        this.setHasMoreDetails(moreDetails);
        this.allTilesDrawn = nTotal == nLoaded;
        this.fusion(map);
        this.hasDrawnSomething = this.hasObj();
        if (pix.length > 0) {
            this.tryWakeUp();
        }
        return this.hasDrawnSomething;
    }

    private void fusion(TreeMap<String, Source> map) {
        Pcat pcat1 = new Pcat(this);
        if (this.pcat != null && this.pcat.hasObj()) {
            Iterator<Obj> it = this.pcat.iterator();
            while (it.hasNext()) {
                Source src = (Source)it.next();
                String id = src.id + src.raj + src.dej;
                boolean isInMap = map.containsKey(id);
                if (!isInMap && !src.isSelected()) continue;
                map.put(id, src);
            }
        }
        for (Source src : map.values()) {
            if (this.showFootprint) {
                src.setShowFootprint(true, false);
            }
            pcat1.setObjetFast(src);
        }
        this.pcat = pcat1;
    }

    protected void setShowFootprint(boolean flag) {
        this.showFootprint = flag;
    }

    @Override
    protected void resetProj(int n) {
        if (this.pcat != null) {
            this.pcat.projpcat[n] = null;
        }
    }

    @Override
    protected void reallocObjetCache() {
        if (this.pcat != null) {
            this.pcat.reallocObjetCache();
        }
    }

    @Override
    protected int getNbTable() {
        return 1;
    }

    @Override
    protected boolean hasObj() {
        return this.pcat == null ? false : this.pcat.hasObj();
    }

    @Override
    protected boolean hasSources() {
        return this.hasObj();
    }

    @Override
    protected int getCounts() {
        return this.pcat == null ? 0 : this.pcat.getCount();
    }

    @Override
    protected Iterator<Obj> iterator() {
        return this.pcat == null ? null : this.pcat.iterator();
    }

    @Override
    protected Iterator<Obj> iterator(ViewSimple v) {
        return this.iterator();
    }

    @Override
    protected boolean detectServerError(int[] nb) {
        this.completude = -1.0;
        this.pourcent = -1.0;
        return false;
    }
}

