/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.PlanImageCube;
import cds.aladin.PointD;
import cds.aladin.Tile;
import cds.aladin.TileAllsky;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import cds.tools.pixtools.Addr;

public class PlanHipsCube
extends PlanHips {
    public int depth;
    protected double z = 0.0;
    protected int zInit;
    protected boolean pause;
    private double crval3;
    private double crpix3;
    private double cdelt3;
    private String cunit3;
    protected boolean fromCanal;
    protected int tileDepth;
    private static final int MAXSLICE = 50;
    private double ox = -1.0;
    private double oy = -1.0;
    private double[] bit8 = new double[10000];
    private LoadingImmediatelyThread loadingThread = null;

    protected PlanHipsCube(Aladin aladin) {
        super(aladin);
        this.type = 22;
    }

    protected PlanHipsCube(Aladin aladin, TreeObjDir gluSky, String label, Coord c, double radius, String startingTaskId) {
        super(aladin, gluSky, label, c, radius, startingTaskId);
        aladin.log(Plan.TYPE[this.type], label);
    }

    @Override
    protected void setSpecificParams(TreeObjDir gluSky) {
        super.setSpecificParams(gluSky);
        this.depth = gluSky.cubeDepth;
        this.zInit = gluSky.cubeFirstFrame;
        this.z = this.zInit;
        this.pause = true;
        this.scanCubeProperties();
    }

    @Override
    protected String getFrameLabel(int i) {
        if (!this.active) {
            return super.getFrameLabel(i);
        }
        if (this.fromCanal) {
            return this.getCanalValue(i);
        }
        String s = this.prop.getProperty("obs_title_" + i);
        if (s == null) {
            s = this.prop.getProperty("label_" + i);
        }
        return s != null ? s : this.label;
    }

    @Override
    protected int getTileDepth() {
        return this.tileDepth;
    }

    @Override
    protected int getChannel() {
        int z = (int)this.getZ();
        return z % this.tileDepth;
    }

    @Override
    protected int getChannel(ViewSimple v) {
        return this.getChannel();
    }

    protected int getChannel(Addr addr) {
        return addr.z % this.tileDepth;
    }

    @Override
    protected Addr createAddr(int order, long npix, int z) {
        int z1 = z - z % this.tileDepth;
        return new Addr(order, npix, z1);
    }

    protected String getCanalValue(int n) {
        return PlanImageCube.getCanalValue(n, this.crpix3, this.cdelt3, this.crval3, this.cunit3, false);
    }

    @Override
    protected boolean freePlan() {
        this.stopLoadingImmediately();
        return super.freePlan();
    }

    protected boolean scanCubeProperties() {
        try {
            MyProperties prop = this.loadPropertieFile();
            if (prop == null) {
                throw new Exception();
            }
            String s = prop.getProperty("hips_cube_depth");
            if (s == null) {
                s = prop.getProperty("cubeDepth");
            }
            if (s != null) {
                try {
                    this.depth = Integer.parseInt(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "PlanBGCube error on cubeDepth property [" + s + "]");
                }
            }
            s = prop.getProperty("hips_tile_depth");
            try {
                this.tileDepth = Integer.parseInt(s);
            }
            catch (Exception e1) {
                this.tileDepth = 1;
            }
            s = prop.getProperty("hips_cube_firstframe");
            if (s == null) {
                s = prop.getProperty("cubeFirstFrame");
            }
            if (s != null) {
                try {
                    this.zInit = Integer.parseInt(s);
                    this.z = this.zInit;
                }
                catch (Exception e) {
                    Aladin.trace(3, "PlanBGCube error on cubeFirstFrame property [" + s + "]");
                }
            }
            try {
                s = prop.getProperty("data_cube_crpix3");
                this.crpix3 = Double.parseDouble(s);
                s = prop.getProperty("data_cube_crval3");
                this.crval3 = Double.parseDouble(s);
                s = prop.getProperty("data_cube_cdelt3");
                this.cdelt3 = Double.parseDouble(s);
                this.fromCanal = true;
                this.cunit3 = prop.getProperty("data_cube_cunit3");
                if (this.cunit3 == null) {
                    this.cunit3 = prop.getProperty("data_cube_bunit3");
                }
            }
            catch (Exception e) {
                this.fromCanal = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected void paramByTreeNode(TreeObjDir gSky, Coord c, double radius) {
        super.paramByTreeNode(gSky, c, radius);
        this.depth = gSky.cubeDepth;
        this.z = gSky.cubeFirstFrame;
    }

    @Override
    protected void activeCubePixels(ViewSimple v) {
        if (!this.setCubeFrame(v.cubeControl.lastFrame)) {
            return;
        }
        v.cubeControl.startTime = System.currentTimeMillis();
        this.askForRepaint();
    }

    @Override
    protected boolean setCubeFrame(double frameLevel) {
        if (this.z == frameLevel) {
            return false;
        }
        this.z = frameLevel;
        return true;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        int[] n = this.aladin.view.getNumView(this);
        if (n != null) {
            for (int i : n) {
                this.aladin.view.viewSimple[n[i]].cubeControl.nbFrame = depth;
            }
        }
    }

    @Override
    protected void setZ(double initFrame) {
        this.z = initFrame;
    }

    @Override
    protected double getZ() {
        return this.z;
    }

    @Override
    protected double getZ(ViewSimple v) {
        if (v.pref == this) {
            int f = v.cubeControl.getCurrentFrameIndex();
            if (f == -1) {
                f = v.cubeControl.lastFrame = this.zInit;
            }
            return f;
        }
        return this.z;
    }

    @Override
    protected Addr createAddr(ViewSimple v, int order, long npix) {
        int z = (int)this.getZ(v);
        return new Addr(order, npix, z / this.tileDepth * this.tileDepth);
    }

    protected int getGap() {
        return this.depth < 50 ? 1 : this.depth / 50;
    }

    @Override
    protected void setPause(boolean t, ViewSimple v) {
        if (t == this.pause) {
            return;
        }
        this.pause = t;
    }

    @Override
    protected boolean isPause() {
        return this.pause;
    }

    @Override
    public int getDepth() {
        return this.depth == -1 ? 1 : this.depth;
    }

    @Override
    protected int getInitDelay() {
        return 500;
    }

    @Override
    protected byte getPixel8bit(int z, double x, double y) {
        double pix;
        ViewSimple v = this.aladin.view.getCurrentView();
        PointD p = v.getPosition(x, y);
        if (p.x != this.ox || p.y != this.oy) {
            for (int i = 0; i < this.bit8.length; ++i) {
                this.bit8[i] = Double.NaN;
            }
            this.ox = p.x;
            this.oy = p.y;
        }
        if (!Double.isNaN(this.bit8[z])) {
            pix = this.bit8[z];
            System.out.println(pix + " (from cache)");
        } else {
            pix = this.bit8[z] = this.getOnePixelFromCache(this.projd, p.x, p.y, -1, z, 3);
        }
        if (Double.isNaN(pix)) {
            pix = 0.0;
        }
        return (byte)((int)pix & 0xFF);
    }

    @Override
    protected String key(int order, long npix) {
        return this.key(order, npix, (int)this.z);
    }

    @Override
    public Tile askForTile(Addr addr) {
        if (this.isPause()) {
            return super.askForTile(addr);
        }
        this.readyAfterDraw = false;
        Tile pixAsk = new Tile(this, addr, 3);
        this.tileList.put(addr, pixAsk);
        return pixAsk;
    }

    protected void loadingImmediately(ViewSimple v) {
        this.loadingThread = new LoadingImmediatelyThread(this, v, (int)this.getZ() + 1);
        this.loadingThread.start();
    }

    protected void stopLoadingImmediately() {
        if (this.loadingThread != null) {
            this.loadingThread.abort();
        }
    }

    protected int getCurrentFrameReady() {
        if (this.isPause() || this.loadingThread == null) {
            return -1;
        }
        return this.loadingThread.getZ();
    }

    class LoadingImmediatelyThread
    extends Thread {
        private int z1 = 0;
        private boolean encore;
        private PlanHipsCube plan;
        private ViewSimple v;
        int initOrder;
        Coord center;

        LoadingImmediatelyThread(PlanHipsCube plan, ViewSimple v, int z) {
            this.plan = plan;
            this.v = v;
            this.z1 = z;
        }

        void abort() {
            this.encore = false;
        }

        int getZ() {
            return this.z1 - 1;
        }

        private boolean onZone() {
            int o = Math.min(PlanHipsCube.this.getOrderMaxInView(this.v), PlanHipsCube.this.orderMax);
            if (o != this.initOrder) {
                return false;
            }
            if (o < PlanHipsCube.this.getOrderMin() || this.v.isAllSky()) {
                return true;
            }
            Coord c = PlanHipsCube.this.getCooCentreHiPS(this.v);
            return c.al == this.center.al && c.del == this.center.del;
        }

        @Override
        public void run() {
            this.encore = true;
            block0: while (this.encore) {
                boolean lowResolution;
                int order;
                this.z1 = (int)this.plan.getZ(this.v) + 1;
                this.center = PlanHipsCube.this.getCooCentreHiPS(this.v);
                this.initOrder = order = Math.min(PlanHipsCube.this.getOrderMaxInView(this.v), PlanHipsCube.this.orderMax);
                long[] npix = null;
                boolean bl = lowResolution = this.v.isAllSky() || order <= PlanHipsCube.this.getOrderMin();
                if (!lowResolution) {
                    npix = PlanHipsCube.this.getNpixList(this.v, this.center, order);
                    for (int j = 0; j < npix.length; ++j) {
                        if (!PlanHipsCube.this.isOutMoc(order, npix[j]) && !PlanHipsCube.this.isOutView(this.v, PlanHipsCube.this.createAddr(order, npix[j], -1))) continue;
                        npix[j] = -1L;
                    }
                }
                int i = 0;
                while (i < PlanHipsCube.this.depth && this.encore) {
                    if (PlanHipsCube.this.isPause()) {
                        this.encore = false;
                        break;
                    }
                    if (this.z1 >= PlanHipsCube.this.depth) {
                        this.z1 = 0;
                    }
                    if (!this.onZone()) break;
                    if (npix == null) {
                        TileAllsky tileAllsky = new TileAllsky(this.plan, PlanHipsCube.this.createAddr(PlanHipsCube.this.getOrderMin(), -1L, this.z1), 2);
                    } else {
                        for (int j = 0; j < npix.length; ++j) {
                            Addr addr;
                            if (npix[j] == -1L || PlanHipsCube.this.tileList.get(addr = PlanHipsCube.this.createAddr(order, npix[j], this.z1)) != null) continue;
                            Tile t = new Tile(this.plan, addr, 5);
                            PlanHipsCube.this.tileList.put(addr, t);
                        }
                    }
                    if (PlanHipsCube.this.ox != -1.0) {
                        ((PlanHipsCube)PlanHipsCube.this).bit8[this.z1] = PlanHipsCube.this.getOnePixelFromCache(PlanHipsCube.this.projd, PlanHipsCube.this.ox, PlanHipsCube.this.oy, -1, this.z1, 3);
                    }
                    ++i;
                    ++this.z1;
                }
                while (this.encore && this.onZone()) {
                    this.z1 = 0;
                    if (PlanHipsCube.this.isPause()) {
                        this.encore = false;
                        continue block0;
                    }
                    Util.pause(1000);
                }
            }
        }
    }
}

