/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.SED;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.moc.FMoc;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.SFMoc;
import cds.tools.Util;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import javax.swing.SwingUtilities;

public class PlanHips3D
extends PlanHips {
    protected int orderZMax;
    protected int orderZTile;
    protected String hipsVersion;
    protected boolean isHipsSeq;
    private double freqDefault;
    private double restFreq;
    private double freqMin;
    private double freqMax;
    protected boolean hips3dProto;

    protected PlanHips3D(Aladin aladin) {
        super(aladin);
        this.type = 23;
    }

    protected PlanHips3D(Aladin aladin, TreeObjDir gluSky, String label, Coord c, double radius, String startingTaskId) {
        super(aladin, gluSky, label, c, radius, startingTaskId);
        aladin.log(Plan.TYPE[this.type], label);
    }

    @Override
    protected void setSpecificParams(TreeObjDir gluSky) {
        super.setSpecificParams(gluSky);
        this.scanCubeProperties();
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        if (prop == null) {
            prop = this.loadPropertieFile();
        }
        if (prop != null) {
            String s = prop.get("moc_sky_fraction");
            if (s != null) {
                PlanHips3D.ADD(buf, "\n* Coverage: ", PlanHips3D.getCoverageSpace(s));
            }
            try {
                s = prop.get("em_min");
                if (s != null) {
                    PlanHips3D.ADD(buf, "\n* Freq min: ", SED.getUnitFreq(SED.wave2Freq(Double.parseDouble(s)), "Hz"));
                }
                if ((s = prop.get("em_max")) != null) {
                    PlanHips3D.ADD(buf, "\n* Freq max: ", SED.getUnitFreq(SED.wave2Freq(Double.parseDouble(s)), "Hz"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int order = this.getOrderInCurrentView();
        int orderZ = this.getOrderZForOrder(order);
        PlanHips3D.ADD(buf, "\n", "* HiPS3D orders\n -space: " + order + "/" + this.orderMax + "\n -freq: " + orderZ + "/" + this.orderZMax);
    }

    @Override
    protected void scanPropertiesMore(MyProperties prop) {
        String s;
        this.restFreq = Double.NaN;
        try {
            s = prop.getProperty("obs_restfreq");
            if (s != null) {
                this.restFreq = Double.parseDouble(s);
            }
        }
        catch (NumberFormatException e) {
            this.aladin.warning("Syntax error on obs_restfreq value");
        }
        this.freqMin = Double.NaN;
        this.freqMax = Double.NaN;
        try {
            s = prop.getProperty("em_min");
            if (s != null) {
                this.freqMin = CalibFreq.wave2Freq(Double.parseDouble(s));
            }
            if ((s = prop.getProperty("em_max")) != null) {
                this.freqMax = CalibFreq.wave2Freq(Double.parseDouble(s));
            }
            if (this.freqMin > this.freqMax) {
                double x = this.freqMin;
                this.freqMin = this.freqMax;
                this.freqMax = x;
            }
        }
        catch (NumberFormatException s2) {
            // empty catch block
        }
        this.hipsVersion = prop.getProperty("hips_version");
        try {
            this.hips3dProto = this.hipsVersion.equals("1.5-proto");
            if (this.hips3dProto) {
                System.err.println("WARNING: HIPS3D proto " + this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        s = prop.getProperty("hips_initial_freq");
        if (s != null) {
            try {
                double fq;
                this.freqDefault = fq = Double.parseDouble(s);
            }
            catch (Exception e) {
                System.err.println("HiPS hips_initial_freq value error [" + s + "] -> ignored");
            }
        }
        this.isHipsSeq = prop.getProperty("dataproduct_type").indexOf("sequence-cube") >= 0;
    }

    protected double getRestFreq() {
        return this.restFreq;
    }

    @Override
    protected int getTileDepth() {
        return (int)CDSHealpix.pow2(this.getOrderZTile());
    }

    @Override
    protected int getOrderZTile() {
        return this.orderZTile;
    }

    protected int getOrderZInCurrentView() {
        return this.getOrderZInView(this.aladin.view.getCurrentView());
    }

    protected int getOrderZInView(ViewSimple v) {
        return this.getOrderZForOrder(this.getOrderInView(v));
    }

    protected int getOrderZForOrder(int order) {
        int deltaSpaceOrder = this.orderMax - order;
        int depthOrder = this.orderZMax - deltaSpaceOrder;
        if (depthOrder < 0) {
            depthOrder = 0;
        }
        return depthOrder;
    }

    protected double getFrequenceMin() {
        block4: {
            if (!Double.isNaN(this.freqMin)) {
                return this.freqMin;
            }
            if (this.moc != null) {
                try {
                    this.freqMin = this.moc.getFreqMoc().getFreqMin();
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block4;
                    e.printStackTrace();
                }
            }
        }
        return this.freqMin;
    }

    protected double getFrequenceMax() {
        block4: {
            if (!Double.isNaN(this.freqMax)) {
                return this.freqMax;
            }
            if (this.moc != null) {
                try {
                    this.freqMax = this.moc.getFreqMoc().getFreqMax();
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block4;
                    e.printStackTrace();
                }
            }
        }
        return this.freqMax;
    }

    protected double getFrequence(ViewSimple v) {
        double f = v.getFrequence();
        if (Double.isNaN(f)) {
            f = this.getFreqDefault();
            this.setFrequence(v, f);
        }
        return f;
    }

    protected void setFrequence(ViewSimple v, double freq) {
        v.setFrequence(freq, true);
    }

    protected double getFreqDefault() {
        if (this.freqDefault != 0.0) {
            return this.freqDefault;
        }
        try {
            int sorder = this.moc.getSpaceOrder();
            double[] radec = CDSHealpix.radecToPolar(new double[]{this.co.al, this.co.del});
            long npix = CDSHealpix.ang2pix_nest(sorder, radec[0], radec[1]);
            FMoc fmoc = this.moc.intersection(Moc.createMoc("s" + sorder + "/" + npix)).getFreqMoc();
            MocCell mc = fmoc.iterator().next();
            this.freqDefault = CalibFreq.pix2freq(mc.order, mc.start);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.freqDefault = (this.getFrequenceMin() + this.getFrequenceMax()) / 2.0;
        }
        return this.freqDefault;
    }

    @Override
    protected boolean isFreq() {
        return true;
    }

    @Override
    public boolean isCubeClassique() {
        return false;
    }

    @Override
    protected int getChannel(ViewSimple v) {
        try {
            return this.getChannel(v, this.getFrequence(v));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int getChannel(ViewSimple v, double freq) {
        return this.getChannel(v, this.getOrderZInView(v), freq);
    }

    protected int getChannel(ViewSimple v, int orderZ, double freq) {
        try {
            int orderZtile = this.getOrderZTile();
            int orderZFull = orderZ + orderZtile;
            long npixZFull = CalibFreq.freq2pix(orderZFull, freq);
            int tileDepth = (int)CDSHealpix.pow2(orderZtile);
            return (int)(npixZFull % (long)tileDepth);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    protected boolean isOutMoc(Addr addr) {
        int frameMoc;
        if (this.moc == null) {
            return false;
        }
        char a = this.moc.getSpaceSys().charAt(0);
        int n = a == 'G' ? 3 : (frameMoc = a == 'E' ? 2 : 0);
        if (this.frameOrigin != frameMoc) {
            return false;
        }
        boolean res = false;
        try {
            SFMoc m = new SFMoc();
            m.setSpaceSys(this.moc.getSpaceSys());
            m.add(addr.orderZ, addr.npixZ, addr.order, addr.npix);
            res = !this.moc.isIntersecting(m);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    @Override
    protected void loadInternalMoc() throws Exception {
        this.moc = this.loadInternalMoc("Moc.fits");
    }

    @Override
    protected Addr createAddr(ViewSimple v, int order, long npix) {
        Addr addr;
        block2: {
            addr = null;
            try {
                int orderZ = this.getOrderZForOrder(order);
                long npixZ = CalibFreq.freq2pix(orderZ, this.getFrequence(v));
                addr = new Addr(order, npix, orderZ, npixZ);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
        return addr;
    }

    @Override
    protected Addr createAddr(int order, long npix, int z) {
        return this.createAddr(this.aladin.view.getCurrentView(), order, npix);
    }

    protected boolean scanCubeProperties() {
        MyProperties prop = null;
        try {
            prop = this.loadPropertieFile();
            if (prop == null) {
                throw new Exception();
            }
            String s = prop.getProperty("hips_order_freq");
            this.orderZMax = Integer.parseInt(s);
            s = prop.getProperty("hips_tile_depth");
            this.orderZTile = (int)CDSHealpix.log2(Integer.parseInt(s));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean allSkyAvailable() {
        return false;
    }

    @Override
    protected boolean detectServerError(int[] nb) {
        return false;
    }

    protected void checkVersion() {
        if (this.hipsVersion == null || this.hipsVersion.equals("1.5-proto1") || this.hipsVersion.equals("1.5-proto")) {
            this.error = "Prototype HiPS3D " + this.hipsVersion + " no longer supported.\nRequire AladinProto between 12.600 and 12.635";
            Aladin.error(this.error);
        }
    }

    @Override
    protected boolean waitForPlan() {
        this.checkVersion();
        return super.waitForPlan();
    }

    @Override
    protected void planReady(boolean ready) {
        super.planReady(ready);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Util.pause(100);
                PlanHips3D.this.askForRepaint();
            }
        });
    }
}

