/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Cache;
import cds.aladin.Calib;
import cds.aladin.CalibFreq;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Fov;
import cds.aladin.FrameHeaderFits;
import cds.aladin.FrameHipsProperties;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanHipsRgb;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Server;
import cds.aladin.Tile;
import cds.aladin.TileAllsky;
import cds.aladin.TilePol;
import cds.aladin.TilePolAllsky;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewMemoItem;
import cds.aladin.ViewSimple;
import cds.aladin.stc.STCCircle;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import cds.astro.Coo;
import cds.fits.HeaderFits;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.SMoc;
import cds.tools.pixtools.Addr;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import cds.tools.pixtools.Util;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class PlanHips
extends PlanImage {
    static final boolean NOALLSKY = false;
    static final int DRAWPIXEL = 0;
    static final int DRAWPOLARISATION = 1;
    protected boolean segmentIAUConv;
    private float segmentLenFactor;
    private int segmentThickness;
    private float segmentDensityFactor;
    private Color oc;
    protected int drawMode;
    static final String CACHE = "Background";
    static long MAXCACHE = 0x400000L;
    protected static final int LIVETIME = 3000;
    protected MyProperties prop;
    protected String gluTag;
    protected String survey;
    protected String urlSuffix;
    protected String version;
    protected String url;
    protected int orderMin;
    protected int orderMax;
    protected int orderTile;
    protected TileList tileList;
    protected TileLoader loader;
    protected boolean hasDrawnSomething;
    protected boolean allTilesDrawn;
    protected boolean useCache;
    protected boolean cube;
    protected boolean color;
    protected boolean colorPNG;
    protected boolean colorUnknown;
    public boolean fitsGzipped;
    public boolean truePixels;
    public boolean inFits;
    public boolean inJPEG;
    public boolean inPNG;
    protected int frameOrigin;
    protected int frameDrawing;
    protected boolean local;
    protected boolean live;
    protected boolean loadMocNow;
    protected String pixelRange;
    protected String pixelCut;
    protected int transferFct4Fits;
    protected int transferFct4Preview;
    protected boolean flagNoTarget;
    private boolean flagWaitAllSky;
    protected boolean hasAllSky;
    protected boolean hasMoc;
    protected boolean hasHpxFinder;
    protected boolean hasHpxCounter;
    private boolean testHpxFinder;
    private boolean testHpxCounter;
    protected int[] RGBCONTROL;
    protected int[] RGBControl;
    protected boolean specificProj;
    static volatile long cacheSize = -1L;
    private static Object cacheLock = new Object();
    private int polaScaleFactor;
    protected long memSize;
    private boolean testMoc;
    protected Moc moc;
    private static final String[] SKYFRAME = new String[]{"g", "gal", "galactic", "e", "ecl", "ecliptic", "c", "equ", "equatorial"};
    private static final int MAXCHECKSITE = 3;
    private int nbCheckSite;
    private FrameHipsProperties frameHipsProperties;
    private boolean garbageJustDone;
    private PlanHipsRgb planHipsRGB;
    protected boolean flagRecut;
    protected double flagRecutRadius;
    protected Coord flagRecutCoo;
    private String cacheName;
    private String dirCache;
    private boolean flagCache;
    protected int nbReady;
    private static Thread scanCache = null;
    private static long NBFILE = 0L;
    protected int nbFlush;
    private long lastGc;
    private long lastMemP;
    private long lastMemI;
    private static int MEMREQUIREDFORGC = 0x2800000;
    private boolean memCpt;
    private boolean firstSubtil;
    private static final long[] ALLSKY = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L};
    protected static String CURRENTMODE = "";
    protected double[] RES;
    private int allSkyOrder;
    public static final int DIRSIZE = 10000;
    protected int[] xy2hpx;
    protected int[] hpx2xy;
    private long lastTouch;
    protected long lastIz;
    protected int lastOrderMax;
    private int oTileOrder;
    private boolean hasMoreDetails;
    boolean first1;
    private int lastHistID;
    private double[] histRed;
    private double[] histGreen;
    private double[] histBlue;
    protected byte[] red;
    protected byte[] green;
    protected byte[] blue;
    private Timer timer;
    boolean readyAfterDraw;
    boolean readyDone;
    protected int priority;
    protected static int nDraw1 = 0;
    protected static int nOut1 = 0;
    static final int DRAWFASTMS = 100;
    private boolean computeDrawFast;
    private boolean lastMustDrawFast;
    private static final boolean DEBUGDRAW = false;
    protected static final int MAXSTAT = 5;
    protected int nStat;
    protected long[] statTimeDisplayArray;
    private boolean first;
    private boolean fading;
    private float op;
    static final int M = 2;
    private long timerLastDrawBG;
    private int nbgzip;
    private long timegzip;
    private int nbnogzip;
    private long timenogzip;
    private int gzipMode;
    private static int THREADID = 0;
    private boolean oLoading;
    private static final int MAXTIMETOBELOADFROMNET = 1000;
    protected long cumulTimeLoadNet;
    protected long cumulTimeLoadCache;
    protected long cumulTimeWriteCache;
    protected long cumulTimeDraw;
    protected long cumulTimeStream;
    protected long cumulTimeUncmp;
    protected long cumulTimePixel;
    protected int nbLoadNet;
    protected int nbLoadCache;
    protected int nbWriteCache;
    protected int nbImgDraw;
    protected long nByteReadNet;
    protected long nByteReadCache;
    protected long nByteWriteCache;
    protected int nbImgCreated;
    protected int nbImgInBuf;
    protected int nbCreated;
    protected int nbAborted;
    protected int nbFree;

    protected void setDrawMode(int mode) {
        this.drawMode = mode;
        if (this.drawMode == 1) {
            if ((double)this.opacityLevel < 0.1) {
                this.setOpacityLevel(1.0f);
            }
            if (this.oc == null) {
                this.oc = this.c = Couleur.getNextDefault(this.aladin.calque);
            } else {
                this.c = this.oc;
            }
        } else {
            this.c = Color.black;
        }
        this.type = mode == 1 ? 17 : 16;
    }

    protected PlanHips(Aladin aladin) {
        super(aladin);
        this.segmentIAUConv = false;
        this.segmentLenFactor = 1.0f;
        this.segmentThickness = 1;
        this.segmentDensityFactor = 1.0f;
        this.oc = null;
        this.drawMode = 0;
        this.prop = null;
        this.gluTag = null;
        this.urlSuffix = null;
        this.version = "";
        this.orderMin = 3;
        this.orderMax = 14;
        this.orderTile = -1;
        this.hasDrawnSomething = false;
        this.allTilesDrawn = false;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.colorPNG = false;
        this.colorUnknown = false;
        this.fitsGzipped = false;
        this.truePixels = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.frameOrigin = 0;
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.transferFct4Fits = 3;
        this.transferFct4Preview = 3;
        this.flagNoTarget = false;
        this.hasAllSky = true;
        this.hasMoc = false;
        this.hasHpxFinder = false;
        this.hasHpxCounter = false;
        this.testHpxFinder = false;
        this.testHpxCounter = false;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.specificProj = false;
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.garbageJustDone = false;
        this.planHipsRGB = null;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastOrderMax = 3;
        this.oTileOrder = -1;
        this.hasMoreDetails = true;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.op = 0.0f;
        this.timerLastDrawBG = 0L;
        this.nbgzip = 0;
        this.timegzip = 0L;
        this.nbnogzip = 0;
        this.timenogzip = 0L;
        this.gzipMode = 0;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeUncmp = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.initCache();
        this.suiteSpecific();
        this.type = 16;
    }

    protected PlanHips(Aladin aladin, TreeObjDir to, String label, Coord c, double radius, String startingTaskId) {
        super(aladin);
        this.segmentIAUConv = false;
        this.segmentLenFactor = 1.0f;
        this.segmentThickness = 1;
        this.segmentDensityFactor = 1.0f;
        this.oc = null;
        this.drawMode = 0;
        this.prop = null;
        this.gluTag = null;
        this.urlSuffix = null;
        this.version = "";
        this.orderMin = 3;
        this.orderMax = 14;
        this.orderTile = -1;
        this.hasDrawnSomething = false;
        this.allTilesDrawn = false;
        this.useCache = true;
        this.cube = false;
        this.color = false;
        this.colorPNG = false;
        this.colorUnknown = false;
        this.fitsGzipped = false;
        this.truePixels = false;
        this.inFits = false;
        this.inJPEG = false;
        this.inPNG = false;
        this.frameOrigin = 0;
        this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
        this.live = false;
        this.loadMocNow = false;
        this.pixelRange = null;
        this.pixelCut = null;
        this.transferFct4Fits = 3;
        this.transferFct4Preview = 3;
        this.flagNoTarget = false;
        this.hasAllSky = true;
        this.hasMoc = false;
        this.hasHpxFinder = false;
        this.hasHpxCounter = false;
        this.testHpxFinder = false;
        this.testHpxCounter = false;
        this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
        this.specificProj = false;
        this.polaScaleFactor = 40;
        this.memSize = 0L;
        this.testMoc = false;
        this.nbCheckSite = 0;
        this.frameHipsProperties = null;
        this.garbageJustDone = false;
        this.planHipsRGB = null;
        this.flagRecut = true;
        this.flagRecutRadius = 0.0;
        this.flagRecutCoo = null;
        this.cacheName = null;
        this.dirCache = null;
        this.flagCache = false;
        this.nbReady = 0;
        this.nbFlush = 0;
        this.lastGc = 0L;
        this.lastMemP = 0L;
        this.lastMemI = 0L;
        this.memCpt = true;
        this.firstSubtil = true;
        this.RES = null;
        this.allSkyOrder = -1;
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.lastTouch = 0L;
        this.lastIz = -1L;
        this.lastOrderMax = 3;
        this.oTileOrder = -1;
        this.hasMoreDetails = true;
        this.first1 = false;
        this.lastHistID = -1;
        this.histRed = new double[256];
        this.histGreen = new double[256];
        this.histBlue = new double[256];
        this.timer = null;
        this.readyAfterDraw = false;
        this.readyDone = false;
        this.priority = 0;
        this.computeDrawFast = true;
        this.lastMustDrawFast = true;
        this.nStat = 0;
        this.statTimeDisplayArray = new long[5];
        this.first = true;
        this.fading = false;
        this.op = 0.0f;
        this.timerLastDrawBG = 0L;
        this.nbgzip = 0;
        this.timegzip = 0L;
        this.nbnogzip = 0;
        this.timenogzip = 0L;
        this.gzipMode = 0;
        this.oLoading = false;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeDraw = 0L;
        this.cumulTimeStream = 0L;
        this.cumulTimeUncmp = 0L;
        this.cumulTimePixel = 0L;
        this.nbLoadNet = 0;
        this.nbLoadCache = 0;
        this.nbWriteCache = 0;
        this.nbImgDraw = 0;
        this.nByteReadNet = 0L;
        this.nByteReadCache = 0L;
        this.nByteWriteCache = 0L;
        this.nbImgCreated = 0;
        this.nbImgInBuf = 0;
        this.nbCreated = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.startingTaskId = startingTaskId;
        this.initCache();
        this.gluTag = to.getID();
        this.id = to.internalId;
        this.url = to.getUrl();
        this.survey = to.label;
        this.version = to.version;
        this.orderMin = to.minOrder;
        this.orderMax = to.maxOrder;
        this.useCache = to.useCache();
        this.local = to.local;
        this.loadMocNow = to.loadMocNow();
        this.frameOrigin = to.frame;
        this.description = to.description;
        this.verboseDescr = to.verboseDescr;
        this.ack = to.ack;
        this.copyright = to.copyright;
        this.copyrightUrl = to.copyrightUrl;
        this.co = c;
        this.coRadius = radius;
        if (label != null && label.trim().length() > 0) {
            this.setLabel(label);
        }
        this.setSpecificParams(to);
        Aladin.trace(3, "HiPS creation: " + to.toString1() + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected void initTileParam(int width, int height, int bitpix, byte[] pixelsOrigin, byte[] pixels) {
        if (this.color) {
            return;
        }
        this.pixelsOrigin = pixelsOrigin;
        this.pixels = pixels;
        this.bitpix = bitpix;
        this.nbytes = Math.abs(bitpix) / 8;
        this.naxis1 = this.width = width;
        this.naxis2 = this.height = height;
        if (this.hasRecutListener()) {
            this.getRecutListener().initTileParam(width, height);
        }
    }

    private void resetCache() {
        String dirname = this.getCacheDir() + cds.tools.Util.FS + this.getCacheName();
        File f = new File(dirname);
        for (int i = 1; i < 10 && !f.renameTo(new File(this.getCacheDir() + cds.tools.Util.FS + this.getCacheName() + "." + i + ".old")); ++i) {
        }
        new File(this.getCacheDir() + cds.tools.Util.FS + this.getCacheName()).mkdir();
        Aladin.trace(3, "HEALPix local cache for " + this.getCacheName() + " is out of date => renamed => will be removed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyProperties loadPropertieFile() {
        if (this.prop != null) {
            return this.prop;
        }
        String dateRef = null;
        boolean local = !this.url.startsWith("http:") && !this.url.startsWith("https:") && !this.url.startsWith("ftp:");
        try {
            InputStream in = null;
            if (local) {
                in = new FileInputStream(new File(this.url + cds.tools.Util.FS + "properties"));
            } else {
                File f;
                block25: {
                    String cacheFile = this.getCacheDir() + cds.tools.Util.FS + this.getCacheName() + cds.tools.Util.FS + "properties";
                    f = new File(cacheFile);
                    String urlFile = this.url + "/" + "properties";
                    if (this.isDynHips()) {
                        urlFile = urlFile + "?" + this.urlSuffix;
                        System.out.println("Scanning for " + urlFile);
                    }
                    HttpURLConnection conn = (HttpURLConnection)new URL(urlFile).openConnection();
                    if (this.useCache && f.exists()) {
                        conn.setIfModifiedSince(f.lastModified());
                        this.prop = new MyProperties();
                        InputStreamReader in1 = new InputStreamReader(new FileInputStream(f));
                        this.prop.load(in1, true, false);
                        in1.close();
                        dateRef = this.prop.getProperty("hips_release_date");
                        if (dateRef == null) {
                            dateRef = this.prop.getProperty("processingDate", "");
                        }
                    }
                    try (MyInputStream dis = null;){
                        in = conn.getInputStream();
                        int code = conn.getResponseCode();
                        if (code == 304) {
                            throw new Exception();
                        }
                        if (!this.useCache) break block25;
                        dis = new MyInputStream(in);
                        byte[] buf = dis.readFully();
                        dis.close();
                        this.prop = new MyProperties();
                        InputStreamReader in1 = new InputStreamReader(new ByteArrayInputStream(buf));
                        this.prop.load(in1, true, false);
                        in1.close();
                        String dateRef1 = this.prop.getProperty("hips_release_date");
                        if (dateRef1 == null) {
                            dateRef1 = this.prop.getProperty("processingDate", "");
                        }
                        if (dateRef1.equals(dateRef)) {
                            throw new Exception();
                        }
                        try (RandomAccessFile fcache = null;){
                            this.resetCache();
                            f = new File(cacheFile);
                            fcache = new RandomAccessFile(f, "rw");
                            fcache.write(buf);
                        }
                    }
                }
                if (f.exists()) {
                    in = new FileInputStream(f);
                }
            }
            if (in == null) {
                throw new Exception();
            }
            this.prop = new MyProperties();
            this.prop.load(new InputStreamReader(in), true, false);
            ((InputStream)in).close();
        }
        catch (Exception e) {
            this.prop = null;
        }
        return this.prop;
    }

    static final void touch(File f) {
        f.setLastModified(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanMetadata() {
        MyInputStream in = null;
        try {
            in = cds.tools.Util.openAnyStream(this.url + cds.tools.Util.FS + "metadata.txt");
            byte[] res = in.readFully();
            HeaderFits h = new HeaderFits();
            h.readFreeHeader(new String(res));
            this.headerFits = new FrameHeaderFits(h);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static String getHiPSID(MyProperties prop) {
        String s = prop.getProperty("creator_did");
        if (s == null) {
            s = prop.getProperty("publisher_did");
        }
        if (s == null && (s = prop.getProperty("obs_id")) != null) {
            String s1 = prop.getProperty("creator_id");
            if (s1 == null) {
                s1 = prop.getProperty("publisher_id");
            }
            s = s1 != null ? s1 + "?" + s : null;
        }
        if (s == null) {
            s = prop.getProperty("id");
        }
        if (s.startsWith("ivo://")) {
            s = s.substring(6);
        }
        return s;
    }

    protected boolean checkSite() {
        boolean lookForFaster;
        boolean bl = lookForFaster = !this.aladin.glu.checkSiteHistory(this.gluTag);
        if (!lookForFaster) {
            try {
                URL u = this.aladin.glu.getURL(this.gluTag, "", false, true, 1);
                if (u != null) {
                    this.url = u.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lookForFaster;
    }

    protected boolean scanProperties() {
        boolean rep = true;
        boolean alternative = true;
        boolean lookForFaster = false;
        if (!(this.local || this.id != null && this.id.startsWith("DIRECT/"))) {
            URL u;
            lookForFaster = this.checkSite();
            URL uRL = u = this.gluTag == null ? null : this.aladin.glu.getURL(this.gluTag, "", false, false, 2);
            if (u == null) {
                alternative = false;
            }
        }
        if (!this.scanProperties1() && alternative) {
            Aladin.trace(3, "HiPS server unreachable [" + this.url + "] ! Trying another...");
            this.checkSite(false);
            rep = this.scanProperties1();
        } else if (alternative && lookForFaster) {
            Aladin.trace(3, "HiPS server OK [" + this.url + "], looking for a faster...");
            new Thread(){

                @Override
                public void run() {
                    PlanHips.this.checkSite(false);
                }
            }.start();
        }
        return rep;
    }

    private boolean scanProperties1() {
        try {
            int i2;
            String s;
            MyProperties prop = this.loadPropertieFile();
            if (prop == null) {
                throw new Exception();
            }
            Aladin.trace(4, "PlanBG.setSpecificParams() found a \"properties\" file");
            int frame = -1;
            String strFrame = prop.getProperty("hips_frame", "X");
            if (strFrame.equals("equatorial") || this.isPlanet(strFrame)) {
                frame = 0;
            } else if (strFrame.equals("galactic")) {
                frame = 3;
            } else if (strFrame.equals("ecliptic")) {
                frame = 2;
            }
            if (this.isPlanet(strFrame)) {
                this.setBody(strFrame.trim().toLowerCase());
            } else {
                this.setBody("sky");
            }
            if (strFrame.equals("X")) {
                strFrame = prop.getProperty("coordsys", "X");
                char c1 = strFrame.charAt(0);
                if (c1 == 'C' || c1 == 'Q') {
                    frame = 0;
                } else if (c1 == 'E') {
                    frame = 2;
                } else if (c1 == 'G') {
                    frame = 3;
                }
            }
            if (frame != -1 && frame != this.frameOrigin) {
                Aladin.trace(1, "Coordinate frame found in properties file (" + Localisation.getFrameName(frame) + ") differs from the remote information (" + Localisation.getFrameName(this.frameOrigin) + ") => assume " + Localisation.getFrameName(frame));
                this.frameOrigin = frame;
            }
            if ((s = prop.getProperty("obs_title")) == null) {
                s = prop.getProperty("description");
            }
            if (s != null) {
                this.description = s;
            }
            if ((s = prop.getProperty("obs_description")) == null) {
                s = prop.getProperty("verboseDescription");
            }
            if (s != null) {
                this.verboseDescr = s;
            }
            if ((s = prop.getProperty("obs_ack")) == null) {
                s = prop.getProperty("acknowledgement");
            }
            if (s != null) {
                this.ack = s;
            }
            if ((s = prop.getProperty("obs_copyright")) == null) {
                s = prop.getProperty("copyright");
            }
            if (s != null) {
                this.copyright = s;
            }
            if ((s = prop.getProperty("obs_copyright_url")) == null) {
                s = prop.getProperty("copyrightUrl");
            }
            if (s != null) {
                this.copyrightUrl = s;
            }
            if ((s = prop.getProperty("hips_data_minmax")) != null) {
                this.pixelRange = s;
            } else {
                s = prop.getProperty("hips_data_range");
                if (s == null) {
                    s = prop.getProperty("pixelRange");
                }
                if (s != null) {
                    this.pixelRange = s;
                }
            }
            s = prop.getProperty("hips_pixel_cut");
            if (s == null) {
                s = prop.getProperty("pixelCut");
            }
            if (s != null) {
                this.pixelCut = s;
            }
            if ((s = prop.getProperty("hips_pixel_function")) != null && (i2 = cds.tools.Util.indexInArrayOf(s, TRANSFERTFCT, true)) >= 0) {
                this.transferFct4Fits = i2;
            }
            this.id = PlanHips.getHiPSID(prop);
            s = prop.getProperty("hips_order");
            if (s == null) {
                s = prop.getProperty("maxOrder");
            }
            if (s != null) {
                try {
                    this.orderMax = Integer.parseInt(s);
                }
                catch (Exception i2) {
                    // empty catch block
                }
            }
            if ((s = prop.getProperty("hips_order_min")) == null) {
                s = prop.getProperty("minOrder");
            }
            if (s != null) {
                try {
                    this.orderMin = Integer.parseInt(s);
                }
                catch (Exception i2) {
                    // empty catch block
                }
            }
            if ((s = prop.getProperty("hips_tile_width")) != null) {
                try {
                    int w = Integer.parseInt(s);
                    this.orderTile = (int)CDSHealpix.log2(w);
                }
                catch (Exception w) {}
            } else {
                s = prop.getProperty("tileOrder");
                if (s != null) {
                    try {
                        this.orderTile = Integer.parseInt(s);
                    }
                    catch (Exception w) {
                        // empty catch block
                    }
                }
            }
            if ((s = prop.getProperty("hips_tile_depth")) != null) {
                try {
                    int d = Integer.parseInt(s);
                    this.setOrderTile((int)CDSHealpix.log2(d));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((s = prop.getProperty("dataproduct_subtype")) != null && s.indexOf("live") >= 0) {
                this.live = true;
            }
            this.scanPropertiesMore(prop);
        }
        catch (Exception e) {
            Aladin.trace(3, "No properties file found ...");
            return false;
        }
        return true;
    }

    protected void scanPropertiesMore(MyProperties prop) {
    }

    protected void setSpecificParams(TreeObjDir gluSky) {
        this.type = 16;
        this.video = this.aladin.configuration.getCMVideo();
        this.inFits = gluSky.isFits();
        this.inJPEG = gluSky.isJPEG();
        this.inPNG = gluSky.isPNG();
        this.truePixels = gluSky.isTruePixels();
        this.color = gluSky.isColored();
        this.cube = gluSky.isCube();
        this.scanProperties();
        this.scanMetadata();
        gluSky.reset();
    }

    protected int getTileMode() {
        if (this.isTruePixels()) {
            return 1;
        }
        if (this.inPNG) {
            return 4;
        }
        return 0;
    }

    public PlanHips(Aladin aladin, String path, String label, Coord c, double radius, String startingTaskId) {
        TreeObjDir gsky;
        block2: {
            super(aladin);
            this.segmentIAUConv = false;
            this.segmentLenFactor = 1.0f;
            this.segmentThickness = 1;
            this.segmentDensityFactor = 1.0f;
            this.oc = null;
            this.drawMode = 0;
            this.prop = null;
            this.gluTag = null;
            this.urlSuffix = null;
            this.version = "";
            this.orderMin = 3;
            this.orderMax = 14;
            this.orderTile = -1;
            this.hasDrawnSomething = false;
            this.allTilesDrawn = false;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.colorPNG = false;
            this.colorUnknown = false;
            this.fitsGzipped = false;
            this.truePixels = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.frameOrigin = 0;
            this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
            this.live = false;
            this.loadMocNow = false;
            this.pixelRange = null;
            this.pixelCut = null;
            this.transferFct4Fits = 3;
            this.transferFct4Preview = 3;
            this.flagNoTarget = false;
            this.hasAllSky = true;
            this.hasMoc = false;
            this.hasHpxFinder = false;
            this.hasHpxCounter = false;
            this.testHpxFinder = false;
            this.testHpxCounter = false;
            this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
            this.specificProj = false;
            this.polaScaleFactor = 40;
            this.memSize = 0L;
            this.testMoc = false;
            this.nbCheckSite = 0;
            this.frameHipsProperties = null;
            this.garbageJustDone = false;
            this.planHipsRGB = null;
            this.flagRecut = true;
            this.flagRecutRadius = 0.0;
            this.flagRecutCoo = null;
            this.cacheName = null;
            this.dirCache = null;
            this.flagCache = false;
            this.nbReady = 0;
            this.nbFlush = 0;
            this.lastGc = 0L;
            this.lastMemP = 0L;
            this.lastMemI = 0L;
            this.memCpt = true;
            this.firstSubtil = true;
            this.RES = null;
            this.allSkyOrder = -1;
            this.xy2hpx = null;
            this.hpx2xy = null;
            this.lastTouch = 0L;
            this.lastIz = -1L;
            this.lastOrderMax = 3;
            this.oTileOrder = -1;
            this.hasMoreDetails = true;
            this.first1 = false;
            this.lastHistID = -1;
            this.histRed = new double[256];
            this.histGreen = new double[256];
            this.histBlue = new double[256];
            this.timer = null;
            this.readyAfterDraw = false;
            this.readyDone = false;
            this.priority = 0;
            this.computeDrawFast = true;
            this.lastMustDrawFast = true;
            this.nStat = 0;
            this.statTimeDisplayArray = new long[5];
            this.first = true;
            this.fading = false;
            this.op = 0.0f;
            this.timerLastDrawBG = 0L;
            this.nbgzip = 0;
            this.timegzip = 0L;
            this.nbnogzip = 0;
            this.timenogzip = 0L;
            this.gzipMode = 0;
            this.oLoading = false;
            this.cumulTimeLoadNet = 0L;
            this.cumulTimeLoadCache = 0L;
            this.cumulTimeWriteCache = 0L;
            this.cumulTimeDraw = 0L;
            this.cumulTimeStream = 0L;
            this.cumulTimeUncmp = 0L;
            this.cumulTimePixel = 0L;
            this.nbLoadNet = 0;
            this.nbLoadCache = 0;
            this.nbWriteCache = 0;
            this.nbImgDraw = 0;
            this.nByteReadNet = 0L;
            this.nByteReadCache = 0L;
            this.nByteWriteCache = 0L;
            this.nbImgCreated = 0;
            this.nbImgInBuf = 0;
            this.nbCreated = 0;
            this.nbAborted = 0;
            this.nbFree = 0;
            this.startingTaskId = startingTaskId;
            this.initCache();
            Aladin.trace(2, "Creating HiPS plane [" + path + "]");
            this.type = 16;
            this.video = aladin.configuration.getCMVideo();
            File f = new File(path);
            this.url = f.getAbsolutePath();
            this.survey = f.getName();
            this.orderMax = 3;
            this.useCache = false;
            this.label = label;
            gsky = null;
            try {
                gsky = new TreeObjDir(aladin, this.url);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
        this.paramByTreeNode(gsky, c, radius);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "HiPS local... frame=" + Localisation.getFrameName(this.frameOrigin) + " " + this + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected PlanHips(Aladin aladin, URL u, String label, Coord c, double radius, String startingTaskId) {
        TreeObjDir gsky;
        block3: {
            super(aladin);
            this.segmentIAUConv = false;
            this.segmentLenFactor = 1.0f;
            this.segmentThickness = 1;
            this.segmentDensityFactor = 1.0f;
            this.oc = null;
            this.drawMode = 0;
            this.prop = null;
            this.gluTag = null;
            this.urlSuffix = null;
            this.version = "";
            this.orderMin = 3;
            this.orderMax = 14;
            this.orderTile = -1;
            this.hasDrawnSomething = false;
            this.allTilesDrawn = false;
            this.useCache = true;
            this.cube = false;
            this.color = false;
            this.colorPNG = false;
            this.colorUnknown = false;
            this.fitsGzipped = false;
            this.truePixels = false;
            this.inFits = false;
            this.inJPEG = false;
            this.inPNG = false;
            this.frameOrigin = 0;
            this.frameDrawing = this.aladin != null && this.aladin.configuration != null ? this.aladin.configuration.getFrameDrawing() : 0;
            this.live = false;
            this.loadMocNow = false;
            this.pixelRange = null;
            this.pixelCut = null;
            this.transferFct4Fits = 3;
            this.transferFct4Preview = 3;
            this.flagNoTarget = false;
            this.hasAllSky = true;
            this.hasMoc = false;
            this.hasHpxFinder = false;
            this.hasHpxCounter = false;
            this.testHpxFinder = false;
            this.testHpxCounter = false;
            this.RGBCONTROL = new int[]{0, 128, 255, 0, 128, 255, 0, 128, 255};
            this.specificProj = false;
            this.polaScaleFactor = 40;
            this.memSize = 0L;
            this.testMoc = false;
            this.nbCheckSite = 0;
            this.frameHipsProperties = null;
            this.garbageJustDone = false;
            this.planHipsRGB = null;
            this.flagRecut = true;
            this.flagRecutRadius = 0.0;
            this.flagRecutCoo = null;
            this.cacheName = null;
            this.dirCache = null;
            this.flagCache = false;
            this.nbReady = 0;
            this.nbFlush = 0;
            this.lastGc = 0L;
            this.lastMemP = 0L;
            this.lastMemI = 0L;
            this.memCpt = true;
            this.firstSubtil = true;
            this.RES = null;
            this.allSkyOrder = -1;
            this.xy2hpx = null;
            this.hpx2xy = null;
            this.lastTouch = 0L;
            this.lastIz = -1L;
            this.lastOrderMax = 3;
            this.oTileOrder = -1;
            this.hasMoreDetails = true;
            this.first1 = false;
            this.lastHistID = -1;
            this.histRed = new double[256];
            this.histGreen = new double[256];
            this.histBlue = new double[256];
            this.timer = null;
            this.readyAfterDraw = false;
            this.readyDone = false;
            this.priority = 0;
            this.computeDrawFast = true;
            this.lastMustDrawFast = true;
            this.nStat = 0;
            this.statTimeDisplayArray = new long[5];
            this.first = true;
            this.fading = false;
            this.op = 0.0f;
            this.timerLastDrawBG = 0L;
            this.nbgzip = 0;
            this.timegzip = 0L;
            this.nbnogzip = 0;
            this.timenogzip = 0L;
            this.gzipMode = 0;
            this.oLoading = false;
            this.cumulTimeLoadNet = 0L;
            this.cumulTimeLoadCache = 0L;
            this.cumulTimeWriteCache = 0L;
            this.cumulTimeDraw = 0L;
            this.cumulTimeStream = 0L;
            this.cumulTimeUncmp = 0L;
            this.cumulTimePixel = 0L;
            this.nbLoadNet = 0;
            this.nbLoadCache = 0;
            this.nbWriteCache = 0;
            this.nbImgDraw = 0;
            this.nByteReadNet = 0L;
            this.nByteReadCache = 0L;
            this.nByteWriteCache = 0L;
            this.nbImgCreated = 0;
            this.nbImgInBuf = 0;
            this.nbCreated = 0;
            this.nbAborted = 0;
            this.nbFree = 0;
            this.startingTaskId = startingTaskId;
            this.initCache();
            Aladin.trace(2, "Creating HiPS HTTP plane [" + u + "]");
            this.type = 16;
            this.video = aladin.configuration.getCMVideo();
            this.url = u.toString();
            this.url = this.checkDynHips(this.url);
            this.orderMax = 3;
            this.useCache = true;
            this.local = false;
            this.co = c;
            this.coRadius = radius;
            gsky = null;
            try {
                gsky = new TreeObjDir(aladin, this.url);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        this.paramByTreeNode(gsky, c, radius);
        int n = this.url.length();
        if (this.url.endsWith("/")) {
            --n;
        }
        this.survey = this.label != null && this.label.length() > 0 ? this.label : this.url.substring(this.url.lastIndexOf(47, n - 1) + 1, n);
        this.scanProperties();
        this.scanMetadata();
        Aladin.trace(3, "HiPS http... " + this + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected boolean isDynHips() {
        return this.urlSuffix != null;
    }

    protected String checkDynHips(String url) {
        int i = url.indexOf("_HIPS_");
        if (i < 0) {
            return url;
        }
        this.urlSuffix = url.substring(i + 7);
        if ((url = url.substring(0, i)).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        this.id = "DIRECT/" + System.currentTimeMillis() / 1000L;
        Aladin.trace(1, "Dynamical HiPS detected ! id=" + this.id + " param=[" + this.urlSuffix + "]");
        return url;
    }

    protected void paramByTreeNode(TreeObjDir gSky, Coord c, double radius) {
        if (this.label != null && this.label.trim().length() > 0) {
            this.setLabel(this.label);
        } else {
            this.setLabel(gSky.label);
        }
        this.orderMax = gSky.getMaxOrder();
        this.inFits = gSky.isFits();
        this.inJPEG = gSky.isJPEG();
        this.inPNG = gSky.isPNG();
        this.truePixels = gSky.isTruePixels();
        this.color = gSky.isColored();
        this.cube = gSky.isCube();
        this.frameOrigin = gSky.getFrame();
        this.orderTile = gSky.getLosangeOrder();
        this.local = gSky.isLocal();
        this.loadMocNow = gSky.loadMocNow();
        this.version = gSky.getVersion();
        this.useCache = !this.local && gSky.useCache();
        this.co = c != null ? c : gSky.getTarget();
        this.coRadius = c != null ? radius : gSky.getRadius();
    }

    @Override
    protected String getPixelInfoFromGrey(int greyLevel, int mode) {
        if (this.truePixels) {
            return super.getPixelInfoFromGrey(greyLevel, mode);
        }
        return "";
    }

    protected boolean hasMoc() {
        if (this.hasMoc || this.testMoc) {
            return this.hasMoc;
        }
        String s = this.getProperty("moc_access_url");
        if (s != null) {
            this.testMoc = true;
            this.hasMoc = true;
        } else {
            String moc = this.url + "/" + "Moc.fits";
            this.hasMoc = this.local ? new File(moc).exists() : cds.tools.Util.isUrlResponding(moc);
            this.testMoc = true;
        }
        return this.hasMoc;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        String s;
        if (prop != null && (s = prop.get("moc_sky_fraction")) != null) {
            PlanHips.ADD(buf, "\n* Coverage: ", PlanHips.getCoverageSpace(s));
        }
        PlanHips.ADD(buf, "\n", "* HiPS order: " + this.getOrderInCurrentView() + "/" + this.orderMax);
    }

    protected String getProperty(String key) {
        return this.prop == null ? null : this.prop.getProperty(key);
    }

    protected boolean hasHpxFinder() {
        if (this.hasHpxFinder || this.testHpxFinder) {
            return this.hasHpxFinder;
        }
        String s = this.getProperty("hips_progenitor_url");
        if (s != null) {
            this.testHpxFinder = true;
            this.hasHpxFinder = true;
        } else {
            String f = this.url + "/" + "HpxFinder" + "/" + "metadata.xml";
            this.hasHpxFinder = this.local ? new File(f).exists() : cds.tools.Util.isUrlResponding(f);
            this.testHpxFinder = true;
        }
        return this.hasHpxFinder;
    }

    protected boolean hasHpxCounter() {
        if (this.hasHpxCounter || this.testHpxCounter) {
            return this.hasHpxCounter;
        }
        String s = this.getProperty("hips_progenitor_url");
        if (s != null) {
            this.testHpxCounter = true;
            this.hasHpxCounter = true;
        } else {
            String f = this.url + "/" + "HpxCounter" + "/" + "properties";
            this.hasHpxCounter = this.local ? new File(f).exists() : cds.tools.Util.isUrlResponding(f);
            this.testHpxCounter = true;
        }
        return this.hasHpxCounter;
    }

    protected void loadMoc() {
        if (this.moc == null) {
            try {
                this.loadInternalMoc();
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return;
            }
        }
        this.aladin.calque.newPlanMOC(this.moc, this.label + " MOC", this.getUrl() + "/" + "Moc.fits");
    }

    protected void loadInternalMoc() throws Exception {
        Moc moc = this.loadInternalMoc("Moc.fits");
        if (moc instanceof SMoc) {
            this.moc = moc;
            ((SMoc)this.moc).setMinOrder(3);
            this.removeTilesOutsideMoc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Moc loadInternalMoc(String mocName) throws Exception {
        Moc moc = null;
        String fcache = this.getCacheDir() + "/" + this.getCacheName() + "/" + mocName;
        if (!this.local && this.useCache && new File(fcache).exists()) {
            try (InputStream in = null;){
                in = new BufferedInputStream(new FileInputStream(fcache));
                moc = Moc.createMoc(in);
                Aladin.trace(3, "Loading " + this.id + " " + mocName + " from cache");
            }
            return moc;
        }
        String f = this.getUrl() + "/" + mocName;
        try (MyInputStream mis = null;){
            mis = cds.tools.Util.openAnyStream(f);
            moc = Moc.createMoc(mis);
            Aladin.trace(3, "Loading " + this.id + " " + mocName + " from net");
        }
        if (!this.local && this.useCache && moc != null) {
            moc.write(fcache);
            Aladin.trace(3, "Saving " + this.survey + " MOC in cache");
        }
        return moc;
    }

    private void removeTilesOutsideMoc() {
        block8: {
            SMoc moc1;
            if (this.moc == null) {
                return;
            }
            try {
                moc1 = this.moc.getSpaceMoc();
            }
            catch (Exception e2) {
                if (Aladin.levelTrace >= 3) {
                    e2.printStackTrace();
                }
                return;
            }
            Enumeration e = this.tileList.keys();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                Tile h = (Tile)this.tileList.get(k);
                if (h == null || h.addr.npix == -1L || moc1.isIntersecting(h.addr.order, h.addr.npix)) continue;
                h.abort();
                this.tileList.remove(k);
            }
            if ((this.co == null || this.flagNoTarget) && !moc1.isEmpty() && this.frameOrigin == 0) {
                try {
                    MocCell cell = moc1.iterator().next();
                    double[] res = CDSHealpix.pix2ang_nest(cell.order, cell.start);
                    double[] radec = CDSHealpix.polarToRadec(new double[]{res[0], res[1]});
                    this.co = new Coord(radec[0], radec[1]);
                }
                catch (Exception e1) {
                    if (Aladin.levelTrace < 3) break block8;
                    e1.printStackTrace();
                }
            }
        }
    }

    protected void loadProgen() {
        String s = this.getProperty("hips_progenitor_url");
        if (s == null) {
            s = this.url + "/" + "HpxFinder";
        }
        this.aladin.execAsyncCommand("'Details " + this.label + "'=load " + s);
    }

    protected void loadCounter() {
        String s = this.getProperty("HpxCounter");
        if (s == null) {
            s = this.url + "/" + "HpxCounter";
        }
        this.aladin.execAsyncCommand("'Count " + this.label + "'=load " + s);
    }

    protected int getFrameDrawing() {
        return this.frameDrawing;
    }

    protected void setFrameDrawing(int frame) {
        this.frameDrawing = frame;
        if (this.projd.frame != this.getCurrentFrameDrawing()) {
            this.projd.frame = this.getCurrentFrameDrawing();
            this.syncProjLocal();
            this.aladin.view.repaintAll();
        }
    }

    @Override
    protected void syncProjLocal() {
        Coord c;
        int j;
        int m = this.aladin.view.getNbView();
        for (j = 0; j < m; ++j) {
            ViewSimple v = this.aladin.view.viewSimple[j];
            if (v.pref != this) continue;
            c = v.projLocal.getProjCenter();
            v.projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                c = Localisation.frameToFrame(c, 0, this.projd.frame);
            }
            v.projLocal.modify(this.projd.label, this.projd.modeCalib, c.al, c.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
            v.newView(1);
        }
        for (j = this.aladin.view.viewMemo.size() - 1; j >= 0; --j) {
            ViewMemoItem memo = this.aladin.view.viewMemo.memo[j];
            if (memo == null || memo.pref != this) continue;
            c = memo.projLocal.getProjCenter();
            memo.projLocal.frame = this.projd.frame;
            if (this.projd.frame != 0) {
                c = Localisation.frameToFrame(c, 0, this.projd.frame);
            }
            memo.projLocal.modify(this.projd.label, this.projd.modeCalib, c.al, c.del, this.projd.rm, this.projd.rm, this.projd.cx, this.projd.cy, this.projd.r, this.projd.r, this.projd.rot, this.projd.sym, this.projd.t, this.projd.system);
        }
    }

    protected int getCurrentFrameDrawing() {
        if (this.frameDrawing == 0) {
            return this.aladin.localisation.getFrame();
        }
        return cds.tools.Util.indexInArrayOf(Localisation.FRAME[this.frameDrawing], Localisation.REPERE);
    }

    public int getFrameOrigin() {
        return this.frameOrigin;
    }

    protected static boolean isPlanHipsFinder(String path) {
        File f = new File(path);
        return f.getName().equals("HpxFinder") && f.isDirectory();
    }

    protected void suite() {
        boolean isAPlanet;
        if (this.label == null || this.label.trim().length() == 0) {
            this.setLabel(this.id != null ? this.id : this.survey);
        }
        int defaultProjType = this.aladin.projSelector.getProjType();
        if (this.co == null) {
            this.flagNoTarget = true;
            this.co = new Coord(0.0, 0.0);
            this.co = Localisation.frameToFrame(this.co, this.aladin.localisation.getFrame(), 0);
            this.coRadius = 220.0;
        }
        if (this.coRadius <= 0.0) {
            this.coRadius = 220.0;
        }
        this.objet = this.co + "";
        boolean isPanorama = this.isPanorama();
        boolean longAsc = isAPlanet = this.isPlanet();
        int projection = isPanorama ? 17 : (isAPlanet ? 1 : defaultProjType);
        this.specificProj = isAPlanet;
        Projection p = new Projection("hips", 2, this.co.al, this.co.del, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, longAsc, projection, Calib.FK5, this);
        p.frame = this.getCurrentFrameDrawing();
        this.setNewProjD(p);
        this.typeCM = this.aladin.configuration.getCMMap();
        this.transferFct4Preview = this.aladin.configuration.getCMFct();
        this.transfertFct = this.truePixels ? this.transferFct4Fits : this.transferFct4Preview;
        this.video = this.aladin.configuration.getCMVideo();
        if (Aladin.levelTrace == 6) {
            System.err.println("WARNING: Cache off for perf tests on " + this.id);
            this.useCache = false;
        }
        this.setDefaultZoom(this.co, this.coRadius);
        this.suiteSpecific();
        this.launchLoading();
    }

    protected void launchLoading() {
        this.threading();
        this.log();
    }

    @Override
    protected boolean hasSpecificProj() {
        return this.specificProj;
    }

    protected void setSpecificProj(boolean flag) {
        this.specificProj = flag;
    }

    protected String getHipsFrame() {
        String frame;
        if (this.prop != null && (frame = this.prop.getProperty("hips_frame")) != null) {
            return frame;
        }
        return Localisation.getFrameName(this.frameOrigin);
    }

    protected boolean isPanorama() {
        if (this.prop == null) {
            return false;
        }
        String s = this.prop.getProperty("hips_frame");
        if (!this.isPlanet(s)) {
            return false;
        }
        return this.id.toLowerCase().indexOf("/pan") >= 0 || s.toLowerCase().indexOf("pan") >= 0;
    }

    protected boolean isPlanet() {
        if (this.prop == null) {
            return false;
        }
        String s = this.prop.getProperty("hips_frame");
        return this.isPlanet(s);
    }

    protected boolean isPlanet(String frame) {
        return frame != null && cds.tools.Util.indexInArrayOf(frame, SKYFRAME, true) < 0;
    }

    protected String getPlanetSys() {
        if (!this.isPlanet()) {
            return null;
        }
        return this.prop.getProperty("hips_frame");
    }

    protected void suiteSpecific() {
        this.pixelMin = 0.0;
        this.dataMin = 0.0;
        this.pixelMax = 255.0;
        this.dataMax = 255.0;
        this.selected = true;
        this.active = true;
        this.isOldPlan = false;
        this.tileList = new TileList();
        if (this.error == null) {
            this.loader = new TileLoader();
        }
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.aladin.endMsg();
        this.creatDefaultCM();
        this.resetStats();
    }

    protected void setDefaultZoom(Coord c, double radius) {
        this.setDefaultZoom(c, radius, this.aladin.view.getCurrentView().getWidth());
    }

    protected void setDefaultZoom(Coord c, double radius, int width) {
        this.initZoom = -1.0;
        if (radius > 0.0 && c != null) {
            double projPixelRes = this.projd.rm / 60.0 / this.projd.r;
            double taille = (double)width * projPixelRes;
            double z = taille / radius;
            this.initZoom = this.aladin.calque.zoom.getNearestZoomFct(z);
        }
        if (this.initZoom == -1.0) {
            this.initZoom = c == null ? 0.03125 : 16.0;
        }
        Aladin.trace(4, "PlanBG.setDefaultZoom(" + c + "," + Coord.getUnit(radius) + ") => zoom = " + this.initZoom);
    }

    protected void log() {
        this.aladin.log(Plan.TYPE[this.type], this.label);
    }

    protected void initCache() {
        if (cacheSize == -1L) {
            cacheSize = this.aladin.configuration.getHpxCacheSize();
            Aladin.trace(3, "Cache Size => " + cacheSize);
        }
        if (Aladin.MAXMEM < 50L) {
            Aladin.error("Full sky Aladin mode requires atleast 64MB of RAM\nWe strongly suggest to adjust the JAVA memory parameter and relaunch Aladin.\nSee the corresponding Aladin FAQ entry available via the Help menu");
        }
    }

    public boolean checkSite(boolean withTrace) {
        if (this.nbCheckSite >= 3) {
            return false;
        }
        if (this.gluTag == null || this.gluTag.startsWith("__") || this.gluTag.startsWith("DIRECT/")) {
            return false;
        }
        this.aladin.glu.checkIndirection(this.gluTag, "/properties");
        URL u = this.aladin.glu.getURL(this.gluTag, "", false, true, 1);
        if (u == null) {
            return false;
        }
        String url1 = "" + u;
        if (url1.equals(this.url)) {
            return false;
        }
        ++this.nbCheckSite;
        if (withTrace) {
            this.aladin.command.console("!!! Dynamic Web server site switching => " + url1);
            Aladin.trace(2, "Plan " + this.label + " Dynamic Web server site switching: from " + this.url + " to " + url1);
        }
        this.url = url1;
        this.resetStats();
        return true;
    }

    @Override
    public ArrayList<String> getMirrorsUrl() {
        if (this.gluTag == null || this.gluTag.startsWith("__") || this.gluTag.startsWith("DIRECT/")) {
            return null;
        }
        ArrayList<String> a = this.aladin.glu.getAllUrls(this.gluTag);
        if (a.size() < 2) {
            return null;
        }
        return a;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected void planReady(boolean ready) {
        super.planReady(ready);
        this.setPourcent(0.0);
        this.flagOk = ready;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        this.planReadyMoc();
    }

    protected void planReadyMoc() {
        final PlanHips p = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PlanHips.this.loadMocNow) {
                        PlanHips.this.loadMoc();
                    } else if (PlanHips.this.hasMoc()) {
                        PlanHips.this.loadInternalMoc();
                    }
                    if (PlanHips.this.hasMoc()) {
                        Healpix hpx = new Healpix();
                        if (PlanHips.this.co == null || !PlanHips.this.moc.getSpaceMoc().contains(hpx, PlanHips.this.co.al, PlanHips.this.co.del)) {
                            if (PlanHips.this.co == null) {
                                PlanHips.this.co = new Coord();
                            }
                            PlanHips.this.co.al = Double.parseDouble(PlanHips.this.prop.getFirst("hips_initial_ra"));
                            PlanHips.this.co.del = Double.parseDouble(PlanHips.this.prop.getFirst("hips_initial_dec"));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PlanHips.this.aladin.view.syncPlan(p);
            }
        });
    }

    @Override
    protected boolean waitForPlan() {
        return this.error == null;
    }

    @Override
    protected void setCM(Object cm) {
        this.cm = (ColorModel)cm;
        this.changeImgID();
    }

    @Override
    protected boolean freePlan() {
        String stat = this.getShortStats();
        if (stat != null) {
            this.aladin.log("HealpixStats", stat);
            Aladin.trace(4, "PlanBG.Free() stat => " + stat);
            this.nbLoadCache = 0;
            this.nbLoadNet = 0;
        }
        this.xy2hpx = null;
        this.hpx2xy = null;
        this.frameOrigin = 0;
        this.freeTileList();
        this.prop = null;
        return super.freePlan();
    }

    @Override
    protected void setFmt() {
    }

    protected void seeHipsProp() {
        block3: {
            try {
                if (this.frameHipsProperties == null) {
                    this.frameHipsProperties = new FrameHipsProperties(this);
                }
                this.frameHipsProperties.seeHeaderFits();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void freeTileList() {
        try {
            if (this.tileList != null) {
                Enumeration e = this.tileList.elements();
                while (e.hasMoreElements()) {
                    Tile tile = (Tile)e.nextElement();
                    if (tile == null) continue;
                    if (this.useCache && tile.shouldBeCached()) {
                        tile.write();
                    }
                    tile.free();
                }
                this.tileList.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getPolaScaleFactor() {
        return this.polaScaleFactor;
    }

    protected void setPolaScaleFactor(int polaScaleFactor) {
        this.polaScaleFactor = polaScaleFactor;
    }

    protected void garbage() {
        Enumeration e = this.tileList.elements();
        while (e.hasMoreElements()) {
            Tile healpix = (Tile)e.nextElement();
            if (healpix == null) continue;
            healpix.clearBuf();
        }
        this.gc();
    }

    @Override
    protected boolean pixelsOriginIntoCache() {
        if (this.garbageJustDone) {
            return true;
        }
        this.garbage();
        this.changeImgID();
        this.garbageJustDone = true;
        return true;
    }

    @Override
    protected boolean hasOriginalPixels() {
        return this.isTruePixels();
    }

    @Override
    protected double getInvPixel(double pix8) {
        if (this.width == 0 && this.local && this.truePixels) {
            this.loadOneTileMaxOrder();
        }
        return super.getInvPixel(pix8);
    }

    private void loadOneTileMaxOrder() {
        try {
            int order = Util.getMaxOrderByPath(this.url);
            File f = new File(new Tile().getFilePath(this.url, this.createAddr(order, 0L, 0)));
            f = f.getParentFile().getParentFile();
            File[] list = f.listFiles();
            list = list[0].listFiles();
            String name = list[0].getName();
            int i = name.lastIndexOf(46);
            int npix = Integer.parseInt(name.substring(4, i));
            new Tile(this, this.createAddr(order, (long)npix, 0), 2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void flip(int methode) throws Exception {
        this.setSpecificProj(true);
        boolean sym = methode == 1 || methode == 2 ? !this.projd.sym : this.projd.sym;
        double angle = methode == 0 || methode == 2 ? this.projd.rot + 180.0 : this.projd.rot;
        Projection p = this.projd;
        this.modifyProj(null, 3, p.alphai, p.deltai, p.rm1, p.cx, p.cy, p.r1, angle, sym, p.t, p.system);
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
    }

    protected void addRecutListener(PlanHipsRgb p) {
        this.planHipsRGB = p;
    }

    protected boolean hasRecutListener() {
        return this.planHipsRGB != null;
    }

    protected PlanHipsRgb getRecutListener() {
        return this.planHipsRGB;
    }

    @Override
    protected boolean recut(double min, double max, boolean autocut) {
        this.freeTileList();
        this.changeImgID();
        double tmpRangeMin = this.dataMin;
        double tmpRangeMax = this.dataMax;
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, min, max, autocut, 0, 0, 0, 0);
        if (tmpRangeMin != tmpRangeMax) {
            this.dataMin = tmpRangeMin;
            this.dataMax = tmpRangeMax;
        }
        if (this.pixelsOrigin != null) {
            int size = this.pixelsOrigin.length / (Math.abs(this.bitpix) / 8);
            if (this.pixels == null || this.pixels.length != size) {
                this.pixels = new byte[size];
            }
            this.to8bits(this.pixels, 0, this.pixelsOrigin, size, this.bitpix, this.pixelMin, this.pixelMax, false);
            this.resetHist();
        }
        if (this.planHipsRGB != null) {
            this.planHipsRGB.recut();
        }
        return true;
    }

    protected void setMem() {
    }

    @Override
    protected boolean setActivated(boolean flag) {
        if (flag && this.aladin.calque.hasHpxGrid()) {
            System.out.println(this.getStats());
        }
        return super.setActivated(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCacheName() {
        if (this.cacheName != null) {
            return this.cacheName;
        }
        try {
            String s;
            if (this.id != null && this.id.startsWith("DIRECT/")) {
                s = this.id;
                if (s.startsWith("ivo://")) {
                    s = s.substring(6);
                }
            } else {
                MyProperties prop = new MyProperties();
                String urlFile = this.url + "/" + "properties";
                if (this.isDynHips()) {
                    urlFile = urlFile + "?" + this.urlSuffix;
                }
                InputStreamReader in = null;
                try {
                    in = new InputStreamReader((InputStream)cds.tools.Util.openAnyStream(urlFile), "UTF-8");
                    prop.load(in);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                s = PlanHips.getHiPSID(prop);
            }
            s = s.replace(":", "_");
            s = s.replace("/", "_");
            s = s.replace("\\", "_");
            s = s.replace("?", "_");
            s = s.replace("#", "_");
            this.cacheName = s = s.replace("&", "_");
        }
        catch (Exception e) {
            this.cacheName = this.survey + this.version;
        }
        Aladin.trace(4, "getCacheName(): Cache name = [" + this.cacheName + "]");
        return this.cacheName;
    }

    protected String getCacheDir() {
        if (this.flagCache) {
            return this.dirCache;
        }
        this.flagCache = true;
        if (!this.aladin.createCache()) {
            return null;
        }
        String dir = System.getProperty("user.home") + cds.tools.Util.FS + Aladin.CACHE + cds.tools.Util.FS + "Cache";
        File f = new File(dir);
        if (!f.isDirectory() && !f.mkdir()) {
            return null;
        }
        f = new File(dir = dir + cds.tools.Util.FS + CACHE);
        if (!f.isDirectory() && !f.mkdir()) {
            return null;
        }
        this.dirCache = dir;
        return dir;
    }

    protected static String getCacheDirStatic() {
        return System.getProperty("user.home") + cds.tools.Util.FS + Aladin.CACHE + cds.tools.Util.FS + "Cache" + cds.tools.Util.FS + CACHE;
    }

    protected static void setMaxCacheSize(long maxCacheSize) {
        if (maxCacheSize < 524288L) {
            maxCacheSize = 524288L;
        }
        MAXCACHE = maxCacheSize;
        Aladin.trace(4, "PlanBG.setMaxCacheSize() => " + MAXCACHE / 1024L + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long getCacheSize() {
        Object object = cacheLock;
        synchronized (object) {
            return cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addInCache(long size) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize += size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setCacheSize(long size) {
        Object object = cacheLock;
        synchronized (object) {
            cacheSize = size;
        }
    }

    static synchronized void scanCache() {
        if (cacheSize != -1L && cacheSize < MAXCACHE) {
            return;
        }
        PlanHips.cleanCache();
    }

    public static synchronized void cleanCache() {
        if (scanCache != null) {
            return;
        }
        String dir = PlanHips.getCacheDirStatic();
        if (dir == null) {
            PlanHips.setCacheSize(0L);
            return;
        }
        File ft = new File(Cache.getCacheDir() + cds.tools.Util.FS + "ScanRunning.bin");
        if (ft.exists()) {
            long t = System.currentTimeMillis();
            if (t - ft.lastModified() < 3600L) {
                ft.setLastModified(t);
            } else {
                Aladin.trace(4, "Detect concurrent scanning HiPS cache => abort");
                return;
            }
        }
        try {
            new RandomAccessFile(ft, "rw").close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        scanCache = new Thread("Scan cache"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3.currentThread().setPriority(1);
                long size = 0L;
                long t = System.currentTimeMillis();
                String dir = PlanHips.getCacheDirStatic();
                Aladin.trace(3, "Scanning HiPS cache...");
                File[] fold = new File(dir).listFiles();
                for (int i = 0; i < fold.length; ++i) {
                    if (!fold[i].isDirectory() || !fold[i].getName().endsWith(".old")) continue;
                    Aladin.trace(4, "PlanBG.scanCache(): removing folder " + fold[i].getName() + "...");
                    cds.tools.Util.deleteDir(fold[i]);
                }
                Vector<FileItem> listCache = new Vector<FileItem>(2000);
                size = PlanHips.getCacheSize(new File(dir), listCache);
                size += PlanHips.getCacheSizePlanHealpix(new File(PlanHealpix.getCacheDirPath()), listCache);
                try {
                    Collections.sort(listCache, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (o1 == o2) {
                                return 0;
                            }
                            if (o1 == null) {
                                return -1;
                            }
                            if (o2 == null) {
                                return 1;
                            }
                            long t1 = ((FileItem)o1).date;
                            long t2 = ((FileItem)o2).date;
                            return t1 == t2 ? 0 : (t1 > t2 ? 1 : -1);
                        }
                    });
                    Enumeration<FileItem> e = listCache.elements();
                    while (e.hasMoreElements() && size > 3L * MAXCACHE / 4L) {
                        FileItem fi = e.nextElement();
                        File f = fi.f;
                        if (fi.hasBeenModified() || size <= 3L * MAXCACHE / 4L) continue;
                        Aladin.trace(4, "PlanHips.scanCache(): removing " + f + " (" + fi.date + ")");
                        if (f.isFile()) {
                            size -= f.length() / 1024L;
                            if (fi.hasBeenModified()) {
                                throw new Exception("File :" + f.getAbsolutePath());
                            }
                            f.delete();
                            continue;
                        }
                        if (!f.isDirectory()) continue;
                        long dirSize = cds.tools.Util.dirSize(f) / 1024L;
                        size -= dirSize;
                        if (fi.hasBeenModified()) {
                            throw new Exception("Dir :" + f.getAbsolutePath());
                        }
                        cds.tools.Util.deleteDir(f);
                    }
                    Aladin.trace(3, " => Cache size=" + cds.tools.Util.getUnitDisk(size * 1024L) + " maxCache=" + cds.tools.Util.getUnitDisk(MAXCACHE * 1024L) + " scan in " + (System.currentTimeMillis() - t) + "ms");
                    PlanHips.setCacheSize(size);
                }
                catch (Exception e1) {
                    Aladin.trace(3, "Simultaneous access on cache => Clean aborted for avoiding conflict" + (e1.getMessage() != null ? " => " + e1.getMessage() : ""));
                }
                finally {
                    File ft = new File(Cache.getCacheDir() + cds.tools.Util.FS + "ScanRunning.bin");
                    ft.delete();
                    scanCache = null;
                }
            }
        };
        scanCache.start();
    }

    static void clearCache() {
        String dir = PlanHips.getCacheDirStatic();
        if (dir != null) {
            cds.tools.Util.deleteDir(new File(dir));
        }
        if ((dir = PlanHealpix.getCacheDirPath()) != null) {
            cds.tools.Util.deleteDir(new File(dir));
        }
        PlanHips.setCacheSize(0L);
    }

    public static long getCacheSize(File dir, Vector<FileItem> listCache) {
        long size = 0L;
        File[] f = dir.listFiles();
        for (int i = 0; f != null && i < f.length; ++i) {
            if (++NBFILE % 100L == 0L) {
                cds.tools.Util.pause(50);
            }
            if (f[i].isDirectory()) {
                long n = PlanHips.getCacheSize(f[i], listCache);
                if (n == 0L) {
                    f[i].delete();
                    continue;
                }
                size += n;
                continue;
            }
            size += f[i].length() / 1024L;
            if (listCache == null) continue;
            listCache.addElement(new FileItem(f[i]));
        }
        return size;
    }

    private static long getCacheSizePlanHealpix(File dir, Vector<FileItem> listCache) {
        File[] f = dir.listFiles();
        long size = 0L;
        for (int i = 0; f != null && i < f.length; ++i) {
            if (!f[i].isDirectory()) continue;
            size += cds.tools.Util.dirSize(f[i]);
            listCache.addElement(new FileItem(f[i]));
            cds.tools.Util.pause(100);
        }
        return size / 1024L;
    }

    protected String key(Tile tile) {
        return this.key(tile.addr);
    }

    protected String key(Addr cell) {
        return cell.toString();
    }

    protected String key(int order, long npix) {
        return order + "/" + npix;
    }

    protected String key(int order, long npix, int z) {
        return order + "/" + npix + (z <= 0 ? "" : "_" + z);
    }

    public Tile askForTile(Addr addr) {
        this.readyAfterDraw = false;
        Tile pixAsk = this.drawMode == 1 ? new TilePol(this, addr) : new Tile(this, addr);
        this.tileList.put(addr, pixAsk);
        return pixAsk;
    }

    protected void gc() {
        long t = System.currentTimeMillis();
        if (t - this.lastGc < 1000L) {
            return;
        }
        this.lastGc = t;
        if (this.aladin.getMem() < 256.0) {
            if (this.memCpt) {
                this.lastMemP = Runtime.getRuntime().freeMemory();
            } else {
                this.lastMemI = Runtime.getRuntime().freeMemory();
            }
            if (Math.abs(this.lastMemP - this.lastMemI) < (long)MEMREQUIREDFORGC) {
                return;
            }
        }
        this.nbFlush = 0;
        this.memCpt = !this.memCpt;
        this.aladin.gcIfRequired();
    }

    protected void purgeTile(Tile tile) {
        this.nbFlush += tile.free();
        if (this.nbFlush > 20) {
            this.gc();
        }
        this.tileList.remove(this.key(tile));
    }

    protected void tryWakeUp() {
        this.loader.wakeUp();
    }

    protected Tile getTileLowLevel(Addr addr, int mode) {
        Tile t = this.tileList.get(addr);
        if (t == null) {
            t = new Tile(this, addr, mode);
            this.tileList.put(addr, t);
        }
        if (t.getStatus() != 6) {
            return null;
        }
        return t;
    }

    protected Tile getTile(Addr addr, boolean flagLoad) {
        return this.getTile(addr, flagLoad, true);
    }

    protected Tile getTile(Addr addr, boolean flagLoad, boolean flagAllsky) {
        Tile tile = this.tileList.get(addr);
        if (tile != null) {
            return tile;
        }
        if (flagAllsky && (tile = this.getTileFromAllSky(addr)) != null) {
            return tile;
        }
        if (flagLoad) {
            return this.askForTile(addr);
        }
        return null;
    }

    protected Tile getTileFromAllSky(Addr addr) {
        if (addr.order > 3) {
            return null;
        }
        Tile allsky = this.tileList.get(this.createAddr(this.getOrderMin(), -1L, addr.z));
        if (allsky == null || allsky.getStatus() != 6) {
            return null;
        }
        int orderLosange = this.getOrderTile();
        if (orderLosange > 0 && orderLosange <= this.getAllSkyOrder(allsky)) {
            Tile[] list = allsky.getTileList();
            if (list == null) {
                return null;
            }
            Tile healpix = list[(int)addr.npix];
            if (healpix != null) {
                if (this.firstSubtil) {
                    Aladin.trace(4, "PlanBG.getHealpix " + this.label + " will use Allsky for order 3 diamonds!");
                    this.firstSubtil = false;
                }
                return healpix;
            }
        }
        return null;
    }

    static long[] getNpixListCircle(int order, Coord center, double radius) throws Exception {
        if (order == 0) {
            return ALLSKY;
        }
        return CDSHealpix.query_disc(order, center.al, center.del, Math.toRadians(radius), true);
    }

    protected Coord getCooCentreHiPS(ViewSimple v) {
        Coord center = v.getCooCentre();
        if (center == null) {
            return null;
        }
        center = Localisation.frameToFrame(center, 0, this.frameOrigin);
        return center;
    }

    protected long[] getPixListView(ViewSimple v, int order) {
        return this.getNpixList(v, null, order);
    }

    protected long[] getNpixList(ViewSimple v, Coord center, int order) {
        try {
            if (center == null) {
                center = this.getCooCentreHiPS(v);
            }
            double radius = v.getTaille();
            radius = radius / 2.0 * 1.43;
            return (long[])PlanHips.getNpixListCircle(order, center, radius).clone();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected long getNpix(int order, Coord coo) {
        try {
            coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
            double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
            return CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    protected long[] getNpix(int order, Coord coo, double radius) throws Exception {
        Coord coo1 = Localisation.frameToFrame(coo, 0, this.frameOrigin);
        long[] res = CDSHealpix.query_disc(order, coo1.al, coo1.del, Math.toRadians(radius), false);
        return res;
    }

    protected int getOrderTile() {
        if (this.orderTile == -1) {
            return 9;
        }
        return this.orderTile;
    }

    protected void setOrderTile(int orderTile) {
        if (this.orderTile != -1 || orderTile <= 0) {
            return;
        }
        this.orderTile = orderTile;
    }

    protected int getTileWidth() {
        return (int)CDSHealpix.pow2(this.getOrderTile());
    }

    protected int getTileDepth() {
        return 1;
    }

    protected int getOrderZTile() {
        return 0;
    }

    protected int getAllSkyOrder(Tile allsky) {
        Tile[] healpix;
        if (this.allSkyOrder == -1 && allsky != null && (healpix = allsky.getTileList()) != null) {
            this.allSkyOrder = healpix[0].getLosangeOrder();
        }
        return this.allSkyOrder;
    }

    @Override
    protected boolean pixelsOriginFromDisk() {
        return this.flagOk && !this.color && this.isTruePixels();
    }

    protected int getOrderInView(ViewSimple v) {
        int o = Math.min(this.getOrderMaxInView(v), this.orderMax);
        if (o < this.getOrderMin()) {
            o = this.getOrderMin();
        }
        return o;
    }

    protected int getOrderInCurrentView() {
        int o = Math.min(this.getOrderMaxInCurrentView(), this.orderMax);
        if (o < this.getOrderMin()) {
            o = this.getOrderMin();
        }
        return o;
    }

    protected int getOrderMaxInCurrentView() {
        ViewSimple v = this.aladin.view.getCurrentView();
        return this.getOrderMaxInView(v);
    }

    public String getSurveyDir() {
        if (this.local) {
            return this.url;
        }
        return this.getCacheDir() + cds.tools.Util.FS + this.getCacheName();
    }

    protected String getPixelInfo(double x, double y, int mode) {
        if (!this.pixelsOriginFromDisk() || mode != 1) {
            return "";
        }
        double pixel = this.getPixelInDouble(x, y);
        if (Double.isNaN(pixel)) {
            return "";
        }
        return this.Y(pixel);
    }

    @Override
    public int getPixel8(int x, int y) {
        double pix = this.getPixelInDouble(x, y);
        return (int)((pix - this.pixelMin) * 256.0 / (this.pixelMax - this.pixelMin));
    }

    @Override
    protected double getPixelOriginInDouble(int x, int y) {
        return this.getPixelInDouble(x, y);
    }

    @Override
    protected double getPixelInDouble(int x, int y) {
        return this.getPixelInDouble((double)x, (double)y);
    }

    protected double getPixelInDouble(double x, double y) {
        if (!this.pixelsOriginFromDisk()) {
            return Double.NaN;
        }
        int bitpix = this.getBitpix();
        int mynpix = Math.abs(bitpix) / 8;
        byte[] onePixelOrigin = new byte[mynpix];
        if (!this.getOnePixelFromCache(onePixelOrigin, x, y)) {
            return Double.NaN;
        }
        return this.getPixVal(onePixelOrigin, bitpix, 0) * this.bScale + this.bZero;
    }

    protected boolean getOnePixelFromCache(byte[] pixels, double x, double y) {
        return this.getOnePixelFromCache(this.projd, pixels, x, y);
    }

    protected boolean getOnePixelFromCache(Projection projd, byte[] pixels, double x, double y) {
        double val = this.getOnePixelFromCache(projd, x, y);
        if (Double.isNaN(val)) {
            return false;
        }
        PlanHips.setPixVal(pixels, this.getBitpix(), 0, val);
        return true;
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y) {
        return this.getOnePixelFromCache(projd, x, y, -1, -1, 2);
    }

    protected double getOnePixelFromCache(Projection projd, double x, double y, int order, int z, int mode) {
        double pixel;
        block5: {
            pixel = Double.NaN;
            if (order < 0) {
                order = this.getOrderInCurrentView();
            }
            if (z < 0) {
                z = (int)this.getZ();
            }
            try {
                Coord coo = new Coord();
                coo.x = x;
                coo.y = y;
                projd.getCoord(coo);
                coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                if (Double.isNaN(coo.al) || Double.isNaN(coo.del)) {
                    return Double.NaN;
                }
                double[] polar = CDSHealpix.radecToPolar(new double[]{coo.al, coo.del});
                long npixFile = CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
                Addr addr = this.createAddr(order, npixFile, z);
                pixel = this.getHealpixPixel(addr, polar[0], polar[1], mode);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block5;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    protected double getHealpixPixel(Addr addr, double theta, double phi, int mode) {
        Tile tile;
        int channel = this.getChannel();
        if (this.isOutMoc(addr.order, addr.npix)) {
            return Double.NaN;
        }
        Tile tile2 = mode == 3 ? this.tileList.get(addr) : (tile = this.getTileLowLevel(addr, mode == 0 ? 2 : 3));
        if (tile == null || tile.getStatus() != 6) {
            return Double.NaN;
        }
        int orderFull = (int)CDSHealpix.log2(tile.width) + tile.addr.order;
        try {
            long healpixIdxPixel = CDSHealpix.ang2pix_nest(orderFull, theta, phi);
            return tile.getPixelValue(healpixIdxPixel, channel, mode);
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    protected double getHealpixPixel(int order, long npix, long healpixIdxPixel, int z, int mode) throws Exception {
        Addr addr;
        Tile h;
        if (z == -1) {
            z = (int)this.getZ();
        }
        if ((h = this.getTileLowLevel(addr = this.createAddr(order, npix, z), mode == 1 ? 2 : 3)) == null) {
            throw new Exception("Tile " + order + "/" + npix + " not yet ready");
        }
        int channel = this.getChannel();
        return h.getPixelValue(healpixIdxPixel, channel, mode);
    }

    protected double getHealpixClosestPixel(double ra, double dec, int order, int z) {
        double pixel;
        block4: {
            pixel = Double.NaN;
            int channel = this.getChannel();
            try {
                double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
                long npixFile = CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
                Addr addr = this.createAddr(order, npixFile, z);
                Tile h = this.getTileLowLevel(addr, 2);
                if (h == null) {
                    return Double.NaN;
                }
                int orderPix = (int)CDSHealpix.log2(h.width) + h.addr.order;
                long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
                Tile h1 = this.getTileLowLevel(addr, 2);
                if (h1 == null) {
                    return Double.NaN;
                }
                pixel = h1.getPixelValue(npixPixel, channel, 0);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    protected double getHealpixLinearPixel(double ra, double dec, double ra1, double dec1, int order, int z) {
        double pixel;
        block9: {
            pixel = Double.NaN;
            int channel = this.getChannel();
            try {
                int m;
                double[] polar = CDSHealpix.radecToPolar(new double[]{ra, dec});
                double[] polar1 = CDSHealpix.radecToPolar(new double[]{ra1, dec1});
                long npix = CDSHealpix.ang2pix_nest(order, polar[0], polar[1]);
                Tile h = this.getTileLowLevel(this.createAddr(order, npix, z), 2);
                if (h == null) {
                    return Double.NaN;
                }
                int orderPix = (int)CDSHealpix.log2(h.width) + h.addr.order;
                long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
                long[] voisins = CDSHealpix.neighbours(orderPix, npixPixel);
                for (int i = m = 4; i >= 1; --i) {
                    voisins[i] = voisins[i - 1];
                }
                voisins[0] = npixPixel;
                double totalPixel = 0.0;
                double totalCoef = 0.0;
                for (int i = 0; i < m; ++i) {
                    Tile h1 = h;
                    long nlpix = voisins[i];
                    long startIdx = h.addr.npix * (long)h.width * (long)h.width;
                    long pixOffset = nlpix - startIdx;
                    if (pixOffset < 0L || pixOffset >= (long)(h.width * h.width)) {
                        long npixFile1 = nlpix / (long)(h.width * h.width);
                        Tile htmp = this.getTileLowLevel(this.createAddr(order, npixFile1, z), 2);
                        if (htmp == null) continue;
                        h1 = htmp;
                    }
                    try {
                        double pix = h1.getPixelValue(nlpix, channel, 0);
                        if (Double.isNaN(pix)) continue;
                        double[] polar2 = CDSHealpix.pix2ang_nest(orderPix, nlpix);
                        double coef = Coo.distance(polar1[0], polar1[1], polar2[0], polar2[1]);
                        if (coef == 0.0) {
                            return pix;
                        }
                        double c = 1.0 / coef;
                        totalPixel += pix * c;
                        totalCoef += c;
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                pixel = totalPixel / totalCoef;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block9;
                e.printStackTrace();
            }
        }
        return pixel;
    }

    public static String getFilePath(String survey, int order, long npix) {
        return survey + cds.tools.Util.FS + "Norder" + order + cds.tools.Util.FS + "Dir" + npix / 10000L * 10000L + cds.tools.Util.FS + "Npix" + npix;
    }

    private static void fillUp(int[] npix, int nsize, int[] pos) {
        int i;
        int size = nsize * nsize;
        int[][] fils = new int[4][size / 4];
        int[] nb = new int[4];
        for (i = 0; i < size; ++i) {
            int dg = i % nsize < nsize / 2 ? 0 : 1;
            int bh = i < size / 2 ? 1 : 0;
            int quad = dg << 1 | bh;
            int j = pos == null ? i : pos[i];
            npix[j] = npix[j] << 2 | quad;
            int n = quad;
            int n2 = nb[n];
            nb[n] = n2 + 1;
            fils[quad][n2] = j;
        }
        if (size > 4) {
            for (i = 0; i < 4; ++i) {
                PlanHips.fillUp(npix, nsize / 2, fils[i]);
            }
        }
    }

    protected void createHealpixOrder(int order) throws Exception {
        if (order == 0) {
            this.hpx2xy = new int[]{0};
            this.xy2hpx = this.hpx2xy;
            return;
        }
        int nsize = (int)CDSHealpix.pow2(order);
        if (CDSHealpix.log2(nsize) != (long)order) {
            throw new Exception("Only HEALPix order power of 2 are supported");
        }
        this.xy2hpx = new int[nsize * nsize];
        this.hpx2xy = new int[nsize * nsize];
        PlanHips.fillUp(this.xy2hpx, nsize, null);
        for (int i = 0; i < this.xy2hpx.length; ++i) {
            this.hpx2xy[this.xy2hpx[i]] = i;
        }
    }

    public final int xy2hpx(int hpxOffset) {
        return this.xy2hpx[hpxOffset];
    }

    public final int hpx2xy(int xyOffset) {
        return this.hpx2xy[xyOffset];
    }

    protected void touchCache() {
        long t = System.currentTimeMillis();
        if (t - this.lastTouch < 60000L) {
            return;
        }
        this.lastTouch = t;
        String pathName = this.getCacheDir() + cds.tools.Util.FS + this.getCacheName();
        new File(pathName).setLastModified(t);
        Date d = new Date();
        d.setTime(this.lastTouch);
        Aladin.trace(4, "PlanHips.touchCache() : Date:" + d + " => " + pathName);
    }

    protected int getOrderMaxInView(ViewSimple v) {
        long iz = v.getIZ();
        if (this.lastIz == iz) {
            return this.lastOrderMax;
        }
        this.lastIz = iz;
        int myOrder = this.getOrderTile();
        if (this.RES == null || this.oTileOrder != myOrder) {
            this.oTileOrder = myOrder;
            if (this.RES == null) {
                this.RES = new double[20];
            }
            this.lastOrderMax = 0;
            while (this.lastOrderMax < 20) {
                int order = this.lastOrderMax + myOrder + 1;
                this.RES[this.lastOrderMax] = CDSHealpix.pixRes(order) / 3600.0;
                ++this.lastOrderMax;
            }
        }
        double pixSize = v.getPixelSize();
        this.lastOrderMax = 0;
        while (this.lastOrderMax < this.RES.length && this.RES[this.lastOrderMax] > pixSize) {
            ++this.lastOrderMax;
        }
        this.lastOrderMax = this.adjustOrderMax(this.lastOrderMax, pixSize);
        return this.lastOrderMax;
    }

    protected int adjustOrderMax(int lastOrderMax, double pixSize) {
        if (lastOrderMax <= 2 && pixSize < 0.06 && this.getOrderMin() == 3) {
            lastOrderMax = 3;
        }
        return lastOrderMax;
    }

    protected String getFormat() {
        if (this.color) {
            if (this.inFits) {
                return "FITS RGB color";
            }
            return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " color";
        }
        if (this.truePixels) {
            return "FITS true pixels (BITPIX=" + this.bitpix + ")";
        }
        return (this.colorPNG || this.inPNG ? "PNG" : "JPEG") + " 8 bits pixels";
    }

    protected void switchFormat() {
        if (this.truePixels) {
            this.transferFct4Fits = this.transfertFct;
        } else {
            this.transferFct4Preview = this.transfertFct;
        }
        boolean bl = this.truePixels = !this.truePixels;
        this.setPixMode(this.truePixels ? 2 : (this.inPNG ? 4 : 3));
        this.transfertFct = this.truePixels ? this.transferFct4Fits : this.transferFct4Preview;
        this.restoreCM();
        this.forceReload();
        if (this.aladin.frameCM != null) {
            this.aladin.frameCM.majCM(true);
        }
    }

    public void forceReload() {
        this.freeTileList();
        this.changeImgID();
        this.flagRecut = true;
        this.flagRecutCoo = new Coord(this.aladin.view.repere.raj, this.aladin.view.repere.dej);
        this.flagRecutRadius = this.aladin.view.getCurrentView().getTaille() / 2.0;
        this.resetHist();
    }

    protected String getMaxResolution() {
        return Coord.getUnit(this.getPixelResolution());
    }

    public int getOrderMax() {
        return this.orderMax;
    }

    public int getOrderMaxPixel() {
        return this.orderMax + this.getOrderTile();
    }

    public double getPixelResolution() {
        return CDSHealpix.pixRes(this.getOrderMaxPixel()) / 3600.0;
    }

    protected boolean isFullyDrawn() {
        return this.isDrawn() && this.allTilesDrawn;
    }

    protected boolean isDrawn() {
        return this.readyDone;
    }

    protected boolean isLoading() {
        return !this.loader.isReadyForDrawing();
    }

    protected boolean hasMoreDetails() {
        return this.hasMoreDetails;
    }

    protected String getInfoDetails() {
        return this.getOrderInCurrentView() + "/" + this.orderMax;
    }

    protected void setHasMoreDetails(boolean flag) {
        this.hasMoreDetails = flag;
    }

    @Override
    protected boolean isSync() {
        if (this.error != null) {
            Aladin.trace(6, "PlanBG.isSync()=true:" + this.label + " => in error (error=" + this.error + ")");
            return true;
        }
        if (!this.flagOk) {
            Aladin.trace(6, "PlanBG.isSync()=false: " + this.label + " => not ready (!flagOk)");
            return false;
        }
        if (!this.active) {
            Aladin.trace(6, "PlanBG.isSync()=true: " + this.label + "=> not active (!active)");
            return true;
        }
        if (this.getOpacityLevel() == 0.0f && !this.ref) {
            Aladin.trace(6, "PlanBG.isSync()=true: " + this.label + "=> transparent (!ref && opacity=" + this.getOpacityLevel() + ")");
            return true;
        }
        if (this.flagProcessing) {
            Aladin.trace(6, "PlanBG.isSync()=false: " + this.label + "=> is processing (flagProcessing)");
            return false;
        }
        if (this.isLoading()) {
            Aladin.trace(6, "PlanBG.isSync()=false: " + this.label + "=> is loading (isLoading())");
            return false;
        }
        return true;
    }

    @Override
    public boolean isCubeClassique() {
        return this.cube;
    }

    public boolean isColored() {
        return this.color;
    }

    public boolean isTruePixels() {
        return this.truePixels;
    }

    public boolean canbeTruePixels() {
        return this.inFits;
    }

    public boolean isLocalHips() {
        return this.local;
    }

    @Override
    protected void modifyProj(String label, int modeCalib, double alphai, double deltai, double rm, double cx, double cy, double r, double rot, boolean sym, int t, int system) {
        super.modifyProj(label, modeCalib, alphai, deltai, rm, cx, cy, r, rot, sym, t, system);
    }

    protected int futurGetMinOrder() {
        return this.orderMin == -1 ? 3 : this.orderMin;
    }

    protected int getOrderMin() {
        if (Aladin.HIPSLOWORDER || !this.hasAllSky || this.hasRecutListener()) {
            return this.futurGetMinOrder();
        }
        return 3;
    }

    protected void loadAllSkyNow() {
        Addr cell = this.createAddr(this.getOrderMin(), -1L, (int)this.getZ());
        Tile allsky = this.tileList.get(cell);
        if (allsky == null) {
            allsky = new TileAllsky(this, cell);
            this.tileList.put(this.key(allsky), allsky);
            try {
                allsky.loadNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean allSkyAvailable() {
        return true;
    }

    protected boolean drawAllSky(Graphics g, ViewSimple v, BufferedImage imgb) {
        int status;
        Tile allsky;
        Addr addr;
        boolean hasDrawnSomething = false;
        int order = this.getOrderMin();
        if (!this.allSkyAvailable()) {
            addr = this.createAddr(order, -1L, 0);
            allsky = new Tile(this, addr);
            allsky.setStatus(7);
            this.hasAllSky = false;
            order = this.getOrderMin();
        } else {
            addr = this.createAddr(v, order, -1L);
            allsky = this.tileList.get(addr);
            this.flagWaitAllSky = false;
        }
        if (allsky == null) {
            allsky = this.drawMode == 1 ? new TilePolAllsky(this, order) : new TileAllsky(this, addr);
            this.tileList.put(this.key(allsky), allsky);
            if (this.local) {
                allsky.waitLock();
                if (allsky.getStatus() == 3) {
                    allsky.loadFromNet();
                }
                allsky.unLock();
            } else {
                if (!this.useCache || !allsky.isCached()) {
                    this.tryWakeUp();
                    if (v.pref == this) {
                        this.drawBackground(g, v);
                    }
                    return true;
                }
                allsky.loadFromCache();
            }
        }
        if ((status = allsky.getStatus()) == 7) {
            this.hasAllSky = false;
            if (order <= 3) {
                int n = (int)(12L * CDSHealpix.pow2(order) * CDSHealpix.pow2(order));
                Aladin.trace(3, "Allsky not found => anticipated load of " + n + " tiles order " + order);
                Tile tile = null;
                for (int npix = 0; npix < n && this.tileList.get(addr = this.createAddr(v, order, (long)npix)) == null; ++npix) {
                    if (this.isOutMoc(this.orderMin, npix)) continue;
                    tile = this.getTileLowLevel(addr, 5);
                }
                if (tile != null) {
                    tile.setMode(1);
                }
            }
            return false;
        }
        if (status == 6) {
            long[] npix;
            allsky.resetTimer();
            this.statNbItems = 0L;
            double size = Math.min(v.getTailleRA(), v.getTailleDE());
            Tile[] tileAllskyList = allsky.getTileList();
            if (size < 40.0 && !v.isAllSky()) {
                npix = this.getNpixList(v, null, order);
            } else {
                npix = new long[tileAllskyList.length];
                for (int i = 0; i < npix.length; ++i) {
                    npix[i] = i;
                }
            }
            int channel = this.getChannel();
            for (int i = 0; i < npix.length; ++i) {
                Tile healpix = tileAllskyList[(int)npix[i]];
                if (healpix == null || healpix.isOutView(v)) continue;
                if (this.drawMode == 0) {
                    healpix.draw(g, v, channel);
                } else if (this.drawMode == 1) {
                    ((TilePol)healpix).drawPolarisation(g, v);
                }
                ++this.statNbItems;
                hasDrawnSomething = true;
            }
        } else {
            this.flagWaitAllSky = status != 7;
        }
        return hasDrawnSomething;
    }

    private boolean mustDrawHoles(ViewSimple v) {
        if (this.mustDrawFast()) {
            return false;
        }
        if (!v.isAllSky()) {
            return false;
        }
        try {
            if (this.moc != null && this.moc.getSpaceMoc().getCoverage() < 0.3) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !this.isTransparent();
    }

    private void drawHoles(BufferedImage imgb, ViewSimple v) {
        if (imgb == null) {
            return;
        }
        if (!this.mustDrawHoles(v)) {
            return;
        }
        long t0 = System.currentTimeMillis();
        Tile[] tiles = null;
        String method = null;
        if (this.hasAllSky) {
            Tile allsky = this.getTile(this.createAddr(v, 3, -1L), true);
            if (allsky == null || allsky.getStatus() != 6) {
                return;
            }
            tiles = allsky.getTileList();
            method = " via allsky";
        } else {
            int n = (int)(12L * CDSHealpix.pow2(this.orderMin) * CDSHealpix.pow2(this.orderMin));
            tiles = new Tile[n];
            for (int i = 0; i < n; ++i) {
                tiles[i] = this.getTile(this.createAddr(v, this.orderMin, (long)i), true, false);
            }
            method = " via tiles order " + this.orderMin;
        }
        int vide = 0xFFFFFF & this.getColorHoles().getRGB();
        int channel = this.getChannel();
        int[] pixelsRGB = ((DataBufferInt)imgb.getRaster().getDataBuffer()).getData();
        int width = imgb.getWidth();
        int height = imgb.getHeight();
        Projection proj = v.getProj();
        Coord c = new Coord();
        int orderTiles = (int)CDSHealpix.log2(tiles[0].width);
        int order = tiles[0].addr.order;
        int orderPix = orderTiles + order;
        int offset = 0;
        int nb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int rgb = pixelsRGB[offset];
                if ((0xFFFFFF & rgb) == vide) {
                    Point p = v.getPosition(x, y);
                    c.x = p.x;
                    c.y = p.y;
                    proj.getCoord(c);
                    c = Localisation.frameToFrame(c, 0, this.frameOrigin);
                    if (!Double.isNaN(c.al)) {
                        try {
                            Tile h1;
                            double[] polar = CDSHealpix.radecToPolar(new double[]{c.al, c.del});
                            long npixPixel = CDSHealpix.ang2pix_nest(orderPix, polar[0], polar[1]);
                            long npixFile = npixPixel >>> (orderTiles << 1);
                            if (!this.isOutMoc(order, npixFile) && (h1 = tiles[(int)npixFile]) != null && h1.getStatus() == 6) {
                                ++nb;
                                int pix = this.color ? h1.getPixelRGB(npixPixel) : this.cm.getRGB(h1.getPixelByte(npixPixel, channel));
                                if (Aladin.levelTrace >= 4) {
                                    pix |= 0xFFFF00FF;
                                }
                                pixelsRGB[offset] = pix;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++x;
                ++offset;
            }
        }
        if (nb > 0) {
            imgb.setRGB(0, 0, width, height, pixelsRGB, 0, width);
        }
        long t1 = System.currentTimeMillis();
        Aladin.trace(4, "drawHoles" + method + " in " + (t1 - t0) + "ms redrawnPixel: " + nb + "/" + offset);
    }

    protected void getCurrentBufPixels(PlanImage pi, RectangleD rcrop, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        byte[] pixelsOrigin = new byte[w * h * npix];
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int n = order = fullRes ? this.orderMax : (int)((double)this.getOrderInCurrentView() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.orderMax) {
            order = this.orderMax;
        }
        int z = (int)this.getZ();
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        block0: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val;
                double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                double y1 = rcrop.y + (double)y / zoom;
                coo.x = x1;
                coo.y = y1;
                pi.projd.getCoord(coo);
                coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                double x2 = rcrop.x + (double)(x + 1) / zoom;
                double y2 = rcrop.y + (double)y / zoom;
                coo1.x = x2;
                coo1.y = y2;
                pi.projd.getCoord(coo1);
                coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                if (!testClosest) {
                    double resSrc;
                    testClosest = true;
                    double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                    if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                        flagClosest = true;
                    }
                }
                if (Double.isNaN(val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order, z) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order, z)))) {
                    PlanHips.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanHips.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                System.arraycopy(onePixelOrigin, 0, pixelsOrigin, offset, npix);
                if ((offset += npix) > pixelsOrigin.length) continue block0;
            }
        }
        pi.bitpix = bitpix;
        pi.pixelsOrigin = pixelsOrigin;
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected void getCurrentBufPixels(PlanImage pi, RectangleD rcrop, STCObj stcObj, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        byte[] pixelsOrigin = new byte[w * h * npix];
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int n = order = fullRes ? this.orderMax : (int)((double)this.getOrderInCurrentView() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.orderMax) {
            order = this.orderMax;
        }
        int z = (int)this.getZ();
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        Healpix healPix = new Healpix();
        SMoc posBounds = null;
        try {
            if (stcObj != null) {
                posBounds = new SMoc(Aladin.createMocRegion(stcObj, -1, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        block4: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val = Double.NaN;
                try {
                    double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                    double y1 = rcrop.y + (double)y / zoom;
                    coo.x = x1;
                    coo.y = y1;
                    pi.projd.getCoord(coo);
                    coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                    double x2 = rcrop.x + (double)(x + 1) / zoom;
                    double y2 = rcrop.y + (double)y / zoom;
                    coo1.x = x2;
                    coo1.y = y2;
                    pi.projd.getCoord(coo1);
                    coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                    if (posBounds != null && !posBounds.contains(healPix, coo1.al, coo1.del)) {
                        val = Double.NaN;
                    } else {
                        if (!testClosest) {
                            double resSrc;
                            testClosest = true;
                            double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                            if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                                flagClosest = true;
                            }
                        }
                        val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order, z) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order, z));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Double.isNaN(val)) {
                    PlanHips.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanHips.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                System.arraycopy(onePixelOrigin, 0, pixelsOrigin, offset, npix);
                if ((offset += npix) > pixelsOrigin.length) continue block4;
            }
        }
        pi.bitpix = bitpix;
        pi.pixelsOrigin = pixelsOrigin;
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected void getCurrentBufPixelsBubbleWrapped(PlanImage pi, RectangleD rcrop, STCObj stcObj, double zoom, double resMult, boolean fullRes) {
        int order;
        int w = (int)Math.round(rcrop.width * zoom);
        int h = (int)Math.round(rcrop.height * zoom);
        int bitpix = this.getBitpix() == -64 ? -64 : -32;
        int npix = Math.abs(bitpix) / 8;
        try {
            this.aladin.askIMResourceCheck(w * h * npix);
        }
        catch (Exception e1) {
            Aladin.trace(3, "No sufficient memory");
            this.aladin.notifyIMStatusChange((short)0);
            return;
        }
        SoftReference<byte[]> ref = new SoftReference<byte[]>(new byte[w * h * npix]);
        if (ref == null || ref.get() == null) {
            this.aladin.notifyIMStatusChange((short)-1);
            Aladin.trace(3, "can't process this");
            return;
        }
        this.aladin.notifyIMStatusChange((short)1);
        byte[] onePixelOrigin = new byte[npix];
        double blank = Double.NaN;
        boolean flagClosest = false;
        boolean testClosest = false;
        int n = order = fullRes ? this.orderMax : (int)((double)this.getOrderInCurrentView() * resMult);
        if (order < 3) {
            order = 3;
        } else if (order > this.orderMax) {
            order = this.orderMax;
        }
        int z = (int)this.getZ();
        int offset = 0;
        double fct = 100.0 / (double)h;
        Coord coo = new Coord();
        Coord coo1 = new Coord();
        Healpix healPix = new Healpix();
        SMoc posBounds = null;
        try {
            if (stcObj != null) {
                posBounds = new SMoc(Aladin.createMocRegion(stcObj, -1, true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        block6: for (int y = h - 1; y >= 0; --y) {
            pi.pourcent += fct;
            for (int x = 0; x < w; ++x) {
                double val = Double.NaN;
                try {
                    double x1 = rcrop.x + ((double)x + 0.5) / zoom;
                    double y1 = rcrop.y + (double)y / zoom;
                    coo.x = x1;
                    coo.y = y1;
                    pi.projd.getCoord(coo);
                    coo = Localisation.frameToFrame(coo, 0, this.frameOrigin);
                    double x2 = rcrop.x + (double)(x + 1) / zoom;
                    double y2 = rcrop.y + (double)y / zoom;
                    coo1.x = x2;
                    coo1.y = y2;
                    pi.projd.getCoord(coo1);
                    coo1 = Localisation.frameToFrame(coo1, 0, this.frameOrigin);
                    if (posBounds != null && !posBounds.contains(healPix, coo1.al, coo1.del)) {
                        val = Double.NaN;
                    } else {
                        if (!testClosest) {
                            double resSrc;
                            testClosest = true;
                            double resDest = Coo.distance(coo.al, coo.del, coo1.al, coo1.del) * 2.0;
                            if (resDest < (resSrc = this.getPixelResolution()) / 2.0) {
                                flagClosest = true;
                            }
                        }
                        val = Double.isNaN(coo.al) || Double.isNaN(coo.del) ? Double.NaN : (flagClosest ? this.getHealpixClosestPixel(coo1.al, coo1.del, order, z) : this.getHealpixLinearPixel(coo.al, coo.del, coo1.al, coo1.del, order, z));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Double.isNaN(val)) {
                    PlanHips.setPixVal(onePixelOrigin, bitpix, 0, blank);
                    if (!pi.isBlank) {
                        pi.isBlank = true;
                        pi.blank = blank;
                        if (bitpix > 0 && pi.headerFits != null) {
                            pi.headerFits.setKeyValue("BLANK", blank + "");
                        }
                    }
                } else {
                    val = val * this.bScale + this.bZero;
                    PlanHips.setPixVal(onePixelOrigin, bitpix, 0, val);
                }
                int length = -1;
                if (ref == null || ref.get() == null) {
                    Aladin.trace(3, "ooo im thinking out of memory. free:" + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + " request: " + stcObj);
                    return;
                }
                length = ref.get().length;
                System.arraycopy(onePixelOrigin, 0, ref.get(), offset, npix);
                if ((offset += npix) > length) continue block6;
            }
        }
        pi.bitpix = bitpix;
        if (ref == null || ref.get() == null) {
            Aladin.trace(3, "ooo im thinking out of memory. free:" + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + " request: " + stcObj);
            return;
        }
        pi.pixelsOrigin = ref.get();
        pi.dataMin = this.dataMin * this.bScale + this.bZero;
        pi.dataMax = this.dataMax * this.bScale + this.bZero;
        pi.pixelMin = this.pixelMin * this.bScale + this.bZero;
        pi.pixelMax = this.pixelMax * this.bScale + this.bZero;
        pi.bScale = 1.0;
        pi.bZero = 0.0;
        pi.pixels = this.getPix8Bits(null, pi.pixelsOrigin, pi.bitpix, pi.width, pi.height, pi.pixelMin, pi.pixelMax, false, 0, 0, 0);
        PlanImage.invImageLine(pi.width, pi.height, pi.pixels);
        pi.colorBackground = Color.white;
    }

    protected byte[] getBufPixels8(ViewSimple v) {
        return this.getPixels8Area(v, new RectangleD(0.0, 0.0, v.rv.width, v.rv.height), true);
    }

    protected byte[] getPixels8Area(ViewSimple v, RectangleD rcrop, boolean now) {
        int[] rgb = this.getPixelsRGBArea(v, rcrop, now);
        if (rgb == null) {
            return null;
        }
        int taille = rgb.length;
        byte[] pixels = new byte[taille];
        for (int i = 0; i < taille; ++i) {
            if ((rgb[i] >>> 24 & 0xFF) == 0) {
                pixels[i] = 0;
                continue;
            }
            int pix = rgb[i] & 0xFF;
            if (pix < 255) {
                ++pix;
            }
            pixels[i] = (byte)(pix & 0xFF);
        }
        rgb = null;
        return pixels;
    }

    protected byte[] getPixels8Area(ViewSimple v, RectangleD rcrop, STCObj stcObj, boolean now) {
        int[] rgb = this.getPixelsRGBArea(v, rcrop, stcObj, now);
        if (rgb == null) {
            return null;
        }
        int taille = rgb.length;
        byte[] pixels = new byte[taille];
        for (int i = 0; i < taille; ++i) {
            if ((rgb[i] >>> 24 & 0xFF) == 0) {
                pixels[i] = 0;
                continue;
            }
            int pix = rgb[i] & 0xFF;
            if (pix < 255) {
                ++pix;
            }
            pixels[i] = (byte)(pix & 0xFF);
        }
        rgb = null;
        return pixels;
    }

    protected int[] getPixelsRGBArea(ViewSimple v, RectangleD rcrop, boolean now) {
        int y;
        if (v == null) {
            return null;
        }
        BufferedImage imgBuf = new BufferedImage(v.rv.width, v.rv.height, 2);
        Graphics g = imgBuf.getGraphics();
        this.drawTiles(g, v, now, imgBuf);
        g.finalize();
        g = null;
        int width = (int)Math.ceil(rcrop.width);
        int height = (int)Math.ceil(rcrop.height);
        int taille = width * height;
        int[] rgb = new int[taille];
        int x = (int)Math.floor(rcrop.x);
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)Math.floor(rcrop.y)) < 0) {
            y = 0;
        }
        imgBuf.getRGB(x, y, width, height, rgb, 0, width);
        imgBuf.flush();
        imgBuf = null;
        return rgb;
    }

    protected int[] getPixelsRGBArea(ViewSimple v, RectangleD rcrop, STCObj stcObj, boolean now) {
        int y;
        if (v == null) {
            return null;
        }
        BufferedImage imgBuf = new BufferedImage(v.rv.width, v.rv.height, 2);
        Graphics g = imgBuf.getGraphics();
        Shape shape = this.getShape(v, stcObj);
        if (shape != null) {
            g.setClip(shape);
        }
        this.drawTiles(g, v, now, imgBuf);
        g.finalize();
        if (shape != null) {
            g.setClip(null);
        }
        g = null;
        int width = (int)Math.ceil(rcrop.width);
        int height = (int)Math.ceil(rcrop.height);
        int taille = width * height;
        int[] rgb = new int[taille];
        int x = (int)Math.floor(rcrop.x);
        if (x < 0) {
            x = 0;
        }
        if ((y = (int)Math.floor(rcrop.y)) < 0) {
            y = 0;
        }
        imgBuf.getRGB(x, y, width, height, rgb, 0, width);
        imgBuf.flush();
        imgBuf = null;
        return rgb;
    }

    public Shape getShape(ViewSimple v, STCObj stcObj) {
        Shape shape = null;
        Coord coord = null;
        PointD pt = null;
        if (stcObj instanceof STCCircle) {
            STCCircle circle = (STCCircle)stcObj;
            coord = this.getCoodSetXY(circle.getCenter().al, circle.getCenter().del);
            double radius = Server.getAngleInArcmin(String.valueOf(circle.getRadius()), 8) / 60.0;
            int plotRadius = (int)Math.round(Fov.getPlotRadiusForCircleFromCoord(this.projd, coord, radius) * v.getZoom());
            pt = v.getViewCoordDble(coord.x, coord.y);
            shape = new Ellipse2D.Double((int)(pt.x - (double)plotRadius), (int)(pt.y - (double)plotRadius), plotRadius * 2, plotRadius * 2);
        } else if (stcObj instanceof STCPolygon) {
            STCPolygon poly = (STCPolygon)stcObj;
            ArrayList<Double> xCorners = poly.getxCorners();
            ArrayList<Double> yCorners = poly.getyCorners();
            int[] xPoly = new int[xCorners.size()];
            int[] yPoly = new int[xCorners.size()];
            for (int i = 0; i < xCorners.size(); ++i) {
                coord = this.getCoodSetXY((Double)xCorners.get(i), (Double)yCorners.get(i));
                pt = v.getViewCoordDble(coord.x, coord.y);
                xPoly[i] = (int)Math.floor(pt.x);
                if (xPoly[i] < 0) {
                    xPoly[i] = 0;
                }
                yPoly[i] = (int)Math.floor(pt.y);
                if (yPoly[i] >= 0) continue;
                yPoly[i] = 0;
            }
            shape = new Polygon(xPoly, yPoly, xPoly.length);
        }
        return shape;
    }

    public Coord getCoodSetXY(double ra, double dec) {
        Coord coord = new Coord(ra, dec);
        coord = Localisation.frameToFrame(coord, 0, this.frameOrigin);
        coord = this.projd.getXY(coord);
        return coord;
    }

    @Override
    protected Image getImage(ViewSimple v, boolean now) {
        if (now) {
            BufferedImage img = new BufferedImage(v.rv.width, v.rv.height, 3);
            Graphics g = img.getGraphics();
            this.drawTiles(g, v, now, img);
            this.adjustCM(img);
            g.dispose();
            return img;
        }
        if (v.imageBG != null && v.ovizBG == v.iz && v.oImgIDBG == this.imgID && v.rv.width == v.owidthBG && v.rv.height == v.oheightBG) {
            return v.imageBG;
        }
        if (v.imageBG == null || v.rv.width != v.owidthBG || v.rv.height != v.oheightBG) {
            if (v.imageBG != null) {
                v.imageBG.flush();
            }
            if (v.g2BG != null) {
                v.g2BG.dispose();
            }
            v.imageBG = new BufferedImage(v.rv.width, v.rv.height, 3);
            v.g2BG = v.imageBG.getGraphics();
        } else {
            ((Graphics2D)v.g2BG).setComposite(AlphaComposite.Clear);
            v.g2BG.fillRect(0, 0, v.rv.width, v.rv.height);
            ((Graphics2D)v.g2BG).setComposite(AlphaComposite.Src);
        }
        v.oImgIDBG = this.imgID;
        v.owidthBG = v.rv.width;
        v.oheightBG = v.rv.height;
        v.ovizBG = v.iz;
        this.garbageJustDone = false;
        if (!this.isTransparent()) {
            this.drawBackground(v.g2BG, v);
        }
        this.drawTiles(v.g2BG, v, now, v.imageBG);
        try {
            this.adjustCM(v.imageBG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            v.w = v.imageBG.getWidth();
            v.h = v.imageBG.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v.imageBG;
    }

    private void adjustCM(BufferedImage img) {
        boolean flagInitRGB;
        if (!this.isColored()) {
            return;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        boolean modif = this.RGBControl[0] != 0 || this.RGBControl[1] != 128 || this.RGBControl[2] != 255 || this.RGBControl[3] != 0 || this.RGBControl[4] != 128 || this.RGBControl[5] != 255 || this.RGBControl[6] != 0 || this.RGBControl[7] != 128 || this.RGBControl[8] != 255 || this.video != 0;
        int size = width * height;
        boolean bl = flagInitRGB = this.lastHistID != this.imgID;
        if (flagInitRGB) {
            this.lastHistID = this.imgID;
            if (this.red == null || size != this.red.length) {
                this.red = new byte[size];
                this.green = new byte[size];
                this.blue = new byte[size];
            }
        }
        if (!flagInitRGB && !modif) {
            return;
        }
        int[] pixelsRGB = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < pixelsRGB.length; ++pos) {
            int rgb = pixelsRGB[pos];
            int a = (rgb & 0xFF000000) >> 24;
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            if (flagInitRGB) {
                this.red[pos] = (byte)(0xFF & r);
                this.green[pos] = (byte)(0xFF & g);
                this.blue[pos] = (byte)(0xFF & b);
            }
            if (!modif) continue;
            r = PlanImageRGB.filter(this.RGBControl[0], this.RGBControl[1], this.RGBControl[2], r & 0xFF);
            g = PlanImageRGB.filter(this.RGBControl[3], this.RGBControl[4], this.RGBControl[5], g & 0xFF);
            b = PlanImageRGB.filter(this.RGBControl[6], this.RGBControl[7], this.RGBControl[8], b & 0xFF);
            if (this.video == 1) {
                r ^= 0xFFFFFFFF;
                g ^= 0xFFFFFFFF;
                b ^= 0xFFFFFFFF;
            }
            pixelsRGB[pos] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        if (modif) {
            img.setRGB(0, 0, width, height, pixelsRGB, 0, width);
        }
        if (flagInitRGB) {
            this.resetHist();
            if (this.aladin.frameCM != null) {
                this.aladin.frameCM.repaint();
            }
        }
    }

    protected void filterRGB(int[] triangle, int color) {
        this.changeImgID();
        this.RGBControl[color * 3] = triangle[0];
        this.RGBControl[color * 3 + 1] = triangle[1];
        this.RGBControl[color * 3 + 2] = triangle[2];
    }

    @Override
    protected double[] getHistArray(int rgb) {
        return rgb == 0 ? this.histRed : (rgb == 1 ? this.histGreen : this.histBlue);
    }

    @Override
    protected byte[] getPixelHist(int rgb) {
        return rgb == -1 ? super.getPixelHist(rgb) : (rgb == 0 ? this.red : (rgb == 1 ? this.green : this.blue));
    }

    protected synchronized void redrawAsap() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                PlanHips.this.changeImgID();
                PlanHips.this.aladin.view.repaintAll();
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, 5L, 5L);
    }

    protected synchronized void stopRedraw() {
        if (this.timer == null) {
            return;
        }
        System.out.println("stopping fading process");
        this.timer.cancel();
        this.timer = null;
        this.op = 0.0f;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op) {
        this.draw(g, v, dx, dy, -1.0f, false);
    }

    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op, boolean now) {
        if (v == null) {
            return;
        }
        if (op == -1.0f) {
            op = this.getOpacityLevel();
        }
        if ((double)op <= 0.1) {
            return;
        }
        this.resetFading();
        if (g instanceof Graphics2D) {
            Composite saveComposite;
            Graphics2D g2d;
            block14: {
                g2d = (Graphics2D)g;
                saveComposite = g2d.getComposite();
                try {
                    if ((double)op < 0.9) {
                        Composite myComposite = cds.tools.Util.getImageComposite(op);
                        g2d.setComposite(myComposite);
                    }
                    if (this.drawMode == 1) {
                        this.drawPolarisation(g2d, v);
                    } else {
                        g2d.drawImage(this.getImage(v, now), dx, dy, this.aladin);
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block14;
                    e.printStackTrace();
                }
            }
            g2d.setComposite(saveComposite);
        } else if (this.drawMode == 1) {
            this.drawPolarisation(g, v);
        } else {
            g.drawImage(this.getImage(v, now), dx, dy, this.aladin);
        }
        this.setHasMoreDetails(this.getOrderMaxInView(v) < this.orderMax);
        if (this.isFading()) {
            this.redrawAsap();
        } else {
            this.stopRedraw();
        }
        this.readyDone = this.readyAfterDraw;
    }

    protected void drawHealpixMouse(Graphics g, ViewSimple v) {
        try {
            Coord coo = new Coord(this.aladin.localisation.getLastCoord().al, this.aladin.localisation.getLastCoord().del);
            int order = this.aladin.getOrder();
            long npix = this.getNpix(order, coo);
            Tile hk = new Tile(this, this.createAddr(v, order, npix), 0);
            hk.drawCtrl(g, v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void resetPriority() {
        Enumeration e = this.tileList.elements();
        while (e.hasMoreElements()) {
            Tile healpix = (Tile)e.nextElement();
            if (healpix.addr.npix == -1L || healpix.priority >= 1000) continue;
            healpix.priority += 1000;
        }
        this.priority = 0;
    }

    protected void drawPolarisation(Graphics g, ViewSimple v) {
        long[] pix = null;
        int max = Math.min(this.getOrderMaxInView(v), this.orderMax);
        int nb = 0;
        if (v.getTaille() > 20.0 && (this.hasDrawnSomething = this.drawAllSky(g, v, null))) {
            return;
        }
        this.setMem();
        this.resetPriority();
        int order = Math.max(3, max);
        pix = this.getPixListView(v, order);
        int z = (int)this.getZ(v);
        for (int i = 0; i < pix.length; ++i) {
            Tile healpix;
            Addr cell = this.createAddr(order, pix[i], z);
            if (this.isOutView(v, cell) || (healpix = this.getTile(cell, true)) == null) continue;
            healpix.priority = 250 - this.priority++;
            int status = healpix.getStatus();
            if (status == 7) continue;
            if (status == 8) {
                healpix.setStatus(1, true);
            }
            healpix.resetTimer();
            if (status != 6) continue;
            nb += ((TilePol)healpix).drawPolarisation(g, v);
        }
        this.hasDrawnSomething = nb > 0;
        this.tryWakeUp();
    }

    protected boolean mustDrawFast() {
        if (this.aladin.isAnimated()) {
            return false;
        }
        if (!this.computeDrawFast) {
            return this.lastMustDrawFast;
        }
        boolean rep = this.aladin.view.mustDrawFast();
        boolean bl = !rep ? false : (this.lastMustDrawFast = this.statTimeDisplay > 100L);
        if (this.lastMustDrawFast) {
            this.computeDrawFast = false;
        }
        return this.lastMustDrawFast;
    }

    protected void resetDrawFastDetection() {
        this.computeDrawFast = true;
    }

    protected void drawHealpixGrid(Graphics g, ViewSimple v) {
        int i;
        long[] npix;
        int order = Math.max(this.getOrderMin(), Math.min(this.getOrderMaxInView(v), this.orderMax));
        if (v.isAllSky()) {
            npix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (i = 0; i < npix.length; ++i) {
                npix[i] = i;
            }
        } else {
            npix = this.getNpixList(v, this.getCooCentreHiPS(v), order);
        }
        for (i = 0; i < npix.length; ++i) {
            Tile tile = new Tile(this, this.createAddr(order, npix[i], -1), 0);
            if (this.isOutMoc(order, npix[i]) || tile.isOutView(v)) continue;
            try {
                tile.drawTileBorder(g, v, null, null, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void drawTilesNow(Graphics g, ViewSimple v, BufferedImage imgb) {
        long[] npix;
        Addr addr;
        int order = Math.max(this.getOrderMin(), Math.min(this.getOrderMaxInView(v), this.orderMax));
        boolean lowResolution = v.isAllSky() && order == this.getOrderMin() && this.hasAllSky;
        Tile allsky = null;
        if (lowResolution && (allsky = this.tileList.get(addr = this.createAddr(v, this.getOrderMin(), -1L))) == null) {
            allsky = new TileAllsky(this, addr);
            try {
                allsky.loadNow();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (v.isAllSky()) {
            npix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (int i = 0; i < npix.length; ++i) {
                npix[i] = i;
            }
        } else {
            npix = this.getNpixList(v, this.getCooCentreHiPS(v), order);
        }
        int channel = this.getChannel(v);
        for (int i = 0; i < npix.length; ++i) {
            Tile tile;
            addr = this.createAddr(v, order, npix[i]);
            if (this.isOutMoc(order, npix[i]) || this.isOutView(v, addr)) continue;
            if (lowResolution && allsky != null) {
                tile = allsky.getTileList()[i];
            } else {
                tile = this.getTile(addr, true);
                try {
                    tile.loadNow();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (tile.getStatus() != 6) continue;
            tile.resetTimer();
            tile.draw(g, v, channel);
        }
    }

    protected synchronized void drawTiles(Graphics g, ViewSimple v, boolean now, BufferedImage imgb) {
        if (now) {
            this.drawTilesNow(g, v, imgb);
        } else {
            this.drawTilesAsync(g, v, imgb);
        }
        if (Aladin.TESTHIPSDOUBLEPAINT) {
            this.drawHoles(imgb, v);
        }
    }

    protected boolean isOutMoc(int order, long npix) {
        int frameMoc;
        if (this.moc == null) {
            return false;
        }
        char a = this.moc.getSpaceSys().charAt(0);
        int n = a == 'G' ? 3 : (frameMoc = a == 'E' ? 2 : 0);
        if (this.frameOrigin != frameMoc) {
            return false;
        }
        boolean res = false;
        try {
            SMoc m = this.moc.getSpaceMoc();
            res = !m.isIntersecting(order, npix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    protected boolean isOutView(ViewSimple v, Addr addr) {
        if (addr.npixZ != -1L) {
            try {
                double freqMin = CalibFreq.pix2freqStart(addr.orderZ, addr.npixZ);
                double freqMax = CalibFreq.pix2freqStart(addr.orderZ, addr.npixZ + 1L);
                double[] rangeFreq = v.getSpectrogramRange();
                if (rangeFreq != null && (freqMax < rangeFreq[0] || freqMin > rangeFreq[1])) {
                    return true;
                }
            }
            catch (Exception freqMin) {
                // empty catch block
            }
        }
        Hpix hpix = new Hpix(addr.order, addr.npix, this.frameOrigin);
        return hpix.isOutView(v);
    }

    protected Addr createAddr(ViewSimple v, int order, long npix) {
        return new Addr(order, npix, (int)this.getZ(v));
    }

    protected Addr createAddr(int order, long npix, int z) {
        return new Addr(order, npix, z);
    }

    protected Addr createAllSkyAddr(int order) {
        return new Addr(order, -1L);
    }

    protected int getChannel() {
        return this.getChannel(this.aladin.view.getCurrentView());
    }

    protected int getChannel(ViewSimple v) {
        return 0;
    }

    protected long[] moveInFirst(long[] npix, int order, Coord center) {
        block3: {
            try {
                if (center == null) break block3;
                long firstPix = this.getNpix(order, center);
                for (int i = 0; i < npix.length; ++i) {
                    if (npix[i] != firstPix) continue;
                    long a = npix[0];
                    npix[0] = npix[i];
                    npix[i] = a;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return npix;
    }

    protected void drawTilesAsync(Graphics g, ViewSimple v, BufferedImage imgb) {
        Tile allsky;
        this.allTilesDrawn = false;
        boolean first = true;
        long t1 = cds.tools.Util.getTime(0);
        int nb = 0;
        long[] npix = null;
        int channel = this.getChannel(v);
        int min = Math.max(this.getOrderMin(), this.orderMin);
        int max = Math.min(this.getOrderMaxInView(v), this.orderMax);
        boolean allTilesReady = false;
        boolean oneTileReady = false;
        boolean allskyDrawn = false;
        Object debug = null;
        Tile tile = allsky = this.isDynHips() ? null : this.tileList.get(this.createAddr(v, this.getOrderMin(), -1L));
        if (this.isDynHips()) {
            min = 3;
        }
        if (min < this.getOrderMin()) {
            if (this.drawAllSky(g, v, imgb)) {
                ++nb;
            }
            allskyDrawn = true;
        } else {
            int cmin;
            boolean hipsRGB;
            boolean fast = this.mustDrawFast();
            boolean bl = hipsRGB = v.getSpectrogram() != null && v.getSpectrogram().isModeRGB();
            if (fast || hipsRGB) {
                min = max;
            }
            Coord center = this.getCooCentreHiPS(v);
            allTilesReady = true;
            if (max < this.getOrderMin()) {
                allTilesReady = false;
            } else {
                npix = this.getNpixList(v, center, max);
                for (int i = 0; i < npix.length; ++i) {
                    Addr addr = this.createAddr(v, max, npix[i]);
                    Tile t = this.getTile(addr, false);
                    if (t == null) {
                        if (this.isOutMoc(max, npix[i]) || this.isOutView(v, addr)) {
                            npix[i] = -1L;
                            continue;
                        }
                        allTilesReady = false;
                        break;
                    }
                    if (this.isOutMoc(max, npix[i]) || t.isOutView(v)) {
                        npix[i] = -1L;
                        continue;
                    }
                    int status = t.getStatus();
                    if (status != 6 && status != 7) {
                        allTilesReady = false;
                        break;
                    }
                    t.resetTimer();
                    oneTileReady = true;
                }
            }
            if (nb == 0 && max <= this.getOrderMin() && (!allTilesReady || !oneTileReady && allsky != null)) {
                if (this.drawAllSky(g, v, imgb)) {
                    ++nb;
                }
                allskyDrawn = true;
            }
            this.resetPriority();
            Tile tile2 = null;
            int n = min < max && allTilesReady ? max : (cmin = min < max - 3 ? max - 3 : min);
            if (this.aladin.isAnimated() && cmin < max - 1) {
                cmin = max - 1;
                oneTileReady = true;
            }
            if (max >= this.getOrderMin()) {
                for (int order = cmin; order <= max || !oneTileReady && order <= max + 2 && order <= this.orderMax; ++order) {
                    if (!allTilesReady) {
                        npix = this.getNpixList(v, center, order);
                    }
                    if (npix.length == 0) break;
                    nDraw1 += npix.length;
                    npix = this.moveInFirst(npix, order, center);
                    for (int i = 0; i < npix.length; ++i) {
                        int n2;
                        Tile testIn;
                        if (npix[i] == -1L) continue;
                        Addr addr = this.createAddr(v, order, npix[i]);
                        tile2 = this.getTile(addr, false);
                        Tile tile3 = testIn = tile2 != null ? tile2 : new Tile(this, addr, 0);
                        if (!allTilesReady && (this.isOutMoc(order, npix[i]) || testIn.isOutView(v))) {
                            ++nOut1;
                            npix[i] = -1L;
                            continue;
                        }
                        if (tile2 == null && order <= max) {
                            tile2 = this.getTile(addr, true);
                        }
                        if (tile2 == null) continue;
                        if (order < max) {
                            n2 = 500 - this.priority++;
                        } else {
                            int n3 = this.priority;
                            n2 = n3;
                            this.priority = n3 + 1;
                        }
                        tile2.priority = n2;
                        int status = tile2.getStatus();
                        if (status == 7) continue;
                        if (status == 8) {
                            tile2.setStatus(1, true);
                        }
                        tile2.resetTimer();
                        if (status != 6) continue;
                        int m = tile2.draw(g, v, channel);
                        nb += m;
                        this.setHealpixPreviousFrame(order, npix[i]);
                        if (!first || this.isColored()) continue;
                        first = false;
                        this.pixels = tile2.getChannelPix8(channel);
                        this.pixelsOrigin = tile2.pixelsOrigin;
                        this.resetHist();
                    }
                }
            }
            boolean bl2 = this.allTilesDrawn = allTilesReady || max <= this.getOrderMin() && this.hasDrawnSomething;
        }
        if (this.isPause() && nb == 0 && !allskyDrawn && allsky != null && allsky.getStatus() == 6 && this.drawAllSky(g, v, imgb)) {
            ++nb;
        }
        this.hasDrawnSomething = nb > 0;
        this.tryWakeUp();
        long t2 = cds.tools.Util.getTime(0);
        long l = (t2 - t1) / 1000000L;
        this.statTimeDisplayArray[this.nStat++] = l;
        long statTime = l;
        if (this.nStat == this.statTimeDisplayArray.length) {
            this.nStat = 0;
        }
        long totalStatTime = 0L;
        int nbStat = 0;
        for (int i = 0; i < this.statTimeDisplayArray.length; ++i) {
            if (this.statTimeDisplayArray[i] == 0L) continue;
            totalStatTime += this.statTimeDisplayArray[i];
            ++nbStat;
        }
        this.statTimeDisplay = nbStat > 0 ? totalStatTime / (long)nbStat : -1L;
        this.statNbItems = nb;
    }

    protected Tile getHealpixPreviousFrame(int order, long npix) {
        return null;
    }

    protected void setHealpixPreviousFrame(int order, long npix) {
    }

    protected double getFps() {
        return this.mustDrawFast() ? 0.0 : (this.statTimeDisplay > 0L ? 1000.0 / (double)this.statTimeDisplay : -1.0);
    }

    private synchronized boolean isFading() {
        return this.fading;
    }

    protected synchronized void resetFading() {
        this.fading = false;
    }

    protected synchronized void updateFading(boolean flag) {
        this.fading |= flag;
    }

    protected void askForRepaint() {
        this.askForRepaint(null);
    }

    protected void askForRepaint(ViewSimple v) {
        this.changeImgID();
        if (this.aladin.view == null) {
            return;
        }
        if (this.first) {
            this.first = false;
            this.aladin.view.setRepere(this);
        }
        if (v == null) {
            this.aladin.view.repaintAll();
        } else {
            v.repaint();
        }
    }

    protected void drawForeground(Graphics gv, ViewSimple v) {
        this.drawForeground1(gv, v);
    }

    private void drawForeground1(Graphics gv, ViewSimple v) {
        v = v.getProjSyncView();
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            if (this.aladin.calque.hasHpxGrid()) {
                this.drawHealpixGrid(gv, v);
            }
            return;
        }
        Graphics2D g = (Graphics2D)gv;
        int x = 0;
        int y = 0;
        int rayon = 0;
        int grandAxe = 0;
        double angle = 0.0;
        if (v.getTaille() < 15.0) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color bckCol = v.getCouleurFond();
        g.setColor(bckCol);
        Stroke st = g.getStroke();
        int epaisseur = this.projd.t == 7 || this.projd.t == 17 ? 20 : 100;
        g.setStroke(new BasicStroke(epaisseur));
        Projection projd = v.getProj().copy();
        projd.setProjCenter(0.0, 0.0);
        projd.frame = 0;
        rayon = 0;
        int m = epaisseur / 2;
        int chouilla = 1;
        if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
            Coord c = projd.c.getProjCenter();
            projd.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            c.del = c.del + signe * (double)(projd.t == 1 ? 89 : 179);
            projd.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            double deltaY = haut.y - center.y;
            double deltaX = haut.x - center.x;
            rayon = (int)Math.abs(Math.sqrt(deltaX * deltaX + deltaY * deltaY)) - chouilla;
            x = (int)(center.x - (double)rayon);
            y = (int)(center.y - (double)rayon);
            g.drawOval(x - m, y - m, (rayon + m) * 2, (rayon + m) * 2);
        } else if (projd.t == 4 || projd.t == 11) {
            Projection p = projd.copy();
            angle = -p.c.getProjRot();
            p.setProjRot(0.0);
            p.frame = 0;
            p.setProjCenter(0.0, 0.1);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            double del = c.del;
            c.del += signe * 89.0;
            p.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            c.del = del;
            c.al += 179.0;
            p.getXYNative(c);
            PointD droit = v.getViewCoordDble(c.x, c.y);
            rayon = (int)Math.abs(haut.y - center.y) - chouilla;
            grandAxe = (int)Math.abs(droit.x - center.x) - chouilla;
            x = (int)(center.x - (double)grandAxe);
            y = (int)(center.y - (double)rayon);
            if (angle == 0.0) {
                g.drawOval(x - m, y - m, (grandAxe + m) * 2, (rayon + m) * 2);
            } else {
                cds.tools.Util.drawEllipse(g, x + grandAxe, y + rayon, grandAxe + m, rayon + m, angle);
            }
        } else if (projd.t == 7) {
            projd = v.getProjSyncView().getProj();
            Coord c1 = new Coord(1.0, 89.0);
            projd.getXYNative(c1);
            Point p1 = v.getViewCoord(c1.x, c1.y);
            Coord c2 = new Coord(359.0, -89.0);
            projd.getXYNative(c2);
            Point p2 = v.getViewCoord(c2.x, c2.y);
            x = p1.x;
            y = p1.y;
            int w = p2.x - p1.x;
            int h = p2.y - p1.y;
            g.drawRect(x, y, w, h);
        } else if (projd.t == 17) {
            Projection p = projd.copy();
            p.setProjCenter(0.0, 0.0);
            Coord c = p.c.getProjCenter();
            p.getXY(c);
            Point center = v.getViewCoord(c.x, c.y);
            c.al += 180.0;
            p.getXY(c);
            Point gauche = v.getViewCoord(c.x, c.y);
            x = gauche.x;
            y = 0;
            int w = 2 * (center.x - gauche.x);
            int h = v.rv.height;
            g.drawLine(x, 0, x, h);
            g.drawLine(x + w, 0, x + w, h);
        }
        g.setStroke(st);
        if (this.pixMode != 0 && this.pixMode != 1 && this.video == 1) {
            m = 0;
            g.setStroke(new BasicStroke(2.0f));
            if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
                g.drawOval(x - m, y - m, (rayon + m) * 2, (rayon + m) * 2);
            } else if (projd.t == 4 || projd.t == 11) {
                if (angle == 0.0) {
                    g.drawOval(x - m, y - m, (grandAxe + m) * 2, (rayon + m) * 2);
                } else {
                    cds.tools.Util.drawEllipse(g, x + grandAxe, y + rayon, grandAxe + m, rayon + m, angle);
                }
            }
            g.setStroke(st);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private Color getColorHoles() {
        int b;
        int g;
        int r;
        if (this.isTransparent()) {
            r = 69;
            g = 145;
            b = 161;
        } else if (this.color) {
            b = 0;
            g = 0;
            r = 0;
        } else if (this.cm == null) {
            b = 255;
            g = 255;
            r = 255;
        } else {
            r = this.cm.getRed(0);
            g = this.cm.getGreen(0);
            b = this.cm.getBlue(0);
        }
        if (Aladin.TESTHIPSDOUBLEPAINT) {
            b = b == 255 ? --b : ++b;
        }
        return new Color(r, g, b);
    }

    protected void drawBackground(Graphics g, ViewSimple v) {
        if (this.aladin.calque.hasHpxGrid() || this.isOverlay()) {
            return;
        }
        Projection projd = v.getProjSyncView().getProj().copy();
        projd.setProjCenter(0.0, 0.0);
        projd.frame = 0;
        int x = 0;
        int y = 0;
        int rayon = 0;
        int grandAxe = 0;
        double angle = 0.0;
        Color bckCol = this.getColorHoles();
        g.setColor(bckCol);
        rayon = 0;
        boolean isTransparent = this.isTransparent();
        if (projd.t == 1 || projd.t == 3 || projd.t == 5) {
            Coord c = projd.c.getProjCenter();
            projd.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            c.del = c.del + signe * (double)(projd.t == 1 ? 89 : 179);
            projd.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            double deltaY = haut.y - center.y;
            double deltaX = haut.x - center.x;
            rayon = (int)Math.abs(Math.sqrt(deltaX * deltaX + deltaY * deltaY));
            x = (int)(center.x - (double)rayon);
            y = (int)(center.y - (double)rayon);
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(x, y, new Color(0, 0, 70), x + rayon * 2, y + rayon * 2, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillOval(x, y, rayon * 2, rayon * 2);
                g2d.setPaint(paint);
            } else {
                g.fillOval(x, y, rayon * 2, rayon * 2);
            }
        } else if (projd.t == 4 || projd.t == 11) {
            Projection p = projd.copy();
            angle = -p.c.getProjRot();
            p.setProjRot(0.0);
            p.frame = 0;
            p.setProjCenter(0.0, 0.1);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            PointD center = v.getViewCoordDble(c.x, c.y);
            double signe = c.del < 0.0 ? 1.0 : -1.0;
            double del = c.del;
            c.del += signe * 89.0;
            p.getXYNative(c);
            PointD haut = v.getViewCoordDble(c.x, c.y);
            c.del = del;
            c.al += 179.0;
            p.getXYNative(c);
            PointD droit = v.getViewCoordDble(c.x, c.y);
            rayon = (int)Math.abs(haut.y - center.y);
            grandAxe = (int)Math.abs(droit.x - center.x);
            x = (int)(center.x - (double)grandAxe);
            y = (int)(center.y - (double)rayon);
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(x + rayon / 4, y + rayon / 4, new Color(0, 0, 70), x + grandAxe * 2 - rayon / 4, y + rayon * 2 - rayon / 4, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                if (angle == 0.0) {
                    g.fillOval(x, y, grandAxe * 2, rayon * 2);
                } else {
                    cds.tools.Util.fillEllipse(g, x + grandAxe, y + rayon, grandAxe, rayon, angle);
                }
                g2d.setPaint(paint);
            } else if (angle == 0.0) {
                g.fillOval(x, y, grandAxe * 2, rayon * 2);
            } else {
                cds.tools.Util.fillEllipse(g, x + grandAxe, y + rayon, grandAxe, rayon, angle);
            }
        } else if (projd.t == 7) {
            projd = v.getProjSyncView().getProj();
            Coord c1 = new Coord(1.0, 89.0);
            projd.getXYNative(c1);
            Point p1 = v.getViewCoord(c1.x, c1.y);
            Coord c2 = new Coord(359.0, -89.0);
            projd.getXYNative(c2);
            Point p2 = v.getViewCoord(c2.x, c2.y);
            x = p1.x;
            y = p1.y;
            int w = p2.x - p1.x;
            int h = p2.y - p1.y;
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), w, h, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillRect(x, y, w, h);
                g2d.setPaint(paint);
            } else {
                g.fillRect(x, y, w, h);
            }
        } else if (projd.t == 17) {
            Projection p = projd.copy();
            p.setProjCenter(0.0, 0.0);
            Coord c = p.c.getProjCenter();
            p.getXYNative(c);
            Point center = v.getViewCoord(c.x, c.y);
            c.al += 180.0;
            p.getXYNative(c);
            Point gauche = v.getViewCoord(c.x, c.y);
            x = gauche.x;
            y = 0;
            int w = 2 * (center.x - gauche.x);
            int h = v.rv.height;
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), w, h, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillRect(x, y, w, h);
                g2d.setPaint(paint);
            } else {
                g.fillRect(x, y, w, h);
            }
        } else {
            int w = v.rv.width;
            int h = v.rv.height;
            if (isTransparent) {
                Graphics2D g2d = (Graphics2D)g;
                Paint paint = g2d.getPaint();
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 70), w, h, new Color(180, 190, 200));
                g2d.setPaint(gradient);
                g.fillRect(0, 0, w, h);
                g2d.setPaint(paint);
            } else {
                g.fillRect(0, 0, w, h);
            }
        }
    }

    protected boolean isSegmentIAUConv() {
        return this.segmentIAUConv;
    }

    protected float getSegmentLenFactor() {
        return this.segmentLenFactor;
    }

    protected void setSegmentLenFactor(float segmentLenFactor) {
        this.segmentLenFactor = segmentLenFactor;
    }

    protected int getSegmentThickness() {
        return this.segmentThickness;
    }

    protected void setSegmentThickness(int segmentThickness) {
        this.segmentThickness = segmentThickness;
    }

    protected float getSegmentDensityFactor() {
        return this.segmentDensityFactor;
    }

    protected void setSegmentDensityFactor(float segmentDensityFactor) {
        this.segmentDensityFactor = segmentDensityFactor;
    }

    private void shouldRefresh() {
        long t = System.currentTimeMillis();
        if (t - this.timerLastDrawBG < 500L) {
            return;
        }
        this.timerLastDrawBG = t;
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    protected boolean detectServerError(int[] nb) {
        if (this.moc == null) {
            return false;
        }
        this.removeTilesOutsideMoc();
        int nbReady = 0;
        int nbError = 0;
        for (Tile key : this.tileList.values()) {
            int status = key.getStatus();
            if (status == 6) {
                ++nbReady;
                continue;
            }
            if (status != 7) continue;
            ++nbError;
        }
        return nbReady == 0 && nbError > 5;
    }

    public String testnet() throws Exception {
        try {
            if (this.moc == null) {
                this.loadInternalMoc();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        long time = 0L;
        long tileTime = 0L;
        long allskyTime = 0L;
        long size = 0L;
        int minOrder = 3;
        long timeMax = 10000L;
        long start = System.currentTimeMillis();
        this.resetGzippedMode();
        System.out.println("Testnet HiPS " + this.label + " maxOrder=" + this.orderMax + " from " + this.url + " :");
        int n = 0;
        boolean allsky = false;
        int memo = Aladin.levelTrace;
        Aladin.levelTrace = 0;
        block4: while (true) {
            try {
                while (true) {
                    Tile hk;
                    if (System.currentTimeMillis() - start > timeMax) {
                        if (allsky) break block4;
                        allsky = true;
                    }
                    int order = minOrder + (int)(Math.random() * (double)(this.orderMax - minOrder));
                    ArrayList<String> a = new ArrayList<String>();
                    int nb = this.moc.getNbRanges();
                    int i = (int)(Math.random() * (double)nb);
                    long npix = (this.moc.seeRangeList().begins(i) + (this.moc.seeRangeList().ends(i) - 1L)) / 2L;
                    int shift = (29 - order) * 2;
                    String key = order + "/" + (npix >>>= shift);
                    if (a.contains(key)) continue;
                    a.add(key);
                    if (allsky) {
                        key = "3/-1";
                        hk = new TileAllsky(this, this.createAddr(3, -1L, 0), 4);
                    } else {
                        hk = new Tile(this, this.createAddr(order, npix, -1), 4);
                    }
                    long t = hk.timeNet;
                    long s = hk.sizeStream;
                    if (s == 0L) {
                        System.out.println(" error => " + this.url + "/" + hk.getFileNet());
                    } else {
                        System.out.println(".Loading " + key + " " + cds.tools.Util.getUnitDisk(s) + (hk.gzipped ? "/gzip" : "") + " in " + cds.tools.Util.getTemps(t * 1000L));
                    }
                    time += t;
                    if (allsky) {
                        allskyTime = t;
                    } else {
                        tileTime += t;
                    }
                    size += s;
                    ++n;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        Aladin.levelTrace = memo;
        System.out.println("=> Downloaded " + n + " tiles in " + Tile.EXT[this.getTileMode()] + " : " + cds.tools.Util.getUnitDisk(size) + " in " + cds.tools.Util.getTemps(time * 1000L));
        long rate = (long)((double)size / ((double)time / 1000.0));
        String res = "=> Stream rate " + cds.tools.Util.getUnitDisk(rate) + "/s (" + n + " tiles)";
        System.out.println(res);
        this.aladin.console.printInfo(this.label + " net perf " + res);
        return cds.tools.Util.getUnitDisk(rate) + "/s (" + n + " tiles/avg=" + cds.tools.Util.getTemps(tileTime / (long)(n - 1) * 1000L) + " allsky/" + cds.tools.Util.getTemps(allskyTime * 1000L) + ")";
    }

    protected void incrGzipMode(int mode, long t) {
        if (this.inJPEG || this.inPNG) {
            return;
        }
        if (mode == 1) {
            ++this.nbgzip;
            this.timegzip += t;
        } else {
            ++this.nbnogzip;
            this.timenogzip += t;
        }
    }

    protected void resetGzippedMode() {
        this.nbnogzip = 0;
        this.nbgzip = 0;
        this.timenogzip = 0L;
        this.timegzip = 0L;
        this.gzipMode = 0;
    }

    protected int getGzippedMode() {
        if (this.inJPEG || this.inPNG) {
            return 2;
        }
        if (this.gzipMode > 0) {
            return this.gzipMode;
        }
        if (this.gzipMode == 0) {
            if (this.nbgzip < 2) {
                return -1;
            }
            if (this.nbnogzip < 2) {
                return -2;
            }
            if (this.nbgzip == 0) {
                return -1;
            }
            if (this.nbnogzip == 0) {
                return -2;
            }
            this.gzipMode = this.timegzip / (long)this.nbgzip < this.timenogzip / (long)this.nbnogzip ? 1 : 2;
        }
        return this.gzipMode;
    }

    public void center(Coord coord) {
        this.aladin.view.setRepere(coord);
        this.aladin.view.showSource();
        this.aladin.view.zoomview.repaint();
        this.aladin.calque.repaintAll();
    }

    protected void resetStats() {
        this.cumulTimeDraw = 0L;
        this.cumulTimeWriteCache = 0L;
        this.cumulTimeLoadCache = 0L;
        this.cumulTimeLoadNet = 0L;
        this.cumulTimePixel = 0L;
        this.cumulTimeUncmp = 0L;
        this.cumulTimeStream = 0L;
        this.nbWriteCache = 0;
        this.nbLoadCache = 0;
        this.nbLoadNet = 0;
        this.nByteWriteCache = 0L;
        this.nByteReadCache = 0L;
        this.nByteReadNet = 0L;
        this.nbImgDraw = 0;
        this.nbAborted = 0;
        this.nbFree = 0;
        this.nbCreated = 0;
        this.nbImgInBuf = 0;
        this.nbImgCreated = 0;
        this.resetGzippedMode();
    }

    @Override
    protected String getStats() {
        return "HealpixKey stats: " + this.label + ":\n.Created: " + this.nbCreated + "   Abort: " + this.nbAborted + "   Free: " + this.nbFree + "\n.Net   : " + this.nbLoadNet + " => " + cds.tools.Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb in ~" + cds.tools.Util.round(this.avgLoadNet(), 0) + "ms " + this.streamJpegPixel() + "\n.CacheR: " + this.nbLoadCache + " => " + cds.tools.Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb in ~" + cds.tools.Util.round(this.avgLoadCache(), 0) + "ms\n.CacheW: " + this.nbWriteCache + " => " + cds.tools.Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb in ~" + cds.tools.Util.round(this.avgWriteCache(), 0) + "ms\n.Img created: " + this.nbImgCreated + "    reused:" + this.nbImgInBuf + "    drawn " + this.nbImgDraw + " in ~" + cds.tools.Util.round(this.avgDraw(), 0) + "ms\n";
    }

    public String getCreatorFromId() {
        String s = this.id;
        if (s == null) {
            return null;
        }
        if (s.startsWith("ivo://")) {
            s = s.substring(6);
        }
        int offset = s.indexOf(47);
        int offset1 = s.indexOf(63);
        if (offset == -1 && offset1 == -1) {
            return null;
        }
        if (offset == -1) {
            offset = s.length();
        }
        if (offset1 == -1) {
            offset1 = s.length();
        }
        if (offset1 < offset) {
            offset = offset1;
        }
        return s.substring(0, offset);
    }

    private String getHost() {
        int i = this.url.indexOf("//");
        if (i == -1) {
            return "?";
        }
        int j = this.url.indexOf("/", i + 2);
        if (j < 0) {
            j = this.url.length();
        }
        return this.url.substring(i + 2, j);
    }

    protected String getShortStats() {
        if (this.nbLoadNet == 0 && this.nbLoadCache == 0) {
            return null;
        }
        boolean flagLocal = this.isLocalHips();
        String name = this.id != null ? this.id : this.label;
        return name + (flagLocal ? " Local:" : " Net[" + this.getHost() + "]:") + this.nbLoadNet + "/" + cds.tools.Util.round((double)this.nByteReadNet / 1048576.0, 2) + "Mb/" + cds.tools.Util.round(this.avgLoadNet(), 0) + "ms CacheR:" + this.nbLoadCache + "/" + cds.tools.Util.round((double)this.nByteReadCache / 1048576.0, 2) + "Mb/" + cds.tools.Util.round(this.avgLoadCache(), 0) + "ms CacheW:" + this.nbWriteCache + "/" + cds.tools.Util.round((double)this.nByteWriteCache / 1048576.0, 2) + "Mb/" + cds.tools.Util.round(this.avgWriteCache(), 0) + "ms";
    }

    protected String streamJpegPixel() {
        if (this.nbLoadNet == 0) {
            return "";
        }
        return "(stream=" + cds.tools.Util.round(this.cumulTimeStream / (long)this.nbLoadNet, 1) + "/jpeg=" + cds.tools.Util.round(this.cumulTimeUncmp / (long)this.nbLoadNet, 1) + "/getpix=" + cds.tools.Util.round(this.cumulTimePixel / (long)this.nbLoadNet, 1) + ")";
    }

    protected String getNetSpeed() {
        long r = this.rateLoadNet();
        int er = this.nbTileError();
        if (er == 0 && r == 0L) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        if (r != 0L) {
            s.append(cds.tools.Util.getUnitDisk(r) + "/s");
        }
        if (er > 0) {
            if (s.length() > 0) {
                s.append(" - ");
            }
            s.append("tile errors: " + er + "/" + this.tileList.size() + " (" + cds.tools.Util.myRound(100.0 * (double)er / (double)this.tileList.size()) + "%)");
        }
        return s.toString();
    }

    protected int nbTileError() {
        if (this.moc == null) {
            return 0;
        }
        this.removeTilesOutsideMoc();
        Enumeration e = this.tileList.elements();
        int n = 0;
        while (e.hasMoreElements()) {
            Tile h = (Tile)e.nextElement();
            if (h.getStatus() != 7) continue;
            ++n;
            Aladin.trace(4, "Error on " + h);
        }
        return n;
    }

    protected long rateLoadNet() {
        if (this.cumulTimeLoadNet == 0L) {
            return 0L;
        }
        long r = this.nByteReadNet / this.cumulTimeLoadNet * 1000L;
        return r;
    }

    protected double avgDraw() {
        if (this.nbImgDraw == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeDraw / (double)this.nbImgDraw / 1000000.0;
    }

    protected double avgLoadNet() {
        if (this.nbLoadNet == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadNet / (double)this.nbLoadNet;
    }

    protected double avgLoadCache() {
        if (this.nbLoadCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeLoadCache / (double)this.nbLoadCache;
    }

    protected double avgWriteCache() {
        if (this.nbWriteCache == 0) {
            return 0.0;
        }
        return (double)this.cumulTimeWriteCache / (double)this.nbWriteCache;
    }

    class TileList
    extends Hashtable<String, Tile> {
        TileList() {
            super(1000);
        }

        public synchronized Tile get(Addr addr) {
            Tile hk = (Tile)this.get(PlanHips.this.key(addr));
            if (hk != null) {
                hk.addr.z = addr.z;
            }
            return hk;
        }

        @Override
        public synchronized Tile put(Addr addr, Tile v) {
            return this.put(PlanHips.this.key(addr), v);
        }
    }

    class TileLoader
    implements Runnable {
        static final int POOLSIZE = 1;
        boolean POOLTEST = false;
        static final int DELAI = 10000;
        private boolean loading = false;
        private boolean purging = false;
        private Thread thread = null;
        private Loader cacheLoader;
        private Loader netLoader;
        private Loader[] netPool;
        private volatile boolean sleep;
        private boolean isSleeping = false;
        private Object lockSleep = new Object();
        private long ot = -1L;

        TileLoader() {
            this.cacheLoader = new Loader(0);
            if (this.POOLTEST) {
                this.netPool = new Loader[1];
                for (int i = 0; i < this.netPool.length; ++i) {
                    this.netPool[i] = new Loader(1);
                }
            } else {
                this.netLoader = new Loader(1);
            }
            this.wakeUp();
        }

        protected boolean isReadyForDrawing() {
            return PlanHips.this.readyAfterDraw;
        }

        protected boolean isLoading() {
            return this.loading;
        }

        protected boolean isPurging() {
            return this.purging;
        }

        protected void wakeUp() {
            if (this.thread != null) {
                this.loading = true;
                this.noSleep();
                if (this.isSleeping()) {
                    this.thread.interrupt();
                }
            } else {
                this.thread = new Thread((Runnable)this, "HealpixLoader");
                this.thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void noSleep() {
            Object object = this.lockSleep;
            synchronized (object) {
                this.sleep = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isSleeping() {
            Object object = this.lockSleep;
            synchronized (object) {
                return this.isSleeping;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSleep(boolean flag) {
            Object object = this.lockSleep;
            synchronized (object) {
                this.isSleeping = flag;
            }
        }

        private boolean shouldRun() {
            return this.isLoading() || this.isPurging();
        }

        @Override
        public void run() {
            cds.tools.Util.pause(100);
            if (PlanHips.this.useCache) {
                this.cacheLoader.start();
            }
            if (this.POOLTEST) {
                for (Loader a : this.netPool) {
                    a.start();
                }
            } else {
                this.netLoader.start();
            }
            do {
                this.sleep = true;
                try {
                    try {
                        this.launchJob();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (PlanHips.this.useCache) {
                        PlanHips.scanCache();
                    }
                    if (!this.sleep) continue;
                    this.setSleep(true);
                    try {
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.setSleep(false);
                }
                catch (Throwable e1) {
                    e1.printStackTrace();
                }
            } while (this.shouldRun());
            if (PlanHips.this.useCache) {
                this.cacheLoader.stop();
            }
            if (this.POOLTEST) {
                for (Loader a : this.netPool) {
                    a.stop();
                }
            } else {
                this.netLoader.stop();
            }
            this.thread = null;
            PlanHips.this.nbFlush = 0;
            PlanHips.this.aladin.gcIfRequired();
        }

        private void launchJob() throws Exception {
            boolean stillOnePurge = false;
            boolean perhapsOneDeath = false;
            int[] nb = new int[Tile.NBSTATUS];
            Aladin cfr_ignored_0 = PlanHips.this.aladin;
            boolean flagVerbose = Aladin.levelTrace >= 5;
            boolean first = true;
            int n = 0;
            try {
                ArrayList<Tile> list = new ArrayList<Tile>();
                Enumeration e = PlanHips.this.tileList.elements();
                while (e.hasMoreElements()) {
                    list.add((Tile)e.nextElement());
                }
                try {
                    Collections.sort(list);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Tile tile : list) {
                    int live;
                    int status = tile.getStatus();
                    if (flagVerbose && status != 7) {
                        first = false;
                    }
                    if ((live = tile.getLive()) == -1) {
                        PlanHips.this.purgeTile(tile);
                    } else if (live == -2) {
                        perhapsOneDeath = true;
                        stillOnePurge = true;
                    } else if (status == 6) {
                        tile.purgeFils();
                    }
                    switch (status) {
                        case 1: {
                            if (!tile.allSky && tile.priority >= 1000) {
                                tile.setOld();
                                break;
                            }
                            if (PlanHips.this.useCache && tile.isCached()) {
                                status = 2;
                                tile.setStatus(2);
                                break;
                            }
                            status = 3;
                            tile.setStatus(3);
                            break;
                        }
                        case 6: {
                            if (!PlanHips.this.useCache) break;
                            tile.write();
                        }
                    }
                    int n2 = status;
                    nb[n2] = nb[n2] + 1;
                    if (tile.priority < 250 && status != 6 && status != 7) {
                        ++n;
                        continue;
                    }
                    if (tile.addr.npix != -1L || status == 6 || status == 7) continue;
                    n += 10;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.loading = nb[1] > 0 || nb[2] > 0 || nb[3] > 0 || nb[4] > 0 || nb[5] > 0;
            boolean bl = this.purging = stillOnePurge || nb[9] > 0;
            PlanHips.this.pourcent = n == 0 ? -2.0 : (n >= 10 ? 1.0 : (double)(10 - n) * 10.0);
            PlanHips.this.readyAfterDraw = n == 0;
            PlanHips.this.nbReady = nb[6];
            if (PlanHips.this.detectServerError(nb)) {
                PlanHips.this.error = "Server not available";
            }
            Tile healpixMin = null;
            Tile healpixNet = null;
            int min = Integer.MAX_VALUE;
            Enumeration e = PlanHips.this.tileList.elements();
            while (e.hasMoreElements()) {
                Tile healpix = (Tile)e.nextElement();
                int status = healpix.getStatus();
                if (status != 3 && status != 5) continue;
                if (status == 5) {
                    healpixNet = healpix;
                }
                if (healpix.priority >= min) continue;
                min = healpix.priority;
                healpixMin = healpix;
            }
            if (healpixNet != null && healpixNet != healpixMin) {
                healpixNet.abort();
            }
            if (nb[2] > 0) {
                this.cacheLoader.wakeUp();
            }
            if (nb[3] > 0) {
                if (this.POOLTEST) {
                    for (Loader a : this.netPool) {
                        if (!a.isPause()) continue;
                        a.wakeUp();
                    }
                } else {
                    this.netLoader.wakeUp();
                }
            }
            if (PlanHips.this.aladin.calque != null && PlanHips.this.oLoading != this.loading) {
                PlanHips.this.oLoading = this.loading;
                PlanHips.this.aladin.calque.select.repaint();
            }
            if (perhapsOneDeath) {
                PlanHips.this.shouldRefresh();
            }
        }
    }

    static class FileItem {
        File f;
        long date;

        FileItem(File f) {
            this.f = f;
            this.date = f.lastModified();
        }

        boolean hasBeenModified() {
            return this.date != this.f.lastModified();
        }
    }

    class Loader
    implements Runnable {
        boolean encore;
        Thread thread;
        int type;
        String label;
        private boolean pause = false;

        Loader(int type) {
            this.type = type;
            this.label = (type == 0 ? "LoaderCache-" : "LoaderNet-") + THREADID++;
        }

        void start() {
            this.encore = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
            this.thread = new Thread((Runnable)this, this.label);
            if (!Aladin.NOGUI) {
                cds.tools.Util.decreasePriority(Thread.currentThread(), this.thread);
            }
            this.thread.start();
        }

        void wakeUp() {
            if (this.thread == null) {
                this.start();
            } else if (this.pause) {
                this.thread.interrupt();
            }
        }

        synchronized void setPause(boolean flag) {
            this.pause = flag;
        }

        boolean isPause() {
            return this.pause;
        }

        void stop() {
            this.encore = false;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void run() {
            while (this.encore) {
                try {
                    boolean flagLoad;
                    block16: {
                        flagLoad = false;
                        try {
                            ArrayList<Tile> list = new ArrayList<Tile>();
                            MyEnum e = new MyEnum(PlanHips.this.tileList);
                            while (e.hasMoreElements()) {
                                Tile tile = (Tile)e.nextElement();
                                int status = tile.getStatus();
                                if (this.type == 0 && status == 2) {
                                    tile.loadFromCache();
                                    if (!tile.allSky) {
                                        PlanHips.this.setOrderTile(tile.getLosangeOrder());
                                    }
                                    flagLoad = true;
                                    continue;
                                }
                                if (this.type != 1 || status != 3) continue;
                                list.add(tile);
                            }
                            long t0 = System.currentTimeMillis();
                            if (list.size() > 0) {
                                Collections.sort(list);
                                for (Tile t : list) {
                                    t.waitLock();
                                    if (t.getStatus() != 3) {
                                        t.unLock();
                                        continue;
                                    }
                                    if (this.type == 0) {
                                        t.loadFromCache();
                                    } else {
                                        t.loadFromNet();
                                    }
                                    t.unLock();
                                    if (t.allSky) continue;
                                    PlanHips.this.setOrderTile(t.getLosangeOrder());
                                }
                                flagLoad = true;
                            }
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace < 3) break block16;
                            e.printStackTrace();
                        }
                    }
                    if (flagLoad) {
                        PlanHips.this.loader.wakeUp();
                        continue;
                    }
                    try {
                        this.setPause(true);
                        Thread.currentThread();
                        Thread.sleep(10000L);
                    }
                    catch (Exception e) {
                    }
                }
                catch (Throwable t) {
                    if (Aladin.levelTrace < 3) continue;
                    t.printStackTrace();
                }
            }
            Aladin.trace(5, "PlanBG.Loader (" + this.label + ") died !");
            this.thread = null;
        }
    }

    class MyEnum
    implements Enumeration<Tile> {
        Tile[] tab;
        int size;
        int pos;

        MyEnum(Hashtable<String, Tile> pixList) {
            int i;
            this.tab = new Tile[pixList.size()];
            Enumeration<Tile> e = pixList.elements();
            for (i = 0; e.hasMoreElements() && i < this.tab.length; ++i) {
                this.tab[i] = e.nextElement();
            }
            this.size = i;
            try {
                Arrays.sort(this.tab, 0, this.size);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pos = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos < this.size;
        }

        @Override
        public Tile nextElement() {
            return this.tab[this.pos++];
        }
    }
}

