/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanHips;
import cds.aladin.Projection;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewSimple;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.hipsgen.Constante;
import cds.hipsgen.Context;
import cds.moc.Healpix;
import cds.moc.Moc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.StringTokenizer;

public class PlanHealpix
extends PlanHips {
    static final int POLA_SEGMENT_MAGIC_CODE = -42;
    static final int POLA_AMPLITUDE_MAGIC_CODE = -41;
    static final int POLA_ANGLE_MAGIC_CODE = -40;
    static Object lock = new Object();
    private char coordsys;
    private int nSideFile;
    private int sizeRecord;
    private int nRecord;
    private int nField;
    private char[] typeHpx;
    private int[] lenHpx;
    private String dirName;
    private String ordering;
    private double badData;
    private boolean hasBadData;
    protected int idxTFormToRead;
    protected String[] tfieldNames;
    private int newNSideImage;
    private int newNSideFile;
    private int hpxOrderGeneratedImgs;
    private boolean isLocal;
    private boolean isGZ;
    private boolean isPartial;
    private boolean isARGB;
    private long[] partialHpxPixIdx;
    private int nbRecordsPartial;
    private String originalPath;
    private String pixelPath;
    private String tempFilePath;
    private int nbPixGeneratedImage;
    private int curTFormBitpix;
    private boolean fromProperties;
    boolean isAPlanet;
    private String dirCache;
    private boolean flagCache;
    static final String CACHEHPX = "HPX";
    HashMap partialValues;
    private int lastOrder;
    static final double DENSPROB = 3.0461741978670857E-4;
    private double[] ringValues;
    private RandomAccessFile rafHpx;
    private long initialOffsetHpx;
    private static String[] UPOL = new String[]{"U-POLARIZATION", "U_POLARIZATION", "U-POLARISATION", "U_POLARISATION", "U-Pol", "U_STOKES"};
    private static String[] QPOL = new String[]{"Q-POLARIZATION", "Q_POLARIZATION", "Q-POLARISATION", "Q_POLARISATION", "Q-Pol", "Q_STOKES"};

    public PlanHealpix(Aladin aladin, String file, MyInputStream in, String label, int mode, int idxTFormToRead, boolean fromProperties, Coord c, double radius) {
        super(aladin);
        this.hasBadData = false;
        this.idxTFormToRead = 0;
        this.isGZ = false;
        this.isPartial = false;
        this.isARGB = false;
        this.isAPlanet = false;
        this.dirCache = null;
        this.flagCache = false;
        this.lastOrder = 0;
        this.initialOffsetHpx = Long.MIN_VALUE;
        this.fromProperties = fromProperties;
        this.co = c;
        this.coRadius = radius;
        this.init(file, in, label, idxTFormToRead);
        this.setDrawMode(mode);
        this.threading();
    }

    public PlanHealpix(Aladin aladin, TreeObjDir gluSky, String label, Coord c, double radius, String startingTaskId) {
        MyInputStream in;
        String file;
        block3: {
            super(aladin);
            this.hasBadData = false;
            this.idxTFormToRead = 0;
            this.isGZ = false;
            this.isPartial = false;
            this.isARGB = false;
            this.isAPlanet = false;
            this.dirCache = null;
            this.flagCache = false;
            this.lastOrder = 0;
            this.initialOffsetHpx = Long.MIN_VALUE;
            this.startingTaskId = startingTaskId;
            this.fromProperties = false;
            this.gluTag = gluSky.getID();
            this.id = gluSky.internalId;
            file = gluSky.getUrl();
            in = null;
            try {
                in = Util.openAnyStream(file);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
        if (label == null) {
            label = gluSky.label;
        }
        this.co = c;
        this.coRadius = radius;
        this.init(file, in, label, 0);
        this.setDrawMode(0);
        this.threading();
    }

    public PlanHealpix(Aladin aladin) {
        super(aladin);
        this.hasBadData = false;
        this.idxTFormToRead = 0;
        this.isGZ = false;
        this.isPartial = false;
        this.isARGB = false;
        this.isAPlanet = false;
        this.dirCache = null;
        this.flagCache = false;
        this.lastOrder = 0;
        this.initialOffsetHpx = Long.MIN_VALUE;
    }

    @Override
    protected void log() {
    }

    protected void init(String file, MyInputStream in, String label, int idxTFormToRead) {
        this.isLocal = file == null || !file.startsWith("http") && !file.startsWith("ftp");
        this.idxTFormToRead = idxTFormToRead;
        this.video = this.aladin.configuration.getCMVideo();
        this.flagOk = false;
        this.isOldPlan = false;
        this.type = 16;
        this.frameOrigin = 3;
        this.dis = in;
        this.filename = file;
        this.cacheID = this.survey = file;
        this.originalPath = file;
        this.orderMax = 3;
        int i = file.lastIndexOf(Util.FS);
        if (i > 0) {
            this.survey = this.survey.substring(i + 1);
        }
        this.setLabel(label == null ? this.survey : label);
        this.survey = this.dirName = this.getDirname() + Util.FS + this.dirNameForIdx(idxTFormToRead);
        this.aladin.log("AllskyMap", label);
    }

    private String getDirname() {
        String s = null;
        if (this.isLocal) {
            File f = new File(this.originalPath);
            try {
                s = f.getCanonicalPath().replace('/', '_').replace('\\', '_').replace(':', '_').replace('.', '_').replace('?', '_');
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            s = this.originalPath.replace('/', '_').replace('\\', '_').replace(':', '_').replace('.', '_').replace('?', '_');
        }
        return s;
    }

    private String dirNameForIdx(int idx) {
        switch (idx) {
            case -42: {
                return "polarisation";
            }
            case -41: {
                return "polarisation_amplitude";
            }
            case -40: {
                return "polarisation_angle";
            }
        }
        return "TFIELD" + (idx + 1);
    }

    @Override
    protected boolean freePlan() {
        this.ringValues = null;
        return super.freePlan();
    }

    private void cleanup() {
        if (this.tempFilePath != null) {
            try {
                new File(this.tempFilePath).delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.tempFilePath = null;
        }
        this.partialValues = null;
        this.partialHpxPixIdx = null;
    }

    @Override
    protected int getOrderTile() {
        return (int)PlanHealpix.log2(this.nbPixGeneratedImage);
    }

    private boolean dumpStreamToFile(InputStream srcStream, File destFile) {
        BufferedOutputStream bos;
        Aladin.trace(2, "Dumping input stream to temp file: " + destFile.getName());
        BufferedInputStream bis = new BufferedInputStream(srcStream);
        try {
            bos = new BufferedOutputStream(new FileOutputStream(destFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = bis.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            bis.close();
            bos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        return true;
    }

    private void setPixelPath() throws IOException {
        if (this.isLocal && !this.isGZ) {
            this.pixelPath = this.originalPath;
        } else {
            this.tempFilePath = this.aladin.createTempFile("PlanHealpix", ".hpx").getCanonicalPath();
            this.dumpStreamToFile(this.dis, new File(this.tempFilePath));
            this.pixelPath = this.tempFilePath;
        }
        Aladin.trace(2, "isLocal: " + this.isLocal + ", isGZ: " + this.isGZ + ", originalPath: " + this.originalPath + ", pixelPath: " + this.pixelPath);
    }

    @Override
    protected boolean waitForPlan() {
        super.waitForPlan();
        try {
            boolean needProcessing = this.needProcessing(this.dirName, true);
            if (needProcessing) {
                try {
                    long type = this.dis.getType();
                    this.isGZ = (type & 0x20L) != 0L;
                    this.isARGB = (type & 0x400000000L) != 0L;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.setPixelPath();
            this.startHealpixCreation();
            if (needProcessing) {
                this.writePropertiesFile(this.dirName);
            }
            this.suiteSpecif();
            return true;
        }
        catch (Exception e) {
            this.error = "HEALPix error " + (e.getMessage() != null ? ": " + e.getMessage() : "");
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private String getCoordSys(char c) {
        if (c == 'C' || c == 'Q') {
            return "equatorial";
        }
        if (c == 'E') {
            return "ecliptic";
        }
        return "galactic";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePropertiesFile(String dir) {
        MyProperties prop = new MyProperties();
        prop.setProperty("dataPath", this.originalPath);
        if (this.isLocal) {
            try {
                String modifDate = new File(this.originalPath).lastModified() + "";
                prop.setProperty("lastModified", modifDate);
            }
            catch (Exception modifDate) {
                // empty catch block
            }
        }
        prop.setProperty("hips_release_date", Constante.getDate());
        prop.setProperty("hips_order", this.orderMax + "");
        prop.setProperty("nsideFile", this.newNSideImage + "");
        prop.setProperty("nsidePixel", this.newNSideFile + "");
        prop.setProperty("hips_tile_width", CDSHealpix.pow2(this.hpxOrderGeneratedImgs) + "");
        prop.setProperty("ordering", this.ordering);
        prop.setProperty("tfields", this.nField + "");
        prop.setProperty("ttypes", Util.join(this.tfieldNames, ','));
        prop.setProperty("localData", this.isLocal + "");
        prop.setProperty("gzipped", this.isGZ + "");
        prop.setProperty("offset", this.initialOffsetHpx + "");
        prop.setProperty("sizeRecord", this.sizeRecord + "");
        prop.setProperty("isPartial", this.isPartial + "");
        prop.setProperty("IAU", this.segmentIAUConv + "");
        prop.setProperty("ARGB", this.isARGB + "");
        prop.setProperty("nbPixGeneratedImage", this.nbPixGeneratedImage + "");
        prop.setProperty("curTFormBitpix", this.curTFormBitpix + "");
        prop.setProperty("hips_frame", this.getCoordSys(this.coordsys));
        prop.setProperty("lenhpx", Util.join(this.lenHpx, ','));
        prop.setProperty("typehpx", Util.join(this.typeHpx, ','));
        prop.setProperty("aladinVersion", "v12.646");
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.propertiesFile(dir)), "UTF-8");
            prop.store(out, null);
        }
        catch (FileNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private void suiteSpecif() {
        this.url = this.getCacheDir() + Util.FS + this.survey;
        this.orderMin = 3;
        this.useCache = false;
        this.inFits = true;
        this.truePixels = true;
        this.inJPEG = false;
        this.inPNG = false;
        this.color = this.isARGB;
        Aladin.trace(3, this + "");
        if (this.co == null) {
            this.co = new Coord(0.0, 0.0);
            this.co = Localisation.frameToFrame(this.co, this.aladin.localisation.getFrame(), 0);
            this.coRadius = 220.0;
        }
        if (this.coRadius <= 0.0) {
            this.coRadius = 220.0;
        }
        this.objet = this.co + "";
        this.selected = true;
        this.active = true;
        this.tileList = new PlanHips.TileList(this);
        this.loader = new PlanHips.TileLoader(this);
        this.scanMetadata();
        this.postProd();
    }

    protected void postProd() {
        int defaultProjType = this.aladin.configuration.getProjAllsky();
        Plan base = this.aladin.calque.getPlanBase();
        if (base instanceof PlanHips) {
            defaultProjType = base.projd.t;
        }
        boolean longAsc = this.isAPlanet;
        if (this.isAPlanet) {
            defaultProjType = 1;
            this.setSpecificProj(true);
        }
        Projection p = new Projection("hips", 2, this.co.al, this.co.del, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, longAsc, defaultProjType, Calib.FK5, this);
        p.frame = this.getCurrentFrameDrawing();
        this.setNewProjD(p);
        this.typeCM = this.aladin.configuration.getCMMap();
        this.transfertFct = this.aladin.configuration.getCMFct();
        this.video = this.aladin.configuration.getCMVideo();
        this.setDefaultZoom(this.co, this.coRadius);
        this.creatDefaultCM();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHealpixCreation() throws Exception {
        double levelImage;
        Aladin.trace(2, "Loading HEALPIX FITS image");
        File tmp = new File(this.getCacheDir() + Util.FS + this.dirName);
        if (!this.needProcessing(this.dirName, true)) {
            return;
        }
        Util.createPath(tmp + "");
        tmp.mkdir();
        int nside = 0;
        this.ordering = null;
        double start = System.currentTimeMillis();
        try (MyInputStream isTmp = null;){
            isTmp = new MyInputStream(new FileInputStream(this.pixelPath));
            this.headerFits = new FrameHeaderFits((Plan)this, isTmp);
            int naxis = this.headerFits.getIntFromHeader("NAXIS");
            if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
                try {
                    nside = this.headerFits.getIntFromHeader("NSIDE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.ordering = this.headerFits.getStringFromHeader("ORDERING");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.segmentIAUConv = this.headerFits.getStringFromHeader("POLCCONV").equalsIgnoreCase("IAU");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    isTmp.skip(this.naxis1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                isTmp.skipOnNext2880();
                this.headerFits = new FrameHeaderFits((Plan)this, isTmp);
            }
            this.initialOffsetHpx = isTmp.getPos();
        }
        int nsideImage = 0;
        int minLevel = 3;
        if (nside == 0) {
            try {
                nside = this.headerFits.getIntFromHeader("NSIDE");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (nside == 0) {
                try {
                    int o = this.headerFits.getIntFromHeader("MOCORDER");
                    nside = (int)CDSHealpix.pow2(o);
                }
                catch (Exception o) {
                    // empty catch block
                }
            }
        }
        int maxSizeGeneratedImage = 512;
        if (nside != 0 && nside < maxSizeGeneratedImage) {
            maxSizeGeneratedImage = nside;
        }
        Aladin.trace(3, "maxSizeGeneratedImage: " + maxSizeGeneratedImage);
        this.nbPixGeneratedImage = 2 * maxSizeGeneratedImage;
        this.nSideFile = nside;
        do {
            this.nbPixGeneratedImage /= 2;
        } while ((levelImage = this.getLevelImage(nside, this.nbPixGeneratedImage)) < (double)minLevel);
        nsideImage = (int)CDSHealpix.pow2((long)levelImage);
        Aladin.trace(3, "NSIDE image: " + nsideImage);
        Aladin.trace(3, "Level image : " + levelImage);
        Aladin.trace(3, "nb pixels generated image : " + this.nbPixGeneratedImage);
        this.naxis1 = this.sizeRecord = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.nRecord = this.headerFits.getIntFromHeader("NAXIS2");
        this.nField = this.headerFits.getIntFromHeader("TFIELDS");
        if (this.ordering == null) {
            this.ordering = this.headerFits.getStringFromHeader("ORDERING");
        }
        try {
            this.segmentIAUConv = this.headerFits.getStringFromHeader("POLCCONV").equalsIgnoreCase("IAU");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.segmentIAUConv) {
            Aladin.trace(3, "POLCCONV: IAU");
        }
        Aladin.trace(3, "sizeRecord: " + this.sizeRecord);
        Aladin.trace(3, "nRecord: " + this.nRecord);
        Aladin.trace(3, "ordering: " + this.ordering);
        try {
            this.badData = Double.parseDouble(this.headerFits.getStringFromHeader("BAD_DATA"));
            this.hasBadData = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String s = this.headerFits.getStringFromHeader("COORDSYS");
            this.coordsys = s.charAt(0);
        }
        catch (Exception e) {
            this.coordsys = (char)71;
        }
        finally {
            this.frameOrigin = this.coordsysToFrame(this.coordsys);
        }
        Aladin.trace(3, "COORDSYS vaut " + this.coordsys);
        this.blank = Double.NaN;
        this.loadFitsHeaderParam(this.headerFits);
        this.typeHpx = new char[this.nField];
        this.lenHpx = new int[this.nField];
        this.tfieldNames = new String[this.nField];
        for (int i = 0; i < this.nField; ++i) {
            int k;
            String fName = this.headerFits.getStringFromHeader("TTYPE" + (i + 1));
            if (fName == null) {
                fName = "TTYPE" + (i + 1);
            }
            this.tfieldNames[i] = fName;
            String s = null;
            try {
                s = this.headerFits.getStringFromHeader("TFORM" + (i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lenHpx[i] = 0;
            for (k = 0; k < s.length() && Character.isDigit(s.charAt(k)); ++k) {
                this.lenHpx[i] = this.lenHpx[i] * 10 + (s.charAt(k) - 48);
            }
            if (k == 0) {
                this.lenHpx[i] = 1;
            }
            this.typeHpx[i] = s.charAt(k);
        }
        try {
            this.rafHpx = new RandomAccessFile(this.pixelPath, "r");
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            return;
        }
        this.hpxOrderGeneratedImgs = (int)PlanHealpix.log2(this.nbPixGeneratedImage);
        Aladin.trace(3, "hpxOrderGeneratedImgs: " + this.hpxOrderGeneratedImgs);
        this.createHealpixOrder(this.hpxOrderGeneratedImgs);
        this.newNSideImage = nsideImage;
        this.orderMax = (int)PlanHealpix.log2(this.newNSideImage);
        Aladin.trace(3, "MAXORDER: " + this.orderMax);
        this.newNSideFile = nside;
        this.generateHierarchy(this.idxTFormToRead);
        double end = System.currentTimeMillis();
        Context.writeMetadataFits(this.getSurveyDir(), this.headerFits.getHeaderFits());
        Aladin.trace(3, "TOTAL TIME: " + (end - start) / 1000.0 + " s");
    }

    private void generateHierarchy(int idxTForm) {
        if (idxTForm < 0) {
            this.generatePolarisationData();
            long size = Util.dirSize(new File(this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(idxTForm)));
            PlanHealpix.addInCache(size / 1024L);
            return;
        }
        int nbGeneratedImg = 12 * this.newNSideImage * this.newNSideImage;
        Aladin.trace(3, "Nb images to generate: " + nbGeneratedImg);
        Aladin.trace(3, "nbPixGeneratedImage : " + this.nbPixGeneratedImage);
        if (this.ordering.equals("RING")) {
            this.fillRingValues(0, 12 * this.newNSideFile * this.newNSideFile, idxTForm);
        }
        if (this.ordering.equals("NUNIQ") || this.tfieldNames.length > 0 && this.tfieldNames[0].equals("PIXEL")) {
            this.isPartial = true;
            if (idxTForm == 0 && !this.fromProperties) {
                idxTForm = 1;
                this.idxTFormToRead = 1;
                this.survey = this.dirName = this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead);
            }
            int sizeOneRec = 0;
            for (int i = 0; i < this.typeHpx.length; ++i) {
                sizeOneRec += Util.binSizeOf(this.typeHpx[i], this.lenHpx[i]);
            }
            this.nbRecordsPartial = this.naxis1 * this.naxis2 / sizeOneRec;
            Aladin.trace(3, "nbRecordsPartial: " + this.nbRecordsPartial);
            if (this.ordering.equals("NESTED") || this.ordering.equals("NUNIQ")) {
                this.partialHpxPixIdx = this.getIndex(0L, this.nbRecordsPartial, this.rafHpx, this.initialOffsetHpx, 0L);
            } else {
                double[] x = this.getValuesRing(0L, this.nbRecordsPartial, this.newNSideFile);
                this.partialHpxPixIdx = new long[x.length];
                for (int i = 0; i < x.length; ++i) {
                    this.partialHpxPixIdx[i] = (long)x[i];
                }
            }
            this.fillPartialValues(idxTForm);
        }
        this.curTFormBitpix = this.getBitpixFromFormat(this.typeHpx[idxTForm]);
        String dir = this.getDirname() + Util.FS + this.dirNameForIdx(idxTForm);
        double fct = 85.0 / (double)nbGeneratedImg;
        for (int i = 0; i < nbGeneratedImg; ++i) {
            this.pourcent += this.idxTFormToRead >= 0 ? fct : fct / 3.0;
            Fits out = new Fits(this.nbPixGeneratedImage, this.nbPixGeneratedImage, this.curTFormBitpix);
            this.buildDoubleHealpix(this.newNSideImage, i, this.newNSideFile, out, idxTForm, dir);
        }
        this.ringValues = null;
        int curNorder = (int)PlanHealpix.log2(this.newNSideImage);
        Fits[] fils = new Fits[4];
        Aladin.trace(3, "curNorder: " + curNorder);
        for (int norder = curNorder - 1; norder >= 3; --norder) {
            int nbPix = (int)(12.0 * Math.pow(CDSHealpix.pow2(norder), 2.0));
            for (long npix = 0L; npix < (long)nbPix; ++npix) {
                for (int i = 0; i < 4; ++i) {
                    try {
                        String s = PlanHealpix.getFilePath(this.getCacheDir() + Util.FS + dir, norder + 1, npix * 4L + (long)i) + ".fits";
                        fils[i] = null;
                        if (!new File(s).exists()) continue;
                        fils[i] = new Fits();
                        fils[i].loadFITS(s);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                try {
                    this.createNodeHpx(PlanHealpix.getFilePath(this.getCacheDir() + Util.FS + dir, norder, npix) + ".fits", norder, npix, fils, this.curTFormBitpix, this.blank);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.createAllSky(this.getCacheDir(), dir, 3, 64);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dir2 = this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(idxTForm);
        long size = Util.dirSize(new File(dir2));
        PlanHealpix.addInCache(size / 1024L);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean needProcessing(String dir, boolean readProperties) {
        File tmp = new File(this.getCacheDir() + Util.FS + dir + Util.FS + "properties");
        if (!tmp.exists() || tmp.length() <= 0L) {
            boolean rep;
            if (dir.endsWith("TFIELD1") && !(rep = this.needProcessing(dir.substring(0, dir.length() - 1) + "2", readProperties)) && this.isPartial) {
                this.idxTFormToRead = 1;
                this.survey = this.dirName = this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead);
                return false;
            }
            return true;
        }
        File propFile = this.propertiesFile(dir);
        MyProperties prop = new MyProperties();
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
            prop.load(in);
        }
        catch (Exception e) {
            File dirToRemove = new File(this.getCacheDir() + Util.FS + this.getDirname());
            Util.deleteDir(dirToRemove);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        if (this.isLocal) {
            double modifDateValue;
            String modifDate = prop.getProperty("lastModified");
            try {
                modifDateValue = Double.valueOf(modifDate);
            }
            catch (Exception e) {
                return true;
            }
            if (modifDate == null || modifDateValue == 0.0 || modifDateValue != (double)new File(this.originalPath).lastModified()) {
                return true;
            }
        }
        if (!readProperties) {
            return false;
        }
        Util.touch(new File(this.getCacheDir() + Util.FS + this.getDirname()), false);
        try {
            StringTokenizer st;
            block31: {
                block30: {
                    String version = prop.getProperty("aladinVersion");
                    if (version == null) break block30;
                    if (version.equals("v12.646")) break block31;
                }
                Aladin.trace(3, "Detected a different version of Aladin, recreate the Healpix files");
                File dirToRemove = new File(this.getCacheDir() + Util.FS + this.getDirname());
                Util.deleteDir(dirToRemove);
                return true;
            }
            String s = prop.getProperty("hips_frame");
            if (s == null) {
                s = prop.getProperty("coordsys");
            }
            if (s == null) {
                s = "galactic";
            }
            this.isAPlanet = this.isPlanet(s);
            this.coordsys = this.coordsys(s);
            this.frameOrigin = this.coordsysToFrame(this.coordsys);
            this.isLocal = new Boolean(prop.getProperty("localData"));
            this.isGZ = new Boolean(prop.getProperty("gzipped"));
            this.isARGB = new Boolean(prop.getProperty("ARGB"));
            this.segmentIAUConv = new Boolean(prop.getProperty("IAU"));
            this.originalPath = prop.getProperty("dataPath");
            this.initialOffsetHpx = new Long(prop.getProperty("offset"));
            this.sizeRecord = new Integer(prop.getProperty("sizeRecord"));
            this.newNSideImage = Integer.parseInt(prop.getProperty("nsideFile"));
            this.orderMax = (int)PlanHealpix.log2(this.newNSideImage);
            this.newNSideFile = Integer.parseInt(prop.getProperty("nsidePixel"));
            s = prop.getProperty("hips_tile_width");
            this.hpxOrderGeneratedImgs = s != null ? (int)CDSHealpix.log2(Integer.parseInt(s)) : Integer.parseInt(prop.getProperty("tileOrder"));
            this.ordering = prop.getProperty("ordering");
            this.nField = Integer.parseInt(prop.getProperty("tfields"));
            this.tfieldNames = Util.split(prop.getProperty("ttypes"), ",");
            this.isPartial = new Boolean(prop.getProperty("isPartial"));
            this.nbPixGeneratedImage = Integer.parseInt(prop.getProperty("nbPixGeneratedImage"));
            this.curTFormBitpix = Integer.parseInt(prop.getProperty("curTFormBitpix"));
            this.lenHpx = Util.splitAsInt(prop.getProperty("lenhpx"), ",");
            this.typeHpx = Util.splitAschar(prop.getProperty("typehpx"), ",");
            s = prop.getProperty("hips_pixel_cut");
            if (s != null) {
                st = new StringTokenizer(s);
                this.pixelMin = Double.parseDouble(st.nextToken());
                this.pixelMax = Double.parseDouble(st.nextToken());
            }
            if ((s = prop.getProperty("hips_data_range")) != null) {
                st = new StringTokenizer(s);
                this.dataMin = Double.parseDouble(st.nextToken());
                this.dataMax = Double.parseDouble(st.nextToken());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            File dirToRemove = new File(this.getCacheDir() + Util.FS + this.getDirname());
            Aladin.trace(3, "Exception while reading properties file, remove directory " + dirToRemove + " and recreate Healpix files");
            Util.deleteDir(dirToRemove);
            return true;
        }
        return false;
    }

    private File propertiesFile(String dir) {
        return new File(this.getCacheDir() + Util.FS + dir + Util.FS + "properties");
    }

    private int getBitpixFromFormat(char t) {
        switch (t) {
            case 'B': {
                return 8;
            }
            case 'I': {
                return 16;
            }
            case 'J': {
                return 32;
            }
            case 'K': {
                return 64;
            }
            case 'E': {
                return -32;
            }
            case 'D': {
                return -64;
            }
        }
        return -1;
    }

    @Override
    public String getCacheDir() {
        if (this.flagCache) {
            return this.dirCache;
        }
        this.flagCache = true;
        String dir = System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache";
        File f = new File(dir = dir + Util.FS + CACHEHPX);
        if (!f.isDirectory() && !f.mkdirs()) {
            return null;
        }
        this.dirCache = dir;
        return dir;
    }

    protected static String getCacheDirPath() {
        return System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + "Cache" + Util.FS + CACHEHPX;
    }

    private double[] getValues(long lowHealpixIdx, long highHealpixIdx, RandomAccessFile raf, long initialOffset, long idxTForm) {
        if (this.isPartial && (this.ordering.equals("NESTED") || this.ordering.equals("NUNIQ"))) {
            return this.getValuesPartialNested(lowHealpixIdx, highHealpixIdx);
        }
        if (this.isPartial && this.ordering.equals("RING")) {
            return this.getValuesPartialRing(lowHealpixIdx, highHealpixIdx);
        }
        if (this.ordering.equals("RING")) {
            return this.getValuesRing(lowHealpixIdx, highHealpixIdx, this.nSideFile);
        }
        return this.getValuesNested(lowHealpixIdx, highHealpixIdx, raf, initialOffset, idxTForm);
    }

    private double[] getValuesRing(long lowHealpixIdx, long highHealpixIdx, int nside) {
        return this.fillRingBuffer((int)lowHealpixIdx, (int)highHealpixIdx, nside);
    }

    private double[] getValuesNested(long lowHealpixIdx, long highHealpixIdx, RandomAccessFile raf, long initialOffset, long idxTForm) {
        double val = 0.0;
        int nbValues = (int)(highHealpixIdx - lowHealpixIdx);
        double[] result = new double[nbValues];
        int nbRowsToRead = nbValues / this.lenHpx[(int)idxTForm];
        if (nbRowsToRead == 0) {
            nbRowsToRead = 1;
        }
        int sizeBuf = nbRowsToRead * this.sizeRecord;
        byte[] buf = new byte[sizeBuf];
        int inrowSkip = 0;
        if (nbValues < this.lenHpx[(int)idxTForm]) {
            inrowSkip = (int)lowHealpixIdx % this.lenHpx[(int)idxTForm] * Util.binSizeOf(this.typeHpx[(int)idxTForm], 1);
        }
        long nbRowsToSkip = lowHealpixIdx / (long)this.lenHpx[(int)idxTForm];
        try {
            long skipLength = initialOffset + nbRowsToSkip * (long)this.sizeRecord + (long)inrowSkip;
            raf.seek(skipLength);
            try {
                raf.readFully(buf);
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int resultIdx = 0;
        int offset = 0;
        int idxRow = 0;
        while (idxRow < nbRowsToRead) {
            int offsetField = 0;
            for (int idxField = 0; idxField < this.nField; ++idxField) {
                if ((long)idxField != idxTForm) {
                    offsetField += Util.binSizeOf(this.typeHpx[idxField], this.lenHpx[idxField]);
                    continue;
                }
                int totalOffset = offset + offsetField;
                for (int k = 0; k < this.lenHpx[idxField] && resultIdx < result.length; ++k, ++resultIdx) {
                    int offsetc = Util.binSizeOf(this.typeHpx[idxField], k);
                    if (k == 0) {
                        // empty if block
                    }
                    switch (this.typeHpx[idxField]) {
                        case 'B': {
                            val = PlanHealpix.getByte(buf, totalOffset + offsetc);
                            break;
                        }
                        case 'I': {
                            val = PlanHealpix.getShort(buf, totalOffset + offsetc);
                            break;
                        }
                        case 'J': {
                            val = PlanHealpix.getInt(buf, totalOffset + offsetc);
                            break;
                        }
                        case 'K': {
                            val = (long)PlanHealpix.getInt(buf, totalOffset + offsetc) << 32 | (long)PlanHealpix.getInt(buf, totalOffset + offsetc + 4) & 0xFFFFFFFFL;
                            break;
                        }
                        case 'E': {
                            val = Float.intBitsToFloat(PlanHealpix.getInt(buf, totalOffset + offsetc));
                            break;
                        }
                        case 'D': {
                            long a = (long)PlanHealpix.getInt(buf, totalOffset + offsetc) << 32 | (long)PlanHealpix.getInt(buf, totalOffset + offsetc + 4) & 0xFFFFFFFFL;
                            val = Double.longBitsToDouble(a);
                            break;
                        }
                        default: {
                            val = -1.0;
                        }
                    }
                    result[resultIdx] = val;
                }
            }
            ++idxRow;
            offset += this.sizeRecord;
        }
        return result;
    }

    private long[] getIndex(long lowHealpixIdx, long highHealpixIdx, RandomAccessFile raf, long initialOffset, long idxTForm) {
        long val = 0L;
        int nbValues = (int)(highHealpixIdx - lowHealpixIdx);
        long[] result = new long[nbValues];
        int nbRowsToRead = nbValues / this.lenHpx[(int)idxTForm];
        if (nbRowsToRead == 0) {
            nbRowsToRead = 1;
        }
        int sizeBuf = nbRowsToRead * this.sizeRecord;
        byte[] buf = new byte[sizeBuf];
        int inrowSkip = 0;
        if (nbValues < this.lenHpx[(int)idxTForm]) {
            inrowSkip = (int)lowHealpixIdx % this.lenHpx[(int)idxTForm] * Util.binSizeOf(this.typeHpx[(int)idxTForm], 1);
        }
        int nbRowsToSkip = (int)lowHealpixIdx / this.lenHpx[(int)idxTForm];
        try {
            raf.seek(initialOffset + (long)(nbRowsToSkip * this.sizeRecord) + (long)inrowSkip);
            try {
                raf.readFully(buf);
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int resultIdx = 0;
        int offset = 0;
        int idxRow = 0;
        while (idxRow < nbRowsToRead) {
            int offsetField = 0;
            for (int idxField = 0; idxField < this.nField; ++idxField) {
                if ((long)idxField != idxTForm) {
                    offsetField += Util.binSizeOf(this.typeHpx[idxField], this.lenHpx[idxField]);
                    continue;
                }
                int totalOffset = offset + offsetField;
                for (int k = 0; k < this.lenHpx[idxField] && resultIdx < result.length; ++k, ++resultIdx) {
                    int offsetc = Util.binSizeOf(this.typeHpx[idxField], k);
                    if (k == 0) {
                        // empty if block
                    }
                    switch (this.typeHpx[idxField]) {
                        case 'B': {
                            val = PlanHealpix.getByte(buf, totalOffset + offsetc);
                            break;
                        }
                        case 'I': {
                            val = PlanHealpix.getShort(buf, totalOffset + offsetc);
                            break;
                        }
                        case 'J': {
                            val = PlanHealpix.getInt(buf, totalOffset + offsetc);
                            break;
                        }
                        case 'K': {
                            val = (long)PlanHealpix.getInt(buf, totalOffset + offsetc) << 32 | (long)PlanHealpix.getInt(buf, totalOffset + offsetc + 4) & 0xFFFFFFFFL;
                            break;
                        }
                        default: {
                            val = -1L;
                        }
                    }
                    result[resultIdx] = val;
                }
            }
            ++idxRow;
            offset += this.sizeRecord;
        }
        return result;
    }

    public static long getHealpixMin(int n1, long n, int n2, boolean nside) {
        if (nside) {
            return n * (long)Math.pow(4.0, (PlanHealpix.log2(n2) - PlanHealpix.log2(n1)) / PlanHealpix.log2(2L));
        }
        return n * (long)Math.pow(4.0, (long)(n2 - n1) / PlanHealpix.log2(2L));
    }

    public static long log2(long x) {
        return CDSHealpix.log2(x);
    }

    public static long getFather(long npix) {
        return npix / 4L;
    }

    private void fillPartialValues(long idxTForm) {
        this.partialValues = new HashMap();
        double[] values = this.ordering.equals("NUNIQ") || this.ordering.equals("NESTED") ? this.getValuesNested(0L, this.nbRecordsPartial, this.rafHpx, this.initialOffsetHpx, idxTForm) : this.getValuesRing(0L, this.nbRecordsPartial, this.newNSideFile);
        for (int i = 0; i < this.partialHpxPixIdx.length; ++i) {
            this.partialValues.put(this.partialHpxPixIdx[i], values[i]);
        }
    }

    private double[] getValuesPartialRing(long low, long high) {
        int nbVal = (int)(high - low);
        double[] ret = new double[nbVal];
        try {
            int order = (int)CDSHealpix.log2(this.nSideFile);
            for (int i = 0; i < nbVal; ++i) {
                Double a = (Double)this.partialValues.get(CDSHealpix.nest2ring(order, low + (long)i));
                ret[i] = a == null ? Double.NaN : a;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private double[] getValuesPartialNested(long low, long high) {
        int nbVal = (int)(high - low);
        double[] ret = new double[nbVal];
        for (int i = 0; i < nbVal; ++i) {
            ret[i] = this.getPartialValue(low + (long)i);
        }
        return ret;
    }

    private double getPartialValue(long npix) {
        if (!this.ordering.equals("NUNIQ")) {
            Double a = (Double)this.partialValues.get(npix);
            return a == null ? Double.NaN : a;
        }
        int maxOrder = (int)PlanHealpix.log2(this.newNSideFile);
        int i = 0;
        while (i <= maxOrder) {
            if (this.lastOrder > maxOrder) {
                this.lastOrder = 0;
            }
            int gap = 2 * (maxOrder - this.lastOrder);
            long nuniq = Moc.hpix2uniq(this.lastOrder, npix >>> gap);
            Double a = (Double)this.partialValues.get(nuniq);
            double s = 3.0461741978670857E-4;
            long ncell = 12 << maxOrder * 2;
            double s1 = Healpix.SKYAREA / (double)ncell;
            if (a != null) {
                a = a * s * s1;
                return a;
            }
            ++i;
            ++this.lastOrder;
        }
        return Double.NaN;
    }

    private void fillRingValues(int minIdx, int maxIdx, long idxTForm) {
        int nbValues = maxIdx - minIdx + 1;
        this.ringValues = new double[nbValues];
        int step = Math.max(this.nbPixGeneratedImage * this.nbPixGeneratedImage, this.lenHpx[(int)idxTForm]);
        int min = minIdx;
        int max = Math.min(min + step, maxIdx);
        while (min < maxIdx) {
            System.arraycopy(this.getValuesNested(min, max, this.rafHpx, this.initialOffsetHpx, idxTForm), 0, this.ringValues, min - minIdx, max - min);
            max = Math.min((min += step) + step, maxIdx);
        }
    }

    private double[] fillRingBuffer(int minNested, int maxNested, int nside) {
        int length = maxNested - minNested;
        double[] val = new double[length];
        try {
            int order = (int)CDSHealpix.log2(nside);
            for (int i = 0; i < length; ++i) {
                val[i] = this.ringValues[(int)CDSHealpix.nest2ring(order, minNested + i)];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return val;
    }

    boolean buildDoubleHealpix(int nside_file, long npix_file, int nside, Fits out, long idxTForm, String dir) {
        return this.buildDoubleHealpix(nside_file, npix_file, nside, out, true, idxTForm, dir);
    }

    boolean buildDoubleHealpix(int nside_file, long npix_file, int nside, Fits out, boolean write, long idxTForm, String dir) {
        boolean empty = true;
        long min = PlanHealpix.getHealpixMin(nside_file, npix_file, nside, true);
        long max = min + (long)(out.width * out.height);
        double[] values = this.getValues(min, max, this.rafHpx, this.initialOffsetHpx, idxTForm);
        for (int y = 0; y < out.height; ++y) {
            for (int x = 0; x < out.width; ++x) {
                long index = min + (long)this.xy2hpx(y * out.width + x);
                double value = values[(int)(index - min)];
                if (empty && !Double.isNaN(value)) {
                    empty = false;
                }
                out.setPixelDouble(x, y, value);
            }
        }
        if (this.isARGB) {
            out.setARGB();
        }
        if (write) {
            try {
                String filePath = PlanHealpix.getFilePath(this.getCacheDir() + Util.FS + dir, (int)PlanHealpix.log2(nside_file), npix_file) + ".fits";
                if (!empty) {
                    out.writeFITS(filePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return !empty;
    }

    @Override
    protected int getBitpix() {
        return this.curTFormBitpix;
    }

    @Override
    public String getSurveyDir() {
        return this.getCacheDir() + Util.FS + this.dirName;
    }

    public String getFilePath(int idxTForm, int order, long npix) {
        return this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(idxTForm) + Util.FS + "Norder" + order + Util.FS + "Dir" + npix / 10000L * 10000L + Util.FS + "Npix" + npix;
    }

    protected String getAllskyFilePath(int idxTForm, int order) {
        return this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(idxTForm) + Util.FS + "Norder" + order + Util.FS + "Allsky.fits";
    }

    private double getLevelImage(int nside, int nbPixImage) {
        long nbPix = 12L * (long)nside * (long)nside;
        long nbNeededImages = nbPix / (long)(nbPixImage * nbPixImage);
        if (nbNeededImages < 1L) {
            return Double.NEGATIVE_INFINITY;
        }
        double nsideImage = Math.sqrt(nbNeededImages / 12L);
        return Math.log(nsideImage) / Math.log(2.0);
    }

    protected int getIdxPolaU() {
        return this.getIdxPola(UPOL);
    }

    protected int getIdxPolaQ() {
        return this.getIdxPola(QPOL);
    }

    private int getIdxPola(String[] polKeys) {
        if (this.tfieldNames == null) {
            return -1;
        }
        for (int i = 0; i < this.tfieldNames.length; ++i) {
            if (Util.indexInArrayOf(this.tfieldNames[i], polKeys, true) < 0) continue;
            return i;
        }
        return -1;
    }

    protected boolean hasPolarisationData() {
        return this.getIdxPolaU() >= 0 && this.getIdxPolaQ() >= 0;
    }

    protected boolean isPartial() {
        return this.isPartial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayPolarisation(int mode) {
        Plan folderPlane;
        block16: {
            folderPlane = null;
            PlanHealpix planHealpix = this;
            synchronized (planHealpix) {
                block15: {
                    if (this.folder != 0) break block15;
                    String saveLabel = this.label;
                    this.label = this.labelForField(this.idxTFormToRead);
                    int idx = this.aladin.calque.newFolder(saveLabel, 0, false);
                    if (idx < 0) break block16;
                    folderPlane = this.aladin.calque.plan[idx];
                    this.aladin.calque.permute(this, folderPlane);
                    this.aladin.view.newView(1);
                    this.aladin.calque.repaintAll();
                    break block16;
                }
                boolean found = false;
                for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
                    if (this.aladin.calque.plan[i] == this) {
                        found = true;
                        continue;
                    }
                    if (!found || this.aladin.calque.plan[i].type != 11) continue;
                    folderPlane = this.aladin.calque.plan[i];
                    break;
                }
            }
        }
        MyInputStream in = null;
        try {
            in = this.isLocal ? new MyInputStream(new FileInputStream(this.originalPath)) : new MyInputStream(Util.openStream(this.originalPath));
            in = in.startRead();
            in.getType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String label = this.labelForField(mode);
        PlanHealpix planHealpix = this;
        synchronized (planHealpix) {
            int idx = this.aladin.calque.newPlanHealpix(this.originalPath, in, label, mode == -42 ? 1 : 0, mode, false);
            Plan polaPlane = this.aladin.calque.plan[idx];
            if (folderPlane != null) {
                int newIdx = this.aladin.calque.getIndex(folderPlane);
                if (this.aladin.calque.plan[newIdx + 1].type == 17) {
                    ++newIdx;
                }
                this.aladin.calque.permute(polaPlane, this.aladin.calque.plan[newIdx]);
                this.aladin.view.newView(1);
                this.aladin.calque.repaintAll();
            }
            if (mode == -40) {
                idx = this.aladin.calque.getIndex(polaPlane);
                this.aladin.execAsyncCommand("cm @" + idx + " polarisation");
            } else if (mode == -41) {
                idx = this.aladin.calque.getIndex(polaPlane);
                this.aladin.execAsyncCommand("cm @" + idx + " log");
            }
        }
    }

    protected static double[] getPolaAmpMinMax(Fits fitsQ, Fits fitsU, boolean dataExtrema) {
        String minKw = "DATAMIN";
        String maxKw = "DATAMAX";
        double dataMinUAllsky = Double.parseDouble(fitsU.headerFits.getStringFromHeader(minKw));
        double dataMaxUAllsky = Double.parseDouble(fitsU.headerFits.getStringFromHeader(maxKw));
        double dataMinQAllsky = Double.parseDouble(fitsQ.headerFits.getStringFromHeader(minKw));
        double dataMaxQAllsky = Double.parseDouble(fitsQ.headerFits.getStringFromHeader(maxKw));
        double maxU = Math.max(Math.abs(dataMinUAllsky), Math.abs(dataMaxUAllsky));
        double maxQ = Math.max(Math.abs(dataMinQAllsky), Math.abs(dataMaxQAllsky));
        double minAmp = 0.0;
        double maxAmp = Math.sqrt(maxU * maxU + maxQ * maxQ);
        return new double[]{minAmp, maxAmp};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generatePolarisationData() {
        Object object = lock;
        synchronized (object) {
            block25: {
                try {
                    long size;
                    File tmp = new File(this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead) + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                    if (tmp.exists() && tmp.length() > 0L) break block25;
                    File polaDir = new File(this.getCacheDir() + Util.FS + this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead));
                    if (!polaDir.exists() && !polaDir.mkdir()) {
                        System.err.println("Can't create directory " + polaDir);
                        return;
                    }
                    int idxPolaU = this.getIdxPolaU();
                    int idxPolaQ = this.getIdxPolaQ();
                    if (idxPolaU < 0 || idxPolaQ < 0) {
                        System.err.println("Can't find polarisation indexes");
                        return;
                    }
                    String dirnamePolaU = this.getDirname() + Util.FS + this.dirNameForIdx(idxPolaU);
                    String dirnamePolaQ = this.getDirname() + Util.FS + this.dirNameForIdx(idxPolaQ);
                    if (this.needProcessing(dirnamePolaU, false)) {
                        this.generateHierarchy(idxPolaU);
                        size = Util.dirSize(new File(dirnamePolaU));
                        PlanHealpix.addInCache(size / 1024L);
                        this.writePropertiesFile(dirnamePolaU);
                    }
                    if (this.needProcessing(dirnamePolaQ, false)) {
                        this.generateHierarchy(idxPolaQ);
                        size = Util.dirSize(new File(dirnamePolaU));
                        PlanHealpix.addInCache(size / 1024L);
                        this.writePropertiesFile(dirnamePolaQ);
                    }
                    Fits fitsOut = null;
                    Fits fitsQ = new Fits();
                    Fits fitsU = new Fits();
                    double pixelMinPola = 0.0;
                    double dataMinPola = 0.0;
                    double pixelMaxPola = 1.0;
                    double dataMaxPola = 1.0;
                    try {
                        fitsU.loadFITS(this.getAllskyFilePath(idxPolaU, 3));
                        fitsQ.loadFITS(this.getAllskyFilePath(idxPolaQ, 3));
                        if (this.idxTFormToRead == -41 || this.idxTFormToRead == -42) {
                            double[] dataExtrema = PlanHealpix.getPolaAmpMinMax(fitsQ, fitsU, true);
                            dataMinPola = dataExtrema[0];
                            dataMaxPola = dataExtrema[1];
                            double[] pixelExtrema = PlanHealpix.getPolaAmpMinMax(fitsQ, fitsU, false);
                            pixelMinPola = pixelExtrema[0];
                            pixelMaxPola = pixelExtrema[1];
                        } else if (this.idxTFormToRead == -40) {
                            pixelMinPola = -90.0;
                            dataMinPola = -90.0;
                            pixelMaxPola = 90.0;
                            dataMaxPola = 90.0;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        if (this.idxTFormToRead != -42) {
                            fitsOut = new Fits(fitsU.width, fitsU.height, -32);
                        }
                        this.computePolarisation(fitsOut, fitsQ, fitsU, 3, this.nbytes, true, dataMinPola, dataMaxPola, pixelMinPola, pixelMaxPola, this.idxTFormToRead);
                        fitsOut = null;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    int deepestNorder = (int)PlanHealpix.log2(this.newNSideImage);
                    for (int norder = 3; norder <= deepestNorder; ++norder) {
                        int nbPix = (int)(12.0 * Math.pow(CDSHealpix.pow2(norder), 2.0));
                        for (int npix = 0; npix < nbPix; ++npix) {
                            try {
                                fitsU.loadFITS(this.getFilePath(idxPolaU, norder, npix) + ".fits");
                                fitsQ.loadFITS(this.getFilePath(idxPolaQ, norder, npix) + ".fits");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                continue;
                            }
                            try {
                                if (fitsOut == null && this.idxTFormToRead != -42) {
                                    fitsOut = new Fits(fitsU.width, fitsU.height, -32);
                                }
                                this.computePolarisation(fitsOut, fitsQ, fitsU, norder, npix, false, dataMinPola, dataMaxPola, pixelMinPola, pixelMaxPola, this.idxTFormToRead);
                                continue;
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    if (this.idxTFormToRead != -42) {
                        this.curTFormBitpix = -32;
                    }
                    this.writePropertiesFile(this.getDirname() + Util.FS + this.dirNameForIdx(this.idxTFormToRead));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void computePolarisation(Fits fitsOut, Fits fitsQ, Fits fitsU, int norder, int npix, boolean allsky, double dataMin, double dataMax, double pixelMin, double pixelMax, int mode) throws Exception {
        HeaderFits extHeader;
        int mybitpix = -32;
        int w = fitsQ.width;
        int h = fitsQ.height;
        try {
            String header = "XTENSION=IMAGE\nBITPIX=" + mybitpix + "\nNAXIS=2\nNAXIS1=" + w + "\nNAXIS2=" + h;
            if (mode != -42) {
                header = header + "\nPIXELMIN=" + pixelMin + "\nPIXELMAX=" + pixelMax;
                header = header + "\nDATAMIN=" + dataMin + "\nDATAMAX=" + dataMax;
            }
            extHeader = new HeaderFits(header);
            if (allsky) {
                Aladin.trace(3, "Allsky header:\n" + header);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (mode == -42) {
            fitsQ = this.normalize(fitsQ, pixelMin, pixelMax);
            fitsU = this.normalize(fitsU, pixelMin, pixelMax);
            fitsQ.clearExtensions();
            fitsQ.addFitsExtension(extHeader, fitsU.pixels);
            String path = allsky ? this.getAllskyFilePath(-42, norder) : this.getFilePath(-42, norder, npix) + ".fits";
            fitsQ.writeFITS(path);
            return;
        }
        fitsOut.clearExtensions();
        fitsOut.headerFits = extHeader;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                double valU = fitsU.getPixelFull(x, y);
                double valQ = fitsQ.getPixelFull(x, y);
                double value = mode == -41 ? Math.sqrt(valU * valU + valQ * valQ) : Math.toDegrees(0.5 * Math.atan2(valU, valQ));
                fitsOut.setPixelDouble(x, y, value);
            }
        }
        String path = allsky ? this.getAllskyFilePath(mode, norder) : this.getFilePath(mode, norder, npix) + ".fits";
        fitsOut.writeFITS(path);
    }

    private Fits normalize(Fits in, double min, double max) {
        Fits out = new Fits(in.width, in.height, in.bitpix);
        double range = max - min;
        if (range == 0.0) {
            return in;
        }
        for (int y = 0; y < in.height; ++y) {
            for (int x = 0; x < in.width; ++x) {
                double val = in.getPixelDouble(x, y);
                val = val / range + min;
                out.setPixelDouble(x, y, val);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadNewField(int idxField) {
        Plan folder;
        block12: {
            if (idxField >= this.nField) {
                return false;
            }
            folder = null;
            PlanHealpix planHealpix = this;
            synchronized (planHealpix) {
                block11: {
                    if (this.folder != 0) break block11;
                    String saveLabel = this.label;
                    this.label = this.labelForField(this.idxTFormToRead);
                    int idx = this.aladin.calque.newFolder(saveLabel, 0, false);
                    if (idx < 0) break block12;
                    folder = this.aladin.calque.plan[idx];
                    this.aladin.calque.permute(this, folder);
                    this.aladin.view.newView(1);
                    this.aladin.calque.repaintAll();
                    break block12;
                }
                boolean found = false;
                for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
                    if (this.aladin.calque.plan[i] == this) {
                        found = true;
                        continue;
                    }
                    if (!found || this.aladin.calque.plan[i].type != 11) continue;
                    folder = this.aladin.calque.plan[i];
                    break;
                }
            }
        }
        MyInputStream in = null;
        try {
            in = this.isLocal ? new MyInputStream(new FileInputStream(this.originalPath)) : new MyInputStream(Util.openStream(this.originalPath));
            in = in.startRead();
            in.getType();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        int idx = this.aladin.calque.newPlanHealpix(this.originalPath, in, this.tfieldNames[idxField], 0, idxField, true);
        if (idx < 0) {
            return false;
        }
        if (folder != null) {
            int newIdx = this.aladin.calque.getIndex(folder);
            if (this.aladin.calque.plan[newIdx + 1].type == 17) {
                ++newIdx;
            }
            this.aladin.calque.permute(this.aladin.calque.plan[idx], this.aladin.calque.plan[newIdx]);
            this.aladin.view.newView(1);
            this.aladin.calque.repaintAll();
        }
        return true;
    }

    private String labelForField(int idx) {
        if (idx == -42) {
            return "Polarisation";
        }
        if (idx == -41) {
            return "Amplitude";
        }
        if (idx == -40) {
            return "Angle";
        }
        return this.tfieldNames[this.idxTFormToRead];
    }

    public void createAllSky(String path, String survey, int order, int outLosangeWidth) throws Exception {
        int nbOutLosangeHeight;
        int nbOutLosangeWidth;
        long t = System.currentTimeMillis();
        int nside = (int)CDSHealpix.pow2(order);
        int n = 12 * nside * nside;
        if ((double)n / (double)(nbOutLosangeWidth = (int)Math.sqrt(n)) != (double)(nbOutLosangeHeight = (int)((double)n / (double)nbOutLosangeWidth))) {
            ++nbOutLosangeHeight;
        }
        int outFileWidth = outLosangeWidth * nbOutLosangeWidth;
        Aladin.trace(3, "Cr\u00e9ation Allsky " + (this.isARGB ? "ARB " : "") + "order=" + order + ": " + n + " losanges (" + nbOutLosangeWidth + "x" + nbOutLosangeHeight + " de " + outLosangeWidth + "x" + outLosangeWidth + " soit " + outFileWidth + "x" + nbOutLosangeHeight * outLosangeWidth + " pixels)...");
        Fits out = null;
        double blank = this.hasBadData ? this.badData : this.blank;
        double fct = 15.0 / (double)n;
        for (int npix = 0; npix < n; ++npix) {
            String name = PlanHealpix.getFilePath(survey, order, npix);
            Fits in = new Fits();
            String filename = path + Util.FS + name;
            this.pourcent += fct;
            try {
                if (!new File(filename + ".fits").exists()) continue;
                in.loadFITS(filename + ".fits");
                if (out == null) {
                    out = new Fits(outFileWidth, nbOutLosangeHeight * outLosangeWidth, in.bitpix);
                    out.setBlank(blank);
                    out.setBzero(this.bZero);
                    out.setBscale(this.bScale);
                    for (int y = 0; y < out.height; ++y) {
                        for (int x = 0; x < out.width; ++x) {
                            out.setPixelDouble(x, out.height - 1 - y, blank);
                        }
                    }
                }
                int yLosange = npix / nbOutLosangeWidth;
                int xLosange = npix % nbOutLosangeWidth;
                int gap = in.width / outLosangeWidth;
                if (gap == 0) {
                    this.createAllSky(path, survey, order, in.width);
                    return;
                }
                for (int y = 0; y < in.width / gap; ++y) {
                    for (int x = 0; x < in.width / gap; ++x) {
                        int offsetY = this.isARGB ? y * gap : in.heightCell - 1 - y * gap;
                        double pix = in.getPixelDouble(x * gap, offsetY);
                        if (pix < this.dataMin) {
                            this.dataMin = pix;
                        } else if (pix > this.dataMax) {
                            this.dataMax = pix;
                        }
                        int xOut = xLosange * outLosangeWidth + x;
                        int yOut = yLosange * outLosangeWidth + y;
                        out.setPixelDouble(xOut, out.heightCell - 1 - yOut, pix);
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        String filename = path + Util.FS + survey + Util.FS + "Norder" + order + Util.FS + "Allsky";
        if (this.isARGB) {
            out.setARGB();
        } else {
            int bitpix = out.bitpix;
            double[] cut = out.findAutocutRange();
            out.headerFits.setKeyValue("PIXELMIN", (bitpix > 0 ? (double)((long)cut[0]) : cut[0]) + "");
            out.headerFits.setKeyValue("PIXELMAX", (bitpix > 0 ? (double)((long)cut[1]) : cut[1]) + "");
            if (!(cut[2] < cut[3] && cut[2] <= cut[0] && cut[3] >= cut[1])) {
                double d = bitpix == -64 ? -1.7976931348623157E308 : (bitpix == -32 ? -3.4028234663852886E38 : (bitpix == 64 ? -9.223372036854776E18 : (bitpix == 32 ? -2.147483647E9 : (cut[2] = bitpix == 16 ? -32767.0 : 1.0))));
                cut[3] = bitpix == -64 ? Double.MAX_VALUE : (bitpix == -32 ? 3.4028234663852886E38 : (bitpix == 64 ? 9.223372036854776E18 : (bitpix == 32 ? 2.147483647E9 : (bitpix == 16 ? 32767.0 : 255.0))));
                Aladin.trace(1, "createAllSky() data range [DATAMMIN..DATAMAX] not consistante => max possible range");
            }
            out.headerFits.setKeyValue("DATAMIN", (bitpix > 0 ? (double)((long)cut[2]) : cut[2]) + "");
            out.headerFits.setKeyValue("DATAMAX", (bitpix > 0 ? (double)((long)cut[3]) : cut[3]) + "");
            Aladin.trace(3, "PIXELMINMAX = [" + cut[0] + " " + cut[1] + "] DATAMINMAX=[" + cut[2] + " " + cut[3] + "]");
        }
        out.writeFITS(filename + ".fits");
        Aladin.trace(3, "\nConstruction " + survey + Util.FS + "Norder" + order + Util.FS + "Allsky en " + (int)((System.currentTimeMillis() - t) / 1000L) + "s");
    }

    private int coordsysToFrame(char sys) {
        switch (sys) {
            case 'C': 
            case 'Q': {
                return 0;
            }
            case 'G': {
                return 3;
            }
            case 'E': {
                return 2;
            }
        }
        return 3;
    }

    private char coordsys(String s) {
        if (s.equals("equatorial")) {
            return 'C';
        }
        if (s.equals("galactic")) {
            return 'G';
        }
        if (s.equals("ecliptic")) {
            return 'E';
        }
        return s.charAt(0);
    }

    @Override
    protected boolean drawAllSky(Graphics g, ViewSimple v, BufferedImage imgb) {
        this.local = true;
        return super.drawAllSky(g, v, imgb);
    }

    Fits createNodeHpx(String file, int order, long npix, Fits[] fils, int bitpix, double blank) throws Exception {
        int w = this.nbPixGeneratedImage;
        Fits out = new Fits(w, w, bitpix);
        out.setBlank(blank);
        out.setBzero(this.bZero);
        out.setBscale(this.bScale);
        boolean empty = true;
        double[] px = new double[4];
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int quad = dg << 1 | hb;
                Fits in = fils[quad];
                int offX = dg * w >>> 1;
                int offY = (1 - hb) * w >>> 1;
                for (int y = 0; y < w; y += 2) {
                    for (int x = 0; x < w; x += 2) {
                        int i;
                        double pix = 0.0;
                        int nbPix = 0;
                        if (in != null) {
                            for (i = 0; i < 4; ++i) {
                                int gx = i == 1 || i == 3 ? 1 : 0;
                                int gy = i > 1 ? 1 : 0;
                                px[i] = in.getPixelDouble(x + gx, y + gy);
                                if (Double.isNaN(px[i]) || px[i] == blank) continue;
                                ++nbPix;
                            }
                        }
                        for (i = 0; i < 4; ++i) {
                            if (Double.isNaN(px[i]) || px[i] == blank) continue;
                            pix += px[i] / (double)nbPix;
                        }
                        if (nbPix == 0) {
                            pix = blank;
                        } else {
                            empty = false;
                        }
                        out.setPixelDouble(offX + (x >>> 1), offY + (y >>> 1), pix);
                    }
                }
            }
        }
        if (empty) {
            out = null;
        } else {
            out.addDataSum();
            out.writeFITS(file);
        }
        return out;
    }

    protected char getCoordsys() {
        return this.coordsys;
    }

    protected int getNSideFile() {
        return this.newNSideFile;
    }
}

