/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Couleur;
import cds.aladin.Fov;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import java.util.ArrayList;
import java.util.Iterator;

public class PlanFov
extends Plan {
    private Fov[] fov;

    PlanFov(Aladin aladin, String label, Fov[] fov) {
        this.aladin = aladin;
        this.type = 13;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.selected = true;
        this.fov = fov;
        this.suite();
        this.flagOk = true;
        this.askActive = true;
        aladin.view.repaintAll();
        aladin.calque.repaintAll();
    }

    private static double max(double a, double b) {
        return a > b ? a : b;
    }

    private static double min(double a, double b) {
        return a < b ? a : b;
    }

    private static double abs(double a) {
        return a < 0.0 ? -a : a;
    }

    protected static Projection getProjection(Fov[] fovs) {
        double maxDE;
        double maxRA;
        double de = 0.0;
        double ra = 0.0;
        double minRA = maxRA = fovs[0].alpha;
        double minDE = maxDE = fovs[0].delta;
        int nbProcessed = 0;
        for (int i = 0; i < fovs.length; ++i) {
            double y;
            double x;
            if (fovs[i] == null) continue;
            double raTmp = fovs[i].alpha;
            double deTmp = fovs[i].delta;
            if (raTmp > 180.0) {
                raTmp = -360.0 + raTmp;
            }
            if (deTmp > 180.0) {
                deTmp = -360.0 + deTmp;
            }
            ra += raTmp;
            de += deTmp;
            if (fovs[i].spectrumFov) {
                x = 0.0;
                y = 0.02;
            } else {
                x = fovs[i].x;
                y = fovs[i].y;
            }
            minRA = PlanFov.min(minRA, raTmp - x);
            maxRA = PlanFov.max(maxRA, raTmp + x);
            minDE = PlanFov.min(minDE, deTmp - y);
            maxDE = PlanFov.max(maxDE, deTmp + y);
            ++nbProcessed;
        }
        double[] diff = new double[]{PlanFov.abs((de /= (double)nbProcessed) - (minDE %= 360.0)), PlanFov.abs(de - (maxDE %= 360.0)), PlanFov.abs((ra /= (double)nbProcessed) - (minRA %= 360.0)), PlanFov.abs(ra - (maxRA %= 360.0))};
        for (int i = 0; i < 4; ++i) {
            if (!(diff[i] > 180.0)) continue;
            diff[i] = PlanFov.abs(-360.0 + diff[i]);
        }
        double radius = PlanFov.max(PlanFov.max(diff[0], diff[1]), PlanFov.max(diff[2], diff[3]));
        return new Projection(null, 3, ra, de, radius * 60.0 * 2.0, 250.0, 250.0, 500.0, 0.0, false, 2, Calib.FK5, null);
    }

    private void suite() {
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        Plan ref = this.aladin.calque.getPlanRef();
        if (this.fov == null || this.fov.length == 0) {
            return;
        }
        this.projd = ref == null || !Projection.isOk(ref.projd) ? PlanFov.getProjection(this.fov) : ref.projd;
        for (int i = 0; i < this.fov.length; ++i) {
            Fov curFov = this.fov[i];
            if (curFov == null) continue;
            if (curFov.pf != null) {
                PlanField pf = new PlanField(this.aladin, curFov.fpBean, curFov.key);
                pf.make(curFov.alpha, curFov.delta, curFov.angle);
                Iterator<Obj> it = pf.pcat.iterator();
                while (it.hasNext()) {
                    Obj o = it.next();
                    if (o instanceof Position) {
                        ((Position)o).plan = this;
                    }
                    this.pcat.setObjet(o);
                }
            }
            ArrayList<PointD[]> polygons = new ArrayList<PointD[]>();
            if (curFov.getStcObjects() != null) {
                for (STCObj stcObj : curFov.getStcObjects()) {
                    if (stcObj.getShapeType() != STCObj.ShapeType.POLYGON) continue;
                    STCPolygon stcPolygon = (STCPolygon)stcObj;
                    PointD[] polygonBords = new PointD[stcPolygon.getxCorners().size()];
                    for (int k = 0; k < polygonBords.length; ++k) {
                        polygonBords[k] = new PointD(stcPolygon.getxCorners().get(k), stcPolygon.getyCorners().get(k));
                    }
                    polygons.add(polygonBords);
                }
            } else {
                polygons.add(curFov.getPoints());
            }
            for (PointD[] polygon : polygons) {
                PointD curPoint = polygon[polygon.length - 1];
                if (curPoint == null) continue;
                Ligne curLine = new Ligne(this);
                curLine.raj = curPoint.x;
                curLine.dej = curPoint.y;
                this.pcat.setObjet(curLine);
                for (int j = 0; j < polygon.length; ++j) {
                    curPoint = polygon[j];
                    Ligne newLine = new Ligne(this);
                    newLine.raj = curPoint.x;
                    newLine.dej = curPoint.y;
                    newLine.debligne = curLine;
                    this.pcat.setObjet(newLine);
                    curLine = newLine;
                }
            }
        }
    }

    @Override
    protected boolean freePlan() {
        this.fov = null;
        return super.freePlan();
    }
}

