/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.FootprintBean;
import cds.aladin.Forme;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.Pickle;
import cds.aladin.Plan;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Repere;
import cds.aladin.SubFootprintBean;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.Proj3;
import cds.tools.Util;
import cds.tools.VOApp;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public final class PlanField
extends Plan {
    private static final int CFH12K = 0;
    private static final int EPICMOS = 1;
    private static final int EPICPN = 2;
    private static final int MEGACAM = 3;
    private static final int MEGAPRIME = 4;
    private static final int WIRCAM = 5;
    private static final int ESPADONS = 6;
    private static String[] INSTR = new String[]{"CFH12K", "EPICMOS", "EPICpn", "MEGACAM", "MEGAPRIME", "WIRCAM", "ESPADONS"};
    private int instr;
    private boolean flagRoll = true;
    private boolean flagCenterRoll = false;
    private boolean flagMove = true;
    private double roll;
    protected boolean needTarget;
    private boolean almaFP = false;
    private FootprintBean fpBean;
    private String fovLabel = null;
    private static final double EPICMOS_RA = 0.18166666666666667;
    private static final double EPICMOS_DE = 0.18166666666666667;
    private static final double[] EPICMOS_DRA = new double[]{-1.5, -1.5, -0.5, -0.5, -0.5, 0.5, 0.5};
    private static final double[] EPICMOS_DDE = new double[]{-1.0, 0.0, -1.5, -0.5, 0.5, -1.0, 0.0};
    private static final double EPICPN_RA = 0.07333333333333333;
    private static final double EPICPN_DE = 0.22666666666666666;
    private static final double[] EPICPN_DRA = new double[]{-3.0, -2.0, -1.0, 0.0, 1.0, 2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0};
    private static final double[] EPICPN_DDE = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double CFH12K_RA = 0.11719111111111111;
    private static final double CFH12K_DE = 0.23438222222222221;
    private static final double[] CFH12K_DRA = new double[]{-3.0, -2.0, -1.0, 0.0, 1.0, 2.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0};
    private static final double[] CFH12K_DDE = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[] CFH12K_GAPRA = new double[]{-15.0, -9.0, -3.0, 3.0, 9.0, 15.0, -15.0, -9.0, -3.0, 3.0, 9.0, 15.0};
    private static final double[] CFH12K_GAPDE = new double[]{-3.0, -3.0, -3.0, -3.0, -3.0, -3.0, 3.0, 3.0, 3.0, 3.0, 3.0, 3.0};
    private static final double CFH12K_ORA = -0.004166666666666667;
    private static final double CFH12K_ODE = 0.008333333333333333;
    private static final String[] CFH12K_CCD = new String[]{"06", "07", "08", "09", "10", "11", "00", "01", "02", "03", "04", "05"};
    private static final double MEGACAM_RA = 0.10638222222222223;
    private static final double MEGACAM_DE = 0.23956777777777777;
    private static final double[] MEGACAM_DRA = new double[]{-4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5, -4.5, -3.5, -2.5, -1.5, -0.5, 0.5, 1.5, 2.5, 3.5};
    private static final double[] MEGACAM_DDE = new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private static final double[] MEGACAM_GAPRA = new double[]{-56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0, -56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0, -56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0, -56.0, -42.0, -28.0, -14.0, 0.0, 14.0, 28.0, 42.0, 56.0};
    private static final double[] MEGACAM_GAPDE = new double[]{-88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -88.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, -5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 5.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5, 88.5};
    private static final double MEGACAM_ORA = 0.004166666666666667;
    private static final double MEGACAM_ODE = -0.005694444444444445;
    private static final String[] MEGACAM_CCD = new String[]{"35", "34", "33", "32", "31", "30", "29", "28", "27", "26", "25", "24", "23", "22", "21", "20", "19", "18", "17", "16", "15", "14", "13", "12", "11", "10", "09", "08", "07", "06", "05", "04", "03", "02", "01", "00"};
    private static final double MEGAGUI_RA = 0.3425;
    private static final double MEGAGUI_DE = 0.24736111111111111;
    private static final double[] MEGAGUI_DRA = new double[]{-0.5, -0.5};
    private static final double[] MEGAGUI_DDE = new double[]{-1.0, 0.0};
    private static final double[] MEGAGUI_GAPRA = new double[]{0.0, 0.0};
    private static final double[] MEGAGUI_GAPDE = new double[]{-1739.9, 1739.9};
    private static final String[] MEGAGUI_BOX = new String[]{"S", "N"};
    private static final double WIRCAM_RA = 0.17066666666666666;
    private static final double WIRCAM_DE = 0.17066666666666666;
    private static final double[] WIRCAM_DRA = new double[]{-1.0, 0.0, -1.0, 0.0};
    private static final double[] WIRCAM_DDE = new double[]{-1.0, -1.0, 0.0, 0.0};
    private static final double[] WIRCAM_GAPRA = new double[]{-45.0, 0.0, -45.0, 0.0};
    private static final double[] WIRCAM_GAPDE = new double[]{-45.0, -45.0, 0.0, 0.0};
    private static final double WIRCAM_ORA = 0.008333333333333333;
    private static final double WIRCAM_ODE = 0.008333333333333333;
    private static final String[] WIRCAM_CCD = new String[]{"52", "54", "77", "60"};
    private static final double WIRCAM_RD = 0.0;
    private static final double ESPADONS_RA = 0.03333333333333333;
    private static final double ESPADONS_DE = 0.03333333333333333;
    private static final double[] ESPADONS_DRA = new double[]{-0.5};
    private static final double[] ESPADONS_DDE = new double[]{-0.5};
    private static final double[] ESPADONS_GAPRA = new double[]{0.0};
    private static final double[] ESPADONS_GAPDE = new double[]{0.0};
    private static final double ESPADONS_ORA = 0.0;
    private static final double ESPADONS_ODE = 0.0;
    private static final String[] ESPADONS_CCD = new String[]{""};
    private static final double ESPADONS_RD = 0.0;
    private boolean showSubFPInProperties = true;
    protected VOApp observer = null;
    private Astrocoo afs = new Astrocoo(Astroframe.create("ICRS"));
    protected Vector subFoV = null;
    protected JCheckBox[] cbSubFoV;

    public static final double tand(double x) {
        return Math.tan(x * (Math.PI / 180));
    }

    protected PlanField(Aladin aladin, String label) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.objet = null;
        this.body = "sky";
    }

    protected PlanField(Aladin aladin, String target, double roll, String label, String instrument) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.selectPlan(this);
        this.objet = null;
        this.body = "sky";
        this.setInstr(instrument);
        if (target.length() == 0 || Localisation.notCoord(target)) {
            this.needTarget = true;
            this.setActivated(false);
            this.roll = roll;
            if (target.length() > 0) {
                this.objet = target;
            }
        } else {
            Coord co;
            try {
                co = new Coord(target);
            }
            catch (Exception e) {
                Aladin.error = "Unknown object";
                this.error = "Unknown object";
                return;
            }
            this.needTarget = false;
            this.setActivated(true);
            this.make(co.al, co.del, roll);
        }
    }

    protected PlanField(Aladin aladin, String label, Coord center, double angle, boolean canbeRoll, boolean canbeMove) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        this.selected = true;
        this.flagOk = true;
        this.askActive = true;
        this.flagRoll = canbeRoll;
        this.flagMove = canbeMove;
        this.instr = -1;
        this.roll = angle;
        this.co = center != null ? center : new Coord(0.0, 0.0);
        Repere projCenter = new Repere((Plan)this, this.co);
        projCenter.setType(4);
        Repere rotCenter = new Repere((Plan)this, this.co);
        rotCenter.setRotCenterType(projCenter);
        this.pcat.setObjetFast(rotCenter);
        this.pcat.setObjetFast(projCenter);
        this.needTarget = false;
        this.make(this.co.al, this.co.del, this.roll);
    }

    protected PlanField(Aladin aladin, FootprintBean fpBean, String label) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.selectPlan(this);
        this.objet = null;
        this.body = "sky";
        this.instr = -1;
        this.fpBean = fpBean;
        this.setObjects(fpBean);
        this.needTarget = false;
    }

    protected PlanField(Aladin aladin, String target, FootprintBean fpBean, String label, double roll) {
        this.aladin = aladin;
        this.type = 10;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setLabel(label);
        this.setOpacityLevel(Aladin.DEFAULT_FOOTPRINT_OPACITY_LEVEL);
        this.pcat = new Pcat(this, this.c, aladin.calque, aladin.status, aladin);
        aladin.calque.selectPlan(this);
        this.objet = null;
        this.body = "sky";
        this.instr = -1;
        this.fpBean = fpBean;
        this.setObjects(fpBean);
        if (target == null || target.length() == 0 || Localisation.notCoord(target)) {
            this.needTarget = true;
            this.setActivated(false);
            this.roll = roll;
            if (target.length() > 0) {
                this.objet = target;
            }
        } else {
            Coord co;
            try {
                co = new Coord(target);
            }
            catch (Exception e) {
                Aladin.error = "Unknown object";
                this.error = "Unknown object";
                return;
            }
            this.needTarget = false;
            this.setActivated(true);
            this.make(co.al, co.del, roll);
        }
        this.setRollable(fpBean.isRollable());
    }

    @Override
    protected void setLabel(String s) {
        if (s == null) {
            s = "FoV";
        }
        if (this.fovLabel == null) {
            this.fovLabel = s;
        }
        super.setLabel(s);
    }

    protected boolean resolveTarget(double ra, double de) {
        this.needTarget = false;
        this.make(ra, de, this.roll);
        this.planReady(true);
        return true;
    }

    @Override
    protected boolean setActivated() {
        boolean rep = super.setActivated();
        if (!rep) {
            this.aladin.view.unSelectObjetPlanField(this);
        }
        return rep;
    }

    protected void make(double ra, double de, double roll) {
        this.make(ra, de, ra, de, roll);
    }

    protected void make(double ra, double de, double raRot, double deRot, double roll) {
        this.projd = new Projection(null, 3, ra, de, this.instr == 3 || this.instr == 4 ? 100.0 : 45.0, 250.0, 250.0, 500.0, 0.0, false, 2, Calib.FK5, (Plan)this);
        switch (this.instr) {
            case 3: {
                this.setRollable(false);
                this.makeCCDs(0.004166666666666667, -0.005694444444444445, 0.10638222222222223, 0.23956777777777777, MEGACAM_DRA, MEGACAM_DDE, MEGACAM_GAPRA, MEGACAM_GAPDE, MEGACAM_CCD);
                break;
            }
            case 4: {
                this.setRollable(false);
                this.makeCCDs(0.004166666666666667, -0.005694444444444445, 0.10638222222222223, 0.23956777777777777, MEGACAM_DRA, MEGACAM_DDE, MEGACAM_GAPRA, MEGACAM_GAPDE, MEGACAM_CCD);
                this.makeCCDs(0.004166666666666667, -0.005694444444444445, 0.3425, 0.24736111111111111, MEGAGUI_DRA, MEGAGUI_DDE, MEGAGUI_GAPRA, MEGAGUI_GAPDE, MEGAGUI_BOX);
                break;
            }
            case 0: {
                this.setRollable(false);
                this.makeCCDs(-0.004166666666666667, 0.008333333333333333, 0.11719111111111111, 0.23438222222222221, CFH12K_DRA, CFH12K_DDE, CFH12K_GAPRA, CFH12K_GAPDE, CFH12K_CCD);
                break;
            }
            case 5: {
                this.setRollable(false);
                this.makeCCDs(0.008333333333333333, 0.008333333333333333, 0.17066666666666666, 0.17066666666666666, WIRCAM_DRA, WIRCAM_DDE, WIRCAM_GAPRA, WIRCAM_GAPDE, WIRCAM_CCD);
                break;
            }
            case 6: {
                this.setRollable(false);
                this.makeCCDs(0.0, 0.0, 0.03333333333333333, 0.03333333333333333, ESPADONS_DRA, ESPADONS_DDE, ESPADONS_GAPRA, ESPADONS_GAPDE, ESPADONS_CCD);
                break;
            }
            case 1: {
                this.setRollable(true);
                this.makeCCDs(0.0, 0.0, 0.18166666666666667, 0.18166666666666667, EPICMOS_DRA, EPICMOS_DDE, null, null, null);
                break;
            }
            case 2: {
                this.setRollable(true);
                this.makeCCDs(0.0, 0.0, 0.07333333333333333, 0.22666666666666666, EPICPN_DRA, EPICPN_DDE, null, null, null);
            }
        }
        this.setTarget(ra, de, raRot, deRot, roll);
    }

    private void makeCCDs(double ORA, double ODE, double RA, double DE, double[] DRA, double[] DDE, double[] GAPRA, double[] GAPDE, String[] CCD) {
        int j = 0;
        if (this.pcat.o != null) {
            Obj[] o = this.pcat.o;
            this.pcat.nb_o = o.length + DRA.length * 5 + (CCD == null ? 0 : CCD.length);
            this.pcat.o = new Obj[this.pcat.nb_o];
            System.arraycopy(o, 0, this.pcat.o, 0, o.length);
            j = o.length;
        } else {
            this.pcat.nb_o = DRA.length * 5 + 2 + (CCD == null ? 0 : CCD.length);
            this.pcat.o = new Obj[this.pcat.nb_o];
            j = 2;
            Repere center = new Repere(this);
            center.setType(4);
            this.pcat.o[1] = center;
            Repere rotCenter = new Repere(this);
            rotCenter.setRotCenterType(center);
            this.pcat.o[0] = rotCenter;
        }
        for (int i = 0; i < DRA.length; ++i) {
            Ligne p = null;
            int k = 0;
            while (k < 5) {
                p = new Ligne(this);
                this.pcat.o[j] = p;
                double gapra = GAPRA == null ? 0.0 : GAPRA[i] / 3600.0;
                double gapde = GAPDE == null ? 0.0 : GAPDE[i] / 3600.0;
                p.x = Util.tand((DRA[i] + (k == 1 || k == 2 ? 1.0 : 0.0)) * RA + gapra - ORA);
                p.y = Util.tand((DDE[i] + (k == 2 || k == 3 ? 1.0 : 0.0)) * DE + gapde - ODE);
                if (k > 0) {
                    p.debligne = (Ligne)this.pcat.o[j - 1];
                }
                if (k < 4) {
                    p.finligne = (Ligne)this.pcat.o[j + 1];
                } else {
                    p.bout = (byte)3;
                }
                ++k;
                ++j;
            }
            if (CCD == null) continue;
            Tag t = new Tag(this, null, 0.0, 0.0, CCD[i]);
            t.x = p.x + Util.tand(RA / 3.0 - ORA);
            t.y = p.y + Util.tand(0.016666666666666666 - ODE);
            this.pcat.o[j++] = t;
        }
    }

    protected void setParameters(double raProjCenter, double deProjCenter, double raRotCenter, double deRotCenter, double roll) {
        Position p = this.getProjCenterObjet();
        if (!this.flagMove || Double.isNaN(raProjCenter) || Double.isNaN(deProjCenter)) {
            raProjCenter = p.raj;
            deProjCenter = p.dej;
        }
        if (!this.flagRoll || Double.isNaN(raRotCenter) || Double.isNaN(deRotCenter)) {
            roll = this.roll;
            raRotCenter = raProjCenter;
            deRotCenter = deProjCenter;
        } else {
            roll = this.angle(roll);
        }
        this.setTarget(raProjCenter, deProjCenter, raRotCenter, deRotCenter, roll);
    }

    private synchronized void setTarget(double raP, double deP, double raR, double deR, double roll) {
        double cosr = 1.0;
        double sinr = 0.0;
        if (this.co == null) {
            this.co = new Coord();
        }
        this.co.al = raP;
        this.co.del = deP;
        this.objet = this.co.getSexa();
        Proj3 a = new Proj3(1, raP, deP);
        Position rot = this.getRotCenterObjet();
        a.set(new Coo(raR, deR));
        double offsetX = a.getX();
        double offsetY = a.getY();
        rot.x = offsetX;
        rot.y = offsetY;
        rot.raj = raR;
        rot.dej = deR;
        this.roll = roll;
        if (roll != 0.0) {
            cosr = AstroMath.cosd(roll);
            sinr = AstroMath.sind(roll);
        }
        for (int i = 1; i < this.pcat.nb_o; ++i) {
            double y;
            double x;
            Position p = (Position)this.pcat.o[i];
            if (p instanceof Forme) {
                Forme f = (Forme)p;
                for (int j = 0; j < f.o.length; ++j) {
                    p = f.o[j];
                    x = p.x;
                    y = p.y;
                    if (roll != 0.0) {
                        double xr = (x -= offsetX) * cosr + (y -= offsetY) * sinr;
                        double yr = -x * sinr + y * cosr;
                        x = xr + offsetX;
                        y = yr + offsetY;
                    }
                    a.set(x, y);
                    p.raj = a.getLon();
                    p.dej = a.getLat();
                }
                continue;
            }
            x = p.x;
            y = p.y;
            if (roll != 0.0) {
                double xr = (x -= offsetX) * cosr + (y -= offsetY) * sinr;
                double yr = -x * sinr + y * cosr;
                x = xr + offsetX;
                y = yr + offsetY;
            }
            a.set(x, y);
            p.raj = a.getLon();
            p.dej = a.getLat();
        }
        Properties.majProp(this);
    }

    protected void reset(int flag) {
        Position c = this.getProjCenterObjet();
        Position cr = this.getRotCenterObjet();
        if (c != null) {
            this.setTarget(c.raj, c.dej, cr.raj, cr.dej, this.roll);
            if ((flag & 1) != 0) {
                this.sendTargetObserver(false);
            }
            if ((flag & 2) != 0) {
                this.sendRollObserver(false);
            }
            if ((flag & 4) != 0) {
                this.sendRotCenterObserver(false);
            }
        }
        this.aladin.view.newView();
    }

    protected void changeRoll(double roll) {
        Position c = this.getProjCenterObjet();
        Position cr = this.getRotCenterObjet();
        this.setTarget(c.raj, c.dej, cr.raj, cr.dej, roll);
    }

    protected void changeTarget(double raj, double dej) {
        Position c = this.getProjCenterObjet();
        Position cr = this.getRotCenterObjet();
        if (Double.isNaN(raj) || Double.isNaN(dej)) {
            raj = c.raj;
            dej = c.dej;
        }
        double deltaRa = raj - c.raj;
        double deltaDE = dej - c.dej;
        this.setTarget(raj, dej, cr.raj + deltaRa, cr.dej + deltaDE, this.roll);
    }

    protected void changeRotCenter(double raj, double dej) {
        Position c = this.getProjCenterObjet();
        if (Double.isNaN(raj) || Double.isNaN(dej)) {
            raj = c.raj;
            dej = c.dej;
        }
        this.setTarget(c.raj, c.dej, raj, dej, this.roll);
    }

    protected void addObserver(VOApp observer) {
        this.observer = observer;
    }

    protected void sendTargetObserver(boolean cont) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label) + " Target=" + this.getTarget() + (cont ? " ..." : ""));
    }

    protected void sendRotCenterObserver(boolean cont) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label) + " RotCenter=" + this.getRotCenter() + (cont ? " ..." : ""));
    }

    protected void sendRollObserver(boolean cont) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label) + " Roll=" + this.roll + (cont ? " ..." : ""));
    }

    protected void sendSubFovObserver(String subFoVID, boolean visible) {
        if (this.observer == null) {
            return;
        }
        this.observer.execCommand("set " + Tok.quote(this.label + "/" + subFoVID) + " Status=" + (visible ? "shown" : "hidden"));
    }

    private void setObjects(FootprintBean bean) {
        SubFootprintBean[] fovParts = bean.getBeans();
        int nbO = 0;
        int nbSubFov = fovParts.length;
        Obj[][] o = new Obj[nbSubFov][];
        for (int i = 0; i < nbSubFov; ++i) {
            o[i] = fovParts[i].buildObjets(this);
            nbO += o[i].length;
        }
        this.pcat.nb_o = nbO + 2;
        this.pcat.o = new Obj[this.pcat.nb_o];
        Repere projCenter = new Repere(this);
        projCenter.setType(4);
        this.pcat.o[1] = projCenter;
        Repere rotCenter = new Repere(this);
        rotCenter.setRotCenterType(projCenter);
        this.pcat.o[0] = rotCenter;
        int idxStart = 2;
        for (int i = 0; i < nbSubFov; ++i) {
            System.arraycopy(o[i], 0, this.pcat.o, idxStart, o[i].length);
            this.addSubFoV(fovParts[i].getName(), fovParts[i].getDesc(), idxStart, idxStart + o[i].length - 1, true, fovParts[i].getColor());
            idxStart += o[i].length;
        }
    }

    private void setInstr(String instrument) {
        for (int i = 0; i < INSTR.length; ++i) {
            if (!INSTR[i].equalsIgnoreCase(instrument)) continue;
            this.instr = i;
            return;
        }
        this.instr = -1;
    }

    protected void memTarget() {
    }

    @Override
    protected boolean setActivated(boolean flag) {
        this.askActive = flag;
        boolean rep = this.setActivated();
        if (rep == flag && this.observer != null) {
            this.observer.execCommand("set " + Tok.quote(this.label) + " Status=" + (flag ? "shown" : "hidden"));
        }
        return rep;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("Target")) {
            if (!this.isMovable()) {
                throw new Exception("Not movable aperture");
            }
            Coord co = new Coord(value);
            this.changeTarget(co.al, co.del);
        } else if (prop.equalsIgnoreCase("Roll")) {
            if (!this.isRollable()) {
                throw new Exception("Not rollable aperture");
            }
            double roll = Double.valueOf(value);
            this.changeRoll(roll);
        } else if (prop.equalsIgnoreCase("RotCenter")) {
            if (!this.isRollable()) {
                throw new Exception("Not rollable aperture");
            }
            if (value.trim().length() == 0) {
                Position c = this.getProjCenterObjet();
                this.changeRotCenter(c.raj, c.dej);
            } else {
                Coord co = new Coord(value);
                this.changeRotCenter(co.al, co.del);
            }
        } else if (prop.equalsIgnoreCase("Rollable")) {
            if (value.equalsIgnoreCase("True")) {
                this.setRollable(true);
            } else {
                if (!value.equalsIgnoreCase("False")) throw new Exception("Rollable propertie should be \"true\" or \"false\" !");
                this.setRollable(false);
            }
        } else if (prop.equalsIgnoreCase("Movable")) {
            if (value.equalsIgnoreCase("True")) {
                this.setMovable(true);
            } else {
                if (!value.equalsIgnoreCase("False")) throw new Exception("Movable propertie should be \"true\" or \"false\" !");
                this.setMovable(false);
            }
        } else if (prop.equalsIgnoreCase("Status") && specif != null) {
            boolean flag;
            int[] n = this.findSubFoVs(specif);
            if (n.length == 0) {
                throw new Exception("Unknown " + this.label + " FoV [" + specif + "]");
            }
            if (value.indexOf("shown") >= 0) {
                flag = true;
            } else {
                if (value.indexOf("hidden") < 0) throw new Exception("Unknown FoV status [" + value + "]");
                flag = false;
            }
            for (int i = 0; i < n.length; ++i) {
                this.setVisibleSubFoV(n[i], flag);
            }
        } else {
            super.setPropertie(prop, null, value);
        }
        if (this.observer != null && !prop.equals("Status")) {
            this.observer.execCommand("set " + Tok.quote(this.label) + " " + prop + "=" + value);
        }
        Properties.majProp(this);
        this.aladin.view.resetClip();
        this.aladin.view.newView(1);
    }

    @Override
    protected String getInfo() {
        return this.label + super.addDebugInfo();
    }

    protected Coord getCenter() {
        Position pos = this.getProjCenterObjet();
        return new Coord(pos.raj, pos.dej);
    }

    protected Position getProjCenterObjet() {
        try {
            return (Position)this.pcat.o[1];
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Position getRotCenterObjet() {
        try {
            return (Position)this.pcat.o[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void resetRotCenterObjet() {
        try {
            this.pcat.o[0].raj = this.pcat.o[1].raj;
            this.pcat.o[0].dej = this.pcat.o[1].dej;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getProjCenter() {
        Position c = this.getProjCenterObjet();
        if (c == null) {
            return "";
        }
        return this.aladin.localisation.J2000ToString(c.raj, c.dej, 11, false);
    }

    protected String getRotCenter() {
        Position c = this.getRotCenterObjet();
        if (c == null) {
            return "";
        }
        return this.aladin.localisation.J2000ToString(c.raj, c.dej, 11, false);
    }

    @Override
    protected String getTarget() {
        Position c = this.getProjCenterObjet();
        if (c == null) {
            return null;
        }
        this.afs.setPrecision(9);
        this.afs.set(c.raj, c.dej);
        return this.afs.toString("2:");
    }

    protected String getRoll() {
        return (double)((int)Math.round(this.roll * 10.0)) / 10.0 + "";
    }

    protected boolean isNewRoll(double x) {
        return this.roll != this.angle(x);
    }

    private double angle(double x) {
        if ((x %= 360.0) < 0.0) {
            x += 360.0;
        }
        return x;
    }

    protected void deltaRoll(double x) {
        this.setRoll(this.roll + x);
    }

    private void setRoll(double x) {
        if (!this.flagRoll) {
            return;
        }
        this.roll = this.angle(x);
    }

    protected boolean isRollable() {
        return this.flagRoll;
    }

    protected void setRollable(boolean b) {
        this.flagRoll = b;
    }

    protected boolean isCenterRollable() {
        return this.flagCenterRoll;
    }

    protected void setCenterRollable(boolean b) {
        this.flagCenterRoll = b;
    }

    protected void setMovable(boolean b) {
        this.flagMove = b;
    }

    @Override
    protected boolean isMovable() {
        return this.flagMove;
    }

    protected boolean switchCheckbox(JCheckBox cb) {
        if (this.cbSubFoV == null) {
            return false;
        }
        for (int i = 0; i < this.cbSubFoV.length; ++i) {
            if (cb != this.cbSubFoV[i]) continue;
            this.setVisibleSubFoV(i, cb.isSelected());
            return true;
        }
        return false;
    }

    protected JPanel getPanelSubFov(ActionListener al) {
        if (this.subFoV == null || this.subFoV.size() == 0 || this.isAlmaFP()) {
            return null;
        }
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(0, 1));
        int nb = this.subFoV.size();
        this.cbSubFoV = new JCheckBox[nb];
        for (int i = 0; i < nb; ++i) {
            PlanFieldSub sfov = this.getSubFoV(i);
            this.cbSubFoV[i] = new JCheckBox(i + 1 + ".- " + sfov.ID + " " + sfov.desc, sfov.visible);
            this.cbSubFoV[i].addActionListener(al);
            p.add(this.cbSubFoV[i]);
        }
        return p;
    }

    protected void exportAlmaPointings() {
        ArrayList<Forme> pointings = new ArrayList<Forme>();
        for (Obj obj : this.pcat.o) {
            if (!(obj instanceof Cercle) || obj instanceof Pickle) continue;
            pointings.add((Forme)obj);
        }
        String vot = Util.createVOTable(pointings);
        this.aladin.calque.newPlanCatalog(new MyInputStream(new BufferedInputStream(new ByteArrayInputStream(vot.getBytes()))), "Pointings");
    }

    protected boolean isAlmaFP() {
        return this.almaFP;
    }

    protected void setIsAlmaFP(boolean b) {
        this.almaFP = b;
    }

    protected String getStatusSubFov() {
        if (this.subFoV == null || this.subFoV.size() == 0) {
            return null;
        }
        StringBuffer res = new StringBuffer(100);
        int nb = this.subFoV.size();
        for (int i = 0; i < nb; ++i) {
            PlanFieldSub sfov = this.getSubFoV(i);
            res.append("FoV      " + Tok.quote(sfov.ID) + " Status=" + (sfov.visible ? "shown" : "hidden") + "\n");
        }
        return res.toString();
    }

    protected void addSubFoV(String ID, String desc, int first, int last, boolean visible, Color color) {
        PlanFieldSub sfov = new PlanFieldSub(ID, desc, first, last, visible, color);
        if (this.subFoV == null) {
            this.subFoV = new Vector(10);
        }
        this.subFoV.addElement(sfov);
    }

    protected int[] findSubFoVs(String masq) {
        int n = this.subFoV.size();
        int[] res = new int[n];
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if (!Util.matchMask(masq, ((PlanFieldSub)this.subFoV.elementAt((int)i)).ID)) continue;
            res[j++] = i;
        }
        int[] r = new int[j];
        System.arraycopy(res, 0, r, 0, j);
        return r;
    }

    protected int findSubFoV(String ID) {
        if (this.subFoV == null) {
            return -1;
        }
        for (int i = this.subFoV.size() - 1; i >= 0; --i) {
            if (!((PlanFieldSub)this.subFoV.elementAt((int)i)).ID.equals(ID)) continue;
            return i;
        }
        return -1;
    }

    protected int findSubFoV(int index) {
        if (this.subFoV == null) {
            return -1;
        }
        for (int i = this.subFoV.size() - 1; i >= 0; --i) {
            PlanFieldSub sFov = (PlanFieldSub)this.subFoV.elementAt(i);
            if (sFov.first > index || index > sFov.last) continue;
            return i;
        }
        return -1;
    }

    protected PlanFieldSub getSubFoV(int n) {
        return (PlanFieldSub)this.subFoV.elementAt(n);
    }

    protected void setVisibleSubFoV(int n, boolean visible) {
        PlanFieldSub sfov = this.getSubFoV(n);
        if (sfov == null || sfov.visible == visible) {
            return;
        }
        sfov.visible = visible;
        for (int i = sfov.first; i <= sfov.last; ++i) {
            this.pcat.o[i].setVisibleGenerique(visible);
        }
        this.aladin.view.repaintAll();
        this.sendSubFovObserver(sfov.ID, visible);
    }

    protected Color getColor(Obj o) {
        int i = this.pcat.getIndex(o);
        if (i < 0) {
            return null;
        }
        int j = this.findSubFoV(i);
        if (j < 0) {
            return null;
        }
        Color x = this.getSubFoV((int)j).color;
        return x;
    }

    protected String getInstrumentName() {
        if (this.fpBean != null) {
            return this.fpBean.getInstrumentName();
        }
        return "";
    }

    protected String getInstrumentDesc() {
        if (this.fpBean != null) {
            return this.fpBean.getInstrumentDesc();
        }
        return "";
    }

    protected String getTelescopeName() {
        if (this.fpBean != null) {
            return this.fpBean.getTelescopeName();
        }
        return "";
    }

    protected String getOrigine() {
        if (this.fpBean != null) {
            return this.fpBean.getOrigin();
        }
        return "";
    }

    protected String getFovLabel() {
        return this.fovLabel;
    }

    private class PlanFieldSub {
        protected String ID;
        protected String desc;
        protected int first;
        protected int last;
        protected boolean visible;
        protected Color color;

        private PlanFieldSub(String ID, String desc, int first, int last, boolean visible, Color color) {
            this.ID = ID.replace('/', '.');
            this.desc = desc;
            this.first = first;
            this.last = last;
            this.visible = visible;
            this.color = color;
        }
    }
}

