/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Cercle;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.FilterProperties;
import cds.aladin.Forme;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Pcat;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFov;
import cds.aladin.PlanHips;
import cds.aladin.PlanHipsCat;
import cds.aladin.PlanImage;
import cds.aladin.PlanTool;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PlaneLoadListener;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.Slide;
import cds.aladin.Source;
import cds.aladin.SourceFootprint;
import cds.aladin.TapManager;
import cds.aladin.ViewSimple;
import cds.astro.Astroframe;
import cds.astro.Astropos;
import cds.astro.Astrotime;
import cds.astro.Unit;
import cds.tools.Astrodate;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.TableParser;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class Plan
implements Runnable {
    static String NOREDUCTION;
    static String NOPOSITION;
    protected static final int STATUS_UNKNOWN = 0;
    protected static final int STATUS_INPROGRESS = 1;
    protected static final int STATUS_MOREDETAILSAVAILABLE = 2;
    protected static final int STATUS_ERROR = 4;
    protected static final int STATUS_EMPTYMOC = 8;
    protected static final int STATUS_OVERFLOW = 16;
    protected static final int STATUS_NOCALIB = 32;
    protected static final int STATUS_EMPTYCAT = 64;
    protected static final int STATUS_LOADING = 128;
    protected static final int STATUS_READY = 256;
    protected static final int STATUS_NOPOS = 512;
    private static final String[] STATUS;
    static final int NO = 0;
    static final int IMG = 1;
    static final int IMGRGB = 2;
    static final int IMGBLINK = 3;
    static final int CUBE = 4;
    static final int IMGRSP = 5;
    static final int IMGMOSAIC = 6;
    static final int IMGALGO = 7;
    static final int CAT = 8;
    static final int TOOL = 9;
    static final int APERTURE = 10;
    static final int FOLDER = 11;
    static final int FILTER = 12;
    static final int FOV = 13;
    static final int X = 14;
    static final int IMGHUGE = 15;
    static final int HIPSIMG = 16;
    static final int HIPSPOL = 17;
    static final int HIPSCAT = 18;
    static final int MOC = 19;
    static final int CUBERGB = 20;
    static final int HIPSFINDER = 21;
    static final int HIPSCUBE = 22;
    static final int HIPS3D = 23;
    static final int TMOC = 24;
    static final int STMOC = 25;
    static final int FMOC = 26;
    static final int SFMOC = 27;
    public static final String BODYSKY = "sky";
    static String[] TYPE;
    protected String id = null;
    protected int type;
    protected int folder;
    protected Slide slide = null;
    protected boolean isOldPlan;
    protected boolean noBestPlacePost;
    protected boolean collapse;
    protected String body = null;
    protected String objet;
    public String label;
    protected String param;
    protected String description = null;
    protected String verboseDescr = null;
    protected String ack = null;
    protected String copyright = null;
    protected String copyrightUrl = null;
    protected String query = null;
    protected String tapUrl = null;
    protected double coRadius;
    protected Coord co;
    private double energy = -1.0;
    protected Color c;
    protected Astrotime epoch;
    protected Astrotime epochOrig;
    protected Projection projd;
    protected Projection projInit;
    protected Hashtable projD = null;
    protected FrameHeaderFits headerFits;
    private boolean hasSpecificCalib;
    protected String filename;
    protected Server server;
    protected float opacityLevel = 1.0f;
    protected Color colorBackground = null;
    protected String startingTaskId = null;
    boolean[] influence = new boolean[PlanFilter.LIMIT];
    protected boolean log = true;
    protected String[] filters;
    protected int filterIndex = -1;
    protected PlanFilter planFilter = null;
    boolean flagOk;
    boolean flagSkip;
    boolean flagProcessing;
    boolean flagUpdating;
    boolean flagWaitTarget;
    boolean active;
    boolean askActive;
    boolean selected;
    boolean isLastVisible;
    boolean underMouse;
    boolean isHighlighted;
    boolean ref;
    int timeStackIndex;
    int freqStackIndex;
    int hasPM = -1;
    protected boolean memoClinDoeil;
    Projection[] proj = new Projection[16];
    String error;
    int status;
    boolean flagLocal;
    protected boolean hasXYorig;
    protected boolean hasNoPos;
    protected boolean recalibrating;
    protected boolean isSelectable = true;
    protected boolean doClose = true;
    protected double initZoom = 1.0;
    protected double lastZoomView = 0.0;
    protected double lastXZoomView;
    protected double lastYZoomView;
    long statNbComputing = 0L;
    long statTimeComputing = 0L;
    long statTimeDisplay = 0L;
    long statNbItems = 0L;
    Pcat pcat;
    int sourceType = 1;
    boolean fullSource = false;
    MyInputStream dis = null;
    Thread runme;
    URL u;
    Vector<String> plasticIDs;
    Aladin aladin;
    int requestId = 0;
    private String bookmarkCode = null;
    private int cacheCatalogTimeFlag = -1;
    private boolean blinking = false;
    protected float scalingFactor = 1.0f;
    double pourcent = -1.0;
    static final int REFFORVISIBLEVIEW = 1;
    static final int CANBETRANSP = 2;
    static final int OUTOFVIEW = 4;
    static final int VIEWABLE = 8;
    static final int ACTIVATED = 16;
    static final int ASKACTIVATED = 32;
    static final int REF = 64;
    static final int FLAGOK = 128;
    static final int FLAGPROCESSING = 256;
    static final int FLAGUPDATING = 512;
    static final int SELECTED = 1024;
    static final int UNDERIMG = 2048;
    static final int UNDERBKGD = 4096;
    static final int NOTSAMEBODY = 8192;
    static final String[] DEBUGFLAG;
    private int debugFlag = 0;
    private boolean hasCheckBox = false;
    private long startCheckBoxBlink = 0L;
    private Vector listeners = new Vector();
    protected static final String ALADINQUERY = "AladinQuery";
    private long startTime;
    private int indexAnaglyphMag = -2;
    private int indexAnaglyphParallax = -2;

    protected static void createChaine(Chaine chaine) {
        NOREDUCTION = "No astronomical reduction";
        NOPOSITION = "No coordinate";
    }

    protected Plan() {
        this.type = 14;
        this.aladin = Aladin.aladin;
        this.flagOk = false;
        this.label = "";
        this.startTime = System.currentTimeMillis();
    }

    protected Plan(Aladin aladin) {
        this.aladin = aladin;
    }

    protected String getBookmarkCode() {
        return this.bookmarkCode;
    }

    protected void setBookmarkCode(String code) {
        this.bookmarkCode = code;
    }

    protected String getAdqlQuery() {
        return this.query;
    }

    protected void setAdqlQuery(String query) {
        this.query = query;
    }

    protected void copy(Plan p) {
        p.id = this.id;
        p.type = this.type;
        p.folder = this.folder;
        p.collapse = this.collapse;
        p.objet = this.objet;
        p.body = this.body;
        p.param = this.param;
        p.label = this.label;
        p.description = this.description;
        p.verboseDescr = this.verboseDescr;
        p.ack = this.ack;
        p.copyright = this.copyright;
        p.copyrightUrl = this.copyrightUrl;
        p.co = this.co;
        p.c = this.c;
        p.projd = this.projd == null ? null : this.projd.copy();
        p.projInit = this.projInit;
        p.projD = this.projD;
        p.hasSpecificCalib = this.hasSpecificCalib;
        p.influence = new boolean[this.influence.length];
        System.arraycopy(this.influence, 0, p.influence, 0, this.influence.length);
        p.log = this.log;
        p.flagOk = this.flagOk;
        p.active = this.active;
        p.askActive = this.askActive;
        p.selected = this.selected;
        p.underMouse = this.underMouse;
        p.ref = this.ref;
        p.proj = new Projection[this.proj.length];
        System.arraycopy(this.proj, 0, p.proj, 0, this.proj.length);
        p.error = this.error;
        p.flagLocal = this.flagLocal;
        p.hasPM = this.hasPM;
        p.hasXYorig = this.hasXYorig;
        p.hasNoPos = this.hasNoPos;
        p.initZoom = this.initZoom;
        p.lastZoomView = this.lastZoomView;
        p.lastXZoomView = this.lastXZoomView;
        p.lastYZoomView = this.lastYZoomView;
        p.pcat = this.pcat;
        p.u = this.u;
        p.filename = this.filename;
        p.opacityLevel = this.opacityLevel;
        p.active = this.active;
        p.ref = this.ref;
    }

    public void finalize() throws Throwable {
        this.freePlan();
    }

    protected boolean isSED() {
        if (this.getCounts() == 0) {
            return false;
        }
        Obj s = this.iterator().next();
        return s instanceof Source && ((Source)s).getLeg() != null && ((Source)s).getLeg().isSED();
    }

    protected boolean isOverlay() {
        return this.isCatalog() || this.isPlanBGOverlay() || this instanceof PlanTool || this instanceof PlanField || this instanceof PlanFov || this instanceof PlanFilter;
    }

    protected boolean isPixel() {
        return this.isImage() || this.type == 16;
    }

    protected final boolean isImage() {
        return this.type == 1 || this.type == 2 || this.type == 15 || this.type == 3 || this.type == 4 || this.type == 5 || this.type == 7 || this.type == 6 || this.type == 20;
    }

    protected final boolean isSimpleImage() {
        return this.type == 1 || this.type == 5 || this.type == 7 || this.type == 6 || this.type == 15;
    }

    public final boolean hasAvailablePixels() {
        return this.hasOriginalPixels();
    }

    protected boolean hasOriginalPixels() {
        return false;
    }

    protected final boolean hasNoReduction() {
        return this.error == NOREDUCTION || !Projection.isOk(this.projd);
    }

    protected final boolean hasNoPosition() {
        return this.error == NOPOSITION;
    }

    protected boolean isReady() {
        return this.type != 0 && this.flagOk && (this.error == null || this.hasNoReduction() || this.hasOverflow());
    }

    protected String getStackStatus() {
        StringBuilder rep = new StringBuilder();
        if (this.status != 0) {
            int code = 1;
            int i = 1;
            while (i < STATUS.length) {
                if ((code & this.status) != 0) {
                    if (rep.length() > 0) {
                        rep.append("\n");
                    }
                    rep.append(Aladin.chaine.getString(STATUS[i]));
                }
                ++i;
                code <<= 1;
            }
        }
        if (this instanceof PlanHips) {
            if (rep.length() > 0) {
                rep.append("\n");
            }
            rep.append("HiPS order: " + ((PlanHips)this).getInfoDetails());
        }
        return rep.toString();
    }

    public boolean hasOverflow() {
        return this.error != null && this.error.indexOf("OVERFLOW") >= 0;
    }

    public boolean hasError() {
        if (!this.flagOk) {
            return false;
        }
        if (this.hasNoReduction()) {
            return false;
        }
        if (this.hasNoPosition()) {
            return false;
        }
        if (this.hasOverflow()) {
            return false;
        }
        return this.error != null;
    }

    protected void setSourceType(int sourceType) {
        Iterator<Obj> it = this.iterator();
        if (it == null) {
            return;
        }
        while (it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Source)) continue;
            Source s = (Source)o;
            s.setSourceType(sourceType);
        }
        this.sourceType = sourceType;
    }

    public void setSelectable(boolean flag) {
        this.isSelectable = flag;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public boolean isFree() {
        return this.type == 0;
    }

    protected boolean isEmpty() {
        if (this.type == 0) {
            return false;
        }
        return this.hasError() || (this.isCatalog() || this.type == 9) && this.getCounts() == 0;
    }

    protected boolean hasFitsHeader() {
        return this.headerFits != null;
    }

    protected boolean hasSources() {
        return this.isCatalog() && this.iterator().hasNext();
    }

    protected boolean hasObj() {
        return this.pcat != null && this.pcat.hasObj();
    }

    protected boolean isPlanBGOverlay() {
        return this.type == 17 || this.type == 18;
    }

    protected boolean isOnPixel(int xImg, int yImg) {
        return false;
    }

    protected boolean isCatalog() {
        return false;
    }

    protected void resetTimeFieldCache() {
        this.cacheCatalogTimeFlag = -1;
    }

    protected boolean isCatalogFreq() {
        return false;
    }

    protected boolean isCatalogTime() {
        if (this.cacheCatalogTimeFlag != -1) {
            return this.cacheCatalogTimeFlag == 1;
        }
        int rep = 0;
        try {
            for (Legende leg : this.getLegende()) {
                if (leg.getTime() < 0) continue;
                rep = 1;
                break;
            }
            if (this.flagOk) {
                this.cacheCatalogTimeFlag = rep;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rep == 1;
    }

    protected double[] getTimeRange() {
        double tmin = Double.NaN;
        double tmax = Double.NaN;
        if (this.isTime()) {
            Iterator<Obj> it = this.iterator();
            while (it.hasNext()) {
                try {
                    Source src = (Source)it.next();
                    if (Double.isNaN(tmin) || src.jdtime < tmin) {
                        tmin = src.jdtime;
                    }
                    if (!Double.isNaN(tmax) && !(src.jdtime > tmax)) continue;
                    tmax = src.jdtime;
                }
                catch (Exception e) {}
            }
        }
        return new double[]{tmin, tmax};
    }

    protected double[] getFreqRange() {
        return new double[]{Double.NaN, Double.NaN};
    }

    protected boolean isTime() {
        return false;
    }

    protected boolean isFreq() {
        return false;
    }

    protected boolean isMoc() {
        return this.type == 19 || this.type == 24 || this.type == 25 || this.type == 26 || this.type == 27;
    }

    protected boolean isSpaceMoc() {
        return this.type == 19 || this.type == 25 || this.type == 27;
    }

    protected boolean isTimeMoc() {
        return this.type == 24 || this.type == 25;
    }

    protected boolean isFreqMoc() {
        return this.type == 26 || this.type == 27;
    }

    protected void setPlanBlink(boolean flag) {
        this.blinking = flag;
    }

    protected boolean isPlanBlink() {
        return this.blinking;
    }

    protected boolean isCubeClassique() {
        return false;
    }

    protected void activeCubePixels(ViewSimple v) {
    }

    public int getDepth() {
        return 1;
    }

    protected double getZ(ViewSimple v) {
        return 0.0;
    }

    protected double getZ() {
        return 0.0;
    }

    protected void setZ(double z) {
    }

    protected byte getPixel8bit(int z, double x, double y) {
        return 0;
    }

    protected void setPause(boolean t, ViewSimple v) {
    }

    protected boolean isPause() {
        return true;
    }

    protected int getInitDelay() {
        return 400;
    }

    synchronized void changeImgID() {
    }

    protected boolean setCubeFrame(double frame) {
        return false;
    }

    protected boolean isTool() {
        return this.type == 9 || this.type == 10 || this.type == 13 || this.isMoc();
    }

    protected boolean isSimpleCatalog() {
        return this.type == 8 || this.type == 9 && this.isCatalog();
    }

    protected boolean isSourceRemovable() {
        return this.pcat != null && this.pcat.removable;
    }

    protected boolean isMovable() {
        return true;
    }

    protected void setSourceRemovable(boolean flag) {
        this.pcat.removable = flag;
    }

    protected String getStats() throws Exception {
        if (!this.isCatalog()) {
            throw new Exception("Not a PlanCatalog");
        }
        int nbSelected = 0;
        int nbFiltered = 0;
        boolean filter = PlanFilter.allFilters.length > 0;
        int nbo = 0;
        Iterator<Obj> it = this.iterator();
        nbo = 0;
        while (it.hasNext()) {
            Obj o = it.next();
            if (o.asSource()) {
                Source s = (Source)o;
                if (s.isSelected()) {
                    ++nbSelected;
                }
                if (filter && s.isSelectedInFilter()) {
                    ++nbFiltered;
                }
            }
            ++nbo;
        }
        return nbo + " src" + (filter ? "/" + nbFiltered + " filt" : "") + (nbSelected != 0 ? "/" + nbSelected + " sel" : "");
    }

    protected Legende getFirstLegende() {
        return null;
    }

    protected Vector<Legende> getLegende() {
        return null;
    }

    protected int getNbTable() {
        return 0;
    }

    protected int getCounts() {
        return 0;
    }

    protected void reallocObjetCache() {
        if (this.pcat != null) {
            this.pcat.reallocObjetCache();
        }
    }

    protected boolean hasCatalogInfo() {
        return false;
    }

    protected Astrotime getOriginalEpoch() {
        try {
            if (this.epochOrig == null) {
                this.epochOrig = new Astrotime("J2000");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.epochOrig;
    }

    protected Astrotime getEpoch() {
        try {
            if (this.epoch == null) {
                this.epoch = new Astrotime("J2000");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.epoch;
    }

    protected void setOriginalEpoch(String s) throws Exception {
        if (Character.isDigit(s.charAt(0))) {
            s = "J" + s;
        }
        if (this.epochOrig == null) {
            this.epochOrig = new Astrotime(s);
        } else {
            this.epochOrig.set(s);
        }
    }

    protected void setEpoch(String s) throws Exception {
        if (Character.isDigit(s.charAt(0))) {
            s = "J" + s;
        }
        if (this.epoch == null) {
            this.epoch = new Astrotime(s);
        } else {
            this.epoch.set(s);
        }
        if (!this.recomputePosition()) {
            throw new Exception("Unknown proper motion fields !");
        }
    }

    public double getEnergy() {
        if (this.energy != -1.0) {
            return this.energy;
        }
        double x = Double.NaN;
        MyProperties prop = this.aladin.directory.getProperties(this.id);
        if (prop != null) {
            try {
                double em_min = Double.parseDouble(prop.get("em_min"));
                double em_max = Double.parseDouble(prop.get("em_max"));
                x = (em_max + em_min) / 2.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.energy = x;
        return x;
    }

    protected Obj[] getObj() {
        return new Obj[0];
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(float scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    protected Vector<Obj> setMultiSelect(ViewSimple v, RectangleD r) {
        if (!this.isSelectable()) {
            return new Vector<Obj>();
        }
        if (!(this instanceof PlanHips) && this.pcat != null && !this.pcat.isDrawnInSimpleView(v.n)) {
            return new Vector<Obj>();
        }
        Vector<Obj> res = new Vector<Obj>(5000);
        Iterator<Obj> it = this.iterator(v);
        while (it != null && it.hasNext()) {
            Obj o = it.next();
            if (!(o instanceof Position)) continue;
            Position p = (Position)o;
            if (p.plan.type == 13 || p instanceof Forme || !p.inRectangle(v, r) || !p.inTime(v) || p.asSource() && !((Source)p).noFilterInfluence() && !((Source)p).isSelectedInFilter()) continue;
            p.setSelect(true);
            res.addElement(p);
        }
        return res;
    }

    protected Vector<Obj> getObjWith(ViewSimple v, double x, double y) {
        if (!this.isSelectable()) {
            return new Vector<Obj>();
        }
        if (this.pcat != null && !this.pcat.isDrawnInSimpleView(v.n)) {
            return new Vector<Obj>(1);
        }
        Vector<Obj> res = new Vector<Obj>(500);
        Iterator<Obj> it = this.iterator(v);
        if (it == null) {
            return new Vector<Obj>(1);
        }
        if (this.type == 10) {
            int i = 0;
            while (it.hasNext()) {
                Obj o = it.next();
                if (o.in(v, x, y)) {
                    if (i == 0 && Aladin.ROTATEFOVCENTER && ((PlanField)this).isRollable() && ((PlanField)this).isCenterRollable()) {
                        this.aladin.calque.planRotCenter = ((Repere)o).plan;
                        res.addElement(o);
                    } else {
                        this.aladin.calque.planRotCenter = null;
                        Iterator<Obj> it1 = this.iterator(v);
                        while (it1.hasNext()) {
                            res.addElement(it1.next());
                        }
                    }
                    break;
                }
                ++i;
            }
        } else {
            Vector<Ligne> vo = new Vector<Ligne>();
            while (it.hasNext()) {
                boolean in;
                Obj o = it.next();
                if (o instanceof Ligne && ((Ligne)o).inPolygon(v, (int)x, (int)y)) {
                    vo.addElement((Ligne)o);
                }
                if (!(in = o instanceof Cercle ? o.in(v, x, y) : o.inside(v, x, y)) || o.asSource() && !((Source)o).noFilterInfluence() && !((Source)o).isSelectedInFilter()) continue;
                res.addElement(o);
            }
            for (Ligne o : vo) {
                o = o.getFirstBout();
                while (o != null) {
                    if (!res.contains(o)) {
                        res.addElement(o);
                    }
                    o = o.finligne;
                }
            }
        }
        return res;
    }

    public boolean hasPM() {
        if (!this.flagOk || !this.isCatalog()) {
            return false;
        }
        if (this.hasPM < 0) {
            Vector<Legende> legs = this.getLegende();
            if (legs == null) {
                return false;
            }
            for (Legende leg : legs) {
                if (leg == null || leg.getPmRa() <= 0 || leg.getPmDe() <= 0) continue;
                this.hasPM = 1;
                return true;
            }
            this.hasPM = 0;
            return false;
        }
        return this.hasPM == 1;
    }

    public boolean recomputePosition() {
        boolean rep = false;
        Vector<Legende> legs = this.getLegende();
        if (legs == null) {
            return false;
        }
        for (Legende leg : legs) {
            int npmra = leg.getPmRa();
            int npmde = leg.getPmDe();
            if (npmra <= 0 || npmde <= 0) continue;
            int nra = leg.getRa();
            int nde = leg.getDe();
            this.recomputePosition(this.iterator(), leg, nra, nde, npmra, npmde);
            rep = true;
        }
        if (rep) {
            this.aladin.view.newView(1);
        }
        return rep;
    }

    public void recomputePositionByFrame(Iterator<Obj> it, Legende leg, int nlon, int nlat, int originFrame) {
        int nError = 0;
        Coord c = new Coord();
        while (it.hasNext()) {
            try {
                block6: {
                    Source s = (Source)it.next();
                    if (s.getLeg() != leg) continue;
                    try {
                        c.al = Double.parseDouble(s.getValue(nlon));
                        c.del = Double.parseDouble(s.getValue(nlat));
                        Localisation.frameToFrame(c, originFrame, 0);
                    }
                    catch (Exception e) {
                        c.del = Double.NaN;
                        c.al = Double.NaN;
                        if (++nError <= 100) break block6;
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        Aladin.error("Too many error during coordinate computation !\n" + e.getMessage());
                        break;
                    }
                }
                s.raj = c.al;
                s.dej = c.del;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
    }

    public void recomputeTime(Iterator<Obj> it, Legende leg, int ntime, int timeMode) {
        int nError = 0;
        Coord c = new Coord();
        while (it.hasNext()) {
            try {
                double jdTime;
                block6: {
                    Source s = (Source)it.next();
                    if (s.getLeg() != leg) continue;
                    try {
                        jdTime = Astrodate.parseTime(s.getValue(ntime), timeMode);
                    }
                    catch (Exception e) {
                        jdTime = Double.NaN;
                        if (++nError <= 100) break block6;
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        Aladin.error("Too many error during time computation !\n" + e.getMessage());
                        break;
                    }
                }
                s.jdtime = jdTime;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
    }

    public void recomputePosition(Iterator<Obj> it, Legende leg, int nra, int ndec, int npmra, int npmde) {
        double originalEpoch = this.getOriginalEpoch().getJyr();
        double epoch = this.getEpoch().getJyr();
        int format = 0;
        int nError = 0;
        Astropos c = new Astropos(Astroframe.create("ICRS(" + originalEpoch + ")"));
        while (it.hasNext()) {
            try {
                block13: {
                    Source s = (Source)it.next();
                    if (s.getLeg() != leg) continue;
                    String ra = s.getValue(nra);
                    String dec = s.getValue(ndec);
                    int unit = TableParser.getUnit(s.getUnit(nra));
                    format = TableParser.getRaDec(c, ra, dec, format, unit);
                    if (npmra > 0 && npmde > 0) {
                        try {
                            Unit mu1 = new Unit();
                            try {
                                mu1.setUnit(Util.adjustFoxUnit(s.getUnit(npmra)));
                                mu1.setValue(s.getValue(npmra));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            Unit mu2 = new Unit();
                            try {
                                mu2.setUnit(Util.adjustFoxUnit(s.getUnit(npmde)));
                                mu2.setValue(s.getValue(npmde));
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            if (mu1.getValue() == 0.0 && mu2.getValue() == 0.0) break block13;
                            try {
                                mu1.convertTo(new Unit("mas/yr"));
                            }
                            catch (Exception e) {
                                mu1.setUnit(Util.adjustFoxUnit(s.getUnit(npmra)));
                                mu1.setValue(s.getValue(npmra));
                                mu1.convertTo(new Unit("ms/yr"));
                                double v = 15.0 * mu1.getValue() * Math.cos(c.getLat() * Math.PI / 180.0);
                                mu1 = new Unit(v + "mas/yr");
                            }
                            double pmra = mu1.getValue();
                            mu2.convertTo(new Unit("mas/yr"));
                            double pmde = mu2.getValue();
                            c.set(c.getLon(), c.getLat(), pmra, pmde);
                            c.toEpoch(epoch);
                        }
                        catch (Exception e) {
                            if (++nError <= 100) break block13;
                            if (Aladin.levelTrace >= 3) {
                                e.printStackTrace();
                            }
                            this.aladin.warning("Too many error during proper motion computation !\n" + e.getMessage());
                            break;
                        }
                    }
                }
                s.raj = c.getLon();
                s.dej = c.getLat();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
    }

    protected boolean modifyOriginalEpoch(String origEpoch) {
        Astrotime at = this.getOriginalEpoch();
        try {
            Aladin.trace(3, this.label + " new original epoch: " + this.getOriginalEpoch().getJyr() + " => " + origEpoch);
            this.setOriginalEpoch(origEpoch);
            this.recomputePosition();
            this.aladin.view.newView(1);
            this.aladin.view.repaintAll();
            String s = "New original epoch for " + this.label + "\n=> J" + this.getOriginalEpoch().getJyr();
            Aladin.trace(2, s);
            Aladin.info(this.aladin, s);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.epochOrig = at;
            Aladin.error(this.aladin, "New original epoch error\n=> ignored");
            return false;
        }
        return true;
    }

    public void modifyLonLatField(Legende leg, int nlon, int nlat, int frame) {
        String sFrame = Localisation.getFrameName(frame);
        Aladin.trace(3, this.label + " new " + sFrame + " => LON pos=" + (nlon + 1) + " LAT pos=" + (nlat + 1));
        this.recomputePositionByFrame(this.iterator(), leg, nlon, nlat, frame);
        if (this.hasXYorig || this.hasNoPos) {
            this.hasXYorig = false;
            this.hasNoPos = false;
            this.error = null;
        }
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
        String s = "New " + sFrame + " fields for " + this.label + "\n=> LON column " + (nlon + 1) + " -  LAT column " + (nlat + 1);
        Aladin.trace(2, s);
        Aladin.info(this.aladin, s);
    }

    public void modifyTimeField(Legende leg, int ntime, int timeMode) {
        Aladin.trace(3, this.label + " new epoch field => pos=" + (ntime + 1) + " mode=" + Field.COOSIGN[timeMode]);
        this.recomputeTime(this.iterator(), leg, ntime, timeMode);
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
        String s = "New epoch field for " + this.label + "\n=> column " + (ntime + 1) + " mode=" + Field.COOSIGN[timeMode];
        Aladin.trace(2, s);
        Aladin.info(this.aladin, s);
    }

    public void modifyRaDecField(Legende leg, int nra, int ndec, int npmra, int npmde) {
        Aladin.trace(3, this.label + " new ICRS => RA pos=" + (nra + 1) + " DE pos=" + (ndec + 1) + " PMRA pos=" + (npmra + 1) + " PMDE pos=" + (npmde + 1));
        this.recomputePosition(this.iterator(), leg, nra, ndec, npmra, npmde);
        if (this.hasNoReduction()) {
            this.pcat.createDefaultProj();
        }
        if (this.hasXYorig || this.hasNoPos) {
            this.hasXYorig = false;
            this.hasNoPos = false;
            this.error = null;
        }
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
        String s = "New ICRS fields for " + this.label + "\n=> RA column " + (nra + 1) + " -  DE column " + (ndec + 1) + (npmra > 0 ? " -  PMRA column " + (npmra + 1) : "") + (npmde > 0 ? " -  PMDEC column " + (npmde + 1) : "");
        Aladin.trace(2, s);
        Aladin.info(this.aladin, s);
    }

    public void modifyXYField(Legende leg, int nx, int ny) {
        Aladin.trace(3, this.label + " new XY coordinate fields => X pos=" + (nx + 1) + " Y pos=" + (ny + 1));
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            try {
                Source s = (Source)it.next();
                if (s.getLeg() != leg) continue;
                s.x = Double.parseDouble(s.getValue(nx));
                s.y = Double.parseDouble(s.getValue(ny));
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
        if (!this.hasXYorig) {
            this.hasNoPos = false;
            this.hasXYorig = true;
            this.error = NOREDUCTION;
        }
        this.aladin.view.newView(1);
        this.aladin.view.repaintAll();
        Aladin.info(this.aladin, "New XY fields for " + this.label + "\n=> X column " + (nx + 1) + " -  Y column " + (ny + 1));
    }

    protected void memoInfoZoom(ViewSimple v) {
        this.lastZoomView = v.zoom;
        this.lastXZoomView = v.xzoomView;
        this.lastYZoomView = v.yzoomView;
    }

    protected boolean initInfoZoom(ViewSimple v) {
        if (this.lastZoomView == 0.0) {
            return false;
        }
        v.zoom = this.lastZoomView;
        v.xzoomView = this.lastXZoomView;
        v.yzoomView = this.lastYZoomView;
        return true;
    }

    protected boolean theSame(int type, String objet, String param) {
        return this.theSame(type, objet, param, null);
    }

    protected boolean theSame(int type, String objet, String param, String other) {
        if (type != this.type) {
            return false;
        }
        if (!this.egale(this.objet, objet)) {
            return false;
        }
        if (!this.egale(this.param, param)) {
            return false;
        }
        if (other != null) {
            String s = "";
            switch (type) {
                case 1: 
                case 15: {
                    PlanImage p = (PlanImage)this;
                    s = p.fmt + "/" + p.res;
                }
            }
            if (!other.equals(s)) {
                return false;
            }
        }
        return true;
    }

    private boolean egale(String s, String t) {
        if (s == t) {
            return true;
        }
        return s == null && t == null || s != null && t != null && s.equals(t);
    }

    protected boolean equals(Plan p) {
        if (!this.theSame(p.type, p.objet, p.param)) {
            return false;
        }
        if (this instanceof PlanImage && p instanceof PlanImage && !PlanImage.sameFmtRes(this, p)) {
            return false;
        }
        if (this.error == null && p.error != null || this.error != null && p.error == null) {
            return false;
        }
        if (this.error != null && p.error != null && !this.error.equals(p.error)) {
            return false;
        }
        if (this.flagOk != p.flagOk) {
            return false;
        }
        return this.projd == p.projd;
    }

    protected double getPourcent() {
        return this.pourcent;
    }

    protected void setPourcent(double x) {
        this.pourcent = x;
    }

    protected static String throughput(double deb) {
        String u = "B";
        if (deb > 1024.0) {
            deb /= 1024.0;
            u = "KB";
        }
        if (deb > 1024.0) {
            deb /= 1024.0;
            u = "MB";
        }
        return Util.myRound(deb + "", 2) + " " + u + "/s";
    }

    protected void sendLog(String id, String s) {
        s = s.replace('\n', ' ');
        s = s.replace('\r', ' ');
        if (this.log) {
            this.aladin.log(id, s);
        }
    }

    void setLogMode(boolean mode) {
        this.log = mode;
    }

    protected boolean Free(boolean askInterrupt) {
        return this.freePlan();
    }

    protected boolean freePlan() {
        this.setLogMode(false);
        if (this.planFilter != null) {
            this.planFilter.freePlan();
        }
        try {
            if (this.dis != null && (this.server == null || this.server != this.aladin.dialog.server[ServerDialog.ALADIN])) {
                this.dis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.aladin.dialog != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.dialog.resume();
                }
            });
        }
        if (this.aladin.grabUtilInstance != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.grabUtilInstance.resetAllGrabIts(Plan.this.aladin);
                }
            });
        }
        final Plan[] param1 = new Plan[]{this};
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Properties.disposeProperties(param1[0]);
            }
        });
        if (this.aladin.frameCM != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.frameCM.disposeFrameCM(param1[0]);
                }
            });
        }
        if (this.aladin.frameNewCalib != null && this.aladin.frameNewCalib.plan == this) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Plan.this.aladin.frameNewCalib.hide();
                }
            });
        }
        if (this.pcat != null) {
            this.pcat.free();
        }
        if (this.headerFits != null) {
            this.headerFits.free();
        }
        this.init();
        return true;
    }

    protected void init() {
        this.type = 0;
        this.hasPM = -1;
        this.flagOk = false;
        this.isOldPlan = false;
        this.flagWaitTarget = false;
        this.hasSpecificCalib = false;
        this.copyrightUrl = null;
        this.copyright = null;
        this.ack = null;
        this.verboseDescr = null;
        this.description = null;
        this.param = null;
        this.label = null;
        this.error = null;
        this.objet = null;
        this.body = null;
        this.flagSkip = false;
        this.co = null;
        this.projInit = null;
        this.projd = null;
        this.projD = null;
        this.pcat = null;
        this.headerFits = null;
        this.hasNoPos = false;
        this.recalibrating = false;
        this.underMouse = false;
        this.hasXYorig = false;
        this.ref = false;
        this.active = false;
        this.selected = false;
        this.flagOk = false;
        this.collapse = false;
        this.memoClinDoeil = false;
        this.resetProj();
        this.folder = 0;
        this.initZoom = 1.0;
        this.filename = null;
        this.dis = null;
        this.server = null;
        this.filters = null;
        this.slide = null;
    }

    protected void setXYorig(boolean lock) {
        this.hasXYorig = lock;
    }

    protected boolean hasXYorig() {
        return this.hasXYorig;
    }

    protected void setXYorig() {
        Aladin.trace(3, "create original XY from RA,DEC for plane " + this);
        Iterator<Obj> it = this.pcat.iterator();
        while (it.hasNext()) {
            ((Position)it.next()).setXY(this.projd);
        }
        this.hasXYorig = true;
    }

    protected String getFilterDescription() {
        if (this.filterIndex < 0 || this.filters == null) {
            return "no dedicated filter";
        }
        return Server.getFilterDescription(this.filters[this.filterIndex]);
    }

    protected PlanFilter getFilter() {
        return this.planFilter;
    }

    protected void setFilter(String s) {
        if (this.filters == null) {
            return;
        }
        int i = this.findFilter(s);
        this.setFilter(i);
    }

    protected int findFilter(String s) {
        if (this.filters == null) {
            return -1;
        }
        for (int i = 0; i < this.filters.length; ++i) {
            String fs = Server.getFilterDescription(this.filters[i]);
            if (fs != null && Util.indexOfIgnoreCase(fs, s) >= 0) {
                return i;
            }
            fs = Server.getFilterName(this.filters[i]);
            if (fs == null || Util.indexOfIgnoreCase(fs, s) < 0) continue;
            return i;
        }
        return -1;
    }

    protected void addFilter(String filter) {
        int i = this.findFilter(filter);
        if (i >= 0) {
            this.filters[i] = filter;
            Aladin.trace(4, "Plan.addFilter(): replace:" + Server.getFilterName(filter));
        } else {
            String[] tmp;
            if (this.filters == null) {
                tmp = new String[1];
            } else {
                tmp = new String[this.filters.length + 1];
                System.arraycopy(this.filters, 0, tmp, 0, this.filters.length);
            }
            tmp[tmp.length - 1] = filter;
            this.filters = tmp;
            Aladin.trace(4, "Plan.addFilter(): add:" + Server.getFilterName(filter));
        }
        if (this.filterIndex == -1) {
            this.filterIndex = this.aladin.configuration.getFilter();
        }
    }

    protected void setFilter(int n) {
        if (this.filters == null) {
            return;
        }
        this.filterIndex = n;
        if (n < 0) {
            this.planFilter = null;
            PlanFilter.updateAllFilters(this.aladin);
            this.aladin.calque.repaintAll();
            return;
        }
        String name = Server.getFilterName(this.filters[n]);
        String script = Server.getFilterScript(this.filters[n]);
        if (this.planFilter == null) {
            this.planFilter = new PlanFilter(this.aladin, name, script, this);
            PlanFilter.updateAllFilters(this.aladin);
            this.planFilter.applyFilter();
        } else {
            this.planFilter.updateDefinition(script, name, null);
        }
    }

    protected void updateDedicatedFilter() {
        if (this.planFilter == null) {
            return;
        }
        PlanFilter.updateAllFilters(this.aladin);
        PlanFilter.updateNow();
    }

    protected void toGenericalFilter() {
        if (this.filterIndex < 0) {
            return;
        }
        int i = this.filterIndex;
        this.setFilter(-1);
        PlanFilter p = this.aladin.command.createFilter(Server.getFilter(this.filters[i]));
        if (p != null) {
            Properties.createProperties(p);
        }
    }

    protected boolean hasDedicatedFilter() {
        return this.filterIndex >= 0;
    }

    protected void getXYRange(double[] m) {
        m[2] = Double.POSITIVE_INFINITY;
        m[0] = Double.POSITIVE_INFINITY;
        m[3] = Double.NEGATIVE_INFINITY;
        m[1] = Double.NEGATIVE_INFINITY;
        Iterator<Obj> it = this.pcat.iterator();
        while (it.hasNext()) {
            Position a = (Position)it.next();
            if (a.x < m[0]) {
                m[0] = a.x;
            }
            if (a.x > m[1]) {
                m[1] = a.x;
            }
            if (a.y < m[2]) {
                m[2] = a.y;
            }
            if (!(a.y > m[3])) continue;
            m[3] = a.y;
        }
    }

    protected void modifyProj(String projName) {
        int t = Projection.getProjType(projName);
        Projection p = this.projd;
        if (p == null || t == -1) {
            return;
        }
        this.modifyProj(null, 3, p.alphai, p.deltai, p.rm1, p.cx, p.cy, p.r1, p.rot, p.sym, t, p.system);
        this.aladin.view.newView(1);
        this.aladin.calque.repaintAll();
    }

    protected void modifyProj(String label, int modeCalib, double alphai, double deltai, double rm, double cx, double cy, double r, double rot, boolean sym, int t, int system) {
        this.projd.modify(label, modeCalib, alphai, deltai, rm, rm, cx, cy, r, r, rot, sym, t, system);
        this.syncProjLocal();
    }

    protected void syncProjLocal() {
    }

    protected void resetProj(int n) {
        this.proj[n] = null;
    }

    protected void resetProj() {
        for (int i = 0; i < 16; ++i) {
            this.resetProj(i);
        }
    }

    protected void setHasSpecificCalib() {
        this.hasSpecificCalib = true;
    }

    protected boolean hasSpecificCalib() {
        return this.hasSpecificCalib;
    }

    protected boolean hasSpecificProj() {
        return false;
    }

    protected void setNewProjD(Projection p) {
        if (this.projD == null) {
            this.projD = new Hashtable();
            this.projInit = p;
        }
        this.projD.put(p.label, p);
        this.projd = p;
        if (this.error != null && this.hasNoReduction()) {
            this.error = null;
        }
    }

    protected Plan[] getAvailablePlanRef() {
        Vector<Plan> v = new Vector<Plan>();
        if (this.isImage() || this instanceof PlanHips) {
            v.addElement(this);
        } else {
            Plan[] allPlan = this.aladin.calque.getPlans();
            for (int i = 0; i < allPlan.length; ++i) {
                Plan p = allPlan[i];
                if (!p.isImage() && !p.isCatalog() || !this.aladin.calque.canBeRef(p) || !p.flagOk || !Projection.isOk(this.projd) || !this.projd.agree(p.projd, null)) continue;
                v.addElement(p);
            }
        }
        int n = v.size();
        Plan[] pRef = new Plan[n];
        Enumeration e = v.elements();
        for (int i = 0; i < n; ++i) {
            pRef[i] = (Plan)e.nextElement();
        }
        return pRef;
    }

    protected Projection[] getAvailableProj() {
        Enumeration<Object> e;
        Vector<Projection> v = new Vector<Projection>();
        if (this.projD != null) {
            e = this.projD.keys();
            while (e.hasMoreElements()) {
                Projection p = (Projection)this.projD.get(e.nextElement());
                v.addElement(p);
            }
        }
        int n = v.size();
        Projection[] projs = new Projection[n];
        e = v.elements();
        for (int i = 0; i < n; ++i) {
            projs[i] = (Projection)e.nextElement();
        }
        return projs;
    }

    protected boolean isRefForVisibleView() {
        block4: {
            try {
                if (this.isPixel()) {
                    for (int i = this.aladin.view.getNbView() - 1; i >= 0; --i) {
                        ViewSimple v = this.aladin.view.viewSimple[i];
                        if (v.pref != this) continue;
                        this.setDebugFlag(1, true);
                        return true;
                    }
                }
                this.setDebugFlag(1, false);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    protected boolean hasCanBeTranspState() {
        return (this.debugFlag & 2) == 2;
    }

    protected boolean isUnderImg() {
        return (this.debugFlag & 0x1800) != 0;
    }

    protected boolean isUnderImgBkgd() {
        return (this.debugFlag & 0x1000) != 0;
    }

    protected void setHasCheckBox(boolean flag) {
        this.hasCheckBox = flag;
    }

    protected boolean hasCheckBox() {
        return this.hasCheckBox;
    }

    protected void setDebugFlag(int type, boolean flag) {
        this.debugFlag = flag ? (this.debugFlag |= type) : (this.debugFlag &= ~type);
    }

    protected String getDebugFlag() {
        int mask = 1;
        StringBuffer rep = new StringBuffer();
        this.setDebugFlag(16, this.active);
        this.setDebugFlag(32, this.askActive);
        this.setDebugFlag(64, this.ref);
        this.setDebugFlag(128, this.flagOk);
        this.setDebugFlag(256, this.flagProcessing);
        this.setDebugFlag(512, this.flagUpdating);
        this.setDebugFlag(1024, this.selected);
        for (int i = 1; i < 32; ++i) {
            if ((mask & this.debugFlag) == mask) {
                if (rep.length() > 0) {
                    rep.append(", ");
                }
                rep.append(DEBUGFLAG[i]);
            }
            mask <<= 1;
        }
        return rep.toString();
    }

    protected boolean isViewable() {
        if (this.hasNoPos || this.hasXYorig || this.isSED()) {
            this.setDebugFlag(8, true);
            return true;
        }
        if (this.type == 0 || this.type == 14 || !this.flagOk) {
            this.setDebugFlag(8, false);
            return false;
        }
        if (!(this.isCatalog() || this.isPlanBGOverlay() || this.isImage() || this.type == 16)) {
            this.setDebugFlag(8, true);
            return true;
        }
        for (int i = this.aladin.view.getNbView() - 1; i >= 0; --i) {
            ViewSimple v = this.aladin.view.viewSimple[i];
            if (v.isFree()) continue;
            if (this.projd == null) {
                if (v.pref != this) continue;
                this.setDebugFlag(8, true);
                return true;
            }
            if (!this.isCompatibleWith(v)) continue;
            this.setDebugFlag(8, true);
            return true;
        }
        this.setDebugFlag(8, false);
        return false;
    }

    protected boolean shouldHaveARefCheckBox() {
        if (!this.isReady()) {
            return false;
        }
        boolean isImage = this.isImage();
        boolean isCatalog = this.isSimpleCatalog();
        boolean isImgBg = this.type == 16;
        boolean isMoc = this.isMoc();
        boolean isCatBg = this.isPlanBGOverlay();
        if (this.ref && !isMoc) {
            return true;
        }
        boolean rep = isCatalog;
        int n = this.aladin.calque.getIndex(this);
        Plan[] p = this.aladin.calque.getPlans();
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].isReady() || p[i] == this) continue;
            if (isImage && (p[i].isSimpleCatalog() && !this.isCompatibleWith(p[i]) || p[i].isImage() || p[i].type == 16)) {
                return true;
            }
            if (isMoc) {
                return false;
            }
            if (isCatalog || isMoc) {
                if (p[i].isImage() && this.isCompatibleWith(p[i]) || p[i] instanceof PlanHips) {
                    return false;
                }
                if (p[i].isSimpleCatalog() && this.isCompatibleWith(p[i]) && i > n) {
                    return false;
                }
            }
            if (!isImgBg || !p[i].isImage() && p[i].type != 16) continue;
            return true;
        }
        return rep;
    }

    protected boolean contains(Coord c) {
        return false;
    }

    protected boolean setExtName() {
        block6: {
            try {
                String s;
                if (this.headerFits == null) break block6;
                try {
                    s = this.headerFits.getStringFromHeader("HDUNAME");
                }
                catch (Exception e) {
                    s = this.headerFits.getStringFromHeader("EXTNAME");
                }
                s = s.trim();
                if (s.length() != 0) {
                    int pos = this.label.lastIndexOf(91);
                    if (pos >= 0) {
                        s = s + this.label.substring(pos);
                    }
                    this.setLabel(s);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected void setFieldOrder() {
        for (Legende leg : this.getLegende()) {
            leg.setDefaultFieldOrder();
        }
    }

    protected boolean isSync() {
        return true;
    }

    protected boolean isCompatibleWith(Plan p) {
        return Projection.isOk(p.projd) && p.projd.agree(this.projd, this.aladin.view.getCurrentView());
    }

    protected boolean isCompatibleWith(ViewSimple v) {
        if (v.isFree() || !Projection.isOk(v.getProj())) {
            return false;
        }
        if (v.pref == this) {
            this.setUnderBackGroundFlag(v);
            return true;
        }
        if (v.getProj().isUncompatibleBody(this.projd)) {
            this.setDebugFlag(8192, true);
            return false;
        }
        this.setDebugFlag(8192, false);
        if (!(this.aladin.view.isMultiView() && v.pref.ref || !v.pref.isImage() || this.type != 1 || this.aladin.calque.getIndex(this) <= this.aladin.calque.getIndex(v.pref))) {
            this.setDebugFlag(2048, true);
            return false;
        }
        this.setDebugFlag(2048, false);
        if (!this.setUnderBackGroundFlag(v)) {
            return false;
        }
        boolean rep = this.isOutView(v);
        return !rep;
    }

    private boolean setUnderBackGroundFlag(ViewSimple v) {
        boolean under = false;
        this.setDebugFlag(4096, under);
        return !under;
    }

    protected boolean isOutView(ViewSimple v) {
        int w = v.getWidth();
        int h = v.getHeight();
        if (this instanceof PlanHips) {
            this.setDebugFlag(4, false);
            return false;
        }
        if (this.isImage()) {
            double maxY;
            double maxX;
            PointD[] b = ((PlanImage)this).getBords(v);
            if (b == null) {
                return true;
            }
            double minX = maxX = b[0].x;
            double minY = maxY = b[0].y;
            for (int i = 1; i < 4; ++i) {
                if (b[i].x < minX) {
                    minX = b[i].x;
                } else if (b[i].x > maxX) {
                    maxX = b[i].x;
                }
                if (b[i].y < minY) {
                    minY = b[i].y;
                    continue;
                }
                if (!(b[i].y > maxY)) continue;
                maxY = b[i].y;
            }
            if (minX < 0.0 && maxX < 0.0 || minX >= (double)w && maxX >= (double)w || minY < 0.0 && maxY < 0.0 || minY >= (double)h && maxY >= (double)h) {
                this.setDebugFlag(4, true);
                return true;
            }
            this.setDebugFlag(4, false);
            return false;
        }
        boolean rep = !v.getProj().agree(this.projd, this.aladin.view.getCurrentView(), false);
        this.setDebugFlag(4, rep);
        return rep;
    }

    protected String getProgress() {
        if (this.type != 0 && !this.flagOk && this.error == null) {
            return " - in progress...";
        }
        return "";
    }

    protected String getInfo() {
        return this.getInfo(false);
    }

    protected String getInfo(boolean full) {
        try {
            String s = null;
            if (this.type == 0) {
                s = "";
            } else if (this.error != null) {
                s = this.label + " *** " + this.error;
            } else {
                String from = this.getFrom();
                String progress = this.getProgress();
                if (progress.length() > 0) {
                    s = this.label + progress;
                } else if (Aladin.levelTrace >= 3) {
                    try {
                        if (this.isCatalog()) {
                            s = this.label + " - " + this.getStats();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (s == null) {
                    s = this.label;
                }
                if (full && s != null) {
                    s = s + (this.objet != null ? "\nAround " + this.objet : "");
                    s = s + (from != null ? "\n" + from : "");
                }
                int n = this.aladin.calque.plan.length - this.aladin.calque.getIndex(this);
                s = "[Plane @" + n + "] - " + s;
            }
            s = s + this.addDebugInfo();
            return s;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getCoverageTime(String s1, String s2) {
        if (s2 == null) {
            s2 = s1;
        }
        if (s1 == null) {
            return null;
        }
        if (s1.equals(s2)) {
            return Util.getDateFromMJD(s1);
        }
        String y1 = Util.getDateFromMJD(s1);
        String y2 = Util.getDateFromMJD(s2);
        return Plan.Y1(y1, y2) + " .. " + Plan.Y2(y1, y2);
    }

    private static String Y1(String y1, String y2) {
        String a2;
        String a1;
        if (y1.endsWith("-01-01") && !(a1 = y1.substring(0, 4)).equals(a2 = y2.substring(0, 4))) {
            return a1;
        }
        return y1;
    }

    private static String Y2(String y1, String y2) {
        try {
            if (y2.endsWith("-12-31")) {
                String a1 = y1.substring(0, 4);
                String a2 = y2.substring(0, 4);
                if (!a2.equals(a1)) {
                    return a2;
                }
            }
            if (y2.endsWith("-01-01")) {
                return "" + (Integer.parseInt(y2.substring(0, 4)) - 1);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return y2;
    }

    public static String getCoverageEnergy(String s1, String s2) {
        if (s2 == null) {
            s2 = s1;
        }
        if (s1 == null) {
            return null;
        }
        boolean flagFreq = true;
        boolean flagWave = true;
        try {
            double c = Double.parseDouble(s1);
            flagWave = c > 1.0E-10;
        }
        catch (Exception e) {
            if (s1.equals(s2)) {
                return s1 + "m";
            }
            return s1 + "m .. " + s2 + "m";
        }
        if (s1.equals(s2)) {
            return (flagWave ? Util.getWaveFromMeter(s1) : "") + (flagFreq && flagWave ? "/" : "") + (flagFreq ? Util.getFreqFromMeter(s1) : "");
        }
        return (flagWave ? Util.getWaveFromMeter(s1) : "") + (flagFreq && flagWave ? "/" : "") + (flagFreq ? Util.getFreqFromMeter(s1) : "") + " .. " + (flagWave ? Util.getWaveFromMeter(s2) : "") + (flagFreq && flagWave ? "/" : "") + (flagFreq ? Util.getFreqFromMeter(s2) : "");
    }

    public static String getCoverageSpace(String s) {
        try {
            double cov = Double.parseDouble(s);
            if (cov < 0.1) {
                double degrad = Math.toDegrees(1.0);
                double skyArea = Math.PI * 4 * degrad * degrad;
                return Coord.getUnit(skyArea * cov, false, true) + "\u00b2";
            }
            s = "" + Util.round(cov * 100.0, 3);
            if (s.equals("100.0")) {
                s = "100";
            }
            return s + "%";
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getMessageInfo() {
        String s;
        if (this.hasError()) {
            return "!!Error:\n \n" + this.error;
        }
        MyProperties prop = this.aladin.directory.getProperties(this.id);
        String string = s = prop == null ? null : prop.getFirst("obs_collection_label");
        if (s == null) {
            s = this.label;
        }
        StringBuilder buf = new StringBuilder(s + "\n ");
        if (prop != null) {
            String s1;
            s = prop.get("obs_regime");
            if (s != null) {
                Plan.ADD(buf, "\n* Regime: ", s.replace("\t", ", "));
            }
            if ((s = prop.get("em_min")) != null && (s1 = prop.get("em_max")) != null) {
                Plan.ADD(buf, "\n* Energy: ", Plan.getCoverageEnergy(s, s1));
            }
            if ((s = prop.get("t_min")) != null && (s1 = prop.get("t_max")) != null) {
                Plan.ADD(buf, "\n* Time: ", Plan.getCoverageTime(s, s1));
            }
            if ((s = prop.get("prov_progenitor")) != null) {
                Plan.ADD(buf, "\n* Provenance: ", s.replace("\t", ", "));
            }
        } else if (this.filename == null) {
            Plan.ADD(buf, "\n* Provenance: ", this.copyright);
        }
        if (this.aladin.configuration.isPlanet()) {
            String body = this.getBody();
            if (body == null) {
                body = "unknown";
            }
            if (!BODYSKY.equals(body)) {
                Plan.ADD(buf, "\n* Body: ", body);
            }
        }
        if (this.error != null) {
            Plan.ADD(buf, "\n* !!", this.error);
        }
        this.addMessageInfo(buf, prop);
        if (prop != null) {
            s = prop.getFirst("obs_title");
            if (s == null) {
                s = prop.getFirst("obs_collection");
            }
        } else {
            s = this.description;
        }
        if (s != null) {
            Plan.ADD(buf, "\n \n", s);
        }
        return buf.toString();
    }

    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
    }

    protected static void ADD(StringBuilder buf, String prefix, String s) {
        if (s == null) {
            return;
        }
        if (prefix != null) {
            buf.append(prefix);
        }
        buf.append(s);
    }

    protected String addDebugInfo() {
        String a;
        if (Aladin.levelTrace < 2) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        if (this.active) {
            if (this.statNbComputing != 0L) {
                s.append("\n - " + this.statNbComputing + " projection" + (this.statNbComputing > 1L ? "s" : "") + " computed");
                s.append("\n - last proj computed in " + this.statTimeComputing + "ms");
            }
            if (this.statNbItems != 0L) {
                s.append("\n - " + this.statNbItems + " object" + (this.statNbItems > 1L ? "s" : "") + " drawn (" + this.statTimeDisplay + "ms)");
            } else {
                s.append("\n - drawn in " + this.statTimeDisplay + "ms");
            }
        }
        if ((a = this.getDebugFlag()).length() > 0) {
            s.append("\n[" + a + "]");
        }
        return s.toString();
    }

    public String getLabel() {
        return this.getLabel(false);
    }

    protected String getLabel(boolean flagShort) {
        String s = flagShort ? this.getShortLabel() : this.label;
        return s;
    }

    protected String getShortLabel() {
        String s;
        if (this.id == null) {
            return this.label;
        }
        int i = this.label.lastIndexOf(126);
        String string = s = i > 0 ? this.label.substring(0, i) : this.label;
        if (!this.id.equals(s)) {
            return this.label;
        }
        String type = Util.getSubpath(this.label, 1);
        if (type == null) {
            return this.label;
        }
        if (type.equals("P") || type.equals("C")) {
            return Util.getSubpath(this.label, 2, -1).replace('/', ' ');
        }
        return Util.getSubpath(this.label, 1, -1).replace('/', ' ');
    }

    protected String getBody() {
        return this.body;
    }

    protected void setBody(String body) {
        this.body = body;
    }

    protected String getFrameLabel(int frame) {
        return this.label;
    }

    protected double getCompletude() {
        return -1.0;
    }

    protected String getUrl() {
        return this.u == null ? null : this.u.toString();
    }

    public ArrayList<String> getMirrorsUrl() {
        return null;
    }

    protected boolean hasRemoteUrl() {
        return this.u != null && !this.u.toString().startsWith("file:");
    }

    public float getOpacityLevel() {
        return this.opacityLevel;
    }

    public void setOpacityLevel(float opacityLevel) {
        if (opacityLevel < 0.0f) {
            opacityLevel = 0.0f;
        }
        if (opacityLevel > 1.0f) {
            opacityLevel = 1.0f;
        }
        this.opacityLevel = opacityLevel;
    }

    protected String getLastPlasticID() {
        if (this.plasticIDs != null && this.plasticIDs.size() > 0) {
            return this.plasticIDs.get(this.plasticIDs.size() - 1);
        }
        return this.getUrl();
    }

    protected String getPlasticID() {
        if (this.plasticIDs != null && this.plasticIDs.size() > 0) {
            return this.plasticIDs.get(0);
        }
        return this.getUrl();
    }

    protected boolean hasPlasticID(String id) {
        Object url;
        String str;
        if (id == null) {
            return false;
        }
        try {
            if (!id.startsWith("file")) {
                str = id;
            } else {
                url = new URL(id);
                str = ((URL)url).getFile();
            }
        }
        catch (MalformedURLException mue) {
            str = id;
        }
        if (this.plasticIDs != null) {
            Enumeration<String> enumID = this.plasticIDs.elements();
            while (enumID.hasMoreElements()) {
                String tmp = enumID.nextElement();
                if (tmp.startsWith("file")) {
                    try {
                        URL url2 = new URL(tmp);
                        tmp = url2.getFile();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (!str.equals(tmp)) continue;
                return true;
            }
        }
        return (url = this.getUrl()) != null && id.equals(url);
    }

    protected void addPlasticID(String id) {
        if (id == null) {
            return;
        }
        if (this.plasticIDs == null) {
            this.plasticIDs = new Vector();
        }
        if (this.plasticIDs.indexOf(id) < 0) {
            this.plasticIDs.addElement(id);
        }
    }

    protected void setLabel(String label) {
        String x = this.getUniqueLabel(label);
        if (x == null) {
            return;
        }
        this.label = x;
    }

    protected String getUniqueLabel(String label) {
        char[] a = label.toCharArray();
        if (a.length > 0 && a[0] == '=') {
            if (a[1] != '@') {
                this.label = label.substring(1);
            }
            this.isOldPlan = true;
            return null;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != '\n') continue;
            a[i] = 32;
        }
        String s = new String(a);
        String x = s;
        if (this.isExistingLabel(x, false)) {
            int j = s.indexOf(126);
            if (j > 0) {
                s = s.substring(0, j);
            }
            x = s;
            int n = 1;
            while (this.isExistingLabel(x, false)) {
                x = s + "~" + n++;
            }
        }
        return x;
    }

    protected boolean isExistingLabel(String s, boolean withTestView) {
        if (s.trim().length() == 0) {
            return true;
        }
        if (withTestView) {
            if (this.aladin.view.getNViewFromID(s) >= 0) {
                return true;
            }
            if (s.equals("ROI")) {
                return true;
            }
            if (s.equals("all")) {
                return true;
            }
        }
        Plan[] allPlan = this.aladin.calque.getPlans();
        for (int i = 0; i < allPlan.length; ++i) {
            Plan p = allPlan[i];
            if (p == this || p == null || p.label == null || !s.equals(p.label)) continue;
            return true;
        }
        return false;
    }

    protected String getFrom() {
        if (this.copyright == null) {
            return null;
        }
        int n = this.copyright.length();
        if (n > 40) {
            int end = this.copyright.lastIndexOf(Util.FS, this.copyright.length() - 15);
            int first = this.copyright.indexOf(Util.FS, 4);
            if (end != -1 && first != -1 && first < end) {
                return this.copyright.substring(0, first + 1) + "..." + this.copyright.substring(end);
            }
            return this.copyright.substring(0, 40) + "...";
        }
        return this.copyright;
    }

    protected void setFrom(String from) {
        this.copyright = from;
    }

    protected String getLogInfo() {
        return (this.objet == null ? "null" : this.objet) + "/" + (this.param == null ? "null" : this.param);
    }

    protected String getTargetQuery() {
        if (this.objet != null) {
            return this.objet;
        }
        if (this.co != null) {
            return this.co.getSexa();
        }
        return "";
    }

    protected String getTarget() {
        if (this.co == null) {
            return null;
        }
        return this.co.getSexa(":");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        if (prop.equalsIgnoreCase("PlaneID")) {
            if (this.isExistingLabel(value, false)) {
                throw new Exception("PlaneID already existing");
            }
            this.setLabel(value);
        } else if (prop.equalsIgnoreCase("proj") || prop.equalsIgnoreCase("projection")) {
            this.modifyProj(value);
            this.aladin.projSelector.setProjection(value);
        } else if (prop.equalsIgnoreCase("epoch")) {
            if (!this.isCatalog()) {
                throw new Exception("Epoch can be modified only for catalog planes");
            }
            if (!this.hasPM()) {
                throw new Exception("Unknown proper motion fields");
            }
            this.setEpoch(value);
            this.aladin.calque.repaintAll();
        } else if (prop.equalsIgnoreCase("info")) {
            this.verboseDescr = value;
        } else if (prop.equalsIgnoreCase("ack")) {
            this.ack = value;
        } else if (prop.equalsIgnoreCase("Color")) {
            Color c = Action.getColor(value);
            if (c == null) {
                throw new Exception("Syntax error in color function (ex: rgb(30,60,255) )");
            }
            this.c = c;
            this.aladin.calque.repaintAll();
        } else if (prop.equalsIgnoreCase("Status")) {
            if (value.indexOf("shown") >= 0) {
                this.setActivated(true);
            } else {
                if (value.indexOf("hidden") < 0) throw new Exception("Status unknown");
                this.setActivated(false);
            }
        } else if (prop.equalsIgnoreCase("Background")) {
            Color c;
            this.colorBackground = c = value.equalsIgnoreCase("white") ? Color.white : (value.equalsIgnoreCase("black") ? Color.black : null);
            this.aladin.calque.repaintAll();
        } else if (prop.equalsIgnoreCase("Opacity")) {
            float f;
            if (!this.aladin.calque.canBeTransparent(this)) {
                throw new Exception("opacity property only applicable for images and footprints !");
            }
            try {
                f = Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                throw new Exception(value + " is not a valid value for opacity level !");
            }
            if (f > 100.0f || f < 0.0f) {
                throw new Exception("Opacity value must be between 0 and 100 !");
            }
            this.setOpacityLevel(f / 100.0f);
            this.aladin.calque.repaintAll();
        } else if (prop.equalsIgnoreCase("scalingFactor") || prop.equalsIgnoreCase("size")) {
            float n;
            try {
                n = Float.parseFloat(value);
                if (n <= 0.0f) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception(value + " is not a valid value for scalingFactor ]0..5] !");
            }
            this.setScalingFactor(n);
            this.aladin.calque.repaintAll();
        } else {
            if (!prop.startsWith("FITS:")) throw new Exception("Unknown plane propertie [" + prop + "]");
            prop = prop.substring(5);
            if (this.headerFits == null) {
                this.headerFits = new FrameHeaderFits(this, prop + "=" + value);
            } else {
                if (value.length() == 0) {
                    value = null;
                }
                this.headerFits.setToHeader(prop, value);
            }
            try {
                this.setNewProjD(new Projection(2, new Calib(this.headerFits.getHeaderFits()), this));
                this.setHasSpecificCalib();
                this.aladin.command.console("Astrometrical calibration has been modified on " + this.label);
                this.aladin.view.newView();
                this.aladin.view.repaintAll();
            }
            catch (Exception exception) {}
        }
        Properties.majProp(this);
    }

    protected void startCheckBoxBlink() {
        this.startCheckBoxBlink = System.currentTimeMillis();
    }

    protected boolean isCheckBoxBlink() {
        long t = System.currentTimeMillis();
        return t - this.startCheckBoxBlink < 4000L;
    }

    protected boolean redoConeSearch() {
        return false;
    }

    protected boolean isRedoable() {
        return false;
    }

    protected boolean setActivated(boolean flag) {
        this.askActive = flag;
        return this.setActivated();
    }

    protected boolean setActivated() {
        Source sEtalon;
        boolean flag = this.askActive;
        if (this.askActive && !this.isViewable()) {
            flag = false;
        }
        if (this.active == flag) {
            return this.active;
        }
        this.active = flag;
        if (!this.active) {
            this.aladin.view.deSelect(this);
        } else if (!this.hasNoPos) {
            this.aladin.view.addTaggedSource(this);
        }
        if (this.isCatalog() && this.active) {
            PlanFilter.updatePlan(this);
        }
        if (this.active && this.isSED() && (sEtalon = this.aladin.view.addSEDSource(this)) != null) {
            this.aladin.view.zoomview.setSED(sEtalon);
        }
        return this.active;
    }

    public synchronized void stop() {
        this.runme = null;
    }

    protected void draw(Graphics g, ViewSimple v, int dx, int dy, float op) {
    }

    protected boolean waitForPlan() {
        return false;
    }

    protected synchronized void addPlaneLoadListener(PlaneLoadListener listener) {
        this.listeners.add(listener);
    }

    protected synchronized boolean removeListener(PlaneLoadListener listener) {
        return this.listeners.remove(listener);
    }

    protected boolean isThisListening(PlaneLoadListener listener) {
        return this.listeners.contains(listener);
    }

    protected void callAllListeners(PlaneLoadEvent ple) {
        Enumeration eListeners = this.listeners.elements();
        while (eListeners.hasMoreElements()) {
            ((PlaneLoadListener)eListeners.nextElement()).planeLoaded(ple);
        }
    }

    protected static void aladinQueryThread(Thread t) {
        t.setName(ALADINQUERY);
    }

    protected void threading() {
        Thread th = Thread.currentThread();
        if (th.getName().equals(ALADINQUERY)) {
            this.run();
        } else {
            this.runme = new Thread((Runnable)this, "AladinQueryBis");
            Util.decreasePriority(th, this.runme);
            Plan.aladinQueryThread(this.runme);
            this.aladin.console.memoThreadId(-2L);
            this.runme.start();
        }
    }

    @Override
    public void run() {
        boolean rep;
        block4: {
            this.aladin.console.memoThreadId(Thread.currentThread().getId());
            Aladin.trace(1, (this.flagSkip ? "Skipping" : "Creating") + " the " + TYPE[this.type] + " plane " + this.label);
            if (this.server != null && this.server.ifTapIsCurrentRequest(this.requestId)) {
                this.server.setStatus();
            }
            rep = true;
            try {
                rep = this.waitForPlan();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        this.planReady(rep);
        if (this.server != null && this.server.ifTapIsCurrentRequest(this.requestId)) {
            this.server.setStatus();
        }
    }

    protected void planReady(boolean ready) {
        block17: {
            if (this.flagSkip) {
                return;
            }
            if (this.doClose && this.dis != null) {
                try {
                    this.dis.close();
                }
                catch (IOException e) {
                    if (Aladin.levelTrace < 3) break block17;
                    e.printStackTrace();
                }
            }
        }
        if (this.isImage() && !this.doClose) {
            if (!ready && this.error == null) {
                this.error = Aladin.error;
                return;
            }
            this.setPourcent(-1.0);
            this.flagOk = ready;
            return;
        }
        this.aladin.endMsg();
        if (!ready) {
            if (this.error == null) {
                this.error = Aladin.error;
            }
            this.aladin.calque.select.repaint();
            this.aladin.toolBox.toolMode();
            return;
        }
        long t = System.currentTimeMillis();
        if (this.type != 11) {
            Aladin.trace(3, "Plane [" + this.label + "] load&build in " + (t - this.startTime) + "ms");
        }
        this.setPourcent(-1.0);
        this.flagOk = ready;
        boolean trois = false;
        boolean deux = false;
        boolean un = false;
        un = !this.isOldPlan && (this.isImage() || this.type == 16 && !(this instanceof PlanHipsCat));
        if (un || (deux = this.aladin.calque.isFreeX(this)) || (trois = this.isSimpleCatalog() && !this.isViewable() && !this.aladin.calque.isBackGround())) {
            this.aladin.calque.setPlanRef(this);
            if (!this.isOverlay()) {
                this.setOpacityLevel(0.0f);
            }
        } else {
            if (!this.isViewable()) {
                this.aladin.view.syncPlan(this);
            }
            this.setActivated(true);
            this.aladin.calque.unSelectAllPlan();
            this.selected = true;
            TapManager.getInstance(this.aladin).setCurrentUploadPlane(this.label);
        }
        if (this.isCatalog()) {
            PlanFilter.newPlan(this);
            FilterProperties.notifyNewPlan();
        }
        if (!this.isOldPlan) {
            this.aladin.calque.bestPlacePost(this);
            if (this.aladin.dialog != null) {
                this.aladin.dialog.resume();
            }
            if (this.aladin.grabUtilInstance != null) {
                this.aladin.grabUtilInstance.resetAllGrabIts(this.aladin);
            }
        }
        this.flagWaitTarget = false;
        this.flagProcessing = false;
        this.aladin.calque.repaintAll();
    }

    public String toString() {
        return this.label;
    }

    protected static int round(double x) {
        return (int)(x + 0.5);
    }

    protected static int floor(double x) {
        return (int)x;
    }

    protected static int top(double x) {
        return (double)((int)x) == x ? (int)x : (int)(x + 1.0);
    }

    protected Iterator<Obj> iterator() {
        return this.pcat == null ? null : this.pcat.iterator();
    }

    protected Iterator<Obj> iterator(ViewSimple v) {
        return this.iterator();
    }

    protected boolean hasAssociatedFootprints() {
        Iterator<Obj> it = this.iterator();
        if (it == null) {
            return false;
        }
        while (it.hasNext()) {
            SourceFootprint sf;
            Obj o = it.next();
            if (!o.asSource() || (sf = ((Source)o).getFootprint()) == null || !sf.isSet()) continue;
            return true;
        }
        return false;
    }

    protected void showFootprints(boolean show) {
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (!o.asSource()) continue;
            Source s = (Source)o;
            s.setShowFootprint(show, false);
        }
        this.aladin.calque.repaintAll();
    }

    protected void reallocFootprintCache() {
        if (this.pcat == null) {
            return;
        }
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            PlanField pf;
            Source s;
            Obj o = it.next();
            if (!o.asSource() || (s = (Source)o).getFootprint() == null || (pf = s.getFootprint().getFootprint()) == null) continue;
            pf.pcat.reallocObjetCache();
        }
    }

    protected int getIndexAnaglyphMag() {
        if (this.indexAnaglyphMag == -2) {
            Legende leg = this.getFirstLegende();
            if (leg == null) {
                this.indexAnaglyphMag = -1;
            } else {
                this.indexAnaglyphMag = leg.findUCD("phot.mag;em.opt");
                this.setOpacityLevel(0.35f);
            }
        }
        return this.indexAnaglyphMag;
    }

    protected int getIndexAnaglyphParallax() {
        if (this.indexAnaglyphParallax == -2) {
            Legende leg = this.getFirstLegende();
            this.indexAnaglyphParallax = leg == null ? -1 : leg.findUCD("pos.parallax.trig");
        }
        return this.indexAnaglyphParallax;
    }

    static {
        STATUS = new String[]{"STATUS_UNKNOWN", "STATUS_INPROGRESS", "STATUS_MOREDETAILSAVAILABLE", "STATUS_ERROR", "STATUS_EMPTYMOC", "STATUS_OVERFLOW", "STATUS_NOCALIB", "STATUS_EMPTYCAT", "STATUS_LOADING", "STATUS_READY", "STATUS_NOPOS"};
        TYPE = new String[]{"", "Image", "RGB", "Blink", "Cube", "Resampled", "Mosaic", "Algo", "Catalog", "Tool", "Aperture", "Folder", "Filter", "Image FoV", "In progress", "ImageHuge", "HiPS Image", "HiPS Polarisation", "HiPS Catalog", "SMOC", "Cube Color", "HiPS Finder", "HiPS Cube", "Hips3D", "TMOC", "STMOC", "FMOC", "SFMOC", "RGBdyn"};
        DEBUGFLAG = new String[]{"", "RefForVisibleView", "CanBeTransp", "OutOfView", "Viewable", "Activated", "AskActivated", "Ref", "FlagOk", "FlagProcessing", "FlagUpdating", "Selected", "UnderImg", "UnderBkg", "NotSameBody"};
    }
}

