/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Calque;
import cds.aladin.Cercle;
import cds.aladin.Chaine;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FootprintBean;
import cds.aladin.FootprintParser;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanField;
import cds.aladin.PlanHips;
import cds.aladin.PlanHipsCat;
import cds.aladin.PlanMoc;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Source;
import cds.aladin.Status;
import cds.aladin.Tag;
import cds.aladin.ViewSimple;
import cds.astro.Unit;
import cds.moc.Healpix;
import cds.moc.SMoc;
import cds.tools.Astrodate;
import cds.tools.ConfigurationReader;
import cds.tools.ScientificUnitsUtil;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.TableParser;
import cds.xml.TableParserConsumer;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class Pcat
implements TableParserConsumer {
    static String OUTOFMEMORY;
    static String CATABORT;
    static final int DEFAULTBLOC = 200;
    static final int MAXBLOC = 100000;
    protected Obj[] o;
    protected int nb_o;
    Color c;
    int nbTable = 0;
    int iz = -1;
    int nId = -1;
    int nIdVraisemblance = 0;
    boolean badRaDecDetection;
    boolean flagVOTable = false;
    boolean flagSIAV2 = false;
    boolean flagSIA = false;
    boolean flagEPNTAP = false;
    boolean flagLabelFromData = false;
    protected StringBuffer parsingInfo = null;
    protected StringBuffer description = null;
    private final boolean[] drawnInViewSimple = new boolean[16];
    Calque calque;
    Plan plan;
    Status status;
    Aladin aladin;
    protected Projection[] projpcat = new Projection[16];
    String catalog;
    String table;
    double rajc;
    double dejc;
    double rm;
    public Legende leg = null;
    Vector vField = new Vector(10);
    boolean flagXY;
    boolean flagTarget = false;
    boolean flagEndResource;
    boolean flagFirstRecord = true;
    long timeStartTable;
    int lastNb_o;
    double minRa;
    double maxRa;
    double minDec;
    double maxDec;
    private Vector<String> group = null;
    boolean[] hiddenField;
    boolean firstTrace = true;
    private int indexAccessUrl = -1;
    private int indexAccessFormat = -1;
    private int indexDataProductType = -1;
    private int indexSTC = -1;
    private int indexOID = -1;
    private TableParser res;
    private StringBuilder line = new StringBuilder(500);
    private Map<Integer, Field> standardisedColumns = new HashMap<Integer, Field>();
    private int nextID = 0;
    protected boolean removable = false;

    protected static void createChaine(Chaine chaine) {
        OUTOFMEMORY = chaine.getString("POOUTOFMEMORY");
        CATABORT = chaine.getString("POCATABORT");
    }

    protected Pcat(Plan plan, Color c, Calque calque, Status status, Aladin aladin) {
        this.aladin = aladin;
        this.status = status;
        this.calque = calque;
        this.plan = plan;
        this.c = c;
        this.nb_o = 0;
    }

    protected void free() {
        this.nb_o = 0;
        this.o = null;
    }

    protected Pcat(Aladin aladin) {
        this.aladin = aladin;
        this.nb_o = 0;
    }

    protected Pcat(PlanHips p) {
        this.plan = p;
        this.aladin = p.aladin;
        this.nb_o = 0;
    }

    protected Obj[] getObj() {
        return this.o;
    }

    protected void reallocObjetCache() {
        for (int i = 0; i < this.nb_o; ++i) {
            if (!(this.o[i] instanceof Position)) continue;
            ((Position)this.o[i]).createCacheXYVP();
        }
    }

    protected boolean isDrawnInSimpleView(int n) {
        return this.drawnInViewSimple[n];
    }

    protected void resetDrawnInView(ViewSimple v) {
        this.drawnInViewSimple[v.n] = false;
    }

    protected void projection(ViewSimple v) {
        long t1 = Util.getTime();
        this.drawnInViewSimple[v.n] = false;
        if (v.isFree()) {
            return;
        }
        Projection proj = v.getProj();
        if (!Projection.isOk(proj)) {
            return;
        }
        if (this.plan.proj[v.n] == proj && (!(this.plan instanceof PlanHipsCat) || this.plan instanceof PlanHipsCat && !(this.plan instanceof PlanMoc) && this.projpcat[v.n] == proj)) {
            this.drawnInViewSimple[v.n] = true;
            return;
        }
        if (!(this.plan.type == 9 || this.plan.type == 10 || this.plan.isSimpleCatalog() && (this.plan.hasXYorig || v.isPlot()) || proj.agree(this.plan.projd, v))) {
            return;
        }
        this.plan.proj[v.n] = proj;
        this.projpcat[v.n] = proj;
        for (int i = 0; i < this.nb_o; ++i) {
            try {
                this.o[i].projection(v);
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
        v.newView();
        this.drawnInViewSimple[v.n] = true;
        long t2 = Util.getTime();
        this.plan.statTimeComputing = t2 - t1;
        ++this.plan.statNbComputing;
    }

    protected void setCoord(Projection proj) {
        if (!this.plan.hasXYorig || this.plan.hasNoPos) {
            System.err.println("Recalibration on a no-XYlocked planed !!! Aborted");
            return;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        if (v == null) {
            System.out.println("Y a un probs !");
        }
        Aladin.trace(3, "Recalibration \"" + proj.label + "\" XY->ra/dec on \"" + this.plan.label + "\"");
        for (int i = 0; i < this.nb_o; ++i) {
            Position p = (Position)this.o[i];
            p.xv[v.n] = p.x;
            p.yv[v.n] = proj.r1 - p.y;
            p.setCoord(v, proj);
        }
        v.newView(1);
    }

    @Override
    public void startResource(String name) {
        if (this.plan.label.equals("PLASTIC") && name != null && name.length() > 0) {
            this.plan.setLabel(name);
        }
        this.catalog = this.plan.label;
        this.table = this.plan.label;
    }

    @Override
    public void setFilter(String filter) {
        this.plan.addFilter(filter);
    }

    @Override
    public void setResourceInfo(String name, String value) {
        if (this.description == null) {
            this.description = new StringBuffer();
        }
        if (name.equals("NAME")) {
            this.catalog = value;
            if (this.plan.label == null || this.plan.label.length() == 0) {
                this.plan.setLabel(value);
            }
            this.description.append("\nRESOURCE name: " + value + "\n");
        } else if (name.equals("TITLE")) {
            this.description.append("        title: " + value + "\n");
        } else if (name.equals("DESCRIPTION")) {
            this.description.append(value + "\n");
        }
    }

    @Override
    public void endResource() {
        this.flagEndResource = true;
        if (this.plan instanceof PlanHipsCat) {
            return;
        }
        if (!this.flagTarget && !this.flagXY && this.nb_o > 0) {
            this.computeTarget();
        }
        this.postJob(this.rajc, this.dejc, this.rm, true);
    }

    protected void postJob(double rajc, double dejc, double rm, boolean setSourceType) {
        if (this.plan.type == 14) {
            return;
        }
        if (setSourceType) {
            ((PlanCatalog)this.plan).setSourceType(Source.getDefaultType(this.nb_o));
        }
        if (this.flagXY) {
            this.plan.hasXYorig = true;
            this.flagXY = false;
            return;
        }
        int typeProj = Projection.getDefaultType(rm / 60.0);
        this.plan.setNewProjD(new Projection(null, 3, rajc, dejc, rm * 2.0, 250.0, 250.0, 500.0, 0.0, false, typeProj, Calib.FK5, this.plan));
        if (rajc != 0.0 && dejc != 0.0) {
            this.plan.co = new Coord(rajc, dejc);
        }
    }

    @Override
    public void startTable(String name) {
        Aladin.trace(3, "startTable " + name);
        if (this.plan.label.equals("PLASTIC") && name != null && name.length() > 0) {
            this.plan.setLabel(name);
            this.catalog = this.plan.label;
            this.table = this.plan.label;
        }
        if (name != null && name.length() > 0) {
            this.table = name;
        }
        this.flagFirstRecord = true;
        this.flagXY = false;
        this.vField = new Vector(10);
        this.nId = -1;
        this.nIdVraisemblance = 0;
        this.group = null;
        this.timeStartTable = Util.getTime();
        this.lastNb_o = this.nb_o;
    }

    private void addGroup(String s) {
        if (s == null) {
            this.group = null;
            return;
        }
        if (this.group == null) {
            this.group = new Vector();
        }
        this.group.addElement(s);
    }

    @Override
    public void setTableInfo(String name, String value) {
        if (this.description == null) {
            this.description = new StringBuffer();
        }
        if (name.equals("NAME")) {
            this.table = value;
            this.description.append("  TABLE name: " + value + "\n");
        } else if (name.equals("TITLE")) {
            this.description.append("       title: " + value + "\n");
        } else if (name.equals("DESCRIPTION")) {
            this.description.append(value + "\n");
        } else if (name.equals("GROUP")) {
            this.addGroup(value);
        } else if (name.equals("__XYPOS") && value.equals("true")) {
            this.flagXY = true;
            this.plan.error = Plan.NOREDUCTION;
        } else if (name.equals("__NOCOO") && value.equals("true")) {
            this.plan.hasNoPos = true;
            this.plan.error = Plan.NOPOSITION;
        }
    }

    @Override
    public void endTable() {
        long t = Util.getTime() - this.timeStartTable;
        int nbObj = this.nb_o - this.lastNb_o;
        this.tableParserInfo("   -Table loaded & parsed in " + Util.getTemps(t * 1000L) + " for " + nbObj + " object" + (nbObj > 1 ? "s" : "") + (nbObj < 1000 ? "" : " (" + Util.myRound("" + 1000.0 * (double)nbObj / (double)t) + " objects per sec)"));
    }

    @Override
    public void setField(Field f) {
        Aladin.trace(3, "setField " + f);
        if (this.nIdVraisemblance == 0) {
            int pos = this.vField.size();
            if (f.ucd != null && f.ucd.equalsIgnoreCase("meta.id;meta.main") && this.nIdVraisemblance < 40) {
                this.nIdVraisemblance = 40;
                this.nId = pos;
            } else if (f.ucd != null && (f.ucd.equals("ID_MAIN") || f.ucd.startsWith("meta.id")) && this.nIdVraisemblance < 30) {
                this.nIdVraisemblance = 30;
                this.nId = pos;
            } else if (f.name != null && (f.name.equalsIgnoreCase("name") || f.name.equalsIgnoreCase("designation")) && this.nIdVraisemblance < 20) {
                this.nIdVraisemblance = 20;
                this.nId = pos;
            } else if (!(f.name == null || f.name.length() <= 1 || f.name.charAt(0) != 'I' && f.name.charAt(0) != 'i' || f.name.charAt(1) != 'D' && f.name.charAt(1) != 'd' || this.nIdVraisemblance >= 20)) {
                this.nIdVraisemblance = 10;
                this.nId = pos;
            }
        }
        this.vField.addElement(f);
    }

    private int getFieldIndex(String name) {
        Field f;
        Enumeration e = this.vField.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            f = (Field)e.nextElement();
            if (f.name != null && f.name.equals(name)) {
                return i;
            }
            ++i;
        }
        i = 0;
        while (e.hasMoreElements()) {
            f = (Field)e.nextElement();
            if (f.ID != null && f.ID.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String dollarSub(String s, String[] value, int methode) {
        StringBuffer res = new StringBuffer();
        int mode = 0;
        char[] a = s.toCharArray();
        int prev = 0;
        int startVar = 0;
        boolean acco = false;
        if (methode == 1) {
            methode = 2;
        }
        block7: for (int i = 0; i <= a.length; ++i) {
            char c = i == a.length ? (char)'\u0000' : a[i];
            switch (mode) {
                case 0: {
                    if (methode == 2 && c == '?') {
                        methode = 1;
                    }
                    if (c != '$') continue block7;
                    mode = 1;
                    res.append(a, prev, i - prev);
                    prev = i;
                    continue block7;
                }
                case 1: {
                    startVar = i;
                    if (c == '{') {
                        mode = 10;
                        acco = true;
                        continue block7;
                    }
                    mode = 2;
                    acco = false;
                    continue block7;
                }
                case 10: {
                    if (c != '}') continue block7;
                    mode = 3;
                    continue block7;
                }
                case 2: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') continue block7;
                    mode = 3;
                    continue block7;
                }
                case 3: {
                    String var;
                    int n;
                    boolean httpEncode = false;
                    if (acco) {
                        ++startVar;
                    }
                    int length = i - startVar - 1;
                    boolean bl = httpEncode = methode == 1;
                    if (a[startVar] == '-') {
                        httpEncode = false;
                        ++startVar;
                        --length;
                    }
                    if (a[startVar] == '+') {
                        httpEncode = true;
                        ++startVar;
                        --length;
                    }
                    if (a[startVar] == '*') {
                        ++startVar;
                        --length;
                    }
                    if ((n = this.getFieldIndex(var = new String(a, startVar, length))) < 0) {
                        mode = 0;
                        continue block7;
                    }
                    res.append(httpEncode ? URLEncoder.encode(value[n]) : value[n]);
                    prev = acco ? i : i - 1;
                    mode = 0;
                    --i;
                }
            }
        }
        res.append(a, prev, a.length - prev);
        return res.toString();
    }

    public void interrupt() throws Exception {
        this.res.interrupt();
    }

    @Override
    public void setRecord(double ra, double dec, double jdTime, String[] value) {
        block88: {
            String oid = null;
            try {
                String fov;
                int idxMOC;
                String lab;
                int n;
                if (this.flagFirstRecord) {
                    this.leg = null;
                    this.firstTrace = true;
                    this.indexDataProductType = -1;
                    this.indexAccessUrl = -1;
                    this.indexAccessFormat = -1;
                    n = this.vField.size();
                    Vector<Field> v = new Vector<Field>(n);
                    this.hiddenField = new boolean[n];
                    Enumeration e = this.vField.elements();
                    this.indexOID = -1;
                    int DE = -1;
                    int RA = -1;
                    int underDE = -1;
                    int underRA = -1;
                    Field fRA = null;
                    Field fDE = null;
                    String siaStandardColumns = null;
                    String siaHideColumns = null;
                    if (this.flagSIAV2) {
                        siaStandardColumns = ConfigurationReader.getInstance().getPropertyValue("SIAV2StandardColumns");
                        siaHideColumns = ConfigurationReader.getInstance().getPropertyValue("SIAV2HideColumns");
                    }
                    int i = 0;
                    while (e.hasMoreElements()) {
                        Field f = (Field)e.nextElement();
                        if (f != null) {
                            if (this.indexOID == -1 && f.name != null && f.name.equals("_OID")) {
                                this.indexOID = i;
                            }
                            if (f.name != null) {
                                if (f.name.equals("_RAJ2000")) {
                                    underRA = i;
                                    fRA = f;
                                } else if (f.name.equals("_DEJ2000")) {
                                    underDE = i;
                                    fDE = f;
                                } else if (f.name.equals("RAJ2000")) {
                                    RA = i;
                                } else if (f.name.equals("DEJ2000")) {
                                    DE = i;
                                } else if (f.name.equals("RA(ICRS)")) {
                                    RA = i;
                                } else if (f.name.equals("DE(ICRS)")) {
                                    DE = i;
                                } else if (f.name.equals("s_region")) {
                                    this.indexSTC = i;
                                }
                            }
                            if (f.type != null && (f.type.indexOf("hidden") >= 0 || f.type.indexOf("trigger") >= 0)) {
                                this.hiddenField[i] = true;
                                f.visible = false;
                            }
                            v.addElement(f);
                            if (this.flagSIAV2 && f.name != null) {
                                if (siaHideColumns != null && siaHideColumns.indexOf(f.name) > -1) {
                                    this.hiddenField[i] = true;
                                    f.visible = false;
                                }
                                if (siaStandardColumns != null && siaStandardColumns.indexOf(f.name) > -1) {
                                    Field displayField = new Field(f);
                                    displayField.name = Aladin.getChaine().getString(f.name);
                                    displayField.visible = siaHideColumns == null || siaHideColumns.indexOf(displayField.name) <= -1;
                                    v.addElement(displayField);
                                    this.standardisedColumns.put(i, displayField);
                                }
                            }
                        }
                        ++i;
                    }
                    if (RA != -1 && DE != -1 && underRA != -1 && underDE != -1) {
                        this.hiddenField[underDE] = true;
                        this.hiddenField[underRA] = true;
                        fDE.visible = false;
                        fRA.visible = false;
                    }
                    if (this.plan instanceof PlanHipsCat) {
                        this.leg = ((PlanHipsCat)this.plan).getFirstLegende();
                    }
                    if (this.leg == null) {
                        this.leg = new Legende(v);
                        this.leg.name = this.table;
                    }
                    if (this.group != null) {
                        this.leg.setGroup(this.group);
                    }
                    ++this.nbTable;
                    this.flagFirstRecord = false;
                }
                if (value == null) {
                    return;
                }
                if (this.nb_o == this.o.length) {
                    this.nextIndex();
                    --this.nb_o;
                }
                this.line = new StringBuilder(1000);
                if (this.catalog != null && this.catalog.equals("Simbad")) {
                    this.line.append("<&_SIMBAD |Simbad>");
                } else if (this.catalog != null && (this.catalog.equals("NED") || this.catalog.equals("Ned"))) {
                    this.line.append("<&_NED |NED>");
                } else {
                    this.line = this.line.append("<&_getReadMe " + this.table + " |" + this.table + ">");
                }
                n = value.length;
                int j = -1;
                for (int i = 0; i < n; ++i) {
                    String text;
                    String tag;
                    if (value[i] == null) {
                        value[i] = "";
                    }
                    if (this.indexOID >= 0 && i == this.indexOID) {
                        oid = value[i];
                    }
                    String a = value[i].trim();
                    if (this.leg == null || !this.leg.hasInfo(++j) || a.length() == 0 || a.equals("0") || a.equals("-")) {
                        String displayString = "\t" + (a.length() == 0 ? " " : value[i]);
                        this.line.append(displayString);
                        if (!this.flagSIAV2 || !this.standardisedColumns.containsKey(i)) continue;
                        this.line.append(displayString);
                        continue;
                    }
                    String href = this.leg.getHref(j);
                    String gref = this.leg.getGref(j);
                    String flagArchive = this.leg.getRefValue(j);
                    String utype = this.leg.getUtype(j);
                    String name = this.leg.getName(j);
                    if (this.indexSTC == -1 && (Util.indexOfIgnoreCase(value[i], "Polygon ") == 0 || Util.indexOfIgnoreCase(value[i], "Circle ") == 0)) {
                        this.indexSTC = j;
                    }
                    if (href == null && (value[i].startsWith("http://") || value[i].startsWith("https://") || value[i].startsWith("ftp://"))) {
                        String ucd;
                        href = value[i];
                        if (flagArchive == null && (ucd = this.leg.getUCD(j)) != null && Util.indexOfIgnoreCase(ucd, "Image_AccessReference") >= 0) {
                            flagArchive = "image/fits";
                            this.indexAccessUrl = -2;
                        }
                        if (flagArchive == null && utype != null && Util.indexOfIgnoreCase(utype, "ssa:Access.Reference") >= 0) {
                            flagArchive = "spectrum/???";
                            this.indexAccessUrl = -2;
                        }
                        if (flagArchive == null && (ucd = this.leg.getUCD(j)) != null && Util.indexOfIgnoreCase(ucd, "meta.ref.url;datalink.preview") >= 0) {
                            flagArchive = "image/???";
                        }
                        if (flagArchive == null && name != null && name.equalsIgnoreCase("datalink")) {
                            flagArchive = "data/???";
                        }
                    }
                    String string = gref != null ? gref : (tag = href != null ? "Http " + href : null);
                    if (tag != null && flagArchive != null && flagArchive.startsWith("spectr") && flagArchive.indexOf(47) > 0) {
                        tag = "\u00a3" + tag;
                    } else if (tag != null && flagArchive != null && flagArchive.indexOf(47) > 0) {
                        tag = "^" + tag;
                    }
                    if (tag != null && (tag.charAt(0) == '^' || tag.charAt(0) == '\u00a3')) {
                        this.leg.field[j].flagArchive = true;
                    }
                    if (this.indexAccessUrl == -1 && Util.indexOfIgnoreCase(utype, "Access.Reference") >= 0) {
                        this.indexAccessUrl = j;
                    }
                    if (this.indexAccessFormat == -1 && Util.indexOfIgnoreCase(utype, "Access.Format") >= 0) {
                        this.indexAccessFormat = j;
                    }
                    if (this.indexDataProductType == -1 && Util.indexOfIgnoreCase(utype, "Obs.dataProductType") >= 0) {
                        this.indexDataProductType = j;
                    }
                    if ((text = value[i]).indexOf(9) >= 0) {
                        text = text.replace("\t", " ");
                    }
                    this.line.append('\t');
                    if (tag != null) {
                        this.line.append("<&" + this.dollarSub(tag, value, href != null ? 1 : 0));
                        if (text != null) {
                            this.line.append("|" + this.dollarSub(text, value, 0));
                        }
                        this.line.append('>');
                        continue;
                    }
                    this.line.append(text);
                    if (!this.standardisedColumns.containsKey(i)) continue;
                    this.line.append('\t');
                    this.line.append(this.processValuesToStandardRepresentation(this.standardisedColumns.get(i), text));
                }
                if (this.flagXY || !this.flagTarget) {
                    if (ra < this.minRa) {
                        this.minRa = ra;
                    }
                    if (ra > this.maxRa) {
                        this.maxRa = ra;
                    }
                    if (dec < this.minDec) {
                        this.minDec = dec;
                    }
                    if (dec > this.maxDec) {
                        this.maxDec = dec;
                    }
                }
                String string = lab = this.nId >= 0 ? value[this.nId] : "Source #" + (this.nb_o + 1);
                if (this.firstTrace) {
                    Aladin.trace(3, "setRecord " + (oid != null ? "(oid=" + oid + ")" : "") + " \"" + lab + "\" " + (this.flagXY ? "XY" : "pos") + "=(" + ra + "," + dec + ")" + (!Double.isNaN(jdTime) ? " time=" + Astrodate.JDToDate(jdTime) : "") + " [" + this.line + "]");
                    this.firstTrace = false;
                    if (this.indexAccessUrl == -1) {
                        this.indexAccessUrl = this.leg.find("access_url");
                    }
                    if (this.indexAccessFormat == -1) {
                        this.indexAccessFormat = this.leg.find("access_format");
                    }
                    if (this.indexAccessFormat == -1) {
                        this.indexAccessFormat = this.leg.find("content_type");
                    }
                    if (this.indexDataProductType == -1) {
                        this.indexDataProductType = this.leg.find("dataproduct_type");
                    }
                }
                Source source = this.flagXY ? new Source(this.plan, ra, dec, 0.0, 0.0, 1, lab, this.line.toString(), this.leg) : new Source(this.plan, ra, dec, lab, this.line.toString(), this.leg);
                source.jdtime = jdTime;
                if (oid != null) {
                    source.setOID(oid);
                }
                this.o[this.nb_o++] = source;
                int idxSTCS = source.findUtype("*ObservationLocation.AstroCoordArea.Region");
                if (idxSTCS < 0) {
                    idxSTCS = source.findUtype("*Char.SpatialAxis.Coverage.Support.Area");
                }
                if (idxSTCS < 0) {
                    idxSTCS = this.indexSTC;
                }
                if ((idxMOC = source.findXtype("Moc")) >= 0) {
                    try {
                        String val = source.getCodedValue(idxMOC);
                        val = "<&~MOC " + val + "|  Moc>";
                        source.setValue(idxMOC, val);
                        source.getLeg().field[idxMOC].flagMoc = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (idxSTCS >= 0) {
                    try {
                        String val = source.getValue(idxSTCS);
                        if (this.leg.isNumField(idxSTCS) && this.leg.field[idxSTCS].arraysize != null) {
                            val = "Polygon UNKNOWNFrame UNKNOWNREFPOS " + val;
                        }
                        source.setFootprint(val);
                        source.setIdxFootprint(idxSTCS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (this.flagSIA && !this.flagSIAV2 && (fov = source.createSIAFoV()) != null) {
                    source.setFootprint(fov);
                    int iScale = this.leg.findUCD("VOX:Image_Scale");
                    source.setIdxFootprint(iScale);
                }
                if (this.indexAccessUrl < 0 && this.indexDataProductType < 0) break block88;
                try {
                    String type = this.indexDataProductType == -1 ? "" : source.getCodedValue(this.indexDataProductType);
                    String fmt = this.indexAccessFormat == -1 ? "" : source.getCodedValue(this.indexAccessFormat);
                    String val = source.getCodedValue(this.indexAccessUrl);
                    boolean flagChangeVal = false;
                    if (val.startsWith("<&") && fmt.indexOf("html") < 0 && fmt.indexOf("plain") < 0) {
                        String tag = "^";
                        if (type.length() >= 0 && type.startsWith("spectr")) {
                            tag = "\u00a3";
                        } else if (fmt.startsWith("spectr") && fmt.indexOf(47) > 0) {
                            tag = "\u00a3";
                        }
                        val = "<&" + tag + val.substring(2);
                        flagChangeVal = true;
                    } else if (fmt.equals("application/vnd.das2.das2stream")) {
                        val = "<&@" + val + ">";
                        flagChangeVal = true;
                    }
                    if (flagChangeVal) {
                        source.setValue(this.indexAccessUrl, val);
                        source.getLeg().field[this.indexAccessUrl].flagArchive = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("Pcat setRecord (3p) exception " + e);
                }
                e.printStackTrace();
            }
        }
    }

    public String processValuesToStandardRepresentation(Field field, String text) {
        if (!this.flagSIAV2) {
            return text;
        }
        String standardRepresentation = text;
        try {
            if (text != null && !text.trim().isEmpty() && field != null && field.ucd != null) {
                int i = field.ucd.indexOf(46);
                String s = (i < 0 ? field.ucd : field.ucd.substring(0, i)).toLowerCase();
                if (s.equals("time") && "D".equalsIgnoreCase(field.datatype) && "d".equalsIgnoreCase(field.unit)) {
                    if (this.isNumber(text)) {
                        standardRepresentation = this.convertMJDToISO(text);
                    }
                } else if (s.equals("em") && "D".equalsIgnoreCase(field.datatype) && "m".equalsIgnoreCase(field.unit)) {
                    standardRepresentation = this.setStandardSpectralRepresentation(text);
                }
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            standardRepresentation = text;
        }
        return standardRepresentation;
    }

    private boolean isNumber(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String convertMJDToISO(String timeWord) {
        double valueInProcess = Astrodate.MJDToJD(Double.valueOf(timeWord));
        return Astrodate.JDToDate(valueInProcess);
    }

    public String setStandardSpectralRepresentation(String text) {
        String defaultWavelengthUnit = "m";
        Double spectralVal = Double.parseDouble(text);
        Unit unitToProcess = null;
        Double wavelengthRange1 = Double.parseDouble(ConfigurationReader.getInstance().getPropertyValue("WAVELENGTHRANGE1"));
        Double wavelengthRange2 = Double.parseDouble(ConfigurationReader.getInstance().getPropertyValue("WAVELENGTHRANGE2"));
        try {
            if (spectralVal != null && spectralVal != 0.0) {
                if (spectralVal < wavelengthRange1) {
                    unitToProcess = ScientificUnitsUtil.convertMeter2eV(spectralVal);
                } else if (spectralVal >= wavelengthRange1 && spectralVal < wavelengthRange2) {
                    unitToProcess = new Unit(defaultWavelengthUnit);
                    unitToProcess.value = spectralVal;
                } else if (spectralVal >= wavelengthRange2) {
                    unitToProcess = ScientificUnitsUtil.convertMeter2Frequency(spectralVal);
                }
                if (unitToProcess != null) {
                    text = ScientificUnitsUtil.prefixProcessing(unitToProcess);
                }
            } else {
                text = "0.0";
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return text;
    }

    protected boolean hasCatalogInfo() {
        return this.parsingInfo != null || this.description != null;
    }

    protected boolean hasSelectedOrTaggedObj() {
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Obj o = it.next();
            if (o.isSelected()) {
                return true;
            }
            if (!o.asSource() || !((Source)o).isTagged()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasParsingInfo() {
        return this.parsingInfo != null || this.description != null;
    }

    protected void seeCatalogInfo() {
        if (!this.hasParsingInfo()) {
            return;
        }
        JFrame f = new JFrame("Catalog information");
        Util.setCloseShortcut(f, false, this.aladin);
        f.setIconImage(this.aladin.getImagette("AladinIconSS.gif"));
        JTextArea t = new JTextArea(25, 80);
        t.setFont(Aladin.COURIER);
        if (this.description != null) {
            t.setText(this.description.toString() + "\n\n");
        }
        if (this.parsingInfo != null) {
            t.append("Parsing information:\n\n" + this.parsingInfo.toString());
        }
        JScrollPane sp = new JScrollPane(t);
        Aladin.makeAdd(f, sp, "Center");
        f.pack();
        f.show();
    }

    @Override
    public void tableParserWarning(String msg) {
        if (msg.startsWith("!!!")) {
            int n = msg.indexOf("BODY=");
            if (n > 0) {
                String body = msg.substring(n + 5);
                this.plan.setBody(body);
                return;
            }
            if (msg.indexOf("OVERFLOW") >= 0) {
                this.plan.error = msg;
            }
            if (msg.indexOf("ERROR") >= 0) {
                this.plan.error = msg;
            }
        }
        this.tableParserInfo(msg);
    }

    public void setOriginalEpoch(String s) throws Exception {
        this.plan.setOriginalEpoch(s);
    }

    @Override
    public void tableParserInfo(String msg) {
        if (this.parsingInfo == null) {
            this.parsingInfo = new StringBuffer();
        }
        this.parsingInfo.append(msg + "\n");
        Aladin.trace(3, msg);
    }

    @Override
    public void setTableRaDecXYIndex(int nRa, int nDec, int nPmRa, int nPmDec, int nX, int nY, boolean badDetection) {
        int n = this.vField.size();
        if (nRa >= 0 && nRa < n) {
            ((Field)this.vField.elementAt((int)nRa)).coo = 1;
        }
        if (nDec >= 0 && nDec < n) {
            ((Field)this.vField.elementAt((int)nDec)).coo = 2;
        }
        if (nPmRa >= 0 && nPmRa < n) {
            ((Field)this.vField.elementAt((int)nPmRa)).coo = 3;
        }
        if (nPmDec >= 0 && nPmDec < n) {
            ((Field)this.vField.elementAt((int)nPmDec)).coo = 4;
        }
        if (nX >= 0 && nX < n) {
            ((Field)this.vField.elementAt((int)nX)).coo = 11;
        }
        if (nY >= 0 && nY < n) {
            ((Field)this.vField.elementAt((int)nY)).coo = 12;
        }
        this.badRaDecDetection = badDetection;
        if (this.plan != null) {
            this.plan.hasPM = -1;
        }
    }

    @Override
    public void setTarget(String target) {
        double[] tmp = this.parseTarget(target);
        if (tmp == null) {
            return;
        }
        this.flagTarget = true;
        this.rajc = tmp[0];
        this.dejc = tmp[1];
        this.rm = tmp[2];
    }

    public boolean setTargetCoord(String target) {
        Coord c;
        if (Localisation.notCoord(target)) {
            return false;
        }
        Aladin.trace(6, "Pcat.setTargetCoord(" + target + ")");
        try {
            c = new Coord(target);
        }
        catch (Exception e) {
            return false;
        }
        if (Double.isNaN(c.al) || Double.isNaN(c.del)) {
            return false;
        }
        this.rajc = c.al;
        this.dejc = c.del;
        this.rm = 14.0;
        this.flagTarget = true;
        return true;
    }

    protected int tableParsing(MyInputStream dis, String endTag) throws Exception {
        boolean ok;
        this.o = new Obj[200];
        this.nb_o = 0;
        if (this.plan != null) {
            this.catalog = this.plan.label;
            this.table = this.plan.label;
        }
        this.leg = null;
        this.minDec = Double.MAX_VALUE;
        this.minRa = Double.MAX_VALUE;
        this.maxDec = -1.7976931348623157E308;
        this.maxRa = -1.7976931348623157E308;
        this.hiddenField = null;
        this.flagEndResource = false;
        long d = System.currentTimeMillis();
        long type = dis.getType();
        if ((type & 0x1800000L) != 0L) {
            this.plan.headerFits = new FrameHeaderFits(this.plan, dis);
            this.res = new TableParser(this.aladin, this, ((PlanCatalog)this.plan).headerFits.getHeaderFits(), this.plan.flagSkip);
            ok = this.res.parse(dis);
        } else {
            String sep = this.plan instanceof PlanHipsCat ? "\t" : ((type & 0x400000L) == 0x400000L ? " " : (dis.getSepCSV() != '\uffffffff' ? dis.getSepCSV() + "" : this.aladin.CSVCHAR));
            this.res = new TableParser(this.aladin, (TableParserConsumer)this, sep);
            this.res.setFileName(dis.getFileName());
            ok = this.res.parse(dis, endTag);
        }
        if (ok && this.plan instanceof PlanHipsCat) {
            if (this.nb_o == 0) {
                this.setRecord(0.0, 0.0, Double.NaN, null);
            }
            return this.nb_o;
        }
        if (ok) {
            if (!this.flagEndResource) {
                this.endResource();
            }
            long duree = System.currentTimeMillis() - d;
            String s = "Catalog queried, loaded and parsed in " + Util.getTemps(duree * 1000L);
            this.tableParserInfo("\n" + s);
            Aladin.trace(3, s);
            if (!this.flagXY && this.rm == 0.0) {
                Aladin.error = "no RA or DE columns";
                this.plan.error = "no RA or DE columns";
            }
        } else {
            this.plan.error = Aladin.error = "Error: " + this.res.getError();
        }
        if (this.plan.error != null) {
            System.out.println("!!! " + this.plan.label + ": " + this.plan.error);
        }
        return ok && this.nb_o >= 0 ? this.nb_o : -1;
    }

    protected void createDefaultProj() {
        if (this.nb_o == 0) {
            this.dejc = 0.0;
            this.rajc = 0.0;
            this.rm = 420.0;
        } else if (this.nb_o == 1) {
            Position s = (Position)this.o[0];
            this.rajc = s.raj;
            this.dejc = s.dej;
            this.rm = 420.0;
        } else {
            try {
                Healpix hpx = new Healpix();
                SMoc moc = new SMoc(6);
                moc.bufferOn();
                int gap = 1;
                if (this.nb_o > 1000) {
                    gap = this.nb_o / 1000;
                }
                Position target = null;
                for (int i = 0; i < this.nb_o; i += gap) {
                    Position s = (Position)this.o[i];
                    moc.add(hpx, s.raj, s.dej);
                    if (i != 0) continue;
                    target = s;
                }
                moc.bufferOff();
                this.rajc = target.raj;
                this.dejc = target.dej;
                this.rm = (double)(moc.getNbValues() == 1L ? 2 : 90) * 60.0;
                Aladin.trace(3, "computeTarget by Moc =>" + this.rajc + "," + this.dejc + " rm=[" + this.rm + "] moc.getNbValues=" + moc.getNbValues());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.postJob(this.rajc, this.dejc, this.rm, false);
    }

    private void computeTarget() {
        this.createDefaultProj();
    }

    double[] parseTarget(String target) {
        double[] tmp = new double[3];
        StringTokenizer st = new StringTokenizer(target, "+-,=/");
        try {
            tmp[0] = Double.valueOf(st.nextToken().trim());
        }
        catch (Exception e1) {
            return null;
        }
        boolean neg = target.lastIndexOf(45) > 0;
        try {
            tmp[1] = Double.valueOf(st.nextToken().trim());
            if (neg) {
                tmp[1] = -tmp[1];
            }
        }
        catch (Exception e2) {
            return null;
        }
        try {
            st.nextToken();
            tmp[2] = Double.valueOf(st.nextToken().trim());
            if (target.indexOf("bm") > 0) {
                tmp[2] = tmp[2] / 2.0;
            }
        }
        catch (Exception e3) {
            tmp[2] = 11.0;
        }
        return tmp;
    }

    protected int setPlanCat(Plan plan, URL u, boolean verbose) {
        return this.setPlanCat(plan, u, null, null, verbose);
    }

    protected int setPlanCat(Plan plan, MyInputStream dis, String endTag, boolean verbose) {
        return this.setPlanCat(plan, null, dis, endTag, verbose);
    }

    protected int setPlanCat(Plan plan, URL u, MyInputStream dis, String endTag, boolean verbose) {
        int nb = -1;
        boolean flagFootprint = false;
        try {
            if (u != null) {
                this.tableParserInfo(u + "\n");
            }
            if (dis == null) {
                try {
                    dis = Util.openStream(u);
                }
                catch (Exception efirst) {
                    dis = Util.openStream(u);
                }
            }
            plan.dis = dis;
            long type = dis.getType();
            this.flagVOTable = (type & 0x100L) != 0L;
            flagFootprint = (type & 0x40000L) != 0L;
            this.flagSIA = (type & 0x1000L) != 0L;
            boolean bl = this.flagEPNTAP = (type & 0x800000000000L) != 0L;
            if (flagFootprint) {
                endTag = "TABLE";
            }
            nb = this.tableParsing(dis, endTag);
        }
        catch (OutOfMemoryError e) {
            Aladin.error = OUTOFMEMORY;
            if (verbose) {
                System.out.println("!!! " + (plan == null ? "" : plan.label + ": ") + Aladin.error);
                Aladin.error(Aladin.error);
            }
            this.o = new Obj[200];
            this.nb_o = 0;
            this.aladin.gc();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error = CATABORT + "\n --> " + e;
            this.o = new Obj[200];
            this.nb_o = 0;
            this.aladin.gc();
            if (verbose) {
                System.out.println("!!! " + (plan == null ? "" : plan.label + ": ") + Aladin.error);
                Aladin.error(Aladin.error);
            }
            nb = -1;
        }
        if (flagFootprint) {
            FootprintParser fParser = new FootprintParser(dis, this.res.getUnreadBuffer());
            Hashtable<String, FootprintBean> idToFootprint = fParser.getFooprintHash();
            this.attachFootprintToSources(idToFootprint);
        }
        return nb;
    }

    private void attachFootprintToSources(Hashtable<String, FootprintBean> hash) {
        int idx = -1;
        for (int i = 0; i < this.nb_o; ++i) {
            double angleD;
            if (!this.o[i].asSource()) continue;
            Source s = (Source)this.o[i];
            PlanField pf = null;
            idx = s.findColumn("FoVRef");
            if (idx < 0) {
                idx = s.findUtype("char:SpatialAxis.coverage.support.id");
            }
            if (idx < 0) continue;
            String key = s.getValue(idx);
            FootprintBean footprint = hash.get(key);
            s.setIdxFootprint(idx);
            if (footprint != null) {
                pf = new PlanField(this.aladin, footprint, key);
                s.setFootprint(pf);
            }
            if ((idx = s.findUCD("pos.posAng")) < 0) continue;
            String angle = s.getValue(idx);
            if (angle == null) {
                angle = "";
            }
            try {
                angleD = Double.valueOf(angle);
            }
            catch (NumberFormatException e) {
                angleD = 0.0;
            }
            if (pf == null) continue;
            pf.make(s.raj, s.dej, angleD);
        }
    }

    protected int getNextID() {
        return this.nextID;
    }

    int nextIndex() {
        if (this.o == null) {
            this.o = new Obj[200];
            this.nb_o = 0;
        }
        ++this.nextID;
        if (this.nb_o < this.o.length) {
            return this.nb_o++;
        }
        Obj[] otmp = new Obj[this.o.length > 100000 ? this.o.length + 100000 : this.o.length * 2];
        System.arraycopy(this.o, 0, otmp, 0, this.o.length);
        this.o = otmp;
        otmp = null;
        return this.nb_o++;
    }

    protected int setObjet(Obj newobj) {
        int i = this.nextIndex();
        if (i < 0) {
            return -1;
        }
        if (newobj instanceof Tag) {
            Tag t = (Tag)newobj;
            t.setEditing(false);
        } else if (newobj instanceof Cote) {
            Cote c = (Cote)newobj;
            if (c.debligne != null) {
                c.setId();
                this.aladin.console.printInPad(c.id + "\n");
            }
        }
        this.o[i] = newobj;
        return i;
    }

    protected void insertSource(Source src) {
        for (int i = this.nb_o - 1; i >= 0; --i) {
            int n;
            if (!this.o[i].asSource() || ((Source)this.o[i]).getLeg() != src.getLeg()) continue;
            for (int j = n = this.nextIndex(); j > i + 1; --j) {
                this.o[j] = this.o[j - 1];
            }
            this.o[i + 1] = src;
            return;
        }
        this.setObjetFast(src);
    }

    protected void setObjetFast(Obj newobj) {
        int i = this.nextIndex();
        this.o[i] = newobj;
    }

    protected void fixInfo(Legende leg) {
        int j = 0;
        for (int i = 0; i < this.nb_o; ++i) {
            Source s;
            if (!this.o[i].asSource() || (s = (Source)this.o[i]).getLeg() != leg) continue;
            s.fixInfo();
            ++j;
        }
    }

    protected int getIndex(Obj x) {
        for (int i = 0; i < this.nb_o; ++i) {
            if (x != this.o[i]) continue;
            return i;
        }
        return -1;
    }

    protected boolean delObjet(Obj obj) {
        return this.delObjet(obj, this.removable);
    }

    protected boolean delObjet(Obj obj, boolean force) {
        if (obj instanceof Ligne && !(obj instanceof Cote)) {
            return this.delLigne(obj);
        }
        return this.delObjetOne(obj, force);
    }

    protected boolean delObjetOne(Obj obj, boolean force) {
        int i;
        if (!force && obj.asSource()) {
            return false;
        }
        obj.remove();
        for (i = 0; i < this.nb_o && obj != this.o[i]; ++i) {
        }
        if (i < this.nb_o) {
            while (i < this.nb_o - 1) {
                this.o[i] = this.o[i + 1];
                ++i;
            }
            --this.nb_o;
            return true;
        }
        return false;
    }

    protected boolean delLigne(Obj obj) {
        Iterator<Obj> it = obj.iterator();
        while (it.hasNext()) {
            obj = it.next();
            if (this.delObjetOne(obj, true)) continue;
            return false;
        }
        return false;
    }

    protected void showBaratin(int i) {
        this.o[i].status(this.aladin);
    }

    protected boolean computeAndTestDraw(ViewSimple v, boolean draw) {
        if (this.plan.isCatalog() || this.plan.type == 9 || this.plan.type == 10 || this.plan.type == 13) {
            this.projection(v);
        }
        if (!this.drawnInViewSimple[v.n]) {
            return false;
        }
        return draw;
    }

    protected int draw(Graphics g, Rectangle r, ViewSimple v, boolean draw, int dx, int dy) {
        return this.draw(g, r, v, draw, false, dx, dy);
    }

    protected synchronized int draw(Graphics g, Rectangle r, ViewSimple v, boolean draw, boolean onlySelected, int dx, int dy) {
        int nb;
        block5: {
            if (!this.computeAndTestDraw(v, draw)) {
                return 0;
            }
            long t1 = Util.getTime();
            nb = 0;
            try {
                if (dx == 0 && this.plan != null && Aladin.isFootprintPlane(this.plan) && Aladin.ENABLE_FOOTPRINT_OPACITY && (double)this.plan.getOpacityLevel() > 0.02 && g instanceof Graphics2D) {
                    this.drawFovInTransparency(g, r, v, draw, dx, dy);
                }
                g.setColor(this.c);
                for (int i = 0; i < this.nb_o; ++i) {
                    if (r != null && !this.o[i].inClip(v, r) || onlySelected && !this.o[i].isSelected() || !this.o[i].draw(g, v, dx, dy)) continue;
                    ++nb;
                }
                long t2 = Util.getTime();
                this.plan.statTimeDisplay = t2 - t1;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block5;
                e.printStackTrace();
            }
        }
        this.plan.statNbItems = nb;
        return nb;
    }

    private void drawFovInTransparency(Graphics g, Rectangle r, ViewSimple v, boolean draw, int dx, int dy) {
        Graphics2D g2d = null;
        Composite saveComposite = null;
        g2d = (Graphics2D)g;
        g2d.setColor(this.plan.c);
        saveComposite = g2d.getComposite();
        Composite myComposite = Util.getFootprintComposite(this.plan.getOpacityLevel());
        g2d.setComposite(myComposite);
        ArrayList<Obj> linesToProcess = new ArrayList<Obj>();
        for (int i = 0; i < this.nb_o; ++i) {
            if (this.o[i] instanceof Cercle || !(this.o[i] instanceof Ligne)) continue;
            linesToProcess.add(this.o[i]);
        }
        if (linesToProcess.size() > 0) {
            Ligne[] lArray = linesToProcess.toArray(new Ligne[linesToProcess.size()]);
            ArrayList<Ligne> polyLine = new ArrayList<Ligne>();
            for (int i = lArray.length - 1; i >= 0; --i) {
                Ligne curLine;
                if (!linesToProcess.contains(lArray[i])) continue;
                polyLine.clear();
                Ligne startLine = curLine = lArray[i];
                linesToProcess.remove(curLine);
                while (curLine.debligne != null && curLine.debligne != startLine) {
                    curLine = curLine.debligne;
                    polyLine.add(curLine);
                    linesToProcess.remove(curLine);
                }
                if (polyLine.size() <= 0) continue;
                Point[] points = new Point[polyLine.size()];
                int[] x = new int[polyLine.size()];
                int[] y = new int[polyLine.size()];
                Iterator it = polyLine.iterator();
                int k = 0;
                while (it.hasNext()) {
                    points[k] = ((Ligne)it.next()).getViewCoord(v);
                    if (points[k] == null) {
                        g2d.setComposite(saveComposite);
                        return;
                    }
                    x[k] = points[k].x;
                    y[k] = points[k].y;
                    ++k;
                }
                g2d.setColor(curLine.getColor());
                if (!curLine.isVisible()) continue;
                g2d.fill(new Polygon(x, y, k));
            }
        }
        g2d.setComposite(saveComposite);
    }

    protected synchronized void writeLink(OutputStream out, ViewSimple v, boolean draw) throws Exception {
        if (!this.computeAndTestDraw(v, draw)) {
            return;
        }
        for (int i = 0; i < this.nb_o; ++i) {
            this.o[i].writeLink(out, v);
        }
    }

    protected synchronized void writeLinkFlex(OutputStream out, ViewSimple v, boolean draw) throws Exception {
        if (!this.computeAndTestDraw(v, draw)) {
            return;
        }
        for (int i = 0; i < this.nb_o; ++i) {
            if (!this.o[i].asSource()) continue;
            ((Source)this.o[i]).writeLinkFlex(out, v);
        }
    }

    protected int getCount() {
        return this.nb_o;
    }

    protected boolean hasObj() {
        return this.nb_o > 0;
    }

    protected Obj getObj(int index) {
        return index >= this.nb_o ? null : this.o[index];
    }

    protected Iterator<Obj> iterator() {
        return new PlanObjetIterator(null);
    }

    protected Iterator<Obj> iterator(ViewSimple v) {
        return new PlanObjetIterator(v);
    }

    class PlanObjetIterator
    implements Iterator<Obj> {
        private int index = 0;
        boolean visible = true;

        PlanObjetIterator(ViewSimple v) {
            this.visible = v != null ? Pcat.this.drawnInViewSimple[v.n] : true;
        }

        @Override
        public boolean hasNext() {
            return this.visible && this.index < Pcat.this.nb_o;
        }

        @Override
        public Obj next() {
            return Pcat.this.o[this.index++];
        }

        @Override
        public void remove() {
        }
    }
}

