/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Icon;
import cds.aladin.Plan;
import cds.aladin.ViewSimple;
import java.awt.Color;
import java.awt.Graphics;

public class Oeil
extends Icon {
    private static final int[][] TX = new int[][]{{0, 5, 9}, {1, 2, 4}, {1, 6, 8}, {1, 10, 12}, {2, 0, 1}, {2, 5, 6}, {2, 9, 9}, {2, 13, 14}, {3, 5, 6}, {3, 9, 9}, {4, 5, 9}, {5, 0, 1}, {5, 6, 8}, {5, 13, 14}, {6, 2, 4}, {6, 10, 12}, {7, 5, 9}};
    protected String LABEL = Aladin.chaine.getString("OEIL");

    protected Oeil(Aladin aladin) {
        super(aladin, 29, 24);
    }

    protected static void drawOeil(Graphics g, int x, int y, Color c) {
        g.setColor(c);
        for (int i = 0; i < TX.length; ++i) {
            g.drawLine(TX[i][1] + x, TX[i][0] + y, TX[i][2] + x, TX[i][0] + y);
        }
    }

    @Override
    protected boolean isAvailable() {
        if (this.aladin.calque == null || this.aladin.calque.isFree()) {
            return false;
        }
        if (this.isActivated()) {
            return true;
        }
        Plan pb = this.aladin.calque.getPlanBase();
        if (pb == null || !pb.isPixel()) {
            return false;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        int n = 0;
        for (int i = 0; i < this.aladin.calque.plan.length; ++i) {
            Plan p = this.aladin.calque.plan[i];
            if (p.hasError() || !p.active || p.getOpacityLevel() < 0.1f || p == pb || !p.hasNoReduction() && !pb.hasNoReduction() && !pb.projd.agree(p.projd, v)) continue;
            ++n;
        }
        return n > 0;
    }

    @Override
    protected boolean isActivated() {
        return this.aladin.calque.hasClinDoeil();
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = 5 + this.DX;
        int y = 2;
        Oeil.drawOeil(g, x, y, this.getLogoColor());
        g.setColor(this.getLabelColor());
        g.setFont(Aladin.SPLAIN);
        g.drawString(this.LABEL, this.W / 2 - g.getFontMetrics().stringWidth(this.LABEL) / 2, this.H - 2);
    }

    @Override
    protected void submit() {
        if (!this.isAvailable()) {
            return;
        }
        this.aladin.calque.clinDoeil();
        this.aladin.calque.repaintAll();
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("OEILH");
    }

    @Override
    protected String getHelpKey() {
        return "OEILH";
    }
}

