/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinData;
import cds.aladin.Coord;
import cds.aladin.Plan;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.aladin.prop.Propable;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;

public abstract class Obj
implements Propable {
    public static final int OVAL = 0;
    public static final int SQUARE = 1;
    public static final int CIRCLE = 2;
    public static final int RHOMB = 3;
    public static final int CROSS = 4;
    public static final int TRIANGLE = 5;
    public static final int PLUS = 6;
    public static final int CIRCLES = 7;
    public static final int POINT = 8;
    public static final int DOT = 9;
    public static final int SOLIDOVAL = 10;
    public static final int SOLIDSQUARE = 11;
    public static final int SOLIDCIRCLE = 12;
    public static final int SOLIDRHOMB = 13;
    public static final int SOLIDTRIANGLE = 14;
    public static final int RETICULE = 15;
    protected static final int XY = 1;
    protected static final int RADE = 2;
    protected static final int RADE_COMPUTE = 4;
    protected static final int XY_COMPUTE = 8;
    protected static final byte SELECT = 1;
    protected static final byte TAG = 2;
    protected static final byte VISIBLE = 4;
    protected static final byte WITHLABEL = 8;
    protected static final byte HIGHLIGHT = 16;
    protected static final byte WITHSTAT = 32;
    protected static final byte LOCKED = 64;
    protected Plan plan;
    public double raj = Double.NaN;
    public double dej;
    public double jdtime = Double.NaN;
    public String id;
    protected byte flags = (byte)4;

    @Override
    public boolean hasProp() {
        return this.plan != null && this.plan.type != 10;
    }

    @Override
    public Vector<Prop> getProp() {
        Vector<Prop> propList = new Vector<Prop>();
        JLabel l = new JLabel("\"" + this.getObjType() + "\" object in plane: \"" + this.plan.getLabel() + "\"");
        l.setFont(l.getFont().deriveFont(1));
        l.setFont(l.getFont().deriveFont(14.0f));
        propList.add(Prop.propFactory("object", "", null, l, null, null));
        final Obj myself = this;
        final JTextField pos = new JTextField(20);
        PropAction updatePos = new PropAction(){

            @Override
            public int action() {
                pos.setText(Obj.this.plan.aladin.localisation.getLocalisation(myself));
                return 1;
            }
        };
        PropAction changePos = new PropAction(){

            @Override
            public int action() {
                pos.setForeground(Color.black);
                String opos = Obj.this.plan.aladin.localisation.getLocalisation(myself);
                try {
                    String npos = pos.getText();
                    if (npos.equals(opos)) {
                        return -1;
                    }
                    Coord c1 = new Coord(pos.getText());
                    if (("" + c1).indexOf("--") >= 0) {
                        throw new Exception();
                    }
                    c1 = Obj.this.plan.aladin.localisation.frameToICRS(c1);
                    Obj.this.setRaDec(c1.al, c1.del);
                    return 1;
                }
                catch (Exception e1) {
                    pos.setForeground(Color.red);
                    pos.setText(opos);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("coord", "Coord", "Object position", pos, updatePos, changePos));
        if (this.id != null && this.id.length() > 0) {
            final JLabel idL = new JLabel(this.id);
            PropAction updateId = new PropAction(){

                @Override
                public int action() {
                    idL.setText(Obj.this.id);
                    return 1;
                }
            };
            propList.add(Prop.propFactory("id", "Info", "associated information", idL, updateId, null));
        }
        return propList;
    }

    protected void setSelect(boolean select) {
        this.flags = select ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public Color getColor() {
        return this.plan.c;
    }

    public void setColor() throws Exception {
        throw new Exception("Not specifical color property");
    }

    public boolean hasPhot() {
        return false;
    }

    public boolean hasPhot(ViewSimple v) {
        return false;
    }

    public final boolean isSelected() {
        return (this.flags & 1) != 0;
    }

    public final void setVisible(boolean visible) {
        this.flags = visible ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    public final boolean isVisible() {
        return (this.flags & 4) != 0;
    }

    public double getJD() {
        return this.jdtime;
    }

    public double getRa() {
        return this.raj;
    }

    public double getDec() {
        return this.dej;
    }

    public String getInfo() {
        return this.id;
    }

    public Iterator<Obj> iterator() {
        return null;
    }

    public String getCommand() {
        return null;
    }

    public boolean hasSurface() {
        return false;
    }

    public int getStatsHashcode(AladinData ad) {
        return this.getStatsHashcode(ad.plan, -1);
    }

    public int getStatsHashcode(AladinData ad, int z) {
        return this.getStatsHashcode(ad.plan, z);
    }

    protected int getStatsHashcode(Plan p, int z) {
        return 0;
    }

    public double[] getStatistics(AladinData ad) throws Exception {
        return this.getStatistics(ad.plan, -1);
    }

    public double[] getStatistics(AladinData ad, int z) throws Exception {
        return this.getStatistics(ad.plan, z);
    }

    protected double[] getStatistics(Plan p) throws Exception {
        return this.getStatistics(p, -1);
    }

    protected double[] getStatistics(Plan p, int z) throws Exception {
        throw new Exception("no statistics available");
    }

    public double[] getStatisticsRaDecPix(AladinData ad) throws Exception {
        return this.getStatisticsRaDecPix(ad.plan, -1);
    }

    public double[] getStatisticsRaDecPix(AladinData ad, int z) throws Exception {
        return this.getStatisticsRaDecPix(ad.plan, z);
    }

    protected double[] getStatisticsRaDecPix(Plan p) throws Exception {
        return this.getStatisticsRaDecPix(p, -1);
    }

    protected double[] getStatisticsRaDecPix(Plan p, int z) throws Exception {
        throw new Exception("no statistics available");
    }

    public double getRadius() {
        return 0.0;
    }

    public double getDistance(Obj obj) {
        Coord ca = new Coord();
        Coord cb = new Coord();
        ca.al = this.raj;
        ca.del = this.dej;
        cb.al = obj.raj;
        cb.del = obj.dej;
        return Coord.getDist(ca, cb);
    }

    public String getXMLMetaData() {
        return null;
    }

    public String[] getValues() {
        return null;
    }

    public String[] getNames() {
        return null;
    }

    public String[] getUnits() {
        return null;
    }

    public String[] getDataTypes() {
        return null;
    }

    public String[] getUCDs() {
        return null;
    }

    public String[] getArraysizes() {
        return null;
    }

    public String[] getWidths() {
        return null;
    }

    public String[] getPrecisions() {
        return null;
    }

    public int getSize() {
        return 0;
    }

    public int indexOf(String key) {
        return -1;
    }

    public void setColumn(int index, String name, String unit, String ucd, int width) {
    }

    public boolean setValue(int index, String value) {
        return false;
    }

    public void setShape(int shape) {
    }

    public void setColor(Color c) {
    }

    public void setInfo(String info) {
        this.id = info;
    }

    public String getObjType() {
        return "";
    }

    public String getSexa() {
        return Coord.getSexa(this.raj, this.dej);
    }

    public InputStream getVOTable() throws Exception {
        throw new Exception("Not a source");
    }

    public void setSelected(boolean flag) {
        this.plan.aladin.view.setSelected(this, flag);
    }

    public void setHighlighted(boolean flag) {
    }

    public void setRaDec(double ra, double de) {
        this.raj = ra;
        this.dej = de;
    }

    public void setXY(double x, double y) {
        this.setPosition(this.plan.aladin.view.getCurrentView(), x, y);
    }

    protected abstract void setPosition(ViewSimple var1, double var2, double var4);

    protected abstract void deltaPosition(ViewSimple var1, double var2, double var4);

    protected abstract void deltaRaDec(double var1, double var3);

    protected abstract void setText(String var1);

    protected abstract Point getViewCoord(ViewSimple var1, int var2, int var3);

    protected abstract boolean inside(ViewSimple var1, double var2, double var4);

    protected abstract boolean in(ViewSimple var1, double var2, double var4);

    protected abstract boolean inBout(ViewSimple var1, double var2, double var4);

    protected Rectangle getClip(ViewSimple v) {
        return this.extendClip(v, null);
    }

    protected abstract Rectangle extendClip(ViewSimple var1, Rectangle var2);

    protected boolean inClip(ViewSimple v, Rectangle clip) {
        if (clip == null) {
            return true;
        }
        Rectangle r = this.getClip(v);
        if (r == null) {
            return true;
        }
        return Obj.intersectRect(clip, r.x, r.y, r.width, r.height);
    }

    protected void remove() {
    }

    protected void projection(ViewSimple v) {
    }

    protected abstract boolean draw(Graphics var1, ViewSimple var2, int var3, int var4);

    protected abstract void writeLink(OutputStream var1, ViewSimple var2) throws Exception;

    protected abstract void drawSelect(Graphics var1, ViewSimple var2);

    protected abstract void info(Aladin var1);

    protected abstract void status(Aladin var1);

    protected String getSpecificAJInfo() {
        return this.id;
    }

    protected void setSpecificAJInfo(String s) {
        this.id = s == null || s.length() == 0 ? null : s;
    }

    protected abstract void setVisibleGenerique(boolean var1);

    protected abstract void switchSelect();

    public Plan getPlan() {
        return this.plan;
    }

    protected abstract boolean cutOn();

    protected final double mouseDist(ViewSimple v) {
        return 10.0;
    }

    protected static final Rectangle unionRect(Rectangle r, Rectangle r1) {
        if (r1 == null) {
            return r;
        }
        return Obj.unionRect(r, r1.x, r1.y, r1.width, r1.height);
    }

    protected static final Rectangle unionRect(Rectangle r, int x, int y, int width, int height) {
        if (r == null) {
            return new Rectangle(x, y, width, height);
        }
        int x1 = Math.max(r.x + r.width, x + width);
        int y1 = Math.max(r.y + r.height, y + height);
        r.x = Math.min(r.x, x);
        r.y = Math.min(r.y, y);
        r.width = x1 - r.x;
        r.height = y1 - r.y;
        return r;
    }

    protected static final boolean intersectRect(Rectangle r, int x, int y, int width, int height) {
        if (r == null) {
            return false;
        }
        int x1 = x + width - 1;
        int y1 = y + height - 1;
        int rx1 = r.x + r.width - 1;
        int ry1 = r.y + r.height - 1;
        return !(x < r.x && x1 < r.x || x > rx1 && x1 > rx1 || y < r.y && y1 < r.y || y > ry1 && y1 > ry1);
    }

    public String toString() {
        return "(" + this.raj + "," + this.dej + ") -> " + this.id;
    }

    protected boolean asSource() {
        return false;
    }
}

