/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyButton;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import javax.swing.JComponent;

public final class MyLink
extends JComponent {
    static final int UP = 1;
    static final int DOWN = -1;
    static final int UNAVAIL = 0;
    static final int NORMAL = 0;
    static final int LEFT = 1;
    static final int RIGHT = 2;
    static final int TRI = 7;
    protected String baratin;
    protected String text;
    String help = null;
    Aladin aladin;
    Label status = null;
    boolean alwaysUp = true;
    int mode = 1;
    int type = 0;
    int W = 75;
    static final int MARGE = 10;
    int H = Aladin.LSIZE + 10;
    private Color color = Color.black;
    Font f = null;
    int strWidth;
    PopupMenu pm = null;
    static boolean flagShift = false;
    boolean inCanvas = false;

    protected MyLink(Aladin aladin, String s) {
        this.suite(aladin, s, null, null, true);
    }

    protected MyLink(Aladin aladin, Label status, int type, String s, String baratin) {
        this.status = status;
        this.type = type;
        this.suite(aladin, s, baratin, null, true);
    }

    protected MyLink(Aladin aladin, String s, String baratin, String help) {
        this.suite(aladin, s, baratin, help, true);
    }

    protected MyLink(Aladin aladin, String s, String baratin, String help, boolean enable) {
        this.suite(aladin, s, baratin, help, enable);
    }

    void suite(Aladin aladin, String s, String baratin, String help, boolean enable) {
        this.aladin = aladin;
        this.baratin = baratin;
        this.text = s;
        int n = this.mode = enable ? 1 : 0;
        if (help != null) {
            this.help = help;
        }
        this.f = Aladin.LBOLD;
        this.H = this.getH();
        this.resize(this.W, this.H);
    }

    @Override
    public void setFont(Font f) {
        this.f = f;
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        this.W = fm.stringWidth(this.text) + 10;
        this.strWidth = fm.stringWidth(this.text);
        this.resize(this.W, this.H);
    }

    private int getH() {
        char[] a = this.text.toCharArray();
        int n = 1;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != '\n') continue;
            ++n;
        }
        return Aladin.LSIZE * n + 10;
    }

    protected void setLabel(String s) {
        this.text = s;
        this.repaint();
    }

    protected void setAlwaysUp(boolean a) {
        this.alwaysUp = a;
    }

    @Override
    public void enable(boolean a) {
        int omode = this.mode;
        this.mode = a ? 1 : 0;
        if (omode != this.mode) {
            this.repaint();
        }
    }

    protected void push() {
    }

    protected void pop() {
    }

    @Override
    public boolean mouseDown(Event e, int x, int y) {
        return true;
    }

    @Override
    public boolean mouseUp(Event e, int x, int y) {
        if (this.mode == 0) {
            return true;
        }
        if (this.alwaysUp) {
            this.pop();
        }
        this.postEvent(new Event(new Button(this.baratin), 1001, this.baratin));
        return true;
    }

    @Override
    public synchronized void add(PopupMenu pm) {
        this.pm = pm;
        super.add(pm);
    }

    @Override
    public boolean action(Event e, Object o) {
        try {
            String s = (String)o;
        }
        catch (Exception eact) {
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        if (x > this.strWidth + 5) {
            if (this.inCanvas) {
                this.inCanvas = false;
                Aladin.makeCursor(this, 0);
                this.repaint();
            }
        } else if (!this.inCanvas) {
            this.inCanvas = true;
            Aladin.makeCursor(this, 2);
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseEnter(Event e, int x, int y) {
        if (this.mode == 1) {
            this.color = Aladin.COLOR_GREEN;
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseExit(Event e, int x, int y) {
        this.color = Color.black;
        this.repaint();
        return true;
    }

    private synchronized void setFlagShift(boolean flag) {
        flagShift = flag;
    }

    static synchronized boolean shiftDown() {
        return flagShift;
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 504) {
            if (e.x < this.strWidth + 5) {
                this.inCanvas = true;
                Aladin.makeCursor(this, 2);
                this.repaint();
            }
        } else if (e.id == 505) {
            this.inCanvas = false;
            Aladin.makeCursor(this, 0);
            this.repaint();
        }
        if (e.target instanceof MyButton) {
            this.setFlagShift(e.shiftDown());
        }
        if (e.id == 505 && this.alwaysUp && this.mode != 0) {
            this.pop();
        }
        if (this.baratin == null) {
            return super.handleEvent(e);
        }
        return super.handleEvent(e);
    }

    void draw(Graphics g) {
        Color c = this.mode != 0 ? Color.black : Color.gray;
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.W, this.H);
        if (this.mode == -1) {
            g.setColor(this.type != 0 ? Aladin.COLOR_CONTROL_BACKGROUND : Color.gray);
            g.fillRect(2, 2, this.W - 4, this.H - 4);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        this.W = this.getSize().width;
        this.H = this.getSize().height;
        this.draw(g);
        g.setFont(this.f);
        g.setColor(Color.blue);
        if (this.text != null && !this.text.equals("")) {
            int y = this.H / 2 - 1 * (Aladin.SIZE + 4) / 2 + Aladin.SIZE + 2;
            String s = this.text;
            int l = this.strWidth;
            int x = 0;
            g.drawString(s, x, y);
            if (this.inCanvas) {
                g.drawLine(0, y + 1, l, y + 1);
            }
        }
    }
}

