/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Plan;
import cds.aladin.Tok;
import cds.fits.HeaderFits;
import cds.image.Bzip2;
import cds.tools.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class MyInputStream
extends FilterInputStream {
    private static boolean TEST_FITSKEY = false;
    private static boolean TEST_SKIP80 = true;
    private static final int BLOCCACHE = 65536;
    public static final long UNKNOWN = 0L;
    public static final long FITS = 1L;
    public static final long JPEG = 2L;
    public static final long GIF = 4L;
    public static final long MRCOMP = 8L;
    public static final long HCOMP = 16L;
    public static final long GZ = 32L;
    public static final long XML = 64L;
    public static final long ASTRORES = 128L;
    public static final long VOTABLE = 256L;
    public static final long AJ = 512L;
    public static final long AJS = 1024L;
    public static final long IDHA = 2048L;
    public static final long SIA = 4096L;
    public static final long CSV = 8192L;
    public static final long NOTAVAILABLE = 16384L;
    public static final long AJSx = 32768L;
    public static final long PNG = 65536L;
    public static final long XFITS = 131072L;
    public static final long FOV = 262144L;
    public static final long FOV_ONLY = 524288L;
    public static final long CATLIST = 0x100000L;
    public static final long RGB = 0x200000L;
    public static final long BSV = 0x400000L;
    public static final long FITST = 0x800000L;
    public static final long FITSB = 0x1000000L;
    public static final long CUBE = 0x2000000L;
    public static final long SEXTRA = 0x4000000L;
    public static final long HUGE = 0x8000000L;
    public static final long AIPSTABLE = 0x10000000L;
    public static final long IPAC = 0x20000000L;
    public static final long BMP = 0x40000000L;
    public static final long FITSCMP = 0x80000000L;
    public static final long HEALPIX = 0x100000000L;
    public static final long GLU = 0x200000000L;
    public static final long ARGB = 0x400000000L;
    public static final long PDS = 0x800000000L;
    public static final long SMOC = 0x1000000000L;
    public static final long DS9REG = 0x2000000000L;
    public static final long SED = 0x4000000000L;
    public static final long BZIP2 = 0x8000000000L;
    public static final long AJTOOL = 0x10000000000L;
    public static final long TAP = 0x20000000000L;
    public static final long OBSTAP = 0x40000000000L;
    public static final long EOF = 0x80000000000L;
    public static final long PROP = 0x100000000000L;
    public static final long SSA = 0x200000000000L;
    public static final long SIAV2 = 0x400000000000L;
    public static final long EPNTAP = 0x800000000000L;
    public static final long DATALINK = 0x1000000000000L;
    public static final long DALIEX = 0x2000000000000L;
    public static final long TMOC = 0x4000000000000L;
    public static final long STMOC = 0x8000000000000L;
    public static final long FMOC = 0x10000000000000L;
    public static final long SFMOC = 0x20000000000000L;
    public static final long HPXMOC = 0x40000000000000L;
    public static final long JSON = 0x80000000000000L;
    static final String[] FORMAT = new String[]{"UNKNOWN", "FITS", "JPEG", "GIF", "MRCOMP", "HCOMP", "GZIP", "XML", "ASTRORES", "VOTABLE", "AJ", "AJS", "IDHA", "SIA", "CSV", "UNAVAIL", "AJSx", "PNG", "XFITS", "FOV", "FOV_ONLY", "CATLIST", "RGB", "BSV", "FITS-TABLE", "FITS-BINTABLE", "CUBE", "SEXTRACTOR", "HUGE", "AIPSTABLE", "IPAC-TBL", "BMP", "FITSCMP", "HEALPIX", "GLU", "ARGB", "PDS", "SMOC", "DS9REG", "SED", "BZIP2", "AJTOOL", "TAP", "OBSTAP", "EOF", "PROP", "SSA", "SIAV2", "EPNTAP", "DATALINK", "DALIEX", "TMOC", "STMOC", "FMOC", "SFMOC", "HPXMOC", "JSON"};
    private static final int DEFAULT = 0;
    private static final int FITSEND = 1;
    private static final int FITSEND2 = 2;
    protected boolean withBuffer;
    private byte[] cache = null;
    private int nextReadInCache = 0;
    private int availableInCache = 0;
    private boolean flagEOF = false;
    private long type = -1L;
    private boolean flagGetType;
    private boolean alreadyRead;
    private long sizeAlreadyRead;
    private String commentCalib = null;
    protected String filename = null;
    private boolean fitsHeadRead;
    private int markPos = -1;
    private int markLen = 0;
    public static int NBOPENFILE = 0;
    private byte[] bufRead = new byte[1];
    private static final String SEP = "\t,;!| :/&";
    private static final String[] PROPKEY = new String[]{"ID", "creator_did", "publisher_did", "publisher_id", "obs_did"};
    private char sepCSV = (char)65535;
    private static String HEX = "0123456789ABCDEF";
    Hashtable<String, String> avm = null;
    double avmRefWidth = -1.0;
    private int posAfterFitsHead = -1;
    private HashMap<String, String> fitskey = null;

    public MyInputStream(InputStream in) {
        this(in, 0L, true);
    }

    public MyInputStream(InputStream in, long type, boolean withBuffer) {
        super(in);
        this.type = type;
        this.withBuffer = withBuffer;
        this.flagGetType = false;
        this.alreadyRead = false;
        this.fitsHeadRead = false;
        this.sizeAlreadyRead = 0L;
        this.in = in != null && withBuffer && !(in instanceof BufferedInputStream) ? new BufferedInputStream(in) : in;
        ++NBOPENFILE;
    }

    public void setFileName(String file) {
        this.filename = file;
    }

    public String getFileName() {
        return this.filename;
    }

    @Override
    public void close() throws IOException {
        --NBOPENFILE;
        this.in.close();
    }

    protected static long NativeImage() {
        return 1073807366L;
    }

    public MyInputStream startRead() throws IOException, Exception {
        long t = this.getGZorBzip2();
        if ((t & 0x20L) != 0L) {
            return new MyInputStream(new GZIPInputStream(this), 32L, this.withBuffer);
        }
        if ((t & 0x8000000000L) != 0L) {
            return new MyInputStream(new Bzip2(this), 0x8000000000L, this.withBuffer);
        }
        return this;
    }

    public long getPos() {
        return this.sizeAlreadyRead;
    }

    public void resetType() {
        this.type = this.type & 0x20L | this.type & 0x20000L;
        this.alreadyRead = false;
        this.flagGetType = false;
        this.resetFitsKeys();
        this.fitsHeadRead = false;
    }

    public boolean isHCOMP() throws Exception {
        return (this.getType() & 0x10L) != 0L;
    }

    public boolean isGZ() throws IOException {
        return (this.getGZorBzip2() & 0x20L) != 0L;
    }

    public long getGZorBzip2() throws IOException {
        if (this.flagGetType && this.alreadyRead) {
            return this.type;
        }
        if (this.alreadyRead) {
            return 0L;
        }
        int[] c = new int[2];
        if (this.availableInCache < c.length) {
            this.loadInCache(c.length);
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.cache[this.nextReadInCache + i] & 0xFF;
        }
        if (c[0] == 31 && c[1] == 139) {
            return 32L;
        }
        if (c[0] == 66 && c[1] == 90) {
            return 0x8000000000L;
        }
        return 0L;
    }

    private boolean isFitsRGB() throws IOException {
        if (this.hasFitsKey("CTYPE3", "RGB")) {
            return true;
        }
        if (!this.hasFitsKey("BITPIX", "8")) {
            return false;
        }
        try {
            int naxis = Integer.parseInt(this.getFitsValue("NAXIS"));
            if (naxis != 3) {
                return false;
            }
            int naxis1 = Integer.parseInt(this.getFitsValue("NAXIS1"));
            int naxis2 = Integer.parseInt(this.getFitsValue("NAXIS2"));
            int naxis3 = Integer.parseInt(this.getFitsValue("NAXIS3"));
            if (naxis1 == 3 && naxis2 == naxis3) {
                return true;
            }
            if (naxis2 == 3 && naxis1 == naxis3) {
                return true;
            }
            if (naxis3 == 3 && naxis1 == naxis2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void getTypeFitsImg() throws IOException {
        String snaxis = this.getFitsValue("NAXIS");
        String snaxis1 = this.getFitsValue("NAXIS1");
        String snaxis2 = this.getFitsValue("NAXIS2");
        String snaxis3 = this.getFitsValue("NAXIS3");
        if ("3".equals(snaxis) && !"1".equals(snaxis2) || "4".equals(snaxis) && !"1".equals(snaxis3) && this.hasFitsKey("NAXIS4", "1")) {
            this.type |= 0x2000000L;
        }
        if (this.hasFitsKey("COLORMOD", "ARGB")) {
            this.type |= 0x400000000L;
        }
        if (this.hasFitsKey("EXTEND", null) || "0".equals(snaxis)) {
            this.type |= 0x20000L;
        }
        if (this.isFitsRGB()) {
            this.type |= 0x200000L;
        }
        if ((this.type & 0x2200000L) == 0L) {
            try {
                int naxis1 = Integer.parseInt(snaxis1);
                int naxis2 = Integer.parseInt(snaxis2);
                int npix = Integer.parseInt(this.getFitsValue("BITPIX"));
                long mem = (long)naxis1 * (long)naxis2 * (long)(Math.abs(npix) / 8);
                if (mem > Aladin.LIMIT_HUGEFILE) {
                    this.type |= 0x8000000L;
                }
            }
            catch (Exception naxis1) {
                // empty catch block
            }
        }
        if ((this.type & 0x20000L) != 0L) {
            String o = this.getFitsValue("ORDERING");
            int tfields = 1;
            try {
                tfields = Integer.parseInt(this.getFitsValue("TFIELDS"));
            }
            catch (Exception npix) {
                // empty catch block
            }
            if (tfields == 1 && (this.hasFitsKey("MOCORD_T", null) || this.hasFitsKey("MOCORDER", null) || this.hasFitsKey("HPXMOC", null) || this.hasFitsKey("HPXMOCM", null) || "UNIQ".equals(o) || "NUNIQ".equals(o) || "RANGE".equals(o))) {
                String m = this.getFitsValue("MOCDIM");
                if (m == null) {
                    m = this.getFitsValue("MOC");
                }
                if ("SPACE".equals(m)) {
                    this.type |= 0x1000000000L;
                } else if ("TIME".equals(m)) {
                    this.type |= 0x4000000000000L;
                } else if ("FREQUENCY".equals(m)) {
                    this.type |= 0x10000000000000L;
                } else if ("TIME.SPACE".equals(m)) {
                    this.type |= 0x8000000000000L;
                } else if ("FREQUENCY.SPACE".equals(m)) {
                    this.type |= 0x20000000000000L;
                } else if ("SPACETIME".equals(m)) {
                    this.type |= 0x8000000000000L;
                } else {
                    boolean timeSys = this.hasFitsKey("TIMESYS", null);
                    boolean cooSys = this.hasFitsKey("COORDSYS", null);
                    this.type = timeSys && !cooSys ? (this.type |= 0x4000000000000L) : (timeSys && cooSys ? (this.type |= 0x8000000000000L) : (this.type |= 0x1000000000L));
                }
            } else if ((this.hasFitsKey("PIXTYPE", "HEALPIX") || "NEST".equals(o) || "RING".equals(o)) && !this.hasFitsKey("XTENSION", "IMAGE")) {
                this.type |= 0x100000000L;
                if ("NUNIQ".equals(o)) {
                    this.type |= 0x40000000000000L;
                }
            }
        }
        if ((this.type & 0x20000L) != 0L) {
            this.findFitsEnd2();
            if (this.getFitsValue("ZCMPTYPE") != null) {
                this.type |= 0x80000000L;
                if (this.getFitsValue("ZNAXIS3") != null) {
                    this.type |= 0x2000000L;
                }
            }
        } else {
            int n = this.findFitsEnd();
            int c0 = this.cache[n] & 0xFF;
            int c1 = this.cache[n + 1] & 0xFF;
            if (c0 == 221 && c1 == 153) {
                this.type |= 0x10L;
            }
        }
    }

    public long getType() throws Exception {
        return this.getType(0);
    }

    public long getType(int limit) throws Exception {
        block64: {
            if (this.flagGetType) {
                return this.type;
            }
            this.flagGetType = true;
            if (this.alreadyRead) {
                return 16384L;
            }
            try {
                long t;
                int i;
                int[] c = new int[16];
                try {
                    if (this.availableInCache < c.length) {
                        this.loadInCache(c.length);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                if (this.availableInCache == 0) {
                    throw new EOFException();
                }
                for (i = 0; i < c.length; ++i) {
                    c[i] = this.cache[this.nextReadInCache + i] & 0xFF;
                }
                if (this.availableInCache >= 3 && c[0] == 239 && c[1] == 187 && c[2] == 191) {
                    Aladin.trace(3, "BOM UTF-8 detected and skipped");
                    for (i = 0; i < 3; ++i) {
                        this.read();
                    }
                    System.arraycopy(c, 3, c, 0, c.length - 3);
                }
                if (this.availableInCache >= 2 && c[0] == 31 && c[1] == 139) {
                    this.type |= 0x20L;
                    break block64;
                }
                if (Aladin.PROTO && this.availableInCache >= 2 && c[0] == 66 && c[1] == 90) {
                    this.type |= 0x8000000000L;
                    break block64;
                }
                if (this.availableInCache >= 3 && c[0] == 80 && c[1] == 68 && c[2] == 83) {
                    this.type |= 0x800000000L;
                    break block64;
                }
                if (this.availableInCache >= 5 && c[0] == 79 && c[1] == 82 && c[2] == 68 && c[3] == 69 && c[4] == 82) {
                    this.type |= 0x1000000000L;
                    break block64;
                }
                if (this.availableInCache >= 3 && (t = this.isAsciiOrJsonMoc(c, this.availableInCache)) >= 0L) {
                    this.type |= t;
                    break block64;
                }
                if (this.availableInCache >= 13 && c[0] == 35 && c[1] == 32 && c[2] == 82 && c[3] == 101 && c[4] == 103 && c[5] == 105 && c[6] == 111 && c[7] == 110 && c[8] == 32 && c[9] == 102 && c[10] == 105 && c[11] == 108 && c[12] == 101) {
                    this.type |= 0x2000000400L;
                    break block64;
                }
                if (this.availableInCache >= 7 && c[0] == 35 && c[1] == 72 && c[2] == 80 && c[3] == 88 && c[4] == 77 && c[5] == 79 && c[6] == 67) {
                    this.type |= 0x1000000000L;
                    break block64;
                }
                if (this.availableInCache >= 7 && c[0] == 35 && c[1] == 77 && c[2] == 79 && c[3] == 67 && c[4] == 79 && c[5] == 82 && c[6] == 68) {
                    this.type |= 0x1000000000L;
                    break block64;
                }
                if (this.availableInCache >= 2 && c[0] == 255 && c[1] == 216) {
                    this.type |= 2L;
                    this.lookForJpegCalib(limit);
                    break block64;
                }
                if (this.availableInCache >= 6 && c[0] == 71 && c[1] == 73 && c[2] == 70 && c[5] == 97) {
                    this.type |= 4L;
                    break block64;
                }
                if (this.availableInCache >= 8 && c[0] == 137 && c[1] == 80 && c[2] == 78 && c[3] == 71 && c[4] == 13 && c[5] == 10 && c[6] == 26 && c[7] == 10) {
                    this.type |= 0x10000L;
                    this.lookForPNGCalib(limit);
                    break block64;
                }
                if (this.availableInCache >= 7 && c[0] == 1 && c[1] == 121 && c[2] == 1 && c[3] == 75 && c[4] == 1 && c[5] == 121 && c[6] == 64) {
                    this.type |= 8L;
                    if (this.lookForSignature("SIMPLE  =", false, false) > 0) {
                        this.type |= 1L;
                    }
                    break block64;
                }
                if (this.availableInCache >= 16 && c[0] == 88 && c[1] == 84 && c[2] == 69 && c[3] == 78 && c[4] == 83 && c[5] == 73 && c[6] == 79 && c[7] == 78 && c[8] == 61 && c[11] == 73 && c[12] == 77 && c[13] == 65 && c[14] == 71 && c[15] == 69) {
                    this.type |= 1L;
                    this.getTypeFitsImg();
                    break block64;
                }
                if (this.availableInCache >= 16 && c[0] == 88 && c[1] == 84 && c[2] == 69 && c[3] == 78 && c[4] == 83 && c[5] == 73 && c[6] == 79 && c[7] == 78 && c[8] == 61 && c[11] == 84 && c[12] == 65 && c[13] == 66 && c[14] == 76 && c[15] == 69) {
                    this.type |= 0x800000L;
                    break block64;
                }
                if (this.availableInCache >= 16 && c[0] == 88 && c[1] == 84 && c[2] == 69 && c[3] == 78 && c[4] == 83 && c[5] == 73 && c[6] == 79 && c[7] == 78 && c[8] == 61 && c[11] == 66 && c[12] == 73 && c[13] == 78 && c[14] == 84 && c[15] == 65) {
                    this.type |= 0x1000000L;
                    if (this.getFitsValue("ZCMPTYPE") != null) {
                        this.type |= 0x80000000L;
                        if (this.getFitsValue("ZNAXIS3") != null) {
                            this.type |= 0x2000000L;
                        }
                    } else if (this.hasFitsKey("EXTNAME", "AIPS CC") && this.hasFitsKey("TFIELDS", "3") && this.hasFitsKey("TTYPE2", "DELTAX") && this.hasFitsKey("TUNIT2", "DEGREES") && this.hasFitsKey("TTYPE3", "DELTAY") && this.hasFitsKey("TUNIT3", "DEGREES")) {
                        this.type |= 0x10000000L;
                    }
                    break block64;
                }
                if (this.availableInCache >= 9 && c[0] == 83 && c[1] == 73 && c[2] == 77 && c[3] == 80 && c[4] == 76 && c[5] == 69 && c[6] == 32 && c[7] == 32 && c[8] == 61) {
                    this.type |= 1L;
                    this.getTypeFitsImg();
                    break block64;
                }
                if (this.lookForSignature("\n%A", false, true, false, this.nextReadInCache, 2048, false) > 0 && this.lookForSignature("\n%U", false, true, false, this.nextReadInCache, 2048, false) > 0) {
                    this.type |= 0x200000000L;
                    break block64;
                }
                if (this.isProperties()) {
                    this.type |= 0x100000000000L;
                    break block64;
                }
                if (this.lookForSignature("<!DOCTYPE ASTRO", false) > 0) {
                    this.type |= 0xC0L;
                    break block64;
                }
                if (this.lookForSignature("<ALADINJAVA", false) > 0) {
                    this.type |= 0x240L;
                    break block64;
                }
                if (this.lookForSignature("<VOTABLE", true) > 0 || this.lookForSignature(":VOTABLE", true) > 0) {
                    this.type |= 0x140L;
                    if (this.lookForSignature("name=\"ObservingProgram\"", true) > 0 || this.lookForSignature("name=\"Observation_Group\"", true) > 0) {
                        this.type |= 0x840L;
                    } else if (this.lookForSignature("ucd=\"VOX:Image_Title\"", true) > 0 || this.lookForSignature("ucd=\"VOX:Image_AccessReference\"", true) > 0) {
                        this.type |= 0x1000L;
                    } else if (this.lookForSignature("SSAP</INFO>", true) > 0 || this.lookForSignature("utype=\"ssa:Access.Reference\"", true) > 0 || this.lookForSignature("Dataset.DataModel", true) > 0 && this.lookForSignature("Dataset.Length", true) > 0 && this.lookForSignature("Access.Reference", true) > 0 && this.lookForSignature("Access.Format", true) > 0 && this.lookForSignature("DataID.Title", true) > 0) {
                        this.type |= 0x200000000000L;
                    } else if (this.lookForSignature("name=\"FoVRef\"", true) > 0 || this.lookForSignature("ID=\"FoVRef\"", true) > 0 || this.lookForSignature("utype=\"dal:footprint.geom.id\"", true) > 0) {
                        this.type |= 0x40000L;
                    } else if (this.lookForSignature("utype=\"dal:fov", true) > 0 || this.lookForSignature("utype=\"dal:footprint.geom\"", true) > 0 || this.lookForSignature("utype=\"ivoa:characterization/[ucd=pos]/coverage/support", true) > 0) {
                        this.type |= 0x80000L;
                    } else if (this.lookForSignature("utype=\"photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value", true) > 0) {
                        this.type |= 0x4000000000L;
                    } else if (this.lookForSignature("name=\"ID\"", true) > 0 && this.lookForSignature("name=\"semantics", true) > 0 && this.lookForSignature("name=\"access_url", true) > 0 && this.lookForSignature("name=\"service_def", true) > 0) {
                        this.type |= 0x1000000000000L;
                    } else if (this.lookForSignature("utype=\"obscore:ObsDataset.dataProductType\"", true) > 0 || this.lookForSignature("utype=\"obscore:Access.Reference\"", true) > 0 || this.lookForSignature("utype=\"obscore:Access.Format\"", true) > 0) {
                        this.type |= 0x400000000000L;
                    } else if (this.lookForSignature("ID=\"c1min\"", true) > 0 && this.lookForSignature("ID=\"c1max\"", true) > 0 && this.lookForSignature("ID=\"c2min\"", true) > 0 && this.lookForSignature("ID=\"c2max\"", true) > 0) {
                        this.type |= 0x800000000000L;
                    }
                    break block64;
                }
                if (this.lookForSignature("#AJS", true) > 0) {
                    this.type |= 0x400L;
                    break block64;
                }
                int csv = this.isCSV();
                if (csv == 1) {
                    this.type |= 0x2000L;
                    break block64;
                }
                if (csv == 5) {
                    this.type |= 0x10000002000L;
                    break block64;
                }
                if (this.lookForSignature("#CATLIST", true) > 0) {
                    this.type |= 0x100000L;
                    break block64;
                }
                if (this.lookForSignature("^IMAGE", true) > 0) {
                    this.type |= 0x800000000L;
                    break block64;
                }
                if (csv == 4) {
                    this.type |= 0x20400000L;
                    break block64;
                }
                if (csv == 3) {
                    this.type |= 0x4400000L;
                    break block64;
                }
                if (csv == 2) {
                    this.type |= 0x400000L;
                    break block64;
                }
                if (this.lookForSignature("\"ivo://ivoa.net/std/DALI#examples\"", true) > 0) {
                    this.type |= 0x2000000000000L;
                    break block64;
                }
                return 16384L;
            }
            catch (EOFException e) {
                this.type |= 0x80000000000L;
            }
        }
        if (TEST_FITSKEY) {
            this.resetFitsKeys();
        }
        return this.type;
    }

    public long skipOnNext2880() throws IOException {
        long pos = this.getPos();
        if (pos % 2880L == 0L) {
            return 0L;
        }
        long offset = (pos / 2880L + 1L) * 2880L - pos;
        return this.skip(offset);
    }

    @Override
    public long skip(long n) throws IOException {
        this.alreadyRead = true;
        long m = n;
        while (n > 0L) {
            n -= this.skipInternal(n);
        }
        return m;
    }

    private long skipInternal(long n) throws IOException {
        if (this.availableInCache > 0) {
            if (n > (long)this.availableInCache) {
                n = this.availableInCache;
            }
            this.nextReadInCache += (int)n;
            this.availableInCache -= (int)n;
            this.sizeAlreadyRead += n;
            return n;
        }
        n = super.skip(n);
        this.sizeAlreadyRead += n;
        return n;
    }

    @Override
    public int available() throws IOException {
        if (this.availableInCache != 0) {
            return this.availableInCache;
        }
        return super.available();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int size) {
        this.markPos = this.nextReadInCache;
        this.markLen = size;
    }

    @Override
    public synchronized void reset() {
        if (this.markPos == -1) {
            return;
        }
        int comeBack = this.nextReadInCache - this.markPos;
        this.availableInCache += comeBack;
        this.sizeAlreadyRead -= (long)comeBack;
        this.nextReadInCache = this.markPos;
        this.markPos = -1;
    }

    @Override
    public int read() throws IOException {
        int rep = this.read(this.bufRead, 0, 1);
        return rep == -1 ? -1 : this.bufRead[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        this.alreadyRead = true;
        if (this.markPos != -1 && this.availableInCache < len) {
            int toBeRead = len - this.availableInCache;
            if (this.availableInCache + toBeRead > this.markLen) {
                throw new IOException("InputStream mark overflow");
            }
            this.loadInCache(toBeRead);
        }
        if (this.cache == null || this.availableInCache == 0) {
            int n = super.read(buf, offset, len);
            if (n < 0) {
                return n;
            }
            this.sizeAlreadyRead += (long)n;
            return n;
        }
        if (this.availableInCache < len) {
            len = this.availableInCache;
        }
        System.arraycopy(this.cache, this.nextReadInCache, buf, offset, len);
        this.nextReadInCache += len;
        this.availableInCache -= len;
        this.sizeAlreadyRead += (long)len;
        if (this.availableInCache == 0 && this.markPos == -1) {
            this.freeCache();
        }
        return len;
    }

    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    public void readFully(byte[] buf, int offset, int len) throws IOException {
        while (len > 0) {
            int m = this.read(buf, offset, len);
            if (m == -1) {
                throw new EOFException();
            }
            len -= m;
            offset += m;
        }
    }

    public byte[] readFully() {
        byte[] tmp;
        int size = 8192;
        ArrayList<byte[]> v = new ArrayList<byte[]>(1000);
        ArrayList<Integer> vSize = new ArrayList<Integer>(1000);
        int n = 0;
        int m = 0;
        int i = 0;
        int j = 0;
        try {
            tmp = new byte[size];
            while ((n = this.read(tmp, 0, size)) != -1) {
                ++i;
                v.add(tmp);
                vSize.add(new Integer(n));
                m += n;
                tmp = new byte[size];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] tab = new byte[m];
        j = v.size();
        n = 0;
        for (i = 0; i < j; ++i) {
            tmp = (byte[])v.get(i);
            m = (Integer)vSize.get(i);
            System.arraycopy(tmp, 0, tab, n, m);
            n += m;
        }
        return tab;
    }

    public String readLine() throws IOException {
        int n;
        try {
            n = this.findSignature("\n", false);
        }
        catch (EOFException eof) {
            if (this.availableInCache == 0) {
                return null;
            }
            n = this.nextReadInCache + this.availableInCache;
        }
        String s = new String(this.cache, this.nextReadInCache, n - this.nextReadInCache);
        this.sizeAlreadyRead += (long)(n - this.nextReadInCache);
        this.availableInCache -= n - this.nextReadInCache;
        this.nextReadInCache = n;
        return s;
    }

    public static String decodeType(long type) {
        StringBuilder s = new StringBuilder();
        long mode = 1L;
        for (int i = 1; i < FORMAT.length; ++i) {
            if ((type & mode) != 0L && mode != 0x80000000000L) {
                s.append(" " + FORMAT[i]);
            }
            mode <<= 1;
        }
        if (s.length() == 0) {
            s.append(FORMAT[0]);
        }
        return s.toString();
    }

    private void freeCache() {
        if (this.cache == null) {
            return;
        }
        this.cache = null;
        this.nextReadInCache = 0;
    }

    private void loadInCache(int len) throws IOException {
        int m;
        if (this.flagEOF) {
            throw new EOFException();
        }
        if (this.cache == null) {
            this.cache = new byte[65536];
        } else {
            int freeCache = this.cache.length - (this.nextReadInCache + this.availableInCache);
            if (len > freeCache) {
                int nByte = ((this.availableInCache + len) / 65536 + 1) * 65536;
                byte[] newCache = new byte[nByte];
                System.arraycopy(this.cache, this.nextReadInCache, newCache, 0, this.availableInCache);
                this.nextReadInCache = 0;
                this.cache = newCache;
            }
        }
        int offset = this.nextReadInCache + this.availableInCache;
        for (int n = 0; n < len; n += m) {
            m = super.read(this.cache, offset, len - n);
            if (m == -1) {
                this.flagEOF = true;
                throw new EOFException();
            }
            offset += m;
            this.availableInCache += m;
        }
    }

    private void substitute(int pos, int len, String s) throws Exception {
        char[] a = s.toCharArray();
        if (a.length > len || pos < this.nextReadInCache) {
            throw new Exception("MyInputStream substitution error");
        }
        int i = 0;
        int j = pos;
        while (i < a.length) {
            this.cache[j] = (byte)a[i];
            ++i;
            ++j;
        }
        System.arraycopy(this.cache, pos + len, this.cache, pos + a.length, this.availableInCache - (pos + len));
        this.availableInCache -= len - a.length;
    }

    private boolean isSextra(String s) {
        if (s.length() < 7) {
            return false;
        }
        if (s.charAt(0) != '#') {
            return false;
        }
        try {
            Integer.parseInt(s.substring(1, 5).trim());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static int[] count(String s, boolean flagQuote, boolean flagMalin) {
        int[] n = new int[128];
        boolean inQuote = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch;
            char c = s.charAt(i);
            if (flagQuote) {
                if (inQuote) {
                    if (c == '\\') {
                        ++i;
                    } else if (c == '\"') {
                        inQuote = false;
                    }
                } else {
                    boolean bl = inQuote = c == '\"';
                }
                if (inQuote) continue;
            }
            if (flagMalin && i == 0 || (ch = c) >= n.length) continue;
            char c2 = ch;
            n[c2] = n[c2] + 1;
        }
        return n;
    }

    private static int analyseCSV(String[] s, int size) {
        int c = MyInputStream.analyseCSV1(s, size, true);
        if (c == -1) {
            c = MyInputStream.analyseCSV1(s, size, false);
        }
        return c;
    }

    public static boolean isSimpleDashLine(String s) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    private static int analyseCSV1(String[] s, int size, boolean flagQuote) {
        int[][] m = new int[size][];
        for (int i = 0; i < size; ++i) {
            if (i == 1 && MyInputStream.isSimpleDashLine(s[i].trim())) {
                m[i] = m[i - 1];
                continue;
            }
            if (Aladin.levelTrace >= 4) {
                String s1 = s[i];
                if (s1.length() > 0 && s1.charAt(s1.length() - 1) == '\n') {
                    s1 = s1.substring(0, s1.length() - 1);
                }
                Aladin.trace(4, "analyseCSV (quoted=" + flagQuote + ") ligne " + i + " [" + s1 + "]");
            }
            m[i] = MyInputStream.count(s[i], flagQuote, true);
        }
        for (int k = 0; k < SEP.length(); ++k) {
            int j;
            char i = SEP.charAt(k);
            if (m[0][i] == 0) continue;
            for (j = 1; j < size && m[j][i] == m[j - 1][i]; ++j) {
            }
            if (j != size) continue;
            return i;
        }
        return -1;
    }

    private String translateSextraHeader(String head) {
        StringTokenizer st = new StringTokenizer(head, "\n\r");
        StringBuilder nHead = new StringBuilder();
        while (st.hasMoreTokens()) {
            String s;
            int i = (s = st.nextToken()).indexOf(32, 6);
            String name = s.substring(6, i < 0 ? s.length() : i);
            nHead.append("   " + name);
        }
        nHead.append("\n");
        return nHead.toString();
    }

    private boolean isMocAsciiSep(char ch) {
        return ch == ',' || ch == '-' || Character.isWhitespace(ch) || ch == 's' || ch == 't';
    }

    private long isAsciiOrJsonMoc(int[] c, int n) {
        if (n < 3) {
            return 0L;
        }
        int[] c1 = new int[Math.min(n, c.length)];
        int n1 = 0;
        boolean flagCDim = false;
        boolean flagJson = false;
        for (int i = 0; i < n && i < c.length; ++i) {
            int a = c[i];
            if (!flagJson) {
                if (Character.isSpace((char)a)) continue;
                if (a != 123 && a != 91) break;
                flagJson = true;
            }
            if (flagCDim && !Character.isDigit((char)a) || "{}[]\"".indexOf(a) >= 0) continue;
            boolean bl = flagCDim = a == 116 || a == 115;
            if (a == 44) {
                a = 32;
            }
            if (a == 58) {
                a = 47;
            }
            c1[n1++] = a;
        }
        if (flagJson) {
            c = c1;
            n = n1;
        }
        boolean space = false;
        boolean time = false;
        boolean freq = false;
        int mode = 1;
        block8: for (int i = 0; i < n && i < c.length; ++i) {
            char ch = (char)c[i];
            if (!space && ch == 's') {
                space = true;
            }
            if (!time && ch == 't') {
                time = true;
            }
            if (!freq && ch == 'f') {
                freq = true;
            }
            switch (mode) {
                case 1: {
                    if (this.isMocAsciiSep(ch)) continue block8;
                    mode = 2;
                }
                case 2: {
                    if (ch == '/') {
                        mode = 3;
                        continue block8;
                    }
                    if (Character.isDigit(ch)) continue block8;
                    return -1L;
                }
                case 3: {
                    if (this.isMocAsciiSep(ch)) continue block8;
                    mode = 4;
                    continue block8;
                }
                case 4: {
                    if (ch == '-' || this.isMocAsciiSep(ch)) {
                        mode = 5;
                        continue block8;
                    }
                    if (ch == '/') {
                        mode = 3;
                        continue block8;
                    }
                    if (Character.isDigit(ch)) continue block8;
                    return -1L;
                }
                case 5: {
                    if (ch == '/' || this.isMocAsciiSep(ch)) {
                        mode = 3;
                        continue block8;
                    }
                    if (Character.isDigit(ch)) continue block8;
                    return -1L;
                }
            }
        }
        long res = 0L;
        if (flagJson) {
            res = 0x80000000000000L;
        }
        return res | (space && time ? 0x8000000000000L : (space && freq ? 0x20000000000000L : (time ? 0x4000000000000L : (freq ? 0x10000000000000L : 0x1000000000L))));
    }

    private boolean isProperties() throws Exception {
        if (this.availableInCache < 65526) {
            try {
                this.loadInCache(65526);
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                throw e;
            }
        }
        int deb = this.nextReadInCache;
        int max = 3;
        int nLines = 0;
        int match = 0;
        int i = 0;
        while (nLines < max && deb != -1) {
            StringBuilder ligneb = new StringBuilder(256);
            deb = this.getLigne(ligneb, deb);
            String ligne = ligneb.toString();
            if (ligne.trim().length() != 0 && ligne.charAt(0) != '#') {
                int posEquals = ligne.indexOf(61);
                if (posEquals == -1) {
                    return false;
                }
                String key = ligne.substring(0, posEquals).trim();
                for (int j = key.length() - 1; j >= 0; --j) {
                    if (!Character.isSpace(key.charAt(j))) continue;
                    return false;
                }
                ++nLines;
                if (Util.indexInArrayOf(key, PROPKEY) >= 0) {
                    ++match;
                }
            }
            ++i;
        }
        return nLines == max || match > 0;
    }

    /*
     * Exception decompiling
     */
    private int isCSV() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public char getSepCSV() {
        return this.sepCSV;
    }

    private void setSepCSV(char c) {
        this.sepCSV = c;
    }

    private int getLigne(StringBuilder s, int offset) throws Exception {
        char ch;
        do {
            int c;
            if ((c = this.getValAt(offset++)) == -1) {
                return -1;
            }
            ch = (char)c;
            if (ch == '\r') continue;
            s.append(ch);
        } while (ch != '\n');
        return offset;
    }

    private int getValAt(int pos) throws Exception {
        try {
            while (this.nextReadInCache + pos >= this.availableInCache && !this.flagEOF) {
                this.loadInCache(8192);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.nextReadInCache + pos >= this.availableInCache && this.flagEOF) {
            return -1;
        }
        try {
            return this.cache[this.nextReadInCache + pos] & 0xFF;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String H(int b) {
        return "" + HEX.charAt(b / 16) + HEX.charAt(b % 16);
    }

    private String ASC(byte[] buf, int pos, int size) {
        StringBuilder s = new StringBuilder();
        for (int i = pos; i < pos + size; ++i) {
            char c = (char)buf[i];
            s.append(!Character.isISOControl(c) ? c : (char)'.');
            if (i % 80 != 0 || size >= 80 && i <= 0) continue;
            s.append("\n        ");
        }
        return s + "";
    }

    private String lz77Uncompress(byte[] tmp) throws Exception {
        int n;
        ByteArrayInputStream in = new ByteArrayInputStream(tmp);
        InflaterInputStream zIn = new InflaterInputStream(in);
        byte[] buffer = new byte[8192];
        StringBuilder res = new StringBuilder();
        while ((n = zIn.read(buffer)) != -1) {
            String s = new String(buffer, 0, n);
            res.append(s);
        }
        zIn.close();
        return res.toString();
    }

    private boolean memoPNGCalib(int pos, int size, boolean compress) {
        return this.memoPNGCalib(this.cache, pos, size, compress);
    }

    private boolean memoPNGCalib(byte[] cache, int pos, int size, boolean compress) {
        while (cache[pos] != 0 && size > 1) {
            ++pos;
            --size;
        }
        ++pos;
        --size;
        if (!compress) {
            this.commentCalib = new String(cache, pos, size);
        } else {
            try {
                byte[] tmp = new byte[--size];
                System.arraycopy(cache, ++pos, tmp, 0, size);
                this.commentCalib = this.lz77Uncompress(tmp);
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        if (this.commentCalib.indexOf("Spatial") >= 0) {
            try {
                Tok tok = new Tok(this.commentCalib, "\n:");
                this.commentCalib = null;
                while (tok.hasMoreTokens()) {
                    this.memoOneAVM(new StringBuilder(tok.nextToken()), new StringBuilder(tok.nextToken()));
                }
            }
            catch (Exception exception) {}
        } else if (this.commentCalib.indexOf("CTYPE1") < 0) {
            this.commentCalib = null;
            return false;
        }
        return true;
    }

    private boolean memoJpegCalib(int pos, int size) {
        return this.memoJpegCalib(pos, size, this.cache);
    }

    private boolean memoJpegCalib(int pos, int size, byte[] cache) {
        this.commentCalib = new String(cache, pos, size);
        if (this.commentCalib.indexOf("CTYPE1") < 0) {
            this.commentCalib = null;
            return false;
        }
        return true;
    }

    private void memoOneAVM(StringBuilder key, StringBuilder val) {
        String value = val.toString().trim();
        if (value.length() == 0) {
            return;
        }
        if (this.avm == null) {
            this.avm = new Hashtable(30);
        }
        this.avm.put(key.toString().trim(), value);
        if (Aladin.levelTrace >= 3) {
            System.out.println("AVM tag: " + key + "=[" + value + "] ");
        }
    }

    private void appendValue(StringBuilder buf, char c) {
        int n = buf.length();
        if (c == '\n' || c == '\r') {
            c = (char)32;
        }
        if (n == 0 || !Character.isSpaceChar(c)) {
            buf.append(c);
            return;
        }
        char x = buf.charAt(n - 1);
        if (Character.isSpaceChar(x)) {
            return;
        }
        buf.append(c);
    }

    private boolean memoXMPAVMCalib(int pos, int size) {
        return this.memoXMPAVMCalib(pos, size, this.cache);
    }

    private boolean memoXMPAVMCalib(int pos, int size, byte[] cache) {
        boolean rep = false;
        int mode = 0;
        int omode = -1;
        int depth = 0;
        this.avm = null;
        this.avmRefWidth = -1.0;
        StringBuilder key = null;
        StringBuilder value = null;
        boolean flagXMP2 = false;
        boolean flag0 = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        block10: for (int i = 0; i < size; ++i) {
            char c = (char)cache[pos + i];
            switch (mode) {
                case 0: {
                    flag4 = flag3 && c == ':';
                    flag3 = flag2 && c == 'm';
                    flag2 = flag1 && c == 'v';
                    flag1 = flag0 && c == 'a';
                    boolean bl = flag0 = c == '<' || c == ' ';
                    if (flag0) {
                        boolean bl2 = flagXMP2 = c == ' ';
                    }
                    if (!flag4) continue block10;
                    key = new StringBuilder();
                    if (!flagXMP2) {
                        mode = 1;
                        depth = 1;
                        continue block10;
                    }
                    mode = 10;
                    continue block10;
                }
                case 1: {
                    if (c == '>') {
                        mode = 2;
                        value = new StringBuilder();
                        continue block10;
                    }
                    key.append(c);
                    continue block10;
                }
                case 2: {
                    if (c == '<') {
                        mode = 3;
                        continue block10;
                    }
                    this.appendValue(value, c);
                    continue block10;
                }
                case 3: {
                    depth = c == '/' ? --depth : ++depth;
                    mode = 4;
                    continue block10;
                }
                case 4: {
                    if (c == '>') {
                        if (flag0) {
                            --depth;
                        }
                        if (depth == 0) {
                            this.memoOneAVM(key, value);
                            rep = true;
                            mode = 0;
                        } else {
                            this.appendValue(value, ' ');
                            mode = 2;
                        }
                    }
                    flag0 = c == ' ' ? flag0 : c == '/';
                    flag0 = c == '/';
                    continue block10;
                }
                case 10: {
                    if (c == '=') {
                        mode = 11;
                        value = new StringBuilder();
                        continue block10;
                    }
                    key.append(c);
                    continue block10;
                }
                case 11: {
                    if (c != '\"') continue block10;
                    mode = 12;
                    continue block10;
                }
                case 12: {
                    if (c == '\"') {
                        this.memoOneAVM(key, value);
                        rep = true;
                        mode = 0;
                        continue block10;
                    }
                    this.appendValue(value, c);
                }
            }
        }
        return rep;
    }

    private void createAVMCalib(int width) {
        Tok st;
        String s1;
        StringBuilder fits = new StringBuilder(1000);
        double ratio = 1.0;
        fits.append("COMMENT FITS header built by Aladin from AVM tags\n");
        String projs = this.avm.get("Spatial.CoordsystemProjection");
        if (projs == null) {
            projs = this.avm.get("Spatial Coordsystem Projection");
        }
        if (projs == null) {
            projs = "TAN";
        }
        String slon = "RA---";
        String slat = "DEC--";
        String s = this.avm.get("Spatial.CoordinateFrame");
        if (s == null) {
            s = this.avm.get("Spatial Coordinate Frame");
        }
        if (s != null) {
            if (s.equals("GAL")) {
                slon = "GLON-";
                slat = "GLAT-";
            } else if (s.equals("ECL")) {
                slon = "ELON-";
                slat = "ELAT-";
            }
            if (s.equals("SGAL")) {
                slon = "SLON-";
                slat = "SLAT-";
            }
        }
        fits.append("CTYPE1  = '" + slon + projs + "'\n");
        fits.append("CTYPE2  = '" + slat + projs + "'\n");
        try {
            s1 = this.avm.get("Spatial.ReferenceDimension");
            if (s1 == null) {
                s1 = this.avm.get("Spatial Reference Dimension");
            }
            st = new Tok(s1, " ,");
            ratio = (double)width / Double.parseDouble(st.nextToken());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s1 = this.avm.get("Spatial.ReferencePixel");
            if (s1 == null) {
                s1 = this.avm.get("Spatial Reference Pixel");
            }
            st = new Tok(s1, " ,");
            fits.append("CRPIX1  = " + Double.parseDouble(st.nextToken()) * ratio + "\n");
            fits.append("CRPIX2  = " + Double.parseDouble(st.nextToken()) * ratio + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s1 = this.avm.get("Spatial.ReferenceValue");
            if (s1 == null) {
                s1 = this.avm.get("Spatial Reference Value");
            }
            st = new Tok(s1, " ,");
            fits.append("CRVAL1  = " + st.nextToken() + "\n");
            fits.append("CRVAL2  = " + st.nextToken() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s1 = this.avm.get("Spatial.Scale");
            if (s1 == null) {
                s1 = this.avm.get("Spatial Scale");
            }
            st = new Tok(s1, " ,");
            fits.append("CDELT1  = " + Double.parseDouble(st.nextToken()) / ratio + "\n");
            fits.append("CDELT2  = " + Double.parseDouble(st.nextToken()) / ratio + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s1 = this.avm.get("Spatial.CDMatrix");
            if (s1 == null) {
                s1 = this.avm.get("Spatial CDMatrix");
            }
            st = new Tok(s1, " ,");
            fits.append("CD1_1   = " + st.nextToken() + "\n");
            fits.append("CD1_2   = " + st.nextToken() + "\n");
            fits.append("CD2_1   = " + st.nextToken() + "\n");
            fits.append("CD2_2   = " + st.nextToken() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = this.avm.get("Spatial.Rotation");
        if (s == null) {
            s = this.avm.get("Spatial Rotation");
        }
        if (s != null) {
            fits.append("CROTA2  = " + s + "\n");
        }
        if ((s = this.avm.get("Spatial.Equinox")) == null) {
            s = this.avm.get("Spatial Equinox");
        }
        if (s != null) {
            fits.append("EQUINOX = " + s + "\n");
        }
        if ((s = this.avm.get("Spatial.CoordinateFrame")) == null) {
            s = this.avm.get("Spatial Coordinate Frame");
        }
        if (s != null && (s.equals("FK4") || s.equals("FK5") || s.equals("ICRS"))) {
            fits.append("RADECSYS= " + s + "\n");
        }
        fits.append("COMMENT Original AVM tags:\n");
        Enumeration<String> e = this.avm.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String val = this.avm.get(key);
            s = "COMMENT " + key + "=" + val + "\n";
            if (s.length() > 80) {
                s = s.substring(0, 79) + "\n";
            }
            fits.append(s);
        }
        this.commentCalib = fits.toString();
    }

    protected void appendNAXIS2Calib(int width, int height) {
        if (this.avm != null) {
            this.createAVMCalib(width);
        }
        if (this.commentCalib == null) {
            return;
        }
        this.commentCalib = "SIMPLE  = T\nBITPIX  = 8\nNAXIS   = 2\nNAXIS1  = " + width + "\nNAXIS2  = " + height + "\n" + this.commentCalib;
    }

    protected FrameHeaderFits createFrameHeaderFitsFromCommentCalib(Plan plan) {
        return new FrameHeaderFits(plan, this.commentCalib);
    }

    public HeaderFits createHeaderFitsFromCommentCalib(int width, int height) throws Exception {
        HeaderFits headerFits;
        try {
            headerFits = new HeaderFits(this.commentCalib);
        }
        catch (Exception e) {
            this.appendNAXIS2Calib(width, height);
            headerFits = new HeaderFits(this.commentCalib);
        }
        return headerFits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeaderFits fastExploreCommentOrAvmCalib(String filename) throws Exception {
        HeaderFits headerFits;
        block12: {
            headerFits = null;
            RandomAccessFile file = null;
            try {
                file = new RandomAccessFile(filename, "rw");
                if ((this.type & 2L) != 0L) {
                    this.fastExploreJpg(file);
                    break block12;
                }
                if ((this.type & 0x10000L) != 0L) {
                    this.fastExplorePNG(file);
                    break block12;
                }
                HeaderFits headerFits2 = null;
                return headerFits2;
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return headerFits;
    }

    private boolean fastExploreJpg(RandomAccessFile file) throws Exception {
        int c;
        file.seek(2L);
        while ((c = file.read()) != -1) {
            byte[] buf;
            if (c != 255) {
                return false;
            }
            int mode = file.read();
            int size = file.read() << 8 | file.read();
            long pos = file.getFilePointer();
            if (mode == 225) {
                buf = new byte[size - 2];
                file.readFully(buf);
                if (this.memoXMPAVMCalib(0, buf.length, buf)) {
                    return true;
                }
            } else if (mode == 254) {
                buf = new byte[size - 2];
                file.readFully(buf);
                if (this.memoJpegCalib(0, buf.length, buf)) {
                    return true;
                }
            }
            file.seek(pos + (long)size - 2L);
        }
        return false;
    }

    private boolean fastExplorePNG(RandomAccessFile file) throws Exception {
        file.seek(8L);
        boolean encore = true;
        while (encore) {
            try {
                int size = this.g(file) << 24 | this.g(file) << 16 | this.g(file) << 8 | this.g(file);
                String chunk = new String(new char[]{(char)this.g(file), (char)this.g(file), (char)this.g(file), (char)this.g(file)});
                if (chunk.equals("tEXt") || chunk.equals("zTXt")) {
                    byte[] buf = new byte[size];
                    file.readFully(buf, 0, size);
                    if (this.memoPNGCalib(buf, 0, size, chunk.charAt(0) == 'z')) {
                        return true;
                    }
                } else {
                    file.skipBytes(size);
                }
                if (chunk.equals("IEND")) {
                    encore = false;
                }
                file.skipBytes(4);
            }
            catch (IOException e) {
                encore = false;
            }
        }
        return false;
    }

    private int g(RandomAccessFile file) throws Exception {
        return file.read() & 0xFF;
    }

    public boolean hasCommentCalib() {
        return this.commentCalib != null || this.avm != null;
    }

    public boolean hasCommentAVM() {
        return this.avm != null;
    }

    private boolean lookForJpegCalib(int limit) {
        block9: {
            int i = 2;
            try {
                while (this.getValAt(i) == 255 && (limit <= 0 || this.availableInCache < limit)) {
                    int mode = this.getValAt(i + 1);
                    int size = this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
                    try {
                        while (this.nextReadInCache + i + 2 + size >= this.availableInCache) {
                            this.loadInCache(8192);
                        }
                    }
                    catch (EOFException eOFException) {
                        // empty catch block
                    }
                    if (mode == 225) {
                        this.memoXMPAVMCalib(this.nextReadInCache + i + 4, size - 2);
                    } else if (mode == 254 && this.memoJpegCalib(this.nextReadInCache + i + 4, size - 2)) {
                        return true;
                    }
                    i += size + 2;
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block9;
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean lookForPNGCalib(int limit) {
        block20: {
            boolean encore = true;
            int i = 8;
            boolean more = true;
            try {
                while (encore && (limit <= 0 || this.availableInCache < limit)) {
                    int size = this.getValAt(i) << 24 | this.getValAt(i + 1) << 16 | this.getValAt(i + 2) << 8 | this.getValAt(i + 3);
                    String chunk = new String(new char[]{(char)this.getValAt(i + 4), (char)this.getValAt(i + 5), (char)this.getValAt(i + 6), (char)this.getValAt(i + 7)});
                    try {
                        if (more) {
                            while (this.nextReadInCache + i + 8 + size >= this.availableInCache) {
                                this.loadInCache(8192);
                            }
                        } else if (this.nextReadInCache + i + 8 + size >= this.availableInCache) {
                            encore = false;
                        }
                    }
                    catch (EOFException e) {
                        more = false;
                    }
                    if (chunk.equals("tEXt")) {
                        if (this.memoPNGCalib(this.nextReadInCache + i + 8, size, false)) {
                            return true;
                        }
                    } else if (chunk.equals("zTXt")) {
                        if (this.memoPNGCalib(this.nextReadInCache + i + 8, size, true)) {
                            return true;
                        }
                    } else if (chunk.equals("iTXt")) {
                        if (this.memoXMPAVMCalib(this.nextReadInCache + i + 8, size)) {
                            return true;
                        }
                        if (this.memoPNGCalib(this.nextReadInCache + i + 8, size, false)) {
                            return true;
                        }
                    } else if (chunk.equals("IEND")) {
                        encore = false;
                    }
                    i += size + 12;
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block20;
                e.printStackTrace();
            }
        }
        return false;
    }

    private int lookForSignature(String sig, boolean caseInsensitive) throws IOException {
        int rep = this.lookForSignature(sig, caseInsensitive, true, false, this.nextReadInCache, false);
        return rep;
    }

    private int lookForSignature(String sig, boolean caseInsensitive, boolean skipSpace) throws IOException {
        return this.lookForSignature(sig, caseInsensitive, skipSpace, false, this.nextReadInCache, false);
    }

    private int lookForSignature(String sig, boolean caseInsensitive, boolean skipSpace, boolean skip80, int offset, boolean flagEOF) throws IOException {
        return this.lookForSignature(sig, caseInsensitive, skipSpace, skip80, offset, -1, flagEOF);
    }

    private int lookForSignature(String sig, boolean caseInsensitive, boolean skipSpace, boolean skip80, int offset, int maxOffset, boolean flagEOF) throws IOException {
        int j;
        if (!TEST_SKIP80) {
            skip80 = false;
        }
        boolean EOF = false;
        if (maxOffset >= 0 && offset >= maxOffset) {
            return -1;
        }
        if (this.nextReadInCache + this.availableInCache - offset < 65526) {
            try {
                int oOffsetCache = this.nextReadInCache;
                this.loadInCache(65526);
                if (this.nextReadInCache == 0) {
                    offset -= oOffsetCache;
                }
            }
            catch (EOFException e) {
                EOF = true;
            }
            catch (IOException e) {
                throw e;
            }
        }
        char[] s = sig.toCharArray();
        int i = offset == 0 && s[0] == '\n' && s.length > 1 ? 1 : 0;
        for (j = offset - this.nextReadInCache; i < s.length && j < this.availableInCache; ++j) {
            char a = s[i];
            if (skipSpace) {
                while (j < this.availableInCache && this.isSpace((char)this.cache[this.nextReadInCache + j])) {
                    ++j;
                }
            }
            char b = (char)this.cache[this.nextReadInCache + j];
            if (caseInsensitive) {
                a = Character.toUpperCase(a);
                b = Character.toUpperCase(b);
            }
            if (a == b) {
                ++i;
            } else {
                if (skip80) {
                    int pos = 80 - j % 80;
                    j += pos;
                    --j;
                } else if (i > 0) {
                    --j;
                }
                i = 0;
            }
            if (!skipSpace) continue;
            while (i < s.length && this.isSpace(s[i])) {
                ++i;
            }
        }
        if (i == s.length) {
            return this.nextReadInCache + j;
        }
        if (EOF && flagEOF) {
            throw new EOFException();
        }
        return -1;
    }

    private final boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean isFitsVal(char c) {
        return !this.isSpace(c) && c != '/' && c != '\'';
    }

    private int findFitsEnd() throws IOException {
        if (this.fitsHeadRead) {
            return this.posAfterFitsHead;
        }
        this.posAfterFitsHead = this.findSignature("END", false, 1);
        if (TEST_FITSKEY) {
            this.resetFitsKeys();
            this.fitsHeadRead = true;
        }
        return this.posAfterFitsHead;
    }

    private int findFitsEnd2() throws IOException {
        if (this.fitsHeadRead) {
            return this.posAfterFitsHead;
        }
        this.posAfterFitsHead = this.findSignature("END", false, 2);
        if (TEST_FITSKEY) {
            this.resetFitsKeys();
            this.fitsHeadRead = true;
        }
        return this.posAfterFitsHead;
    }

    private boolean hasFitsKey(String key, String value) throws IOException {
        if (!TEST_FITSKEY) {
            return this.hasFitsKey1(key, value);
        }
        String val = this.getFitsValue(key);
        if (value == null) {
            return val != null;
        }
        return val != null && HeaderFits.unquoteFits(value).equals(val);
    }

    private boolean hasFitsKey1(String key, String value) throws IOException {
        if (!this.fitsHeadRead) {
            this.findFitsEnd();
        }
        int len = value == null ? -1 : value.length();
        int k = this.nextReadInCache;
        StringBuilder key1 = new StringBuilder(key);
        while (key1.length() < 8) {
            key1.append(' ');
        }
        key1.append('=');
        key = key1.toString();
        while ((k = this.lookForSignature(key, false, false, true, k, false)) >= 0) {
            int i = k;
            if ((i - 9) % 80 != 0) continue;
            if (len == -1) {
                return true;
            }
            while (!this.isFitsVal((char)this.cache[i]) && i < k + 71) {
                ++i;
            }
            int j = 0;
            while (j < len && value.charAt(j) == (char)this.cache[i]) {
                ++j;
                ++i;
            }
            if (j != len || this.isFitsVal((char)this.cache[i])) continue;
            return true;
        }
        return false;
    }

    private String getFitsValue(String sig) throws IOException {
        if (!TEST_FITSKEY) {
            return this.getFitsValue1(sig);
        }
        if (this.fitskey == null) {
            if (!this.fitsHeadRead) {
                this.findFitsEnd();
            }
            this.initFitskeys();
        }
        return this.fitskey.get(sig.trim());
    }

    private void resetFitsKeys() {
        this.fitskey = null;
    }

    private void initFitskeys() {
        block26: {
            this.fitskey = new HashMap();
            int i = 0;
            int mode = 0;
            int n = -1;
            int och = 32;
            boolean reset = false;
            boolean memo = false;
            boolean abort = false;
            boolean checkFirstKey = false;
            boolean flagQuote = false;
            int nbEnd = 0;
            try {
                StringBuilder key = new StringBuilder(10);
                StringBuilder val = new StringBuilder(70);
                while (!abort && i < this.availableInCache) {
                    ++n;
                    int codePoint = this.getValAt(i++);
                    if (i == -1) {
                        if (nbEnd > 0) break;
                        abort = true;
                        System.err.println("parseFits abort: end of file");
                        break;
                    }
                    if (!Character.isDefined(codePoint)) {
                        abort = true;
                        System.err.println("parseFits abort: codepoint undefined");
                        break;
                    }
                    char ch = (char)codePoint;
                    switch (mode) {
                        case 0: {
                            key.append(ch);
                            if (n != 7) break;
                            if (this.fitskey.size() == 0) {
                                checkFirstKey = true;
                            }
                            mode = 1;
                            break;
                        }
                        case 1: {
                            if (ch == '=') {
                                mode = 2;
                                break;
                            }
                            if (key.toString().trim().equals("END")) {
                                ++nbEnd;
                            }
                            reset = true;
                            break;
                        }
                        case 2: {
                            if (ch != ' ') {
                                if (nbEnd > 0) {
                                    return;
                                }
                                abort = true;
                                System.err.println("parseFits abort: missing blank [" + key + "]");
                                break;
                            }
                            mode = 3;
                            break;
                        }
                        case 3: {
                            if (ch == '\'') {
                                flagQuote = true;
                                och = ch;
                            }
                            mode = 4;
                        }
                        case 4: {
                            if (n == 80) {
                                memo = true;
                                break;
                            }
                            if (ch == '/' && !flagQuote) {
                                memo = true;
                                break;
                            }
                            if (ch == '\'' && och != 39) {
                                flagQuote = false;
                            }
                            val.append(ch);
                        }
                    }
                    if (checkFirstKey) {
                        String k = key.toString().trim();
                        if (!k.equals("SIMPLE") && !k.equals("XTENSION")) {
                            abort = true;
                            System.err.println("parseFits abort: not SIMPLE not XTENSION [" + k + "]");
                        }
                        checkFirstKey = false;
                    }
                    if (reset || memo) {
                        if (memo) {
                            String s = key.toString().trim();
                            String v = HeaderFits.unquoteFits(val.toString().trim()).trim();
                            this.fitskey.put(s, v);
                        }
                        i += 80 - n - 1;
                        n = -1;
                        mode = 0;
                        key = new StringBuilder(10);
                        val = new StringBuilder(70);
                        flagQuote = false;
                        reset = false;
                        memo = false;
                    }
                    och = ch;
                }
                if (abort) {
                    System.err.println("fitskey clear");
                    this.fitskey.clear();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block26;
                e.printStackTrace();
            }
        }
    }

    private String getFitsValue1(String key) throws IOException {
        if (!this.fitsHeadRead) {
            this.findFitsEnd();
        }
        StringBuilder key1 = new StringBuilder(key);
        while (key1.length() < 8) {
            key1.append(' ');
        }
        key1.append('=');
        key = key1.toString();
        int k = this.nextReadInCache;
        while ((k = this.lookForSignature(key, false, false, true, k, false)) >= 0) {
            char c;
            int i = k;
            if ((i - 9) % 80 != 0) continue;
            StringBuilder value = new StringBuilder();
            while (!this.isFitsVal((char)this.cache[i]) && i < k + 71) {
                ++i;
            }
            while (this.isFitsVal(c = (char)this.cache[i])) {
                value.append(c);
                ++i;
            }
            return value.toString();
        }
        return null;
    }

    private int findSignature(String sig, boolean caseInsensitive) throws IOException {
        return this.findSignature(sig, caseInsensitive, 0);
    }

    private int findSignature(String sig, boolean caseInsensitive, int methode) throws IOException {
        int n;
        int offset = this.nextReadInCache;
        int nbEnd = 0;
        do {
            boolean skip80 = false;
            boolean skipSpace = true;
            if (methode == 1 || methode == 2) {
                skipSpace = false;
                skip80 = true;
            }
            while ((n = this.lookForSignature(sig, caseInsensitive, skipSpace, skip80, offset, true)) < 0) {
                offset = this.nextReadInCache + this.availableInCache;
            }
            if (methode != 1) continue;
            if ((n - sig.length()) % 80 == 0) {
                int dataFits = (n / 80 + 1) * 80;
                try {
                    if (this.availableInCache < dataFits + 2) {
                        this.loadInCache(dataFits + 2 - this.availableInCache);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return dataFits;
            }
            if (methode == 2 && (n - sig.length()) % 80 == 0 && ++nbEnd == 2) {
                int dataFits = (n / 80 + 1) * 80;
                try {
                    if (this.availableInCache < dataFits + 2) {
                        this.loadInCache(dataFits + 2 - this.availableInCache);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return dataFits;
            }
            offset = n;
            n = -1;
        } while (n < 0);
        return n;
    }
}

