/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.MyBox;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.ViewSimple;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Localisation
extends MyBox {
    public static final int ICRS = 0;
    public static final int ICRSD = 1;
    public static final int ECLIPTIC = 2;
    public static final int GAL = 3;
    public static final int SGAL = 4;
    public static final int J2000 = 5;
    public static final int J2000D = 6;
    public static final int B1950 = 7;
    public static final int B1950D = 8;
    public static final int B1900 = 9;
    public static final int B1875 = 10;
    public static final int XY = 11;
    public static final int XYNAT = 12;
    public static final int XYLINEAR = 13;
    public static final int PLANET = 14;
    public static final int PLANETD = 15;
    static final String[] REPERE = new String[]{"ICRS", "ICRSd", "Ecliptic", "Gal", "SGal", "J2000", "J2000d", "B1950", "B1950d", "B1900", "B1875", "XY Fits", "XY image", "XY linear", "Planet", "Planet deg"};
    static final String[] FRAMEFOX = new String[]{"ICRS", "ICRS", "ECL", "GAL", "SGAL", "J2000", "J2000", "B1950", "B1950", "B1900", "B1875", "", "", "", "", ""};
    static final String[] RADECSYS = new String[]{"ICRS", "ICRS", null, null, null, "FK5", "FK5", "FK4", "FK4", "FK4", "FK4", null, null, null, null, null};
    static final String[] CTYPE1 = new String[]{"RA---", "RA---", "ELON-", "GLON-", "SLON-", "RA---", "RA---", "RA---", "RA---", "RA---", "RA---", null, null, "SOLAR", null, null};
    static final String[] CTYPE2 = new String[]{"DEC--", "DEC--", "ELAT-", "GLAT-", "SLAT-", "DEC--", "DEC--", "DEC--", "DEC--", "DEC--", "DEC--", null, null, "SOLAR", null, null};
    static final String[] FRAME = new String[]{"Default", REPERE[0], REPERE[2], REPERE[3], REPERE[4]};
    static final String[] FRAMEBIS = new String[]{"Equatorial", "Galactic", "Ecliptic", "SuperGal"};
    static final int[] FRAMEBISVAL = new int[]{Calib.FK5, Calib.GALACTIC, Calib.ECLIPTIC, Calib.SUPERGALACTIC};
    static final int[] FRAMEVAL = new int[]{0, 3, 2, 4};
    static final String NOREDUCTION = "No astrometrical reduction";
    static final String NOHPX = "No HEALPix map";
    static final String NOPROJECTION = "No proj => select " + REPERE[13];
    static final String NOXYLINEAR = "No XY linear trans.";
    protected static String POSITION;
    protected static String YOUROBJ;
    private int previousFrame = -1;
    private JPopupMenu popup = null;
    Astrocoo afs = new Astrocoo(AF_ICRS);
    boolean first = true;
    int posHist = -1;
    private String lastEditingCmd = null;
    private boolean flagReadyToClear = false;
    private boolean flagStopInfo = false;
    private int frame = 0;
    private Coord coo = new Coord();
    private String lastPosition = "";
    static final Astroframe AF_FK4;
    static final Astroframe AF_FK5;
    static final Astroframe AF_GAL;
    static final Astroframe AF_SGAL;
    static final Astroframe AF_ICRS;
    static final Astroframe AF_ECLI;
    static final Astroframe AF_FK4_1900;
    static final Astroframe AF_FK4_1875;
    private boolean flagCheckHistory = false;

    static JComboBox createFrameCombo() {
        return new JComboBox<String>(FRAME);
    }

    static JComboBox createFrameComboBis() {
        return new JComboBox<String>(FRAMEBIS);
    }

    static int getFrameComboBisValue(String s) {
        int i = Util.indexInArrayOf(s, FRAMEBIS, true);
        if (i < 0) {
            return 0;
        }
        return FRAMEBISVAL[i];
    }

    static int getFrameComboValue(String s) {
        int i = Util.indexInArrayOf(s, FRAMEBIS, true);
        if (i < 0) {
            return 0;
        }
        return FRAMEVAL[i];
    }

    static final boolean isSameFrame(int frame1, int frame2) {
        if (frame1 == 1 || frame1 == 6 || frame1 == 8) {
            --frame1;
        }
        if (frame2 == 1 || frame2 == 6 || frame2 == 8) {
            --frame2;
        }
        return frame1 == frame2;
    }

    protected Localisation() {
    }

    protected Localisation(Aladin aladin) {
        super(aladin, Aladin.chaine.getString("POSITION"));
        String tip = Aladin.chaine.getString("TIPCMD");
        Util.toolTip(this.pos, tip);
        Util.toolTip(this.label, tip);
        Util.toolTip(this.text, Aladin.chaine.getString("TIPCMD"));
        Util.toolTip(this.c, Aladin.chaine.getString("TIPPOSCHOICE"));
        POSITION = Aladin.chaine.getString("POSITION");
        YOUROBJ = Aladin.chaine.getString("YOUROBJ");
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Localisation.this.clearIfRequired();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Localisation.this.clearIfRequired();
                if (e.getKeyCode() == 10) {
                    Localisation.this.submit();
                }
            }
        });
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Localisation.this.flagReadyToClear = false;
                Localisation.this.setMode(0);
            }
        });
        this.pos.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Localisation.this.setMode(0);
            }
        });
        this.text.requestFocusInWindow();
    }

    @Override
    protected void setTextSaisie(String s) {
        this.first = true;
        super.setTextSaisie(s);
        this.text.select(0, this.text.getText().length());
    }

    @Override
    protected void sendKey(KeyEvent e) {
        String s;
        int key = e.getKeyCode();
        char k = e.getKeyChar();
        if (e.isControlDown() || e.isAltDown()) {
            return;
        }
        this.clearIfRequired();
        StringBuffer cmd = new StringBuffer(this.text.getText());
        if (key == 10) {
            s = this.shortCutLoad(cmd.toString());
            this.aladin.execAsyncCommand(s);
            this.first = true;
        } else if (key == 8 || key == 127) {
            this.first = false;
            if (cmd.length() > 0) {
                cmd.deleteCharAt(cmd.length() - 1);
            }
        } else if (key == 38 || key == 40 || key == 34) {
            String s1 = this.browseHistory(key == 34 ? 2 : (key == 38 ? -1 : 1));
            if (s1 != null) {
                cmd = new StringBuffer(s1);
            }
        } else {
            this.posHist = -1;
            if (this.first) {
                cmd.delete(0, cmd.length());
                this.first = false;
            }
            if (k >= '\u001f' && k <= '\u00ff' || k == '@') {
                cmd.append(k);
            }
        }
        this.setMode(0);
        s = cmd.toString();
        if (s.startsWith(this.aladin.GETOBJ)) {
            s = s.substring(this.aladin.GETOBJ.length());
        }
        super.setTextSaisie(s);
    }

    protected String browseHistory(int sens) {
        String s;
        boolean flagHead = false;
        if (this.aladin.console.getIndexArrowHistory() == -1) {
            this.lastEditingCmd = this.text.getText();
            flagHead = true;
        }
        if ((s = this.aladin.console.getNextArrowHistory(sens)) != null && flagHead && this.lastEditingCmd.equals(s)) {
            s = this.aladin.console.getNextArrowHistory(sens);
        }
        if (s == null) {
            s = this.lastEditingCmd;
            this.lastEditingCmd = null;
        }
        if (s == null) {
            return null;
        }
        this.first = false;
        return s;
    }

    protected void clearIfRequired() {
        this.flagStopInfo = true;
        if (!this.flagReadyToClear) {
            return;
        }
        this.flagReadyToClear = false;
        this.text.setText("");
    }

    @Override
    protected void readyToClear() {
        this.flagReadyToClear = true;
    }

    @Override
    protected void setMode(int mode) {
        ViewSimple v;
        super.setMode(mode);
        if (mode != 0 && (v = this.aladin.view.getCurrentView()) != null && !v.hasFocus()) {
            v.requestFocusInWindow();
        }
    }

    protected void focus(String s) {
        this.focus(s, null);
    }

    protected void focus(String s, final String initial) {
        this.setMode(0);
        this.text.setText(s);
        new Thread(){
            Color def;
            Color deff;
            {
                this.def = Localisation.this.text.getBackground();
                this.deff = Localisation.this.text.getForeground();
            }

            @Override
            public void run() {
                for (int i = 0; i < 2; ++i) {
                    Localisation.this.text.setBackground(Color.green);
                    Localisation.this.text.setForeground(Color.black);
                    Util.pause(1000);
                    Localisation.this.text.setBackground(this.def);
                    Localisation.this.text.setForeground(this.deff);
                    Util.pause(100);
                }
                if (initial == null) {
                    Localisation.this.text.setText("");
                    Localisation.this.text.requestFocusInWindow();
                } else {
                    Localisation.this.text.setText(initial);
                    Localisation.this.setInitialFocus();
                }
            }
        }.start();
    }

    protected void setInitialFocus() {
        this.setMode(0);
        this.text.requestFocusInWindow();
        this.text.setCaretPosition(this.text.getText().length());
    }

    private void myPause(int delai) {
        long start = System.currentTimeMillis();
        while (!this.flagStopInfo && System.currentTimeMillis() - start < (long)delai) {
            Util.pause(20);
        }
    }

    protected void infoStart() {
        if (!this.aladin.calque.isFree() || this.text.getText().length() > 0 || this.aladin.dialog == null || this.aladin.dialog.isVisible()) {
            return;
        }
        this.setMode(0);
        final String s = this.aladin.GETOBJ;
        this.text.setText(s);
        this.text.setFont(this.text.getFont().deriveFont(2));
        new Thread(){
            Color def;
            Color deff;
            {
                this.def = Localisation.this.text.getBackground();
                this.deff = Localisation.this.text.getForeground();
            }

            @Override
            public void run() {
                Localisation.this.flagReadyToClear = true;
                Localisation.this.text.setBackground(Aladin.COLOR_TEXT_BACKGROUND);
                for (int i = 0; i < 3 && Localisation.this.aladin.calque.isFree() && !Localisation.this.flagStopInfo; ++i) {
                    if (!Localisation.this.flagStopInfo) {
                        Localisation.this.text.setText("");
                        Localisation.this.text.setForeground(Color.black);
                        Localisation.this.myPause(100);
                    }
                    if (Localisation.this.flagStopInfo) continue;
                    Localisation.this.text.setText(s);
                    Localisation.this.myPause(1500);
                }
                if (Localisation.this.flagStopInfo) {
                    Localisation.this.text.setCaretPosition(Localisation.this.text.getText().length());
                    Localisation.this.flagReadyToClear = (Localisation.this.flagStopInfo = false);
                }
                Localisation.this.text.setText("");
                Localisation.this.text.setForeground(this.deff);
                Localisation.this.text.setBackground(this.def);
                Localisation.this.text.setFont(Localisation.this.text.getFont().deriveFont(1));
                Localisation.this.text.requestFocusInWindow();
            }
        }.start();
    }

    protected JComboBox createSimpleChoice() {
        JComboBox<String> c = new JComboBox<String>();
        int n = this.aladin.configuration.isPlanet() ? REPERE.length : REPERE.length - 2;
        for (int i = 0; i < n; ++i) {
            c.addItem(REPERE[i]);
        }
        return c;
    }

    @Override
    protected JComboBox createChoice() {
        final JComboBox c = super.createChoice();
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Localisation.this.setInternalFrame(c.getSelectedIndex());
            }
        });
        c.setPrototypeDisplayValue(new Integer(100000));
        c.setMaximumRowCount(REPERE.length);
        c.setFont(Aladin.PLAIN);
        int n = this.aladin.configuration.isPlanet() ? REPERE.length : REPERE.length - 2;
        for (int i = 0; i < n; ++i) {
            c.addItem(REPERE[i]);
        }
        c.setSelectedIndex(0);
        this.previousFrame = 0;
        return c;
    }

    protected boolean setPositionMode(String s) {
        if (s.equalsIgnoreCase("xy")) {
            s = REPERE[11];
        }
        for (int i = 0; i < REPERE.length; ++i) {
            if (!REPERE[i].equalsIgnoreCase(s)) continue;
            this.setFrame(i);
            this.actionChoice();
            return true;
        }
        return false;
    }

    private void setInternalFrame(int frame) {
        this.frame = frame;
    }

    protected void setFrame(int frame) {
        this.frame = frame;
        this.setChoiceIndex(frame);
    }

    protected String getFrameFox() {
        return FRAMEFOX[this.frame];
    }

    protected static boolean isFrameFox(String s) {
        return s != null && s.length() > 0 && Util.indexInArrayOf(s, FRAMEFOX, true) >= 0;
    }

    protected String getFrameName() {
        return Localisation.getFrameName(this.frame);
    }

    public static String getFrameName(int frame) {
        return frame < 0 ? "" : REPERE[frame];
    }

    protected int getFrame() {
        return this.frame;
    }

    protected static boolean hasFoxSuffix(String s) {
        String w;
        int i = s.lastIndexOf(32);
        return i > 0 && Localisation.isFrameFox(w = s.substring(i + 1));
    }

    protected static boolean notCoord(String s) {
        char c;
        String w;
        boolean flagFox = false;
        int i = s.lastIndexOf(32);
        if (i > 0 && Localisation.isFrameFox(w = s.substring(i + 1))) {
            s = s.substring(0, i).trim();
            flagFox = true;
        }
        char[] a = s.toCharArray();
        int n = a.length;
        if (!(flagFox || n <= 1 || (c = a[n - 1]) != 'N' && c != 'S' && c != 'E' && c != 'W')) {
            --n;
        }
        for (i = 0; i < n; ++i) {
            if (!(a[i] >= 'a' && a[i] <= 'z' || a[i] >= 'A' && a[i] <= 'Z') && a[i] != '/') continue;
            return true;
        }
        return false;
    }

    public int getFrameGeneric() {
        return this.frame == 3 ? 3 : (this.frame == 2 ? 2 : (this.frame == 4 ? 4 : (this.frame != 11 || this.frame != 12 || this.frame != 13 || this.frame != 14 ? 0 : -1)));
    }

    protected void setSesameResult(String s) {
        this.setTextSaisie(s);
        this.readyToClear();
    }

    protected void setPos(ViewSimple v, double x, double y) {
        this.setPos(v, x, y, 0);
    }

    protected void setPos(ViewSimple v, double x, double y, int methode) {
        this.setPos(v, x, y, methode, false);
    }

    protected void setPos(ViewSimple v, double x, double y, int methode, boolean sendPlasticMsg) {
        Plan plan;
        int frame = this.getFrame();
        ViewSimple view = this.aladin.view.getMouseView();
        boolean isPlotTime = false;
        if (view != null && view.isPlot()) {
            frame = 13;
            isPlotTime = view.isPlotTime();
        }
        if ((plan = v.pref) == null) {
            return;
        }
        Projection proj = v.getProj();
        PointD p = v.getPosition(x, y);
        String s = null;
        if (frame == 11 || proj != null && proj.modeCalib == 0) {
            s = plan.isImage() ? Util.myRound("" + (p.x + 0.5), 4) + "  " + Util.myRound("" + ((double)((PlanImage)plan).naxis2 - p.y + 0.5), 4) : "";
        } else if (frame == 12 || proj != null && proj.modeCalib == 0) {
            s = plan.isImage() ? Util.myRound("" + p.x, 0) + "  " + Util.myRound("" + p.y, 0) : "";
        } else if (!Projection.isOk(proj)) {
            s = NOREDUCTION;
        } else {
            this.coo.x = p.x;
            this.coo.y = p.y;
            proj.getCoord(this.coo);
            if (Double.isNaN(this.coo.al)) {
                s = "";
            } else if (frame == 14) {
                s = this.coo.getSexaPlanet();
            } else if (frame == 15) {
                s = this.coo.getDegPlanet();
            } else if (frame == 13) {
                s = !proj.isXYLinear() ? NOXYLINEAR : (isPlotTime ? Astrodate.JDToDate(this.coo.al) : Util.myRound(this.coo.al + "", 4) + " , " + Util.myRound(this.coo.del + "", 4));
            } else if (proj.isXYLinear()) {
                s = NOPROJECTION;
            } else {
                double r = v.getTailleRA();
                int precision = r == 0.0 ? 3 : (r > 0.001 ? 6 : (r > 1.0E-5 ? 7 : 9));
                s = this.J2000ToString(this.coo.al, this.coo.del, precision, false);
                if (Aladin.PLASTIC_SUPPORT && sendPlasticMsg) {
                    this.aladin.getMessagingMgr().pointAtCoords(this.coo.al, this.coo.del);
                }
            }
        }
        String string = this.lastPosition = s == NOREDUCTION ? "" : s;
        if (methode == 1) {
            this.setTextSaisie(s);
            this.setMode(0);
        } else {
            this.setTextAffichage(s);
            this.setMode(1);
        }
    }

    protected String getLastPosition() {
        return this.lastPosition;
    }

    protected Coord getLastCoord() {
        return this.coo;
    }

    protected Coord getLastCoordInCurrentFrame() {
        return this.ICRSToFrame(this.coo);
    }

    protected void setLastCoord(double ra, double dec) {
        this.coo = new Coord(ra, dec);
    }

    protected static Astroframe getAstroframe(int i) {
        return i == 0 || i == 1 ? AF_ICRS : (i == 3 ? AF_GAL : (i == 5 || i == 6 ? AF_FK5 : (i == 7 || i == 8 ? AF_FK4 : (i == 9 ? AF_FK4_1900 : (i == 10 ? AF_FK4_1875 : (i == 2 ? AF_ECLI : (i == 4 ? AF_SGAL : AF_ICRS)))))));
    }

    public static Coord frameToFrame(Coord c, int frameSrc, int frameDst) {
        if (frameSrc == frameDst) {
            return c;
        }
        Coo cTmp = new Coo(c.al, c.del);
        if (frameSrc != 0 && frameSrc != 1) {
            Localisation.getAstroframe(frameSrc).toICRS(cTmp);
        }
        if (frameDst != 0 && frameDst != 1) {
            Localisation.getAstroframe(frameDst).fromICRS(cTmp);
        }
        c.al = cTmp.getLon();
        c.del = cTmp.getLat();
        return c;
    }

    protected Coord ICRSToFrame(Coord c) {
        if (this.frame == 0 || this.frame == 1) {
            return c;
        }
        return Localisation.frameToFrame(c, 0, this.frame);
    }

    protected Coord frameToICRS(Coord c) {
        if (this.frame == 0 || this.frame == 1) {
            return c;
        }
        return Localisation.frameToFrame(c, this.frame, 0);
    }

    protected String getICRSCoord(String coo) {
        if (coo.length() == 0) {
            return coo;
        }
        return Localisation.convert(coo, this.frame, 0);
    }

    protected String getFrameCoord(String coo) {
        return Localisation.convert(coo, 0, this.frame);
    }

    protected static String convert(String coo, int frameSource, int frameTarget) {
        char c;
        String s;
        int f;
        String coo1 = coo;
        boolean flagFox = false;
        boolean flagPlaneto = false;
        if (coo == null || coo.length() == 0 || coo.indexOf("--") >= 0) {
            return "";
        }
        int i = coo.lastIndexOf(32);
        if (i >= 0 && (f = Util.indexInArrayOf(s = coo.substring(i + 1), FRAMEFOX, true)) >= 0) {
            frameSource = f;
            coo = coo.substring(0, i).trim();
            flagFox = true;
        }
        char[] a = coo.toCharArray();
        int n = a.length;
        if (!(flagFox || n <= 1 || (c = a[n - 1]) != 'N' && c != 'S' && c != 'E' && c != 'W')) {
            --n;
            flagPlaneto = true;
        }
        for (i = 0; i < n; ++i) {
            c = a[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                return coo1;
            }
            if (c != ',') continue;
            flagPlaneto = true;
        }
        if (flagPlaneto) {
            return coo1;
        }
        try {
            String s2;
            Astrocoo aft = new Astrocoo(Localisation.getAstroframe(frameSource));
            aft.set(coo);
            aft.setPrecision(11);
            if (frameSource != frameTarget) {
                aft.convertTo(Localisation.getAstroframe(frameTarget));
            }
            String string = s2 = frameTarget == 6 || frameTarget == 8 || frameTarget == 1 || frameTarget == 2 || frameTarget == 3 || frameTarget == 4 ? aft.toString("2d") : aft.toString("2s");
            if (s2.indexOf("--") >= 0) {
                return "";
            }
            return s2;
        }
        catch (Exception e) {
            return coo;
        }
    }

    protected String J2000ToString(double al, double del) {
        return this.J2000ToString(al, del, 11, false);
    }

    protected String J2000ToString(double al, double del, int precision, boolean withFox) {
        Coord cTmp = new Coord(al, del);
        cTmp = this.ICRSToFrame(cTmp);
        this.afs.setPrecision(precision);
        String rep = this.frameToString(cTmp.al, cTmp.del, precision);
        if (withFox) {
            rep = rep + " " + this.getFrameFox();
        }
        return rep;
    }

    protected String foxString(double al, double del) {
        return this.J2000ToString(al, del, 6, true);
    }

    protected String frameToString(double al, double del) {
        return this.frameToString(al, del, 6);
    }

    protected String frameToString(double al, double del, int precision) {
        int i = this.getFrame();
        this.afs.set(al, del);
        this.afs.setPrecision(precision);
        try {
            return i == 6 || i == 8 || i == 1 || i == 2 || i == 3 || i == 4 ? this.afs.toString("2d") : this.afs.toString("2:");
        }
        catch (Exception e) {
            System.err.println(e);
            return "";
        }
    }

    protected String getGridLabel(double al, double del, int indice) {
        int i = this.getFrame();
        if (i == 14 || i == 15) {
            String s = i == 15 ? new Coord(al, del).getDegPlanet() : new Coord(al, del).getSexaPlanet();
            if (s.length() == 0) {
                return "";
            }
            int offset = s.indexOf(44);
            return this.zeroSec(indice == 1 ? s.substring(0, offset) : s.substring(offset + 2));
        }
        String s = this.frameToString(al, del);
        if (s.length() == 0) {
            return "";
        }
        int offset = s.indexOf(32);
        return this.zeroSec(indice == 0 ? s.substring(0, offset) : s.substring(offset + 1));
    }

    private String zeroSec(String s) {
        int n = s.length();
        if (n == 0) {
            return s;
        }
        char c = s.charAt(n - 1);
        if (c != 'N' && c != 'S' && c != 'E' && c != 'W') {
            return this.zeroSec1(s);
        }
        return this.zeroSec1(s.substring(0, n - 2)) + s.substring(n - 2);
    }

    private String zeroSec1(String s) {
        char[] a = s.toCharArray();
        int flagDecimal = 0;
        int flagZero = 0;
        for (int i = a.length - 1; i > 0 && (a[i] < '1' || a[i] > '9'); --i) {
            if (a[i] == '.') {
                flagDecimal = i;
                continue;
            }
            if (a[i] == '0') {
                flagZero = i;
                continue;
            }
            if (a[i] == ':') {
                s = s.substring(0, i);
                return s;
            }
            if (a[i] != '\'') continue;
            if ((s = s.substring(0, i + 1)).endsWith("\u00b00'")) {
                s = s.substring(0, s.length() - 2);
            }
            return s;
        }
        if (flagDecimal > 0) {
            return s.substring(0, flagDecimal);
        }
        if (flagZero > 0) {
            return s.substring(0, flagZero + 1);
        }
        return s;
    }

    protected void seeCoord(Position o) {
        this.seeCoord(o, 0);
    }

    protected void seeCoord(Position o, int methode) {
        String s = this.getLocalisation(o);
        if (s == null) {
            return;
        }
        if (methode == 0) {
            this.setTextAffichage(s);
            this.setMode(1);
        } else {
            this.setTextSaisie(s);
            this.setMode(0);
            this.aladin.console.printInPad(s + "\n");
        }
    }

    protected String getLocalisation(Obj o) {
        String s = "";
        int frame = this.getFrame();
        switch (frame) {
            case 11: {
                ViewSimple v = this.aladin.view.getCurrentView();
                Projection proj = v.getProj();
                Coord c = new Coord(o.getRa(), o.getDec());
                proj.getXY(c);
                double x = c.x;
                double y = c.y;
                Plan plan = v.pref;
                if (plan.isImage()) {
                    s = Util.myRound("" + (x + 0.5), 2) + " " + Util.myRound("" + ((double)((PlanImage)plan).naxis2 - (y - 0.5)), 2);
                    break;
                }
                s = null;
                break;
            }
            default: {
                s = s + this.J2000ToString(o.getRa(), o.getDec());
            }
        }
        return s;
    }

    private boolean isFile(String s) {
        File f = new File(this.aladin.getFullFileName(s));
        return f.canRead();
    }

    private String shortCutLoad(String s) {
        if (s.startsWith("http://") || s.startsWith("https://") || s.startsWith("ftp://") || s.startsWith("file://") || this.isFile(s)) {
            s = "load " + s;
            this.setTextSaisie(s);
        }
        return s;
    }

    private void submit() {
        String s = this.getTextSaisie();
        if (s.length() > 0) {
            s = this.shortCutLoad(s);
            this.aladin.console.addLot(s);
        }
        this.readyToClear();
    }

    @Override
    protected void actionChoice() {
        block3: {
            if (this.text == null) {
                return;
            }
            try {
                this.aladin.calque.resumeFrame();
                this.previousFrame = this.getFrame();
                this.setTextSaisie(Localisation.convert(this.getTextSaisie(), this.previousFrame, this.getFrame()));
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    @Override
    protected void triangleAction(int x) {
        this.triangleAction(x, -1);
    }

    protected void triangleAction(final int x, int initIndex) {
        int max = 20;
        ArrayList<String> v = this.aladin.console.getRecentHistory(initIndex, max);
        if (v.size() == 0) {
            return;
        }
        this.popup = new JPopupMenu();
        for (String s : v) {
            JMenuItem mi = null;
            if (s.equals("...")) {
                mi = new JMenuItem(s);
                mi.setActionCommand("" + (initIndex + max));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            int index = Integer.parseInt(((JMenuItem)e.getSource()).getActionCommand());
                            Localisation.this.triangleAction(x, index);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                mi = new JMenuItemExt(s.length() > 80 ? s.substring(0, 78) + " ..." : s);
                mi.setActionCommand(s);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String s = ((JMenuItem)e.getSource()).getActionCommand();
                        Localisation.this.aladin.console.addLot(s);
                    }
                });
            }
            this.popup.add(mi);
        }
        this.setComponentPopupMenu(this.popup);
        this.popup.show(this, x - 50, this.getHeight());
    }

    @Override
    protected boolean isPopupVisible() {
        return this.c.isPopupVisible() || this.isPopupShown();
    }

    protected boolean isPopupShown() {
        if (this.popup == null) {
            return false;
        }
        return this.popup.isVisible();
    }

    @Override
    protected boolean hasTriangle() {
        if (!this.flagCheckHistory) {
            if (this.aladin.console.getRecentHistory(1).size() > 0) {
                this.flagCheckHistory = true;
            }
            return false;
        }
        return true;
    }

    static {
        AF_FK4 = Astroframe.create("FK4");
        AF_FK5 = Astroframe.create("FK5");
        AF_GAL = Astroframe.create("Galactic");
        AF_SGAL = Astroframe.create("Supergalactic");
        AF_ICRS = Astroframe.create("ICRS");
        AF_ECLI = Astroframe.create("Ecliptic");
        AF_FK4_1900 = Astroframe.create("FK4(B1900)");
        AF_FK4_1875 = Astroframe.create("FK4(B1875)");
    }

    class JMenuItemExt
    extends JMenuItem {
        JMenuItemExt(String s) {
            super(s);
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    String s = ((JMenuItem)e.getSource()).getActionCommand();
                    Localisation.this.setMode(0);
                    Localisation.this.setTextSaisie(s);
                }
            });
        }
    }
}

