/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Couleur;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.PlanHips;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.StatPixels;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomHist;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.moc.SMoc;
import cds.tools.FastMath;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class Ligne
extends Position {
    static final int L = 7;
    static final int DL = 4;
    protected byte bout;
    private StatPixels statPixels = new StatPixels();
    protected Color couleur = null;
    protected boolean hidden = false;
    protected Ligne debligne = null;
    protected Ligne finligne = null;
    private boolean flagLiveMesure = true;

    protected Ligne(Plan plan) {
        super(plan);
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y, 0.0, 0.0, 5, null);
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, 0.0, 0.0, 5, id);
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, Ligne debligne) {
        this(plan, v, x, y, "", debligne);
    }

    protected Ligne(double ra, double dec, Plan plan, ViewSimple v) {
        super(plan, v, 0.0, 0.0, ra, dec, 2, null);
    }

    protected Ligne(ViewSimple v, double ra, double dec) {
        super(null, v, 0.0, 0.0, ra, dec, 4, null);
    }

    protected Ligne(double ra, double dec) {
        this.raj = ra;
        this.dej = dec;
    }

    protected Ligne(double ra, double dec, Plan plan, ViewSimple v, Ligne debligne) {
        this(ra, dec, plan, v, null, debligne);
    }

    protected Ligne(double ra, double dec, Plan plan, ViewSimple v, String id, Ligne debligne) {
        super(plan, v, 0.0, 0.0, ra, dec, 2, id);
        this.debligne = debligne;
        if (debligne != null) {
            debligne.finligne = this;
        }
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, String id, Ligne debligne) {
        super(plan, v, x, y, 0.0, 0.0, 5, id);
        this.debligne = debligne;
        if (debligne != null) {
            debligne.finligne = this;
        }
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, Color c) {
        this(plan, v, x, y);
        this.couleur = new Color(c.getRGB());
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, String id, Color c) {
        this(plan, v, x, y, id);
        this.couleur = new Color(c.getRGB());
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, Ligne debligne, Color c) {
        this(plan, v, x, y, "", debligne, c);
        this.couleur = new Color(c.getRGB());
    }

    protected Ligne(Plan plan, ViewSimple v, double x, double y, String id, Ligne debligne, Color c) {
        this(plan, v, x, y, id);
        this.debligne = debligne;
        debligne.finligne = this;
        this.couleur = new Color(c.getRGB());
    }

    public Vector getProp() {
        Vector<Prop> propList = super.getProp();
        final Couleur col = new Couleur(this.couleur, true);
        final PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == Ligne.this.couleur) {
                    return -1;
                }
                Ligne.this.setColor(c);
                return 1;
            }
        };
        col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeCouleur.action();
                Ligne.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        return propList;
    }

    @Override
    public String getObjType() {
        return this.finligne == null ? "Line" : "Line+";
    }

    protected static boolean inLigne(double x1, double y1, double x2, double y2, double x, double y, double l) {
        if ((x2 - x) * (x1 - x) > (l = Math.sqrt(l)) || (y2 - y) * (y1 - y) > l) {
            return false;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double ddx = x - x1;
        double ddy = y - y1;
        double dd = ddx * ddx + ddy * ddy;
        if (dx != 0.0 || dy != 0.0) {
            double ddd = dx * ddx + dy * ddy;
            dd -= ddd * ddd / (dx * dx + dy * dy);
        }
        return dd <= l;
    }

    static boolean isLigne(Obj o) {
        return o != null && o instanceof Ligne && !(o instanceof Cote);
    }

    static boolean isDebLigne(Obj o) {
        return Ligne.isLigne(o) && ((Ligne)o).debligne == null;
    }

    protected void makeLastLigneForPolygone(ViewSimple v, boolean select) {
        this.getFirstBout().bout = 0;
        this.bout = (byte)3;
        this.setSelected(select);
        Ligne tmp = this.getFirstBout();
        this.raj = tmp.raj;
        this.dej = tmp.dej;
        tmp.setSelected(select);
        this.projection(v);
    }

    protected void makeLastLigneForClose(ViewSimple v) {
        Ligne tmp = this.getFirstBout();
        this.raj = tmp.raj;
        this.dej = tmp.dej;
        this.bout = (byte)3;
        this.projection(v);
    }

    @Override
    protected void remove() {
        Ligne avant = this.debligne;
        Ligne apres = this.finligne;
        if (avant != null) {
            avant.finligne = apres;
        }
        if (apres != null) {
            apres.debligne = avant;
        }
        if (this.bout == 3) {
            this.plan.aladin.calque.zoom.zoomView.stopHist();
        }
    }

    protected boolean isPolygone() {
        return this.getLastBout().bout == 3;
    }

    @Override
    public String getCommand() {
        StringBuffer s = new StringBuffer("draw");
        boolean isPolygon = this.isPolygone();
        if (isPolygon) {
            s.append(" polygon(");
        } else if (this instanceof Cote) {
            s.append(" dist(");
        } else {
            s.append(" line(");
        }
        boolean first = true;
        Ligne lig = this.getFirstBout();
        while (isPolygon && lig != null && lig.finligne != null || !isPolygon && lig != null) {
            if (!first) {
                s.append(", ");
            }
            s.append(lig.getLocalisation());
            first = false;
            lig = lig.finligne;
        }
        if (!(this instanceof Cote) && this.id != null && this.id.trim().length() > 0) {
            s.append("," + Tok.quote(this.id));
        }
        s.append(')');
        return s.toString();
    }

    @Override
    public boolean hasPhot() {
        return this.isPolygone();
    }

    public boolean hasPhot(Plan p) {
        if (!this.hasPhot()) {
            return false;
        }
        return p.hasAvailablePixels();
    }

    private void fillPolygon(Graphics g, ViewSimple v, int dx, int dy) {
        if (this.bout != 3) {
            return;
        }
        Ligne tmp = this;
        Polygon pol = new Polygon();
        while (tmp.debligne != null) {
            Point p2 = tmp.getViewCoord(v);
            pol.addPoint(dx + p2.x, dy + p2.y);
            tmp = tmp.debligne;
        }
        float opacity = this.plan == null ? 1.0f : this.plan.getOpacityLevel();
        Util.drawFillPolygon(g, pol, 0.1f * opacity, null);
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.debligne == null) {
            return this.inBout(v, x, y);
        }
        PointD p1 = v.getViewCoordDble(this.debligne.xv[v.n], this.debligne.yv[v.n]);
        PointD p2 = v.getViewCoordDble(this.xv[v.n], this.yv[v.n]);
        PointD p = v.getViewCoordDble(x, y);
        return Ligne.inLigne(p1.x, p1.y, p2.x, p2.y, p.x, p.y, this.mouseDist(v)) || this.inBout(v, x, y);
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        return this.nearArrow(v, x, y);
    }

    boolean nearArrow(ViewSimple v, double x, double y) {
        if (!this.isVisible()) {
            return false;
        }
        PointD p1 = v.getViewCoordDble(x, y);
        PointD p2 = v.getViewCoordDble(this.xv[v.n], this.yv[v.n]);
        if (p1 == null || p2 == null) {
            return false;
        }
        double ddx = p1.x - p2.x;
        double ddy = p1.y - p2.y;
        double dist = this.mouseDist(v);
        boolean rep = Math.sqrt(ddx * ddx + ddy * ddy) <= dist;
        return rep;
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.nearArrow(v, x, y);
    }

    protected boolean inPolygon(ViewSimple v, int x, int y) {
        if (this.bout != 3) {
            return false;
        }
        Ligne tmp = this;
        Polygon pol = new Polygon();
        while (tmp.debligne != null) {
            pol.addPoint((int)tmp.xv[v.n], (int)tmp.yv[v.n]);
            tmp = tmp.debligne;
        }
        return pol.contains(x, y);
    }

    protected Point getViewCoord(ViewSimple v) {
        return v.getViewCoord(this.xv[v.n], this.yv[v.n]);
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        int x1 = 2048;
        int y1 = 2048;
        int x2 = 0;
        int y2 = 0;
        Point p0 = this.debligne != null ? this.debligne.getViewCoord(v) : null;
        Point p1 = this.finligne != null ? this.finligne.getViewCoord(v) : null;
        Point p2 = this.getViewCoord(v);
        for (int i = 0; i < 3; ++i) {
            Point p;
            Point point = i == 0 ? p0 : (p = i == 1 ? p1 : p2);
            if (p == null) continue;
            if (p.x < x1) {
                x1 = p.x;
            }
            if (p.y < y1) {
                y1 = p.y;
            }
            if (p.x > x2) {
                x2 = p.x;
            }
            if (p.y <= y2) continue;
            y2 = p.y;
        }
        int gap = 1;
        if (this.bout > 0 || this.isSelected()) {
            gap = 4;
        }
        x1 -= gap;
        y1 -= gap + this.clipYId();
        x2 += gap + this.clipXId();
        y2 += gap + this.clipYId();
        if (this.isWithStat()) {
            clip = Ligne.unionRect(clip, this.getStatPosition(v));
        }
        return Ligne.unionRect(clip, x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    @Override
    protected boolean inClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return false;
        }
        int x1 = 2048;
        int y1 = 2048;
        int x2 = 0;
        int y2 = 0;
        Point p0 = this.debligne != null ? this.debligne.getViewCoord(v) : null;
        Point p1 = this.finligne != null ? this.finligne.getViewCoord(v) : null;
        Point p2 = this.getViewCoord(v);
        for (int i = 0; i < 3; ++i) {
            Point p;
            Point point = i == 0 ? p0 : (p = i == 1 ? p1 : p2);
            if (p == null) continue;
            if (p.x < x1) {
                x1 = p.x;
            }
            if (p.y < y1) {
                y1 = p.y;
            }
            if (p.x > x2) {
                x2 = p.x;
            }
            if (p.y <= y2) continue;
            y2 = p.y;
        }
        int gap = 1;
        if (this.bout > 0 || this.isSelected()) {
            gap = 4;
        }
        x1 -= gap;
        y1 -= gap + this.clipYId();
        x2 += gap + this.clipXId();
        y2 += gap + this.clipYId();
        if (this.bout == 3 && this.hasOneSelected()) {
            clip = Ligne.unionRect(clip, this.getStatPosition(v));
        }
        return Ligne.intersectRect(clip, x1, y1, x2 - x1 + 1, y2 - y1 + 1);
    }

    protected int clipXId() {
        return 0;
    }

    protected int clipYId() {
        return 0;
    }

    @Override
    public Color getColor() {
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null && this.plan.type == 10) {
            this.couleur = ((PlanField)this.plan).getColor(this);
            if (this.couleur == null) {
                return this.plan.c;
            }
            return this.couleur;
        }
        if (this.plan != null) {
            return this.plan.c;
        }
        return Color.black;
    }

    @Override
    public void setColor(Color c) {
        Ligne lig = this.getFirstBout();
        while (lig != null) {
            lig.couleur = c;
            lig = lig.finligne;
        }
    }

    private boolean doLiveMesure() {
        return this.flagLiveMesure;
    }

    private boolean tooSlow(ViewSimple v) {
        long t = 0L;
        if (v.flagClicAndDrag) {
            if (this.flagLiveMesure && (t = this.statPixels.getTime()) > 20L) {
                this.flagLiveMesure = false;
            }
        } else if (!this.flagLiveMesure) {
            this.flagLiveMesure = true;
            this.resume();
        }
        return !this.flagLiveMesure;
    }

    @Override
    protected boolean statCompute(Graphics g, ViewSimple v, int z) {
        double[] tripletPix;
        boolean flagHist;
        boolean bl = flagHist = v == v.aladin.view.getCurrentView();
        if (v == null || v.isFree() || !this.hasPhot(v.pref)) {
            return false;
        }
        if (this.statPixels == null) {
            this.statPixels = new StatPixels();
        }
        if (this.tooSlow(v)) {
            return false;
        }
        try {
            this.getStatistics(v.pref, z);
            tripletPix = this.statPixels.getStatisticsRaDecPix();
        }
        catch (Exception e) {
            return false;
        }
        ZoomHist.HistItem onMouse = null;
        if (flagHist) {
            ZoomHist.HistItem histItem = onMouse = v.aladin.view.zoomview.hist == null ? null : v.aladin.view.zoomview.hist.onMouse;
            if (onMouse == null) {
                v.aladin.view.zoomview.initPixelHist(this);
            } else {
                flagHist = false;
            }
        }
        for (int i = 0; i < tripletPix.length; i += 3) {
            double ra = tripletPix[i];
            double de = tripletPix[i + 1];
            double val = tripletPix[i + 2];
            if (v.pref instanceof PlanHips) {
                this.statPixelBG(g, val, ra, de, v, onMouse);
            } else {
                this.statPixel(g, val, ra, de, v, onMouse);
            }
            if (!flagHist) continue;
            v.aladin.view.zoomview.addPixelHist(val);
        }
        if (flagHist) {
            v.aladin.view.zoomview.createPixelHist(v.pref.type == 16 ? "HEALPixels" : "Pixels");
        }
        this.setWithStat(true);
        return true;
    }

    @Override
    public boolean hasSurface() {
        return this.bout == 3;
    }

    protected String getFoV() {
        if (!this.isPolygone()) {
            return null;
        }
        StringBuilder s = new StringBuilder("POLYGON ICRS");
        Iterator<Obj> it = this.iterator();
        while (it.hasNext()) {
            Ligne lig = (Ligne)it.next();
            s.append(" " + lig.raj + " " + lig.dej);
        }
        return s.toString();
    }

    @Override
    protected int getStatsHashcode(Plan p, int z) {
        return this.getPixelStatsCle(p, z).hashCode();
    }

    protected String getPixelStatsCle(Plan p, int z) {
        if (z == -1 && p.isCubeClassique()) {
            z = (int)p.getZ();
        }
        double tot = 0.0;
        Ligne a = this.getFirstBout();
        while (a.finligne != null) {
            tot += a.raj + a.dej;
            a = a.finligne;
        }
        String sync = p.isSync() ? "sync" : "";
        return this.raj + "," + this.dej + "," + tot + "," + sync + "," + p.hashCode() + "," + z + (p instanceof PlanHips ? ((PlanHips)p).getOrderInCurrentView() + "" : "");
    }

    @Override
    public double[] getStatisticsRaDecPix(Plan p, int z) throws Exception {
        if (this.bout != 3) {
            return null;
        }
        if (z == -1 && p.isCubeClassique()) {
            z = (int)p.getZ();
        }
        this.resumeStatistics(p, z);
        return this.statPixels.getStatisticsRaDecPix();
    }

    @Override
    public double[] getStatistics(Plan p, int z) throws Exception {
        if (this.bout != 3 || this.statPixels == null) {
            return null;
        }
        if (z == -1 && p.isCubeClassique()) {
            z = (int)p.getZ();
        }
        this.resumeStatistics(p, z);
        boolean withMedian = this.statPixels.nb < 100;
        return this.statPixels.getStatistics(withMedian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resumeStatistics(Plan p, int z) throws Exception {
        String cle;
        Projection proj = p.projd;
        if (!p.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(p)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(proj)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        if (this.statPixels == null) {
            this.statPixels = new StatPixels();
        }
        if (!this.statPixels.reinit(cle = this.getPixelStatsCle(p, z))) {
            return false;
        }
        Coord c = new Coord();
        double nombre = 0.0;
        double pixelSurf = 0.0;
        if (p.type == 16 || p.type == 22) {
            PlanHips pbg = (PlanHips)p;
            if (pbg.frameOrigin != 0) {
                throw new Exception("getStats error: not equatorial HiPS");
            }
            int orderFile = pbg.getOrderInCurrentView();
            long nsideLosange = pbg.getTileWidth();
            int orderPix = pbg.getOrderInCurrentView() + pbg.getOrderTile();
            pixelSurf = CDSHealpix.pixRes(orderPix) / 3600.0;
            pixelSurf *= pixelSurf;
            Ligne tmp = this.getLastBout();
            boolean isCounterClock = Aladin.isCounterClok(tmp);
            SMoc moc = Aladin.createMocRegionPol(tmp, orderPix, isCounterClock, false);
            Iterator<Long> it = moc.valIterator();
            while (it.hasNext()) {
                long npix = it.next();
                long npixFile = npix / (nsideLosange * nsideLosange);
                double pix = pbg.getHealpixPixel(orderFile, npixFile, npix, z, 2);
                if (Double.isNaN(pix)) continue;
                pix = pix * pbg.bScale + pbg.bZero;
                double[] polar = null;
                polar = CDSHealpix.pix2ang_nest(orderPix, npix);
                polar = CDSHealpix.polarToRadec(polar);
                c.al = polar[0];
                c.del = polar[1];
                nombre = this.statPixels.addPix(c.al, c.del, pix);
            }
        } else {
            Ligne deb;
            Coord ac = new Coord();
            Coord bc = new Coord();
            Ligne tmp = deb = this.getFirstBout();
            int nb = 0;
            while (tmp.finligne != null) {
                ++nb;
                tmp = tmp.finligne;
            }
            Segment[] seg = new Segment[nb];
            int miny = Integer.MAX_VALUE;
            int minx = Integer.MAX_VALUE;
            int maxy = Integer.MIN_VALUE;
            int maxx = Integer.MIN_VALUE;
            int i = 0;
            tmp = deb;
            while (tmp.finligne != null) {
                ac.al = tmp.raj;
                ac.del = tmp.dej;
                proj.getXY(ac);
                bc.al = tmp.finligne.raj;
                bc.del = tmp.finligne.dej;
                proj.getXY(bc);
                int fx = (int)Math.floor(ac.x - 0.5);
                int tx = (int)Math.ceil(ac.x - 0.5);
                int fy = (int)Math.floor(ac.y - 0.5);
                int ty = (int)Math.ceil(ac.y - 0.5);
                if (tx > maxx) {
                    maxx = tx;
                }
                if (fx < minx) {
                    minx = fx;
                }
                if (ty > maxy) {
                    maxy = ty;
                }
                if (fy < miny) {
                    miny = fy;
                }
                seg[i] = ac.y > bc.y ? new Segment(bc.x - 0.5, bc.y - 0.5, ac.x - 0.5, ac.y - 0.5) : new Segment(ac.x - 0.5, ac.y - 0.5, bc.x - 0.5, bc.y - 0.5);
                tmp = tmp.finligne;
                ++i;
            }
            Arrays.sort(seg, seg[0]);
            boolean isCube = p instanceof PlanImageBlink;
            PlanImage pi = (PlanImage)p;
            pixelSurf = proj.getPixResAlpha() * proj.getPixResDelta();
            try {
                if (!isCube) {
                    pi.setLockCacheFree(true);
                    pi.pixelsOriginFromCache();
                } else if (z < 0 || z > ((PlanImageBlink)pi).getDepth()) {
                    throw new Exception("Cube index out of frame range");
                }
                int n = 0;
                for (int y = miny; y <= maxy; ++y) {
                    while (n < nb && seg[n].out) {
                        ++n;
                    }
                    for (i = n; i < nb; ++i) {
                        seg[i].init();
                    }
                    for (int x = maxx + 1; x >= minx - 1; --x) {
                        double pix;
                        int inter = 0;
                        for (i = n; i < nb; ++i) {
                            if (!seg[i].cut(x, y)) continue;
                            ++inter;
                        }
                        if (inter % 2 != 1) continue;
                        double d = pix = isCube ? ((PlanImageBlink)pi).getPixel(x, pi.height - y - 1, z) : pi.getPixelInDouble(x, y);
                        if (Double.isNaN(pix)) continue;
                        c.x = (double)x + 0.5;
                        c.y = (double)y + 0.5;
                        proj.getCoord(c);
                        nombre = this.statPixels.addPix(c.al, c.del, pix);
                    }
                }
            }
            finally {
                if (!isCube) {
                    pi.setLockCacheFree(false);
                }
            }
        }
        this.statPixels.setSurface(nombre * pixelSurf);
        return true;
    }

    protected void resume() {
        this.plan.aladin.view.newView(1);
        this.resumeMesures();
        this.plan.aladin.view.repaint();
    }

    protected void resumeMesures() {
        if (this.bout != 3) {
            return;
        }
        if (!this.doLiveMesure()) {
            return;
        }
        Plan p = this.plan.aladin.calque.getPlanBase();
        int z = 0;
        if (p.isCubeClassique()) {
            z = (int)p.getZ();
        }
        try {
            this.resumeStatistics(p, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void drawID(Graphics g, ViewSimple v, Point p1, Point p2) {
    }

    protected void drawLabel(Graphics g, ViewSimple v, Point p1, Point p2, String label, Font font) {
        double dy = p2.y - p1.y;
        double dx = p2.x - p1.x;
        if (Math.sqrt(dy * dy + dx * dx) < 20.0 && v.getTaille() > 10.0) {
            return;
        }
        int a = (p1.x + p2.x) / 2;
        int b = (p1.y + p2.y) / 2;
        g.setFont(font);
        int x = a + 3;
        int y = b + (dy * dx > 0.0 ? -2 : 12);
        Color c = g.getColor();
        Color c1 = c == Color.red || c == Color.blue ? Color.white : Color.black;
        Util.drawStringOutline(g, label, x, y, c, c1);
        g.setColor(c);
    }

    protected Ligne getLastBout() {
        Ligne tmp = this;
        while (tmp.finligne != null) {
            tmp = tmp.finligne;
        }
        return tmp;
    }

    protected Ligne getFirstBout() {
        Ligne tmp = this;
        while (tmp.debligne != null) {
            tmp = tmp.debligne;
        }
        return tmp;
    }

    protected boolean hasOneSelected() {
        if (this.isSelected()) {
            return true;
        }
        Ligne tmp = this.getFirstBout();
        while (tmp.finligne != null && !tmp.isSelected()) {
            tmp = tmp.finligne;
        }
        return tmp.isSelected();
    }

    protected boolean tooLarge(ViewSimple v, Point p1, Point p2) {
        Projection proj = v.getProj();
        if (proj == null || proj.t == 1) {
            return false;
        }
        if (!v.isAllSky()) {
            return false;
        }
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        return dist / (double)v.rv.width > 0.5;
    }

    protected void drawLine(Graphics g, ViewSimple v, Point p1, Point p2) {
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
    }

    @Override
    protected Rectangle getStatPosition(ViewSimple v) {
        Point p1 = this.debligne.getViewCoord(v);
        return new Rectangle(p1.x + 50, p1.y - 30, 150, 117);
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        if (!this.hidden) {
            Point p2;
            g.setColor(this.getColor());
            if (this.debligne != null) {
                p2 = this.getViewCoord(v);
                Point p1 = this.debligne.getViewCoord(v);
                if (p2 == null || p1 == null) {
                    return false;
                }
                p1.x += dx;
                p1.y += dy;
                p2.x += dx;
                p2.y += dy;
                if (this.tooLarge(v, p1, p2)) {
                    return false;
                }
                this.drawLine(g, v, p1, p2);
                if (this.bout == 3 && this.hasPhot(v.pref)) {
                    this.fillPolygon(g, v, dx, dy);
                    if (this.hasOneSelected()) {
                        this.statDraw(g, v, p1.x, p1.y, p1.x + 50, p1.y - 30);
                    }
                }
                this.drawID(g, v, p1, p2);
                if (this.bout == 1 || this.bout == 2) {
                    double theta;
                    if (p1.x != p2.x) {
                        theta = Math.atan((double)(p2.y - p1.y) / (double)(p2.x - p1.x));
                        if (p1.x > p2.x) {
                            theta += Math.PI;
                        }
                    } else {
                        theta = p1.y < p2.y ? 1.5707963267948966 : -1.5707963267948966;
                    }
                    double delta = 2.356194490192345;
                    int dx1 = (int)(7.0 * FastMath.cos(theta + delta));
                    int dy1 = (int)(7.0 * FastMath.sin(theta + delta));
                    int dx2 = (int)(7.0 * FastMath.cos(theta - delta));
                    int dy2 = (int)(7.0 * FastMath.sin(theta - delta));
                    g.drawLine(p2.x + dx1, p2.y + dy1, p2.x, p2.y);
                    g.drawLine(p2.x, p2.y, p2.x + dx2, p2.y + dy2);
                    if (this.bout == 2) {
                        g.drawLine(p1.x - dx1, p1.y - dy1, p1.x, p1.y);
                        g.drawLine(p1.x, p1.y, p1.x - dx2, p1.y - dy2);
                    }
                }
            } else {
                p2 = this.getViewCoord(v, 0, 0);
                if (p2 == null) {
                    return false;
                }
                p2.x += dx;
                p2.y += dy;
                if (this.bout == 4) {
                    Util.fillCircle5(g, p2.x, p2.y);
                }
            }
            if (this.isSelected()) {
                if (this.plan != null && this.plan.type == 10) {
                    return true;
                }
                int ds = 2;
                g.setColor(Color.green);
                g.fillRect(p2.x - ds + 1, p2.y - ds + 1, 3, 3);
                g.setColor(Color.black);
                g.drawRect(p2.x - ds, p2.y - ds, 4, 4);
            }
        }
        return true;
    }

    protected void drawCoteBase(Graphics g, ViewSimple v, int dx, int dy) {
    }

    @Override
    public Iterator<Obj> iterator() {
        return new ObjetIterator();
    }

    class Segment
    implements Comparator {
        double x1;
        double y1;
        double x2;
        double y2;
        double dx;
        double dy;
        double dxb;
        double d;
        boolean cut;
        boolean out;

        Segment(double a, double b, double a1, double b1) {
            this.x1 = a;
            this.y1 = b;
            this.x2 = a1;
            this.y2 = b1;
            this.out = false;
            this.dx = this.x2 - this.x1;
            this.dy = this.y2 - this.y1;
            this.dxb = this.dx * this.y1 - this.dy * this.x1;
        }

        void init() {
            this.d = Double.NaN;
            this.cut = false;
        }

        boolean cut(double x, double y) {
            if (this.out) {
                return false;
            }
            if (y < this.y1) {
                return false;
            }
            if (y >= this.y2) {
                this.out = true;
                return false;
            }
            if (this.cut) {
                return true;
            }
            double d1 = y * this.dx - x * this.dy - this.dxb;
            if (Double.isNaN(this.d)) {
                this.d = d1;
            } else {
                this.cut = this.d < 0.0 && d1 >= 0.0 || this.d >= 0.0 && d1 < 0.0;
            }
            d1 = this.d;
            return this.cut;
        }

        public int compare(Object arg0, Object arg1) {
            Segment a = (Segment)arg0;
            Segment b = (Segment)arg1;
            return a.y1 == b.y1 ? 0 : (a.y1 < b.y1 ? -1 : 1);
        }
    }

    class ObjetIterator
    implements Iterator<Obj> {
        private Ligne line;

        ObjetIterator() {
            this.line = Ligne.this.getFirstBout();
        }

        @Override
        public boolean hasNext() {
            return this.line.finligne != null && this.line.bout != 3;
        }

        @Override
        public Obj next() {
            this.line = this.line.finligne;
            return this.line;
        }

        @Override
        public void remove() {
        }
    }
}

