/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.IconSpectro;
import cds.aladin.Spectrogram;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Graphics;

public class IconSpectroRGB
extends IconSpectro {
    static int D = 6;

    protected IconSpectroRGB(Spectrogram sp) {
        super(sp, 14);
    }

    @Override
    protected boolean isActivated() {
        return this.sp.isModeRGB();
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = this.W / 2 - D / 2 + 1;
        int y = 0 + D - 1;
        if (!this.isActivated()) {
            g.setColor(this.getLogoColor());
            Util.drawCircle5(g, x, y);
            Util.drawCircle5(g, x + D - 1, y);
            Util.drawCircle5(g, x + D / 2, y + D - 2);
        } else {
            g.setColor(Color.red);
            Util.fillCircle5(g, x, y);
            g.setColor(Color.blue);
            Util.fillCircle5(g, x + D - 1, y);
            g.setColor(Color.green);
            Util.fillCircle5(g, x + D / 2, y + D - 2);
        }
    }

    @Override
    protected void submit() {
        if (!this.isAvailable()) {
            return;
        }
        this.sp.setModeRGB(!this.sp.isModeRGB());
        Aladin.makeCursor(this, this.getMyCursor());
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("SPECTRORGB");
    }

    @Override
    protected String getHelpKey() {
        return "SpectroRGB.HELP";
    }
}

