/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Icon;
import java.awt.Color;
import java.awt.Graphics;

public class IconMatch
extends Icon {
    static final int L = 12;
    static String MATCH;
    protected boolean megaMatch = false;

    protected IconMatch(Aladin aladin) {
        super(aladin, 35, 24);
        MATCH = Aladin.chaine.getString("SYNC");
    }

    protected boolean isMatched() {
        return this.aladin.view.getNbSelectedView() > 1 && !this.aladin.view.hasCompatibleViews();
    }

    @Override
    protected boolean isAvailable() {
        return this.aladin.view.isMultiView() && this.getMode() >= 1;
    }

    protected Color getFillColor() {
        int mode = this.getMode();
        Color c = mode == 0 || mode == 1 ? this.getBackground() : (mode == 2 ? Color.blue : Aladin.COLOR_RED);
        return c;
    }

    @Override
    protected Color getLogoColor() {
        if (this.getMode() > 1) {
            return Aladin.COLOR_ICON_ACTIVATED;
        }
        return super.getLogoColor();
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = 20 + this.DX;
        int y = 7;
        int r = 3;
        g.setColor(this.getFillColor());
        g.fillRect(x - r, y - r, 2 * r, 2 * r);
        g.setColor(this.getLogoColor());
        g.drawRect(x - r, y - r, 2 * r, 2 * r);
        g.drawLine(x - 6, y, x - 1, y);
        g.drawLine(x + 1, y, x + 6, y);
        g.drawLine(x, y - 6, x, y - 1);
        g.drawLine(x, y + 1, x, y + 6);
        g.setColor(this.getLabelColor());
        g.setFont(Aladin.SPLAIN);
        g.drawString(MATCH, this.W / 2 - g.getFontMetrics().stringWidth(MATCH) / 2, this.H - 2);
    }

    protected int getMode() {
        boolean sync;
        boolean active = this.aladin.view.hasCompatibleViews();
        boolean bl = sync = this.aladin.view.getNbSelectedView() > 1 && !active;
        return sync && this.megaMatch ? 3 : (sync ? 2 : (active ? 1 : 0));
    }

    protected boolean isProjSync() {
        return this.getMode() == 3;
    }

    private void echoCommand() {
        int mode = this.getMode();
        if (mode == 3) {
            this.aladin.console.printCommand("match " + this.aladin.view.getCurrentView().getID());
        } else if (mode <= 1) {
            this.aladin.console.printCommand("match off");
        }
    }

    @Override
    protected void submit() {
        this.aladin.cycleMatch();
        if (this.aladin.frameCM != null && this.aladin.frameCM.isVisible()) {
            this.aladin.frameCM.resumeWidgets();
        }
        this.echoCommand();
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("MVIEWSYNC");
    }

    @Override
    protected String getHelpKey() {
        return "Sync.HELP";
    }
}

