/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Icon;
import java.awt.Graphics;

public class IconCollapse
extends Icon {
    static final int L = 12;
    static String COLLAPSE;
    static String EXPAND;
    private static final int[][] TX;

    protected IconCollapse(Aladin aladin) {
        super(aladin, 32, 24);
        COLLAPSE = Aladin.chaine.getString("COLLAPSE");
        EXPAND = Aladin.chaine.getString("EXPAND");
    }

    private void drawLogo(Graphics g, int x, int y) {
        for (int i = 0; i < TX.length; ++i) {
            g.drawLine(TX[i][1] + x, TX[i][0] + y, TX[i][2] + x, TX[i][0] + y);
        }
    }

    @Override
    protected boolean isAvailable() {
        return !this.aladin.directory.isFree();
    }

    @Override
    protected boolean isActivated() {
        return false;
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = 10 + this.DX;
        int y = 3;
        if (this.isAvailable()) {
            g.setColor(this.getFillInColor());
            g.fillRect(x, y, 9, 9);
        }
        g.setColor(this.getLogoColor());
        this.drawLogo(g, x, y);
        g.setColor(this.getLabelColor());
        g.setFont(Aladin.SPLAIN);
        String s = this.aladin.directory.isDefaultExpand() ? EXPAND : COLLAPSE;
        g.drawString(s, this.W / 2 - g.getFontMetrics().stringWidth(s) / 2, this.H - 2);
    }

    @Override
    protected void submit() {
        if (!this.isAvailable()) {
            return;
        }
        this.aladin.directory.collapseOrNot();
        this.repaint();
    }

    @Override
    protected String getHelpTip() {
        return Aladin.chaine.getString("COLLAPSETIP");
    }

    @Override
    protected String getHelpKey() {
        return "Collapse.HELP";
    }

    static {
        TX = new int[][]{{0, 0, 8}, {1, 0, 0}, {1, 8, 8}, {2, 0, 0}, {2, 4, 4}, {2, 8, 8}, {3, 0, 0}, {3, 4, 4}, {3, 8, 8}, {4, 0, 0}, {4, 2, 6}, {4, 8, 9}, {4, 11, 11}, {4, 13, 13}, {5, 0, 0}, {5, 4, 4}, {5, 8, 8}, {6, 0, 0}, {6, 4, 4}, {6, 8, 8}, {7, 0, 0}, {7, 8, 8}, {8, 0, 8}};
    }
}

