/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyListener;
import cds.aladin.PlanHips;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class Histogramme
extends JComponent
implements MyListener,
MouseListener {
    static final int mX = 10;
    static final int mY = 0;
    static final int Hp = 150;
    static final int W = 276;
    static final int H = 150;
    static final String TITLE = "Pixel values histogram";
    double[] hist;
    Image img = null;
    private int level = -1;
    private boolean showPixVal = true;
    boolean flag = false;
    private PlanImage pimg;
    private byte[] pixels;

    protected Histogramme() {
        this.addMouseListener(this);
    }

    protected Histogramme(PlanImage pimg) {
        this();
        if (pimg != null && !(pimg instanceof PlanImageRGB)) {
            this.setImage(pimg);
        }
    }

    private void computeHist() {
        int i;
        double max = 0.0;
        this.hist = new double[256];
        for (i = 0; i < this.pixels.length; ++i) {
            double c;
            int j;
            int n = j = this.pixels[i] < 0 ? 256 + this.pixels[i] : this.pixels[i];
            this.hist[n] = this.hist[n] + 1.0;
            if (!(c > max)) continue;
            max = c;
        }
        for (i = 0; i < this.hist.length; ++i) {
            this.hist[i] = Math.log(1.0 + this.hist[i]);
        }
        max = Math.log(1.0 + max);
        max += max / 5.0;
        for (i = 0; i < this.hist.length; ++i) {
            this.hist[i] = this.hist[i] * 150.0 / max;
        }
        this.resize(276, 150);
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        this.flag = true;
        if (this.showPixVal && x - 10 != this.level) {
            this.setLevel(x - 10);
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseExit(Event e, int x, int y) {
        this.setLevel(-1);
        return true;
    }

    @Override
    public void paint(Graphics g) {
        if (this.pimg == null && this.pixels == null) {
            return;
        }
        if (this.img == null) {
            this.update(g);
            return;
        }
        g.drawImage(this.img, 10, 0, this.pimg.aladin);
        if (this.showPixVal) {
            this.drawInfo(g);
        }
    }

    @Override
    public void update(Graphics gr) {
        if (this.img == null) {
            this.img = this.createImage(256, 150);
        } else if (this.flag) {
            this.paint(gr);
            return;
        }
        Graphics g = this.img.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, 256, 150);
        g.setColor(Color.blue);
        for (int i = 0; i < 256; ++i) {
            g.drawLine(i, 150, i, 150 - (int)this.hist[i]);
        }
        g.setColor(Color.black);
        g.drawRect(0, 0, 255, 149);
        g.setFont(Aladin.SPLAIN);
        g.drawString(TITLE, 73, 14);
        g.dispose();
        this.paint(gr);
    }

    private void drawInfo(Graphics g) {
        String s2;
        if (this.level < 0) {
            return;
        }
        String s1 = this.pimg.getPixelInfoFromGrey(this.level);
        String s = s1.equals(s2 = this.pimg.getPixelInfoFromGrey(this.level + 1)) ? s1 : "[" + s1 + ".." + s2 + "]";
        String pixStr = "pixel: " + s;
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite saveComposite = g2d.getComposite();
            FontMetrics fm = g2d.getFontMetrics();
            int strWidth = fm.stringWidth(pixStr);
            int strHeight = fm.getMaxAscent() + fm.getMaxDescent();
            g2d.setComposite(Util.getImageComposite(0.55f));
            g2d.setColor(Color.black);
            g2d.fillRoundRect(12, 115 - strHeight, 10 + strWidth + 7, strHeight + 6, 20, 20);
            g2d.setComposite(saveComposite);
        }
        g.setColor(Color.magenta);
        g.drawLine(10 + this.level, 150, 10 + this.level, 0);
        g.drawString(pixStr, 17, 115);
    }

    protected void setLevel(int level) {
        if (level == this.level) {
            return;
        }
        this.level = level > 255 ? 255 : (level < -1 ? -1 : level);
        this.repaint();
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(276, 150);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    protected void setImage(PlanImage pimg) {
        this.pimg = pimg;
        this.pixels = pimg instanceof PlanHips ? ((PlanHips)pimg).getBufPixels8(pimg.aladin.view.getCurrentView()) : pimg.getBufPixels8();
        this.computeHist();
        this.img = null;
        this.flag = false;
        this.showPixVal = false;
    }

    @Override
    public void fireStateChange(String state) {
        if (state == null) {
            this.showPixVal = false;
            this.repaint();
        }
    }

    @Override
    public void fireStateChange(int i) {
        this.showPixVal = true;
        this.setLevel(i);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPixVal = false;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

