/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.GrabItFrame;
import cds.aladin.Plan;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ServerTapExamples;
import cds.aladin.ViewSimple;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JToggleButton;

public class GrabUtil {
    public GrabItFrame grabFrame;
    private static GrabUtil instance = null;
    List<Server> grabItServers = new ArrayList<Server>();
    List<JToggleButton> grabs = new ArrayList<JToggleButton>();

    public static synchronized GrabUtil getInstance() {
        if (instance == null) {
            instance = new GrabUtil();
        }
        return instance;
    }

    protected static String getGrabItCoord(Aladin aladin, Coord c) {
        if (Double.isNaN(c.al)) {
            return null;
        }
        return c.getSexa();
    }

    public static void setGrabItCoord(Aladin aladin, Server server, Coord c) {
        String sexaCoord = GrabUtil.getGrabItCoord(aladin, c);
        if (sexaCoord != null) {
            server.setTarget(aladin.localisation.getFrameCoord(sexaCoord));
        }
    }

    public static void stopGrabIt(Aladin aladin, JFrame serverDialog, Server server) {
        JToggleButton grab = server.grab;
        if (grab != null) {
            Plan pref = aladin.calque.getPlanRef();
            grab.getModel().setSelected(false);
            grab.setEnabled(pref != null && Projection.isOk(pref.projd));
            Server serverToEdit = server;
            if (serverToEdit.tree != null && !serverToEdit.tree.isEmpty()) {
                serverToEdit.tree.clear();
            }
            if (server instanceof ServerTapExamples) {
                ((ServerTapExamples)server).targetSettingsChangedAction();
            }
        }
        serverDialog.toFront();
    }

    protected boolean isGrabIt(Server server) {
        return server.modeCoo != 0 && server.grab != null && server.grab.getModel().isSelected();
    }

    public static String setGrabItRadius(Aladin aladin, Server server, double x1, double y1, double x2, double y2) {
        if (server != null && server.modeRad == 0) {
            return null;
        }
        if (Math.abs(x1 - x2) < 3.0 && Math.abs(y1 - y2) < 3.0) {
            return null;
        }
        ViewSimple v = aladin.view.getCurrentView();
        Plan pr = v.pref;
        if (pr == null) {
            return null;
        }
        Projection proj = pr.projd;
        if (proj == null) {
            return null;
        }
        PointD p1 = v.getPosition(x1, y1);
        PointD p2 = v.getPosition(x2, y2);
        Coord c1 = new Coord();
        c1.x = p1.x;
        c1.y = p1.y;
        proj.getCoord(c1);
        if (Double.isNaN(c1.al)) {
            return null;
        }
        Coord c2 = new Coord();
        c2.x = p2.x;
        c2.y = p2.y;
        proj.getCoord(c2);
        if (Double.isNaN(c2.al)) {
            return null;
        }
        String radius = Coord.getUnit(Coord.getDist(c1, c2));
        if (server != null) {
            server.resolveRadius(radius, true);
        }
        return radius;
    }

    public void resetAllGrabIts(Aladin aladin) {
        Plan pref = aladin.calque.getPlanRef();
        boolean flag = pref != null && pref.projd != null;
        this.setAllGrabItsEnabled(flag);
    }

    public void setAllGrabItsEnabled(boolean isEnabled) {
        for (Server server : this.grabItServers) {
            if (server.grab == null) continue;
            server.grab.setEnabled(isEnabled);
        }
        for (JToggleButton grab : this.grabs) {
            if (grab == null) continue;
            grab.setEnabled(isEnabled);
        }
    }

    public void removeAndAdd(Server oldServer, Server newServer) {
        this.grabItServers.remove(oldServer);
        this.grabItServers.add(newServer);
    }

    public void removeAndAdd(JToggleButton oldGrab, JToggleButton newGrab) {
        this.grabs.remove(oldGrab);
        this.grabs.add(newGrab);
    }
}

