/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.AladinPlugin;
import cds.aladin.FrameVOTool;
import cds.tools.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.Comparator;

public class GluApp
implements Comparator {
    public static String JAVAPATH = "java";
    public static String JAVAWS = "javaws";
    private Aladin aladin;
    String ordre = "Y";
    public String tagGlu;
    public String aladinLabel;
    public String description;
    public String verboseDescr;
    public String institute;
    public String releaseNumber;
    public String nextNumber;
    public String copyright;
    public String docUrl;
    public String jarUrl;
    public String javaParam;
    public String downloadUrl;
    public String wsUrl;
    public String appletUrl;
    public String pluginUrl;
    public String activated;
    public String system;
    public String dir;
    protected long downloading;
    protected boolean interrupt;
    private int type;
    static final int JAVA = 1;
    static final int PLASTIC = 2;
    protected static final int JAR = 1;
    protected static final int DOWNLOAD = 2;
    protected static final int WEBSTART = 3;
    protected static final int APPLET = 4;
    protected static final int PLUGIN = 5;

    public GluApp(Aladin aladin, String tagGlu, String aladinLabel, String aladinMenuNumber, String description, String verboseDescription, String institute, String releaseNumber, String copyright, String docUser, String jar, String javaParam, String dir, String download, String webstart, String applet, String plugin, String aladinActivated, String system, int type) {
        this.aladin = aladin;
        this.tagGlu = tagGlu;
        this.aladinLabel = aladinLabel;
        this.ordre = aladinMenuNumber;
        this.description = description;
        this.verboseDescr = verboseDescription;
        this.institute = institute;
        this.releaseNumber = releaseNumber;
        this.copyright = copyright;
        this.docUrl = docUser;
        this.jarUrl = jar;
        this.javaParam = javaParam;
        this.downloadUrl = download;
        this.wsUrl = webstart;
        this.appletUrl = applet;
        this.pluginUrl = plugin;
        this.dir = dir;
        this.type = type;
        this.system = system;
        this.activated = aladinActivated;
        this.downloading = -1L;
    }

    public GluApp(Aladin aladin, String tagGlu) {
        this.aladin = aladin;
        this.tagGlu = tagGlu;
        this.downloading = -1L;
    }

    protected void merge(String aladinLabel, String aladinMenuNumber, String description, String verboseDescr, String institute, String releaseNumber, String copyright, String docUser, String jar, String javaParam, String download, String webstart, String applet, String plugin, String aladinActivated, int type) {
        this.tagGlu = this.tagGlu;
        this.aladinLabel = aladinLabel;
        this.ordre = aladinMenuNumber;
        this.description = description;
        this.verboseDescr = verboseDescr;
        this.institute = institute;
        if (!this.releaseNumber.equals(releaseNumber)) {
            this.nextNumber = releaseNumber;
        }
        this.copyright = copyright;
        this.docUrl = docUser;
        this.jarUrl = jar;
        this.javaParam = javaParam;
        this.downloadUrl = download;
        this.wsUrl = webstart;
        this.appletUrl = applet;
        this.pluginUrl = plugin;
        this.activated = this.activated == null ? aladinActivated : this.activated;
        this.type = type;
    }

    protected int getInstallMode() {
        if (this.wsUrl != null) {
            return 3;
        }
        if (this.appletUrl != null) {
            return 4;
        }
        if (this.pluginUrl != null) {
            return 5;
        }
        if (this.jarUrl != null) {
            return 1;
        }
        if (this.downloadUrl != null) {
            return 2;
        }
        return 0;
    }

    protected boolean canBeInstall() {
        int mode = this.getInstallMode();
        return mode != 0 && mode != 3 && mode != 4;
    }

    protected boolean isDownloading() {
        return this.downloading != -1L;
    }

    protected boolean canBeRun() {
        int mode = this.getInstallMode();
        if (mode == 3 || mode == 4) {
            return true;
        }
        if (this.isDownloading()) {
            return false;
        }
        return this.dir != null || this.system != null;
    }

    protected boolean canBeMenu() {
        return this.isActivated();
    }

    protected boolean isActivated() {
        return this.activated != null && !this.activated.equals("No");
    }

    protected boolean hasNewRelease() {
        return this.nextNumber != null;
    }

    protected static String glu(String key, String value) {
        if (value == null || value.trim().startsWith("--")) {
            return "";
        }
        return "%" + Util.align(key, 20) + value + Util.CR;
    }

    protected String getGluDic() {
        StringBuffer s = new StringBuffer();
        s.append(GluApp.glu("ActionName", this.tagGlu));
        s.append(GluApp.glu("DistribDomain", "ALADIN"));
        s.append(GluApp.glu("Owner", "CDS'aladin"));
        s.append(GluApp.glu("Description", this.description));
        s.append(GluApp.glu("VerboseDescr", this.verboseDescr));
        s.append(GluApp.glu("Institute", this.institute));
        s.append(GluApp.glu("ReleaseNumber", this.releaseNumber));
        s.append(GluApp.glu("NextNumber", this.nextNumber));
        s.append(GluApp.glu("Copyright", this.copyright));
        s.append(GluApp.glu("Doc.User", this.docUrl));
        s.append(GluApp.glu("Jar", this.jarUrl));
        s.append(GluApp.glu("Webstart", this.wsUrl));
        s.append(GluApp.glu("Applet", this.appletUrl));
        s.append(GluApp.glu("Download", this.downloadUrl));
        s.append(GluApp.glu("JavaParam", this.javaParam));
        s.append(GluApp.glu("Aladin.VOLabel", this.aladinLabel));
        s.append(GluApp.glu("Aladin.Activated", this.activated));
        s.append(GluApp.glu("Dir", this.dir));
        s.append(GluApp.glu("System", this.system));
        s.append(Util.CR);
        return s.toString();
    }

    protected String getCommand() {
        if (this.getInstallMode() == 3) {
            return JAVAWS + " " + this.wsUrl;
        }
        if (this.dir == null) {
            return null;
        }
        if (this.system != null) {
            return this.system;
        }
        return this.getJavaCommand();
    }

    protected String getJavaCommand() {
        if (this.javaParam != null) {
            return JAVAPATH + " " + this.javaParam;
        }
        return null;
    }

    protected boolean hasDedicatedCommand() {
        return this.system != null;
    }

    protected boolean hasDedicatedDir() {
        return this.dir != null && !this.dir.equals(this.aladin.getVOPath());
    }

    protected String getDir() {
        int mode = this.getInstallMode();
        if (mode == 4 || mode == 3) {
            return null;
        }
        return this.dir;
    }

    protected boolean exec() {
        if (!this.isInstalled()) {
            FrameVOTool.display(this.aladin, this);
            return false;
        }
        this.aladin.log("VOToolExec", this.tagGlu);
        if (this.getInstallMode() == 4) {
            return this.execApplet();
        }
        if (this.getInstallMode() == 5) {
            return this.execPlugin();
        }
        final String dir = this.getDir();
        Aladin.trace(1, "Exec: " + (dir != null ? "cd " + dir + ";" : "") + this.getCommand());
        try {
            new Thread(this.tagGlu){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(GluApp.this.getCommand(), null, dir == null ? null : new File(dir));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean execApplet() {
        this.aladin.glu.showDocument("Http", this.appletUrl, true);
        return true;
    }

    protected boolean execPlugin() {
        String pluginID = this.javaParam != null ? this.javaParam : this.tagGlu;
        AladinPlugin ap = this.aladin.plugins.find(pluginID);
        if (ap != null) {
            try {
                ap.start();
            }
            catch (AladinException e1) {
                e1.printStackTrace();
                Aladin.error(Aladin.chaine.getString("PLUGERROR") + "\n\n" + e1.getMessage());
                return false;
            }
        } else {
            Aladin.error(Aladin.chaine.getString("PLUGERROR") + "\n\nPlugin " + this.tagGlu + " unknown");
            return false;
        }
        return true;
    }

    protected String getInstallationName(String jarUrl) {
        try {
            return jarUrl.substring(jarUrl.lastIndexOf(47));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected int install() {
        this.aladin.log("VOToolInstall", this.tagGlu);
        switch (this.getInstallMode()) {
            case 5: {
                this.installPlugin();
                return -3;
            }
            case 1: {
                this.installJar();
                return -3;
            }
            case 2: {
                this.aladin.glu.showDocument("Http", this.downloadUrl, true);
                return -1;
            }
        }
        return -2;
    }

    protected void interrupt() {
        this.interrupt = true;
    }

    synchronized void setDownloading(long n) {
        this.downloading = n;
    }

    protected boolean installPlugin() {
        try {
            this.aladin.plugins.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.installJar1(this.pluginUrl, this.aladin.plugins.getPlugPath());
    }

    protected boolean isInstalled() {
        int mode = this.getInstallMode();
        String file = null;
        if (mode == 1) {
            file = this.aladin.getVOPath() + Util.FS + this.getInstallationName(this.jarUrl);
        } else if (mode == 5) {
            file = this.aladin.plugins.getPlugPath() + Util.FS + this.getInstallationName(this.pluginUrl);
        } else {
            return true;
        }
        return new File(file).exists();
    }

    protected boolean installJar() {
        return this.installJar1(this.jarUrl, this.aladin.getVOPath());
    }

    protected boolean installJar1(final String jarUrl, final String targetPath) {
        this.setDownloading(0L);
        this.interrupt = false;
        new Thread("Install"){

            @Override
            public void run() {
                try {
                    int n;
                    URL u = new URL(jarUrl);
                    InputStream inp = u.openStream();
                    if (inp == null) {
                        throw new Exception();
                    }
                    DataInputStream in = new DataInputStream(inp);
                    if (in == null) {
                        throw new Exception();
                    }
                    String installationName = GluApp.this.getInstallationName(jarUrl);
                    if (installationName == null) {
                        throw new Exception("Installation name error");
                    }
                    String file = targetPath + Util.FS + installationName;
                    String tmp = file + ".tmp";
                    File g = new File(tmp);
                    g.delete();
                    RandomAccessFile out = new RandomAccessFile(tmp, "rw");
                    byte[] buf = new byte[512];
                    while (!GluApp.this.interrupt && in.available() == 0) {
                        Util.pause(100);
                    }
                    while (!GluApp.this.interrupt && (n = in.read(buf)) > 0) {
                        out.write(buf, 0, n);
                        GluApp.this.setDownloading(GluApp.this.downloading + (long)n);
                    }
                    in.close();
                    out.close();
                    if (GluApp.this.interrupt) {
                        g.delete();
                        GluApp.this.setDownloading(-1L);
                    } else {
                        File f = new File(file);
                        GluApp.this.myDelete(file);
                        g.renameTo(f);
                        GluApp.this.dir = targetPath;
                        if (GluApp.this.nextNumber != null) {
                            GluApp.this.releaseNumber = GluApp.this.nextNumber;
                        }
                        GluApp.this.nextNumber = null;
                    }
                }
                catch (Exception e) {
                    GluApp.this.aladin;
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    GluApp.this.aladin;
                    Aladin.error("Installation error");
                }
                GluApp.this.setDownloading(-1L);
                ((GluApp)GluApp.this).aladin.frameVOTool.downloadEnd();
            }
        }.start();
        return true;
    }

    private void myDelete(String file) throws Exception {
        File f = new File(file);
        for (int i = 0; i < 10; ++i) {
            File t = i == 0 ? new File(file) : new File(file + "-toberemoved." + i);
            t.delete();
            Util.pause(500);
            if (t.exists()) continue;
            if (i > 0 && !f.renameTo(t)) {
                throw new Exception();
            }
            return;
        }
        throw new Exception("myDelete error");
    }

    public GluApp() {
    }

    protected static Comparator getComparator() {
        return new GluApp();
    }

    public int compare(Object o1, Object o2) {
        GluApp a1 = (GluApp)o1;
        GluApp a2 = (GluApp)o2;
        if (a1.ordre == a2.ordre) {
            return 0;
        }
        if (a1.ordre == null) {
            return -1;
        }
        if (a2.ordre == null) {
            return 1;
        }
        return a1.ordre.compareTo(a2.ordre);
    }
}

