/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.query.ADQLQuery;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GluAdqlTemplate
extends ADQLQuery {
    private String[] gluTop = null;
    private String[] gluAllOrDistinct = null;
    private String[] gluTable = null;
    private Hashtable<String, String> gluSelect = null;
    private Hashtable<String, String> gluFrom = null;
    private Hashtable<String, String> gluWhere = null;

    public GluAdqlTemplate() {
        this.gluSelect = new Hashtable();
        this.gluFrom = new Hashtable();
        this.gluWhere = new Hashtable();
    }

    public GluAdqlTemplate(Hashtable<String, String> gluSelect, Hashtable<String, String> gluFrom, Hashtable<String, String> gluWhere) {
        this.gluSelect = gluSelect;
        this.gluFrom = gluFrom;
        this.gluWhere = gluWhere;
    }

    public GluAdqlTemplate(Hashtable<String, String> gluSelect, Hashtable<String, String> gluFrom, Hashtable<String, String> gluWhere, Hashtable<String, String> adqlFunc, Hashtable<String, String> adqlFuncParams) {
        this(gluSelect, gluFrom, gluWhere);
    }

    public String getQueryClause(String key) {
        String result = "";
        if (this.gluFrom.containsKey(key)) {
            result = "From";
        } else if (this.gluSelect.containsKey(key)) {
            result = "Select";
        } else if (this.gluWhere.containsKey(key)) {
            result = "Where";
        }
        return result;
    }

    public void setGluQueryTop(Vector v, StringBuffer gluQuery) {
        this.setSingleGluQueryParam(this.gluTop, v, gluQuery, null);
    }

    public void setGluQueryAllOrDistinct(Vector v, StringBuffer gluQuery) {
        this.setSingleGluQueryParam(this.gluAllOrDistinct, v, gluQuery, null);
    }

    public void setGluQueryColumns(Vector v, StringBuffer gluQuery) {
        if (!this.gluSelect.isEmpty() && this.gluSelect.size() >= 1) {
            String colGluKey = this.gluSelect.keys().nextElement();
            this.setSingleGluQueryParam(colGluKey, this.gluSelect.get(colGluKey), v, gluQuery, null, " * ");
        } else {
            gluQuery.append(" * ");
        }
    }

    public void setGluQueryTable(Vector v, StringBuffer gluQuery) {
        this.setSingleGluQueryParam(this.gluTable, v, gluQuery, "FROM");
    }

    public void setSingleGluQueryParam(String[] gluParam, Vector v, StringBuffer gluQuery, String param) {
        if (gluParam != null && gluParam.length > 1) {
            this.setSingleGluQueryParam(gluParam[0], gluParam[1], v, gluQuery, param, "");
        }
    }

    public void setSingleGluQueryParam(String gluKey, String gluParam, Vector v, StringBuffer gluQuery, String param, String defaultAppend) {
        boolean notSetFlag = true;
        if (gluParam != null && gluKey != null) {
            String value = null;
            int k = Integer.valueOf(gluKey) - 1;
            if (v.size() > k && (value = (String)v.get(Integer.valueOf(gluKey) - 1)) != null && !value.isEmpty() && !value.equals("NaN")) {
                if (param != null) {
                    gluQuery.append(param).append(" ");
                }
                gluQuery.append(gluParam).append(" ");
                notSetFlag = false;
            }
        }
        if (notSetFlag) {
            gluQuery.append(defaultAppend);
        }
    }

    public void setGluQueryWheres(Vector v, StringBuffer gluQuery, String currentSelectedTapTable, Hashtable<String, String> adqlFunc, Hashtable<String, String> adqlFuncParams) {
        StringBuffer whereQuery = new StringBuffer();
        String value = null;
        boolean isfirst = true;
        Enumeration<String> keys = this.gluWhere.keys();
        while (keys.hasMoreElements()) {
            String gluKey = keys.nextElement();
            int k = Integer.valueOf(gluKey) - 1;
            if (v.size() > k) {
                value = (String)v.get(Integer.valueOf(gluKey) - 1);
            }
            if (value == null || value.isEmpty() || value.equals("NaN")) continue;
            if (!isfirst) {
                whereQuery.append(" AND ");
            }
            if (adqlFunc != null && adqlFuncParams != null && adqlFunc.containsKey(this.gluWhere.get(gluKey))) {
                String function;
                block8: {
                    function = adqlFunc.get(this.gluWhere.get(gluKey));
                    String params = adqlFuncParams.get(this.gluWhere.get(gluKey) + "." + currentSelectedTapTable);
                    try {
                        if (function == null || params == null) break block8;
                        function = String.format(function, params.split("\t"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                whereQuery.append(function);
            } else {
                whereQuery.append(this.gluWhere.get(gluKey));
            }
            isfirst = false;
        }
        if (whereQuery.length() > 0) {
            gluQuery.append("WHERE ").append(whereQuery);
        }
    }

    public String getGluQuery(Vector v, String currentSelectedTapTable, Hashtable<String, String> adqlFunc, Hashtable<String, String> adqlFuncParams) {
        StringBuffer query = new StringBuffer("SELECT ");
        this.setGluQueryAllOrDistinct(v, query);
        this.setGluQueryTop(v, query);
        this.setGluQueryColumns(v, query);
        this.setGluQueryTable(v, query);
        this.setGluQueryWheres(v, query, currentSelectedTapTable, adqlFunc, adqlFuncParams);
        return query.toString();
    }

    public static void copy(String prefixe, String gluIndex, GluAdqlTemplate sourceGluAdqlTemplate, GluAdqlTemplate queryToUpdate) {
        String valueSet = "";
        if (sourceGluAdqlTemplate.gluWhere.containsKey(gluIndex)) {
            queryToUpdate.gluWhere.put(gluIndex, sourceGluAdqlTemplate.gluWhere.get(gluIndex));
        } else if (sourceGluAdqlTemplate.gluSelect.containsKey(gluIndex)) {
            valueSet = sourceGluAdqlTemplate.gluSelect.get(gluIndex);
            if (prefixe.equalsIgnoreCase("TOP")) {
                queryToUpdate.gluTop = new String[2];
                queryToUpdate.gluTop[0] = gluIndex;
                queryToUpdate.gluTop[1] = valueSet;
            } else if (prefixe.equalsIgnoreCase("ALL") || prefixe.equalsIgnoreCase("DISTINCT")) {
                queryToUpdate.gluAllOrDistinct = new String[2];
                queryToUpdate.gluAllOrDistinct[0] = gluIndex;
                queryToUpdate.gluAllOrDistinct[1] = valueSet;
            } else {
                queryToUpdate.gluSelect.put(gluIndex, valueSet);
            }
        } else if (sourceGluAdqlTemplate.gluFrom.containsKey(gluIndex)) {
            valueSet = sourceGluAdqlTemplate.gluFrom.get(gluIndex);
            queryToUpdate.gluFrom.put(gluIndex, valueSet);
            queryToUpdate.gluTable = new String[2];
            queryToUpdate.gluTable[0] = gluIndex;
            queryToUpdate.gluTable[1] = valueSet;
        }
    }

    public void addFrom(String gluIndex, GluAdqlTemplate sourceGluAdqlTemplate) {
        this.gluFrom.put(gluIndex, sourceGluAdqlTemplate.gluFrom.get(gluIndex));
    }

    public void addWhere(String gluIndex, GluAdqlTemplate sourceGluAdqlTemplate) {
        this.gluWhere.put(gluIndex, sourceGluAdqlTemplate.gluWhere.get(gluIndex));
    }

    public void addSelect(String gluIndex, GluAdqlTemplate sourceGluAdqlTemplate) {
        this.gluSelect.put(gluIndex, sourceGluAdqlTemplate.gluSelect.get(gluIndex));
    }

    public Hashtable<String, String> getGluFrom() {
        return this.gluFrom;
    }

    public void setGluFrom(Hashtable<String, String> gluFrom) {
        this.gluFrom = gluFrom;
    }

    public Hashtable<String, String> getGluSelect() {
        return this.gluSelect;
    }

    public void setGluSelect(Hashtable<String, String> gluSelect) {
        this.gluSelect = gluSelect;
    }

    public Hashtable<String, String> getGluWhere() {
        return this.gluWhere;
    }

    public void setGluWhere(Hashtable<String, String> gluWhere) {
        this.gluWhere = gluWhere;
    }
}

