/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Configuration;
import cds.aladin.Constants;
import cds.aladin.GluAdqlTemplate;
import cds.aladin.GluApp;
import cds.aladin.MyInputStream;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.ServerGlu;
import cds.aladin.ServerSextractor;
import cds.aladin.ServerSkybot;
import cds.aladin.TapClient;
import cds.aladin.TapManager;
import cds.aladin.Tok;
import cds.aladin.TreeObj;
import cds.tools.UrlLoader;
import cds.tools.Util;
import cds.vizier.VizieRQuery;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public final class Glu
implements Runnable {
    private static int MAXPROF = 6;
    private static final int CHECKTIMEOUT = 1000;
    protected static String LOGSCRIPT = "nph-alalog.pl";
    protected static String ALADINLOG = "http://aladin.cds.unistra.fr/java/" + LOGSCRIPT;
    protected static String NPHGLU = "nph-glu.pl";
    protected static String NPHGLUALADIN = "http://aladin.cds.unistra.fr/java/" + NPHGLU;
    private static String KONQUEROR = "konqueror";
    private String[] BROWSERS = new String[]{"firefox", "mozilla", "netscape", "Netscape", KONQUEROR, "google-chrome"};
    static String BROWSER = null;
    public Aladin aladin;
    Thread thread;
    String param;
    static int nWindow = 0;
    static boolean newWindow = false;
    protected Hashtable aladinDic = null;
    protected Hashtable<String, GluTest> aladinDicT = null;
    protected Hashtable aladinDicFilters = null;
    protected static Vector vGluServer;
    protected static Vector vGluApp;
    protected TapManager tapManager;
    private static final String GLUDICPARAM = "?param=-p+-a+-w+Z:ALADIN";
    private static Method openURL;
    private boolean firstError = true;
    protected ServerGlu lastGluServer = null;
    protected ServerGlu lastTapGluServer = null;
    private String lastA = null;
    protected Vector AlaSites = new Vector();
    private boolean flagNoGlu;
    public static final int URL = 0;
    public static final int ENCODE = 1;
    public static final int NOURL = 2;
    private static String IP;
    private HashMap<String, GluHistory> gluHistory;
    protected boolean chut = false;
    private String lastId = null;
    private String indId = null;
    private boolean flagVers;
    private boolean lock = false;
    private int logCpt = 0;
    private Object lockLog = new Object();

    protected void tri() {
        Comparator c = TreeObj.getComparator();
        c = Server.getComparator();
        Collections.sort(vGluServer, c);
    }

    protected Glu(Aladin aladin) {
        this.aladin = aladin;
        this.aladinDic = new Hashtable();
        this.aladinDicT = new Hashtable();
        vGluServer = new Vector(50);
        vGluApp = new Vector(10);
        this.tapManager = TapManager.getInstance(aladin);
        try {
            String nphGlu = aladin.configuration.get(Configuration.GLU);
            if (nphGlu != null) {
                NPHGLUALADIN = nphGlu;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Aladin.STANDALONE) {
            try {
                if (Aladin.NETWORK) {
                    DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("/" + Aladin.ALAGLU));
                    this.loadGluDic(dis, false, false);
                    dis.close();
                    this.testNetwork();
                }
            }
            catch (Exception e) {
                Aladin.error("AlaGlu.dic not found !", 1);
            }
            this.addVOGluFile();
            this.addOtherGluFiles();
        }
        if (Aladin.NETWORK) {
            this.getRemoteGluDic();
        }
        this.tri();
    }

    protected void testNetwork() {
        if (!Aladin.TESTNETWORK) {
            return;
        }
        new Thread("Network test"){

            @Override
            public void run() {
                try {
                    Aladin.trace(3, "Testing network...");
                    if (!Glu.this.testCurrentAlaSite() && !Glu.this.testAlaSites(true, false)) {
                        Aladin cfr_ignored_0 = Glu.this.aladin;
                        Aladin.info(Aladin.chaine.getString("NONET"));
                    } else {
                        Glu.this.flagNoGlu = true;
                    }
                }
                catch (Exception e) {
                    Aladin cfr_ignored_1 = Glu.this.aladin;
                    Aladin.info(Aladin.chaine.getString("No full network access !"));
                    Glu.this.flagNoGlu = true;
                }
            }
        }.start();
    }

    void reload(boolean clearBefore, boolean showLastGlu) {
        if (clearBefore) {
            Aladin.cache.clear();
            this.aladin.glu = new Glu(this.aladin);
        }
        ServerDialog oldDialog = this.aladin.dialog;
        Point p = null;
        Dimension d = null;
        int c = this.aladin.dialog.current;
        try {
            p = this.aladin.dialog.getLocationOnScreen();
            d = this.aladin.dialog.getSize();
        }
        catch (Exception e) {
            p = null;
        }
        VizieRQuery.resetKeywords();
        this.aladin.dialog = new ServerDialog(this.aladin);
        if (showLastGlu) {
            int c1 = this.aladin.dialog.getLastGluServerIndice();
            if (this.lastTapGluServer != null) {
                c1 = this.aladin.dialog.getTapServerIndex();
                this.aladin.dialog.findReplaceServer(this.aladin.dialog.tapServer, this.lastTapGluServer);
                this.aladin.dialog.tapServer = this.lastTapGluServer;
                this.lastTapGluServer = null;
            } else if (oldDialog.tapServer != null) {
                this.aladin.dialog.findReplaceServer(this.aladin.dialog.tapServer, oldDialog.tapServer);
                this.aladin.dialog.tapServer = oldDialog.tapServer;
            }
            if (c1 != -1) {
                c = c1;
            }
        }
        this.tapManager.reloadTapServerList();
        this.aladin.dialog.setCurrent(c);
        if (p != null) {
            this.aladin.dialog.flagSetPos = true;
            this.aladin.dialog.setLocation(p);
            this.aladin.dialog.setSize(d);
        }
        if (oldDialog.isVisible() || showLastGlu) {
            this.aladin.dialog.showNow();
        }
        oldDialog.dispose();
    }

    private void addOtherGluFiles() {
        if (Aladin.GLUFILE == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(Aladin.GLUFILE, ";");
        while (st.hasMoreTokens()) {
            String filename = st.nextToken();
            try {
                DataInputStream dis;
                File f = new File(filename);
                boolean localFile = false;
                try {
                    InputStream in = null;
                    if (filename.startsWith("http://")) {
                        in = Util.openStream(filename);
                    } else {
                        in = new FileInputStream(f);
                        localFile = true;
                    }
                    dis = new DataInputStream(in);
                }
                catch (Exception e) {
                    dis = new DataInputStream(this.getClass().getResourceAsStream("/" + filename));
                }
                if (dis == null) {
                    throw new Exception();
                }
                if (!this.loadGluDic(dis, false, localFile)) {
                    throw new Exception();
                }
                Aladin.trace(1, "Additionnal " + (localFile ? "local" : "remote") + " Glu dic loaded [" + filename + "]");
                dis.close();
            }
            catch (Throwable e) {
                System.err.println("Cannot load the Glu dictionary: [" + filename + "]");
            }
        }
    }

    private void getRemoteGluDic() {
        URL url = null;
        try {
            url = Aladin.STANDALONE ? new URL(NPHGLUALADIN + GLUDICPARAM) : new URL(Aladin.CGIPATH + "/" + NPHGLU + GLUDICPARAM);
            Aladin.trace(1, "Loading the remote glu dictionary");
            Aladin.trace(3, "  => " + url);
            InputStream in = Aladin.cache.get(url);
            DataInputStream dis = new DataInputStream(in);
            this.loadGluDic(dis, true, false);
            try {
                dis.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.err.println("Remote Glu dictionary not reached");
        }
    }

    static String quote(String s) {
        char[] a = s.toCharArray();
        StringBuffer res = new StringBuffer("'");
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '\'') {
                res.append('\\');
            }
            res.append(a[i]);
        }
        res.append('\'');
        return res.toString();
    }

    static String doubleQuote(String s) {
        char[] a = s.toCharArray();
        StringBuffer res = new StringBuffer("\"");
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '\'') {
                res.append('\\');
            }
            res.append(a[i]);
        }
        res.append('\"');
        return res.toString();
    }

    private void setBrowser() {
        String[] cmd = new String[2];
        String defaultBrowser = this.aladin.configuration.get(Configuration.BROWSER);
        if (defaultBrowser != null) {
            BROWSER = defaultBrowser;
            return;
        }
        for (int i = 0; i < this.BROWSERS.length; ++i) {
            cmd[0] = this.BROWSERS[i];
            cmd[1] = "-v";
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
                int res = p.exitValue();
                if (res != 0) continue;
                BROWSER = this.BROWSERS[i];
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Aladin.error(Aladin.chaine.getString("NOBROWSER"));
        BROWSER = "";
    }

    protected void newWindow(boolean newWindow) {
        Glu.newWindow = newWindow;
    }

    protected void showDocument(String id, String params) {
        this.showDocument(id, params, false);
    }

    protected void showDocument(String url) {
        if (!Aladin.STANDALONE) {
            return;
        }
        try {
            this.showDocument(new URL(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showDocument(String id, String params, boolean encode) {
        URL url = this.getURL(id, params, encode);
        if (url == null) {
            return;
        }
        this.showDocument(url);
    }

    private void showDocument(URL url) {
        try {
            Desktop desktop = Desktop.getDesktop();
            URI uri = new URI(url.toString());
            desktop.browse(uri);
        }
        catch (Exception e) {
            if (this.firstError) {
                System.err.println("Browser launching Desktop method not supported, using old method...");
                this.firstError = false;
            }
            this.showDocumentOld(url);
        }
    }

    private void showDocumentOld(URL url) {
        String window = "";
        if (!Aladin.isApplet()) {
            String[] cmd = new String[3];
            if (newWindow) {
                window = ",aladin-" + nWindow;
                ++nWindow;
            }
            String syst = System.getProperty("os.name");
            Aladin.trace(1, "Launching the browser for [" + syst + "]");
            if (syst != null && syst.startsWith("Windows")) {
                try {
                    cmd[0] = "rundll32";
                    cmd[1] = "url.dll,FileProtocolHandler";
                    cmd[2] = url.toString();
                    Aladin.trace(2, "trying: " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
                    Process p = Runtime.getRuntime().exec(cmd);
                }
                catch (Exception e1) {
                    Aladin.error(Aladin.chaine.getString("ERRORBROWSER") + " " + e1);
                }
            } else if (syst != null && syst.startsWith("Mac")) {
                try {
                    if (openURL == null) {
                        Class<?> mrjClass = Class.forName("com.apple.mrj.MRJFileUtils");
                        openURL = mrjClass.getDeclaredMethod("openURL", String.class);
                    }
                    openURL.invoke(null, url.toString());
                }
                catch (Exception emac) {
                    Aladin.error(Aladin.chaine.getString("ERRORBROWSER") + " " + emac);
                }
            } else {
                if (BROWSER == null) {
                    this.setBrowser();
                }
                if (BROWSER.length() == 0) {
                    return;
                }
                try {
                    if (BROWSER.indexOf(KONQUEROR) >= 0) {
                        byte b;
                        String c = "dcop " + KONQUEROR + "*";
                        Process p = Runtime.getRuntime().exec(c);
                        InputStream in = p.getInputStream();
                        StringBuffer konqID = new StringBuffer();
                        while ((b = (byte)in.read()) != -1 && b != 13 && b != 10) {
                            konqID.append((char)b);
                        }
                        p.waitFor();
                        if (p.exitValue() == 0 && konqID.toString().indexOf(KONQUEROR) >= 0) {
                            c = "dcop " + konqID + " konqueror-mainwindow#1 openURL " + url;
                            Aladin.trace(2, "Trying: " + c);
                            p = Runtime.getRuntime().exec(c);
                            p.waitFor();
                            if (p.exitValue() == 0) {
                                return;
                            }
                        }
                        Aladin.trace(2, "Trying: " + KONQUEROR + " " + url);
                        p = Runtime.getRuntime().exec(KONQUEROR + " " + url.toString());
                    } else {
                        if (BROWSER.indexOf("chrome") >= 0) {
                            String myCmd = BROWSER + " " + url.toString();
                            Aladin.trace(2, myCmd);
                            Process p = Runtime.getRuntime().exec(myCmd);
                            p.waitFor();
                            if (p.exitValue() == 0) {
                                return;
                            }
                            throw new Exception("Can not launch Chrome browser !");
                        }
                        cmd[0] = BROWSER;
                        cmd[1] = "-remote";
                        cmd[2] = "openURL(" + url.toString() + window + ")";
                        Aladin.trace(2, "Trying: " + cmd[0] + " " + cmd[1] + " " + cmd[2]);
                        Process p = Runtime.getRuntime().exec(cmd);
                        p.waitFor();
                        if (p.exitValue() == 0) {
                            return;
                        }
                        Aladin.trace(2, "Trying: " + cmd[0] + " " + url);
                        p = Runtime.getRuntime().exec(BROWSER + " " + url.toString());
                    }
                }
                catch (Exception e) {
                    System.out.println("Browser launching problem : " + e);
                }
            }
            return;
        }
        Aladin.trace(1, "Opening a new browser page");
        try {
            if (newWindow) {
                this.aladin.getAppletContext().showDocument(url, window);
            } else {
                this.aladin.getAppletContext().showDocument(url, "aladin");
            }
        }
        catch (Exception e) {
            System.err.println("showDocument() error : " + e);
        }
    }

    static int afterWord(char[] a, int i) {
        while (i < a.length && a[i] != ' ' && a[i] != '\t' && a[i] != '\n') {
            ++i;
        }
        return i == a.length ? -1 : i;
    }

    static int afterSpace(char[] a, int i) {
        while (i < a.length && (a[i] == ' ' || a[i] == '\t' || a[i] == '\n')) {
            ++i;
        }
        return i == a.length ? -1 : i;
    }

    static String getName(String s) {
        char[] a = s.toCharArray();
        if (a[0] != '%') {
            return null;
        }
        int i = Glu.afterWord(a, 1);
        if (i == -1) {
            return null;
        }
        return new String(a, 1, i - 1);
    }

    static String getValue(String s1, DataInputStream dis) {
        StringBuffer res = new StringBuffer();
        String s = new String(s1);
        char[] a = s.toCharArray();
        int i = Glu.afterWord(a, 0);
        if (i == -1) {
            return null;
        }
        if ((i = Glu.afterSpace(a, i)) == -1) {
            return null;
        }
        while (a[a.length - 1] == '\\') {
            block8: {
                res.append(a, i, a.length - i - 1);
                try {
                    while ((s = dis.readLine()) != null && (s.charAt(0) == '#' || s.trim().length() == 0)) {
                    }
                    if (s == null) {
                    }
                    break block8;
                }
                catch (Exception e) {
                    s = null;
                }
                break;
            }
            a = s.toCharArray();
            i = Glu.afterSpace(a, 0);
        }
        if (s != null) {
            res.append(a, i, a.length - i);
        }
        return res.toString();
    }

    static String getNumParam(String s) {
        int j;
        int i;
        char[] a = s.toCharArray();
        for (i = 0; i < a.length && (a[i] < '0' || a[i] > '9'); ++i) {
        }
        for (j = i + 1; j < a.length && a[j] >= '0' && a[j] <= '9'; ++j) {
        }
        return j < a.length ? new String(a, i, j - i) : "";
    }

    static String getValParam(String s) {
        int i;
        char[] a = s.toCharArray();
        for (i = 0; i < a.length && a[i] != ':' && a[i] != '='; ++i) {
        }
        return i < a.length ? new String(a, i + 1, a.length - i - 1) : s;
    }

    private int findGluServer(String actionName) {
        for (int i = vGluServer.size() - 1; i >= 0; --i) {
            ServerGlu gs = (ServerGlu)vGluServer.elementAt(i);
            if (gs == null || gs.gluTag == null || !actionName.equals(gs.gluTag)) continue;
            return i;
        }
        return -1;
    }

    protected boolean removeGluServer(String actionName) {
        int i = this.findGluServer(actionName);
        if (i == -1) {
            return false;
        }
        vGluServer.removeElementAt(i);
        return true;
    }

    protected int findGluApp(String actionName) {
        for (int i = vGluApp.size() - 1; i >= 0; --i) {
            GluApp gs = (GluApp)vGluApp.elementAt(i);
            if (actionName.equals(gs.tagGlu)) {
                return i;
            }
            if (gs.aladinLabel == null || !actionName.equals(gs.aladinLabel)) continue;
            return i;
        }
        return -1;
    }

    protected GluApp getGluApp(String actionName) {
        for (int i = vGluApp.size() - 1; i >= 0; --i) {
            GluApp gs = (GluApp)vGluApp.elementAt(i);
            if (!actionName.equals(gs.tagGlu)) continue;
            return gs;
        }
        return null;
    }

    protected GluApp getGluApp(int i) {
        return (GluApp)vGluApp.elementAt(i);
    }

    protected boolean removeGluApp(String actionName) {
        int i = this.findGluApp(actionName);
        if (i == -1) {
            return false;
        }
        vGluApp.removeElementAt(i);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeGluAppDic() {
        RandomAccessFile out = null;
        try {
            String file = this.aladin.getVOPath() + Util.FS + "VOTools.dic";
            File f = new File(file);
            f.delete();
            out = new RandomAccessFile(file, "rw");
            Enumeration e = vGluApp.elements();
            while (e.hasMoreElements()) {
                GluApp vo = (GluApp)e.nextElement();
                out.writeBytes(vo.getGluDic());
            }
            Aladin.trace(3, file + " successfully saved");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    private void addVOGluFile() {
        try {
            String file = this.aladin.getVOPath() + Util.FS + "VOTools.dic";
            File f = new File(file);
            DataInputStream dis = new DataInputStream(new FileInputStream(f));
            if (dis == null) {
                throw new Exception();
            }
            if (!this.loadGluDic(dis, false, true)) {
                throw new Exception();
            }
            Aladin.trace(1, "VOTools Glu dic loaded [" + file + "]");
            dis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void memoApplication(String actionName, String aladinLabel, String aladinMenuNumber, String description, String verboseDescr, String institute, String releaseNumber, String copyright, String docUser, String jar, String javaParam, String download, String webstart, String applet, String plugin, String dir, String aladinActivated, String system) {
        GluApp vo = this.getGluApp(actionName);
        if (vo != null) {
            vo.merge(aladinLabel, aladinMenuNumber, description, verboseDescr, institute, releaseNumber, copyright, docUser, jar, javaParam, download, webstart, applet, plugin, aladinActivated, 3);
        } else {
            vGluApp.addElement(new GluApp(this.aladin, actionName, aladinLabel, aladinMenuNumber, description, verboseDescr, institute, releaseNumber, copyright, docUser, jar, javaParam, dir, download, webstart, applet, plugin, aladinActivated, system, 3));
        }
    }

    protected GluApp addApplication(String actionName) {
        this.removeGluApp(actionName);
        GluApp ap = new GluApp(this.aladin, actionName);
        vGluApp.addElement(ap);
        return ap;
    }

    protected String[] getAppMenu() {
        String[] menu = new String[vGluApp.size()];
        Enumeration e = vGluApp.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            GluApp ga = (GluApp)e.nextElement();
            if (ga.canBeMenu()) {
                menu[i] = Util.slash(ga.aladinLabel != null ? ga.aladinLabel : ga.tagGlu);
            }
            ++i;
        }
        return menu;
    }

    private int hashSize(Hashtable h) {
        int max = -1;
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            try {
                int n = Integer.parseInt((String)e.nextElement());
                if (n <= max) continue;
                max = n;
            }
            catch (Exception exception) {}
        }
        return max;
    }

    private void memoServer(String actionName, String description, String verboseDescr, String aladinMenu, String aladinMenuNumber, String aladinLabel, String aladinLabelPlane, String docUser, Hashtable paramDescription1, Hashtable paramDataType1, Hashtable paramValue1, String resultDataType, int resultSubmitType, String institute, Vector aladinFilter1, String aladinLogo, String dir, boolean localFile, String system, StringBuffer record, String aladinProtocol, String[] tapTables, Hashtable<String, String> adqlSelect, Hashtable<String, String> adqlFrom, Hashtable<String, String> adqlWhere, Hashtable<String, String> adqlFunc, Hashtable<String, String> adqlFuncParams, boolean flagTapUpload) {
        int i;
        if (this.removeGluServer(actionName) && Aladin.levelTrace >= 3) {
            System.err.println("Server [" + actionName + ":" + description + "] redefined => Aladin will use the last one (remote)");
        }
        if (paramDescription1 == null) {
            return;
        }
        int n = this.hashSize(paramDescription1);
        int m = this.hashSize(paramDataType1);
        if (m > n) {
            n = m;
        }
        if ((m = this.hashSize(paramValue1)) > n) {
            n = m;
        }
        String[] paramDescription = new String[n];
        for (i = 1; i <= n; ++i) {
            paramDescription[i - 1] = (String)paramDescription1.get(i + "");
        }
        String[] paramDataType = new String[n];
        for (i = 1; i <= n; ++i) {
            paramDataType[i - 1] = (String)paramDataType1.get(i + "");
        }
        String[] paramValue = new String[n];
        for (i = 1; i <= n; ++i) {
            paramValue[i - 1] = (String)paramValue1.get(i + "");
        }
        String[] aladinFilter = null;
        if (aladinFilter1 != null && (n = aladinFilter1.size()) > 0) {
            aladinFilter = new String[n];
            Enumeration e = aladinFilter1.elements();
            for (i = 0; i < n; ++i) {
                aladinFilter[i] = (String)e.nextElement();
            }
        }
        if (system != null && system.trim().length() == 0) {
            system = null;
        }
        if (institute == null) {
            institute = description;
        }
        ServerGlu g = null;
        if (this.aladin != null) {
            if (actionName.equals("SkyBoT.IMCCE")) {
                g = new ServerSkybot(this.aladin, actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, resultDataType, institute, aladinFilter, aladinLogo, record);
            } else if (actionName.equals("sextractor")) {
                g = new ServerSextractor(this.aladin, actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, resultDataType, institute, aladinFilter, aladinLogo, record);
            } else if (aladinProtocol != null && Util.indexOfIgnoreCase(aladinProtocol, "TAPv1") == 0) {
                boolean hidden = true;
                GluAdqlTemplate gluAdqlTemplate = new GluAdqlTemplate(adqlSelect, adqlFrom, adqlWhere, adqlFunc, adqlFuncParams);
                Constants.TapClientMode clientMode = null;
                boolean isForDialog = true;
                if (aladinProtocol.endsWith("TREEPANEL")) {
                    clientMode = Constants.TapClientMode.TREEPANEL;
                    isForDialog = false;
                } else {
                    clientMode = aladinLabel.equalsIgnoreCase("TAP") ? Constants.TapClientMode.DIALOG : Constants.TapClientMode.STANDALONE;
                }
                TapClient tapClient = null;
                if (aladinLabel.equalsIgnoreCase("TAP")) {
                    tapClient = this.tapManager.getExistingTapClientForGluActionName(clientMode, actionName);
                    if (tapClient == null) {
                        tapClient = new TapClient(clientMode, this.tapManager, actionName, null, null);
                        this.tapManager.addNewTapClientToCache(isForDialog, actionName, tapClient);
                    }
                } else {
                    tapClient = new TapClient(clientMode, this.tapManager, actionName, null, null);
                    hidden = false;
                }
                g = new ServerGlu(this.aladin, actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, null, resultDataType, resultSubmitType, institute, aladinFilter, aladinLogo, dir, system, record, aladinProtocol, tapTables, gluAdqlTemplate, tapClient, flagTapUpload);
                g.setAdqlFunc(adqlFunc);
                g.setAdqlFuncParams(adqlFuncParams);
                g.HIDDEN = hidden;
                if (localFile) {
                    if (clientMode == Constants.TapClientMode.TREEPANEL) {
                        this.tapManager.showTapPanelFromTree(actionName, g);
                    } else if (clientMode == Constants.TapClientMode.DIALOG) {
                        this.lastTapGluServer = g;
                    }
                }
            } else {
                g = new ServerGlu(this.aladin, actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, null, resultDataType, resultSubmitType, institute, aladinFilter, aladinLogo, dir, system, record, aladinProtocol, null, null, null, false);
            }
            if (g != null) {
                vGluServer.addElement(g);
                if (!g.isHidden()) {
                    this.lastGluServer = g;
                }
            }
        }
    }

    private static String subCR(String s) {
        char[] a = s.toCharArray();
        int j = 0;
        int i = 0;
        while (i < a.length) {
            if (i < a.length - 1 && a[i] == '\\' && a[i + 1] == 'n') {
                a[j] = 10;
                ++i;
            } else {
                a[j] = a[i];
            }
            ++i;
            ++j;
        }
        return new String(a, 0, j).trim();
    }

    protected boolean loadGluDic(DataInputStream dis, boolean testDomain, boolean localFile) {
        return this.loadGluDic(dis, 0, testDomain, true, localFile);
    }

    private boolean isKey(String s, String key) {
        return this.isKey(s, key, false);
    }

    private boolean isKey(String s, String key, boolean testLang) {
        if (testLang) {
            try {
                String suf = this.aladin.configuration.getLang();
                if (suf.length() > 0 && s.equalsIgnoreCase(key + suf)) {
                    return true;
                }
            }
            catch (Exception e) {
                testLang = false;
            }
        }
        return s.equalsIgnoreCase(key);
    }

    protected boolean loadGluDic(DataInputStream dis, int profondeur, boolean testDomain, boolean overwrite, boolean localFile) {
        return this.loadGluDic(dis, profondeur, testDomain, overwrite, localFile, true);
    }

    protected boolean loadGluDic(DataInputStream dis, int profondeur, boolean testDomain, boolean overwrite, boolean localFile, boolean withLog) {
        String actionName = this.lastA;
        String id = null;
        String releaseNumber = null;
        String copyright = null;
        String copyrightUrl = null;
        String jar = null;
        String download = null;
        String webstart = null;
        String applet = null;
        String plugin = null;
        String javaParam = null;
        String dir = null;
        String aladinActivated = null;
        String system = null;
        String aladinMenu = null;
        String aladinMenuNumber = null;
        String aladinLabel = null;
        String aladinLabelPlane = null;
        String docUser = null;
        String url = null;
        String test = null;
        String s = null;
        String description = null;
        String verboseDescr = null;
        String ack = null;
        String resultDataType = null;
        String seeAction = null;
        String institute = null;
        String aladinLogo = null;
        String aladinUrlDemo = null;
        String aladinProtocol = null;
        Vector<String> recI = new Vector<String>();
        Hashtable<String, String> paramDescription = null;
        Hashtable<String, String> paramDataType = null;
        Hashtable<String, String> paramValue = null;
        Object adqls = null;
        Hashtable<String, String> adqlSelect = null;
        Hashtable<String, String> adqlFrom = null;
        Hashtable<String, String> adqlWhere = null;
        Hashtable<String, String> adqlFunc = null;
        Hashtable<String, String> adqlFuncParams = null;
        Vector<String> aladinFilter = null;
        String aladinSurvey = null;
        String aladinHpxParam = null;
        String skyFraction = null;
        String origin = null;
        String aladinBookmarks = null;
        StringBuffer record = null;
        boolean ignore = false;
        boolean distribAladin = !testDomain;
        boolean flagLabel = false;
        String aladinProfile = null;
        boolean flagPlastic = false;
        boolean flagTapServices = false;
        boolean flagTapUpload = false;
        int resultSubmitType = -1;
        int maxIndir = Integer.MAX_VALUE;
        String tablesIndex = "";
        String[] tapTables = null;
        paramDescription = new Hashtable<String, String>();
        paramDataType = new Hashtable<String, String>();
        paramValue = new Hashtable<String, String>(10);
        adqlSelect = new Hashtable<String, String>();
        adqlFrom = new Hashtable<String, String>();
        adqlWhere = new Hashtable<String, String>();
        adqlFunc = new Hashtable<String, String>();
        adqlFuncParams = new Hashtable<String, String>();
        aladinFilter = new Vector<String>(10);
        try {
            if (profondeur > MAXPROF) {
                throw new Exception("Cyclic GLU definitions");
            }
            while ((s = dis.readLine()) != null) {
                String v;
                String num;
                String key;
                StringTokenizer aST;
                String value;
                String name;
                if (s.equals("") || s.charAt(0) == '#' || (name = Glu.getName(s)) == null || (value = Glu.getValue(s, dis)) == null) continue;
                if (!overwrite) {
                    if (this.isKey(name, "A") || this.isKey(name, "ActionName")) {
                        if (ignore) {
                            ignore = false;
                        }
                        StringTokenizer st = new StringTokenizer(value);
                        while (st.hasMoreTokens()) {
                            String id1 = st.nextToken();
                            if (this.aladinDic.get(id1) == null) continue;
                            ignore = true;
                            Aladin.trace(3, "GLU record overwrite ignored: " + value);
                            break;
                        }
                    }
                    if (ignore) continue;
                }
                if (record != null && !this.isKey(name, "A") && !this.isKey(name, "ActionName")) {
                    record.append("%" + Util.fillWithBlank(name, 4) + " " + value + "\n");
                }
                if (this.isKey(name, "Aladin.Menu", true)) {
                    aladinMenu = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.UrlDemo")) {
                    aladinUrlDemo = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.Protocol")) {
                    aladinProtocol = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "SkyFraction")) {
                    skyFraction = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Origin")) {
                    origin = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "ReleaseNumber")) {
                    releaseNumber = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Download")) {
                    download = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Jar")) {
                    jar = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Id")) {
                    id = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Webstart")) {
                    webstart = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Applet")) {
                    applet = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Plugin")) {
                    plugin = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "JavaParam")) {
                    javaParam = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Dir")) {
                    dir = value;
                    continue;
                }
                if (this.isKey(name, "Aladin.Activated")) {
                    aladinActivated = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.Survey")) {
                    aladinSurvey = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.Bookmarks")) {
                    aladinBookmarks = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "System")) {
                    system = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "M.C", true) || this.isKey(name, "Copyright", true)) {
                    copyright = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Copyright.Url", false)) {
                    copyrightUrl = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.MenuNumber")) {
                    aladinMenuNumber = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.LabelPlane", true)) {
                    aladinLabelPlane = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.Logo")) {
                    aladinLogo = Glu.subCR(value);
                    continue;
                }
                if (this.isKey(name, "Aladin.Filter")) {
                    aladinFilter.addElement(Glu.subCR(value));
                    continue;
                }
                if (this.isKey(name, "F.U", true) || this.isKey(name, "Doc.User", true)) {
                    docUser = value;
                    continue;
                }
                if (this.isKey(name, "D", true) || this.isKey(name, "Description", true)) {
                    description = value;
                    continue;
                }
                if (this.isKey(name, "M.D", true) || this.isKey(name, "M.V", true) || this.isKey(name, "VD", true) || this.isKey(name, "VerboseDescr", true)) {
                    verboseDescr = value;
                    continue;
                }
                if (this.isKey(name, "Acknowledgement", true) || this.isKey(name, "Ack", true)) {
                    ack = value;
                    continue;
                }
                if (this.isKey(name, "R") || this.isKey(name, "ResultDataType")) {
                    resultDataType = value;
                    continue;
                }
                if (this.isKey(name, "ResultSubmitType")) {
                    resultSubmitType = this.getNum(value);
                    continue;
                }
                if (this.isKey(name, "A") || this.isKey(name, "ActionName")) {
                    block102: {
                        if (seeAction != null) {
                            recI.addElement(seeAction);
                            aST = new StringTokenizer(actionName);
                            while (aST.hasMoreTokens()) {
                                key = aST.nextToken();
                                this.aladinDic.put(key, "%I " + seeAction);
                            }
                        }
                        try {
                            if (this.hasValidProfile(aladinProfile, null, flagPlastic) && distribAladin) {
                                if (this.aladin != null && aladinBookmarks != null) {
                                    this.aladin.bookmarks.memoGluBookmarks(actionName, aladinBookmarks);
                                } else if (flagPlastic) {
                                    this.memoApplication(actionName, aladinLabel, aladinMenuNumber, description, verboseDescr, institute, releaseNumber, copyright, docUser, jar, javaParam, download, webstart, applet, plugin, dir, aladinActivated, system);
                                } else if (flagTapServices && flagLabel) {
                                    this.tapManager.addTapService(actionName, aladinLabel, url, description);
                                } else if (flagLabel && paramDescription.size() > 0) {
                                    this.memoServer(actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, resultDataType, resultSubmitType, institute, aladinFilter, aladinLogo, dir, localFile, localFile ? system : null, record, aladinProtocol, tapTables, adqlSelect, adqlFrom, adqlWhere, adqlFunc, adqlFuncParams, flagTapUpload);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace < 3) break block102;
                            System.err.println("Error in GLU record " + actionName);
                            e.printStackTrace();
                        }
                    }
                    distribAladin = !testDomain;
                    flagTapServices = false;
                    flagLabel = false;
                    flagPlastic = false;
                    aladinProtocol = null;
                    aladinProfile = null;
                    aladinUrlDemo = null;
                    if (!flagLabel) {
                        this.putAladinFilter(actionName, aladinFilter);
                    }
                    maxIndir = Integer.MAX_VALUE;
                    origin = null;
                    skyFraction = null;
                    id = null;
                    aladinBookmarks = null;
                    aladinHpxParam = null;
                    aladinSurvey = null;
                    aladinLogo = null;
                    institute = null;
                    test = null;
                    url = null;
                    seeAction = null;
                    docUser = null;
                    aladinLabelPlane = null;
                    aladinLabel = null;
                    aladinMenuNumber = null;
                    aladinMenu = null;
                    resultDataType = null;
                    ack = null;
                    verboseDescr = null;
                    description = null;
                    actionName = null;
                    aladinActivated = null;
                    system = null;
                    dir = null;
                    plugin = null;
                    applet = null;
                    webstart = null;
                    download = null;
                    javaParam = null;
                    jar = null;
                    releaseNumber = null;
                    copyrightUrl = null;
                    copyright = null;
                    paramDescription = new Hashtable();
                    paramDataType = new Hashtable();
                    paramValue = new Hashtable(10);
                    aladinFilter = new Vector(10);
                    adqlSelect = new Hashtable();
                    adqlFrom = new Hashtable();
                    adqlWhere = new Hashtable();
                    adqlFunc = new Hashtable();
                    adqlFuncParams = new Hashtable();
                    actionName = Glu.subCR(Glu.getValue(s, dis));
                    record = new StringBuffer(1000);
                    record.append("%" + Util.fillWithBlank(name, 4) + " " + actionName + "\n");
                    continue;
                }
                if (actionName != null && (name.equals("T") || name.equals("Test"))) {
                    test = value;
                    aST = new StringTokenizer(actionName);
                    while (aST.hasMoreTokens()) {
                        key = aST.nextToken();
                        try {
                            if (this.aladinDicT.get(key) != null) continue;
                            this.aladinDicT.put(key, new GluTest(test, name.equals("Test")));
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace < 3) continue;
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                if (name.equals("U") || name.equals("Url")) {
                    url = value;
                    aST = new StringTokenizer(actionName);
                    while (aST.hasMoreTokens()) {
                        this.aladinDic.put(aST.nextToken(), url);
                    }
                    continue;
                }
                if (name.equals("L") || name.equals("FullTextResult")) {
                    url = value;
                    if (!value.startsWith("http://") && !value.startsWith("https://")) continue;
                    aST = new StringTokenizer(actionName);
                    while (aST.hasMoreTokens()) {
                        this.aladinDic.put(aST.nextToken(), url);
                    }
                    continue;
                }
                if (name.equals("I") || name.equals("SeeAction")) {
                    int metric = 0;
                    int i = 0;
                    if (name.equals("I")) {
                        i = value.indexOf(58);
                        if (i > 0) {
                            try {
                                metric = Integer.parseInt(value.substring(i + 1));
                            }
                            catch (Exception e) {
                                metric = 10000;
                            }
                        } else {
                            i = value.length();
                        }
                    } else {
                        i = value.indexOf(32);
                        if (i > 0) {
                            try {
                                metric = Integer.parseInt(value.substring(i + 14));
                            }
                            catch (Exception e) {
                                metric = 10000;
                            }
                        } else {
                            i = value.length();
                        }
                    }
                    String iTag = value.substring(0, i);
                    if (metric < maxIndir) {
                        maxIndir = metric;
                        seeAction = iTag + (seeAction == null ? "" : "\t" + seeAction);
                    } else {
                        seeAction = (seeAction == null ? "" : seeAction + "\t") + iTag;
                    }
                    this.memoAlaSites(actionName, value.substring(0, i));
                    continue;
                }
                if (name.equals("Aladin.Label") || name.equals("Aladin.XLabel")) {
                    aladinLabel = Glu.subCR(value);
                    flagLabel = true;
                    continue;
                }
                if (name.equals("Aladin.Name")) {
                    aladinLabel = Glu.subCR(value);
                    continue;
                }
                if (name.equals("Aladin.Profile")) {
                    aladinProfile = value;
                    flagLabel = true;
                    continue;
                }
                if (name.equals("Aladin.VOLabel")) {
                    aladinLabel = Glu.subCR(value);
                    flagPlastic = true;
                    continue;
                }
                if (name.equals("Z") || name.equals("DistribDomain")) {
                    if (!Glu.getValue(s, dis).equals("ALADIN")) continue;
                    distribAladin = true;
                    continue;
                }
                if (name.equals("P.D") || name.equals("Param.Description")) {
                    paramDescription.put(Glu.getNumParam(value), Glu.getValParam(value));
                    continue;
                }
                if (name.equals("P.K") || name.equals("Param.DataType")) {
                    num = Glu.getNumParam(value);
                    v = Glu.getValParam(value);
                    paramDataType.put(num, v);
                    continue;
                }
                if (name.equals("M.I") || name.equals("Institute")) {
                    institute = value;
                    continue;
                }
                if (name.equals("P.V") || name.equals("Param.Value")) {
                    num = Glu.getNumParam(value);
                    v = Glu.getValParam(value);
                    String v1 = (String)paramValue.get(num);
                    v1 = v1 != null ? v1 + "\t" + v : v;
                    paramValue.put(num, v1);
                    continue;
                }
                if (name.equals("TAPTables")) {
                    String v2 = Glu.getValParam(value);
                    tapTables = Glu.splitNoProcess(v2);
                    continue;
                }
                if (name.startsWith("ADQL")) {
                    String paramName;
                    String[] clauseElements = name.split("\\.");
                    String num2 = Glu.getNumParam(value);
                    String v3 = Glu.getValParam(value);
                    if (clauseElements.length == 2) {
                        if (clauseElements[1].equals("Where")) {
                            adqlWhere.put(num2, v3);
                            continue;
                        }
                        if (clauseElements[1].equals("Select")) {
                            adqlSelect.put(num2, v3);
                            continue;
                        }
                        if (!clauseElements[1].equals("From")) continue;
                        adqlFrom.put(num2, v3);
                        continue;
                    }
                    if (name.startsWith("ADQL.FuncParam") && clauseElements.length > 3) {
                        paramName = name.replace("ADQL.FuncParam.", "");
                        adqlFuncParams.put(paramName, value);
                        continue;
                    }
                    if (!name.startsWith("ADQL.Func") || clauseElements.length <= 2) continue;
                    paramName = name.replace("ADQL.Func.", "");
                    adqlFunc.put(paramName, value);
                    continue;
                }
                if (name.equals("Aladin.TapService") && (value.equals("ALATAP") || value.equals("TAP") || value.equals("TAPv1"))) {
                    flagTapServices = true;
                    continue;
                }
                if (!name.equals("TAPTables.Upload")) continue;
                flagTapUpload = true;
            }
            dis.close();
            if (seeAction != null) {
                recI.addElement(seeAction);
                StringTokenizer aST = new StringTokenizer(actionName);
                while (aST.hasMoreTokens()) {
                    this.aladinDic.put(aST.nextToken(), "%I " + seeAction);
                }
            }
            if (this.hasValidProfile(aladinProfile, null, flagPlastic) && distribAladin) {
                if (aladinBookmarks != null) {
                    this.aladin.bookmarks.memoGluBookmarks(actionName, aladinBookmarks);
                } else if (flagPlastic) {
                    this.memoApplication(actionName, aladinLabel, aladinMenuNumber, description, verboseDescr, institute, releaseNumber, copyright, docUser, jar, javaParam, download, webstart, applet, plugin, dir, aladinActivated, system);
                } else if (flagTapServices && flagLabel) {
                    this.tapManager.addTapService(actionName, aladinLabel, url, description);
                } else if (flagLabel && paramDescription.size() > 0) {
                    this.memoServer(actionName, description, verboseDescr, aladinMenu, aladinMenuNumber, aladinLabel, aladinLabelPlane, docUser, paramDescription, paramDataType, paramValue, resultDataType, resultSubmitType, institute, aladinFilter, aladinLogo, dir, localFile, localFile ? system : null, record, aladinProtocol, tapTables, adqlSelect, adqlFrom, adqlWhere, adqlFunc, adqlFuncParams, flagTapUpload);
                }
            }
            if (!flagLabel) {
                this.putAladinFilter(actionName, aladinFilter);
            }
            Enumeration eI = recI.elements();
            while (eI.hasMoreElements()) {
                seeAction = (String)eI.nextElement();
                String firstAction = new StringTokenizer(seeAction, "\t").nextToken();
                if (this.aladinDic.get(firstAction) != null) continue;
                this.lastA = firstAction;
                this.loadRemoteGluRecord(firstAction, profondeur + 1);
            }
        }
        catch (Exception e) {
            System.err.println("loadGluDic error: " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private int getNum(String value) {
        int number = -1;
        try {
            number = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return number;
    }

    private static String[] split(String s) {
        Tok tok = new Tok(s, " \t");
        String[] rep = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            rep[i] = tok.nextToken();
            ++i;
        }
        return rep;
    }

    private static String[] splitNoProcess(String s) {
        StringTokenizer tok = new StringTokenizer(s, " \t");
        String[] rep = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            rep[i] = tok.nextToken();
            ++i;
        }
        return rep;
    }

    public void put(String actionName, String url) {
        this.aladinDic.put(actionName, url);
    }

    public String get(String actionName) {
        return (String)this.aladinDic.get(actionName);
    }

    private boolean isComparator(char ch) {
        return ch == '<' || ch == '>';
    }

    private boolean hasValidNumVersion(String s) {
        block16: {
            if (this.aladin == null) {
                return true;
            }
            double num = this.aladin.realNumVersion("v12.646");
            int test = 0;
            int i = 0;
            try {
                if (s.charAt(i) == '<') {
                    test = -2;
                    ++i;
                } else if (s.charAt(i) == '>') {
                    test = 2;
                    ++i;
                } else if (s.charAt(i) == '=') {
                    test = 0;
                    ++i;
                }
                if (s.charAt(i) == '=') {
                    test /= 2;
                    ++i;
                }
                double n = Double.parseDouble(s.substring(i));
                switch (test) {
                    case -2: {
                        return num < n;
                    }
                    case -1: {
                        return num <= n;
                    }
                    case 0: {
                        return num == n;
                    }
                    case 1: {
                        return num >= n;
                    }
                    case 2: {
                        return num > n;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("GLU Aladin.Profile version number error [" + s + "]");
                if (Aladin.levelTrace < 3) break block16;
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean hasValidProfile(String profile) {
        return this.hasValidProfile(profile, null, false);
    }

    private boolean hasValidProfile(String profile, String tree, boolean flagPlastic) {
        if (Aladin.OUTREACH && !flagPlastic && (profile == null || profile.indexOf("undergraduate") < 0)) {
            return false;
        }
        if (profile == null) {
            return true;
        }
        boolean rep = true;
        StringTokenizer st = new StringTokenizer(profile);
        while (rep && st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("undergraduate")) {
                if (tree != null) continue;
                rep &= Aladin.OUTREACH;
                continue;
            }
            if (s.equals("beta")) {
                rep &= Aladin.BETA;
                continue;
            }
            if (s.equals("proto")) {
                rep &= Aladin.PROTO;
                continue;
            }
            if (s.equals("applet")) {
                Glu glu = this;
                rep &= glu.aladin.isApplet();
                continue;
            }
            if (s.equals("standalone")) {
                rep &= Aladin.STANDALONE;
                continue;
            }
            if (Character.isDigit(s.charAt(0)) || this.isComparator(s.charAt(0))) {
                rep &= this.hasValidNumVersion(s);
                continue;
            }
            if (s.equals("hpx") || s.equals("localdef")) continue;
            rep = false;
        }
        return rep;
    }

    private void putAladinFilter(String A2, Vector AF) {
        int n;
        if (AF == null || (n = AF.size()) == 0) {
            return;
        }
        String[] filters = null;
        filters = new String[n];
        Enumeration e = AF.elements();
        for (int i = 0; i < n; ++i) {
            filters[i] = (String)e.nextElement();
        }
        if (this.aladinDicFilters == null) {
            this.aladinDicFilters = new Hashtable();
        }
        StringTokenizer aST = new StringTokenizer(A2);
        while (aST.hasMoreTokens()) {
            this.aladinDicFilters.put(aST.nextToken(), filters);
        }
    }

    private void memoAlaSites(String A2, String I) {
        if (!A2.equals("AlaU")) {
            return;
        }
        this.AlaSites.addElement(I);
    }

    private boolean testCurrentAlaSite() {
        try {
            URL testGlu = new URL(NPHGLUALADIN + "?J2000");
            DataInputStream dis = new DataInputStream(testGlu.openStream());
            if (!dis.readLine().startsWith("%DataTypeName")) {
                throw new Exception();
            }
            return true;
        }
        catch (Exception e) {
            int i;
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            if ((i = NPHGLUALADIN.indexOf(47, 8)) < 0) {
                i = NPHGLUALADIN.length();
            }
            String s = NPHGLUALADIN.substring(7, i);
            Aladin.trace(2, "GLU registry site not responding [" + s + "] => Aladin will select another one automatically...");
            return false;
        }
    }

    protected boolean testAlaSites(boolean firstOne, boolean flagConfig) {
        long minTime = Long.MAX_VALUE;
        String bestI = null;
        boolean flagInterrupt = false;
        Enumeration e = this.AlaSites.elements();
        while (e.hasMoreElements() && !flagInterrupt) {
            long time = Long.MAX_VALUE;
            String ala = null;
            try {
                URL testGlu;
                DataInputStream dis;
                long d1 = System.currentTimeMillis();
                ala = (String)e.nextElement();
                String s = this.aladinDic.get(ala) + "/" + NPHGLU;
                if (flagConfig) {
                    this.aladin.configuration.setSelectGluChoice(s);
                }
                if (!(dis = new DataInputStream((testGlu = new URL(s + "?J2000")).openStream())).readLine().startsWith("%DataTypeName")) {
                    throw new Exception();
                }
                time = System.currentTimeMillis() - d1;
            }
            catch (Exception e1) {
                if (Thread.currentThread().isInterrupted()) {
                    flagInterrupt = true;
                }
                time = Long.MAX_VALUE;
            }
            if (time < minTime) {
                minTime = time;
                bestI = ala;
            }
            if (!firstOne || bestI == null) continue;
            break;
        }
        if (bestI == null) {
            return false;
        }
        NPHGLUALADIN = this.aladinDic.get(bestI) + "/" + NPHGLU;
        Aladin.trace(3, "New Glu site selected: [" + NPHGLUALADIN + "]");
        this.aladinDic.put("AlaU", "%I " + bestI);
        return true;
    }

    protected String setDefaultGluSite(String s) {
        if (!s.endsWith("/" + NPHGLU)) {
            s = s + "/" + NPHGLU;
        }
        if (!this.flagNoGlu && s.equals(NPHGLUALADIN)) {
            return null;
        }
        NPHGLUALADIN = s;
        Aladin.trace(3, "New default Glu site: [" + NPHGLUALADIN + "]");
        try {
            this.aladin.configuration.set(Configuration.GLU, NPHGLUALADIN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flagNoGlu = this.testCurrentAlaSite();
        if (!this.flagNoGlu) {
            Aladin.error(Aladin.chaine.getString("NOGLU1") + " \n" + NPHGLUALADIN + " " + Aladin.chaine.getString("NOGLU2"));
            this.testAlaSites(true, false);
            return NPHGLUALADIN;
        }
        return null;
    }

    static String removeBackslash(String s, char x) {
        int i;
        if (s.length() == 0) {
            return s;
        }
        char[] a = s.toCharArray();
        StringBuffer res = new StringBuffer();
        for (i = 0; i < a.length - 1; ++i) {
            if (a[i] == '\\' && a[i + 1] == x) continue;
            res.append(a[i]);
        }
        res.append(a[i]);
        return res.toString();
    }

    static String prefixQuote(String s) {
        char[] a = s.toCharArray();
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == '\"') {
                b.append('\\');
            }
            b.append(a[i]);
        }
        return b.toString();
    }

    static String[] cutParam(String s) {
        char[] a = s.toCharArray();
        int i = 0;
        Vector<String> p = new Vector<String>(3);
        String[] res = null;
        while ((i = Glu.afterSpace(a, i)) != -1) {
            int deb;
            if (a[i] == '\'' || a[i] == '\"') {
                char quote = a[i];
                deb = ++i;
                while (i < a.length && (a[i] != quote || a[i - 1] == '\\')) {
                    ++i;
                }
                if (i == a.length) break;
                p.addElement(Glu.removeBackslash(new String(a, deb, i - deb), quote));
                ++i;
                continue;
            }
            deb = i;
            if ((i = Glu.afterWord(a, i)) == -1) {
                p.addElement(new String(a, deb, a.length - deb));
                break;
            }
            p.addElement(new String(a, deb, i - deb));
        }
        res = new String[p.size()];
        for (i = 0; i < res.length; ++i) {
            res[i] = new String((String)p.elementAt(i));
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static String dollarSet(String s, String[] param, int mode) {
        i = 0;
        afterQuestion = false;
        res = new StringBuilder();
        encode = (mode & 1) == 1;
        isurl = (mode & 2) == 0;
        isMultiple = false;
        multipleParams = null;
        if (s.length() == 0) {
            return "";
        }
        a = s.toCharArray();
        questionMark = isurl != false && a[a.length - 1] == '?';
        paramRaw = Arrays.copyOf(param, param.length);
        block4: while (true) {
            block26: {
                deb = i;
                num = -1;
                while (true) {
                    if (i < a.length && a[i] != '$') {
                        if (isurl && !encode && !afterQuestion && a[i] == '?') {
                            afterQuestion = true;
                            for (j = 0; j < param.length; ++j) {
                                param[j] = URLEncoder.encode(param[j]);
                            }
                        }
                        ++i;
                        continue;
                    }
                    if (i == a.length) break block4;
                    if (isMultiple && a[deb] == '*') {
                        ++deb;
                        isMultiple = false;
                    }
                    offsetNum = ++i;
                    while (i < a.length && a[i] >= '0' && a[i] <= '9') {
                        ++i;
                    }
                    try {
                        num = Integer.parseInt(new String(a, offsetNum, i - offsetNum));
                    }
                    catch (NumberFormatException e) {
                        num = 0;
                    }
                    if (--num >= 0) break;
                }
                okToRemovePrefix = offsetNum >= 2 && a[offsetNum - 2] == '=' && (i >= a.length || a[i] == '&' || a[i] == '*');
                isMultiple = offsetNum >= 2 && a[offsetNum - 2] == '=' && i < a.length && a[i] == '*';
                if (isurl && okToRemovePrefix && (num >= param.length || param[num].length() == 0)) {
                    for (fin = offsetNum - 1; fin > 0 && a[fin] != '&' && a[fin] != '?' && a[fin] != '*'; --fin) {
                    }
                    if (fin == 0) {
                        fin = offsetNum - 1;
                    } else if (a[fin] == '?') {
                        ++fin;
                    }
                }
                paramName = new String(a, deb, fin - deb);
                res.append(paramName);
                if (num >= param.length) continue;
                if (isMultiple) {
                    try {
                        multipleParams = Glu.splitNoProcess(paramRaw[num].trim());
                        if (multipleParams != null && multipleParams.length > 0) {
                            res.append(URLEncoder.encode(multipleParams[0], "UTF-8"));
                            for (j = 1; j < multipleParams.length; ++j) {
                                res.append(paramName).append(URLEncoder.encode(multipleParams[j], "UTF-8"));
                            }
                            break block26;
                        }
                        res.append(param[num]);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else {
                    res.append(param[num]);
                }
            }
            if (!isurl || encode || afterQuestion) continue;
            k = 0;
            while (true) {
                if (k >= param[num].length()) continue block4;
                if (param[num].charAt(k) == '?') {
                    afterQuestion = true;
                    j = 0;
                    while (true) {
                        if (j < param.length) ** break;
                        continue block4;
                        param[j] = URLEncoder.encode(param[j]);
                        ++j;
                    }
                }
                ++k;
            }
            break;
        }
        res.append(new String(a, deb, a.length - deb));
        url = res.toString();
        if (!questionMark) {
            n = url.length();
            if (isurl && n > 0 && url.charAt(n - 1) == '?') {
                url = url.substring(0, n - 1);
            }
        }
        return url;
    }

    String gluResolver(String id, String params, boolean encode) {
        return this.gluResolver(id, params, encode, 1);
    }

    String gluResolver(String id, String params, boolean encode, int indirectionIndex) {
        int i = id.lastIndexOf(44);
        if (i > 0) {
            id = id.substring(0, i);
        }
        if (!this.chut) {
            Aladin.trace(4, "Querying the inside GLU <&" + id + (encode ? ",n" : "") + (params.length() > 0 ? " " + params : "") + ">...");
        }
        String[] param = Glu.cutParam(params);
        String url = (String)this.aladinDic.get(id);
        if (url == null) {
            if (Aladin.NETWORK) {
                this.loadRemoteGluRecord(id);
                url = (String)this.aladinDic.get(id);
            }
        }
        if (indirectionIndex > 1 && (url == null || !url.startsWith("%I ") && url.indexOf("<&") < 0)) {
            return null;
        }
        int bond = 0;
        while (url != null && url.startsWith("%I ")) {
            if (bond > 16) {
                System.err.println("Too many GLU %I indirections (>16) => certainly a cycle => ignored");
                return null;
            }
            String iTag = "";
            int end = 2;
            int nIndex = bond == 0 ? indirectionIndex : 1;
            for (int index = 1; index <= nIndex; ++index) {
                int deb = end + 1;
                if ((end = url.indexOf(9, deb)) == -1) {
                    if (index != indirectionIndex) {
                        if (!this.chut) {
                            System.err.println("GLU %I indirection number " + indirectionIndex + " not existing => ignored");
                        }
                        return null;
                    }
                    end = url.length();
                }
                iTag = url.substring(deb, end);
            }
            url = (String)this.aladinDic.get(iTag);
            this.indId = iTag;
            ++bond;
        }
        if (url == null) {
            return null;
        }
        url = Glu.dollarSet(url, param, encode ? 1 : 0);
        url = this.gluRecFilter(url, indirectionIndex);
        return url;
    }

    protected ArrayList<String> getAllUrls(String id) {
        URL u;
        ArrayList<String> a = new ArrayList<String>();
        int i = 1;
        boolean oChut = this.chut;
        this.chut = true;
        do {
            if ((u = this.getURL(id, "", false, false, i)) != null) {
                a.add(u + "");
            }
            ++i;
        } while (u != null);
        this.chut = oChut;
        return a;
    }

    protected boolean setIndirectionByUrl(String id, String url) {
        URL u;
        int i = 1;
        do {
            if ((u = this.getURL(id, "", false, false, i)) != null && u.toString().equals(url)) {
                this.setIndirectionOrder(id, i - 1);
                return true;
            }
            ++i;
        } while (u != null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkIndirection(String id, String urlSuffix) {
        this.lastId = null;
        this.indId = null;
        this.chut = true;
        try {
            URL u = this.getURL(id, "", false, false, 2);
            if (u == null) {
                boolean bl = false;
                return bl;
            }
            long minTime = Long.MAX_VALUE;
            int indice = 0;
            int n = 0;
            while ((u = this.getURL(id, "", false, false, n + 1)) != null) {
                GluTest gt;
                GluTest gluTest = gt = this.indId == null ? null : this.aladinDicT.get(this.indId);
                if (gt == null) {
                    gt = this.aladinDicT.get(id);
                }
                String pa = gt != null && gt.params != null ? gt.params : "";
                boolean encode = gt != null ? gt.optN : false;
                String pattern = gt != null ? gt.pattern : null;
                boolean regex = gt != null ? gt.regex : false;
                u = this.getURL(id, pa, encode, false, n + 1);
                String url = u + (urlSuffix != null ? urlSuffix : "");
                UrlLoader in = null;
                long tps = -1L;
                long tps1 = -1L;
                try {
                    long t1 = System.currentTimeMillis();
                    in = new UrlLoader(new URL(url), 1000, pattern != null ? 2 : 1);
                    if (pattern != null) {
                        String data = in.getData();
                        boolean trouve = !regex ? data.indexOf(pattern) >= 0 : data.matches(pattern);
                        if (!trouve) {
                            throw new Exception("Pattern not found");
                        }
                    }
                    long t2 = System.currentTimeMillis();
                    tps1 = tps = t2 - t1;
                    tps = tps / 100L * 100L;
                    tps += (long)(Math.random() * 100.0);
                }
                catch (Exception e) {
                    tps = -1L;
                }
                Aladin.trace(4, "Glu.checkIndirection(...): " + id + "/" + (n + 1) + " => " + url + " => " + tps1 + "ms");
                if (tps != -1L && tps < minTime) {
                    minTime = tps;
                    indice = n;
                }
                ++n;
            }
            this.setIndirectionOrderOnLastId(indice);
        }
        finally {
            this.lastId = null;
            this.indId = null;
            this.chut = false;
        }
        return true;
    }

    protected static <K extends Comparable<K>, V> Map<K, V> sortGluHistory(Map<K, V> map, int ascending) {
        Comparator valueComparator = new Comparator<K>(){
            private int ascending;

            @Override
            public int compare(K k1, K k2) {
                int compare = k2.compareTo(k1);
                if (compare == 0) {
                    return 1;
                }
                return this.ascending * compare;
            }

            public Comparator<K> setParam(int ascending) {
                this.ascending = ascending;
                return this;
            }
        }.setParam(ascending);
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    private GluHistory GluHistoryFactory(String serialized) throws Exception {
        StringTokenizer tok = new StringTokenizer(serialized, ":");
        GluHistory gh = new GluHistory();
        gh.ip = tok.nextToken();
        gh.time = Long.parseLong(tok.nextToken());
        gh.tag = tok.nextToken();
        gh.aliases = "%I " + tok.nextToken().replace(',', '\t');
        return gh;
    }

    protected void setGluHistory(String serialized) {
        block3: {
            if (this.gluHistory == null) {
                this.gluHistory = new HashMap();
            }
            try {
                GluHistory gh = this.GluHistoryFactory(serialized);
                this.gluHistory.put(gh.tag, gh);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block3;
                e.printStackTrace();
            }
        }
    }

    private void setGluHistory(String tag, String aliases) {
        if (!aliases.startsWith("%I")) {
            return;
        }
        if (this.gluHistory == null) {
            this.gluHistory = new HashMap();
        }
        this.gluHistory.put(tag, new GluHistory(tag, aliases));
    }

    protected void saveGluHistory(BufferedWriter bw) throws Exception {
        if (this.gluHistory == null) {
            return;
        }
        int i = 1;
        for (GluHistory gh : Glu.sortGluHistory(this.gluHistory, 1).values()) {
            String key = Configuration.LASTGLU + i++;
            bw.write(Util.align(key, 20) + gh.getSerialized());
            bw.newLine();
            if (i <= 30) continue;
            break;
        }
    }

    protected boolean checkSiteHistory(String tag) {
        try {
            if (this.gluHistory == null) {
                return false;
            }
            GluHistory gh = this.gluHistory.get(tag);
            if (gh == null) {
                return false;
            }
            String actualAliases = (String)this.aladinDic.get(tag);
            if (!gh.isBetterThan(actualAliases)) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(gh.aliases, "\t");
            Aladin.trace(3, "Glu mirror by session history " + tag + " => " + st.nextToken());
            this.aladinDic.put(tag, gh.aliases);
            return true;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private void setIndirectionOrderOnLastId(int indiceOfTheBest) {
        this.setIndirectionOrder(this.lastId, indiceOfTheBest);
    }

    private void setIndirectionOrder(String id, int indiceOfTheBest) {
        if (id == null) {
            return;
        }
        String iTags = (String)this.aladinDic.get(id);
        if (!iTags.startsWith("%I ")) {
            return;
        }
        if (indiceOfTheBest == 0) {
            this.setGluHistory(id, iTags);
            return;
        }
        iTags = iTags.substring(3);
        StringTokenizer st = new StringTokenizer(iTags, "\t");
        String[] tags = new String[st.countTokens()];
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = st.nextToken();
        }
        StringBuilder seeActions = new StringBuilder("%I " + tags[indiceOfTheBest]);
        for (int i = 0; i < tags.length; ++i) {
            if (i == indiceOfTheBest) continue;
            seeActions.append("\t" + tags[i]);
        }
        this.aladinDic.put(id, seeActions + "");
        this.setGluHistory(id, seeActions + "");
        Aladin.trace(4, "Glu.CheckIndirections(" + id + ") => %I " + tags[indiceOfTheBest] + " => " + this.getURL(id, "", false, false, 1));
    }

    String gluSystem(String system, String params) {
        String[] param = Glu.cutParam(params);
        system = Glu.dollarSet(system, param, 2);
        return system;
    }

    private String gluRecFilter(String u, int indirectionIndex) {
        URL url;
        int j;
        int i = u.indexOf("<&");
        if (i < 0 || (j = u.indexOf(62, i)) < 0) {
            return u;
        }
        int k = u.indexOf(",", i);
        if (i >= k || k >= j) {
            k = j;
        }
        if ((url = this.getURL(u.substring(i + 2, k).trim(), "", false, false, indirectionIndex)) == null) {
            return null;
        }
        return u.substring(0, i) + url + u.substring(j + 1);
    }

    private void loadRemoteGluRecord(String id) {
        this.loadRemoteGluRecord(id, 0);
    }

    private void loadRemoteGluRecord(String id, int profondeur) {
        try {
            URL url = new URL(NPHGLUALADIN + "?" + URLEncoder.encode(id) + "&param=-p");
            Aladin.trace(3, "Loading GLU record for \"" + id + "\" from " + url + "...");
            this.loadGluDic(new DataInputStream(url.openStream()), profondeur, true, true, false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public MyInputStream getMyInputStream(String uri, boolean withLog) throws Exception {
        MyInputStream is;
        if (!uri.startsWith("http:") && !uri.startsWith("ftp:")) {
            is = new MyInputStream(new FileInputStream(this.aladin.getFullFileName(uri)));
            is = is.startRead();
        } else {
            URL u = Aladin.STANDALONE ? new URL(uri) : this.getURL("Http", uri, true, withLog);
            is = Util.openStream(u);
        }
        return is;
    }

    public URL getURL(String id) {
        return this.getURL(id, "", false, true, 1);
    }

    public URL getURL(String id, String params) {
        return this.getURL(id, params, false, true, 1);
    }

    public URL getURL(String id, String params, boolean encode) {
        return this.getURL(id, params, encode, true, 1);
    }

    public URL getURL(String id, String params, boolean encode, boolean withLog) {
        return this.getURL(id, params, encode, withLog, 1);
    }

    public URL getURL(String id, String params, boolean encode, boolean withLog, int indexIndirection) {
        URL url = null;
        this.lastId = id;
        if (!Aladin.NETWORK) {
            return null;
        }
        if (!this.chut) {
            Aladin.trace(7, "Glu.getURL(" + id + (params == null || params.length() == 0 ? "" : " params=" + params) + " encode=" + encode + " withLog=" + withLog + " indexIndirection=" + indexIndirection + ")");
        }
        if (withLog) {
            this.log(id, params);
        }
        String option = encode ? ",n" : ",";
        try {
            if (Aladin.STANDALONE) {
                String u = this.gluResolver(id, params, encode, indexIndirection);
                if (u == null) {
                    if (!this.chut) {
                        Aladin.trace(3, "getURL error: glu record \"" + id + "\" not found !\n");
                    }
                    return null;
                }
                url = new URL(u);
            } else {
                option = option + "R";
                String tag = "<&" + id + option + " " + params + ">";
                url = new URL(Aladin.CGIPATH + "/" + NPHGLU + "?" + URLEncoder.encode(tag));
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                System.err.println("getURL error: " + e);
                e.printStackTrace();
            }
            return null;
        }
        if (!this.chut) {
            Aladin.trace(4, "Get: " + (url == null ? "null" : url.toString()));
        }
        return url;
    }

    private void waitLock() {
        while (!this.getLock()) {
            Util.pause(100);
            Aladin.trace(4, "Glu.waitLock...");
        }
    }

    synchronized boolean getLock() {
        if (this.lock) {
            return false;
        }
        this.lock = true;
        return true;
    }

    synchronized void unlock() {
        this.lock = false;
    }

    protected void log(String id, String params) {
        boolean bl = this.flagVers = Aladin.STANDALONE && id.equals("Start");
        if (!Aladin.NETWORK || !this.flagVers && !this.aladin.configuration.isLog()) {
            return;
        }
        if (id.equals("VizX")) {
            return;
        }
        if (id.equals("Load")) {
            params = "";
        }
        if (id.equals("Http") && params != null && (params.indexOf("u-strasbg.fr") < 0 || params.indexOf("unistra.fr") < 0)) {
            params = "";
        }
        try {
            this.waitLock();
            this.param = ALADINLOG + "?id=" + (id == null ? "" : URLEncoder.encode(id)) + "&params=" + (params == null ? "" : URLEncoder.encode(params));
            this.thread = new Thread((Runnable)this, "AladinLog");
            Util.decreasePriority(Thread.currentThread(), this.thread);
            this.thread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            String tmp = this.param;
            boolean flagTmp = this.flagVers;
            this.unlock();
            try {
                URL url;
                if (Aladin.APPLETSERVER == null && Aladin.RHOST == null) {
                    url = new URL(tmp);
                } else {
                    tmp = tmp + "&host=";
                    if (Aladin.RHOST != null) {
                        tmp = tmp + Aladin.RHOST;
                    }
                    url = this.getURL("Http", tmp, true, false);
                }
                InputStream is = null;
                try {
                    this.logIncr();
                    is = url.openStream();
                    if (flagTmp) {
                        this.aladin.waitDialog();
                        DataInputStream dis = new DataInputStream(is);
                        this.aladin.setCurrentVersion(dis.readLine());
                        try {
                            String msg = null;
                            while ((msg = dis.readLine()) != null && (msg.trim().length() == 0 || msg.startsWith("#"))) {
                            }
                            if (msg != null) {
                                this.aladin.setCDSMessage(msg);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    is.close();
                    is = null;
                }
                finally {
                    this.logDecr();
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Exception elog) {
                if (Aladin.levelTrace < 3) break block14;
                elog.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLogging() {
        Object object = this.lockLog;
        synchronized (object) {
            return this.logCpt > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logIncr() {
        Object object = this.lockLog;
        synchronized (object) {
            ++this.logCpt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDecr() {
        Object object = this.lockLog;
        synchronized (object) {
            --this.logCpt;
        }
    }

    static {
        openURL = null;
        IP = null;
    }

    class GluTest {
        String pattern;
        boolean regex;
        String params;
        boolean optN;
        String PATTERN = "pattern=";
        String OPTION = "option=";
        String PARAM = "param=";

        GluTest(String s, boolean longSyntax) throws Exception {
            if (longSyntax) {
                this.set1(s);
            } else {
                this.set0(s);
            }
        }

        private void set0(String s) throws Exception {
            int i = s.indexOf(58);
            int j = s.indexOf(58, i + 1);
            if (i == -1 || j == -1) {
                throw new Exception("%T syntax error [" + s + "]");
            }
            this.set(i > 0 ? s.substring(0, i) : null, i + 1 < j ? s.substring(i + 1, j) : null, s.substring(j + 1));
        }

        private void set1(String s) throws Exception {
            String pt = null;
            String op = null;
            String pa = null;
            int i = s.indexOf(this.PATTERN);
            if (i >= 0) {
                pt = new Tok(s.substring(i + this.PATTERN.length())).nextToken();
            }
            if ((i = s.indexOf(this.OPTION)) >= 0) {
                op = new Tok(s.substring(i + this.OPTION.length())).nextToken();
            }
            if ((i = s.indexOf(this.PARAM)) >= 0) {
                pa = new Tok(s.substring(i + this.PARAM.length())).nextToken();
            }
            this.set(pt, op, pa);
        }

        private void set(String pt, String op, String pa) {
            if (pt != null && pt.length() > 0) {
                this.regex = pt.length() > 2 && pt.charAt(0) == '/';
                this.pattern = this.regex ? pt.substring(1, pt.length() - 1) : pt;
            }
            boolean bl = this.optN = op != null && op.indexOf(110) >= 0;
            if (pa != null && pa.length() > 0) {
                this.params = pa;
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.pattern != null) {
                s.append(" pattern=[" + this.pattern + "]");
            }
            if (this.regex) {
                s.append(" regex");
            }
            if (this.optN) {
                s.append(" optN");
            }
            if (this.params != null) {
                s.append(" params=[" + this.params + "]");
            }
            return s.toString();
        }
    }

    class GluHistory
    implements Comparator {
        long time;
        String ip;
        String tag;
        String aliases;

        GluHistory() {
        }

        GluHistory(String tag, String aliases) {
            try {
                if (IP == null) {
                    IP = this.getIP();
                }
            }
            catch (Exception e) {
                IP = "UnknownIP";
            }
            this.ip = IP;
            this.time = this.time = System.currentTimeMillis() / 1000L;
            this.tag = tag;
            this.aliases = aliases;
        }

        String getIP() throws Exception {
            String IP = InetAddress.getLocalHost().getHostAddress();
            int i = IP.lastIndexOf(46);
            if (i > 0) {
                IP = IP.substring(0, i) + ".*";
            }
            return IP;
        }

        String getSerialized() {
            return this.ip + ":" + this.time + ":" + this.tag + ":" + this.aliases.substring(3).replace('\t', ',');
        }

        boolean isBetterThan(String aliases) {
            String[] b;
            try {
                if (IP == null) {
                    IP = this.getIP();
                }
            }
            catch (Exception e) {
                IP = "UnknownIP";
            }
            long delai = System.currentTimeMillis() / 1000L - this.time;
            if (delai < 86400L) {
                return true;
            }
            if (delai > 2592000L) {
                return false;
            }
            if (!IP.equals(this.ip) || IP.startsWith("192.")) {
                return false;
            }
            String[] a = aliases.substring(3).split("\t");
            if (a.length != (b = this.aliases.substring(3).split("\t")).length) {
                return false;
            }
            for (String s : b) {
                if (Util.indexInArrayOf(s, a) >= 0) continue;
                return false;
            }
            return true;
        }

        public int compare(Object o1, Object o2) {
            return (int)(((GluHistory)o1).time - ((GluHistory)o2).time);
        }
    }
}

