/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Tok;
import cds.tools.Util;

public class Function {
    private StringBuffer name = new StringBuffer();
    private StringBuffer param = new StringBuffer();
    private StringBuffer code = new StringBuffer();
    private StringBuffer description = new StringBuffer();
    private boolean localDefinition = false;
    private boolean bookmark = false;
    private int nbParam = -1;
    private int etat = 0;
    private int nbAcc = 0;
    private boolean NL = true;
    private boolean modif = false;

    public Function() {
    }

    public Function(String name, String param, String code, String description) {
        this.setName(name);
        this.setParam(param);
        this.setCode(code);
        this.setDescription(description);
    }

    public Function(String s) throws Exception {
        if (!this.parseFunction(s)) {
            throw new Exception("Function truncated [" + s + "]");
        }
    }

    public String getName() {
        return this.name.toString().trim();
    }

    public String getCode() {
        return this.code.toString();
    }

    public String getParam() {
        return this.param.toString();
    }

    public String getDescription() {
        return this.description.toString();
    }

    public void setName(String name) {
        this.name = new StringBuffer(name == null ? "" : name);
        this.modif = true;
    }

    public void setCode(String code) {
        this.code = new StringBuffer(code == null ? "" : code);
        this.modif = true;
    }

    public void setParam(String param) {
        this.param = new StringBuffer(param == null ? "" : param);
        this.nbParam = -1;
        this.modif = true;
    }

    public void setDescription(String description) {
        this.description = new StringBuffer(description == null ? "" : description);
        this.modif = true;
    }

    public void setLocalDefinition(boolean flag) {
        this.localDefinition = flag;
    }

    public void setBookmark(boolean flag) {
        this.bookmark = flag;
    }

    public boolean isLocalDefinition() {
        return this.localDefinition;
    }

    public boolean isBookmark() {
        return this.bookmark;
    }

    public void setModif(boolean flag) {
        this.modif = flag;
    }

    public boolean hasBeenModif() {
        return this.modif;
    }

    public int getNbParam() {
        if (this.nbParam < 0) {
            if (this.param.toString().trim().length() == 0) {
                this.nbParam = 0;
            } else {
                this.nbParam = 1;
                for (int i = this.param.length() - 1; i >= 0; --i) {
                    if (this.param.charAt(i) != ',') continue;
                    ++this.nbParam;
                }
            }
        }
        return this.nbParam;
    }

    public boolean isOk() {
        return this.etat == 6;
    }

    public String toString() {
        return this.toString("\n");
    }

    public String toString(String CR) {
        StringBuffer s = new StringBuffer(this.description.length() > 0 ? "#" + this.description + CR : "");
        s.append("function " + this.getName());
        if (this.getNbParam() > 0) {
            s.append("(" + this.param + ")");
        }
        s.append(" {" + CR);
        String code = this.getCode();
        if (!CR.equals("\n")) {
            code = code.replaceAll("\n", CR);
        }
        s.append(code);
        s.append(CR + "}" + CR);
        return s.toString();
    }

    public String exec(Aladin aladin, String param, boolean flagLot) throws Exception {
        String codeWithParam = this.getCodeWithParam(aladin, param);
        if (!flagLot) {
            aladin.execAsyncCommand(codeWithParam);
        } else {
            aladin.console.addLot(codeWithParam);
        }
        return "";
    }

    private String getCodeWithParam(Aladin aladin, String param) throws Exception {
        String code = this.getCode();
        Tok p = new Tok(this.getParam(), ", ");
        Tok v = new Tok(param, ", ");
        while (p.hasMoreTokens()) {
            String p1 = p.nextToken();
            String v1 = v.nextToken();
            v1 = this.targetRadiusSpecialCase(aladin, p1, v1);
            code = code.replaceAll("\\" + p1, v1);
        }
        return code;
    }

    private String targetRadiusSpecialCase(Aladin aladin, String p1, String v1) {
        if (v1.length() == 0) {
            if (p1.equals("$TARGET")) {
                return this.getTarget(aladin);
            }
            if (p1.equals("$RADIUS")) {
                return this.getRadius(aladin);
            }
        }
        return v1;
    }

    protected String getTarget(Aladin aladin) {
        String target = "";
        try {
            target = aladin.localisation.getTextSaisie().trim();
            if (target.length() == 0 || target.equals(aladin.GETOBJ) || aladin.command.isCommand(new Tok(target).nextToken())) {
                target = aladin.view.getCurrentView().getCentre();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return target;
    }

    protected String getRadius(Aladin aladin) {
        String radius = "";
        try {
            double r = Util.round(aladin.view.getCurrentView().getTaille() * 60.0, 1);
            radius = r + "'";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return radius;
    }

    protected boolean parseFunction(String s) throws Exception {
        this.modif = true;
        char[] a = s.toCharArray();
        block9: for (int i = 0; i < a.length; ++i) {
            char ch = a[i];
            if (ch == '\r') continue;
            if (this.etat != 5 && this.etat != -1 && ch == '\n') {
                ch = ' ';
            }
            switch (this.etat) {
                case -1: {
                    if (ch == '\n' || i == a.length - 1) {
                        this.etat = 0;
                    }
                    if (ch == 10) continue block9;
                    this.description.append(ch);
                    continue block9;
                }
                case 0: {
                    if (Character.isSpaceChar(ch)) continue block9;
                    if (ch == '#') {
                        this.etat = -1;
                        continue block9;
                    }
                    if (!s.substring(i, i + 8).equals("function")) {
                        throw new Exception("Function syntax error [" + s + "]");
                    }
                    this.etat = 1;
                    i += 7;
                    continue block9;
                }
                case 1: {
                    if (Character.isSpaceChar(ch)) continue block9;
                    this.etat = 2;
                }
                case 2: {
                    if (ch == '(') {
                        this.etat = 4;
                        continue block9;
                    }
                    if (ch == '{') {
                        this.etat = 5;
                        this.nbAcc = 1;
                        continue block9;
                    }
                    this.name.append(ch);
                    continue block9;
                }
                case 3: {
                    if (Character.isSpaceChar(ch)) continue block9;
                    if (ch == '(') {
                        this.etat = 4;
                        continue block9;
                    }
                    if (ch == '{') {
                        this.etat = 5;
                        this.nbAcc = 1;
                        continue block9;
                    }
                    throw new Exception("function syntax error [" + s + "]");
                }
                case 4: {
                    if (ch == ')') {
                        this.etat = 3;
                        continue block9;
                    }
                    this.param.append(ch);
                    continue block9;
                }
                case 5: {
                    if (ch == '{') {
                        ++this.nbAcc;
                    } else if (ch == '}') {
                        --this.nbAcc;
                    }
                    if (this.nbAcc == 0) {
                        this.etat = 6;
                        if (this.NL && this.code.length() > 0) {
                            this.code.delete(this.code.length() - 1, this.code.length());
                        }
                        return true;
                    }
                    if (this.NL && (ch == 10 || ch == ' ')) continue block9;
                    if (this.NL) {
                        this.code.append("   ");
                    }
                    this.NL = ch == '\n';
                    this.code.append(ch);
                    if (i != a.length - 1 || this.NL) continue block9;
                    this.code.append('\n');
                    this.NL = true;
                }
            }
        }
        int j = this.code.indexOf("get allsky");
        if (j > 0) {
            this.code = this.code.replace(j + 4, j + 10, "hips");
        }
        return false;
    }
}

