/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameRGB;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class FrameRGBBlink
extends JFrame
implements ActionListener {
    String SUBMIT;
    String RESET;
    String HELP;
    String CANCEL;
    String NONE;
    String MISSING;
    Aladin a;
    boolean flagHide = true;
    protected JComboBox[] ch;
    Plan[] choicePlan;
    JButton submitBtn;

    protected void createChaine() {
        this.SUBMIT = Aladin.chaine.getString("IMGCREATE");
        this.RESET = Aladin.chaine.getString("IMGRESET");
        this.HELP = Aladin.chaine.getString("IMGHELP");
        this.CANCEL = Aladin.chaine.getString("IMGCLOSE");
        this.NONE = Aladin.chaine.getString("IMGNONE");
        this.MISSING = Aladin.chaine.getString("IMGMISSING");
    }

    protected FrameRGBBlink(Aladin aladin) {
        this.a = aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.getTitre());
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
        this.setLocation(Aladin.computeLocation(this));
        this.choicePlan = new Plan[0];
        this.createPanel();
    }

    protected abstract String getTitre();

    protected abstract String getHelp();

    protected abstract String getInformation();

    protected abstract int getNb();

    protected abstract String getLabelSelector(int var1);

    protected abstract Color getColorLabel(int var1);

    protected abstract JPanel getAddPanel();

    protected JButton[] getAddButtons() {
        return null;
    }

    protected abstract int getToolNumber();

    protected void createPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.setLayout(g);
        JLabel l = new JLabel(Util.fold("<center>" + this.getInformation() + "</center>", 80, true), 0);
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        g.setConstraints(l, c);
        p.add(l);
        GridBagLayout g1 = new GridBagLayout();
        JPanel p1 = new JPanel(g1);
        int n = this.getNb();
        this.ch = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            this.ch[i] = new JComboBox();
            this.ch[i].addActionListener(this);
            this.ch[i].setFont(Aladin.BOLD);
            JLabel ll = new JLabel(this.getLabelSelector(i));
            ll.setForeground(this.getColorLabel(i));
            ll.setFont(Aladin.BOLD);
            c.gridwidth = -1;
            c.weightx = 0.0;
            g1.setConstraints(ll, c);
            p1.add(ll);
            c.gridwidth = 0;
            c.weightx = 10.0;
            g1.setConstraints(this.ch[i], c);
            p1.add(this.ch[i]);
        }
        if (n <= 6) {
            g.setConstraints(p1, c);
            p.add(p1);
        } else {
            JScrollPane pane = new JScrollPane(p1);
            pane.setPreferredSize(new Dimension(300, 180));
            g.setConstraints(pane, c);
            p.add(pane);
        }
        JPanel add = this.getAddPanel();
        if (add != null) {
            g.setConstraints(add, c);
            p.add(add);
        }
        JPanel v = this.valid();
        g.setConstraints(v, c);
        p.add(v);
        this.getContentPane().add((Component)p, "Center");
        this.pack();
    }

    protected void adjustImageChoice(JComboBox c, int defaut) {
        int i = c.getSelectedIndex();
        String s = i >= 0 ? (String)c.getItemAt(i) : null;
        c.removeAllItems();
        this.setItems(c);
        if (defaut >= 0) {
            c.setSelectedIndex(defaut);
        } else if (s == null) {
            c.setSelectedIndex(0);
        } else {
            c.setSelectedItem(s);
        }
    }

    protected synchronized void setItems(JComboBox c) {
        c.addItem(this.NONE);
        for (int i = 0; i < this.choicePlan.length; ++i) {
            c.addItem(this.choicePlan[i].label + " - \"" + this.choicePlan[i].objet + "\"");
        }
    }

    protected Plan[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlanAllImg();
        if (v == null) {
            return new PlanImage[0];
        }
        Object[] pi = new PlanImage[v.size()];
        v.copyInto(pi);
        return pi;
    }

    protected void reset() {
        for (int i = this.getNb() - 1; i >= 0; --i) {
            this.ch[i].setSelectedIndex(0);
        }
    }

    protected abstract void adjustWidgets();

    protected synchronized int[] getChoiceOrder() {
        int n = this.getNb();
        int[] def = new int[n];
        int nbdef = 0;
        for (int i = 0; i < this.choicePlan.length && nbdef < n; ++i) {
            if (!this.choicePlan[i].selected) continue;
            def[nbdef++] = i + 1;
        }
        return def;
    }

    @Override
    public void show() {
        this.choicePlan = this.getPlan();
        int n = this.getNb();
        int[] def = this.getChoiceOrder();
        if (this instanceof FrameRGB && def.length == 2) {
            this.adjustImageChoice(this.ch[0], def[0]);
            this.adjustImageChoice(this.ch[1], 0);
            this.adjustImageChoice(this.ch[2], def[1]);
        } else {
            for (int i = 0; i < n; ++i) {
                this.adjustImageChoice(this.ch[i], i < def.length ? def[i] : 0);
            }
        }
        this.adjustWidgets();
        if (this.flagHide) {
            super.show();
        }
        this.flagHide = false;
    }

    protected void toolButtonUp() {
        int n = this.getToolNumber();
        if (n < 0) {
            return;
        }
        this.a.toolBox.setMode(n, 1);
    }

    protected void maj() {
        int n = this.getToolNumber();
        if (n == -1) {
            return;
        }
        if (n == -2 || this.a.toolBox.tool[n].mode == -1) {
            Plan[] pi = this.getPlan();
            if (!this.flagHide && pi.length == this.choicePlan.length) {
                return;
            }
            this.show();
        } else {
            this.hide();
        }
    }

    @Override
    public void hide() {
        this.choicePlan = null;
        this.flagHide = true;
        this.toolButtonUp();
        super.hide();
    }

    protected JPanel valid() {
        JButton b;
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        p.setFont(Aladin.LBOLD);
        Insets insets = new Insets(4, 5, 4, 5);
        JButton[] tb = this.getAddButtons();
        if (tb != null) {
            for (int i = 0; i < tb.length; ++i) {
                p.add(tb[i]);
                tb[i].setMargin(insets);
            }
        }
        if (tb != null) {
            p.add(new JLabel(" - "));
        }
        this.submitBtn = b = new JButton(this.SUBMIT);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(insets);
        b = new JButton(this.RESET);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(insets);
        b = new JButton(this.CANCEL);
        p.add(b);
        b.addActionListener(this);
        b.setMargin(insets);
        b = Util.getHelpButton(this, this.getHelp());
        p.add(b);
        return p;
    }

    protected Plan getPlan(JComboBox c) {
        int i = c.getSelectedIndex() - 1;
        if (i < 0) {
            return null;
        }
        return this.choicePlan[i];
    }

    protected abstract void submit();

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object c = arg0.getSource();
        if (c instanceof JButton) {
            this.execute(((JButton)c).getActionCommand());
        } else {
            this.adjustWidgets();
        }
    }

    public void execute(String menu) {
        if (this.CANCEL.equals(menu)) {
            this.hide();
        } else if (this.SUBMIT.equals(menu)) {
            if (this.getPlan(this.ch[0]) == null) {
                Aladin.error(this, this.MISSING);
                return;
            }
            this.submit();
        } else if (this.HELP.equals(menu)) {
            Aladin.info(this, this.getHelp());
        } else if (this.RESET.equals(menu)) {
            this.reset();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.hide();
        }
        super.processWindowEvent(e);
    }
}

