/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.aladin.FrameRGBBlink;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanMoc;
import cds.aladin.PlanMocAlgo;
import cds.aladin.prop.PropPanel;
import cds.moc.Moc;
import cds.moc.STMoc;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class FrameMocOperation
extends FrameRGBBlink {
    protected String TITLE;
    protected String INFO;
    protected String HELP1;
    protected String SUNION;
    protected String INTER;
    protected String SUB;
    protected String DIFF;
    protected String COMP;
    protected String COPY;
    protected String PLANE;
    private ButtonGroup cbgOp;
    private JRadioButton rUnion;
    private JRadioButton rInter;
    private JRadioButton rSub;
    private JRadioButton rDiff;
    private JRadioButton rComp;
    private JRadioButton rCopy;
    private JRadioButton rFree;
    private JRadioButton rLessThan;
    private JRadioButton rRedSpace;
    private JRadioButton rRedTime;
    private JRadioButton rRedBoth;
    protected JCheckBox mocCheckSpace;
    protected JCheckBox mocCheckTime;
    protected JComboBox mocTimeOrder;
    protected JComboBox mocSpaceOrder;
    private JTextField maxMB;
    private JSlider sliderAcc;
    static String STIME = "Time";
    static String SSPACE = "Space";
    static String SBOTH = "Both";
    static String IFTOOBIG = "if too big, reduce the resolution in:";
    static String TARGETRES = "Target MOC parameters";
    static String TARGETSIZE = "Target size";
    static String SFREE = "unlimited";
    static String SLESSTHAN = "less than";
    protected int initSpaceOrder = -1;
    protected int initTimeOrder = -1;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCTITLE");
        this.INFO = Aladin.chaine.getString("MOCINFO");
        this.HELP1 = Aladin.chaine.getString("MOCHELP");
        this.SUNION = Aladin.chaine.getString("MOCUNION");
        this.INTER = Aladin.chaine.getString("MOCINTER");
        this.SUB = Aladin.chaine.getString("MOCSUB");
        this.DIFF = Aladin.chaine.getString("MOCDIFF");
        this.COMP = Aladin.chaine.getString("MOCCOMP");
        this.COPY = Aladin.chaine.getString("MOCCOPY");
        this.PLANE = Aladin.chaine.getString("MOCPLANE");
    }

    protected FrameMocOperation(Aladin aladin) {
        super(aladin);
        Aladin.setIcon(this);
    }

    @Override
    protected void maj() {
        this.maj(-1);
    }

    protected void maj(int op) {
        super.maj();
        if (op == 0) {
            this.rUnion.setSelected(true);
        } else if (op == 1) {
            this.rInter.setSelected(true);
        } else if (op == 2) {
            this.rSub.setSelected(true);
        } else if (op == 3) {
            this.rDiff.setSelected(true);
        } else if (op == 4) {
            this.rComp.setSelected(true);
        } else if (op == 5) {
            this.rCopy.setSelected(true);
        } else if (this.getPlan().length == 1) {
            this.rCopy.setSelected(true);
        } else {
            this.rInter.setSelected(true);
        }
        this.rFree.setSelected(true);
    }

    @Override
    protected String getTitre() {
        return this.TITLE;
    }

    @Override
    protected String getInformation() {
        return this.INFO;
    }

    @Override
    protected String getHelp() {
        return this.HELP1;
    }

    @Override
    protected int getToolNumber() {
        return 22;
    }

    @Override
    protected int getNb() {
        return 10;
    }

    @Override
    protected String getLabelSelector(int i) {
        return this.PLANE;
    }

    @Override
    protected Plan[] getPlan() {
        Vector<Plan> v = this.a.calque.getPlans(PlanMoc.class);
        if (v == null) {
            return new PlanImage[0];
        }
        Object[] pi = new PlanImage[v.size()];
        v.copyInto(pi);
        return pi;
    }

    @Override
    protected Color getColorLabel(int i) {
        return Color.black;
    }

    protected JComboBox getComboSpaceRes() {
        return FrameMocGenImg.makeComboSpaceRes();
    }

    protected JComboBox getComboTimeRes() {
        return FrameMocGenImg.makeComboTimeRes();
    }

    @Override
    protected JPanel getAddPanel() {
        JRadioButton cb;
        ButtonGroup cbg;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel p = new JPanel();
        p.setLayout(g);
        this.cbgOp = cbg = new ButtonGroup();
        JPanel pp = new JPanel();
        this.rUnion = cb = new JRadioButton(this.SUNION);
        cb.setActionCommand(this.SUNION);
        cbg.add(cb);
        pp.add(cb);
        this.rInter = cb = new JRadioButton(this.INTER);
        cb.setActionCommand(this.INTER);
        cbg.add(cb);
        pp.add(cb);
        this.rSub = cb = new JRadioButton(this.SUB);
        cb.setActionCommand(this.SUB);
        cbg.add(cb);
        pp.add(cb);
        this.rDiff = cb = new JRadioButton(this.DIFF);
        cb.setActionCommand(this.DIFF);
        cbg.add(cb);
        pp.add(cb);
        this.rComp = cb = new JRadioButton(this.COMP);
        cb.setActionCommand(this.COMP);
        cbg.add(cb);
        pp.add(cb);
        this.rCopy = cb = new JRadioButton(this.COPY);
        cb.setActionCommand(this.COPY);
        cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        c.gridwidth = 0;
        c.weightx = 10.0;
        g.setConstraints(pp, c);
        p.add(pp);
        PropPanel.addSectionTitle(p, new JLabel(TARGETRES), g, c);
        c.gridwidth = 0;
        pp = new JPanel();
        JCheckBox cb1 = this.mocCheckSpace = new JCheckBox(SSPACE + " ");
        cb1.setSelected(true);
        cb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameMocOperation.this.adjustWidgets();
            }
        });
        cb1 = this.mocCheckTime = new JCheckBox(STIME + " ");
        cb1.setSelected(true);
        cb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameMocOperation.this.adjustWidgets();
            }
        });
        pp.add(this.mocCheckSpace);
        this.mocSpaceOrder = this.getComboSpaceRes();
        pp.add(this.mocSpaceOrder);
        pp.add(new JLabel("    "));
        pp.add(this.mocCheckTime);
        this.mocTimeOrder = this.getComboTimeRes();
        pp.add(this.mocTimeOrder);
        g.setConstraints(pp, c);
        p.add(pp);
        pp = new JPanel();
        cbg = new ButtonGroup();
        pp.add(new JLabel(TARGETSIZE + " "));
        this.rFree = cb = new JRadioButton(SFREE);
        cb.setActionCommand(SFREE);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameMocOperation.this.adjustWidgets();
            }
        });
        cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        this.rLessThan = cb = new JRadioButton(SLESSTHAN);
        cb.setActionCommand(SLESSTHAN);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameMocOperation.this.adjustWidgets();
            }
        });
        cbg.add(cb);
        pp.add(cb);
        this.maxMB = new JTextField("10", 5);
        pp.add(this.maxMB);
        pp.add(new JLabel(" MB"));
        g.setConstraints(pp, c);
        p.add(pp);
        pp = new JPanel();
        cbg = new ButtonGroup();
        pp.add(new JLabel(IFTOOBIG));
        this.rRedSpace = cb = new JRadioButton(SSPACE);
        cb.setActionCommand(SSPACE);
        cbg.add(cb);
        pp.add(cb);
        this.rRedTime = cb = new JRadioButton(STIME);
        cb.setActionCommand(STIME);
        cbg.add(cb);
        pp.add(cb);
        this.rRedBoth = cb = new JRadioButton(SBOTH);
        cb.setActionCommand(SBOTH);
        cbg.add(cb);
        pp.add(cb);
        cb.setSelected(true);
        g.setConstraints(pp, c);
        p.add(pp);
        return p;
    }

    private int getOperation(String s) {
        if (s.equals(this.SUNION)) {
            return 0;
        }
        if (s.equals(this.INTER)) {
            return 1;
        }
        if (s.equals(this.SUB)) {
            return 2;
        }
        if (s.equals(this.DIFF)) {
            return 3;
        }
        if (s.equals(this.COMP)) {
            return 4;
        }
        return 5;
    }

    protected PlanMoc[] getPlans() {
        ArrayList<PlanMoc> pListA = new ArrayList<PlanMoc>();
        for (JComboBox c : this.ch) {
            int i = c.getSelectedIndex() - 1;
            if (i < 0) continue;
            pListA.add((PlanMoc)this.choicePlan[i]);
        }
        PlanMoc[] pList = new PlanMoc[pListA.size()];
        pListA.toArray(pList);
        return pList;
    }

    protected int getTimeOrder() {
        return this.mocTimeOrder.isEnabled() ? this.mocTimeOrder.getSelectedIndex() + 10 : -1;
    }

    protected int getSpaceOrder() {
        return this.mocSpaceOrder.isEnabled() ? this.mocSpaceOrder.getSelectedIndex() + 3 : -1;
    }

    protected boolean getTimeMoc() {
        return this.mocCheckTime.isEnabled() && this.mocCheckTime.isSelected();
    }

    protected boolean getSpaceMoc() {
        return this.mocCheckSpace.isEnabled() && this.mocCheckSpace.isSelected();
    }

    protected long getSizeMax() throws Exception {
        if (!this.maxMB.isEnabled() || this.rFree.isSelected()) {
            return -1L;
        }
        try {
            long sizeMax = Long.parseLong(this.maxMB.getText()) * 1024L * 1024L;
            if (sizeMax <= 0L) {
                throw new Exception();
            }
            this.maxMB.setForeground(Color.black);
            return sizeMax;
        }
        catch (Exception e) {
            this.maxMB.setForeground(Color.red);
            return -1L;
        }
    }

    protected String getMaxPriority() {
        if (!this.maxMB.isEnabled() || this.rFree.isSelected()) {
            return null;
        }
        if (this.rRedTime.isSelected()) {
            return "t";
        }
        if (this.rRedSpace.isSelected()) {
            return "s";
        }
        return null;
    }

    @Override
    protected void submit() {
        try {
            PlanMoc[] pList = this.getPlans();
            String s = this.cbgOp.getSelection().getActionCommand();
            int op = this.getOperation(s);
            String label = s.substring(0, 3) + " " + pList[0].label + (pList.length == 1 ? "" : pList[1].label + (pList.length == 2 ? "" : "..."));
            boolean space = this.getSpaceMoc();
            boolean time = this.getTimeMoc();
            int spaceOrder = space ? this.getSpaceOrder() : -1;
            int timeOrder = time ? this.getTimeOrder() : -1;
            long sizeMax = this.getSizeMax();
            String maxPriority = this.getMaxPriority();
            String paramOrd = "";
            int oSpace = this.getMinSpaceOrder(pList);
            int oTime = this.getMinTimeOrder(pList);
            if (!this.hasSTMoc(pList)) {
                if (oSpace != -1 && oSpace != spaceOrder) {
                    paramOrd = " -order=" + spaceOrder;
                }
                if (oTime != -1 && oTime != timeOrder) {
                    paramOrd = " -order=" + timeOrder;
                }
            } else if (oTime != timeOrder || oSpace != spaceOrder) {
                paramOrd = " -order=" + spaceOrder + "/" + timeOrder;
            }
            String paramSize = "";
            if (sizeMax != -1L) {
                long maxMB = sizeMax / 0x100000L;
                paramSize = " -maxSize=" + maxMB;
                if (maxPriority != null) {
                    paramSize = paramSize + "/" + maxPriority;
                }
            }
            Plan[] ps = new Plan[pList.length];
            for (int i = 0; i < ps.length; ++i) {
                ps[i] = pList[i];
            }
            this.a.console.printCommand("cmoc -" + PlanMocAlgo.getOpName(op) + paramOrd + paramSize + " " + FrameMocGenImg.labelList(ps));
            this.a.calque.newPlanMoc(label, pList, op, spaceOrder, timeOrder, sizeMax, maxPriority);
            this.hide();
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error("MOC operation failed !");
        }
    }

    private boolean hasSTMoc(PlanMoc[] pList) {
        for (PlanMoc p : pList) {
            if (!(p.getMoc() instanceof STMoc)) continue;
            return true;
        }
        return false;
    }

    private int getMinTimeOrder(PlanMoc[] pList) {
        int min = -1;
        for (PlanMoc p : pList) {
            Moc moc = p.getMoc();
            if (!moc.isTime()) continue;
            int o = p.moc.getTimeOrder();
            if (min != -1 && o >= min) continue;
            min = o;
        }
        return min;
    }

    private int getMinSpaceOrder(PlanMoc[] pList) {
        int min = -1;
        for (PlanMoc p : pList) {
            Moc moc = p.getMoc();
            if (!moc.isSpace()) continue;
            int o = p.moc.getSpaceOrder();
            if (min != -1 && o >= min) continue;
            min = o;
        }
        return min;
    }

    @Override
    protected void adjustWidgets() {
        int i;
        int oTime;
        PlanMoc[] pList = this.getPlans();
        boolean un = pList.length == 1;
        boolean deux = pList.length == 2;
        boolean plus = pList.length > 1;
        boolean time = false;
        boolean space = false;
        boolean setTimeOrder = false;
        boolean setSpaceOrder = false;
        int oSpace = this.getMinSpaceOrder(pList);
        this.mocCheckSpace.setEnabled(oSpace != -1);
        if (oSpace != -1 && this.mocCheckSpace.isEnabled() && this.mocCheckSpace.isSelected()) {
            space = true;
            if (this.initSpaceOrder == -1) {
                this.initSpaceOrder = oSpace;
                setSpaceOrder = true;
            }
        }
        this.mocCheckTime.setEnabled((oTime = this.getMinTimeOrder(pList)) != -1);
        if (oTime != -1 && this.mocCheckTime.isEnabled() && this.mocCheckTime.isSelected()) {
            time = true;
            if (this.initTimeOrder == -1) {
                this.initTimeOrder = oTime;
                setTimeOrder = true;
            }
        }
        if (!time) {
            this.initTimeOrder = -1;
        }
        if (!space) {
            this.initSpaceOrder = -1;
        }
        this.rUnion.setEnabled(plus);
        this.rInter.setEnabled(plus);
        this.rDiff.setEnabled(deux);
        this.rSub.setEnabled(deux);
        this.rComp.setEnabled(un);
        this.rCopy.setEnabled(un);
        if (setSpaceOrder) {
            i = this.initSpaceOrder - 3;
            if (i < 0) {
                i = 0;
            }
            this.mocSpaceOrder.setSelectedIndex(i);
        }
        if (setTimeOrder) {
            i = this.initTimeOrder - 10;
            if (i < 0) {
                i = 0;
            }
            this.mocTimeOrder.setSelectedIndex(i);
        }
        this.mocSpaceOrder.setEnabled(space);
        this.mocTimeOrder.setEnabled(time);
        if (this.rFree != null) {
            this.rFree.setEnabled(space || time);
        }
        if (this.rLessThan != null) {
            this.rLessThan.setEnabled(space || time);
        }
        boolean reduce = this.rLessThan.isSelected();
        if (this.maxMB != null) {
            this.maxMB.setEnabled(reduce && (space || time));
        }
        if (this.rRedSpace != null) {
            this.rRedSpace.setEnabled(reduce && space);
        }
        if (this.rRedTime != null) {
            this.rRedTime.setEnabled(reduce && time);
        }
        if (this.rRedBoth != null) {
            this.rRedBoth.setEnabled(reduce && space && time);
        }
        this.submitBtn.setEnabled(time || space);
    }
}

