/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameMocGenImg;
import cds.hipsgen.Context;
import cds.tools.Util;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameMocGenImgs
extends FrameMocGenImg {
    private JTextField dirField;
    private JCheckBox strictBox;
    private JCheckBox recBox;
    private JTextField fieldBlank;
    private JTextField fieldHDU;
    private JLabel labelBlank;
    private JLabel labelHDU;
    private JButton browseButton;
    private static final String DEFAULT_FILENAME = "-";

    protected FrameMocGenImgs(Aladin aladin) {
        super(aladin);
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.TITLE = Aladin.chaine.getString("MOCGENTITLE");
        this.INFO = Aladin.chaine.getString("MOCGENIMGSINFO");
    }

    @Override
    protected int getNb() {
        return 0;
    }

    @Override
    protected void reset() {
        this.dirField.setText("");
        this.recBox.setSelected(false);
        this.strictBox.setSelected(false);
        this.labelBlank.setEnabled(false);
        this.fieldBlank.setEnabled(false);
        this.fieldBlank.setText("");
        this.fieldHDU.setText("");
        super.reset();
    }

    @Override
    protected void addSpecifPanel(JPanel p, GridBagConstraints c, GridBagLayout g) {
        c.gridwidth = 0;
        JPanel pp = new JPanel();
        pp.add(new JLabel(Aladin.chaine.getString("REPSALLSKY")));
        this.dirField = new JTextField(29);
        pp.add(this.dirField);
        this.dirField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTextField t = (JTextField)e.getSource();
                if (t.getForeground() != Color.black) {
                    t.setForeground(Color.black);
                }
            }
        });
        this.browseButton = new JButton("Browse");
        pp.add(this.browseButton);
        this.browseButton.setMargin(new Insets(2, 4, 2, 4));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameMocGenImgs.this.actionBrowse();
            }
        });
        g.setConstraints(pp, c);
        p.add(pp);
        this.labelHDU = new JLabel("Specifical FITS HDU (e.g 1,3-5|all)");
        this.fieldHDU = new JTextField(10);
        this.fieldHDU.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTextField t = (JTextField)e.getSource();
                if (t.getForeground() != Color.black) {
                    t.setForeground(Color.black);
                }
            }
        });
        pp = new JPanel(new FlowLayout(0, 5, 0));
        pp.add(this.labelHDU);
        pp.add(this.fieldHDU);
        pp.add(new JLabel("(first one by default)"));
        g.setConstraints(pp, c);
        p.add(pp);
        this.recBox = new JCheckBox("Scanning sub-directories");
        g.setConstraints(this.recBox, c);
        p.add(this.recBox);
        this.labelBlank = new JLabel("=> Alternative BLANK value");
        this.fieldBlank = new JTextField(10);
        this.fieldBlank.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                JTextField t = (JTextField)e.getSource();
                if (t.getForeground() != Color.black) {
                    t.setForeground(Color.black);
                }
            }
        });
        this.strictBox = new JCheckBox("Scanning image pixel values (not just WCS)");
        this.strictBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean flag = ((JCheckBox)e.getSource()).isSelected();
                FrameMocGenImgs.this.fieldBlank.setEnabled(flag);
                FrameMocGenImgs.this.labelBlank.setEnabled(flag);
            }
        });
        g.setConstraints(this.strictBox, c);
        p.add(this.strictBox);
        pp = new JPanel();
        pp.add(this.labelBlank);
        pp.add(this.fieldBlank);
        g.setConstraints(pp, c);
        p.add(pp);
        this.reset();
    }

    private void actionBrowse() {
        FileDialog fd = new FileDialog(this.a.dialog);
        fd.setFile(DEFAULT_FILENAME);
        fd.show();
        String directory = fd.getDirectory();
        String name = fd.getFile();
        boolean isDir = false;
        if (name != null && name.equals(DEFAULT_FILENAME)) {
            name = "";
            isDir = true;
        }
        if (name != null && name.length() > 0 || isDir) {
            this.dirField.setText(directory);
        }
    }

    private boolean getStrict() {
        return this.strictBox.isSelected();
    }

    private boolean getRecursive() {
        return this.recBox.isSelected();
    }

    private double getBlank() throws Exception {
        if (!this.getStrict()) {
            return Double.NaN;
        }
        double x = Double.NaN;
        try {
            String s = this.fieldBlank.getText().trim();
            x = s.length() == 0 || Util.indexOfIgnoreCase(s, "NaN", 0) >= 0 ? Double.NaN : Double.parseDouble(s);
        }
        catch (Exception e) {
            this.fieldBlank.setForeground(Color.red);
            throw e;
        }
        this.fieldBlank.setForeground(Color.black);
        return x;
    }

    private int[] getHDU() throws Exception {
        int[] hdu = null;
        try {
            String s = this.fieldHDU.getText().trim();
            hdu = Context.parseHDU(s);
        }
        catch (Exception e) {
            this.fieldHDU.setForeground(Color.red);
            throw e;
        }
        this.fieldBlank.setForeground(Color.black);
        return hdu;
    }

    private String getDir() throws Exception {
        String dir = "";
        try {
            dir = this.dirField.getText().trim();
            if (dir.length() > 0 && !new File(dir).isDirectory()) {
                throw new Exception("Not a directory");
            }
        }
        catch (Exception e) {
            this.dirField.setForeground(Color.red);
            throw e;
        }
        this.dirField.setForeground(Color.black);
        return dir;
    }

    @Override
    protected void submit() {
        block2: {
            try {
                String dir = this.getDir();
                String label = new File(dir).getName() + " MOC";
                this.a.calque.newPlanMocColl(this.a, label, dir, this.getOrder(), this.getStrict(), this.getRecursive(), this.getBlank(), this.getHDU());
                this.hide();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void adjustWidgets() {
    }
}

