/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Command;
import cds.aladin.MacroController;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.ByteArrayInputStream;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class FrameMacro
extends JFrame {
    protected static String SCRIPT;
    protected static String PARAMS;
    protected static String EXECUTE;
    protected static String LOAD_SCRIPT;
    protected static String SAVE_SCRIPT;
    protected static String LOAD_PARAMS;
    protected static String SAVE_PARAMS;
    protected static String IMPORT_PARAMS;
    protected static String ADD_COL;
    protected static String CLEAR_PARAMS;
    protected static String EXEC_ALL;
    protected static String EXEC_ALL_FROM_CURRENT;
    protected static String EXEC_CURRENT;
    protected static String EXEC_NEXT;
    protected static String FILE;
    protected static String HELP;
    protected static String LOADEX;
    protected static String SEEHELP;
    protected static String CLOSE;
    protected static String STOP;
    protected static String DELETE;
    private MacroController macroController;
    private JTextPane scriptTP;
    private JTable paramTable;
    private JPopupMenu popup;
    private JButton stopBtn;
    private Aladin a;
    int mousePosInScript = -1;
    Vector cmdWordsPos;
    private ScriptSyntaxRenderer scriptRenderer;
    private String cmdWordUnderMouse;
    private String ocmdWordUnderMouse;
    private int hlScriptRow = -1;
    private int ohlScriptRow = -1;
    HelpFrame helpFrame;

    protected FrameMacro(Aladin a) {
        this.a = a;
        this.setIconImage(a.getImagette("AladinIconSS.gif"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, a);
        this.macroController = new MacroController(this, a);
        this.createChaine();
        this.buildFrame();
    }

    private void createChaine() {
        SCRIPT = Aladin.chaine.getString("FMSCRIPT");
        PARAMS = Aladin.chaine.getString("FMPARAMS");
        EXECUTE = Aladin.chaine.getString("FMEXEC");
        LOAD_SCRIPT = Aladin.chaine.getString("FMLOADSCRIPT");
        SAVE_SCRIPT = Aladin.chaine.getString("FMSAVESCRIPT");
        LOAD_PARAMS = Aladin.chaine.getString("FMLOADPARAMS");
        SAVE_PARAMS = Aladin.chaine.getString("FMSAVEPARAMS");
        IMPORT_PARAMS = Aladin.chaine.getString("FMIMPORTPARAMS");
        ADD_COL = Aladin.chaine.getString("FMADDCOL");
        CLEAR_PARAMS = Aladin.chaine.getString("FMCLEARPARAMS");
        EXEC_ALL = Aladin.chaine.getString("FMEXECALL");
        EXEC_ALL_FROM_CURRENT = Aladin.chaine.getString("FMEXECALLFROMCURRENT");
        EXEC_CURRENT = Aladin.chaine.getString("FMEXECCURRENT");
        EXEC_NEXT = Aladin.chaine.getString("FMEXECNEXT");
        FILE = Aladin.chaine.getString("FMFILE");
        HELP = Aladin.chaine.getString("FMHELP");
        LOADEX = Aladin.chaine.getString("FMLOADEX");
        SEEHELP = Aladin.chaine.getString("FMSEEHELP");
        CLOSE = Aladin.chaine.getString("FMCLOSE");
        STOP = Aladin.chaine.getString("FMSTOP");
        DELETE = Aladin.chaine.getString("FMDELETE");
    }

    private void buildFrame() {
        this.setTitle("Macros");
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JSplitPane splitPane = new JSplitPane(0, true, this.buildScriptPanel(), this.buildParamPanel());
        splitPane.setResizeWeight(0.5);
        this.getContentPane().add((Component)splitPane, "Center");
        splitPane.setPreferredSize(new Dimension(300, 400));
        this.getContentPane().add((Component)this.buildCommandPanel(), "South");
        this.setJMenuBar(this.buildMenuBar());
        this.pack();
        splitPane.setDividerLocation(0.5);
    }

    private JPanel buildScriptPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        this.scriptTP = new JTextPane();
        this.scriptTP.getDocument().putProperty("__EndOfLine__", "\n");
        Aladin.makeCursor(this.scriptTP, 6);
        this.scriptTP.addMouseMotionListener(this.macroController);
        this.scriptTP.addMouseListener(this.macroController);
        Dimension dim = new Dimension(300, 100);
        this.scriptTP.setPreferredSize(dim);
        this.scriptRenderer = new ScriptSyntaxRenderer();
        this.scriptTP.getDocument().addDocumentListener(this.scriptRenderer);
        JScrollPane scroll = new JScrollPane(this.scriptTP);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setPreferredSize(dim);
        panel.add((Component)scroll, "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(SCRIPT), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        return panel;
    }

    private JPanel buildParamPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        JPanel buttons = new JPanel(new FlowLayout(0));
        JButton addCol = new JButton(ADD_COL);
        addCol.addActionListener(this.macroController);
        buttons.add(addCol);
        JButton resetCol = new JButton(CLEAR_PARAMS);
        resetCol.addActionListener(this.macroController);
        buttons.add(resetCol);
        panel.add((Component)buttons, "North");
        this.paramTable = new TwoColorJTable();
        this.paramTable.setGridColor(Color.lightGray);
        this.paramTable.setSelectionMode(0);
        this.paramTable.setModel(this.macroController.getMacroModel().getParamTableModel());
        this.paramTable.setDefaultEditor(String.class, this.macroController.getMacroModel().getTableCellEditor());
        this.paramTable.addMouseListener(this.macroController);
        this.macroController.getMacroModel().getParamTableModel().initTable();
        this.macroController.getMacroModel().getParamTableModel().addEmptyCol();
        JScrollPane scrollPane = new JScrollPane(this.paramTable);
        scrollPane.setVerticalScrollBarPolicy(20);
        panel.add((Component)scrollPane, "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(PARAMS), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        return panel;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        int modifier = Aladin.macPlateform ? 4 : 2;
        JMenu fileMenu = new JMenu(FILE);
        menuBar.add(fileMenu);
        fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem(LOAD_SCRIPT);
        fileMenu.add(item);
        item.addActionListener(this.macroController);
        item.setAccelerator(KeyStroke.getKeyStroke(83, modifier));
        item = new JMenuItem(SAVE_SCRIPT);
        fileMenu.add(item);
        item.addActionListener(this.macroController);
        fileMenu.add(new JSeparator());
        item = new JMenuItem(LOAD_PARAMS);
        fileMenu.add(item);
        item.addActionListener(this.macroController);
        item.setAccelerator(KeyStroke.getKeyStroke(80, modifier));
        item = new JMenuItem(IMPORT_PARAMS);
        fileMenu.add(item);
        item.addActionListener(this.macroController);
        item.setAccelerator(KeyStroke.getKeyStroke(73, modifier));
        item = new JMenuItem(SAVE_PARAMS);
        fileMenu.add(item);
        item.addActionListener(this.macroController);
        fileMenu.add(new JSeparator());
        item = new JMenuItem(CLOSE);
        fileMenu.add(item);
        item.addActionListener(this.macroController);
        JMenu helpMenu = new JMenu(HELP);
        menuBar.add(helpMenu);
        item = new JMenuItem(LOADEX);
        helpMenu.add(item);
        item.addActionListener(this.macroController);
        helpMenu.addSeparator();
        item = new JMenuItem(SEEHELP);
        helpMenu.add(item);
        item.addActionListener(this.macroController);
        return menuBar;
    }

    private JPanel buildCommandPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel p1 = new JPanel(new FlowLayout(0));
        JButton executeCurrent = new JButton(EXEC_CURRENT);
        executeCurrent.addActionListener(this.macroController);
        p1.add(executeCurrent);
        JButton executeNext = new JButton(EXEC_NEXT);
        executeNext.addActionListener(this.macroController);
        p1.add(executeNext);
        panel.add((Component)p1, "North");
        JPanel p2 = new JPanel(new FlowLayout(0));
        JButton executeAll = new JButton(EXEC_ALL);
        executeAll.addActionListener(this.macroController);
        p2.add(executeAll);
        JButton executeAllFromCur = new JButton(EXEC_ALL_FROM_CURRENT);
        executeAllFromCur.addActionListener(this.macroController);
        p2.add(executeAllFromCur);
        this.stopBtn = new JButton(STOP);
        this.stopBtn.addActionListener(this.macroController);
        this.stopBtn.setEnabled(false);
        p2.add(this.stopBtn);
        panel.add((Component)p2, "South");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(EXECUTE), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return panel;
    }

    protected void setScript(String s) {
        this.scriptTP.setText(s);
        this.scriptTP.setCaretPosition(0);
        this.scriptTP.requestFocus();
    }

    protected String getScriptText() {
        return this.scriptTP.getText();
    }

    protected void setEnabledStopBtn(boolean b) {
        this.stopBtn.setEnabled(b);
    }

    protected void testIfColorLink(int pos) {
        this.mousePosInScript = pos;
        this.ocmdWordUnderMouse = this.cmdWordUnderMouse;
        if (this.cmdWordsPos == null) {
            return;
        }
        Enumeration e = this.cmdWordsPos.elements();
        String w = null;
        while (e.hasMoreElements()) {
            int[] bounds = (int[])e.nextElement();
            if (pos < bounds[0] || this.mousePosInScript >= bounds[1]) continue;
            w = this.scriptTP.getText().substring(bounds[0], bounds[1]);
            break;
        }
        this.cmdWordUnderMouse = w;
        if (this.cmdWordUnderMouse != this.ocmdWordUnderMouse) {
            if (this.cmdWordUnderMouse != null) {
                Aladin.makeCursor(this.scriptTP, 2);
            } else {
                Aladin.makeCursor(this.scriptTP, 6);
            }
            this.scriptRenderer.doColoringLater();
        }
    }

    protected void hilightScriptLine(int row) {
        this.hlScriptRow = row;
        if (this.hlScriptRow != this.ohlScriptRow) {
            this.scriptRenderer.doColoringLater();
            try {
                if (row >= 0) {
                    Element root = this.scriptTP.getDocument().getDefaultRootElement();
                    int idx = root.getElement(row).getStartOffset();
                    this.scriptTP.setCaretPosition(idx);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.ohlScriptRow = this.hlScriptRow;
    }

    protected void showHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame();
        }
        this.helpFrame.setVisible(true);
        this.helpFrame.toFront();
    }

    private void createPopup() {
        this.popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(DELETE);
        item.addActionListener(this.macroController);
        this.popup.add(item);
    }

    protected JPopupMenu getPopup() {
        if (this.popup == null) {
            this.createPopup();
        }
        return this.popup;
    }

    protected JTable getParamTable() {
        return this.paramTable;
    }

    protected String getCmdWordUnderMouse() {
        return this.cmdWordUnderMouse;
    }

    class ScriptSyntaxRenderer
    implements DocumentListener,
    Runnable {
        StyledDocument TEMPLATE;
        Style COMMENT_STYLE;
        Style DEFAULT_STYLE;
        Style PARAM_STYLE;
        Style KEYWORD_STYLE;
        Style LINK_STYLE;
        Style HILIGHT_STYLE;
        Color COMMENT_COLOR = new Color(63, 180, 95);
        Color PARAM_COLOR = new Color(182, 0, 85);
        Color KEYWORD_COLOR = new Color(100, 163, 224);
        Color HILIGHT_COLOR = new Color(249, 237, 130);
        boolean isColoring = false;
        private Document doc;

        public ScriptSyntaxRenderer() {
            this.initStyles();
        }

        private void initStyles() {
            this.TEMPLATE = new DefaultStyledDocument();
            this.COMMENT_STYLE = this.TEMPLATE.addStyle("comment", null);
            StyleConstants.setItalic(this.COMMENT_STYLE, true);
            StyleConstants.setForeground(this.COMMENT_STYLE, this.COMMENT_COLOR);
            this.DEFAULT_STYLE = this.TEMPLATE.addStyle("default", null);
            this.PARAM_STYLE = this.TEMPLATE.addStyle("param", null);
            StyleConstants.setBold(this.PARAM_STYLE, true);
            StyleConstants.setForeground(this.PARAM_STYLE, this.PARAM_COLOR);
            this.KEYWORD_STYLE = this.TEMPLATE.addStyle("kw", null);
            StyleConstants.setBold(this.KEYWORD_STYLE, true);
            StyleConstants.setForeground(this.KEYWORD_STYLE, this.KEYWORD_COLOR);
            this.LINK_STYLE = this.TEMPLATE.addStyle("link", null);
            StyleConstants.setBold(this.LINK_STYLE, true);
            StyleConstants.setForeground(this.LINK_STYLE, this.KEYWORD_COLOR);
            StyleConstants.setUnderline(this.LINK_STYLE, true);
            this.HILIGHT_STYLE = this.TEMPLATE.addStyle("hl", null);
            StyleConstants.setBackground(this.HILIGHT_STYLE, this.HILIGHT_COLOR);
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            this.doc = ev.getDocument();
            this.doColoringLater();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.doc = ev.getDocument();
            this.doColoringLater();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            this.doc = ev.getDocument();
            this.doColoringLater();
        }

        private void doColoringLater() {
            if (!this.isColoring) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            this.isColoring = true;
            try {
                this.coloration();
            }
            finally {
                this.isColoring = false;
            }
        }

        private void coloration() {
            String sep;
            String txt;
            if (this.doc == null) {
                return;
            }
            Position startPos = this.doc.getStartPosition();
            Position endPos = this.doc.getEndPosition();
            try {
                txt = this.doc.getText(startPos.getOffset(), endPos.getOffset() - startPos.getOffset());
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return;
            }
            Vector<int[]> vec = new Vector<int[]>();
            int posIdx = 0;
            int rowIdx = -1;
            StyledDocument styledDoc = (StyledDocument)this.doc;
            String ocurLine = sep = "\n";
            StringTokenizer st = new StringTokenizer(txt, sep, true);
            while (st.hasMoreTokens()) {
                String curLine = st.nextToken();
                if (curLine.equals(sep)) {
                    if (!sep.equals(ocurLine)) {
                        ocurLine = curLine;
                    } else {
                        ocurLine = curLine;
                        ++rowIdx;
                    }
                    posIdx += curLine.length();
                    continue;
                }
                ocurLine = curLine;
                ++rowIdx;
                if (curLine.trim().startsWith("#")) {
                    styledDoc.setCharacterAttributes(posIdx, curLine.length(), this.COMMENT_STYLE, true);
                } else {
                    styledDoc.setCharacterAttributes(posIdx, curLine.length(), this.DEFAULT_STYLE, true);
                    int idx = -1;
                    try {
                        String word;
                        StreamTokenizer streamTk = new StreamTokenizer(new ByteArrayInputStream(curLine.getBytes()));
                        int type = streamTk.nextToken();
                        if (type == -3 && Util.indexInArrayOf((word = streamTk.sval).toLowerCase(), Command.CMD) >= 0) {
                            idx = curLine.indexOf(word);
                            int cmdIdx = posIdx + idx;
                            vec.add(new int[]{cmdIdx, cmdIdx + word.length()});
                            if (FrameMacro.this.mousePosInScript >= cmdIdx && FrameMacro.this.mousePosInScript < cmdIdx + word.length()) {
                                styledDoc.setCharacterAttributes(cmdIdx, word.length(), this.LINK_STYLE, true);
                            } else {
                                styledDoc.setCharacterAttributes(cmdIdx, word.length(), this.KEYWORD_STYLE, true);
                            }
                            if (word.equalsIgnoreCase("get") && (type = streamTk.nextToken()) == -3) {
                                word = streamTk.sval;
                                String[] array = new String[]{"aladin", "simbad", "vizier"};
                                if (Util.indexInArrayOf(word.toLowerCase(), array) >= 0) {
                                    idx = curLine.indexOf(word);
                                    styledDoc.setCharacterAttributes(posIdx + idx, word.length(), this.KEYWORD_STYLE, true);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    while ((idx = curLine.indexOf(36, idx + 1)) >= 0) {
                        int end;
                        for (end = idx + 2; end <= curLine.length(); ++end) {
                            String tmp = curLine.substring(idx + 1, end);
                            try {
                                Integer.parseInt(tmp);
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                break;
                            }
                        }
                        if (end <= idx + 2) continue;
                        styledDoc.setCharacterAttributes(posIdx + idx, end - idx - 1, this.PARAM_STYLE, true);
                    }
                }
                if (rowIdx == FrameMacro.this.hlScriptRow) {
                    styledDoc.setCharacterAttributes(posIdx, curLine.length(), this.HILIGHT_STYLE, false);
                }
                posIdx += curLine.length();
            }
            FrameMacro.this.cmdWordsPos = vec;
        }
    }

    class HelpFrame
    extends JFrame {
        HelpFrame() {
            this.setIconImage(FrameMacro.this.a.getImagette("AladinIconSS.gif"));
            FrameMacro.this.a;
            this.setTitle(Aladin.chaine.getString("FMHELPTITLE"));
            this.setDefaultCloseOperation(1);
            this.getContentPane().setLayout(new BorderLayout());
            ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new BorderLayout());
            panel.setOpaque(true);
            FrameMacro.this.a;
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Aladin.chaine.getString("FMHOWTO")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            JEditorPane helpPane = new JEditorPane();
            helpPane.setContentType("text/html");
            FrameMacro.this.a;
            helpPane.setText(Aladin.chaine.getString("FMHELPCONTENT"));
            helpPane.setEditable(false);
            helpPane.setFont(Aladin.PLAIN);
            helpPane.setOpaque(true);
            helpPane.setBackground(Color.white);
            helpPane.setBorder(new EmptyBorder(5, 5, 5, 5));
            final JScrollPane scrollPane = new JScrollPane(helpPane);
            scrollPane.setPreferredSize(new Dimension(530, 250));
            panel.add((Component)scrollPane, "Center");
            this.getContentPane().add((Component)panel, "Center");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    scrollPane.getVerticalScrollBar().setValue(0);
                }
            });
            this.pack();
        }
    }
}

