/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Grid;
import cds.aladin.Localisation;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.Properties;
import cds.aladin.Select;
import cds.aladin.ServerFile;
import cds.aladin.Slide;
import cds.aladin.ViewSimple;
import cds.aladin.WidgetControl;
import cds.aladin.Words;
import cds.aladin.bookmark.Bookmarks;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.Timer;

public final class FrameFullScreen
extends JFrame
implements ActionListener {
    static final int WINDOW = 0;
    static final int WINDOW_HIDDEN = 1;
    static final int FULL = 2;
    static final int CINEMA = 3;
    private static String[] MODE = new String[]{"Window", "Window-hidden", "Full", "Cinema"};
    static GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    static GraphicsDevice device = env.getDefaultScreenDevice();
    static DisplayMode display = device.getDisplayMode();
    private Aladin aladin = null;
    protected ViewSimple viewSimple;
    private Rectangle bounds;
    private Vector ligne = null;
    private int ocursor = -1;
    private int mode;
    private Timer timer = null;
    private JPopupMenu popMenu;
    private JMenuItem menuDel;
    private JMenuItem menuProp;
    private StringBuffer cmd = new StringBuffer();
    private boolean blinkState = true;
    private Plan currentPlan = null;
    private int XBLINK = -1;
    private int YBLINK;
    private int XGRID = -1;
    private int YGRID;
    private int XARROW = -1;
    private int YARROW;
    private int XSAVE = -1;
    private int YSAVE;
    static final int YMARGE = 175;
    static final int XMARGE = 40;
    static final int YGAP = 18;
    static final int MAXCHECK = 20;
    private int nCheck = 0;
    private Check[] memoCheck = null;
    private Component box1 = Box.createGlue();
    private Component box2 = Box.createGlue();
    private Component box3 = Box.createGlue();
    private JMenu menuFrame = null;
    private JMenu menuBookmark = null;
    private int modeReticle = -1;
    private Image cross = null;
    private Image arrow = null;
    private Image save = null;
    private int XOUT;
    private int YOUT;
    private Image logo = null;

    protected FrameFullScreen(Aladin aladin, ViewSimple v, int mode) {
        super(env.getDefaultScreenDevice().getDefaultConfiguration());
        this.aladin = aladin;
        this.setTitle("Aladin " + aladin.getReleaseNumber());
        Aladin.setIcon(this);
        this.viewSimple = v;
        this.mode = mode;
        Aladin.trace(4, "FrameFullScreen(mode=" + MODE[mode] + ")");
        this.createPopupMenu();
        this.insertMenu();
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.end();
            }
        }, KeyStroke.getKeyStroke(114, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.zoom(1);
            }
        }, KeyStroke.getKeyStroke(113, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.zoom(-1);
            }
        }, KeyStroke.getKeyStroke(122, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.end();
            }
        }, KeyStroke.getKeyStroke(123, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.end1();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.delete();
            }
        }, KeyStroke.getKeyStroke(127, 0), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.grid();
            }
        }, KeyStroke.getKeyStroke(71, 8), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.hpxGrid();
            }
        }, KeyStroke.getKeyStroke(87, 8), 2);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameFullScreen.this.constellation();
            }
        }, KeyStroke.getKeyStroke(67, 8), 2);
        if (mode != 3) {
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.dist();
                }
            }, KeyStroke.getKeyStroke(68, 8), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.prop();
                }
            }, KeyStroke.getKeyStroke(10, 8), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.pixel();
                }
            }, KeyStroke.getKeyStroke(77, 2), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.open();
                }
            }, KeyStroke.getKeyStroke(79, 2), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.openDialog();
                }
            }, KeyStroke.getKeyStroke(76, 2), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.zoom(-1);
                }
            }, KeyStroke.getKeyStroke(113, 0), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.zoom(1);
                }
            }, KeyStroke.getKeyStroke(114, 0), 2);
            v.setFocusTraversalKeysEnabled(false);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.next(1);
                }
            }, KeyStroke.getKeyStroke(9, 1), 2);
            this.getRootPane().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrameFullScreen.this.next(-1);
                }
            }, KeyStroke.getKeyStroke(9, 0), 2);
        }
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().add((Component)v, "Center");
        this.bounds = v.getBounds();
        v.setBounds(this.getBounds());
        if (mode == 2 || mode == 3) {
            this.full();
        } else {
            this.window();
        }
        if (mode != 1) {
            this.setVisible(true);
        }
        if (!aladin.isApplet() || aladin.flagDetach) {
            aladin.f.setVisible(false);
        }
    }

    private void insertMenu() {
        if (this.mode == 3) {
            return;
        }
        this.setJMenuBar(this.aladin.jBar);
        this.aladin.jBar.setVisible(false);
        this.aladin.jBar.remove(this.aladin.jBar.getMenuCount() - 1);
        this.aladin.jBar.add(this.box1, this.aladin.jbarLastIndex);
        this.aladin.jBar.add(this.box1, this.aladin.jbarLastIndex);
        this.aladin.jBar.add((Component)this.getFrameMenu(), this.aladin.jbarLastIndex);
        this.aladin.jBar.add((Component)this.getBookmarkMenu(), this.aladin.jbarLastIndex);
        this.aladin.jBar.add(this.box3, this.aladin.jbarLastIndex);
    }

    private void removeMenu() {
        if (this.mode == 3) {
            return;
        }
        this.aladin.jBar.remove(this.menuBookmark);
        this.aladin.jBar.remove(this.menuFrame);
        this.aladin.jBar.remove(this.box1);
        this.aladin.jBar.remove(this.box2);
        this.aladin.jBar.remove(this.box3);
        this.aladin.jBar.add(this.aladin.iconFullScreen);
        this.aladin.jBar.setVisible(true);
        this.aladin.setJMenuBar(this.aladin.jBar);
        this.aladin.jBar.setBorderPainted(true);
    }

    private JMenu getFrameMenu() {
        if (this.menuFrame != null) {
            return this.menuFrame;
        }
        this.menuFrame = new JMenu("Frame");
        ButtonGroup mg = new ButtonGroup();
        JComboBox c = this.aladin.localisation.getComboBox();
        int n = c.getItemCount();
        Vector<String> list = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            list.add((String)c.getItemAt(i));
        }
        int select = c.getSelectedIndex();
        for (int i = 0; i < n; ++i) {
            String s = (String)list.get(i);
            JRadioButtonMenuItem ji = new JRadioButtonMenuItem(s);
            ji.setSelected(i == select);
            mg.add(ji);
            this.menuFrame.add(ji);
            ji.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ((JMenuItem)e.getSource()).getActionCommand();
                    ((FrameFullScreen)FrameFullScreen.this).aladin.localisation.setPositionMode(s);
                }
            });
        }
        return this.menuFrame;
    }

    private JMenu getBookmarkMenu() {
        if (this.menuBookmark != null) {
            return this.menuBookmark;
        }
        this.menuBookmark = new JMenu("Bookmark");
        Bookmarks c = this.aladin.bookmarks;
        int n = c.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c1 = c.getComponentAtIndex(i);
            if (!(c1 instanceof JButton)) continue;
            JButton b = (JButton)c1;
            String label = b.getText();
            JMenuItem ji = new JMenuItem(label);
            ji.addActionListener(b.getActionListeners()[0]);
            this.menuBookmark.add(ji);
        }
        return this.menuBookmark;
    }

    private void prop() {
        Properties.createProperties(this.aladin.calque.getPlanBase());
    }

    private void pixel() {
        this.aladin.pixel();
    }

    private void open() {
        ((ServerFile)this.aladin.dialog.localServer).browseFile();
    }

    private void openDialog() {
        this.aladin.dialog.show();
    }

    protected int getMode() {
        return this.mode;
    }

    /*
     * Unable to fully structure code
     */
    private void full() {
        this.setUndecorated(true);
        if (this.mode == 2) ** GOTO lbl-1000
        if (this.mode == 3) {
            ** if (!Aladin.winPlateform) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            this.setLocation(0, 0);
            this.setSize(Aladin.SCREENSIZE);
            ** GOTO lbl12
        }
lbl-1000:
        // 2 sources

        {
            gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            gd.setFullScreenWindow(this);
        }
lbl12:
        // 2 sources

        if (this.mode == 3) {
            this.modeReticle = this.aladin.calque.reticleMode;
            this.aladin.calque.setReticle(0);
        }
    }

    private void window() {
        if (this.modeReticle != -1) {
            this.aladin.calque.setReticle(this.modeReticle);
        }
        Dimension d = this.aladin.f.getSize();
        if (d.width < 10 || d.height < 10) {
            Rectangle r = this.aladin.configuration.getWinLocation();
            if (r.width < 0 || r.height < 0) {
                r.height = 600;
                r.width = 600;
            }
            this.setSize(r.width, r.height);
            this.setLocation(r.x, r.y);
        } else {
            this.setSize(d);
            this.setLocation(this.aladin.f.getLocation());
        }
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        if (this.modeReticle != -1) {
            this.aladin.calque.setReticle(this.modeReticle);
        }
        if (e.getID() == 201) {
            if (this.mode != 2 && this.mode != 3) {
                FrameFullScreen frameFullScreen = this;
                if (frameFullScreen.aladin.isApplet()) {
                    this.setVisible(false);
                } else {
                    this.aladin.quit(0);
                }
            } else {
                this.end();
            }
            return;
        }
        super.processWindowEvent(e);
    }

    private void end1() {
        if (this.hasCmd() && !this.aladin.view.isFree()) {
            Util.resetString(this.cmd);
        } else {
            this.end();
        }
    }

    protected void end() {
        this.viewSimple.aladin.fullScreen = null;
        this.viewSimple.setToolTipText(null);
        this.viewSimple.setBounds(this.bounds);
        this.aladin.view.adjustPanel();
        if (this.mode != 2 && this.mode != 3) {
            this.aladin.toolBox.calcConf(500);
            this.aladin.f.setSize(this.getSize());
        }
        this.removeMenu();
        this.aladin.f.setVisible(true);
        this.aladin.calque.repaintAll();
        this.memoCheck = null;
        this.currentPlan = null;
        this.dispose();
    }

    private void delete() {
        this.aladin.calque.Free(this.viewSimple.pref);
        this.aladin.view.findBestDefault();
    }

    private void next(int sens) {
        this.aladin.view.next(sens);
    }

    private void grid() {
        this.aladin.calque.setGrid(!this.aladin.calque.hasGrid(), true);
    }

    private void hpxGrid() {
        this.aladin.calque.setOverlayFlag("hpxgrid", !this.aladin.calque.hasHpxGrid());
        this.aladin.view.repaintAll();
    }

    private void constellation() {
        boolean flag = !this.aladin.calque.hasConst();
        this.aladin.calque.setOverlayFlag("const", flag);
        this.aladin.console.printCommand("setconf overlay=" + (flag ? "+" : "-") + "const");
        this.aladin.view.repaintAll();
    }

    private void dist() {
        this.aladin.graphic(4);
        Aladin.makeCursor(this.viewSimple, 3);
    }

    private void zoom(int sens) {
        this.aladin.command.execNow("zoom " + (sens == 1 ? (char)'+' : '-'));
    }

    protected void startMemo() {
        if (this.memoCheck == null) {
            this.memoCheck = new Check[20];
        }
        this.nCheck = 0;
    }

    private Plan getCheckPlan(int x, int y) {
        if (this.memoCheck == null) {
            return null;
        }
        try {
            for (int i = this.nCheck - 1; i >= 0; --i) {
                Check c = this.memoCheck[i];
                if (!c.in(x, y)) continue;
                return c.p;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void setCheck(Plan p) {
        if (this.nCheck >= 20) {
            return;
        }
        Check c = this.memoCheck[this.nCheck];
        if (c == null) {
            this.memoCheck[this.nCheck] = c = new Check();
        }
        c.x = this.getWidth() - 40;
        c.y = this.getHeight() - 175 - this.nCheck * 18 - 18;
        c.p = p;
        ++this.nCheck;
    }

    protected void drawChecks(Graphics g) {
        if (this.memoCheck == null || this.aladin.calque.isFree()) {
            return;
        }
        for (int i = this.nCheck - 1; i >= 0; --i) {
            Check c = this.memoCheck[i];
            Util.drawCheckbox(g, c.x, c.y, c.p.c, null, null, c.p.active);
        }
    }

    protected void drawIcons(Graphics g) {
        if (this.mode == 3) {
            return;
        }
        int ymarge = 175;
        if (this.viewSimple.pref != null && Projection.isOk(this.viewSimple.getProj())) {
            this.XGRID = this.getWidth() - 42;
            this.YGRID = this.getHeight() - ymarge + 8;
            Grid cfr_ignored_0 = this.aladin.grid;
            Grid.fillBG(g, this.XGRID, this.YGRID, Color.white);
            Grid cfr_ignored_1 = this.aladin.grid;
            Grid.drawGrid(g, this.XGRID, this.YGRID, this.aladin.calque.hasGrid() ? Aladin.COLOR_GREEN : Color.black);
        } else {
            this.XGRID = -1;
        }
        if (this.viewSimple.pref != null) {
            if (this.save == null) {
                this.save = this.aladin.getImagette("Export.gif");
            }
            try {
                this.XSAVE = this.getWidth() - 41;
                this.YSAVE = this.getHeight() - ymarge + 18 + 6;
                g.drawImage(this.save, this.XSAVE, this.YSAVE, this.viewSimple);
            }
            catch (Exception e) {
                this.XSAVE = -1;
            }
        } else {
            this.XSAVE = -1;
        }
        if (this.aladin.calque.getNbPlanImg() > 1) {
            if (this.arrow == null) {
                this.arrow = this.aladin.getImagette("Next.gif");
            }
            try {
                this.XARROW = this.getWidth() - 40;
                this.YARROW = this.getHeight() - ymarge + 36 + 6;
                g.drawImage(this.arrow, this.XARROW, this.YARROW, this.viewSimple);
            }
            catch (Exception e) {
                this.XARROW = -1;
            }
        } else {
            this.XARROW = -1;
        }
    }

    private boolean inIconOut(int x, int y) {
        x -= this.XOUT;
        y -= this.YOUT;
        try {
            return x >= 0 && x < this.cross.getWidth(this.viewSimple) && y >= 0 && y < this.cross.getHeight(this.viewSimple);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean inIconArrow(int x, int y) {
        if (this.XARROW < 0) {
            return false;
        }
        x -= this.XARROW;
        y -= this.YARROW;
        try {
            return x >= 0 && x < this.arrow.getWidth(this.viewSimple) && y >= 0 && y < this.arrow.getHeight(this.viewSimple);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean inIconSave(int x, int y) {
        if (this.XSAVE < 0) {
            return false;
        }
        x -= this.XSAVE;
        y -= this.YSAVE;
        try {
            return x >= 0 && x < this.save.getWidth(this.viewSimple) && y >= 0 && y < this.save.getHeight(this.viewSimple);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean hasCmd() {
        return this.cmd.length() > 0;
    }

    protected boolean sendKey(KeyEvent e) {
        boolean fullRepaint = false;
        int key = e.getKeyCode();
        char k = e.getKeyChar();
        this.aladin.endMsg();
        if (e.isControlDown() || e.isAltDown()) {
            return fullRepaint;
        }
        this.blinkState = true;
        if (key == 10) {
            this.aladin.execAsyncCommand(this.cmd.toString());
            this.cmd.delete(0, this.cmd.length());
            fullRepaint = true;
        } else if (key == 8 || key == 127) {
            if (this.cmd.length() > 0) {
                this.cmd.deleteCharAt(this.cmd.length() - 1);
            }
            if (this.cmd.length() == 0) {
                fullRepaint = true;
            }
        } else if (k >= '\u001f' && k <= '\u00ff') {
            this.cmd.append(k);
        }
        return fullRepaint;
    }

    protected void drawBlinkInfo(Graphics g) {
        boolean blink;
        block14: {
            boolean form;
            blink = this.aladin.calque.isBlinking();
            boolean command = this.hasCmd();
            boolean bl = form = this.aladin.view.isFree() && !Aladin.isApplet();
            if (!(command || blink || form)) {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                return;
            }
            int YC = 0;
            if (command || form) {
                int y;
                int w = 200;
                int h = 20;
                int x = form && this.mode != 3 ? this.getWidth() / 2 - w / 2 : 10;
                YC = y = form && this.mode != 3 ? this.getHeight() / 2 - 100 - h / 2 : 10;
                g.setColor(Color.white);
                g.fillRect(x, y, w, h);
                Util.drawEdge(g, x, y, w, h);
                g.setFont(Aladin.BOLD);
                String s = this.cmd.toString();
                if (form) {
                    g.setColor(Color.black);
                    String label = Localisation.YOUROBJ;
                    g.drawString(label, this.getWidth() / 2 - g.getFontMetrics().stringWidth(label) / 2, y + h + 15);
                }
                g.setColor(Aladin.COLOR_GREEN);
                if (this.blinkState) {
                    s = s + "_";
                }
                g.drawString(s, x + 5, y + h - 5);
            }
            if (form && this.mode != 3) {
                try {
                    if (this.logo == null) {
                        this.logo = this.aladin.getImagette("Aladin.png");
                    } else {
                        g.drawImage(this.logo, this.getWidth() / 2 - this.logo.getWidth(this.viewSimple) / 2, YC - this.logo.getHeight(this.viewSimple) - 10, this.viewSimple);
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block14;
                    e.printStackTrace();
                }
            }
        }
        WidgetControl voc = this.aladin.calque.select.getWidgetControl();
        if (blink && voc.isCollapsed()) {
            this.XBLINK = voc.getX() + 2;
            this.YBLINK = voc.getY() - 10;
            Slide.drawBall(g, this.XBLINK, this.YBLINK, this.blinkState ? Color.green : Color.white);
        } else {
            this.XBLINK = -1;
        }
        if (this.timer == null) {
            this.timer = new Timer(500, this);
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof JMenuItem) {
            if (this.currentPlan == null) {
                return;
            }
            if (src == this.menuDel) {
                this.aladin.calque.Free(this.currentPlan);
            } else if (src == this.menuProp) {
                Properties.createProperties(this.currentPlan);
            }
            return;
        }
        boolean bl = this.blinkState = !this.blinkState;
        if (!Aladin.NOGUI) {
            this.repaint();
        }
    }

    protected void showMesures() {
        int nbSource = this.aladin.mesure.getNbSrc();
        if (nbSource == 0 || this.aladin.mesure.frameMesure != null && this.aladin.mesure.frameMesure.isVisible()) {
            return;
        }
        if (this.aladin.mesure.frameMesure == null) {
            this.aladin.mesure.split();
        } else if (!this.aladin.mesure.isVisible()) {
            this.aladin.mesure.setReduced(false);
            this.aladin.mesure.frameMesure.setVisible(true);
        }
    }

    private void createPopupMenu() {
        JMenuItem j;
        Select select = this.aladin.view.calque.select;
        this.popMenu = new JPopupMenu();
        this.menuDel = j = new JMenuItem(select.MDEL);
        this.popMenu.add(j);
        j.addActionListener(this);
        this.menuProp = j = new JMenuItem(select.MPROP);
        this.popMenu.add(j);
        j.addActionListener(this);
        this.getContentPane().add(this.popMenu);
    }

    private void showPopMenu(int x, int y) {
        this.popMenu.show(this, x, y);
    }

    protected boolean mousePressed(MouseEvent e1) {
        int x = e1.getX();
        int y = e1.getY();
        boolean rep = false;
        if (this.inIconOut(x, y)) {
            this.end();
            return true;
        }
        if (this.inIconArrow(x, y)) {
            this.next(e1.isShiftDown() ? 1 : -1);
            return true;
        }
        if (this.inIconSave(x, y)) {
            this.aladin.save.saveFile(1, e1.isShiftDown() ? 4 : 8, -1.0f);
            return true;
        }
        Plan p = this.getCheckPlan(x, y);
        if (p != null) {
            rep = true;
            if (e1.isPopupTrigger()) {
                this.currentPlan = p;
                this.showPopMenu(x, y);
            } else {
                p.setActivated(!p.active);
                this.aladin.view.repaintAll();
            }
        } else if (this.XGRID > 0 && x >= this.XGRID && x <= this.XGRID + 15 && y >= this.YGRID && y <= this.YGRID + 15) {
            this.aladin.calque.switchGrid(true);
            rep = true;
        } else if (this.ligne != null) {
            Enumeration e = this.ligne.elements();
            Obj o = (Obj)e.nextElement();
            while (e.hasMoreElements()) {
                Words w = (Words)e.nextElement();
                if (!w.inside(x, y)) continue;
                rep = true;
                if (!w.glu) continue;
                w.haspushed = true;
                if (w.archive) {
                    this.end();
                    w.callArchive(this.aladin, o);
                } else {
                    w.callGlu(this.aladin.glu, this.aladin.mesure.mcanvas);
                }
                return true;
            }
        }
        return rep;
    }

    private void menu(int y) {
        boolean a = this.aladin.jBar.isVisible();
        this.aladin.jBar.setVisible(y < 50);
        if (a != this.aladin.jBar.isVisible()) {
            this.viewSimple.repaint();
        }
    }

    protected boolean mouseMoved(int x, int y) {
        boolean rep = false;
        int cursor = 0;
        this.currentPlan = null;
        this.menu(y);
        if (this.inIconOut(x, y)) {
            cursor = 2;
            rep = true;
            Util.toolTip(this.viewSimple, this.aladin.FULLINT);
        } else if (this.inIconArrow(x, y)) {
            cursor = 2;
            rep = true;
            Util.toolTip(this.viewSimple, this.aladin.NEXT);
        } else if (this.inIconSave(x, y)) {
            cursor = 2;
            rep = true;
            Util.toolTip(this.viewSimple, "Save currentview (PNG format)");
        } else if (this.XBLINK > 0 && x >= this.XBLINK && x <= this.XBLINK + 10 && y >= this.YBLINK && y <= this.YBLINK + 10) {
            String s = this.aladin.calque.getBlinkingInfo();
            if (s.length() > 0) {
                s = "Waiting " + s + "...";
            }
            Util.toolTip(this.viewSimple, s);
            rep = true;
        } else if (this.XGRID > 0 && x >= this.XGRID && x <= this.XGRID + 15 && y >= this.YGRID && y <= this.YGRID + 15) {
            cursor = 2;
            Util.toolTip(this.viewSimple, this.aladin.grid.getHelpTip(), true);
            rep = true;
        } else {
            Plan p = this.getCheckPlan(x, y);
            if (p != null) {
                cursor = 2;
                rep = true;
                Util.toolTip(this.viewSimple, p.getInfo());
            } else {
                Util.toolTip(this.viewSimple, "");
                if (this.ligne != null) {
                    Enumeration e = this.ligne.elements();
                    e.nextElement();
                    while (e.hasMoreElements()) {
                        Words w = (Words)e.nextElement();
                        if (!w.inside(x, y) || !w.glu) continue;
                        cursor = 2;
                        rep = true;
                        break;
                    }
                }
            }
        }
        if (cursor != this.ocursor) {
            this.ocursor = cursor;
            Aladin.makeCursor(this.viewSimple, cursor);
        }
        return rep;
    }

    class Check {
        int x;
        int y;
        Plan p;

        Check() {
        }

        boolean in(int a, int b) {
            return a >= this.x && a <= this.x + 10 && b >= this.y && b <= this.y + 10;
        }
    }
}

