/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanField;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.astro.Proj3;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;

public class Forme
extends Position {
    protected Color couleur = null;
    public Position[] o;

    @Override
    protected void createCacheXYVP() {
        if (this.o == null) {
            return;
        }
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].createCacheXYVP();
        }
    }

    @Override
    protected void createCacheXYVP(int dim) {
        if (this.o == null) {
            return;
        }
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].createCacheXYVP(dim);
        }
    }

    protected Forme(Plan plan, Position[] o) {
        super(plan);
        this.o = o;
    }

    public Vector getProp() {
        Vector<Prop> propList = super.getProp();
        final Couleur col = new Couleur(this.couleur, true);
        PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == Forme.this.couleur) {
                    return -1;
                }
                Forme.this.setColor(c);
                return 1;
            }
        };
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        return propList;
    }

    @Override
    public double getRa() {
        return this.o[0].getRa();
    }

    @Override
    public double getDec() {
        return this.o[0].getDec();
    }

    @Override
    public void setColor(Color c) {
        this.couleur = c;
    }

    @Override
    public void setRaDec(double ra, double de) {
        double dra = this.o[0].getRa() - ra;
        double dde = this.o[0].getDec() - de;
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].deltaRaDec(dra, dde);
        }
    }

    @Override
    public String getObjType() {
        return "ComposedObject";
    }

    protected void setObjet(Position[] o) {
        this.o = o;
    }

    @Override
    protected void setCoord(ViewSimple v) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setCoord(v);
        }
    }

    @Override
    protected void setCoord(ViewSimple v, Projection proj) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setCoord(v, proj);
        }
    }

    @Override
    protected void setXY(Projection proj) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setXY(proj);
        }
    }

    @Override
    protected void setXYTan(double x, double y) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setXYTan(x, y);
        }
    }

    @Override
    protected void setXYTan(Coord center) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setXYTan(center);
        }
    }

    @Override
    protected void projection(ViewSimple v) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].projection(v);
        }
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
    }

    @Override
    protected void deltaPosition(ViewSimple v, double x, double y) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].deltaPosition(v, x, y);
        }
    }

    @Override
    protected void rotatePosition(ViewSimple v, double theta, double x0, double y0) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].rotatePosition(v, theta, x0, y0);
        }
    }

    @Override
    protected void deltaRaDec(double dra, double dde) {
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].deltaRaDec(dra, dde);
        }
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        if (this.o.length == 0) {
            return clip;
        }
        for (int i = 0; i < this.o.length; ++i) {
            clip = this.o[i].extendClip(v, clip);
        }
        return clip;
    }

    @Override
    protected Point getViewCoord(ViewSimple v, int dw, int dh) {
        return null;
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return false;
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        return false;
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        return false;
    }

    @Override
    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        return false;
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
    }

    protected void drawSelect(Graphics g, ViewSimple v, int i) {
        int ds = 2;
        Point p = this.o[i].getViewCoord(v, 0, 0);
        if (p == null) {
            return;
        }
        g.setColor(Color.green);
        g.fillRect(p.x - ds + 1, p.y - ds + 1, 3, 3);
        g.setColor(Color.black);
        g.drawRect(p.x - ds, p.y - ds, 4, 4);
    }

    @Override
    protected void setSelect(boolean flag) {
        super.setSelect(flag);
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setSelect(flag);
        }
    }

    @Override
    protected void setVisibleGenerique(boolean flag) {
        super.setVisibleGenerique(flag);
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].setVisibleGenerique(flag);
        }
    }

    @Override
    protected void switchSelect() {
        super.switchSelect();
        for (int i = 0; i < this.o.length; ++i) {
            this.o[i].switchSelect();
        }
    }

    @Override
    public Color getColor() {
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null && this.plan.type == 10) {
            this.couleur = ((PlanField)this.plan).getColor(this);
            if (this.couleur == null) {
                return this.plan.c;
            }
            return this.couleur;
        }
        if (this.plan != null) {
            return this.plan.c;
        }
        return Color.black;
    }

    protected Coord applySphereRot(Coord c, double radius, double angle) {
        Proj3 a = new Proj3(1, c.al, c.del);
        double tanr = Math.tan(Math.PI * radius / 180.0);
        double cost = Math.cos(Math.PI * angle / 180.0);
        double sint = Math.sin(Math.PI * angle / 180.0);
        double x = tanr * sint;
        double y = tanr * cost;
        a.set(x, y);
        return new Coord(a.getLon(), a.getLat());
    }

    @Override
    public Iterator<Obj> iterator() {
        return new ObjetIterator();
    }

    class ObjetIterator
    implements Iterator<Obj> {
        private int index = 0;

        ObjetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Forme.this.o.length;
        }

        @Override
        public Obj next() {
            return Forme.this.o[this.index++];
        }

        @Override
        public void remove() {
        }
    }
}

