/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.FilterHelp;
import cds.aladin.FrameColumnCalculator;
import cds.aladin.Legende;
import cds.aladin.MetaDataTree;
import cds.aladin.MyLabel;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanFilter;
import cds.aladin.Properties;
import cds.aladin.Source;
import cds.tools.Util;
import cds.tools.parser.Parser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;

public final class FilterProperties
extends Properties
implements MouseListener,
ActionListener {
    protected String SELECT;
    protected String EXPORT;
    protected String UCD;
    protected String FILTER_EXAMPLES;
    protected String FILTERMANUAL;
    protected String SAVEFILTER;
    protected String LOADFILTER;
    protected String PICKCOLUMN;
    protected String PICKUCD;
    protected String SHAPEFUNC;
    protected String COLORFUNC;
    protected String IOERR;
    protected String CAVEAT;
    protected String MATHS;
    protected String OPEN_COLUMNS;
    protected String LABEL;
    protected String CHOOSE;
    protected String CHOOSE1;
    protected String PREDEF;
    protected String YOUROWN;
    protected String PICK;
    protected String COL;
    protected String ACTION;
    protected String UNIT;
    protected String CPLANE;
    protected String FREQUCD;
    protected String CATUCD;
    protected String SHAPEFCT;
    protected String COLORFCT;
    protected String CAVEATMSG;
    protected String FILTER_EXPLAIN;
    protected String RAINBOWCM;
    protected static String BEGINNER;
    protected static String ADVANCED;
    JTabbedPane modeTabbedPane;
    private static String currentMode;
    static boolean useUcdExplain;
    private static final String[] UCDBASE;
    private static final String[] UNITBASE;
    private static String[] UNITEXPLAIN;
    FileDialog fd = null;
    protected static String[] BEGINNER_FILTER;
    protected static final String[] BEGINNER_FILTERDEF;
    private ButtonGroup beginnerCbg;
    PlanFilter pf;
    String oscript;
    String olabel;
    private JPanel panel;
    private int hcmemo = 0;
    private boolean computeCol = true;
    private static boolean pickUCDMode;
    private static boolean pickColumnMode;
    private static FilterProperties curWindow;
    JButton applyBtn;
    JButton closeBtn;
    JButton showRainbowBtn;
    JTextField label;
    JTextArea filterDef;
    JScrollPane filterDefSp;
    private String saveDef;
    private String saveName;
    private JComboBox predefFilters;
    private JPopupMenu columnMenu;
    private JPopupMenu ucdMenu;
    private JPopupMenu actionMenu;
    private JPopupMenu unitMenu;
    private JMenu currentUcdMenu;
    private static ColumnHelperFrame columnHelper;
    private static MathHelperFrame mathHelper;
    private static PickupHelperFrame pickupHelper;
    private int oldIndex = 0;
    private static final Insets BUTTON_INSETS;
    private static FilterProperties pickupFP;
    private static String[] ucds;
    private boolean firstTime = true;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.SELECT = Aladin.chaine.getString("FTSELECT");
        this.EXPORT = Aladin.chaine.getString("FTEXPORT");
        this.UCD = Aladin.chaine.getString("FTUCD");
        this.FILTER_EXAMPLES = Aladin.chaine.getString("FTFILTER_EXAMPLES");
        this.FILTERMANUAL = Aladin.chaine.getString("FTFILTERMANUAL");
        this.SAVEFILTER = Aladin.chaine.getString("FTSAVEFILTER");
        this.LOADFILTER = Aladin.chaine.getString("FTLOADFILTER");
        this.PICKCOLUMN = Aladin.chaine.getString("FTPICKCOLUMN");
        this.PICKUCD = Aladin.chaine.getString("FTPICKUCD");
        this.SHAPEFUNC = Aladin.chaine.getString("FTSHAPEFUNC");
        this.COLORFUNC = Aladin.chaine.getString("FTCOLORFUNC");
        this.IOERR = Aladin.chaine.getString("FTIOERR");
        this.CAVEAT = Aladin.chaine.getString("FTCAVEAT");
        this.MATHS = Aladin.chaine.getString("FTMATHS");
        this.OPEN_COLUMNS = Aladin.chaine.getString("FTOPEN_COLUMNS");
        this.LABEL = Aladin.chaine.getString("FTLABEL");
        this.CHOOSE = Aladin.chaine.getString("FTCHOOSE");
        this.CHOOSE1 = Aladin.chaine.getString("FTCHOOSE1");
        this.PREDEF = Aladin.chaine.getString("FTPREDEF");
        this.YOUROWN = Aladin.chaine.getString("FTYOUROWN");
        this.PICK = Aladin.chaine.getString("FTPICK");
        this.COL = Aladin.chaine.getString("FTCOL");
        this.ACTION = Aladin.chaine.getString("FTACTION");
        this.UNIT = Aladin.chaine.getString("FTUNIT");
        this.CPLANE = Aladin.chaine.getString("FTCPLANE");
        this.FREQUCD = Aladin.chaine.getString("FTFREQUCD");
        this.CATUCD = Aladin.chaine.getString("FTCATUCD");
        this.SHAPEFCT = Aladin.chaine.getString("FTSHAPEFCT");
        this.COLORFCT = Aladin.chaine.getString("FTCOLORFCT");
        this.CAVEATMSG = Aladin.chaine.getString("FTCAVEATMSG");
        this.FILTER_EXPLAIN = Aladin.chaine.getString("FTFILTER_EXPLAIN");
        this.RAINBOWCM = Aladin.chaine.getString("FTRAINBOWCM");
        String[] stringArray = new String[10];
        stringArray[0] = Aladin.chaine.getString("FTMIN");
        stringArray[1] = Aladin.chaine.getString("FTSEC");
        stringArray[2] = Aladin.chaine.getString("FTDEG");
        stringArray[3] = Aladin.chaine.getString("FTEV");
        stringArray[4] = Aladin.chaine.getString("FTJY");
        stringArray[5] = Aladin.chaine.getString("FTMAG");
        stringArray[6] = Aladin.chaine.getString("FTPSC");
        stringArray[7] = Aladin.chaine.getString("FTRAD");
        stringArray[8] = Aladin.chaine.getString("FTYEAR");
        stringArray[9] = Aladin.chaine.getString("FTWATT");
        UNITEXPLAIN = stringArray;
    }

    protected FilterProperties(Plan p) {
        super(p);
        this.pf = (PlanFilter)p;
        FilterProperties.majFilterProp(true, false);
        this.aladin.lastFilterCreated = this;
    }

    @Override
    void showProp() {
        curWindow = this;
        if (this.panel != null) {
            if (!this.oscript.equals(this.pf.script)) {
                this.filterDef.setText(this.pf.script);
            }
            if (!this.olabel.equals(this.pf.label)) {
                this.label.setText(this.pf.label);
            }
        }
        this.oscript = this.pf.script;
        this.olabel = this.pf.label;
        if (this.hcmemo == this.pf.hashCode()) {
            if (this.isShowing()) {
                return;
            }
            this.setVisible(true);
            return;
        }
        this.hcmemo = this.pf.hashCode();
        this.saveDef = "";
        this.saveName = "";
        if (this.panel != null) {
            this.getContentPane().remove(this.panel);
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(5, 5));
        this.propPanel = this.getPanelProperties();
        Aladin.makeAdd(this.panel, this.propPanel, "Center");
        Aladin.makeAdd(this.panel, this.getPanelValid(), "South");
        this.setTitre(this.LABEL + " \"" + this.pf.label + "\"");
        Aladin.makeAdd(this.getContentPane(), this.panel, "Center");
        this.pack();
        this.setVisible(true);
    }

    @Override
    protected JPanel getPanelValid() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        p.setFont(Aladin.LBOLD);
        this.applyBtn = new JButton(this.APPLY);
        this.applyBtn.addActionListener(this);
        p.add(this.applyBtn);
        this.closeBtn = new JButton(this.CLOSE);
        this.closeBtn.setFont(Aladin.PLAIN);
        this.closeBtn.addActionListener(this);
        p.add(this.closeBtn);
        return p;
    }

    @Override
    protected JPanel getPanelProperties() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.insets = new Insets(2, 2, 3, 5);
        JPanel p = new JPanel();
        p.setLayout(g);
        JLabel explain = new JLabel(this.FILTER_EXPLAIN, 0);
        c.gridwidth = 0;
        g.setConstraints(explain, c);
        p.add(explain);
        this.label = new JTextField(this.pf.label, 15);
        FilterProperties.addCouple(p, this.LABEL, this.label, g, c);
        if (this.pf.script.length() == 0) {
            this.pf.active = true;
        }
        currentMode = this.pf.script != null && this.pf.script.length() > 0 || Aladin.ROBOTSUPPORT && this.aladin.command.robotMode ? ADVANCED : BEGINNER;
        this.modeTabbedPane = new JTabbedPane();
        this.modeTabbedPane.addTab(BEGINNER, this.getBeginnerPanel());
        this.modeTabbedPane.addTab(ADVANCED, this.getAdvancedPanel());
        this.modeTabbedPane.setSelectedIndex(currentMode == BEGINNER ? 0 : 1);
        c.gridwidth = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        g.setConstraints(this.modeTabbedPane, c);
        p.add(this.modeTabbedPane);
        return p;
    }

    protected static String[] getBeginnerFilters() {
        String[] res = new String[BEGINNER_FILTER.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Util.slash(BEGINNER_FILTER[i]);
        }
        return res;
    }

    private JPanel getBeginnerPanel() {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 0;
        JPanel p = new JPanel();
        p.setLayout(g);
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.CHOOSE, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        c.gridwidth = 0;
        c.anchor = 17;
        this.beginnerCbg = new ButtonGroup();
        for (int i = 0; i < BEGINNER_FILTER.length; ++i) {
            String label = " " + BEGINNER_FILTER[i];
            JRadioButton cb = new JRadioButton(label, false);
            this.beginnerCbg.add(cb);
            cb.addActionListener(this);
            g.setConstraints(cb, c);
            p.add(cb);
        }
        c.insets = new Insets(30, 0, 0, 0);
        c.anchor = 10;
        JButton caveatBtn = new JButton(this.CAVEAT);
        caveatBtn.addActionListener(this);
        caveatBtn.setFont(Aladin.BOLD);
        g.setConstraints(caveatBtn, c);
        p.add(caveatBtn);
        return p;
    }

    public static void addCouple(JPanel p, Object titre, Component valeur, GridBagLayout g, GridBagConstraints c) {
        Component t;
        if (titre instanceof String) {
            JLabel l = new JLabel((String)titre);
            l.setFont(l.getFont().deriveFont(2));
            t = l;
        } else {
            t = (Component)titre;
        }
        c.anchor = 17;
        c.gridwidth = -1;
        c.weightx = 0.0;
        g.setConstraints(t, c);
        p.add(t);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        g.setConstraints(valeur, c);
        p.add(valeur);
    }

    private JPanel getAdvancedPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        this.majPredefFilters();
        JPanel predefPanel = new JPanel(new FlowLayout(3, 10, 5));
        predefPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.CHOOSE1, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        JLabel l = new JLabel(this.PREDEF);
        predefPanel.add(l);
        l.setFont(l.getFont().deriveFont(2));
        predefPanel.add(this.predefFilters);
        p.add(predefPanel);
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        JPanel defPanel = new JPanel();
        defPanel.setLayout(g);
        defPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, this.YOUROWN, 4, 2, Aladin.BOLD), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        p.add(defPanel);
        JLabel lEg = new JLabel("eg: ${Bmag}<10 {draw red square}");
        lEg.setFont(Aladin.ITALIC);
        c.gridwidth = 0;
        c.fill = 0;
        c.anchor = 17;
        g.setConstraints(lEg, c);
        defPanel.add(lEg);
        JLabel pickLabel = new JLabel(this.PICK);
        c.gridwidth = -1;
        c.fill = 0;
        c.anchor = 13;
        pickLabel.setFont(Aladin.BOLD);
        g.setConstraints(pickLabel, c);
        defPanel.add(pickLabel);
        c.gridwidth = 0;
        c.anchor = 10;
        c.fill = 1;
        JPanel popupPanel = new JPanel(new FlowLayout(1, 8, 5));
        if (this.columnMenu == null) {
            this.createPopup();
        }
        Insets insets = new Insets(2, 5, 2, 5);
        ImageIcon icon = new ImageIcon(this.aladin.getImagette("arrow.gif"));
        final JButton colBtn = new JButton(this.COL);
        popupPanel.add(colBtn);
        colBtn.setIcon(icon);
        colBtn.setHorizontalTextPosition(2);
        colBtn.setMargin(insets);
        colBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.columnMenu.show(colBtn, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        final JButton ucdBtn = new JButton("UCDs");
        popupPanel.add(ucdBtn);
        ucdBtn.setIcon(icon);
        ucdBtn.setHorizontalTextPosition(2);
        ucdBtn.setMargin(insets);
        ucdBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.ucdMenu.show(ucdBtn, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        final JButton actionBtn = new JButton(this.ACTION);
        popupPanel.add(actionBtn);
        actionBtn.setIcon(icon);
        actionBtn.setHorizontalTextPosition(2);
        actionBtn.setMargin(insets);
        actionBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.actionMenu.show(actionBtn, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        JButton mathBtn = new JButton(this.MATHS);
        popupPanel.add(mathBtn);
        mathBtn.addActionListener(this);
        mathBtn.setMargin(insets);
        mathBtn.setIcon(null);
        final JButton unitBtn = new JButton(this.UNIT);
        popupPanel.add(unitBtn);
        unitBtn.setIcon(icon);
        unitBtn.setHorizontalTextPosition(2);
        unitBtn.setMargin(insets);
        unitBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FilterProperties.this.unitMenu.show(unitBtn, mouseEvent.getX(), mouseEvent.getY());
            }
        });
        c.gridx = 1;
        g.setConstraints(popupPanel, c);
        defPanel.add(popupPanel);
        c.gridx = 0;
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new BorderLayout(0, 0));
        JPanel helpPanel = new JPanel();
        GridBagLayout gHelp = new GridBagLayout();
        GridBagConstraints cHelp = new GridBagConstraints();
        helpPanel.setLayout(gHelp);
        JButton manualFilterBtn = this.createButton(this.FILTERMANUAL);
        manualFilterBtn.setFont(Aladin.LBOLD);
        JButton helpFilterBtn = this.createButton(this.FILTER_EXAMPLES);
        helpFilterBtn.setFont(Aladin.LBOLD);
        cHelp.gridwidth = 0;
        cHelp.insets = new Insets(5, 0, 5, 3);
        cHelp.fill = 2;
        gHelp.setConstraints(manualFilterBtn, cHelp);
        helpPanel.add(manualFilterBtn);
        gHelp.setConstraints(helpFilterBtn, cHelp);
        helpPanel.add(helpFilterBtn);
        bigPanel.add((Component)helpPanel, "West");
        this.filterDef = new JTextArea(9, 50);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem(new DefaultEditorKit.CutAction());
        item.setText("Cut");
        popup.add(item);
        item = new JMenuItem(new DefaultEditorKit.CopyAction());
        item.setText("Copy");
        popup.add(item);
        item = new JMenuItem(new DefaultEditorKit.PasteAction());
        item.setText("Paste");
        popup.add(item);
        this.filterDef.setLineWrap(true);
        this.filterDef.addMouseListener(this);
        this.filterDef.setFont(Aladin.COURIER);
        this.filterDef.setText(this.pf.script);
        this.filterDefSp = new JScrollPane(this.filterDef, 22, 31);
        bigPanel.add((Component)this.filterDefSp, "Center");
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        g.setConstraints(bigPanel, c);
        defPanel.add(bigPanel);
        c.weightx = 0.0;
        c.weighty = 0.0;
        if (Aladin.hasNoResctriction()) {
            JButton saveFilter = this.createButton(this.SAVEFILTER);
            saveFilter.setFont(Aladin.PLAIN);
            JButton loadFilter = this.createButton(this.LOADFILTER);
            loadFilter.setFont(Aladin.PLAIN);
            JPanel loadSavePanel = new JPanel();
            loadSavePanel.setLayout(new FlowLayout(1));
            loadSavePanel.add(saveFilter);
            loadSavePanel.add(loadFilter);
            JLabel bidon = new JLabel("");
            c.gridwidth = -1;
            g.setConstraints(bidon, c);
            defPanel.add(bidon);
            c.gridx = 1;
            c.gridwidth = 0;
            g.setConstraints(loadSavePanel, c);
            defPanel.add(loadSavePanel);
        }
        if (this.computeCol) {
            this.updateUCDAndColumn();
        }
        c.gridx = 0;
        JPanel pBtns = new JPanel();
        GridBagConstraints cc = new GridBagConstraints();
        GridBagLayout gg = new GridBagLayout();
        cc.fill = 1;
        cc.insets = new Insets(1, 3, 1, 3);
        pBtns.setLayout(gg);
        pBtns.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        JButton bExport = new JButton(this.EXPORT);
        bExport.addActionListener(this);
        JLabel lExport = new JLabel(this.CPLANE);
        cc.gridwidth = -1;
        cc.weightx = 0.0;
        gg.setConstraints(bExport, cc);
        pBtns.add(bExport);
        cc.gridwidth = 0;
        cc.weightx = 1.0;
        gg.setConstraints(lExport, cc);
        pBtns.add(lExport);
        cc.gridwidth = 0;
        cc.anchor = 17;
        cc.weightx = 0.0;
        cc.fill = 0;
        this.showRainbowBtn = new JButton(this.RAINBOWCM);
        this.showRainbowBtn.addActionListener(this);
        this.showRainbowBtn.setEnabled(this.pf.getUCDFilter().hasRainbowFunction());
        gg.setConstraints(this.showRainbowBtn, cc);
        pBtns.add(this.showRainbowBtn);
        p.add(pBtns);
        return p;
    }

    private JButton createButton(String s) {
        JButton b = new JButton(s);
        b.setMargin(BUTTON_INSETS);
        b.addActionListener(this);
        return b;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        curWindow = this;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void createPopup() {
        int i;
        JMenuItem mi;
        this.columnMenu = new JPopupMenu();
        this.ucdMenu = new JPopupMenu();
        this.actionMenu = new JPopupMenu();
        this.unitMenu = new JPopupMenu();
        JMenu freqUcdMenu = new JMenu(this.FREQUCD);
        for (int i2 = 0; i2 < UCDBASE.length; ++i2) {
            String key;
            String explain;
            String label = UCDBASE[i2];
            if (useUcdExplain && (explain = FilterProperties.getUCDExplain(key = label.endsWith("*") ? label.substring(0, label.length() - 1) : label, true)).length() > 0) {
                label = label + " - " + explain;
            }
            mi = new JMenuItem(label);
            mi.addActionListener(this);
            mi.setActionCommand("$[" + UCDBASE[i2] + "]");
            freqUcdMenu.add(mi);
        }
        this.currentUcdMenu = new JMenu(this.CATUCD);
        this.ucdMenu.add(freqUcdMenu);
        this.ucdMenu.add(this.currentUcdMenu);
        this.ucdMenu.addSeparator();
        mi = new JMenuItem(this.PICKUCD);
        this.ucdMenu.add(mi);
        mi.addActionListener(this);
        JMenu shapeMenu = new JMenu(this.SHAPEFCT);
        JMenu colorMenu = new JMenu(this.COLORFCT);
        mi = new JMenuItem("ellipse".toUpperCase() + "(semi-maj. axis, semi-minor axis, pos. angle)");
        mi.setActionCommand("draw ellipse(,,)");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("fillellipse".toUpperCase() + "(semi-maj. axis, semi-minor axis, pos. angle)");
        mi.setActionCommand("draw fillellipse(,,)");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("circle".toUpperCase() + "(parameter)");
        mi.setActionCommand("draw circle()");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("fillcircle".toUpperCase() + "(parameter)");
        mi.setActionCommand("draw fillcircle()");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("fixedcircle".toUpperCase() + "(parameter)");
        mi.setActionCommand("draw fixedcircle()");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("pm".toUpperCase() + "(proper motion RA, proper motion Dec)");
        mi.setActionCommand("draw pm(,)");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("rectangle".toUpperCase() + "(width, height, pos. angle)");
        mi.setActionCommand("draw rectangle(,,)");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        mi = new JMenuItem("line".toUpperCase() + "(ra1, dec1, ra2, dec2)");
        mi.setActionCommand("draw line(,,,)");
        mi.addActionListener(this);
        shapeMenu.add(mi);
        shapeMenu.addSeparator();
        for (i = 0; i < Action.NOPARAMSHAPE.length; ++i) {
            mi = new JMenuItem(Action.NOPARAMSHAPE[i]);
            mi.addActionListener(this);
            mi.setActionCommand("draw " + Action.NOPARAMSHAPE[i]);
            shapeMenu.add(mi);
        }
        mi = new JMenuItem("rgb".toUpperCase() + "(red param., green param., blue param.)");
        mi.addActionListener(this);
        mi.setActionCommand("draw rgb(,,)");
        colorMenu.add(mi);
        mi = new JMenuItem("rainbow".toUpperCase() + "(parameter)");
        mi.addActionListener(this);
        mi.setActionCommand("draw rainbow()");
        colorMenu.add(mi);
        mi = new JMenuItem("saturation".toUpperCase() + "(parameter)");
        mi.addActionListener(this);
        mi.setActionCommand("draw saturation()");
        colorMenu.add(mi);
        colorMenu.addSeparator();
        for (i = 0; i < Action.COLORNAME.length; ++i) {
            mi = new JMenuItem(Action.COLORNAME[i]);
            mi.addActionListener(this);
            mi.setActionCommand("draw " + Action.COLORNAME[i]);
            colorMenu.add(mi);
        }
        this.actionMenu.add(shapeMenu);
        this.actionMenu.add(colorMenu);
        for (i = 0; i < UNITBASE.length; ++i) {
            mi = new JMenuItem(UNITBASE[i] + " - " + UNITEXPLAIN[i]);
            mi.addActionListener(this);
            mi.setActionCommand(UNITBASE[i]);
            this.unitMenu.add(mi);
        }
    }

    private void majPredefFilters() {
        if (this.predefFilters == null) {
            this.predefFilters = new JComboBox();
            this.predefFilters.addActionListener(this);
        }
        this.createPredefFilters();
        this.predefFilters.setSelectedIndex(0);
    }

    private void createPredefFilters() {
        int i;
        this.predefFilters.removeAllItems();
        this.predefFilters.addItem("----");
        for (i = 0; i < PlanFilter.PREDEFLABELS.length; ++i) {
            this.predefFilters.addItem("** " + PlanFilter.PREDEFLABELS[i] + " **");
        }
        for (i = 0; i <= PlanFilter.num; ++i) {
            this.predefFilters.addItem(PlanFilter.saveLabels[i]);
        }
    }

    private void applyBeginnerFilter(JRadioButton cb) {
        if (cb == null) {
            this.pf.updateDefinition("", this.label.getText(), this);
            this.filterDef.setText("");
            return;
        }
        int idx = Util.indexInArrayOf(cb.getText().substring(1), BEGINNER_FILTER);
        if (idx < 0) {
            return;
        }
        this.pf.updateDefinition(BEGINNER_FILTERDEF[idx], this.label.getText(), this);
        this.filterDef.setText(this.pf.script);
        this.aladin.console.printCommand("filter " + this.pf.label + " {\n" + this.pf.script + "\n}");
    }

    private void apply() {
        this.pf.label = this.label.getText();
        String string = currentMode = this.modeTabbedPane.getSelectedIndex() == 0 ? BEGINNER : ADVANCED;
        if (currentMode.equals(ADVANCED)) {
            boolean wasValid = this.pf.isValid();
            this.pf.updateDefinition(this.filterDef.getText(), this.label.getText(), this);
            if (!wasValid && this.pf.isValid()) {
                this.pf.setActivated(true);
                this.pf.updateState();
                this.aladin.calque.select.repaint();
            }
            this.filterDef.setText(this.pf.script);
            this.beginnerCbg.setSelected(new JButton().getModel(), true);
            this.aladin.console.printCommand("filter " + this.pf.label + " {\n" + this.pf.script + "\n}");
        } else {
            Enumeration<AbstractButton> e = this.beginnerCbg.getElements();
            JRadioButton cb = null;
            while (e.hasMoreElements() && !(cb = (JRadioButton)e.nextElement()).isSelected()) {
            }
            this.applyBeginnerFilter(cb);
        }
        FilterProperties.majFilterProp(true, false);
        this.label.setText(this.pf.label);
        this.setTitre(this.LABEL + " \"" + this.pf.label + "\"");
        this.saveDef = this.filterDef.getText();
        this.saveName = this.label.getText();
        this.showRainbowBtn.setEnabled(this.pf.getUCDFilter().hasRainbowFunction());
        this.aladin.view.repaintAll();
        this.aladin.calque.select.repaint();
    }

    protected String getCaveat() {
        return this.CAVEATMSG;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String what = ae.getActionCommand();
        Object target = ae.getSource();
        if (this.APPLY.equals(what)) {
            this.apply();
        } else if (this.CLOSE.equals(what)) {
            this.dispose();
        } else if (this.CAVEAT.equals(what)) {
            Aladin.info(this, this.getCaveat());
        } else if (this.MATHS.equals(what)) {
            this.showMathHelper();
        } else if (target instanceof JRadioButton) {
            this.applyBeginnerFilter((JRadioButton)target);
        } else if (what.equals(this.RAINBOWCM)) {
            double[] minmax = this.pf.getUCDFilter().getRainbowMinMax();
            this.aladin.view.showRainbowFilter(CanvasColorMap.getRainbowCM(false), minmax[0], minmax[1]);
            this.aladin.view.getCurrentView().rainbowF.setTitle(this.pf.label);
            this.aladin.view.getCurrentView().repaint();
        } else if (target instanceof JMenuItem) {
            if (what.equals(this.PICKCOLUMN) || what.equals(this.PICKUCD)) {
                if (pickupHelper == null) {
                    pickupHelper = new PickupHelperFrame();
                }
                pickupHelper.setVisible(true);
                pickupHelper.toFront();
            }
            if (what.equals(this.PICKCOLUMN)) {
                pickColumnMode = true;
                pickUCDMode = false;
                pickupFP = this;
            } else if (what.equals(this.PICKUCD)) {
                pickUCDMode = true;
                pickColumnMode = false;
                pickupFP = this;
            } else if (what.equals(this.OPEN_COLUMNS)) {
                this.showColumnHelper();
            } else {
                int pos;
                JMenuItem mi = (JMenuItem)target;
                String toInsert = mi.getActionCommand();
                toInsert = this.adjustText(toInsert);
                int newPos = pos = FilterProperties.insertInTA(this.filterDef, toInsert, this.filterDef.getCaretPosition());
                int idx = toInsert.indexOf(40);
                if (idx > 0) {
                    newPos = pos - toInsert.length() + idx + 1;
                }
                this.filterDef.setCaretPosition(newPos);
                if (toInsert.startsWith("${") || toInsert.startsWith("$[")) {
                    this.adjustCaretPos();
                }
                this.filterDef.requestFocus();
            }
        } else if (this.predefFilters != null && this.predefFilters.equals(target)) {
            if (this.filterDef == null) {
                return;
            }
            int index = this.predefFilters.getSelectedIndex();
            if (this.oldIndex == 0) {
                this.saveDef = this.filterDef.getText();
                this.saveName = this.label.getText();
            }
            this.oldIndex = index;
            if (index == -1) {
                return;
            }
            if (index == 0) {
                this.filterDef.setText(this.saveDef);
                this.label.setText(this.saveName);
            } else if (index - 1 < PlanFilter.PREDEFFILTERS.length) {
                this.filterDef.setText(PlanFilter.PREDEFFILTERS[index - 1]);
                String predefName = this.getPredefName(PlanFilter.PREDEFFILTERS[index - 1]);
                if (predefName != null) {
                    this.label.setText(predefName);
                }
            } else {
                this.filterDef.setText(PlanFilter.saveFilters[index - 1 - PlanFilter.PREDEFFILTERS.length]);
                this.label.setText(this.saveName);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FilterProperties.this.filterDefSp.getVerticalScrollBar().setValue(0);
                }
            });
        } else if (this.FILTERMANUAL.equals(what)) {
            this.aladin.glu.showDocument("Aladin.filterManual", "");
        } else if (this.EXPORT.equals(what)) {
            this.pf.export();
        } else if (this.FILTER_EXAMPLES.equals(what)) {
            FilterHelp fh = FilterHelp.getInstance();
            if (!fh.isShowing()) {
                fh.setVisible(true);
            }
            fh.toFront();
        } else if (this.SAVEFILTER.equals(what)) {
            this.showFileDialog(1);
            this.saveFilter();
        } else if (this.LOADFILTER.equals(what)) {
            this.showFileDialog(0);
            this.loadFilter();
        }
    }

    private void adjustCaretPos() {
        int pos = this.filterDef.getCaretPosition();
        String text = this.filterDef.getText();
        if (text.length() > pos && text.charAt(pos) == ',') {
            this.filterDef.setCaretPosition(pos + 1);
        }
    }

    private String adjustText(String s) {
        int pos2;
        if (!s.startsWith("draw ")) {
            return s;
        }
        String text = this.filterDef.getText().substring(0, this.filterDef.getCaretPosition());
        int pos1 = -1;
        for (int i = text.length() - 1; i >= 0; --i) {
            if (text.charAt(i) == '\n') {
                pos1 = i;
                break;
            }
            if (text.charAt(i) != '{') continue;
            if (i == 0) {
                pos1 = i;
            }
            if (text.charAt(i - 1) == '$') continue;
            pos1 = i;
            break;
        }
        if ((pos2 = text.lastIndexOf("draw")) < 0) {
            return s;
        }
        if (pos1 < pos2) {
            return s.substring(5) + " ";
        }
        return s;
    }

    private void showColumnHelper() {
        curWindow = this;
        if (columnHelper == null) {
            columnHelper = new ColumnHelperFrame();
            Point p = this.getRightTopPos();
            columnHelper.setLocation(p.x, p.y);
        } else {
            columnHelper.updateFrame();
        }
        columnHelper.show();
        columnHelper.toFront();
    }

    private void showMathHelper() {
        curWindow = this;
        if (mathHelper == null) {
            mathHelper = new MathHelperFrame();
            Point p = this.getRightTopPos();
            int shift = Aladin.SCREENSIZE.height - p.y;
            if (shift < 60) {
                p.y -= 60 - shift;
            }
            mathHelper.setLocation(p.x, p.y + 350);
        }
        mathHelper.show();
        mathHelper.toFront();
    }

    private String getPredefName(String def) {
        StringTokenizer st = new StringTokenizer(def, "\n");
        String curLine = "";
        while (st.hasMoreTokens() && (curLine = st.nextToken().trim()).charAt(0) != '#') {
        }
        if (curLine.charAt(0) == '#') {
            return curLine.substring(1).trim();
        }
        return null;
    }

    static void sortLexico(String[] t) {
        MetaDataTree.sort(t, null, true);
    }

    protected static void notifyNewPlan() {
        FilterProperties.majFilterProp(false, true);
    }

    protected static boolean clickInMesure(Source s, int index) {
        if (pickupFP == null || !pickupFP.isShowing()) {
            return false;
        }
        pickupHelper.setVisible(false);
        if (index >= s.getLeg().field.length) {
            return true;
        }
        if (pickColumnMode) {
            String col = s.getLeg().field[index].name;
            col = col != null ? col : "";
            int pos = FilterProperties.insertInTA(FilterProperties.pickupFP.filterDef, "${" + col + "}", FilterProperties.pickupFP.filterDef.getCaretPosition());
            FilterProperties.pickupFP.filterDef.setCaretPosition(pos);
            pickupFP.adjustCaretPos();
            pickupFP.toFront();
            FilterProperties.pickupFP.filterDef.requestFocus();
            pickColumnMode = false;
            return true;
        }
        if (pickUCDMode) {
            String ucd = s.getLeg().field[index].ucd;
            ucd = ucd != null ? ucd : "";
            int pos = FilterProperties.insertInTA(FilterProperties.pickupFP.filterDef, "$[" + ucd + "]", FilterProperties.pickupFP.filterDef.getCaretPosition());
            FilterProperties.pickupFP.filterDef.setCaretPosition(pos);
            pickupFP.toFront();
            FilterProperties.pickupFP.filterDef.requestFocus();
            pickUCDMode = false;
            return true;
        }
        return false;
    }

    private void updateUCDAndColumn() {
        JMenuItem mi;
        Aladin.trace(3, "Updating UCD and column names in FilterProperties");
        if (ucds == null) {
            FilterProperties.getUcdsAndColumns(this.aladin);
        }
        if (this.firstTime) {
            mi = new JMenuItem(this.OPEN_COLUMNS);
            this.columnMenu.add(mi);
            mi.addActionListener(this);
            this.columnMenu.addSeparator();
            mi = new JMenuItem(this.PICKCOLUMN);
            this.columnMenu.add(mi);
            mi.addActionListener(this);
            this.firstTime = false;
        }
        this.currentUcdMenu.removeAll();
        for (int i = 0; i < ucds.length; ++i) {
            String explain;
            String label = ucds[i];
            if (useUcdExplain && (explain = FilterProperties.getUCDExplain(ucds[i], true)).length() > 0) {
                label = label + " - " + explain;
            }
            mi = new JMenuItem(label);
            mi.addActionListener(this);
            mi.setActionCommand("$[" + ucds[i] + "]");
            this.currentUcdMenu.add(mi);
        }
        this.computeCol = false;
    }

    static String getUCDExplain(String ucd, boolean truncate) {
        String explain;
        if (ucd == null) {
            return "";
        }
        int limit = 70;
        if (FilterProperties.isUCD1Plus(ucd)) {
            ucd = ucd.toLowerCase();
            StringTokenizer st = new StringTokenizer(ucd, ";");
            explain = "";
            int idx = 0;
            while (st.hasMoreTokens()) {
                String partExplain = Aladin.chaine.getString(st.nextToken());
                if (partExplain.length() > 0 && partExplain.charAt(0) == '[') {
                    partExplain = "?";
                }
                if (idx > 0) {
                    explain = explain + "/";
                }
                explain = explain + partExplain;
                ++idx;
            }
        } else {
            explain = Aladin.chaine.getString(ucd);
            if (explain.length() > 0 && explain.charAt(0) == '[') {
                explain = "?";
            }
        }
        if (truncate && explain.length() > limit) {
            explain = explain.substring(0, limit) + "...";
        }
        return explain;
    }

    static boolean isUCD1Plus(String ucd) {
        if (ucd.indexOf(95) > 0) {
            return false;
        }
        if (ucd.indexOf(59) > 0) {
            return true;
        }
        return !ucd.toUpperCase().equals(ucd);
    }

    static void getUcdsAndColumns(Aladin aladin) {
        Aladin.trace(3, "Recompute all available columns and UCD");
        Vector<String> vUCD = new Vector<String>();
        for (int i = aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan p = aladin.calque.plan[i];
            if (!p.isCatalog()) continue;
            Iterator<Obj> it = p.iterator();
            while (it != null && it.hasNext()) {
                Obj o1 = it.next();
                if (!o1.asSource()) continue;
                Source s = (Source)o1;
                if (s.getLeg() == null || s.getLeg().field == null) {
                    System.out.println("Bizarre");
                }
                for (int k = s.getLeg().field.length - 1; k >= 0; --k) {
                    String str = s.getLeg().field[k].name;
                    str = s.getLeg().field[k].ucd;
                    if (str == null || str.length() <= 0 || vUCD.indexOf(str) >= 0) continue;
                    vUCD.addElement(str);
                }
            }
        }
        ucds = new String[vUCD.size()];
        vUCD.copyInto(ucds);
        vUCD = null;
        FilterProperties.sortLexico(ucds);
    }

    private void saveFilter() {
        String dir = this.fd.getDirectory();
        String name = this.fd.getFile();
        String s = (dir == null ? "" : dir) + (name == null ? "" : name);
        if (name == null) {
            return;
        }
        if (!s.endsWith(".ajs")) {
            s = s + ".ajs";
        }
        File file = new File(s);
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeBytes("#AJS" + Util.CR);
            out.writeBytes("filter " + this.pf.label + " {" + Util.CR);
            out.writeBytes(this.pf.script);
            out.writeBytes(Util.CR + "}" + Util.CR);
            out.close();
        }
        catch (IOException e) {
            Aladin.error(this, this.IOERR + " : " + e);
        }
    }

    private void loadFilter() {
        String dir = this.fd.getDirectory();
        String name = this.fd.getFile();
        String s = (dir == null ? "" : dir) + (name == null ? "" : name);
        if (name == null) {
            return;
        }
        File file = new File(s);
        String def = new String();
        try {
            String line;
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            while ((line = dis.readLine()) != null) {
                if (def.length() > 0) {
                    def = def + Util.CR;
                }
                def = def + line;
            }
            dis.close();
        }
        catch (IOException e) {
            Aladin.error(this, this.IOERR + " : " + e, 1);
            return;
        }
        this.pf.updateDefinition(def, null, this);
        this.showProp();
        this.setTitre(this.LABEL + " \"" + this.pf.label + "\"");
        FilterProperties.majFilterProp(true, false);
        this.aladin.calque.select.repaint();
        this.aladin.view.setMesure();
    }

    protected static void majFilterProp(boolean majPredef, boolean majPopup) {
        if (majPopup) {
            FilterProperties.getUcdsAndColumns(Aladin.aladin);
        }
        Enumeration e = frameProp.elements();
        while (e.hasMoreElements()) {
            Properties propc = (Properties)e.nextElement();
            if (propc.plan.type != 12) continue;
            FilterProperties fp = (FilterProperties)propc;
            if (majPredef) {
                fp.majPredefFilters();
            }
            if (!majPopup) continue;
            fp.updateUCDAndColumn();
        }
    }

    static int insertInTA(JTextArea t, String text, int pos) {
        StringBuffer sb = new StringBuffer(t.getText());
        sb.insert(pos, text);
        t.setText(sb.toString());
        t.repaint();
        int nb = Action.countNbOcc('\r', t.getText().substring(0, pos));
        int newPos = pos + text.length() - nb;
        t.setCaretPosition(newPos);
        return newPos;
    }

    private void showFileDialog(int mode) {
        String dir = null;
        if (this.fd != null) {
            dir = this.fd.getDirectory();
        }
        this.fd = new FileDialog((Frame)this, "", mode);
        if (dir != null) {
            this.fd.setDirectory(dir);
        } else {
            this.aladin.setDefaultDirectory(this.fd);
        }
        if (mode == 1) {
            this.fd.setFile(this.pf.label + ".ajs");
            this.fd.setTitle(this.SAVEFILTER);
        } else {
            this.fd.setFile("");
            this.fd.setTitle(this.LOADFILTER);
        }
        this.fd.show();
    }

    @Override
    public void dispose() {
        if (pickupFP == this) {
            pickupFP = null;
            pickupHelper.hide();
        }
        this.closeHelperFrames();
        super.dispose();
    }

    private void closeHelperFrames() {
        if (curWindow != this) {
            return;
        }
        if (columnHelper != null) {
            columnHelper.hide();
        }
        if (mathHelper != null) {
            mathHelper.hide();
        }
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.id == 201) {
            this.dispose();
        }
        return super.handleEvent(e);
    }

    private Point getRightTopPos() {
        Point p = this.getLocation();
        Dimension d = this.getSize();
        p.x += d.width;
        int shift = Aladin.SCREENSIZE.width - p.x;
        if (shift < 100) {
            p.x -= 100 - shift;
        }
        return p;
    }

    protected static String getCurrentMode() {
        return currentMode;
    }

    protected static void setCurrentMode(String currentMode) {
        if (!currentMode.equals(BEGINNER) && !currentMode.equals(ADVANCED)) {
            return;
        }
        FilterProperties.currentMode = currentMode;
    }

    protected static FilterProperties getCurWindow() {
        return curWindow;
    }

    static {
        currentMode = BEGINNER;
        useUcdExplain = true;
        UCDBASE = new String[]{"phot*", "phot.mag*", "phot.mag;em.opt*", "pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "src.class*", "meta.code*", "meta.id;meta.main", "meta.number"};
        UNITBASE = new String[]{"arcmin", "arcsec", "deg", "eV", "Jy", "mag", "pc", "rad", "yr", "W"};
        BEGINNER_FILTERDEF = new String[]{"{ draw circle(-$[phot.mag*]) }", "$[phot.mag*]<12 { draw }", "$[phot.mag*]>17 { draw }", "{ draw $[src.class] }", "{ draw pm($[pos.pm;pos.eq.ra], $[pos.pm;pos.eq.dec]) }", "{\ndraw\ndraw ellipse(0.5*$[phys.angSize.smajAxis],0.5*$[phys.angSize.sminAxis],$[pos.posAng])\n}"};
        pickUCDMode = false;
        pickColumnMode = false;
        BEGINNER = Aladin.chaine.getString("FTBEGINNER");
        ADVANCED = Aladin.chaine.getString("FTADVANCED");
        String[] stringArray = new String[6];
        stringArray[0] = Aladin.chaine.getString("FTDEMO1");
        stringArray[1] = Aladin.chaine.getString("FTDEMO2");
        stringArray[2] = Aladin.chaine.getString("FTDEMO3");
        stringArray[3] = Aladin.chaine.getString("FTDEMO4");
        stringArray[4] = Aladin.chaine.getString("FTDEMO5");
        stringArray[5] = Aladin.chaine.getString("FTDEMO6");
        BEGINNER_FILTER = stringArray;
        BUTTON_INSETS = new Insets(0, 1, 0, 1);
    }

    class PickupHelperFrame
    extends JFrame
    implements ActionListener {
        static final String HELP = "First, select some sources \n \nThen, click in the measurement panel on the given field \nyou would like to use in your filter.";
        static final String CLOSE = "Close";

        PickupHelperFrame() {
            super("Pick a column/a UCD");
            Aladin.setIcon(this);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.updateFrame();
        }

        void updateFrame() {
            this.getContentPane().removeAll();
            MyLabel l = new MyLabel(HELP);
            this.getContentPane().add((Component)l, "Center");
            l.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel p2 = new JPanel(new FlowLayout());
            JButton b = new JButton(CLOSE);
            p2.add(b);
            b.addActionListener(this);
            this.getContentPane().add((Component)p2, "South");
            this.pack();
            Point p = FilterProperties.this.aladin.localisation.getLocation();
            Container parent = FilterProperties.this.aladin.localisation;
            while ((parent = parent.getParent()) != null) {
                Point tmp = parent.getLocation();
                p.x += tmp.x;
                p.y += tmp.y;
            }
            this.setLocation(p.x, p.y + 30);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String what = ae.getActionCommand();
            if (what.equals(CLOSE)) {
                this.setVisible(false);
            }
        }

        @Override
        public boolean handleEvent(Event e) {
            if (e.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(e);
        }
    }

    class ColumnHelperFrame
    extends JFrame
    implements ActionListener {
        static final String CLOSE = "Close";

        ColumnHelperFrame() {
            super("Available columns");
            Aladin.setIcon(this);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.updateFrame();
        }

        void updateFrame() {
            this.getContentPane().removeAll();
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            GridBagLayout g = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.gridwidth = 0;
            c.anchor = 17;
            p.setLayout(g);
            int nbCol = 4;
            for (int i = 0; i < FilterProperties.this.aladin.calque.plan.length; ++i) {
                Plan plan = FilterProperties.this.aladin.calque.plan[i];
                if (!plan.isCatalog() || !plan.flagOk) continue;
                Legende oleg = null;
                JPanel pBtns = new JPanel(new GridLayout(0, nbCol, 2, 2));
                pBtns.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(null, plan.getLabel(), 0, 0, Aladin.BOLD)), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
                int idxBtn = 0;
                Iterator<Obj> it = plan.iterator();
                while (it.hasNext()) {
                    Obj o = it.next();
                    if (!o.asSource()) continue;
                    Source s = (Source)o;
                    Legende leg = s.getLeg();
                    if (oleg != null && leg == oleg) continue;
                    while (idxBtn % nbCol != 0) {
                        pBtns.add(new JLabel());
                        ++idxBtn;
                    }
                    for (int k = 0; k < s.getLeg().field.length; ++k) {
                        JButton btn = new JButton(s.getLeg().field[k].name);
                        btn.setMargin(BUTTON_INSETS);
                        btn.addActionListener(this);
                        btn.setFont(Aladin.PLAIN);
                        pBtns.add(btn);
                        ++idxBtn;
                        oleg = leg;
                    }
                }
                g.setConstraints(pBtns, c);
                p.add(pBtns);
            }
            JScrollPane scroll = new JScrollPane(p, 20, 30);
            scroll.setSize(300, 290);
            this.getContentPane().add((Component)scroll, "Center");
            JPanel p2 = new JPanel(new FlowLayout());
            JButton b = new JButton(CLOSE);
            p2.add(b);
            b.addActionListener(this);
            this.getContentPane().add((Component)p2, "South");
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String what = ae.getActionCommand();
            Object target = ae.getSource();
            if (CLOSE.equals(what)) {
                this.setVisible(false);
            } else {
                String btnLabel = ((JButton)target).getText();
                int pos = FilterProperties.insertInTA(curWindow.filterDef, "${" + btnLabel + "}", curWindow.filterDef.getCaretPosition());
                curWindow.filterDef.setCaretPosition(pos);
                FilterProperties.this.adjustCaretPos();
                curWindow.toFront();
                curWindow.filterDef.requestFocus();
            }
        }

        @Override
        public boolean handleEvent(Event e) {
            if (e.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(e);
        }

        @Override
        public void show() {
            super.show();
        }
    }

    class MathHelperFrame
    extends JFrame
    implements ActionListener {
        static final String CLOSE = "Close";

        MathHelperFrame() {
            super("Available math operators/functions");
            Aladin.setIcon(this);
            this.getContentPane().setLayout(new BorderLayout(0, 0));
            this.buildFrame();
        }

        private void buildFrame() {
            JButton b;
            this.getContentPane().removeAll();
            JPanel p = new JPanel();
            GridBagLayout g = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.gridwidth = 0;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            p.setLayout(g);
            JLabel l = new JLabel("Operators");
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            JPanel pOp = new JPanel(new FlowLayout(0));
            for (int i = 0; i < FrameColumnCalculator.OPERATORS.length; ++i) {
                b = new JButton(FrameColumnCalculator.OPERATORS[i]);
                b.addActionListener(this);
                b.setFont(Aladin.BOLD);
                pOp.add(b);
            }
            g.setConstraints(pOp, c);
            p.add(pOp);
            l = new JLabel("Functions");
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            JPanel pFunc = new JPanel(new GridLayout(0, 4, 0, 0));
            String[] func = Parser.getAvailFunc();
            for (int i = 0; i < func.length; ++i) {
                b = new JButton(func[i]);
                b.addActionListener(this);
                b.setActionCommand(func[i] + "()");
                pFunc.add(b);
            }
            g.setConstraints(pFunc, c);
            p.add(pFunc);
            String[] compOp = new String[]{"=", "!=", "<", "<=", ">", ">="};
            l = new JLabel("Comparison operators");
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            JPanel pCompOp = new JPanel(new FlowLayout(0));
            for (int i = 0; i < compOp.length; ++i) {
                b = new JButton(compOp[i]);
                b.addActionListener(this);
                b.setFont(Aladin.BOLD);
                pCompOp.add(b);
            }
            g.setConstraints(pCompOp, c);
            p.add(pCompOp);
            String[] misc = new String[]{"{", "}", "&&", "||", "\""};
            l = new JLabel("Miscellaneous");
            l.setFont(Aladin.BOLD);
            g.setConstraints(l, c);
            p.add(l);
            JPanel pMisc = new JPanel(new FlowLayout(0));
            for (int i = 0; i < misc.length; ++i) {
                b = new JButton(misc[i]);
                b.addActionListener(this);
                b.setFont(Aladin.BOLD);
                pMisc.add(b);
            }
            g.setConstraints(pMisc, c);
            p.add(pMisc);
            JScrollPane scroll = new JScrollPane(p, 20, 30);
            scroll.setSize(280, 300);
            scroll.setOpaque(false);
            this.getContentPane().add((Component)scroll, "Center");
            scroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 8, 5, 8), BorderFactory.createTitledBorder("")));
            JPanel p2 = new JPanel(new FlowLayout());
            b = new JButton(CLOSE);
            p2.add(b);
            b.addActionListener(this);
            this.getContentPane().add((Component)p2, "South");
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String what = ae.getActionCommand();
            Object target = ae.getSource();
            if (CLOSE.equals(what)) {
                this.setVisible(false);
            } else {
                String btnLabel = ((JButton)target).getActionCommand();
                int pos = FilterProperties.insertInTA(curWindow.filterDef, btnLabel, curWindow.filterDef.getCaretPosition());
                curWindow.filterDef.setCaretPosition(pos);
                curWindow.toFront();
                curWindow.filterDef.requestFocus();
            }
        }

        @Override
        public boolean handleEvent(Event e) {
            if (e.id == 201) {
                this.setVisible(false);
            }
            return super.handleEvent(e);
        }

        @Override
        public void show() {
            super.show();
        }
    }
}

