/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FilterActionClass;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class FilterDocument
extends PlainDocument {
    private static final long serialVersionUID = 9106769181814191291L;
    FilterActionClass actionClass;
    JComboBox<String> comboBox;
    List<String> keys;
    int processLevelFlag = 0;

    public FilterDocument() {
    }

    public FilterDocument(FilterActionClass actClass, JComboBox<String> gui, List<String> keys, String defaultSelection) throws BadLocationException {
        this.actionClass = actClass;
        this.comboBox = gui;
        this.keys = new ArrayList<String>();
        this.keys.addAll(keys);
        JTextComponent editor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FilterDocument.this.comboBox.isDisplayable()) {
                    FilterDocument.this.comboBox.setPopupVisible(true);
                }
                if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                    String mask = FilterDocument.this.getMask();
                    if (mask != null && !mask.isEmpty()) {
                        FilterDocument.this.processLevelFlag = 2;
                    }
                } else if (e.getKeyCode() == 10) {
                    FilterDocument.this.processLevelFlag = 0;
                    FilterDocument.this.actionClass.checkSelectionChanged(FilterDocument.this.comboBox);
                } else {
                    FilterDocument.this.processLevelFlag = e.getKeyCode() == 38 || e.getKeyCode() == 40 ? -1 : 1;
                }
            }
        });
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                FilterDocument.this.setGuiAsPerUserInput();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterDocument.this.processLevelFlag < 0) {
                    return;
                }
                FilterDocument.this.setGuiAsPerUserInput();
            }
        });
        this.processLevelFlag = -1;
        if (this.comboBox.getItemCount() > 0) {
            if (defaultSelection == null) {
                this.setDefault();
            } else {
                this.setDefault(defaultSelection);
            }
        }
        this.processLevelFlag = 0;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.processLevelFlag < 0) {
            return;
        }
        super.remove(offs, len);
        if (this.processLevelFlag == 2) {
            this.search();
            this.comboBox.setPopupVisible(true);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.processLevelFlag < 0) {
            return;
        }
        super.insertString(offs, str, a);
        if (this.processLevelFlag > 0) {
            this.search();
            this.comboBox.setPopupVisible(true);
        }
        if (Aladin.winPlateform) {
            JTextComponent editor = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            editor.setCaretPosition(this.getLength());
        }
    }

    public void setGuiAsPerUserInput() {
        try {
            String mask = this.getMask();
            if (mask == null || mask.isEmpty()) {
                this.processLevelFlag = 0;
                this.setDefault();
            } else if (!this.isValidSelection(mask)) {
                this.processLevelFlag = 0;
                this.setDefault(this.getFirstItemOnJComboBox());
            }
            this.actionClass.checkSelectionChanged(this.comboBox);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
    }

    private void search() {
        String mask = this.getMask();
        this.processLevelFlag = -1;
        if (mask == null || mask.trim().isEmpty()) {
            this.resetPopUpMenu();
        } else {
            Vector<String> matches = this.actionClass.getMatches(mask, this.comboBox);
            if (!matches.isEmpty()) {
                this.resetPopUpMenu(matches);
            }
        }
        this.processLevelFlag = 0;
    }

    public String getMask() {
        Document tablesGuiDocument = ((JTextComponent)this.comboBox.getEditor().getEditorComponent()).getDocument();
        String mask = null;
        try {
            mask = tablesGuiDocument.getText(0, tablesGuiDocument.getLength()).trim();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return mask;
    }

    public boolean isValidSelection(String mask) {
        boolean result = false;
        if (mask != null && this.keys.contains(mask)) {
            result = true;
        }
        return result;
    }

    public void resetPopUpMenu() {
        Vector<String> resetKeys = new Vector<String>(this.keys.size());
        resetKeys.addAll(this.keys);
        this.resetPopUpMenu(resetKeys);
    }

    public void resetPopUpMenu(Vector<String> keys) {
        DefaultComboBoxModel<String> items = new DefaultComboBoxModel<String>(keys);
        this.comboBox.removeAllItems();
        this.comboBox.setModel(items);
    }

    public String getFirstItemOnJComboBox() {
        return (String)this.comboBox.getModel().getElementAt(0);
    }

    public void setDefault(String tableName) throws BadLocationException {
        if (tableName != null && this.keys.contains(tableName)) {
            super.remove(0, this.getLength());
            super.insertString(0, tableName, null);
            this.comboBox.setSelectedItem(tableName);
        }
    }

    public void setDefault() throws BadLocationException {
        String defaultTableSelected = this.keys.get(0);
        this.setDefault(defaultTableSelected);
    }
}

