/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.DirectoryModel;
import cds.aladin.MyTreeUI;
import cds.aladin.TreeObj;
import cds.aladin.TreeObjDir;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DirectoryTree
extends JTree {
    protected DefaultMutableTreeNode root;
    private Aladin aladin;
    static final String TREEDROP = "__ALADIN/TREE__";
    private boolean suspended = false;
    private HashMap<String, MyImageIcon> mapIcon = null;
    private static final Color r = new Color(255, 100, 100);
    private static final Color v = new Color(50, 255, 50);
    private static final Color b = new Color(100, 100, 255);

    protected DirectoryTree(Aladin aladin, Color cbg) {
        this.aladin = aladin;
        this.setUI(new MyTreeUI(cbg));
        this.setModel(new DirectoryModel(aladin));
        this.setDragEnabled(true);
        this.setTransferHandler(new TreeTransfertHandler());
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.setShowsRootHandles(true);
        NoeudRenderer nr = new NoeudRenderer();
        this.setCellRenderer(nr);
        this.setLargeModel(true);
        Component c = nr.getTreeCellRendererComponent(this, this.getModel().getRoot(), false, false, false, 1, false);
        int rowHeight = c.getPreferredSize().height;
        this.setRowHeight(rowHeight);
    }

    @Override
    public boolean hasBeenExpanded(TreePath path) {
        return false;
    }

    @Override
    public void setModel(TreeModel model) {
        this.root = (DefaultMutableTreeNode)model.getRoot();
        super.setModel(model);
    }

    protected boolean showBranch(String p) {
        if (p == null) {
            return false;
        }
        TreePath path = this.findBranch(new TreePath(this.root), p);
        if (path == null) {
            return false;
        }
        TreePath r = new TreePath(this.root);
        this.suspendListener();
        this.collapseRec(r);
        this.restoreListener();
        this.expandPath(path);
        this.setSelectionPath(path);
        Rectangle bounds = this.getPathBounds(path);
        bounds.height = this.getVisibleRect().height;
        this.scrollRectToVisible(bounds);
        return true;
    }

    private TreePath findBranch(TreePath parent, String p) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        TreeObj to = (TreeObj)node.getUserObject();
        if (to.path.equals(p)) {
            return parent;
        }
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                TreePath tp = this.findBranch(path, p);
                if (tp == null) continue;
                return tp;
            }
        }
        return null;
    }

    protected void showTreeObj(String id) {
        block4: {
            if (id == null) {
                return;
            }
            try {
                TreePath path = this.findTreeObj(new TreePath(this.root), id);
                if (path == null) {
                    return;
                }
                this.setSelectionPath(path);
                Rectangle bounds = this.getPathBounds(path);
                bounds.height = this.getVisibleRect().height;
                this.scrollRectToVisible(bounds);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    private TreePath findTreeObj(TreePath parent, String id) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        TreeObj to = (TreeObj)node.getUserObject();
        if (to instanceof TreeObjDir && ((TreeObjDir)to).internalId.endsWith(id)) {
            return parent;
        }
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                TreePath tp = this.findTreeObj(path, id);
                if (tp == null) continue;
                return tp;
            }
        }
        return null;
    }

    protected boolean isDefaultExpand() {
        TreePath rootTp = new TreePath(this.root);
        if (this.root.getChildCount() >= 0) {
            Enumeration<TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = rootTp.pathByAddingChild(n);
                if (this.isCollapsedRec(path)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isCollapsedRec(TreePath parent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                if (this.isCollapsedRec(path)) continue;
                return false;
            }
        }
        return this.isCollapsed(parent);
    }

    protected void minimalExpand() {
        TreePath rootTp = new TreePath(this.root);
        this.expandPath(rootTp);
    }

    protected void defaultExpand() {
        TreePath rootTp = new TreePath(this.root);
        if (this.root.getChildCount() >= 0) {
            Enumeration<TreeNode> e = this.root.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = rootTp.pathByAddingChild(subNode);
                this.collapseRec(path);
            }
        }
        this.expandPath(rootTp);
    }

    protected void collapseRec(TreePath parent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                this.collapseRec(path);
            }
        }
        this.collapsePath(parent);
    }

    protected void suspendListener() {
        this.suspended = true;
    }

    protected void restoreListener() {
        this.suspended = false;
    }

    @Override
    public void fireTreeExpanded(TreePath path) {
        if (!this.suspended) {
            super.fireTreeExpanded(path);
        }
    }

    @Override
    public void fireTreeCollapsed(TreePath path) {
        if (!this.suspended) {
            super.fireTreeCollapsed(path);
        }
    }

    @Override
    public void fireTreeWillExpand(TreePath path) throws ExpandVetoException {
        if (!this.suspended) {
            super.fireTreeWillExpand(path);
        }
    }

    @Override
    public void fireTreeWillCollapse(TreePath path) throws ExpandVetoException {
        if (!this.suspended) {
            super.fireTreeWillCollapse(path);
        }
    }

    protected void allExpand() {
        this.allExpand(new TreePath(this.root));
    }

    protected void allExpand(TreePath path) {
        this.suspendListener();
        this.expandAll(path);
        this.restoreListener();
        this.collapsePath(path);
        this.expandPath(path);
    }

    protected void expandAll(TreePath parent) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode subNode = (DefaultMutableTreeNode)e.nextElement();
                TreePath path = parent.pathByAddingChild(subNode);
                this.expandAll(path);
            }
        }
        this.expandPath(parent);
    }

    private void initMapIcon() {
        try {
            this.mapIcon = new HashMap();
            Image img = this.aladin.getImagette("Folder.png");
            this.mapIcon.put("folder", new MyImageIcon(img));
            img = this.aladin.getImagette("FolderUnsupervised.png");
            this.mapIcon.put("folderunsupervised", new MyImageIcon(img));
            img = this.aladin.getImagette("FolderProblematic.png");
            this.mapIcon.put("folderproblematic", new MyImageIcon(img));
            img = this.aladin.getImagette("FolderVizieR.png");
            this.mapIcon.put("foldervizieR", new MyImageIcon(img));
            img = this.aladin.getImagette("cds.png");
            this.mapIcon.put("cds", new MyImageIcon(img));
            this.mapIcon.put("cds.vizier", new MyImageIcon(img));
            this.mapIcon.put("cds/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("nasa.png");
            this.mapIcon.put("nasa.heasarc", new MyImageIcon(img));
            this.mapIcon.put("nasa.heasarc/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("eso.png");
            this.mapIcon.put("eso.org", new MyImageIcon(img));
            this.mapIcon.put("eso.org/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("ipac.png");
            this.mapIcon.put("ned.ipac", new MyImageIcon(img));
            this.mapIcon.put("irsa.ipac", new MyImageIcon(img));
            this.mapIcon.put("irsa.ipac/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("mast.png");
            this.mapIcon.put("mast.stsci", new MyImageIcon(img));
            this.mapIcon.put("mast.stsci/color", new MyImageIcon(this.setIconTag(img)));
            this.mapIcon.put("archive.stsci.edu", new MyImageIcon(img));
            this.mapIcon.put("archive.stsci.edu/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("cadc.png");
            this.mapIcon.put("cadc.nrc.ca", new MyImageIcon(img));
            this.mapIcon.put("cadc.nrc.ca/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("esa.png");
            this.mapIcon.put("esavo", new MyImageIcon(img));
            this.mapIcon.put("esavo/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("jaxa.png");
            this.mapIcon.put("jaxa", new MyImageIcon(img));
            this.mapIcon.put("jaxa/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("irap.png");
            this.mapIcon.put("ov-gso", new MyImageIcon(img));
            this.mapIcon.put("ov-gso/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("xcatdb.png");
            this.mapIcon.put("xcatdb", new MyImageIcon(img));
            this.mapIcon.put("xcatdb/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("wfau.png");
            this.mapIcon.put("wfau.roe.ac.uk", new MyImageIcon(img));
            this.mapIcon.put("wfau.roe.ac.uk/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("inaf.png");
            this.mapIcon.put("ia2.inaf.it", new MyImageIcon(img));
            this.mapIcon.put("ia2.inaf.it/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("cfa.png");
            this.mapIcon.put("cfa.tdc", new MyImageIcon(img));
            this.mapIcon.put("cfa.tdc/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("nrao.png");
            this.mapIcon.put("nrao", new MyImageIcon(img));
            this.mapIcon.put("nrao/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("cvo.png");
            this.mapIcon.put("cvo.naoc", new MyImageIcon(img));
            this.mapIcon.put("cvo.naoc/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("nova.png");
            this.mapIcon.put("ar.nova", new MyImageIcon(img));
            this.mapIcon.put("ar.nova/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("svo.png");
            this.mapIcon.put("svo.cab", new MyImageIcon(img));
            this.mapIcon.put("svo.cab/color", new MyImageIcon(this.setIconTag(img)));
            this.mapIcon.put("svo.ifca", new MyImageIcon(img));
            img = this.aladin.getImagette("ucl.png");
            this.mapIcon.put("mssl.ucl.ac.uk", new MyImageIcon(img));
            this.mapIcon.put("mssl.ucl.ac.uk/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("gavo.png");
            this.mapIcon.put("org.gavo.dc", new MyImageIcon(img));
            this.mapIcon.put("org.gavo.dc/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("vopdc.png");
            this.mapIcon.put("vopdc.obspm", new MyImageIcon(img));
            this.mapIcon.put("vopdc.obspm/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("chinavo.png");
            this.mapIcon.put("china-vo", new MyImageIcon(img));
            this.mapIcon.put("china-vo/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("noao.png");
            this.mapIcon.put("noao", new MyImageIcon(img));
            this.mapIcon.put("noao/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("sdss.png");
            this.mapIcon.put("sdss.jhu", new MyImageIcon(img));
            this.mapIcon.put("sdss.jhu/color", new MyImageIcon(this.setIconTag(img)));
            img = this.aladin.getImagette("astron.png");
            this.mapIcon.put("astron.nl", new MyImageIcon(img));
            this.mapIcon.put("hips.astron.nl", new MyImageIcon(img));
            this.mapIcon.put("f", new MyImageIcon(img));
            this.mapIcon.put("defaut", new MyImageIcon());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MyImageIcon getIcon(String id, int mode) {
        int i;
        if (id == null) {
            return null;
        }
        if (this.mapIcon == null) {
            this.initMapIcon();
        }
        if ((i = id.indexOf(47)) == -1) {
            i = id.length();
        }
        String key = id.substring(0, i) + (mode == 1 ? "/color" : (mode == 2 ? "/fits" : ""));
        return this.mapIcon.get(key.toLowerCase());
    }

    private Image setIconTag(Image img) {
        int w = img.getWidth(this.aladin) + 14;
        int h = img.getHeight(this.aladin);
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics g = img2.getGraphics();
        g.drawImage(img, 1, 0, this.aladin);
        DirectoryTree.drawRGBIconTag(g, w - 8, h / 2);
        return img2;
    }

    public static void drawRGBIconTag(Graphics g, int x, int y) {
        g.setColor(r);
        Util.fillCircle5(g, x, y - 3);
        g.setColor(v);
        Util.fillCircle5(g, x, y + 2);
        g.setColor(b);
        Util.fillCircle5(g, x + 4, y);
    }

    class MyImageIcon
    extends ImageIcon {
        Color color;
        boolean defaut;
        boolean hasMoc;
        boolean isNew;

        public MyImageIcon() {
            this.defaut = true;
            this.hasMoc = true;
            this.color = null;
        }

        public MyImageIcon(Image image) {
            super(image);
        }

        void setColor(Color color) {
            this.color = color;
        }

        void setMoc(boolean hasMoc) {
            this.hasMoc = hasMoc;
        }

        void setNew(boolean isNew) {
            this.isNew = isNew;
        }

        @Override
        public int getIconWidth() {
            if (this.defaut) {
                return 12;
            }
            return super.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            if (this.defaut) {
                return 12;
            }
            return super.getIconHeight();
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.defaut) {
                g.setColor(Color.gray.darker());
                Util.fillCircle7(g, x + 5, y + 6);
            } else {
                super.paintIcon(c, g, x, y);
            }
            if (this.color != null) {
                Util.drawCheck(g, -3, -2, this.color == Color.black ? Color.lightGray : this.color);
            }
            if (!this.hasMoc) {
                Util.drawWarning(g, 0, 8, Aladin.ORANGE, Color.black);
            }
            if (this.isNew) {
                Util.drawNew(g, 9, 3, Color.yellow);
            }
        }
    }

    class TreeTransfertHandler
    extends TransferHandler {
        @Override
        protected Transferable createTransferable(JComponent component) {
            return new StringSelection(DirectoryTree.TREEDROP);
        }

        @Override
        public int getSourceActions(JComponent component) {
            return 3;
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            return false;
        }

        @Override
        public boolean importData(JComponent component, Transferable t) {
            return false;
        }
    }

    class NoeudRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color textForeground = UIManager.getColor("Tree.textForeground");
        Color textBackground = UIManager.getColor("Tree.textBackground");

        NoeudRenderer() {
            this.nonLeafRenderer.setBackgroundNonSelectionColor(DirectoryTree.this.getBackground());
            DirectoryTree.this.setFont(DirectoryTree.this.getFont().deriveFont(DirectoryTree.this.getFont().getSize2D() * Aladin.getUIScale()));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            TreeObj n = (TreeObj)node.getUserObject();
            Component c = this.nonLeafRenderer.getTreeCellRendererComponent(tree, obj, selected, expanded, leaf, row, hasFocus);
            try {
                if (!node.isLeaf() && c instanceof JLabel) {
                    int nb = n.nb;
                    int ref = n.nbRef;
                    String s = "<font color=\"gray\"> &rarr; " + (nb == ref || nb == -1 ? Integer.valueOf(ref) : " " + nb + " / " + ref) + "</font>";
                    JLabel lab = (JLabel)c;
                    lab.setText("<html>" + lab.getText() + s + "</html>");
                }
                boolean flagHighLighted = false;
                TreeObjDir tohl = ((DirectoryTree)DirectoryTree.this).aladin.directory.getTreeObjDirHighLighted();
                if (node.isLeaf() && tohl != null && ((TreeObjDir)n).internalId.equals(tohl.internalId)) {
                    ((DefaultTreeCellRenderer)c).setBackgroundNonSelectionColor(Aladin.COLOR_STACK_HIGHLIGHT);
                    flagHighLighted = true;
                } else {
                    ((DefaultTreeCellRenderer)c).setBackgroundNonSelectionColor(DirectoryTree.this.getBackground());
                }
                int isIn = n.getIsIn();
                Color fg = Aladin.COLOR_CONTROL_FOREGROUND;
                if (isIn == 0) {
                    fg = Aladin.ORANGE;
                } else if (isIn == 1) {
                    fg = Aladin.COLOR_GREEN;
                }
                if (((DirectoryTree)DirectoryTree.this).aladin.directory.iconInside.isActivated() && !node.isLeaf() && n.nb != n.nbRef) {
                    fg = Aladin.COLOR_CONTROL_FOREGROUND;
                }
                if (flagHighLighted || selected) {
                    fg = fg.brighter();
                }
                c.setForeground(fg);
                boolean flagTestInside = ((DirectoryTree)DirectoryTree.this).aladin.directory.iconInside.isAvailable();
                MyImageIcon icon = null;
                if (n instanceof TreeObjDir) {
                    TreeObjDir to = (TreeObjDir)n;
                    icon = DirectoryTree.this.getIcon(to.internalId, to.isColored() ? 1 : 0);
                    if (icon == null) {
                        icon = DirectoryTree.this.getIcon("defaut", 0);
                    }
                } else if (!node.isLeaf()) {
                    icon = n.path.startsWith("Others") ? DirectoryTree.this.getIcon("FolderUnsupervised", 0) : (n.path.startsWith("Problematic") ? DirectoryTree.this.getIcon("FolderProblematic", 0) : DirectoryTree.this.getIcon("Folder", 0));
                }
                if (icon != null) {
                    icon.setColor(n.isInStack());
                    boolean hasMoc = true;
                    boolean isNew = false;
                    if (n instanceof TreeObjDir) {
                        TreeObjDir to = (TreeObjDir)n;
                        isNew = to.isNew();
                        if (flagTestInside) {
                            boolean bl = hasMoc = isIn != -1 || to.hasMoc();
                            if (!hasMoc && to.isScanning()) {
                                hasMoc = ((DirectoryTree)DirectoryTree.this).aladin.directory.blinkState;
                            }
                        }
                    }
                    icon.setNew(isNew);
                    icon.setMoc(hasMoc);
                    this.nonLeafRenderer.setIcon(icon);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            c.setMinimumSize(new Dimension(150, c.getMinimumSize().height));
            return c;
        }
    }
}

