/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class DelimitedValFieldListener {
    private String delimiter = "";
    public String REGEX_BETWEENINPUT = "([A-Za-z0-9]+)\\s+%1$s\\s+([A-Za-z0-9]+)";
    private String toolTipText = "Format should be as: value1 %1$s value2";
    private boolean isValid = true;

    public DelimitedValFieldListener() {
    }

    public DelimitedValFieldListener(String delimiter) {
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
        this.REGEX_BETWEENINPUT = String.format(this.REGEX_BETWEENINPUT, this.delimiter);
        this.toolTipText = String.format(this.toolTipText, this.delimiter);
    }

    public static boolean andConstraint(JTextField constraint, String checkPattern, String toolTipText) {
        String selectedText = constraint.getText();
        Highlighter highlighter = constraint.getHighlighter();
        Pattern re = Pattern.compile(checkPattern, 2);
        Matcher m = re.matcher(selectedText);
        boolean result = false;
        highlighter.removeAllHighlights();
        if (!m.find()) {
            constraint.setToolTipText(toolTipText);
            DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Aladin.LIGHTORANGE);
            try {
                highlighter.addHighlight(0, selectedText.length(), painter);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
        } else {
            result = true;
            highlighter.removeAllHighlights();
            constraint.setToolTipText("");
        }
        return result;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    class Expr {
        char[] s;
        int pos;

        Expr(String expr) {
            this.s = expr.toCharArray();
            this.pos = 0;
        }

        boolean isEnd() {
            return this.pos >= this.s.length;
        }

        char ch() {
            return this.isEnd() ? (char)'\u0000' : this.s[this.pos];
        }

        String get(int deb, int count) {
            return new String(this.s, deb, count);
        }

        String error() {
            return new String(this.s, 0, this.pos) + " ?? " + new String(this.s, this.pos, this.s.length - this.pos);
        }

        void skipBlank() {
            while (this.pos < this.s.length && Character.isSpaceChar(this.s[this.pos])) {
                ++this.pos;
            }
        }
    }
}

