/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MyListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class Curseur
extends JComponent
implements MouseListener,
MouseMotionListener {
    static final int NO = -1;
    int[] niveaux;
    int currentTriangle;
    boolean flagDrag = false;
    int nbNiveaux = 0;
    Color[] couleurTriangle;
    private MyListener listener;
    final int mX = 10;
    final int mY = 0;
    final int Hp = 0;
    final int W = 276;
    final int H = 24;

    protected Curseur() {
        this.initNiveaux();
        this.initCouleurs();
        this.enableEvents(64L);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.resize(276, 24);
    }

    protected Curseur(MyListener listener) {
        this();
        this.listener = listener;
    }

    private void initCouleurs() {
        this.couleurTriangle = new Color[20];
        for (int i = 0; i < 20; ++i) {
            this.couleurTriangle[i] = Color.black;
        }
    }

    private void initNiveaux() {
        this.niveaux = new int[20];
        this.niveaux[0] = 100;
        this.nbNiveaux = 1;
    }

    @Override
    public Dimension preferredSize() {
        return new Dimension(276, 24);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    protected void drawTriangle(Graphics g, int x, int i) {
        int[] tx = new int[4];
        int[] ty = new int[4];
        tx[0] = tx[3] = x + 10;
        tx[1] = tx[0] - 7;
        tx[2] = tx[0] + 7;
        ty[3] = 4;
        ty[0] = 4;
        ty[1] = ty[2] = ty[0] + 10;
        g.setColor(this.couleurTriangle[i]);
        g.fillPolygon(tx, ty, tx.length);
        g.setColor(Color.black);
        g.drawPolygon(tx, ty, tx.length);
        g.setFont(Aladin.SPLAIN);
        g.drawString("" + x, 10 + x - 7, 24);
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        x -= 10;
        if (this.listener != null) {
            this.listener.fireStateChange(-1);
        }
        this.requestFocus();
        for (int i = 0; i < this.nbNiveaux; ++i) {
            if (x <= this.niveaux[i] - 5 || x >= this.niveaux[i] + 5) continue;
            this.currentTriangle = i;
            return true;
        }
        this.currentTriangle = -1;
        return true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        x -= 10;
        for (int i = 0; i < this.nbNiveaux; ++i) {
            if (x <= this.niveaux[i] - 5 || x >= this.niveaux[i] + 5) continue;
            this.currentTriangle = i;
            if (this.listener != null) {
                this.listener.fireStateChange(this.niveaux[this.currentTriangle]);
            }
            return;
        }
        this.currentTriangle = -1;
        if (this.listener != null) {
            this.listener.fireStateChange(null);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.currentTriangle == -1) {
            return;
        }
        int x = e.getX();
        if ((x -= 10) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        this.niveaux[this.currentTriangle] = x;
        this.flagDrag = false;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentTriangle == -1) {
            return;
        }
        int x = e.getX();
        if ((x -= 10) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        this.niveaux[this.currentTriangle] = x;
        if (this.listener != null) {
            this.listener.fireStateChange(x);
        }
        this.flagDrag = true;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(10, 3, 265, 3);
        g.drawLine(10, 0, 10, 6);
        g.drawLine(265, 0, 265, 6);
        for (int i = 0; i < this.nbNiveaux; ++i) {
            this.drawTriangle(g, this.niveaux[i], i);
        }
    }

    protected boolean addCurseur() {
        if (this.nbNiveaux >= 20) {
            return false;
        }
        this.niveaux[this.nbNiveaux] = 0;
        ++this.nbNiveaux;
        this.repaint();
        return true;
    }

    protected boolean addCurseur(int level) {
        if (this.nbNiveaux >= 20) {
            return false;
        }
        this.niveaux[this.nbNiveaux] = level;
        ++this.nbNiveaux;
        this.repaint();
        return true;
    }

    protected void reset() {
        this.nbNiveaux = 0;
        this.repaint();
    }

    @Override
    public boolean keyDown(Event e, int key) {
        if (this.currentTriangle == -1) {
            return true;
        }
        boolean move = false;
        if (key == 1007) {
            move = true;
            if (this.niveaux[this.currentTriangle] < 255) {
                int n = this.currentTriangle;
                this.niveaux[n] = this.niveaux[n] + 1;
            }
        } else if (key == 1006) {
            move = true;
            if (this.niveaux[this.currentTriangle] > 0) {
                int n = this.currentTriangle;
                this.niveaux[n] = this.niveaux[n] - 1;
            }
        }
        if (move) {
            if (this.listener != null) {
                this.listener.fireStateChange(this.niveaux[this.currentTriangle]);
            }
            this.repaint();
        }
        return true;
    }
}

