/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calque;
import cds.aladin.Command;
import cds.aladin.Console;
import cds.aladin.Glu;
import cds.aladin.Grid;
import cds.aladin.Hdr;
import cds.aladin.Help;
import cds.aladin.IconMatch;
import cds.aladin.IconRedo;
import cds.aladin.IconStudy;
import cds.aladin.Localisation;
import cds.aladin.Logo;
import cds.aladin.Mesure;
import cds.aladin.MyLabel;
import cds.aladin.Northup;
import cds.aladin.Oeil;
import cds.aladin.ProjSelector;
import cds.aladin.Save;
import cds.aladin.Search;
import cds.aladin.ServerDialog;
import cds.aladin.Status;
import cds.aladin.Synchro;
import cds.aladin.Tips;
import cds.aladin.ToolBox;
import cds.aladin.TreeView;
import cds.aladin.View;
import cds.aladin.ViewControl;
import cds.tools.Util;
import java.awt.Color;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public final class CreatObj
implements Runnable {
    Thread thread;
    Aladin a;
    private long t;

    protected CreatObj(Aladin aladin) {
        this.a = aladin;
        this.initTimer();
        this.a.console = new Console(this.a);
        this.a.console.printInfo("Aladin " + "v12.646" + " under JVM " + aladin.javaVersion + " with " + Aladin.MAXMEM + "MB");
        this.trace(1, "Creating Console window");
        this.a.synchroServer = new Synchro(10000L);
        this.a.synchroPlan = new Synchro(60000L);
        this.a.command = new Command(this.a);
        this.trace(1, "Creating Command");
        this.a.vButton = new Vector(10);
        this.a.glu = new Glu(this.a);
        aladin.configuration.proceedLastGlu();
        this.trace(1, "Creating Glu gateway");
        this.a.logo = new Logo(this.a);
        this.a.status = new Status(this.a, Aladin.WELCOME);
        this.a.match = new IconMatch(this.a);
        this.a.look = new IconStudy(this.a);
        this.a.grid = new Grid(this.a);
        this.a.oeil = new Oeil(this.a);
        this.a.csredo = new IconRedo(this.a);
        this.a.northup = new Northup(this.a);
        this.a.pix = new Hdr(this.a);
        this.a.viewControl = new ViewControl(this.a);
        this.trace(1, "Creating View control widget");
        this.a.urlStatus = new Tips(this.a);
        this.a.memStatus = new MyLabel("", 2, Aladin.SPLAIN);
        this.a.memStatus.setForeground(Color.darkGray);
        this.a.mesure = new Mesure(this.a);
        this.a.search = new Search(this.a, true);
        this.trace(1, "Creating Measurement panel");
        this.a.toolBox = new ToolBox(this.a);
        this.a.calque = new Calque(this.a);
        this.trace(1, "Creating Calque object");
        this.a.treeView = new TreeView(this.a);
        this.trace(1, "Creating Treeview window");
        this.a.localisation = new Localisation(this.a);
        this.trace(1, "Creating Localisation widget");
        this.a.projSelector = new ProjSelector(this.a);
        this.trace(1, "Creating projSelector widget");
        this.a.view = new View(this.a, this.a.calque);
        this.trace(1, "Creating Multiview Panel");
        this.a.help = new Help(this.a);
        this.a.save = new Save(this.a);
        this.trace(1, "Creating Save");
        this.a.setMemory();
    }

    private void initTimer() {
        this.t = System.currentTimeMillis();
    }

    private void trace(int n, String s) {
        long t1 = System.currentTimeMillis();
        s = s + " (" + (t1 - this.t) + "ms)";
        this.t = t1;
        Aladin.trace(n, s);
    }

    protected boolean creatLastObj() {
        this.thread = new Thread((Runnable)this, "AladinCreatObj");
        this.thread.start();
        if (Aladin.isApplet()) {
            if (Aladin.extApplet == null) {
                return this.a.getParameter("img") != null || this.a.getParameter("-c") != null || this.a.getParameter("script") != null;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        String script;
        if (Aladin.PLASTIC_SUPPORT) {
            this.a.setPlastic(this.a.plasticPrefs.getBooleanValue("PlasticLaunchHub") && !Aladin.NOHUB);
            Timer timer = new Timer();
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    CreatObj.this.a.setPlastic(false);
                }
            };
            timer.schedule(timerTask, 5000L, 5000L);
        }
        this.initTimer();
        this.a.dialog = new ServerDialog(this.a);
        this.trace(1, "Creating Server window");
        if (Aladin.NOGUI) {
            Localisation cfr_ignored_0 = this.a.localisation;
            this.a.localisation.setFrame(0);
            Localisation cfr_ignored_1 = this.a.localisation;
            Localisation cfr_ignored_2 = this.a.localisation;
            Aladin.trace(3, "Default frame: " + Localisation.getFrameName(0));
        } else {
            this.a.localisation.setFrame(this.a.configuration.getFrame());
            Localisation cfr_ignored_3 = this.a.localisation;
            Aladin.trace(3, "Default frame: " + Localisation.getFrameName(this.a.configuration.getFrame()));
        }
        this.a.searchData.setEnabled(true);
        if (Aladin.BOOKMARKS) {
            this.trace(1, "CreateObj.run(): initializing bookmarks...");
            this.a.bookmarks.init(false);
        }
        if (Aladin.isApplet()) {
            if (Aladin.extApplet == null) {
                this.processParameter();
                return;
            }
        }
        if ((script = this.a.getLaunchScript()).length() <= 0) return;
        Aladin.trace(4, "CreateObj.run(): exec launch script => " + script);
        String s = "";
        this.a.command.execScriptAsStream(script);
        if (!this.a.quitAfterLaunchScript()) return;
        while (this.a.command.hasCommand()) {
            Util.pause(100);
        }
        Aladin.trace(4, "CreateObj.run(): command stream achieved => quit!");
        this.a.quit(s == null ? 0 : 1);
    }

    private String getParam(Hashtable t, String key) {
        return t == null ? this.a.getParameter(key) : (String)t.get(key);
    }

    protected void processParameter() {
        this.processParameter(null);
    }

    protected void processParameter(Hashtable t) {
        boolean rep = false;
        Aladin.trace(1, "Analyzing the parameters...");
        this.a.waitDialog();
        try {
            String script;
            String c;
            StringTokenizer st;
            String load = this.getParam(t, "img");
            if (load != null) {
                Aladin.trace(3, "loading...");
                st = new StringTokenizer(load, ",");
                while (st.hasMoreTokens()) {
                    StringTokenizer st1 = new StringTokenizer(st.nextToken(), " ");
                    try {
                        String adr = st1.nextToken();
                        String label = st1.hasMoreTokens() ? st1.nextToken() : null;
                        String origin = st1.hasMoreTokens() ? st1.nextToken() : null;
                        this.a.dialog.server[ServerDialog.LOCAL].createPlane(null, null, adr, label, origin);
                    }
                    catch (Exception ef) {
                        System.err.print("Cannot build url: " + ef);
                    }
                }
            }
            if ((c = this.getParam(t, "-c")) != null) {
                this.a.setBannerWait();
                String rm = this.getParam(t, "-rm");
                String servers = this.getParam(t, "-server");
                String source = this.getParam(t, "-source");
                String qualifier = this.getParam(t, "-aladin.qualifier");
                String resol = this.getParam(t, "-aladin.resolution");
                String fmt = this.getParam(t, "-aladin.format");
                String fov = this.getParam(t, "-fov");
                if (servers == null) {
                    servers = "Aladin";
                }
                if (resol == null) {
                    resol = "FULL";
                }
                if (fmt == null) {
                    fmt = "JPEG";
                }
                st = new StringTokenizer(servers, ",");
                while (st.hasMoreTokens()) {
                    try {
                        String server = st.nextToken();
                        if (server.indexOf("Aladin") >= 0) {
                            String criteria = fmt + " " + resol;
                            if (qualifier != null) {
                                criteria = criteria + " " + qualifier;
                            }
                            this.a.dialog.server[ServerDialog.ALADIN].createPlane(c, rm, criteria, null, null);
                        }
                        if (server.indexOf("VizieR") >= 0 && source != null) {
                            this.a.dialog.server[ServerDialog.VIZIER].createPlane(c, rm, source, null, null);
                        }
                        if (server.indexOf("Simbad") >= 0) {
                            this.a.dialog.server[ServerDialog.SIMBAD].createPlane(c, rm, null, null, null);
                        }
                        if (server.indexOf("NED") < 0) continue;
                        this.a.dialog.server[ServerDialog.NED].createPlane(c, rm, null, null, null);
                    }
                    catch (Exception e1) {
                        System.out.println("Pb: " + e1);
                        e1.printStackTrace();
                    }
                }
                st = new StringTokenizer(fov, ",");
                while (st.hasMoreTokens()) {
                    this.a.dialog.server[ServerDialog.FIELD].createPlane(c, null, st.nextToken(), null, null);
                }
            }
            if ((script = this.getParam(t, "script")) == null) {
                script = this.getParam(t, "-script");
            }
            if (script != null) {
                this.a.setBannerWait();
                this.a.command.execScriptAsStream(script);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

