/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Couleur;
import cds.aladin.Tok;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class CouleurBox
extends JPanel
implements MouseListener,
ActionListener {
    private Color defaultCouleur;
    private Color couleur;
    private int size;
    private FrameCouleur frameCouleur = null;
    private ActionListener actionListener;

    protected CouleurBox(Color defaultCouleur, Color couleur) {
        this(defaultCouleur, couleur, 18);
    }

    protected CouleurBox(Color defaultCouleur, Color couleur, int size) {
        this.defaultCouleur = defaultCouleur;
        this.couleur = couleur;
        this.size = size;
        this.addMouseListener(this);
    }

    protected Color getColor() {
        return this.couleur;
    }

    protected void setColor(Color c) {
        this.couleur = c;
    }

    protected String getCouleur() {
        if (this.couleur == null) {
            return null;
        }
        return "RGB(" + this.couleur.getRed() + "," + this.couleur.getGreen() + "," + this.couleur.getBlue() + ")";
    }

    protected static Color getCouleur(String rgb) throws Exception {
        Tok tok = new Tok(rgb, "(, )");
        tok.nextToken();
        int r = Integer.parseInt(tok.nextToken());
        int g = Integer.parseInt(tok.nextToken());
        int b = Integer.parseInt(tok.nextToken());
        return new Color(r, g, b);
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = l;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.couleur == null ? this.defaultCouleur : this.couleur);
        g.fillRect(0, 0, this.size, this.size);
        g.setColor(Color.gray);
        g.drawRect(0, 0, this.size, this.size);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.frameCouleur == null) {
            this.frameCouleur = new FrameCouleur(this);
        } else {
            this.frameCouleur.setCouleur(this.couleur);
        }
        Point p = e.getLocationOnScreen();
        this.frameCouleur.setLocation(p.x + e.getX(), p.y + e.getY() - 20);
        this.frameCouleur.setVisible(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void hideFrame() {
        if (this.frameCouleur != null) {
            this.frameCouleur.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.frameCouleur.setVisible(false);
        this.couleur = this.frameCouleur.getCouleur();
        this.repaint();
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.couleur + ""));
        }
    }

    private class FrameCouleur
    extends JFrame {
        Couleur selecteurCouleur;

        FrameCouleur(CouleurBox cb) {
            this.setDefaultCloseOperation(3);
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout(5, 5));
            contentPane.setBackground(new Color(240, 240, 250));
            contentPane.setBorder(BorderFactory.createLineBorder(Color.black));
            this.setUndecorated(true);
            MyPanel panel = new MyPanel();
            this.selecteurCouleur = new Couleur(cb.couleur);
            this.selecteurCouleur.setNoColorFlag(true);
            this.selecteurCouleur.addActionListener(cb);
            panel.add(this.selecteurCouleur);
            contentPane.add((Component)panel, "Center");
            this.pack();
        }

        void setCouleur(Color c) {
            this.selecteurCouleur.setCouleur(c);
        }

        Color getCouleur() {
            return this.selecteurCouleur.getCouleur();
        }
    }

    private class MyPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final int W = 6;
        Rectangle cross = null;
        boolean in;

        MyPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(7, 7, 3, 7));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.drawCross(g, this.getWidth() - 6 - 3, 2);
        }

        private void drawCross(Graphics g, int x, int y) {
            g.setColor(this.in ? Color.red : Color.gray);
            g.drawLine(x, y, x + 6, y + 6);
            g.drawLine(x + 1, y, x + 6 + 1, y + 6);
            g.drawLine(x + 2, y, x + 6 + 2, y + 6);
            g.drawLine(x + 6, y, x, y + 6);
            g.drawLine(x + 6 + 1, y, x + 1, y + 6);
            g.drawLine(x + 6 + 2, y, x + 2, y + 6);
            this.cross = new Rectangle(x, y - 2, 8, 8);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.in) {
                CouleurBox.this.hideFrame();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean in1 = this.cross.contains(e.getPoint());
            if (in1 != this.in) {
                this.repaint();
            }
            this.in = in1;
        }
    }
}

