/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.PlanContour;
import cds.aladin.PointD;

public abstract class ContourAlgorithm {
    protected PlanContour pc;
    protected int width;
    protected int height;
    protected double level;
    protected short[] data;

    ContourAlgorithm(short[] pixels, int width, int height, double level) {
        this();
        this.level = level;
        this.width = width;
        this.height = height;
        this.data = pixels;
    }

    ContourAlgorithm() {
    }

    protected abstract PointD[] getContours();

    protected void setLevel(double level) {
        this.level = level;
    }

    protected void setData(short[] pix) {
        this.data = pix;
    }

    protected void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected static PointD[] cleanContours(PointD[] tab) {
        if (tab.length == 0) {
            return tab;
        }
        PointD[] retTab = new PointD[tab.length];
        int indexOrg = 0;
        int indexRet = 0;
        int i1 = 0;
        int i2 = 1;
        int i3 = 2;
        boolean fin = false;
        while (!fin) {
            PointD p1;
            if (i3 >= tab.length) {
                fin = true;
            }
            retTab[indexRet] = p1 = tab[i1];
            indexOrg = ContourAlgorithm.testPoints(i1, tab);
            retTab[++indexRet] = tab[indexOrg];
            ++indexRet;
            i1 = indexOrg + 1;
            i2 = i1 + 1;
            i3 = i2 + 1;
            if (i3 < tab.length) continue;
            fin = true;
        }
        PointD[] tmp = new PointD[indexRet + 1];
        System.arraycopy(retTab, 0, tmp, 0, indexRet + 1);
        return tmp;
    }

    private static int testPoints(int i1, PointD[] tab) {
        int i2 = i1 + 1;
        int i3 = i2 + 1;
        boolean fin = false;
        int type = -1;
        while (!fin) {
            if (i3 >= tab.length) {
                fin = true;
                continue;
            }
            PointD p1 = tab[i1];
            PointD p2 = tab[i2];
            PointD p3 = tab[i3];
            if (p1 == null || p2 == null || p3 == null) {
                fin = true;
                continue;
            }
            if (p1.x == p2.x && p2.x == p3.x && (type == 0 || type == -1)) {
                type = 0;
                ++i2;
                ++i3;
                continue;
            }
            if (p1.y == p2.y && p2.y == p3.y && (type == 1 || type == -1)) {
                type = 1;
                ++i2;
                ++i3;
                continue;
            }
            if (p2.x - p1.x == p3.x - p2.x && p2.y - p1.y == p3.y - p2.y && (type == 2 || type == -1)) {
                type = 2;
                ++i2;
                ++i3;
                continue;
            }
            fin = true;
        }
        return i2;
    }
}

