/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CustomListCellRenderer;
import cds.aladin.DelimitedValFieldListener;
import cds.aladin.Server;
import cds.aladin.ServerTap;
import cds.aladin.TapClient;
import cds.aladin.TapTableColumn;
import cds.aladin.WhereGridConstraint;
import cds.tools.Util;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public class ColumnConstraint
extends WhereGridConstraint
implements ItemListener {
    private static final long serialVersionUID = 1L;
    public static final String BETWEEN = "BETWEEN";
    public static final String NOTBETWEEN = "NOT BETWEEN";
    public static final String REGEX_BETWEENINPUT = "(?<range1>[A-Za-z0-9]+)\\s+and\\s+(?<range1>[A-Za-z0-9]+)";
    private static final String toolTipText = "Format should be as: value1 AND value2";
    protected static final String[] charOperators = new String[]{"=", "!=", "IS NULL", "IS NOT NULL", "LIKE", "NOT LIKE"};
    protected static final String[] numOperators = new String[]{"=", "!=", "<", ">", "<=", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"};
    public static final String FORMATFORBETWEEN = Aladin.chaine.getString("FORMATFORBETWEEN");
    public static final String FORMATFORBETWEENTOOLTIP = Aladin.chaine.getString("FORMATFORBETWEENTOOLTIP");
    public static final String INCORRECTCONSTRAINTVALUE = Aladin.chaine.getString("INCORRECTCONSTRAINTVALUE");

    public ColumnConstraint(ServerTap serverTap, Vector columnNames) {
        super(serverTap, new JComboBox(columnNames), new JComboBox<String>(operators), new JTextField(14));
        JComboBox columns = (JComboBox)this.firstGridComponent;
        columns.setRenderer(new CustomListCellRenderer(serverTap));
        columns.setSize(columns.getWidth(), Server.HAUT);
        this.setWhereOperators();
        columns.addItemListener(this);
        ((JTextField)this.thirdGridComponent).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ColumnConstraint.this.processInput((JTextField)e.getSource());
                ColumnConstraint.this.itemStateChanged(null);
            }
        });
        ((JComboBox)this.firstGridComponent).addItemListener(this);
        ((JComboBox)this.secondGridComponent).addItemListener(this);
    }

    public void processInput(JTextField constraint) {
        ColumnConstraint columnConstraintPanel = (ColumnConstraint)constraint.getParent();
        String selectedWhereOperator = (String)((JComboBox)columnConstraintPanel.secondGridComponent).getSelectedItem();
        if (selectedWhereOperator.equals(BETWEEN) || selectedWhereOperator.equals(NOTBETWEEN)) {
            DelimitedValFieldListener.andConstraint(constraint, "^(?<range1>.*){1}\\s*(?<operator>\\.\\.|,|and|AND|\\s+){1}\\s*(?<range2>.*{1}){1}\\s*$", toolTipText);
        }
    }

    @Override
    public String getAdqlString() throws Exception {
        StringBuffer whereClause = new StringBuffer();
        if (this.andOrOperator != null) {
            whereClause.append(this.andOrOperator.getSelectedItem()).append(" ");
        }
        JComboBox columns = (JComboBox)this.firstGridComponent;
        JComboBox whereOperator = (JComboBox)this.secondGridComponent;
        JTextField constraintValue = (JTextField)this.thirdGridComponent;
        String selectedWhereOperator = (String)whereOperator.getSelectedItem();
        TapTableColumn column = (TapTableColumn)columns.getSelectedItem();
        String alias = null;
        String columnName = column.getColumnNameForQuery();
        alias = this.serverTap.getRelevantAlias(column);
        if (alias != null) {
            whereClause.append(alias).append(".");
        }
        whereClause.append(columnName).append(" ");
        if (selectedWhereOperator.equals("IS NULL")) {
            whereClause.append(selectedWhereOperator).append(" ");
        } else if (constraintValue.getText().isEmpty()) {
            whereClause.append("IS NOT NULL").append(" ");
        } else if (selectedWhereOperator.equals(BETWEEN) || selectedWhereOperator.equals(NOTBETWEEN)) {
            String selectedText = constraintValue.getText();
            Highlighter highlighter = constraintValue.getHighlighter();
            String processedInput = TapClient.getRangeInput(selectedText, null);
            if (processedInput.isEmpty()) {
                block13: {
                    Aladin.trace(3, "No 'AND' used for the between operator!");
                    constraintValue.setToolTipText(FORMATFORBETWEENTOOLTIP);
                    DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Aladin.LIGHTORANGE);
                    try {
                        highlighter.addHighlight(0, selectedText.length(), painter);
                    }
                    catch (BadLocationException e1) {
                        if (Aladin.levelTrace < 3) break block13;
                        e1.printStackTrace();
                    }
                }
                throw new Exception("Error for column contraint: " + columnName + ". \n" + FORMATFORBETWEEN);
            }
            whereClause.append(processedInput);
        } else {
            Pattern pattern;
            Matcher matcher;
            String dataType = column.getDatatype();
            boolean considerAsString = true;
            if (dataType != null && !dataType.toUpperCase().contains("VARCHAR") && !dataType.toUpperCase().contains("CHAR")) {
                considerAsString = false;
            }
            if (!considerAsString && !(matcher = (pattern = Pattern.compile("\\A\\s*([-+]?\\d+(\\.\\d+)?([eE]{1}[-+]?\\d+)?){1}\\s*\\z")).matcher(constraintValue.getText())).find()) {
                throw new Exception(INCORRECTCONSTRAINTVALUE);
            }
            whereClause.append(whereOperator.getSelectedItem()).append(" ").append(Util.formatterPourRequete(considerAsString, constraintValue.getText())).append(" ");
        }
        return whereClause.toString();
    }

    public TapTableColumn getSelectedItem() {
        return (TapTableColumn)((JComboBox)this.firstGridComponent).getSelectedItem();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() instanceof JTextField) {
            // empty if block
        }
    }

    public void setWhereOperators() {
        JComboBox columns = (JComboBox)this.firstGridComponent;
        JComboBox whereOperator = (JComboBox)this.secondGridComponent;
        TapTableColumn column = (TapTableColumn)columns.getSelectedItem();
        String dataType = column.getDatatype();
        if (column.isNumeric()) {
            whereOperator.removeAllItems();
            DefaultComboBoxModel<String> items = new DefaultComboBoxModel<String>(numOperators);
            whereOperator.setModel(items);
        } else {
            whereOperator.removeAllItems();
            DefaultComboBoxModel<String> items = new DefaultComboBoxModel<String>(charOperators);
            whereOperator.setModel(items);
        }
        this.setIsNullGui();
    }

    public void setIsNullGui() {
        JComboBox whereOperator = (JComboBox)this.secondGridComponent;
        JTextField constraintValue = (JTextField)this.thirdGridComponent;
        if (whereOperator.getSelectedItem() != null && (whereOperator.getSelectedItem().equals("IS NULL") || whereOperator.getSelectedItem().equals("IS NOT NULL"))) {
            constraintValue.setText("");
            constraintValue.setEnabled(false);
        } else {
            constraintValue.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e != null && e.getSource().equals(this.firstGridComponent)) {
            this.setWhereOperators();
        } else {
            this.setIsNullGui();
        }
        this.serverTap.writeQuery();
    }

    public void setWhereModel(Vector<TapTableColumn> displayColumns, TapTableColumn selectedItem) {
        DefaultComboBoxModel<TapTableColumn> model = new DefaultComboBoxModel<TapTableColumn>(displayColumns);
        JComboBox columns = (JComboBox)this.firstGridComponent;
        columns.setModel(model);
        columns.setSelectedItem(selectedItem);
    }
}

