/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameColorMap;
import cds.aladin.PlanHips;
import cds.aladin.PlanImage;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public final class CanvasPixelRange
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final int MX = 5;
    private static final int MY = 5;
    private static final int MINIMUM_HEIGHT = 65;
    private static final int H_HAMPE = 3;
    private static final int COLORMAP_POSX_CUTMIN = 39;
    private static final int COLORMAP_POSX_CUTMAX = 295;
    private FrameColorMap frameColorMap;
    private Color BKGD = null;
    private PlanImage pimg;
    private boolean isFullDynamic;
    private boolean isFitsHiPS;
    private int width;
    private int height;
    private Rectangle rectRange;
    private Rectangle rectVisible;
    private double sizeOnePixel;
    private double pixelRangeMin;
    private double pixelRangeMax;
    private double pixelCutMin;
    private double pixelCutMax;
    private int xStart = -1;
    private int xMove;
    private int mode = 0;
    private static final int IN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private int oM = -1;

    protected CanvasPixelRange(FrameColorMap frameColorMap, PlanImage pimg) {
        this.frameColorMap = frameColorMap;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.pimg = pimg;
        this.BKGD = pimg.aladin.frameCM.getBackground();
        this.rectRange = new Rectangle();
        this.rectVisible = new Rectangle();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        return new Dimension(dim.width, 65);
    }

    protected void resume() {
        double range;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.pimg == null) {
            return;
        }
        this.isFullDynamic = this.pimg.hasAvailablePixels();
        this.isFitsHiPS = this.pimg instanceof PlanHips && ((PlanHips)this.pimg).isTruePixels();
        this.rectRange.x = 5;
        this.rectRange.y = 20;
        this.rectRange.width = this.width - 10;
        this.rectRange.height = 17;
        if (this.isFitsHiPS) {
            this.rectRange.x += 20;
            this.rectRange.width -= 40;
        }
        if (this.isFullDynamic) {
            this.pixelRangeMin = this.pimg.uncompressPixel(this.pimg.dataMin);
            this.pixelRangeMax = this.pimg.uncompressPixel(this.pimg.dataMax);
            this.pixelCutMin = this.pimg.uncompressPixel(this.pimg.pixelMin);
            this.pixelCutMax = this.pimg.uncompressPixel(this.pimg.pixelMax);
            if (this.pixelCutMin < this.pixelRangeMin) {
                this.pixelRangeMin = this.pixelCutMin;
            }
            if (this.pixelCutMax > this.pixelRangeMax) {
                this.pixelRangeMax = this.pixelCutMax;
            }
        } else {
            this.pixelRangeMax = 0.0;
            this.pixelRangeMin = 0.0;
            this.pixelCutMin = this.rectRange.width / 4;
            this.pixelCutMax = 2 * this.rectRange.width / 3;
        }
        this.sizeOnePixel = (range = this.pixelRangeMax - this.pixelRangeMin) <= 0.0 ? 1.0 : (double)this.rectRange.width / range;
        this.rectVisible.x = (int)((double)this.rectRange.x + (this.pixelCutMin - this.pixelRangeMin) * this.sizeOnePixel);
        this.rectVisible.y = this.rectRange.y + 1;
        this.rectVisible.width = (int)((this.pixelCutMax - this.pixelCutMin) * this.sizeOnePixel);
        this.rectVisible.height = this.rectRange.height - 2;
        if (this.mode != 0) {
            int delta = this.xMove - this.xStart;
            switch (this.mode) {
                case 1: {
                    this.rectVisible.x += delta;
                    break;
                }
                case 2: {
                    this.rectVisible.x += delta;
                    this.rectVisible.width -= delta;
                    break;
                }
                case 3: {
                    this.rectVisible.width += delta;
                }
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int x;
        int y;
        super.paintComponent(g);
        FontMetrics fm = g.getFontMetrics();
        this.resume();
        g.setColor(this.BKGD);
        g.fillRect(0, 0, this.width, this.height);
        if (this.pimg == null) {
            return;
        }
        g.setColor(this.frameColorMap.cm.getColor(0));
        g.fillRect(this.rectRange.x, this.rectRange.y, this.rectVisible.x - this.rectRange.x, this.rectRange.height);
        g.setColor(this.frameColorMap.cm.getColor(255));
        g.fillRect(this.rectVisible.x + this.rectVisible.width, this.rectRange.y, this.rectRange.x + this.rectRange.width - this.rectVisible.x - this.rectVisible.width, this.rectRange.height);
        g.setColor(this.pimg.hasAvailablePixels() ? Color.cyan : Color.lightGray);
        g.fillRect(this.rectVisible.x, this.rectVisible.y, this.rectVisible.width, this.rectVisible.height);
        g.drawRect(this.rectVisible.x, this.rectVisible.y, this.rectVisible.width, this.rectVisible.height);
        g.setColor(Color.black);
        g.drawRect(this.rectRange.x, this.rectRange.y, this.rectRange.width, this.rectRange.height);
        if (this.isFitsHiPS) {
            int i;
            y = this.rectRange.y + this.rectRange.height / 2;
            x = this.rectRange.x - 5;
            for (i = 0; i < 3; ++i) {
                Util.fillCircle2(g, x - i * 5, y);
            }
            x = this.rectRange.x + this.rectRange.width + 3;
            for (i = 0; i < 3; ++i) {
                Util.fillCircle2(g, x + i * 5, y);
            }
        }
        g.setColor(Color.lightGray);
        int a = this.rectVisible.x;
        int b = this.rectVisible.y + this.rectVisible.height + 3;
        g.drawLine(a, b, a, b + 3);
        g.drawLine(a, b + 3, 39, this.height - 3);
        g.drawLine(39, this.height - 3, 39, this.height);
        a = this.rectVisible.x + this.rectVisible.width;
        b = this.rectVisible.y + this.rectVisible.height + 3;
        g.drawLine(a, b, a, b + 3);
        g.drawLine(a, b + 3, 295, this.height - 3);
        g.drawLine(295, this.height - 3, 295, this.height);
        g.setColor(Color.black);
        y = this.rectRange.y - 2;
        String s = !this.isFullDynamic ? "???" : Util.myRound(this.pixelRangeMin);
        g.drawString(s, this.rectRange.x, y);
        s = !this.isFullDynamic ? "???" : Util.myRound(this.pixelRangeMax);
        int ws = fm.stringWidth(s);
        g.drawString(s, this.rectRange.x + this.rectRange.width + 2 - ws, y);
        g.setColor(Aladin.MYBLUE);
        s = this.isFullDynamic ? this.frameColorMap.CMRANGE : this.frameColorMap.CMRANGE1;
        ws = fm.stringWidth(s);
        x = this.rectRange.x + this.rectRange.width / 2 - ws / 2;
        y = this.rectRange.y - 3;
        g.drawString(s, x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.mode = this.getMode(x, y);
        if (this.mode != 0) {
            this.xStart = x;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.pimg.hasAvailablePixels()) {
            return;
        }
        this.xMove = e.getX();
        this.resume();
        double myPixelCutMin = this.pixelRangeMin + (double)(this.rectVisible.x - this.rectRange.x) / this.sizeOnePixel;
        double myPixelCutMax = myPixelCutMin + (double)this.rectVisible.width / this.sizeOnePixel;
        this.frameColorMap.setMinMax(myPixelCutMin, myPixelCutMax, true);
        this.xStart = -1;
        this.mode = 0;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.pimg.hasAvailablePixels()) {
            return;
        }
        this.xMove = e.getX();
        this.resume();
        double myPixelCutMin = this.pixelRangeMin + (double)this.rectVisible.x / this.sizeOnePixel;
        double myPixelCutMax = (double)(this.rectVisible.x + this.rectVisible.width) / this.sizeOnePixel;
        this.frameColorMap.setMinMax(myPixelCutMin, myPixelCutMax, false);
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int m = this.getMode(e.getX(), e.getY());
        if (this.oM == m || m == 0) {
            return;
        }
        switch (m) {
            case 1: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 2: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case 3: {
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            default: {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        this.oM = m;
    }

    private int getMode(int x, int y) {
        if (!this.pimg.hasAvailablePixels()) {
            return 0;
        }
        int mode = 0;
        if (y > this.rectVisible.y && y < this.rectVisible.y + this.rectVisible.height) {
            if (Math.abs(x - this.rectVisible.x) < 4) {
                mode = 2;
            } else if (Math.abs(x - (this.rectVisible.x + this.rectVisible.width)) < 4) {
                mode = 3;
            } else if (this.rectVisible.contains(x, y)) {
                mode = 1;
            }
        }
        return mode;
    }
}

