/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameColorMap;
import cds.aladin.MyColorMap;
import cds.aladin.PlanHips;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageRGB;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public final class CanvasColorMap
extends JPanel
implements MouseMotionListener,
MouseListener,
KeyListener {
    private static final int MIN = 0;
    private static final int MIL = 1;
    private static final int MAX = 2;
    private static final int NO = 3;
    private static final int SIZEBAND = 16;
    private static final int mX = 5;
    private static final int mY = 0;
    protected static final int Hp = 120;
    private static final int cmH = 25;
    private static final int cmY = 155;
    private static final int W = 271;
    private static final int H = 180;
    private static final int[] Y = new int[]{120, 120, 60, 1, 1};
    private static final int[] Yr = new int[]{1, 1, 60, 120, 120};
    protected PlanImage pimg;
    private boolean isPlanImageRGB = false;
    private boolean isPlanBGRGB = false;
    private int currentTriangle = 3;
    protected int[] triangle = new int[3];
    private Image imgHist = null;
    private Graphics gHist = null;
    private int greyLevel = -1;
    private boolean isDragging = false;
    private boolean flagLosange = false;
    private static Vector customCM;
    protected static Vector customCMName;
    int rgb = -1;
    private static final int[] SR;
    private static final int[] SG;
    private static final int[] SB;
    protected static final int[] RAINBOW_R;
    protected static final int[] RAINBOW_G;
    protected static final int[] RAINBOW_B;
    private static final int[] EOSB_R;
    private static final int[] EOSB_G;
    private static final int[] EOSB_B;
    private static final int[] FIRE_R;
    private static final int[] FIRE_G;
    private static final int[] FIRE_B;
    private static final int[] CUBEHELIX_R;
    private static final int[] CUBEHELIX_G;
    private static final int[] CUBEHELIX_B;
    private Color BKGD = null;
    protected FrameColorMap frameColorMap;
    private CanvasColorMap cm1 = null;
    private CanvasColorMap cm2 = null;
    static byte[] r;
    static byte[] g;
    static byte[] b;
    static final int LAST_DEFAULT_CM_IDX = 6;
    private static byte[] rb;
    private static byte[] gb;
    private static byte[] bb;
    private static int minb;
    private static int maxb;
    private static final Dimension DIM;
    private static final Dimension DIMRGB;
    static int ogreyLevel;
    boolean flagCMBand = false;
    private int oy = -1;
    private int trMin = 0;
    private int trMax = 0;
    private int[] t = new int[3];
    private long lastHistID = -1L;

    protected CanvasColorMap(FrameColorMap parent, PlanImage pimg) {
        this(parent, pimg, -1);
    }

    protected CanvasColorMap(FrameColorMap parent, PlanImage pimg, int color) {
        this.frameColorMap = parent;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.pimg = pimg;
        this.isPlanImageRGB = pimg instanceof PlanImageRGB;
        this.isPlanBGRGB = pimg instanceof PlanHips && ((PlanHips)pimg).isColored();
        this.BKGD = pimg.aladin.frameCM.getBackground();
        if (this.isPlanImageRGB) {
            for (int i = 0; i < 3; ++i) {
                this.triangle[i] = ((PlanImageRGB)pimg).RGBControl[color * 3 + i];
            }
        } else if (this.isPlanBGRGB) {
            for (int i = 0; i < 3; ++i) {
                this.triangle[i] = ((PlanHips)pimg).RGBControl[color * 3 + i];
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                this.triangle[i] = pimg.cmControl[i];
            }
        }
        this.rgb = color;
    }

    protected void setOtherColorMap(CanvasColorMap cm1, CanvasColorMap cm2) {
        this.cm1 = cm1;
        this.cm2 = cm2;
    }

    public static String[] getCMList() {
        String[] res = new String[FrameColorMap.CM.length + (customCMName == null ? 0 : customCMName.size())];
        for (int i = 0; i < FrameColorMap.CM.length; ++i) {
            res[i] = FrameColorMap.CM[i];
        }
        if (customCMName != null) {
            Enumeration e = customCMName.elements();
            while (e.hasMoreElements()) {
                res[i++] = (String)e.nextElement();
            }
        }
        return res;
    }

    public static String getCMName(int i) {
        return CanvasColorMap.getCMList()[i];
    }

    protected void reset() {
        this.triangle[0] = 0;
        this.triangle[1] = 128;
        this.triangle[2] = 255;
        this.repaint();
    }

    protected IndexColorModel getCM() {
        this.flagCMBand = false;
        return CanvasColorMap.getCM(this.triangle[0], this.triangle[1], this.triangle[2], this.pimg.video == 1, this.pimg.typeCM, this.pimg.getTransfertFct(), this.pimg.isTransparent());
    }

    static void interpolPalette(int[] Sr, int[] Sg, int[] Sb, boolean inverse, boolean transp, int tr0, int tr1, int tr2, int fct) {
        int gap = transp ? 1 : 0;
        double range = 256 - gap;
        double mid = range / 2.0;
        double pas1 = mid / (double)(tr1 - tr0);
        double pas2 = mid / (double)(tr2 - tr1);
        int max = (int)range - 1;
        int[] fctGap = CanvasColorMap.computeTransfertFct(fct, transp);
        int i = 0;
        while ((double)i < range) {
            int j = i < tr0 ? 0 : (i < tr1 ? (int)Math.round((double)(i - tr0) * pas1) : (i < tr2 ? (int)Math.round(mid + (double)(i - tr1) * pas2) : max));
            if ((j = fctGap[j]) >= Sr.length) {
                j = Sr.length - 1;
            } else if (j < 0) {
                j = 0;
            }
            if (inverse) {
                j = Sr.length - j - 1;
            }
            CanvasColorMap.r[i + gap] = (byte)(0xFF & Sr[j]);
            CanvasColorMap.g[i + gap] = (byte)(0xFF & Sg[j]);
            CanvasColorMap.b[i + gap] = (byte)(0xFF & Sb[j]);
            ++i;
        }
    }

    public static IndexColorModel getRainbowCM(boolean transp) {
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        for (int i = 0; i < 256; ++i) {
            red[i] = (byte)(0xFF & RAINBOW_R[i]);
            green[i] = (byte)(0xFF & RAINBOW_G[i]);
            blue[i] = (byte)(0xFF & RAINBOW_B[i]);
        }
        return transp ? new IndexColorModel(8, 256, red, green, blue, 0) : new IndexColorModel(8, 256, red, green, blue);
    }

    private static int getRBandColor(int x) {
        return 255 - Math.abs(x - (maxb + minb) / 2) * 10;
    }

    public static ColorModel getCMBand(int greyLevel, boolean inverse, boolean background, boolean transp) {
        return CanvasColorMap.getCMBand(greyLevel - 16, greyLevel + 16, inverse, background, transp);
    }

    private static IndexColorModel getCMBand(int min, int max, boolean inverse, boolean background, boolean transp) {
        minb = min;
        maxb = max;
        int milieu = (min + max) / 2;
        for (int i = 0; i < 256; ++i) {
            if (i < min || i > max) {
                CanvasColorMap.gb[i] = CanvasColorMap.bb[i] = (byte)(!background ? (inverse ? 255 : 0) : (inverse ? 255 - i : i));
                CanvasColorMap.rb[i] = CanvasColorMap.bb[i];
                continue;
            }
            if (i == milieu) {
                CanvasColorMap.rb[i] = -1;
                CanvasColorMap.bb[i] = 0;
                CanvasColorMap.gb[i] = 0;
                continue;
            }
            byte c = (byte)CanvasColorMap.getRBandColor(i);
            CanvasColorMap.rb[i] = 0;
            CanvasColorMap.gb[i] = c;
            CanvasColorMap.bb[i] = c;
        }
        return transp ? new IndexColorModel(8, 256, rb, gb, bb, 0) : new IndexColorModel(8, 256, rb, gb, bb);
    }

    public static IndexColorModel getCM(int tr0, int tr1, int tr2, boolean inverse, int typeCM, int fct) {
        return CanvasColorMap.getCM(tr0, tr1, tr2, inverse, typeCM, fct, false);
    }

    public static IndexColorModel getCM(int tr0, int tr1, int tr2, boolean inverse, int typeCM, int fct, boolean transp) {
        int[] rd = new int[256];
        int[] gn = new int[256];
        int[] bl = new int[256];
        if (typeCM == 1) {
            for (int i = 0; i < 256; ++i) {
                rd[i] = i << 1;
                if (rd[i] > 255) {
                    rd[i] = 255;
                }
                gn[i] = i - 64 << 1;
                if (gn[i] < 0) {
                    gn[i] = 0;
                } else if (gn[i] > 255) {
                    gn[i] = 255;
                }
                bl[i] = i - 128 << 1;
                if (bl[i] >= 0) continue;
                bl[i] = 0;
            }
            CanvasColorMap.interpolPalette(rd, gn, bl, inverse, transp, tr0, tr1, tr2, fct);
        } else if (typeCM == 2) {
            for (int i = 0; i < 256; ++i) {
                rd[i] = i;
            }
            CanvasColorMap.interpolPalette(rd, gn, bl, inverse, transp, tr0, tr1, tr2, fct);
        } else if (typeCM == 3) {
            for (int i = 0; i < 256; ++i) {
                gn[i] = i;
            }
            CanvasColorMap.interpolPalette(rd, gn, bl, inverse, transp, tr0, tr1, tr2, fct);
        } else if (typeCM == 4) {
            for (int i = 0; i < 256; ++i) {
                bl[i] = i;
            }
            CanvasColorMap.interpolPalette(rd, gn, bl, inverse, transp, tr0, tr1, tr2, fct);
        } else if (typeCM == 5) {
            for (int i = 0; i < 256; ++i) {
                int n = i < 64 ? 0 : (rd[i] = i < 128 ? i - 64 << 2 : 255);
                int n2 = i < 64 ? i << 2 : (i < 128 ? 255 - (i - 64 << 2) : (gn[i] = i < 192 ? 0 : i - 192 << 2));
                bl[i] = i < 32 ? 0 : (i < 128 ? (i - 32 << 3) / 3 : (i < 192 ? 255 - (i - 128 << 2) : 0));
            }
            CanvasColorMap.interpolPalette(rd, gn, bl, inverse, transp, tr0, tr1, tr2, fct);
        } else if (typeCM == 6) {
            CanvasColorMap.interpolPalette(SR, SG, SB, !inverse, transp, tr0, tr1, tr2, fct);
        } else if (typeCM > 6) {
            int idx = typeCM - 6 - 1;
            MyColorMap myCM = (MyColorMap)customCM.elementAt(idx);
            CanvasColorMap.interpolPalette(myCM.getRed(), myCM.getGreen(), myCM.getBlue(), !inverse, transp, tr0, tr1, tr2, fct);
        } else {
            for (int i = 0; i < 256; ++i) {
                gn[i] = bl[i] = i;
                rd[i] = bl[i];
            }
            CanvasColorMap.interpolPalette(rd, gn, bl, inverse, transp, tr0, tr1, tr2, fct);
        }
        return transp ? new IndexColorModel(8, 256, r, g, b, 0) : new IndexColorModel(8, 256, r, g, b);
    }

    private static int[] computeTransfertFct(int fct, boolean transp) {
        double v;
        int range = transp ? 255 : 256;
        int[] r = new int[range];
        if (fct == 3) {
            for (int i = 0; i < range; ++i) {
                r[i] = i;
            }
            return r;
        }
        double[] val = new double[range];
        double min = Double.MAX_VALUE;
        double max = -min;
        for (int i = 0; i < range; ++i) {
            v = i;
            switch (fct) {
                case 0: {
                    val[i] = v = Math.log(v + Math.sqrt(Math.pow(v, 2.0) + 1.0));
                    break;
                }
                case 1: {
                    val[i] = v = Math.log(v / 10.0 + 1.0);
                    break;
                }
                case 2: {
                    val[i] = v = Math.sqrt(v / 10.0);
                    break;
                }
                case 4: {
                    v *= v;
                    val[i] = v;
                }
            }
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        double x = (double)range / (max - min);
        for (int i = 0; i < range; ++i) {
            v = x * val[i] - min;
            if (v >= (double)range) {
                v = range - 1;
            } else if (v < 0.0) {
                v = 0.0;
            }
            r[i] = (int)v;
            if (!transp || r[i] != 0) continue;
            r[i] = 1;
        }
        return r;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.isPlanBGRGB || this.isPlanImageRGB ? DIMRGB : DIM;
    }

    protected void drawTriangle(Graphics g, int x) {
        int[] tx = new int[4];
        int[] ty = new int[4];
        tx[0] = tx[3] = x + 5;
        tx[1] = tx[0] - 7;
        tx[2] = tx[0] + 7;
        ty[3] = 124;
        ty[0] = 124;
        ty[1] = ty[2] = ty[0] + 10;
        g.fillPolygon(tx, ty, tx.length);
    }

    protected void ajustTriangle() {
        int i;
        for (i = 0; i < 2; ++i) {
            if (this.triangle[i] <= this.triangle[i + 1] - 5) continue;
            this.triangle[i] = this.triangle[i + 1] - 5;
        }
        for (i = 2; i > 0; --i) {
            if (this.triangle[i] >= this.triangle[i - 1]) continue;
            this.triangle[i - 1] = this.triangle[i] - 5;
        }
        for (i = 2; i > 0; --i) {
            if (this.triangle[i] < 0) {
                this.triangle[i] = 0;
            }
            if (this.triangle[i] <= 255) continue;
            this.triangle[i] = 255;
        }
    }

    protected void drawLinear(Graphics g) {
        int i;
        int[] y = this.pimg.video == 0 ? Y : Yr;
        int[] x = new int[]{5, 5 + this.triangle[0], 5 + this.triangle[1], 5 + this.triangle[2], 261};
        g.setColor(Color.black);
        for (i = 0; i < 4; ++i) {
            g.drawLine(x[i], y[i], x[i + 1], y[i + 1]);
            g.drawLine(x[i], y[i] - 1, x[i + 1], y[i + 1] - 1);
        }
        for (i = 1; i < 4; ++i) {
            g.drawLine(x[i], 123, x[i], y[i]);
        }
    }

    private boolean memoGreyLevel(int x) {
        int n = x < 0 ? 0 : (this.greyLevel = x > 255 ? 255 : x);
        if (ogreyLevel != this.greyLevel) {
            ogreyLevel = this.greyLevel;
            this.resumePixelTool();
            return true;
        }
        return false;
    }

    protected void resumePixelTool() {
        if (this.pimg.aladin.framePixelTool == null || !this.pimg.aladin.framePixelTool.isVisible()) {
            return;
        }
        this.pimg.aladin.framePixelTool.setParams(this.pimg, this.getLastPixel());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (!this.memoGreyLevel(x -= 5)) {
            return;
        }
        if (this.pimg.type != 2 && y >= 155 && y <= 180) {
            this.pimg.setCM(CanvasColorMap.getCMBand(this.greyLevel, this.pimg.video == 1, !e.isShiftDown(), this.pimg.isTransparent()));
            this.flagCMBand = true;
            this.isDragging = true;
            this.pimg.aladin.view.getCurrentView().repaint();
            this.repaint();
        } else {
            this.stopBand();
        }
        if (!this.flagCMBand) {
            this.repaint();
        }
    }

    protected void stopBand() {
        if (this.flagCMBand) {
            this.pimg.setCM(this.getCM());
            this.pimg.aladin.view.getCurrentView().repaint();
        }
        this.isDragging = false;
        this.flagCMBand = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        x -= 5;
        this.oy = 0;
        this.repaint();
        for (int i = 0; i < 3; ++i) {
            if (x <= this.triangle[i] - 7 || x >= this.triangle[i] + 7) continue;
            if (i < 1 && this.triangle[1] == this.triangle[2]) {
                i = 2;
            }
            this.currentTriangle = i;
            Aladin.makeCursor(this, i == 1 ? 4 : 9);
            this.isDragging = true;
            return;
        }
        if (this.currentTriangle == 3 && x > this.triangle[0] + 10 && x < this.triangle[2] - 10) {
            this.currentTriangle = 1;
            Aladin.makeCursor(this, 4);
            this.isDragging = true;
            return;
        }
        this.currentTriangle = 3;
        Aladin.makeCursor(this, 2);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.currentTriangle == 3) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.memoGreyLevel(x -= 5);
        System.arraycopy(this.triangle, 0, this.t, 0, 3);
        boolean bl = this.flagLosange = e.isControlDown() || (e.getModifiers() & 4) != 0;
        if (x < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        int ox = this.triangle[1];
        this.triangle[this.currentTriangle] = x;
        if (this.triangle[1] < 5) {
            this.triangle[1] = 5;
        }
        if (this.triangle[1] > 250) {
            this.triangle[1] = 250;
        }
        if (this.currentTriangle == 1 && this.flagLosange) {
            int fct = 2;
            this.triangle[0] = this.triangle[0] - (ox - this.triangle[1]);
            this.triangle[2] = this.triangle[2] - (ox - this.triangle[1]);
            int deltaY = y - this.oy;
            if (this.oy != -1 && deltaY != 0) {
                this.triangle[0] = this.triangle[0] + deltaY * fct;
                if (this.triangle[0] > this.triangle[1] - 5) {
                    this.triangle[0] = this.triangle[1] - 5;
                }
                this.triangle[2] = this.triangle[2] - deltaY * fct;
                if (this.triangle[2] < this.triangle[1] + 5) {
                    this.triangle[2] = this.triangle[1] + 5;
                }
            }
            this.oy = y;
        }
        if (this.trMin > 0) {
            this.triangle[0] = this.triangle[0] - this.trMin;
            this.trMin = 0;
        }
        if (this.triangle[0] < 0) {
            this.trMin -= this.triangle[0];
            this.triangle[0] = 0;
        }
        if (this.trMax > 0) {
            this.triangle[2] = this.triangle[2] + this.trMax;
            this.trMax = 0;
        }
        if (this.triangle[2] > 255) {
            this.trMax += this.triangle[2] - 255;
            this.triangle[2] = 255;
        }
        this.ajustTriangle();
        if (e.isShiftDown() && (this.cm1 != null || this.cm2 != null)) {
            for (int i = 0; i < 3; ++i) {
                if (this.t[i] == this.triangle[i]) continue;
                if (this.cm1 != null) {
                    this.cm1.triangle[i] = this.triangle[i];
                }
                if (this.cm2 == null) continue;
                this.cm2.triangle[i] = this.triangle[i];
            }
            if (this.cm1 != null) {
                this.cm1.repaint();
            }
            if (this.cm2 != null) {
                this.cm2.repaint();
            }
        }
        if (this.isPlanImageRGB) {
            this.pimg.aladin.view.getCurrentView().setFilter(this.triangle, this.rgb);
            this.pimg.aladin.calque.zoom.zoomView.repaint();
        } else if (this.isPlanBGRGB) {
            ((PlanHips)this.pimg).filterRGB(this.triangle, this.rgb);
        } else {
            this.pimg.setCM(this.getCM());
        }
        this.pimg.aladin.view.getCurrentView().repaint();
        this.repaint();
    }

    protected final boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.isDragging = false;
        if (this.currentTriangle == 3) {
            this.repaint();
            return;
        }
        int x = e.getX();
        this.oy = -1;
        if ((x -= 5) < 0) {
            x = 0;
        } else if (x > 255) {
            x = 255;
        }
        Aladin.makeCursor(this, 2);
        this.triangle[this.currentTriangle] = x;
        this.ajustTriangle();
        this.repaint();
        this.pimg.aladin.view.recreateMemoryBufferFor(this.pimg);
        if (this.isPlanImageRGB) {
            this.pimg.aladin.view.getCurrentView().setFilter(this.triangle, this.rgb);
            this.pimg.aladin.calque.zoom.zoomView.repaint();
        } else if (this.isPlanBGRGB) {
            ((PlanHips)this.pimg).filterRGB(this.triangle, this.rgb);
        } else {
            this.pimg.setCM(this.getCM());
        }
        this.frameColorMap.resumeWidgets();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Aladin.makeCursor(this, 2);
        this.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.stopBand();
        this.greyLevel = -1;
        Aladin.makeCursor(this, 0);
        this.repaint();
    }

    public void updateImageHist() {
        int i;
        if (this.imgHist != null && this.pimg.getHistID() == this.lastHistID) {
            return;
        }
        this.lastHistID = this.pimg.getHistID();
        if (this.imgHist == null) {
            this.imgHist = this.pimg.aladin.createImage(257, 140);
            this.gHist = this.imgHist.getGraphics();
        }
        this.gHist.setColor(this.BKGD);
        this.gHist.fillRect(0, 120, 256, 120);
        this.gHist.setColor(Color.white);
        this.gHist.fillRect(0, 0, 256, 120);
        double[] hist = this.pimg.getHist(this.rgb);
        if (this.rgb > -1) {
            if (this.pimg.video == 1) {
                this.gHist.setColor(this.rgb == 0 ? Color.cyan : (this.rgb == 1 ? Color.magenta : Color.yellow));
            } else {
                this.gHist.setColor(this.rgb == 0 ? Color.red : (this.rgb == 1 ? Color.green : Color.blue));
            }
        } else {
            this.gHist.setColor(Color.cyan);
        }
        for (i = 0; i < 256; ++i) {
            this.gHist.drawLine(i, 120, i, (int)(120.0 - hist[i]));
        }
        this.gHist.setColor(Color.black);
        if (this.isPlanImageRGB && ((PlanImageRGB)this.pimg).labels[this.rgb] != null) {
            this.gHist.drawString(((PlanImageRGB)this.pimg).labels[this.rgb], 100, 20);
        }
        this.gHist.drawRect(0, 0, 256, 120);
        this.gHist.setFont(Aladin.SPLAIN);
        String c = "color";
        for (i = 0; i < c.length(); ++i) {
            this.gHist.drawString(c.substring(i, i + 1), 281, 50 + 12 * i);
        }
    }

    @Override
    public void paintComponent(Graphics gd) {
        super.paintComponent(gd);
        this.updateImageHist();
        gd.setColor(this.BKGD);
        gd.fillRect(0, 0, 271, 180);
        gd.drawImage(this.imgHist, 5, 0, this);
        for (int i = 0; i < 3; ++i) {
            gd.setColor(i == this.currentTriangle ? Color.red : Color.black);
            this.drawTriangle(gd, this.triangle[i]);
        }
        if (this.isPlanImageRGB || this.isPlanBGRGB) {
            this.drawLinear(gd);
        } else {
            this.drawFct(gd);
        }
    }

    protected static void drawColorMap(Graphics gr, int dx, int dy, int width, int height, int typeCM, boolean reverse) {
        IndexColorModel idm = CanvasColorMap.getCM(0, 128, 255, reverse, typeCM, 3);
        double gapx = (double)width / 256.0;
        double x = 0.0;
        int i = 0;
        int xc = 0;
        while (i < 256) {
            int red = idm.getRed(i);
            int green = idm.getGreen(i);
            int blue = idm.getBlue(i);
            gr.setColor(new Color(red, green, blue));
            while ((double)xc < x) {
                gr.drawLine(dx + xc, dy, dx + xc, dy + height);
                ++xc;
            }
            ++i;
            x += gapx;
        }
    }

    protected void drawColorMap(Graphics gr, int dx, int dy, int width, int height) {
        double gapx = (double)width / 256.0;
        double x = 0.0;
        int i = 0;
        int xc = 0;
        while (i < 256) {
            gr.setColor(this.getColor(i));
            while ((double)xc < x) {
                gr.drawLine(dx + xc, dy, dx + xc, dy + height);
                ++xc;
            }
            ++i;
            x += gapx;
        }
    }

    protected Color getColor(int i) {
        Color c = !this.flagCMBand ? new Color(r[i] & 0xFF, g[i] & 0xFF, b[i] & 0xFF) : new Color(rb[i] & 0xFF, gb[i] & 0xFF, bb[i] & 0xFF);
        return c;
    }

    protected double getLastPixel() {
        try {
            return Double.parseDouble(this.pimg.getPixelInfoFromGrey(this.greyLevel));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    protected void drawFct(Graphics gr) {
        int x;
        int y;
        double f = 0.46875;
        int ox = 0;
        int oy = 0;
        this.drawColorMap(gr, 5, 155, 256, 25);
        gr.setColor(Aladin.MYBLUE);
        gr.drawString(this.frameColorMap.CMCM, 85, 153);
        if (!this.flagCMBand) {
            for (int j = 0; j < 3; ++j) {
                gr.setColor(j == 0 ? Color.red : (j == 1 ? Aladin.COLOR_GREEN : Color.blue));
                byte[] t = j == 0 ? r : (j == 1 ? g : b);
                for (int i = 0; i < 256; ++i) {
                    y = (int)((double)(256 - (t[i] & 0xFF)) * f - 0.5);
                    x = i + 5;
                    if (i > 0) {
                        gr.drawLine(ox, 0 + oy, x, 0 + y);
                    }
                    ox = x;
                    oy = y;
                }
            }
        }
        if (this.greyLevel > 0 && this.pimg.hasAvailablePixels()) {
            String s = this.pimg.getPixelInfoFromGrey(this.greyLevel);
            x = this.greyLevel + 5;
            gr.setColor(Color.red);
            gr.drawLine(x, 120, x, 120 - (int)this.pimg.hist[this.greyLevel]);
            gr.drawLine(x, 155, x, 180);
            int len = gr.getFontMetrics().stringWidth(s);
            x = 135 - len / 2;
            y = 14;
            int h = 15;
            Util.drawCartouche(gr, x, y - h / 2 - 5, len, h, 0.8f, null, Color.white);
            gr.drawString(s, x, y);
        }
    }

    public static synchronized String addCustomCM(MyColorMap cm) {
        if (customCM == null) {
            customCM = new Vector();
            customCMName = new Vector();
        }
        String name = CanvasColorMap.checkCMNameUnicity(cm.getName());
        cm.setName(name);
        customCM.addElement(cm);
        customCMName.addElement(name);
        return name;
    }

    private static String checkCMNameUnicity(String s) {
        String newName = new String(s);
        int n = 1;
        while (customCMName.contains(newName)) {
            newName = newName + n++;
        }
        return newName;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        boolean control = e.isControlDown();
        if (control != this.flagLosange) {
            this.repaint();
        }
        this.flagLosange = control;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyPressed(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * Opcode count of 15385 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        SR = new int[]{0, 18, 36, 54, 72, 90, 108, 127, 145, 163, 199, 217, 235, 254, 249, 244, 239, 234, 229, 223, 218, 213, 208, 203, 197, 192, 187, 182, 177, 172, 161, 156, 151, 146, 140, 135, 130, 125, 120, 115, 109, 104, 99, 94, 89, 83, 78, 73, 68, 63, 52, 47, 42, 37, 32, 26, 21, 16, 11, 6, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254};
        SG = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254};
        SB = new int[]{0, 1, 3, 5, 7, 9, 11, 13, 15, 17, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 63, 65, 67, 69, 71, 73, 75, 77, 79, 81, 83, 85, 87, 89, 91, 93, 95, 97, 99, 101, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 127, 129, 131, 133, 135, 137, 139, 141, 143, 145, 149, 151, 153, 155, 157, 159, 161, 163, 165, 167, 169, 171, 173, 175, 177, 179, 181, 183, 185, 187, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217, 219, 221, 223, 225, 227, 229, 233, 235, 237, 239, 241, 243, 245, 247, 249, 251, 255, 251, 247, 243, 238, 234, 230, 226, 221, 217, 209, 204, 200, 196, 192, 187, 183, 179, 175, 170, 166, 162, 158, 153, 149, 145, 141, 136, 132, 128, 119, 115, 111, 107, 102, 98, 94, 90, 85, 81, 77, 73, 68, 64, 60, 56, 51, 47, 43, 39, 30, 26, 22, 17, 13, 9, 5, 0, 3, 7, 15, 19, 22, 26, 30, 34, 38, 41, 45, 49, 57, 60, 64, 68, 72, 76, 79, 83, 87, 91, 95, 98, 102, 106, 110, 114, 117, 121, 125, 129, 137, 140, 144, 148, 152, 156, 159, 163, 167, 171, 175, 178, 182, 186, 190, 194, 197, 201, 205, 209, 216, 220, 224, 228, 232, 235, 239, 243, 247, 251};
        RAINBOW_R = new int[]{0, 4, 9, 13, 18, 22, 27, 31, 36, 40, 45, 50, 54, 58, 61, 64, 68, 69, 72, 74, 77, 79, 80, 82, 83, 85, 84, 86, 87, 88, 86, 87, 87, 87, 85, 84, 84, 84, 83, 79, 78, 77, 76, 71, 70, 68, 66, 60, 58, 55, 53, 46, 43, 40, 36, 33, 25, 21, 16, 12, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 21, 25, 29, 33, 42, 46, 51, 55, 63, 67, 72, 76, 80, 89, 93, 97, 101, 110, 114, 119, 123, 131, 135, 140, 144, 153, 157, 161, 165, 169, 178, 182, 187, 191, 199, 203, 208, 212, 221, 225, 229, 233, 242, 246, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        RAINBOW_G = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 16, 21, 25, 29, 38, 42, 46, 51, 55, 63, 67, 72, 76, 84, 89, 93, 97, 106, 110, 114, 119, 127, 131, 135, 140, 144, 152, 157, 161, 165, 174, 178, 182, 187, 195, 199, 203, 208, 216, 220, 225, 229, 233, 242, 246, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 250, 242, 238, 233, 229, 221, 216, 212, 208, 199, 195, 191, 187, 178, 174, 170, 165, 161, 153, 148, 144, 140, 131, 127, 123, 119, 110, 106, 102, 97, 89, 85, 80, 76, 72, 63, 59, 55, 51, 42, 38, 34, 29, 21, 17, 12, 8, 0};
        RAINBOW_B = new int[]{0, 3, 7, 10, 14, 19, 23, 28, 32, 38, 43, 48, 53, 59, 63, 68, 72, 77, 81, 86, 91, 95, 100, 104, 109, 113, 118, 122, 127, 132, 136, 141, 145, 150, 154, 159, 163, 168, 173, 177, 182, 186, 191, 195, 200, 204, 209, 214, 218, 223, 227, 232, 236, 241, 245, 250, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 242, 238, 233, 225, 220, 216, 212, 203, 199, 195, 191, 187, 178, 174, 170, 165, 157, 152, 148, 144, 135, 131, 127, 123, 114, 110, 106, 102, 97, 89, 84, 80, 76, 67, 63, 59, 55, 46, 42, 38, 34, 25, 21, 16, 12, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        EOSB_R = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 18, 27, 36, 45, 49, 57, 72, 81, 91, 100, 109, 118, 127, 136, 131, 139, 163, 173, 182, 191, 200, 209, 218, 227, 213, 221, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 253, 251, 249, 247, 245, 243, 241, 215, 214, 235, 234, 232, 230, 228, 226, 224, 222, 198, 196, 216, 215, 213, 211, 209, 207, 205, 203, 181, 179, 197, 196, 194, 192, 190, 188, 186, 184, 164, 162, 178, 176, 175, 173, 171, 169, 167, 165, 147, 145, 159, 157, 156, 154, 152, 150, 148, 146, 130, 128, 140, 138, 137, 135, 133, 131, 129, 127, 113, 111, 121, 119, 117, 117};
        EOSB_G = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 15, 23, 31, 39, 47, 55, 57, 64, 79, 87, 95, 103, 111, 119, 127, 135, 129, 136, 159, 167, 175, 183, 191, 199, 207, 215, 200, 207, 239, 247, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 255, 255, 255, 255, 255, 255, 255, 229, 229, 255, 250, 246, 242, 238, 233, 229, 225, 198, 195, 212, 208, 204, 199, 195, 191, 187, 182, 160, 156, 169, 165, 161, 157, 153, 148, 144, 140, 122, 118, 127, 125, 123, 121, 119, 116, 114, 112, 99, 97, 106, 104, 102, 99, 97, 95, 93, 91, 80, 78, 84, 82, 80, 78, 76, 74, 72, 70, 61, 59, 63, 61, 59, 57, 55, 53, 50, 48, 42, 40, 42, 40, 38, 36, 33, 31, 29, 27, 22, 21, 21, 19, 16, 14, 12, 13, 8, 6, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        EOSB_B = new int[]{116, 121, 127, 131, 136, 140, 144, 148, 153, 157, 145, 149, 170, 174, 178, 182, 187, 191, 195, 199, 183, 187, 212, 216, 221, 225, 229, 233, 238, 242, 221, 225, 255, 247, 239, 231, 223, 215, 207, 199, 172, 164, 175, 167, 159, 151, 143, 135, 127, 119, 100, 93, 95, 87, 79, 71, 63, 55, 47, 39, 28, 21, 15, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        FIRE_R = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 7, 10, 13, 16, 19, 22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88, 91, 94, 98, 101, 104, 107, 110, 113, 116, 119, 122, 125, 128, 131, 134, 137, 140, 143, 146, 148, 150, 152, 154, 156, 158, 160, 162, 163, 164, 166, 167, 168, 170, 171, 173, 174, 175, 177, 178, 179, 181, 182, 184, 185, 186, 188, 189, 190, 192, 193, 195, 196, 198, 199, 201, 202, 204, 205, 207, 208, 209, 210, 212, 213, 214, 215, 217, 218, 220, 221, 223, 224, 226, 227, 229, 230, 231, 233, 234, 235, 237, 238, 240, 241, 243, 244, 246, 247, 249, 250, 252, 252, 252, 253, 253, 253, 254, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        FIRE_G = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 7, 8, 10, 12, 14, 16, 19, 21, 24, 27, 29, 32, 35, 37, 40, 43, 46, 48, 51, 54, 57, 59, 62, 65, 68, 70, 73, 76, 79, 81, 84, 87, 90, 92, 95, 98, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127, 129, 131, 133, 134, 136, 138, 140, 141, 143, 145, 147, 148, 150, 152, 154, 155, 157, 159, 161, 162, 164, 166, 168, 169, 171, 173, 175, 176, 178, 180, 182, 184, 186, 188, 190, 191, 193, 195, 197, 199, 201, 203, 205, 206, 208, 210, 212, 213, 215, 217, 219, 220, 222, 224, 226, 228, 230, 232, 234, 235, 237, 239, 241, 242, 244, 246, 248, 248, 249, 250, 251, 252, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        FIRE_B = new int[]{0, 7, 15, 22, 30, 38, 45, 53, 61, 65, 69, 74, 78, 82, 87, 91, 96, 100, 104, 108, 113, 117, 121, 125, 130, 134, 138, 143, 147, 151, 156, 160, 165, 168, 171, 175, 178, 181, 185, 188, 192, 195, 199, 202, 206, 209, 213, 216, 220, 220, 221, 222, 223, 224, 225, 226, 227, 224, 222, 220, 218, 216, 214, 212, 210, 206, 202, 199, 195, 191, 188, 184, 181, 177, 173, 169, 166, 162, 158, 154, 151, 147, 143, 140, 136, 132, 129, 125, 122, 118, 114, 111, 107, 103, 100, 96, 93, 89, 85, 82, 78, 74, 71, 67, 64, 60, 56, 53, 49, 45, 42, 38, 35, 31, 27, 23, 20, 16, 12, 8, 5, 4, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 13, 17, 21, 26, 30, 35, 42, 50, 58, 66, 74, 82, 90, 98, 105, 113, 121, 129, 136, 144, 152, 160, 167, 175, 183, 191, 199, 207, 215, 223, 227, 231, 235, 239, 243, 247, 251, 255, 255, 255, 255, 255, 255, 255, 255};
        CUBEHELIX_R = new int[]{0, 1, 3, 4, 6, 8, 9, 10, 12, 13, 14, 15, 17, 18, 19, 20, 20, 21, 22, 23, 23, 24, 24, 25, 25, 25, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 25, 25, 25, 25, 24, 24, 24, 23, 23, 23, 23, 22, 22, 22, 21, 21, 21, 21, 21, 21, 20, 20, 20, 21, 21, 21, 21, 21, 22, 22, 22, 23, 23, 24, 25, 26, 27, 27, 28, 30, 31, 32, 33, 35, 36, 38, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 60, 62, 65, 67, 70, 72, 75, 78, 81, 83, 86, 89, 92, 95, 98, 101, 104, 107, 110, 113, 116, 120, 123, 126, 129, 132, 135, 138, 141, 144, 147, 150, 153, 155, 158, 161, 164, 166, 169, 171, 174, 176, 178, 181, 183, 185, 187, 189, 191, 193, 194, 196, 198, 199, 201, 202, 203, 204, 205, 206, 207, 208, 209, 209, 210, 211, 211, 211, 212, 212, 212, 212, 212, 212, 212, 212, 211, 211, 211, 210, 210, 210, 209, 208, 208, 207, 207, 206, 205, 205, 204, 203, 203, 202, 201, 201, 200, 199, 199, 198, 197, 197, 196, 196, 195, 195, 194, 194, 194, 193, 193, 193, 193, 193, 193, 193, 193, 193, 193, 194, 194, 195, 195, 196, 196, 197, 198, 199, 200, 200, 202, 203, 204, 205, 206, 208, 209, 210, 212, 213, 215, 217, 218, 220, 222, 223, 225, 227, 229, 231, 232, 234, 236, 238, 240, 242, 244, 245, 247, 249, 251, 253, 255};
        CUBEHELIX_G = new int[]{0, 0, 1, 1, 2, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 10, 11, 11, 12, 13, 14, 15, 17, 18, 19, 20, 21, 22, 24, 25, 26, 28, 29, 31, 32, 34, 35, 37, 38, 40, 41, 43, 45, 46, 48, 50, 52, 53, 55, 57, 58, 60, 62, 64, 66, 67, 69, 71, 73, 74, 76, 78, 79, 81, 83, 84, 86, 88, 89, 91, 92, 94, 95, 97, 98, 99, 101, 102, 103, 104, 106, 107, 108, 109, 110, 111, 112, 113, 114, 114, 115, 116, 116, 117, 118, 118, 119, 119, 120, 120, 120, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 122, 121, 121, 121, 121, 121, 121, 121, 121, 121, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 121, 121, 122, 122, 122, 123, 123, 124, 124, 125, 125, 126, 127, 127, 128, 129, 130, 131, 131, 132, 133, 135, 136, 137, 138, 139, 140, 142, 143, 144, 146, 147, 149, 150, 152, 154, 155, 157, 158, 160, 162, 164, 165, 167, 169, 171, 172, 174, 176, 178, 180, 182, 183, 185, 187, 189, 191, 193, 194, 196, 198, 200, 202, 203, 205, 207, 208, 210, 212, 213, 215, 216, 218, 219, 221, 222, 224, 225, 226, 228, 229, 230, 231, 232, 233, 235, 236, 237, 238, 239, 240, 240, 241, 242, 243, 244, 244, 245, 246, 247, 247, 248, 248, 249, 250, 250, 251, 251, 252, 252, 253, 253, 254, 255};
        CUBEHELIX_B = new int[]{0, 1, 3, 4, 6, 8, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31, 33, 35, 37, 39, 41, 43, 45, 47, 48, 50, 52, 54, 56, 57, 59, 60, 62, 63, 65, 66, 67, 69, 70, 71, 72, 73, 74, 74, 75, 76, 76, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 76, 76, 75, 75, 74, 73, 73, 72, 71, 70, 69, 68, 67, 66, 66, 65, 64, 63, 61, 60, 59, 58, 58, 57, 56, 55, 54, 53, 52, 51, 51, 50, 49, 49, 48, 48, 47, 47, 47, 46, 46, 46, 46, 46, 47, 47, 47, 48, 48, 49, 50, 50, 51, 52, 53, 55, 56, 57, 59, 60, 62, 64, 65, 67, 69, 71, 74, 76, 78, 81, 83, 86, 88, 91, 94, 96, 99, 102, 105, 108, 111, 114, 117, 120, 124, 127, 130, 133, 136, 140, 143, 146, 149, 153, 156, 159, 162, 165, 169, 172, 175, 178, 181, 184, 186, 189, 192, 195, 197, 200, 203, 205, 207, 210, 212, 214, 216, 218, 220, 222, 224, 226, 227, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 239, 240, 241, 241, 242, 242, 242, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 242, 242, 242, 242, 241, 241, 241, 241, 240, 240, 240, 239, 239, 239, 239, 239, 238, 238, 238, 238, 238, 238, 238, 238, 239, 239, 239, 240, 240, 240, 241, 242, 242, 243, 244, 245, 246, 247, 248, 249, 250, 252, 253, 255};
        CanvasColorMap.addCustomCM(new MyColorMap("rainbow", RAINBOW_R, RAINBOW_G, RAINBOW_B));
        CanvasColorMap.addCustomCM(new MyColorMap("eosb", EOSB_R, EOSB_G, EOSB_B));
        CanvasColorMap.addCustomCM(new MyColorMap("fire", FIRE_R, FIRE_G, FIRE_B));
        CanvasColorMap.addCustomCM(new MyColorMap("cubehlx", CUBEHELIX_R, CUBEHELIX_G, CUBEHELIX_B));
        int[] r = new int[256];
        int[] g = new int[256];
        int[] b = new int[256];
        for (int i = 0; i < 256; ++i) {
            float hue = (1.0f * (float)i / 256.0f + 0.5f) % 1.0f;
            Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
            r[i] = color.getRed();
            g[i] = color.getGreen();
            b[i] = color.getBlue();
        }
        CanvasColorMap.addCustomCM(new MyColorMap("polar", r, g, b));
        CanvasColorMap.r = new byte[256];
        CanvasColorMap.g = new byte[256];
        CanvasColorMap.b = new byte[256];
        rb = new byte[256];
        gb = new byte[256];
        bb = new byte[256];
        DIM = new Dimension(271, 180);
        DIMRGB = new Dimension(271, 155);
        ogreyLevel = -1;
    }
}

