/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.SED;
import cds.astro.Unit;
import cds.fits.Fits;
import cds.fits.HeaderFits;
import cds.moc.FMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;

public final class CalibFreq
implements Cloneable {
    public static double C = 2.99792458E8;
    public static final int UNKNOWN = 0;
    public static final int FREQ = 1;
    public static final int WAV = 2;
    public static final int VELO = 3;
    int method;
    String ctype3;
    String cunit3;
    double crval3;
    double crpix3;
    double cdelt3;
    double restFreq;
    boolean log;
    double constLog;
    double constLogInv;
    double fctUnit;
    private String lastWarning;
    private static final String[] ANGSTROM = new String[]{"Angstrom", "angstrom", "angstroem", "aangstroem", "aangstrom"};
    private static final String[] MS = new String[]{null, "m/s"};
    static final String DIR = "/HIPS_PROD/fernique/Solar/img";
    static final String OUT = "/HIPS_PROD/fernique/SolarCube";

    public long getMem() {
        return 56L;
    }

    public CalibFreq(HeaderFits hf) throws Exception {
        this(hf, null, Double.NaN, true);
    }

    public CalibFreq(HeaderFits hf, String defaultCUnit, double defaultRestFreq, boolean flagException) throws Exception {
        block25: {
            this.fctUnit = 1.0;
            this.lastWarning = null;
            int n = 3;
            String naxis3 = hf.getStringFromHeader("NAXIS3");
            if (naxis3.equals("1")) {
                ++n;
            }
            this.ctype3 = hf.getStringFromHeader("CTYPE" + n);
            if (this.ctype3.indexOf("VELO") >= 0) {
                this.method = 3;
            } else if (this.ctype3.indexOf("VRAD") >= 0) {
                this.method = 3;
            } else if (this.ctype3.indexOf("WAV") >= 0) {
                this.method = 2;
            } else if (this.ctype3.indexOf("FREQ") >= 0) {
                this.method = 1;
            } else {
                throw new Exception("Frequential calibration unknown [CTYPE" + n + "]");
            }
            this.restFreq = Double.NaN;
            if (this.method == 3) {
                try {
                    String s = hf.getStringFromHeader("RESTFRQ");
                    if (s == null) {
                        s = hf.getStringFromHeader("RESTFREQ");
                    }
                    if (s == null) {
                        s = hf.getStringFromHeader("OBSFREQ");
                    }
                    this.restFreq = s == null ? CalibFreq.wave2Freq(hf.getDoubleFromHeader("RESTWAV")) : Double.parseDouble(s);
                }
                catch (Exception e1) {
                    if (Double.isNaN(defaultRestFreq)) {
                        throw new Exception("Rest frequence unknown [RESTFRQ] or [RESTWAV]");
                    }
                    this.lastWarning = "Rest frequency unknown (RESTFREQ" + n + " missing). Using default value [" + defaultRestFreq + "]";
                    this.restFreq = defaultRestFreq;
                }
            }
            this.crpix3 = hf.getDoubleFromHeader("CRPIX" + n);
            this.crval3 = hf.getDoubleFromHeader("CRVAL" + n);
            try {
                this.cdelt3 = hf.getDoubleFromHeader("CDELT" + n);
            }
            catch (Exception e) {
                this.cdelt3 = hf.getDoubleFromHeader("CD3_3");
            }
            try {
                this.cunit3 = hf.getStringFromHeader("CUNIT" + n);
                if (this.cunit3 == null) {
                    if (defaultCUnit != null) {
                        this.cunit3 = defaultCUnit;
                    } else {
                        this.lastWarning = "Unit unknown (CUNIT" + n + " missing). Assuming International System";
                    }
                }
                if (this.cunit3 != null) {
                    String u = this.adjustUnit(this.cunit3);
                    if (u == null) {
                        this.lastWarning = "Suspicious unit [CUNIT" + n + "=" + this.cunit3 + "]. Assuming International System";
                    } else {
                        this.fctUnit = this.computeFctUnit(this.method, u);
                    }
                }
            }
            catch (Exception e) {
                this.lastWarning = "Unit conversion error (unknown or wrong unit) [CUNIT" + n + "=" + this.cunit3 + "]";
                if (!flagException) break block25;
                throw new Exception(this.lastWarning);
            }
        }
        this.log = this.ctype3.indexOf("LOG") > 0;
        this.constLog = this.cdelt3 / (Math.log(10.0) * this.crval3);
        this.constLogInv = 1.0 / this.constLog;
    }

    private String adjustUnit(String u) {
        if (Util.indexInArrayOf(u, ANGSTROM, true) >= 0) {
            return ANGSTROM[0];
        }
        if (Util.indexInArrayOf(u, MS, true) >= 0) {
            return MS[0];
        }
        return u;
    }

    public String getLastWarning() {
        return this.lastWarning;
    }

    private double computeFctUnit(int method, String cunit3) throws Exception {
        Unit u1 = new Unit();
        Unit u2 = new Unit();
        u1.setUnit(cunit3);
        u1.setValue(1.0);
        switch (method) {
            case 1: {
                u2.setUnit("Hz");
                break;
            }
            case 2: {
                u2.setUnit("m");
                break;
            }
            case 3: {
                u2.setUnit("m/s");
            }
        }
        u2.convertTo(u1);
        return u2.getValue();
    }

    public double velo2Freq(double velo) {
        return CalibFreq.velo2Freq(velo, this.restFreq);
    }

    public double freq2Velo(double freq) {
        return CalibFreq.freq2Velo(freq, this.restFreq);
    }

    public static double freq2Wave(double freq) {
        return C / freq;
    }

    public static double wave2Freq(double wave) {
        return C / wave;
    }

    public static double velo2Freq(double velo, double restFreq) {
        return (1.0 - velo / C) * restFreq;
    }

    public static double freq2Velo(double freq, double restFreq) {
        return (1.0 - freq / restFreq) * C;
    }

    public double getValue(double channel) {
        if (this.log) {
            return this.crval3 * Math.pow(10.0, this.constLog * (channel - this.crpix3));
        }
        return (channel - this.crpix3) * this.cdelt3 + this.crval3;
    }

    public double getValueRecip(double x) {
        if (this.log) {
            return this.crpix3 + this.constLogInv * Math.log10(x / this.crval3);
        }
        return (x - this.crval3) / this.cdelt3 + this.crpix3;
    }

    public double getFreq(double channel) {
        double x = this.getValue(channel) / this.fctUnit;
        switch (this.method) {
            case 3: {
                return this.velo2Freq(x);
            }
            case 2: {
                return CalibFreq.wave2Freq(x);
            }
            case 1: {
                return x;
            }
        }
        return Double.NaN;
    }

    public int getChannel(double freq) throws Exception {
        double x;
        switch (this.method) {
            case 3: {
                x = this.freq2Velo(freq);
                break;
            }
            case 2: {
                x = CalibFreq.freq2Wave(freq);
                break;
            }
            default: {
                x = freq;
            }
        }
        return (int)Math.round(this.getValueRecip(x * this.fctUnit));
    }

    public String getFrequence(double channel) {
        return SED.getUnitFreq(this.getFreq(channel), "Hz");
    }

    public String getWave(double channel) {
        return SED.getUnitWave(SED.freq2Wave(this.getFreq(channel)), "m");
    }

    public static final long freq2pix(int order, double freq) throws Exception {
        long npix = FMoc.getNpix(freq);
        if (npix == -1L) {
            throw new Exception("Frequency out of FMOC range");
        }
        return npix >>> 51 - order;
    }

    public static final double pix2freq(int order, long pix) throws Exception {
        int deltaOrder = 51 - order;
        long nbPixIn = CDSHealpix.pow2(deltaOrder);
        long hash = (pix << deltaOrder) + nbPixIn / 2L;
        double res = FMoc.getFreq(hash);
        if (Double.isNaN(res)) {
            throw new Exception("npix out of FMOC range");
        }
        return res;
    }

    public static final double pix2freqStart(int order, long pix) throws Exception {
        int deltaOrder = 51 - order;
        long hash = pix << deltaOrder;
        double res = FMoc.getFreq(hash);
        if (Double.isNaN(res)) {
            throw new Exception("npix out of FMOC range");
        }
        return res;
    }

    public static final double getOrderFreqRes(int order, double freq) throws Exception {
        long npix = FMoc.getNpix(freq);
        if (npix == -1L) {
            return Double.NaN;
        }
        long pix = npix >>> 51 - order;
        return Math.abs(CalibFreq.pix2freqStart(order, pix) - CalibFreq.pix2freqStart(order, pix + 1L));
    }

    public static long[] queryRange(int order, double freqMin, double freqMax) throws Exception {
        long npixMin = CalibFreq.freq2pix(order, freqMin);
        long npixMax = CalibFreq.freq2pix(order, freqMax);
        if (npixMin == -1L || npixMax == -1L) {
            throw new Exception("Frequency limits out of FMOC range");
        }
        if (npixMin > npixMax) {
            long x = npixMin;
            npixMin = npixMax;
            npixMax = x;
        }
        return new long[]{npixMin, npixMax};
    }

    public int getAdequateOrder() throws Exception {
        return this.getAdequateOrder(0);
    }

    public int getAdequateOrder(int channel) throws Exception {
        int order;
        double freq0 = this.getFreq(channel);
        double freq1 = this.getFreq(channel + 1);
        double resOrigin = Math.abs(freq0 - freq1);
        for (order = 51; order >= 0; --order) {
            try {
                long pix0 = CalibFreq.freq2pix(order, freq0);
                freq1 = CalibFreq.pix2freqStart(order, pix0);
                double freq2 = CalibFreq.pix2freqStart(order, pix0 + 1L);
                double resTrg = Math.abs(freq2 - freq1);
                if (!(resTrg > resOrigin)) continue;
                ++order;
                break;
            }
            catch (Exception e) {
                return order++;
            }
        }
        return order;
    }

    public double getRestFreq() {
        return this.restFreq;
    }

    public static void main(String[] argv) {
        Fits cube = null;
        int bitpix = 0;
        int limit = -1;
        int m = 1;
        int k = 0;
        try {
            File dir = new File(DIR);
            File[] list = dir.listFiles();
            int n = 0;
            for (File filename : list) {
                if (!filename.getName().endsWith(".fits")) continue;
                ++n;
            }
            System.out.println("Scanning /HIPS_PROD/fernique/Solar/img -> " + n + " fits images found");
            int j = 0;
            while (k < n) {
                int offset = 0;
                int i = 0;
                while (limit == -1 || i < limit) {
                    File filename = list[k];
                    if (filename.getName().endsWith(".fits")) {
                        System.out.println("  .adding " + filename + "...");
                        Fits fits = new Fits(filename.getAbsolutePath());
                        if (i == 0) {
                            if (limit == -1) {
                                limit = Integer.MAX_VALUE / fits.pixels.length;
                            }
                            if (limit > n - k) {
                                limit = n - k;
                            }
                            cube = new Fits(fits.width, fits.height, limit, fits.bitpix);
                            bitpix = fits.bitpix;
                        }
                        int length = fits.pixels.length;
                        System.arraycopy(fits.pixels, 0, cube.pixels, offset, length);
                        offset += length;
                    }
                    ++i;
                    ++k;
                }
                if (cube != null) {
                    String header = "SIMPLE  = T\nBITPIX  = " + bitpix + "\nNAXIS   = 3\nNAXIS1  = 4096\nNAXIS2  = 4096\nNAXIS3  = " + limit + "\nCRPIX1  = 2048.0\nCRPIX2  = 2048.0\nEQUINOX = 2000.0\nCRVAL1  = 359.999968125\nCRVAL2  = -1.2638888888888888E-5\nCTYPE1  = RA---SIN\nCTYPE2  = DEC--SIN\nRADECSYS= FK5\nCD1_1   = -0.035833333333333335\nCD1_2   = -0.0\nCD2_1   = -0.0\nCD2_2   = 0.035833333333333335\nCTYPE3  = 'AWAV    '\nCUNIT3  = 'angstrom'\nCRPIX3  = " + (limit - k + 1) + "\nCD3_3   =                 1.25\nCRVAL3  =       4749.533203125\nCD1_3   =                   0.\nCD2_3   =                   0.\nCD3_1   =                   0.\nCD3_2   =                   0.\n";
                    cube.headerFits = new HeaderFits(header);
                    String s = "/HIPS_PROD/fernique/SolarCube/cube" + m++ + ".fits";
                    cube.writeFITS(s);
                    System.out.println("Cube " + (limit - k + 1) + "/" + limit + " generated: " + s);
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

