/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AladinException;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.FrameHeaderFits;
import cds.aladin.Legende;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.Projection;
import cds.aladin.Source;
import java.awt.Color;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;

public class AladinData {
    protected static final String ERR000 = "000 No default data plane";
    protected static final String ERR001 = "001 Unknown data plane";
    protected static final String ERR002 = "002 Plane not ready";
    protected static final String ERR003 = "003 Not an image plane";
    protected static final String ERR004 = "004 Full pixels not available";
    protected static final String ERR005 = "005 Fits header not available";
    protected static final String ERR006 = "006 No astrometrical solution";
    protected static final String ERR007 = "007 No object";
    protected static final String ERR008 = "008 No info on this overlay object";
    protected static final String ERR009 = "009 Plane creation error";
    protected static final String ERR010 = "010 Calibration error";
    protected static final String ERR011 = "011 Not an cube or blink plane";
    protected static final String ERR012 = "012 Cube extraction error";
    protected static final String ERR013 = "013 Plugin already running";
    protected static final String ERR014 = "014 Not available for a huge image";
    protected static final String ERR015 = "015 Catalogue creation error";
    protected Plan plan;
    private Legende leg;

    public int getPlaneHashCode() {
        return this.plan.hashCode();
    }

    public String getLabel() {
        return this.plan.label;
    }

    public Color getColor() {
        return this.plan.c;
    }

    public String getOrigin() {
        return this.plan.copyright;
    }

    public URL getUrl() {
        return this.plan.u;
    }

    public String getError() {
        if (this.plan.type == 0) {
            return "Unknown plane";
        }
        return this.plan.error;
    }

    public String getPlaneType() {
        if (this.plan.type == 11 || this.plan.type == 1 || this.plan.type == 15) {
            return Plan.TYPE[this.plan.type];
        }
        if (this.plan.type == 0) {
            return "";
        }
        return (this.plan instanceof PlanImage ? "Image/" : "Overlay/") + Plan.TYPE[this.plan.type];
    }

    public boolean isSelected() {
        return this.plan.selected;
    }

    public boolean isOn() {
        return this.plan.active;
    }

    public boolean isReady() {
        return this.plan.isReady();
    }

    public double[][] getPixels() throws AladinException {
        this.testImage();
        this.testHuge();
        PlanImage p = (PlanImage)this.plan;
        double[][] pix = null;
        try {
            p.setLockCacheFree(true);
            if (!p.hasOriginalPixels() || !p.pixelsOriginFromCache()) {
                throw new AladinException(ERR004);
            }
            pix = ((PlanImage)this.plan).getPixels();
        }
        finally {
            p.setLockCacheFree(false);
        }
        return pix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPixel(int x, int y) throws AladinException {
        this.testImage();
        this.testHuge();
        PlanImage p = (PlanImage)this.plan;
        double pix = Double.NaN;
        try {
            p.setLockCacheFree(true);
            if (!p.hasOriginalPixels() || !p.pixelsOriginFromCache()) {
                throw new AladinException(ERR004);
            }
            if (x < 0 || x >= p.naxis1 || y < 0 || y >= p.naxis2) {
                double d = Double.NaN;
                return d;
            }
            pix = p.getPixelOriginInDouble(x, y);
        }
        finally {
            p.setLockCacheFree(false);
        }
        return pix;
    }

    public double getPixel(int x, int y, int z) throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        try {
            return ((PlanImageBlink)this.plan).getPixel(x, y, z);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AladinException("012 Cube extraction error ");
        }
    }

    public double[][][] getCube(int x, int y, int z, int width, int height, int depth) throws AladinException {
        return this.getCube(null, x, y, z, width, height, depth);
    }

    public double[][][] getCube(double[][][] cube, int x, int y, int z, int width, int height, int depth) throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        try {
            return ((PlanImageBlink)this.plan).getCube(cube, x, y, z, width, height, depth);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AladinException("012 Cube extraction error ");
        }
    }

    public double[][][] getCube() throws AladinException {
        return this.getCube(0, 0, 0, ((PlanImage)this.plan).width, ((PlanImage)this.plan).height, ((PlanImageBlink)this.plan).depth);
    }

    public void setPixels(double[][] pixels) throws AladinException {
        this.testImage();
        ((PlanImage)this.plan).setPixels(pixels);
        this.codedPixelsModified();
    }

    public void setPixels(double[][] pixels, int bitpix) throws AladinException {
        this.testImage();
        this.testHuge();
        ((PlanImage)this.plan).setPixels(pixels, bitpix);
        this.codedPixelsModified();
    }

    public int getWidth() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).width;
    }

    public int getHeight() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).height;
    }

    public int getDepth() throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        return ((PlanImageBlink)this.plan).depth;
    }

    public double[] getPixelSize() throws AladinException {
        this.testImage();
        double[] x = ((PlanImage)this.plan).getPixelSize();
        if (x == null) {
            throw new AladinException(ERR006);
        }
        return x;
    }

    public int getFitsBitPix() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).bitpix;
    }

    public double getFitsBzero() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).bZero;
    }

    public double getFitsBscale() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).bScale;
    }

    public String getFitsHeader() throws AladinException {
        this.testImage();
        try {
            return this.plan.aladin.save.generateFitsHeaderString((PlanImage)this.plan);
        }
        catch (Exception e) {
            throw new AladinException(ERR005);
        }
    }

    public void setFitsHeader(String header) throws AladinException {
        this.testImage();
        try {
            ((PlanImage)this.plan).headerFits = new FrameHeaderFits(this.plan, header);
            ((PlanImage)this.plan).headerFits = new FrameHeaderFits(this.plan, this.plan.aladin.save.generateFitsHeaderString((PlanImage)this.plan));
        }
        catch (Exception e) {
            throw new AladinException("010 Calibration error => " + e.getMessage());
        }
        this.setCalib();
    }

    public byte[] seeBytePixels() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).getBufPixels8();
    }

    public byte[] seeBytePixels(int z) throws AladinException {
        this.testImage();
        if (!(this.plan instanceof PlanImageBlink)) {
            throw new AladinException(ERR011);
        }
        return ((PlanImageBlink)this.plan).vFrames.elementAt((int)z).pixels;
    }

    public byte[] seeCodedPixels() throws AladinException {
        this.testImage();
        this.testHuge();
        PlanImage p = (PlanImage)this.plan;
        p.setLockCacheFree(true);
        if (!p.hasOriginalPixels() || !p.pixelsOriginFromCache()) {
            throw new AladinException(ERR004);
        }
        return p.pixelsOrigin;
    }

    public Hashtable seeFitsKeys() throws AladinException {
        this.testImage();
        return ((PlanImage)this.plan).headerFits.getHeaderFits().getHashHeader();
    }

    public static double CodedPixelsToDouble(byte[] codedPixels, int bitpix, int pos) {
        return PlanImage.getPixVal1(codedPixels, bitpix, pos);
    }

    public static void DoubleToCodedPixels(double val, byte[] codedPixels, int bitpix, int pos) {
        PlanImage.setPixVal(codedPixels, bitpix, pos, val);
    }

    public void bytePixelsModified() throws AladinException {
        this.testImage();
        this.testHuge();
        ((PlanImage)this.plan).noOriginalPixels();
        this.repaint();
    }

    public void codedPixelsModified() throws AladinException {
        this.testImage();
        this.testHuge();
        ((PlanImage)this.plan).reUseOriginalPixels();
        this.repaint();
    }

    public void fitsKeysModified() throws AladinException {
        this.testImage();
        this.setCalib();
        this.setFitsHeader(this.plan.aladin.save.generateFitsHeaderString((PlanImage)this.plan));
    }

    public double[] getCoord(double x, double y) throws AladinException {
        this.testImage();
        if (!Projection.isOk(this.plan.projd)) {
            throw new AladinException(ERR006);
        }
        Coord coo = new Coord();
        coo.x = x - 0.5;
        coo.y = y - 0.5;
        coo.y = (double)((PlanImage)this.plan).naxis2 - coo.y;
        this.plan.projd.getCoord(coo);
        return new double[]{coo.al, coo.del};
    }

    public double[] getXY(double ra, double dec) throws AladinException {
        if (!Projection.isOk(this.plan.projd)) {
            throw new AladinException(ERR006);
        }
        Coord coo = new Coord();
        coo.al = ra;
        coo.del = dec;
        this.plan.projd.getXY(coo);
        coo.y = (double)((PlanImage)this.plan).naxis2 - coo.y;
        return new double[]{coo.x + 0.5, coo.y + 0.5};
    }

    public Iterator<Obj> iteratorObj() throws AladinException {
        this.testOverlay();
        return this.plan.pcat.iterator();
    }

    public Obj[] seeObj() throws AladinException {
        this.testOverlay();
        return this.plan.pcat.getObj();
    }

    public int getNbObj() throws AladinException {
        this.testOverlay();
        return this.plan.pcat.getCount();
    }

    public void rmObj(Obj obj) throws AladinException {
        this.testOverlay();
        if (obj.isSelected()) {
            obj.setSelected(false);
        }
        this.plan.pcat.delObjet(obj, true);
    }

    public void setName(String[] name) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 3, name);
    }

    public void setDescription(String[] desc) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 4, desc);
    }

    public void setDatatype(String[] datatype) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 6, datatype);
    }

    public void setUnit(String[] unit) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 5, unit);
    }

    public void setUCD(String[] ucd) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 7, ucd);
    }

    public void setWidth(String[] width) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 10, width);
    }

    public void setArraysize(String[] arraysize) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 11, arraysize);
    }

    public void setPrecision(String[] precision) {
        this.leg = Legende.adjustDefaultLegende(this.leg, 12, precision);
    }

    public Obj addSource(String id, double ra, double dec, String[] value) throws AladinException {
        this.testOverlay();
        StringBuffer s = new StringBuffer("<&_A>");
        for (int i = 0; i < value.length; ++i) {
            if (value[i].startsWith("http://") || value[i].startsWith("https://")) {
                s.append("\t<&Http " + value[i] + ">");
                continue;
            }
            s.append("\t" + value[i]);
        }
        Source o = new Source(this.plan, ra, dec, id, s.toString());
        o.setLeg(this.leg);
        this.plan.pcat.setObjetFast(o);
        return o;
    }

    public void objModified() throws AladinException {
        this.testOverlay();
        if (!Projection.isOk(this.plan.projd)) {
            this.plan.pcat.createDefaultProj();
        }
        this.plan.planReady(true);
        this.plan.aladin.view.newView(1);
        this.plan.aladin.mesure.memoWordLineClear();
        this.plan.aladin.mesure.display();
        this.plan.aladin.calque.repaintAll();
    }

    public AladinData(Aladin aladin) throws AladinException {
        this(aladin, 0, null);
    }

    public AladinData(Aladin aladin, String name) throws AladinException {
        this(aladin, 0, name);
    }

    public AladinData(Aladin aladin, int planeHashCode) throws AladinException {
        this.leg = null;
        this.plan = aladin.calque.getPlanByHashCode(planeHashCode);
        if (this.plan == null) {
            throw new AladinException(ERR001);
        }
    }

    public AladinData(Aladin aladin, Plan plan) throws AladinException {
        this.leg = null;
        this.plan = plan;
    }

    public AladinData(Aladin aladin, int mode, String name) throws AladinException {
        block13: {
            this.leg = null;
            if (mode == 0) {
                if (name == null) {
                    try {
                        String planeID = aladin.calque.getFirstSelectedPlan().label;
                        this.plan = aladin.calque.getPlan(planeID);
                    }
                    catch (Exception e) {
                        throw new AladinException(ERR000);
                    }
                } else {
                    this.plan = aladin.calque.getPlan(name);
                    if (this.plan == null) {
                        throw new AladinException(ERR001);
                    }
                }
                if (this.plan != null) {
                    this.leg = this.plan.getFirstLegende();
                }
            } else {
                try {
                    if (mode == 1) {
                        String planeID = aladin.calque.newPlanPlugImg(name);
                        this.plan = aladin.calque.getPlan(planeID);
                        double[][] pix = new double[500][500];
                        this.setPixels(pix);
                        this.plan.error = PlanImage.NOREDUCTION;
                        this.plan = aladin.calque.getPlan(planeID, 1);
                        this.plan.planReady(true);
                        break block13;
                    }
                    if (mode == 2) {
                        String planeID = aladin.calque.newPlanPlugCat(name);
                        this.plan = aladin.calque.getPlan(planeID, 1);
                        break block13;
                    }
                    if (mode == 3) {
                        String planeID = aladin.calque.newPlanPlugTool(name);
                        this.plan = aladin.calque.getPlan(planeID, 1);
                        break block13;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    throw new AladinException(ERR009);
                }
            }
        }
    }

    protected AladinData(Aladin aladin, String planeId, String origin) throws AladinException {
        this.leg = null;
        int i = aladin.calque.newPlanImage(null, 0, planeId, "", "", origin, 0, 0, null, null);
        this.plan = aladin.calque.plan[i];
    }

    private void testImage() throws AladinException {
        if (!this.plan.isReady()) {
            throw new AladinException(ERR002);
        }
        if (!(this.plan instanceof PlanImage)) {
            throw new AladinException(ERR003);
        }
    }

    private void testHuge() throws AladinException {
        if (this.plan.type == 15) {
            throw new AladinException(ERR014);
        }
    }

    private void testOverlay() throws AladinException {
        if (!this.plan.isReady()) {
            throw new AladinException(ERR002);
        }
        if (this.plan.pcat == null) {
            throw new AladinException(ERR007);
        }
    }

    private void setCalib() {
        try {
            Projection proj = new Projection(2, new Calib(((PlanImage)this.plan).headerFits.getHeaderFits()), this.plan);
            this.plan.setNewProjD(proj);
            this.plan.setHasSpecificCalib();
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void repaint() {
        if (this.plan instanceof PlanImage) {
            ((PlanImage)this.plan).changeImgID();
        } else {
            this.plan.aladin.view.newView(1);
        }
        this.plan.aladin.calque.repaintAll();
    }

    public String toString() {
        try {
            String s = this.getPlaneType() + " " + this.getLabel();
            if (!(this.plan instanceof PlanImage)) {
                return s;
            }
            return s + " " + this.getWidth() + "x" + this.getHeight();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

