/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBType;
import adql.db.STCS;
import adql.parser.ParseException;
import adql.query.TextPosition;
import adql.query.constraint.Comparison;
import adql.query.constraint.ComparisonOperator;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.translator.PostgreSQLTranslator;
import adql.translator.TranslationException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.postgresql.util.PGobject;

public class PgSphereTranslator
extends PostgreSQLTranslator {
    protected static double ANGLE_CIRCLE_TO_POLYGON = 0.19634954084936207;

    public PgSphereTranslator() {
    }

    public PgSphereTranslator(boolean bl) {
        super(bl);
    }

    public PgSphereTranslator(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(bl, bl2, bl3, bl4);
    }

    @Override
    public String translate(PointFunction pointFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("spoint(");
        stringBuffer.append("radians(").append(this.translate(pointFunction.getCoord1())).append("),");
        stringBuffer.append("radians(").append(this.translate(pointFunction.getCoord2())).append("))");
        return stringBuffer.toString();
    }

    @Override
    public String translate(CircleFunction circleFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("scircle(");
        stringBuffer.append("spoint(radians(").append(this.translate(circleFunction.getCoord1())).append("),");
        stringBuffer.append("radians(").append(this.translate(circleFunction.getCoord2())).append(")),");
        stringBuffer.append("radians(").append(this.translate(circleFunction.getRadius())).append("))");
        return stringBuffer.toString();
    }

    @Override
    public String translate(BoxFunction boxFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("sbox(");
        stringBuffer.append("spoint(").append("radians(").append(this.translate(boxFunction.getCoord1())).append("-(").append(this.translate(boxFunction.getWidth())).append("/2.0)),");
        stringBuffer.append("radians(").append(this.translate(boxFunction.getCoord2())).append("-(").append(this.translate(boxFunction.getHeight())).append("/2.0))),");
        stringBuffer.append("spoint(").append("radians(").append(this.translate(boxFunction.getCoord1())).append("+(").append(this.translate(boxFunction.getWidth())).append("/2.0)),");
        stringBuffer.append("radians(").append(this.translate(boxFunction.getCoord2())).append("+(").append(this.translate(boxFunction.getHeight())).append("/2.0))))");
        return stringBuffer.toString();
    }

    @Override
    public String translate(PolygonFunction polygonFunction) throws TranslationException {
        try {
            StringBuffer stringBuffer = new StringBuffer("spoly('{'");
            if (polygonFunction.getNbParameters() > 2) {
                PointFunction pointFunction = new PointFunction(polygonFunction.getCoordinateSystem(), polygonFunction.getParameter(1), polygonFunction.getParameter(2));
                stringBuffer.append(" || ").append(this.translate(pointFunction));
                for (int i = 3; i < polygonFunction.getNbParameters() && i + 1 < polygonFunction.getNbParameters(); i += 2) {
                    pointFunction.setCoord1(polygonFunction.getParameter(i));
                    pointFunction.setCoord2(polygonFunction.getParameter(i + 1));
                    stringBuffer.append(" || ',' || ").append(this.translate(pointFunction));
                }
            }
            stringBuffer.append(" || '}')");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new TranslationException(exception);
        }
    }

    @Override
    public String translate(ExtractCoord extractCoord) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("degrees(");
        if (extractCoord.getName().equalsIgnoreCase("COORD1")) {
            stringBuffer.append("long(");
        } else {
            stringBuffer.append("lat(");
        }
        stringBuffer.append(this.translate(extractCoord.getParameter(0))).append("))");
        return stringBuffer.toString();
    }

    @Override
    public String translate(DistanceFunction distanceFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("degrees(");
        stringBuffer.append(this.translate(distanceFunction.getP1())).append(" <-> ").append(this.translate(distanceFunction.getP2())).append(")");
        return stringBuffer.toString();
    }

    @Override
    public String translate(AreaFunction areaFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("degrees(degrees(area(");
        stringBuffer.append(this.translate(areaFunction.getParameter())).append(")))");
        return stringBuffer.toString();
    }

    @Override
    public String translate(ContainsFunction containsFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.translate(containsFunction.getLeftParam())).append(" @ ").append(this.translate(containsFunction.getRightParam())).append(")");
        return stringBuffer.toString();
    }

    @Override
    public String translate(IntersectsFunction intersectsFunction) throws TranslationException {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.translate(intersectsFunction.getLeftParam())).append(" && ").append(this.translate(intersectsFunction.getRightParam())).append(")");
        return stringBuffer.toString();
    }

    @Override
    public String translate(Comparison comparison) throws TranslationException {
        if ((comparison.getLeftOperand() instanceof ContainsFunction || comparison.getLeftOperand() instanceof IntersectsFunction) && (comparison.getOperator() == ComparisonOperator.EQUAL || comparison.getOperator() == ComparisonOperator.NOT_EQUAL) && comparison.getRightOperand().isNumeric()) {
            return this.translate(comparison.getLeftOperand()) + " " + comparison.getOperator().toADQL() + " '" + this.translate(comparison.getRightOperand()) + "'";
        }
        if ((comparison.getRightOperand() instanceof ContainsFunction || comparison.getRightOperand() instanceof IntersectsFunction) && (comparison.getOperator() == ComparisonOperator.EQUAL || comparison.getOperator() == ComparisonOperator.NOT_EQUAL) && comparison.getLeftOperand().isNumeric()) {
            return "'" + this.translate(comparison.getLeftOperand()) + "' " + comparison.getOperator().toADQL() + " " + this.translate(comparison.getRightOperand());
        }
        return super.translate(comparison);
    }

    @Override
    public DBType convertTypeFromDB(int n, String string, String string2, String[] stringArray) {
        if (string2 == null || string2.trim().length() == 0) {
            return new DBType(DBType.DBDatatype.VARCHAR, -1);
        }
        if ((string2 = string2.toLowerCase()).equals("spoint")) {
            return new DBType(DBType.DBDatatype.POINT);
        }
        if (string2.equals("scircle") || string2.equals("sbox") || string2.equals("spoly")) {
            return new DBType(DBType.DBDatatype.REGION);
        }
        return super.convertTypeFromDB(n, string, string2, stringArray);
    }

    @Override
    public String convertTypeToDB(DBType dBType) {
        if (dBType != null) {
            if (dBType.type == DBType.DBDatatype.POINT) {
                return "spoint";
            }
            if (dBType.type == DBType.DBDatatype.REGION) {
                return "spoly";
            }
        }
        return super.convertTypeToDB(dBType);
    }

    @Override
    public STCS.Region translateGeometryFromDB(Object object) throws ParseException {
        if (object == null) {
            return null;
        }
        if (!(object instanceof PGobject)) {
            throw new ParseException("Incompatible type! The column value \"" + object.toString() + "\" was supposed to be a geometrical object.");
        }
        PGobject pGobject = (PGobject)object;
        if (pGobject == null || pGobject.getType() == null || pGobject.getValue() == null || pGobject.getValue().length() == 0) {
            return null;
        }
        String string = pGobject.getType().toLowerCase();
        String string2 = pGobject.getValue();
        if (string.equals("spoint")) {
            return new PgSphereGeometryParser().parsePoint(string2);
        }
        if (string.equals("scircle")) {
            return new PgSphereGeometryParser().parseCircle(string2);
        }
        if (string.equals("sbox")) {
            return new PgSphereGeometryParser().parseBox(string2);
        }
        if (string.equals("spoly")) {
            return new PgSphereGeometryParser().parsePolygon(string2);
        }
        throw new ParseException("Unsupported PgSphere type: \"" + string + "\"! Impossible to convert the column value \"" + string2 + "\" into a Region.");
    }

    @Override
    public Object translateGeometryToDB(STCS.Region region) throws ParseException {
        if (region == null) {
            return null;
        }
        try {
            PGobject pGobject = new PGobject();
            switch (region.type) {
                case POSITION: {
                    pGobject.setType("spoint");
                    pGobject.setValue("(" + region.coordinates[0][0] + "d," + region.coordinates[0][1] + "d)");
                    break;
                }
                case POLYGON: {
                    pGobject.setType("spoly");
                    StringBuffer stringBuffer = new StringBuffer("{");
                    for (int i = 0; i < region.coordinates.length; ++i) {
                        if (i > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append('(').append(region.coordinates[i][0]).append("d,").append(region.coordinates[i][1]).append("d)");
                    }
                    stringBuffer.append('}');
                    pGobject.setValue(stringBuffer.toString());
                    break;
                }
                case BOX: {
                    pGobject.setType("spoly");
                    StringBuffer stringBuffer = new StringBuffer("{");
                    stringBuffer.append('(').append(region.coordinates[0][0] - region.width / 2.0).append("d,").append(region.coordinates[0][1] - region.height / 2.0).append("d),");
                    stringBuffer.append('(').append(region.coordinates[0][0] - region.width / 2.0).append("d,").append(region.coordinates[0][1] + region.height / 2.0).append("d),");
                    stringBuffer.append('(').append(region.coordinates[0][0] + region.width / 2.0).append("d,").append(region.coordinates[0][1] + region.height / 2.0).append("d),");
                    stringBuffer.append('(').append(region.coordinates[0][0] + region.width / 2.0).append("d,").append(region.coordinates[0][1] - region.height / 2.0).append("d)");
                    stringBuffer.append('}');
                    pGobject.setValue(stringBuffer.toString());
                    break;
                }
                case CIRCLE: {
                    pGobject.setType("spoly");
                    pGobject.setValue(this.circleToPolygon(region.coordinates[0], region.radius));
                    break;
                }
                default: {
                    throw new ParseException("Unsupported geometrical region: \"" + (Object)((Object)region.type) + "\"!");
                }
            }
            return pGobject;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    protected String circleToPolygon(double[] dArray, double d) {
        StringBuffer stringBuffer = new StringBuffer();
        for (double d2 = 0.0; d2 < Math.PI * 2; d2 += ANGLE_CIRCLE_TO_POLYGON) {
            double d3 = dArray[0] + d * Math.cos(d2);
            double d4 = dArray[1] + d * Math.sin(d2);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('(').append(d3).append("d,").append(d4).append("d)");
        }
        return "{" + stringBuffer + "}";
    }

    protected static class PgSphereGeometryParser {
        private int pos;
        private String expr;
        private String token;
        private StringBuffer buffer;
        private static final char OPEN_PAR = '(';
        private static final char CLOSE_PAR = ')';
        private static final char COMMA = ',';
        private static final char LESS_THAN = '<';
        private static final char GREATER_THAN = '>';
        private static final char OPEN_BRACE = '{';
        private static final char CLOSE_BRACE = '}';
        private static final char DEGREE = 'd';
        private static final char HOUR = 'h';
        private static final char MINUTE = 'm';
        private static final char SECOND = 's';

        private void init(String string) {
            this.expr = string == null ? "" : string;
            this.token = null;
            this.buffer = new StringBuffer();
            this.pos = 0;
        }

        private void end() throws ParseException {
            this.skipSpaces();
            if (this.expr.length() > 0 && this.pos < this.expr.length()) {
                throw new ParseException("Unexpected end of PgSphere region expression: \"" + this.expr.substring(this.pos) + "\" was unexpected!", new TextPosition(1, this.pos, 1, this.expr.length()));
            }
            this.buffer = null;
            this.expr = null;
            this.token = null;
        }

        private void skipSpaces() {
            while (this.pos < this.expr.length() && Character.isWhitespace(this.expr.charAt(this.pos))) {
                ++this.pos;
            }
        }

        private String nextToken() throws EOEException {
            this.skipSpaces();
            if (this.pos >= this.expr.length()) {
                throw new EOEException();
            }
            this.buffer.append(this.expr.charAt(this.pos++));
            if (!PgSphereGeometryParser.isSyntaxSeparator(this.buffer.charAt(0))) {
                while (this.pos < this.expr.length() && !PgSphereGeometryParser.isSyntaxSeparator(this.expr.charAt(this.pos))) {
                    if (!Character.isWhitespace(this.expr.charAt(this.pos))) {
                        this.buffer.append(this.expr.charAt(this.pos));
                    }
                    ++this.pos;
                }
            }
            this.token = this.buffer.toString();
            this.buffer.delete(0, this.token.length());
            return this.token;
        }

        private static boolean isSyntaxSeparator(char c) {
            return c == ',' || c == 'd' || c == 'h' || c == 'm' || c == 's' || c == '(' || c == ')' || c == '<' || c == '>' || c == '{' || c == '}';
        }

        private void nextToken(char c) throws ParseException {
            this.skipSpaces();
            if (this.pos >= this.expr.length()) {
                throw new EOEException();
            }
            char c2 = this.expr.charAt(this.pos++);
            this.token = new String(new char[]{c2});
            if (c2 != c) {
                throw new ParseException("Incorrect syntax for \"" + this.expr + "\"! \"" + c + "\" was expected instead of \"" + c2 + "\".", new TextPosition(1, this.pos - 1, 1, this.pos));
            }
        }

        public STCS.Region parsePoint(String string) throws ParseException {
            this.init(string);
            double[] dArray = this.parsePoint();
            this.end();
            return new STCS.Region(null, dArray);
        }

        private double[] parsePoint() throws ParseException {
            this.nextToken('(');
            double d = this.parseAngle();
            this.nextToken(',');
            double d2 = this.parseAngle();
            this.nextToken(')');
            return new double[]{d, d2};
        }

        public STCS.Region parseCircle(String string) throws ParseException {
            this.init(string);
            this.nextToken('<');
            double[] dArray = this.parsePoint();
            this.nextToken(',');
            double d = this.parseAngle();
            this.nextToken('>');
            this.end();
            return new STCS.Region(null, dArray, d);
        }

        public STCS.Region parseBox(String string) throws ParseException {
            this.init(string);
            this.nextToken('(');
            double[] dArray = this.parsePoint();
            this.nextToken(',');
            double[] dArray2 = this.parsePoint();
            this.nextToken(')');
            this.end();
            double d = Math.abs(dArray2[0] - dArray[0]);
            double d2 = Math.abs(dArray2[1] - dArray[1]);
            double[] dArray3 = new double[]{dArray2[0] - d / 2.0, dArray2[1] - d2 / 2.0};
            return new STCS.Region(null, dArray3, d, d2);
        }

        public STCS.Region parsePolygon(String string) throws ParseException {
            this.init(string);
            this.nextToken('{');
            ArrayList<double[]> arrayList = new ArrayList<double[]>(3);
            arrayList.add(this.parsePoint());
            this.nextToken(',');
            arrayList.add(this.parsePoint());
            this.nextToken(',');
            arrayList.add(this.parsePoint());
            while (this.nextToken().length() == 1 && this.token.charAt(0) == ',') {
                arrayList.add(this.parsePoint());
            }
            if (this.token.length() != 1 || this.token.charAt(0) != '}') {
                throw new ParseException("Incorrect syntax for \"" + this.expr + "\"! \"}\" was expected instead of \"" + this.token + "\".", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
            }
            this.end();
            return new STCS.Region(null, (double[][])arrayList.toArray((T[])new double[arrayList.size()][2]));
        }

        private double parseAngle() throws ParseException {
            int n = this.pos;
            String string = this.nextToken();
            try {
                double d = Double.parseDouble(string);
                int n2 = d < 0.0 ? -1 : 1;
                d = Math.abs(d);
                n = this.pos;
                try {
                    if (this.nextToken().length() == 1 && this.token.charAt(0) == 'h') {
                        n2 *= 15;
                    } else if (this.token.length() != 1 || this.token.charAt(0) != 'd') {
                        d = d * 180.0 / Math.PI;
                        this.pos -= this.token.length();
                        return d * (double)n2;
                    }
                    n = this.pos;
                    string = this.nextToken();
                    if (this.nextToken().length() == 1 && this.token.charAt(0) == 'm') {
                        d += Double.parseDouble(string) / 60.0;
                    } else {
                        if (this.token.length() == 1 && this.token.charAt(0) == 's') {
                            return (d += Double.parseDouble(string) / 3600.0) * (double)n2;
                        }
                        this.pos = n;
                        return d * (double)n2;
                    }
                    n = this.pos;
                    string = this.nextToken();
                    if (this.nextToken().length() == 1 && this.token.charAt(0) == 's') {
                        d += Double.parseDouble(string) / 3600.0;
                    } else {
                        this.pos = n;
                    }
                }
                catch (EOEException eOEException) {
                    this.pos = n;
                }
                return d * (double)n2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Incorrect numeric syntax: \"" + string + "\"!", new TextPosition(1, this.pos - this.token.length(), 1, this.pos));
            }
        }

        private static class EOEException
        extends ParseException {
            private static final long serialVersionUID = 1L;

            public EOEException() {
                super("Unexpected End Of PgSphere Expression!");
            }
        }
    }
}

